/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.hebrew;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreeNormalizer;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreebankLanguagePack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class HebrewTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 818065349424602548L;

    public TreeReader newTreeReader(Reader in) {
        return new PennTreeReader(in, new LabeledScoredTreeFactory(), new HebrewTreeNormalizer(), new PennTreebankTokenizer(in));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.printf("Usage: java %s tree_file > trees%n", HebrewTreeReaderFactory.class.getName());
            System.exit(-1);
        }
        HebrewTreebankLanguagePack tlp = new HebrewTreebankLanguagePack();
        File treeFile = new File(args[0]);
        try {
            Tree t;
            HebrewTreeReaderFactory trf = new HebrewTreeReaderFactory();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFile), tlp.getEncoding()));
            TreeReader tr = trf.newTreeReader(br);
            int numTrees = 0;
            while ((t = tr.readTree()) != null) {
                System.out.println(t.toString());
                ++numTrees;
            }
            tr.close();
            System.err.printf("Processed %d trees.%n", numTrees);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

