/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static void addMethodNamesToMap(Map<String, JRubyMethod> map2, JRubyMethod jrubyMethod, String simpleName) {
        AnnotationHelper.addMethodNamesToMap(map2, jrubyMethod, simpleName, jrubyMethod.name(), jrubyMethod.alias());
    }

    public static void addMethodNamesToMap(Map<String, JRubyMethod> map2, JRubyMethod anno, String simpleName, String[] names2, String[] aliases2) {
        if (names2.length == 0) {
            map2.put(simpleName, anno);
        } else {
            for (String name2 : names2) {
                map2.put(name2, anno);
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                map2.put(alias, anno);
            }
        }
    }

    public static int getArityValue(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return -(actualRequired + 1);
        }
        return actualRequired;
    }

    public static String getCallerCallConfigNameByAnno(JRubyMethod jrubyMethod) {
        boolean frame = false;
        boolean scope = false;
        for (FrameField field : jrubyMethod.reads()) {
            frame |= field.needsFrame();
            scope |= field.needsScope();
        }
        for (FrameField field : jrubyMethod.writes()) {
            frame |= field.needsFrame();
            scope |= field.needsScope();
        }
        return AnnotationHelper.getCallConfigName(frame, scope);
    }

    public static String getCallConfigName(boolean frame, boolean scope) {
        if (frame) {
            return scope ? "FrameFullScopeFull" : "FrameFullScopeNone";
        }
        return scope ? "FrameNoneScopeFull" : "FrameNoneScopeNone";
    }

    public static void groupFrameFields(Map<Set<FrameField>, List<String>> readGroups, Map<Set<FrameField>, List<String>> writeGroups, JRubyMethod anno, String simpleName) {
        List<String> nameList;
        if (anno.reads().length > 0) {
            HashSet<FrameField> reads = new HashSet<FrameField>(Arrays.asList(anno.reads()));
            nameList = readGroups.get(reads);
            if (nameList == null) {
                nameList = new ArrayList<String>();
                readGroups.put(reads, nameList);
            }
            if (anno.name().length == 0) {
                nameList.add(simpleName);
            } else {
                nameList.addAll(Arrays.asList(anno.name()));
            }
        }
        if (anno.writes().length > 0) {
            HashSet<FrameField> writes = new HashSet<FrameField>(Arrays.asList(anno.writes()));
            nameList = writeGroups.get(writes);
            if (nameList == null) {
                nameList = new ArrayList<String>();
                writeGroups.put(writes, nameList);
            }
            if (anno.name().length == 0) {
                nameList.add(simpleName);
            } else {
                nameList.addAll(Arrays.asList(anno.name()));
            }
        }
    }

    public static void populateMethodIndex(Map<Set<FrameField>, List<String>> accessGroups, BiConsumer<Integer, String> action) {
        if (!accessGroups.isEmpty()) {
            accessGroups.forEach((reads, names2) -> {
                int bits = FrameField.pack((FrameField[])reads.stream().toArray(FrameField[]::new));
                StringJoiner joiner = new StringJoiner(";");
                HashSet<String> uniqueValues = new HashSet<String>();
                for (String name2 : names2) {
                    if (!uniqueValues.add(name2)) continue;
                    joiner.add(name2);
                    if (!name2.matches("^[a-z_]+$")) continue;
                    joiner.add(name2 + "!");
                }
                String namesJoined = joiner.toString();
                action.accept(bits, namesJoined);
            });
        }
    }

    public static void addSubclassNames(List<String> classAndSubs, JRubyClass classAnno) {
        for (int i2 = 0; i2 < classAnno.overrides().length; ++i2) {
            classAndSubs.add(classAnno.overrides()[i2].getCanonicalName());
        }
    }
}

