use strict;
use warnings;
package IPC::Lockfile;
$IPC::Lockfile::VERSION = '0.01';
# ABSTRACT: run only one instance of a program at a time using flock
use Fcntl qw(:flock);

flock DATA, LOCK_EX|LOCK_NB or die "$0 is running!\n";;


1;

=pod

=encoding UTF-8

=head1 NAME

IPC::Lockfile - run only one instance of a program at a time using flock

=head1 VERSION

version 0.01

=head1 SYNOPSIS

Just import the module:

    #!/usr/bin/env perl
    use IPC::Lockfile;

    ... # program code here

No external lockfile is created, C<IPC::Lockfile> uses C<_DATA_> (See L<#THANKS>).

=head1 DESCRIPTION

C<IPC::Lockfile> is a module for use with Perl programs when you only want one
instance of the script to run at a time. It uses C<flock> and should work if
run on an OS that supports C<flock> (e.g. Linux, BSD, OSX and Windows).

=head1 THANKS

This module implements an elegant L<solution|http://perl.plover.com/yak/flock/samples/slide006.html> to lockfiles proposed by Mark Jason Dominus.

=head1 SEE ALSO

L<IPC::Pidfile> for a PID-based solution that relies on signals and has a race
condition (not recommended).

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut

__DATA__