
package Apache::MP3::L10N::zh_tw;  # Traditional Chinese
use strict;
use Apache::MP3::L10N;
use vars qw($VERSION @ISA %Lexicon);
@ISA = qw(Apache::MP3::L10N);

# Translators, in no particular order:
#  autrijus@autrijus.org

sub encoding {'big5'}
sub language_tag {__PACKAGE__->SUPER::language_tag}

%Lexicon = (
 '_VERSION' => __PACKAGE__ . ' v' . 
 ($VERSION=   '20020612'), # Last modified

 # These are links as well as button text:
 'Play All' => "",
 'Shuffle All' => 'H',  # Stream all in random order
 'Stream All' => 'y',

 # This one in just button text
 'Play Selected' => 'd',
 
 "In this demo, streaming is limited to approximately [quant,_1,second,seconds]."
  => "bܽdҦU, ȯ༽ [quant,_1,,] y.",
 
 # Headings:
 'CD Directories ([_1])' => 'Хؿ ([_1])',
 'Playlists ([_1])' => 'زM ([_1])',        # .m3u files
 'Song List ([_1])' => 'qC ([_1])', # i.e., file list


 'Playlist' => '',
 'Select' => '',
	 
 'fetch'  => 'U',   # this file
 'stream' => 'y',    # this file
 
 'Shuffle'  => 'H',  # a subdirectory, recursively
 'Stream'   => 'y',            # a subdirectory, recursively
 
 # Label for a link to "http://[servername]/"
 'Home' => '',

 # Credits
 "_CREDITS_before_author" => "Apache::MP3 @̬O ",
 "_CREDITS_author"        => "Lincoln D. Stein", 
 "_CREDITS_after_author"  => ".",


 'unknown' => 'RW',

 # Metadata fields:
 'Artist' => "@",
 'Comment' => "",
 'Duration' => "",
 'Filename' => "ɮ",
 'Genre' => "",
 'Album' => "M",
 'Min' => "",
 'Track' => "y",  # just the track number (not the track name)
 'Samplerate' => "Wv",
 'Bitrate' => "ǿWv",
 'Sec' => "",
 'Seconds' => "",
 'Title' => "D",
 'Year' => "~",


 # Now the stuff for the help page:

 'Quick Help Summary' => "U@",
  # page title as well as the text we use for linking to that page

 "= Stream all songs" => "= NҦqHy覡",
 "= Shuffle-play all Songs" => "= HҦq",
 "= Go to earlier directory" => "= ^eؿ",
 "= Stream contents" => "= N䤺eHy覡",
 "= Enter directory" => "= iJؿ",
 "= Stream this song" => "= NثeqHy覡",
 "= Select for streaming" => "= iyq",
 "= Download this song" => "= Uoq",
 "= Stream this song" => "= NثeqHy覡",
 "= Sort by field" => "= HYƧ",

);

1;

