# Generated by default/object.tt
package Paws::QLDBSession::TimingInformation;
  use Moose;
  has ProcessingTimeMilliseconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::QLDBSession::TimingInformation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::QLDBSession::TimingInformation object:

  $service_obj->Method(Att1 => { ProcessingTimeMilliseconds => $value, ..., ProcessingTimeMilliseconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::QLDBSession::TimingInformation object:

  $result = $service_obj->Method(...);
  $result->Att1->ProcessingTimeMilliseconds

=head1 DESCRIPTION

Contains server-side performance information for a command. Amazon QLDB
captures timing information between the times when it receives the
request and when it sends the corresponding response.

=head1 ATTRIBUTES


=head2 ProcessingTimeMilliseconds => Int

The amount of time that QLDB spent on processing the command, measured
in milliseconds.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::QLDBSession>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

