######################################################################
#
# 5156_jef9p_by_utf8jp_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x84\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],
        ["\xA1\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],

        ["\xF3\xB0\x84\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\xA1\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],

        ["\xF3\xB0\x84\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\xA1\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],

        ["\xF3\xB0\x84\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\xA1\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],

        ["\xF3\xB0\x84\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\xA1\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],

        ["\xF3\xB0\x84\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\xA1\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],

        ["\xF3\xB0\x84\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\xA1\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],

        ["\xF3\xB0\x84\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\xA1\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],

        ["\xF3\xB0\x84\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\xA1\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],

        ["\xF3\xB0\x84\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\xA1\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],

        ["\xF3\xB0\x84\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\xA1\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],

        ["\xF3\xB0\x84\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\xA1\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],

        ["\xF3\xB0\x84\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\xA1\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],

        ["\xF3\xB0\x84\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\xA1\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],

        ["\xF3\xB0\x84\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\xA1\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],

        ["\xF3\xB0\x84\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\xA1\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],

        ["\xF3\xB0\x84\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\xA1\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],

        ["\xF3\xB0\x84\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\xA1\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],

        ["\xF3\xB0\x84\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\xA1\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],

        ["\xF3\xB0\x84\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\xA1\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],

        ["\xF3\xB0\x84\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\xA1\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],

        ["\xF3\xB0\x84\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\xA1\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],

        ["\xF3\xB0\x84\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\xA1\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],

        ["\xF3\xB0\x84\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\xA1\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],

        ["\xF3\xB0\x84\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\xA1\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],

        ["\xF3\xB0\x84\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\xA1\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],

        ["\xF3\xB0\x84\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\xA1\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],

        ["\xF3\xB0\x84\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\xA1\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],

        ["\xF3\xB0\x84\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\xA1\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],

        ["\xF3\xB0\x84\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\xA1\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],

        ["\xF3\xB0\x84\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\xA1\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],

        ["\xF3\xB0\x84\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],
        ["\xA1\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],

        ["\xF3\xB0\x84\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\xA1\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],

        ["\xF3\xB0\x84\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],
        ["\xA1\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],

        ["\xF3\xB0\x84\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\xA1\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],

        ["\xF3\xB0\x84\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\xA1\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],

        ["\xF3\xB0\x84\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\xA1\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],

        ["\xF3\xB0\x84\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\xA1\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],

        ["\xF3\xB0\x84\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\xA1\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],

        ["\xF3\xB0\x84\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\xA1\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],

        ["\xF3\xB0\x84\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\xA1\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],

        ["\xF3\xB0\x84\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\xA1\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],

        ["\xF3\xB0\x84\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\xA1\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],

        ["\xF3\xB0\x84\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\xA1\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],

        ["\xF3\xB0\x84\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\xA1\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],

        ["\xF3\xB0\x84\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\xA1\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],

        ["\xF3\xB0\x84\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\xA1\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],

        ["\xF3\xB0\x84\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\xA1\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],

        ["\xF3\xB0\x84\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\xA1\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],

        ["\xF3\xB0\x84\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\xA1\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],

        ["\xF3\xB0\x84\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\xA1\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],

        ["\xF3\xB0\x84\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\xA1\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],

        ["\xF3\xB0\x84\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\xA1\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],

        ["\xF3\xB0\x84\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\xA1\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],

        ["\xF3\xB0\x84\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\xA1\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],

        ["\xF3\xB0\x84\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\xA1\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],

        ["\xF3\xB0\x84\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\xA1\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],

        ["\xF3\xB0\x84\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\xA1\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],

        ["\xF3\xB0\x84\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\xA1\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],

        ["\xF3\xB0\x84\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\xA1\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],

        ["\xF3\xB0\x84\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],
        ["\xA1\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],

        ["\xF3\xB0\x84\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\xA1\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],

        ["\xF3\xB0\x84\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\xA1\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],

        ["\xF3\xB0\x84\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\xA1\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],

        ["\xF3\xB0\x85\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\xA1\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],

        ["\xF3\xB0\x85\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\xA1\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],

        ["\xF3\xB0\x85\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\xA1\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],

        ["\xF3\xB0\x85\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\xA1\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],

        ["\xF3\xB0\x85\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\xA1\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],

        ["\xF3\xB0\x85\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\xA1\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],

        ["\xF3\xB0\x85\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\xA1\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],

        ["\xF3\xB0\x85\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xA1\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],

        ["\xF3\xB0\x85\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xA1\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],

        ["\xF3\xB0\x85\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xA1\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],

        ["\xF3\xB0\x85\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xA1\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],

        ["\xF3\xB0\x85\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xA1\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],

        ["\xF3\xB0\x85\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xA1\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],

        ["\xF3\xB0\x85\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xA1\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],

        ["\xF3\xB0\x85\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xA1\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],

        ["\xF3\xB0\x85\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xA1\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],

        ["\xF3\xB0\x85\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\xA1\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],

        ["\xF3\xB0\x85\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\xA1\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],

        ["\xF3\xB0\x85\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xA1\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],

        ["\xF3\xB0\x85\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xA1\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],

        ["\xF3\xB0\x85\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xA1\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],

        ["\xF3\xB0\x85\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xA1\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],

        ["\xF3\xB0\x85\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xA1\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],

        ["\xF3\xB0\x85\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xA1\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],

        ["\xF3\xB0\x85\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xA1\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],

        ["\xF3\xB0\x85\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xA1\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],

        ["\xF3\xB0\x85\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\xA1\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],

        ["\xF3\xB0\x85\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\xA1\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],

        ["\xF3\xB0\x85\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xA1\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],

        ["\xF3\xB0\x85\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xA1\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],

        ["\xF3\xB0\x85\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xA2\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],

        ["\xF3\xB0\x85\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xA2\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],

        ["\xF3\xB0\x85\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xA2\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],

        ["\xF3\xB0\x85\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xA2\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],

        ["\xF3\xB0\x85\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xA2\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],

        ["\xF3\xB0\x85\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xA2\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],

        ["\xF3\xB0\x85\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xA2\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],

        ["\xF3\xB0\x85\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xA2\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],

        ["\xF3\xB0\x85\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xA2\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],

        ["\xF3\xB0\x85\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xA2\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],

        ["\xF3\xB0\x85\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\xA2\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],

        ["\xF3\xB0\x85\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xA2\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],

        ["\xF3\xB0\x85\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\xA2\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],

        ["\xF3\xB0\x85\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA2\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],

        ["\xF3\xB0\x85\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD0"],
        ["\x7F\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],

        ["\xF3\xB0\x85\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD1"],
        ["\x7F\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],

        ["\xF3\xB0\x85\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD2"],
        ["\x7F\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],

        ["\xF3\xB0\x85\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD3"],
        ["\x7F\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],

        ["\xF3\xB0\x85\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD4"],
        ["\x7F\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],

        ["\xF3\xB0\x85\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD5"],
        ["\x7F\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],

        ["\xF3\xB0\x85\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD6"],
        ["\x7F\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],

        ["\xF3\xB0\x85\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD7"],
        ["\x7F\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],

        ["\xF3\xB0\x86\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD8"],
        ["\x7F\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],

        ["\xF3\xB0\x86\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xD9"],
        ["\x7F\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],

        ["\xF3\xB0\x86\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA7"],
        ["\x76\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],

        ["\xF3\xB0\x86\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDA"],
        ["\x7F\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],

        ["\xF3\xB0\x86\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDB"],
        ["\x7F\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],

        ["\xF3\xB0\x86\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDC"],
        ["\x7F\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],

        ["\xF3\xB0\x86\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDD"],
        ["\x7F\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],

        ["\xF3\xB0\x86\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDE"],
        ["\x7F\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],

        ["\xF3\xB0\x86\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xDF"],
        ["\x7F\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],

        ["\xF3\xB0\x86\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],
        ["\x7F\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],

        ["\xF3\xB0\x86\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE1"],
        ["\x7F\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],

        ["\xF3\xB0\x86\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE2"],
        ["\x7F\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],

        ["\xF3\xB0\x86\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xAA"],
        ["\x76\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],

        ["\xF3\xB0\x86\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA9"],
        ["\x76\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],

        ["\xF3\xB0\x86\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE3"],
        ["\x7F\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],

        ["\xF3\xB0\x86\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE4"],
        ["\x7F\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],

        ["\xF3\xB0\x86\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE5"],
        ["\x7F\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],

        ["\xF3\xB0\x86\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE6"],
        ["\x7F\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],

        ["\xF3\xB0\x86\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE7"],
        ["\x7F\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],

        ["\xF3\xB0\x86\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA8"],
        ["\x76\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],

        ["\xF3\xB0\x86\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE8"],
        ["\x7F\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],

        ["\xF3\xB0\x86\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE9"],
        ["\x7F\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],

        ["\xF3\xB0\x86\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],
        ["\x76\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],

        ["\xF3\xB0\x86\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],
        ["\x76\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],

        ["\xF3\xB0\x86\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEA"],
        ["\x7F\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],

        ["\xF3\xB0\x86\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEB"],
        ["\x7F\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],

        ["\xF3\xB0\x86\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEC"],
        ["\x7F\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],

        ["\xF3\xB0\x86\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xED"],
        ["\x7F\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],

        ["\xF3\xB0\x86\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEE"],
        ["\x7F\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],

        ["\xF3\xB0\x86\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xEF"],
        ["\x7F\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],

        ["\xF3\xB0\x86\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xF0"],
        ["\x7F\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],

        ["\xF3\xB0\x87\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\xA3\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],

        ["\xF3\xB0\x87\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\xA3\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],

        ["\xF3\xB0\x87\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\xA3\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],

        ["\xF3\xB0\x87\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\xA3\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],

        ["\xF3\xB0\x87\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xA3\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],

        ["\xF3\xB0\x87\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xA3\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],

        ["\xF3\xB0\x87\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xA3\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],

        ["\xF3\xB0\x87\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\xA3\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],

        ["\xF3\xB0\x87\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\xA3\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],

        ["\xF3\xB0\x87\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\xA3\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],

        ["\xF3\xB0\x87\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\xA3\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],

        ["\xF3\xB0\x87\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\xA3\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],

        ["\xF3\xB0\x87\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\xA3\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],

        ["\xF3\xB0\x87\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\xA3\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],

        ["\xF3\xB0\x87\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\xA3\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],

        ["\xF3\xB0\x87\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\xA3\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],

        ["\xF3\xB0\x87\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\xA3\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],

        ["\xF3\xB0\x87\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\xA3\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],

        ["\xF3\xB0\x87\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\xA3\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],

        ["\xF3\xB0\x87\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\xA3\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],

        ["\xF3\xB0\x87\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\xA3\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],

        ["\xF3\xB0\x87\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xA3\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],

        ["\xF3\xB0\x87\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xA3\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],

        ["\xF3\xB0\x87\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xA3\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],

        ["\xF3\xB0\x87\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xA3\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],

        ["\xF3\xB0\x87\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\xA3\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],

        ["\xF3\xB0\x87\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\xA3\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],

        ["\xF3\xB0\x87\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\xA3\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],

        ["\xF3\xB0\x87\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\xA3\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],

        ["\xF3\xB0\x87\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\xA3\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],

        ["\xF3\xB0\x87\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\xA3\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],

        ["\xF3\xB0\x87\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\xA3\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],

        ["\xF3\xB0\x87\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\xA3\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],

        ["\xF3\xB0\x87\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\xA3\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],

        ["\xF3\xB0\x87\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\xA3\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],

        ["\xF3\xB0\x87\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\xA3\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],

        ["\xF3\xB0\x87\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xA3\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],

        ["\xF3\xB0\x87\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xA3\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],

        ["\xF3\xB0\x87\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xA3\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],

        ["\xF3\xB0\x87\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xA3\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],

        ["\xF3\xB0\x88\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\xA3\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],

        ["\xF3\xB0\x88\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\xA3\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],

        ["\xF3\xB0\x88\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\xA3\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],

        ["\xF3\xB0\x88\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\xA3\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],

        ["\xF3\xB0\x88\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\xA3\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],

        ["\xF3\xB0\x88\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\xA3\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],

        ["\xF3\xB0\x88\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xA3\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],

        ["\xF3\xB0\x88\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xA3\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],

        ["\xF3\xB0\x88\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xA3\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],

        ["\xF3\xB0\x88\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xA3\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],

        ["\xF3\xB0\x88\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xA3\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],

        ["\xF3\xB0\x88\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xA3\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],

        ["\xF3\xB0\x88\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xA3\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],

        ["\xF3\xB0\x88\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xA3\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],

        ["\xF3\xB0\x88\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xA3\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],

        ["\xF3\xB0\x88\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xA3\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],

        ["\xF3\xB0\x88\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xA3\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],

        ["\xF3\xB0\x88\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xA3\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],

        ["\xF3\xB0\x88\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xA3\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],

        ["\xF3\xB0\x88\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xA3\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],

        ["\xF3\xB0\x88\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xA3\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],

        ["\xF3\xB0\x88\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xA3\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],

        ["\xF3\xB0\x88\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xA4\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],

        ["\xF3\xB0\x88\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xA4\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],

        ["\xF3\xB0\x88\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xA4\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],

        ["\xF3\xB0\x88\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xA4\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],

        ["\xF3\xB0\x88\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xA4\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],

        ["\xF3\xB0\x88\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xA4\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],

        ["\xF3\xB0\x88\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xA4\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],

        ["\xF3\xB0\x88\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xA4\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],

        ["\xF3\xB0\x88\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xA4\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],

        ["\xF3\xB0\x88\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xA4\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],

        ["\xF3\xB0\x88\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xA4\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],

        ["\xF3\xB0\x88\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xA4\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],

        ["\xF3\xB0\x88\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xA4\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],

        ["\xF3\xB0\x88\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xA4\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],

        ["\xF3\xB0\x88\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xA4\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],

        ["\xF3\xB0\x88\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xA4\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],

        ["\xF3\xB0\x88\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xA4\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],

        ["\xF3\xB0\x88\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xA4\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],

        ["\xF3\xB0\x88\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xA4\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],

        ["\xF3\xB0\x88\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xA4\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],

        ["\xF3\xB0\x88\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xA4\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],

        ["\xF3\xB0\x88\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xA4\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],

        ["\xF3\xB0\x88\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xA4\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],

        ["\xF3\xB0\x88\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xA4\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],

        ["\xF3\xB0\x88\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xA4\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],

        ["\xF3\xB0\x88\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xA4\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],

        ["\xF3\xB0\x88\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xA4\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],

        ["\xF3\xB0\x88\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xA4\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],

        ["\xF3\xB0\x88\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xA4\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],

        ["\xF3\xB0\x88\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xA4\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],

        ["\xF3\xB0\x88\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xA4\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],

        ["\xF3\xB0\x88\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xA4\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],

        ["\xF3\xB0\x88\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xA4\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],

        ["\xF3\xB0\x88\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xA4\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],

        ["\xF3\xB0\x88\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xA4\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],

        ["\xF3\xB0\x88\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xA4\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],

        ["\xF3\xB0\x88\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xA4\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],

        ["\xF3\xB0\x88\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xA4\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],

        ["\xF3\xB0\x89\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xA4\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],

        ["\xF3\xB0\x89\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xA4\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],

        ["\xF3\xB0\x89\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xA4\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],

        ["\xF3\xB0\x89\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xA4\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],

        ["\xF3\xB0\x89\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xA4\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],

        ["\xF3\xB0\x89\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xA4\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],

        ["\xF3\xB0\x89\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xA4\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],

        ["\xF3\xB0\x89\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xA4\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],

        ["\xF3\xB0\x89\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xA4\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],

        ["\xF3\xB0\x89\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xA4\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],

        ["\xF3\xB0\x89\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xA4\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],

        ["\xF3\xB0\x89\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xA4\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],

        ["\xF3\xB0\x89\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xA4\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],

        ["\xF3\xB0\x89\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xA4\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],

        ["\xF3\xB0\x89\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xA4\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],

        ["\xF3\xB0\x89\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xA4\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],

        ["\xF3\xB0\x89\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xA4\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],

        ["\xF3\xB0\x89\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xA4\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],

        ["\xF3\xB0\x89\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xA4\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],

        ["\xF3\xB0\x89\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xA4\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],

        ["\xF3\xB0\x89\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xA4\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],

        ["\xF3\xB0\x89\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xA4\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],

        ["\xF3\xB0\x89\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xA4\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],

        ["\xF3\xB0\x89\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xA4\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],

        ["\xF3\xB0\x89\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xA4\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],

        ["\xF3\xB0\x89\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xA4\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],

        ["\xF3\xB0\x89\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xA4\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],

        ["\xF3\xB0\x89\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xA4\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],

        ["\xF3\xB0\x89\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xA4\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],

        ["\xF3\xB0\x89\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xA4\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],

        ["\xF3\xB0\x89\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xA4\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],

        ["\xF3\xB0\x89\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xA4\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],

        ["\xF3\xB0\x89\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xA4\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],

        ["\xF3\xB0\x89\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xA4\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],

        ["\xF3\xB0\x89\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xA4\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],

        ["\xF3\xB0\x89\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xA4\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],

        ["\xF3\xB0\x89\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xA4\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],

        ["\xF3\xB0\x89\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xA4\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],

        ["\xF3\xB0\x89\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xA4\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],

        ["\xF3\xB0\x89\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xA4\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],

        ["\xF3\xB0\x89\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xA4\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],

        ["\xF3\xB0\x89\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xA4\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],

        ["\xF3\xB0\x89\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xA4\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],

        ["\xF3\xB0\x89\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xA4\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],

        ["\xF3\xB0\x89\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\xA4\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],

        ["\xF3\xB0\x89\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xA5\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],

        ["\xF3\xB0\x89\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xA5\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],

        ["\xF3\xB0\x89\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\xA5\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],

        ["\xF3\xB0\x89\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xA5\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],

        ["\xF3\xB0\x89\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xA5\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],

        ["\xF3\xB0\x89\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xA5\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],

        ["\xF3\xB0\x89\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xA5\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],

        ["\xF3\xB0\x89\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xA5\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],

        ["\xF3\xB0\x8A\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xA5\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],

        ["\xF3\xB0\x8A\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xA5\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],

        ["\xF3\xB0\x8A\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xA5\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],

        ["\xF3\xB0\x8A\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xA5\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],

        ["\xF3\xB0\x8A\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xA5\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],

        ["\xF3\xB0\x8A\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xA5\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],

        ["\xF3\xB0\x8A\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xA5\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],

        ["\xF3\xB0\x8A\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xA5\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],

        ["\xF3\xB0\x8A\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xA5\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],

        ["\xF3\xB0\x8A\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xA5\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],

        ["\xF3\xB0\x8A\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xA5\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],

        ["\xF3\xB0\x8A\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xA5\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],

        ["\xF3\xB0\x8A\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xA5\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],

        ["\xF3\xB0\x8A\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xA5\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],

        ["\xF3\xB0\x8A\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xA5\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],

        ["\xF3\xB0\x8A\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xA5\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],

        ["\xF3\xB0\x8A\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xA5\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],

        ["\xF3\xB0\x8A\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xA5\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],

        ["\xF3\xB0\x8A\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xA5\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],

        ["\xF3\xB0\x8A\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xA5\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],

        ["\xF3\xB0\x8A\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xA5\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],

        ["\xF3\xB0\x8A\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xA5\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],

        ["\xF3\xB0\x8A\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xA5\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],

        ["\xF3\xB0\x8A\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xA5\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],

        ["\xF3\xB0\x8A\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xA5\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],

        ["\xF3\xB0\x8A\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xA5\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],

        ["\xF3\xB0\x8A\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\xA5\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],

        ["\xF3\xB0\x8A\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xA5\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],

        ["\xF3\xB0\x8A\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xA5\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],

        ["\xF3\xB0\x8A\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xA5\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],

        ["\xF3\xB0\x8A\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xA5\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],

        ["\xF3\xB0\x8A\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xA5\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],

        ["\xF3\xB0\x8A\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\xA5\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],

        ["\xF3\xB0\x8A\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xA5\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],

        ["\xF3\xB0\x8A\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xA5\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],

        ["\xF3\xB0\x8A\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xA5\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],

        ["\xF3\xB0\x8A\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\xA5\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],

        ["\xF3\xB0\x8A\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xA5\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],

        ["\xF3\xB0\x8A\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xA5\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],

        ["\xF3\xB0\x8A\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xA5\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],

        ["\xF3\xB0\x8A\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xA5\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],

        ["\xF3\xB0\x8A\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xA5\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],

        ["\xF3\xB0\x8A\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xA5\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],

        ["\xF3\xB0\x8A\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xA5\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],

        ["\xF3\xB0\x8A\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xA5\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],

        ["\xF3\xB0\x8A\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xA5\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],

        ["\xF3\xB0\x8A\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xA5\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],

        ["\xF3\xB0\x8A\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\xA5\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],

        ["\xF3\xB0\x8A\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\xA5\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],

        ["\xF3\xB0\x8A\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\xA5\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],

        ["\xF3\xB0\x8A\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xA5\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],

        ["\xF3\xB0\x8A\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xA5\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],

        ["\xF3\xB0\x8A\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xA5\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],

        ["\xF3\xB0\x8A\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xA5\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],

        ["\xF3\xB0\x8A\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xA5\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],

        ["\xF3\xB0\x8A\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xA5\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],

        ["\xF3\xB0\x8A\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xA5\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],

        ["\xF3\xB0\x8A\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xA5\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],

        ["\xF3\xB0\x8A\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xA5\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],

        ["\xF3\xB0\x8A\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xA5\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],

        ["\xF3\xB0\x8A\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\xA5\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],

        ["\xF3\xB0\x8A\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\xA5\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],

        ["\xF3\xB0\x8A\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xA5\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],

        ["\xF3\xB0\x8A\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xA5\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],

        ["\xF3\xB0\x8B\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xA5\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],

        ["\xF3\xB0\x8B\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xA5\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],

        ["\xF3\xB0\x8B\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xA5\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],

        ["\xF3\xB0\x8B\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\xA5\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],

        ["\xF3\xB0\x8B\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\xA5\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],

        ["\xF3\xB0\x8B\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xA5\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],

        ["\xF3\xB0\x8B\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xA5\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],

        ["\xF3\xB0\x8B\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xA5\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],

        ["\xF3\xB0\x8B\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\xA5\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],

        ["\xF3\xB0\x8B\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xA5\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],

        ["\xF3\xB0\x8B\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xA5\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],

        ["\xF3\xB0\x8B\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xA5\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],

        ["\xF3\xB0\x8B\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xA5\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],

        ["\xF3\xB0\x8B\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\xA5\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],

        ["\xF3\xB0\x8B\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\xA6\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],

        ["\xF3\xB0\x8B\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\xA6\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],

        ["\xF3\xB0\x8B\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\xA6\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],

        ["\xF3\xB0\x8B\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\xA6\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],

        ["\xF3\xB0\x8B\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\xA6\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],

        ["\xF3\xB0\x8B\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xA6\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],

        ["\xF3\xB0\x8B\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xA6\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],

        ["\xF3\xB0\x8B\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xA6\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],

        ["\xF3\xB0\x8B\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xA6\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],

        ["\xF3\xB0\x8B\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xA6\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],

        ["\xF3\xB0\x8B\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\xA6\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],

        ["\xF3\xB0\x8B\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xA6\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],

        ["\xF3\xB0\x8B\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\xA6\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],

        ["\xF3\xB0\x8B\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\xA6\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],

        ["\xF3\xB0\x8B\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xA6\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],

        ["\xF3\xB0\x8B\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\xA6\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],

        ["\xF3\xB0\x8B\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\xA6\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],

        ["\xF3\xB0\x8B\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\xA6\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],

        ["\xF3\xB0\x8B\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\xA6\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],

        ["\xF3\xB0\x8B\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xA6\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],

        ["\xF3\xB0\x8B\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\xA6\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],

        ["\xF3\xB0\x8B\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xA6\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],

        ["\xF3\xB0\x8B\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\xA6\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],

        ["\xF3\xB0\x8B\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xA6\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],

        ["\xF3\xB0\x8B\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\xA6\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],

        ["\xF3\xB0\x8B\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\xA6\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],

        ["\xF3\xB0\x8B\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\xA6\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],

        ["\xF3\xB0\x8B\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\xA6\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],

        ["\xF3\xB0\x8B\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\xA6\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],

        ["\xF3\xB0\x8B\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\xA6\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],

        ["\xF3\xB0\x8B\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\xA6\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],

        ["\xF3\xB0\x8B\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\xA6\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],

        ["\xF3\xB0\x8B\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\xA6\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],

        ["\xF3\xB0\x8B\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\xA6\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],

        ["\xF3\xB0\x8C\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\xA6\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],

        ["\xF3\xB0\x8C\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\xA6\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],

        ["\xF3\xB0\x8C\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xA6\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],

        ["\xF3\xB0\x8C\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\xA6\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],

        ["\xF3\xB0\x8C\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xA6\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],

        ["\xF3\xB0\x8C\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\xA6\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],

        ["\xF3\xB0\x8C\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\xA6\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],

        ["\xF3\xB0\x8C\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\xA6\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],

        ["\xF3\xB0\x8C\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\xA6\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],

        ["\xF3\xB0\x8C\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\xA6\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],

        ["\xF3\xB0\x8C\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\xA6\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],

        ["\xF3\xB0\x8C\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\xA6\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],

        ["\xF3\xB0\x8C\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\xA6\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],

        ["\xF3\xB0\x8C\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\xA6\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],

        ["\xF3\xB0\x8C\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\xA7\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],

        ["\xF3\xB0\x8C\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\xA7\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],

        ["\xF3\xB0\x8C\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\xA7\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],

        ["\xF3\xB0\x8C\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\xA7\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],

        ["\xF3\xB0\x8C\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\xA7\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],

        ["\xF3\xB0\x8C\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xA7\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],

        ["\xF3\xB0\x8C\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\xA7\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],

        ["\xF3\xB0\x8C\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xA7\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],

        ["\xF3\xB0\x8C\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\xA7\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],

        ["\xF3\xB0\x8C\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\xA7\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],

        ["\xF3\xB0\x8C\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\xA7\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],

        ["\xF3\xB0\x8C\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\xA7\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],

        ["\xF3\xB0\x8D\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\xA7\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],

        ["\xF3\xB0\x8D\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xA7\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],

        ["\xF3\xB0\x8D\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\xA7\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],

        ["\xF3\xB0\x8D\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\xA7\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],

        ["\xF3\xB0\x8D\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\xA7\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],

        ["\xF3\xB0\x8D\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\xA7\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],

        ["\xF3\xB0\x8D\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\xA7\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],

        ["\xF3\xB0\x8D\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\xA7\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],

        ["\xF3\xB0\x8D\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\xA7\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],

        ["\xF3\xB0\x8D\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\xA7\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],

        ["\xF3\xB0\x8D\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\xA7\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],

        ["\xF3\xB0\x8D\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\xA7\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],

        ["\xF3\xB0\x8D\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xA7\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],

        ["\xF3\xB0\x8D\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xA7\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],

        ["\xF3\xB0\x8D\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\xA7\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],

        ["\xF3\xB0\x8D\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\xA7\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],

        ["\xF3\xB0\x8D\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\xA7\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],

        ["\xF3\xB0\x8D\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\xA7\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],

        ["\xF3\xB0\x8D\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xA7\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],

        ["\xF3\xB0\x8D\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\xA7\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],

        ["\xF3\xB0\x8D\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\xA7\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],

        ["\xF3\xB0\x8D\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\xA7\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],

        ["\xF3\xB0\x8D\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\xA7\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],

        ["\xF3\xB0\x8D\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\xA7\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],

        ["\xF3\xB0\x8D\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\xA7\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],

        ["\xF3\xB0\x8D\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\xA7\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],

        ["\xF3\xB0\x8D\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\xA7\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],

        ["\xF3\xB0\x8D\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\xA7\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],

        ["\xF3\xB0\x8D\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\xA7\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],

        ["\xF3\xB0\x8D\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\xA7\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],

        ["\xF3\xB0\x8D\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xA7\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],

        ["\xF3\xB0\x8D\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\xA7\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],

        ["\xF3\xB0\x8D\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\xA7\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],

        ["\xF3\xB0\x8D\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\xA7\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],

        ["\xF3\xB0\x8D\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xA7\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],

        ["\xF3\xB0\x8D\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xA7\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],

        ["\xF3\xB0\x8D\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\xA7\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],

        ["\xF3\xB0\x8D\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\xA7\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],

        ["\xF3\xB0\x8D\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\xA7\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],

        ["\xF3\xB0\x8D\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\xA7\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],

        ["\xF3\xB0\x8D\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\xA7\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],

        ["\xF3\xB0\x8D\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\xA7\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],

        ["\xF3\xB0\x8D\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\xA7\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],

        ["\xF3\xB0\x8D\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\xA7\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],

        ["\xF3\xB0\x8D\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\xA7\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],

        ["\xF3\xB0\x8D\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\xA7\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],

        ["\xF3\xB0\x8D\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xA7\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],

        ["\xF3\xB0\x8D\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\xA7\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],

        ["\xF3\xB0\x8D\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\xA7\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],

        ["\xF3\xB0\x8E\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xA7\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],

        ["\xF3\xB0\x8E\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xA7\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],

        ["\xF3\xB0\x8E\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\xA7\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],

        ["\xF3\xB0\x8E\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\xA7\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],

        ["\xF3\xB0\x8E\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\xA7\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],

        ["\xF3\xB0\x8E\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],
        ["\x7C\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],

        ["\xF3\xB0\x8E\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],
        ["\x7C\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],

        ["\xF3\xB0\x8E\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],
        ["\x7C\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],

        ["\xF3\xB0\x8E\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],
        ["\x7C\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],

        ["\xF3\xB0\x8E\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],
        ["\x7C\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],

        ["\xF3\xB0\x8E\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],
        ["\x7C\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],

        ["\xF3\xB0\x8E\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],
        ["\x7C\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],

        ["\xF3\xB0\x8E\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],
        ["\x7C\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],

        ["\xF3\xB0\x8E\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],
        ["\x7C\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],

        ["\xF3\xB0\x8E\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],
        ["\x7C\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],

        ["\xF3\xB0\x8E\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],
        ["\x7C\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],

        ["\xF3\xB0\x8E\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],
        ["\x7C\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],

        ["\xF3\xB0\x8E\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],
        ["\x7C\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],

        ["\xF3\xB0\x8E\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],
        ["\x7C\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],

        ["\xF3\xB0\x8E\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],
        ["\x7C\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],

        ["\xF3\xB0\x8E\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],
        ["\x7C\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],

        ["\xF3\xB0\x8E\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],
        ["\x7C\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],

        ["\xF3\xB0\x8E\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],
        ["\x7C\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],

        ["\xF3\xB0\x8E\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],
        ["\x7C\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],

        ["\xF3\xB0\x8E\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],
        ["\x7C\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],

        ["\xF3\xB0\x8E\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],
        ["\x7C\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],

        ["\xF3\xB0\x8E\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],
        ["\x7C\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],

        ["\xF3\xB0\x8E\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCA"],
        ["\x7C\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],

        ["\xF3\xB0\x8E\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCB"],
        ["\x7C\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],

        ["\xF3\xB0\x8E\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCC"],
        ["\x7C\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],

        ["\xF3\xB0\x8E\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],
        ["\x7C\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],

        ["\xF3\xB0\x8E\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCE"],
        ["\x7C\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],

        ["\xF3\xB0\x8E\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA2"],
        ["\x7F\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],

        ["\xF3\xB0\x8E\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA3"],
        ["\x7F\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],

        ["\xF3\xB0\x8E\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA4"],
        ["\x7F\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],

        ["\xF3\xB0\x8E\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xA1"],
        ["\x7F\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],

        ["\xF3\xB0\x8E\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xCD"],
        ["\x7C\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],

        ["\xF3\xB0\x95\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],
        ["\x77\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],

        ["\xF3\xB0\x95\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCA"],
        ["\x77\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],

        ["\xF3\xB0\x95\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCB"],
        ["\x77\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],

        ["\xF3\xB0\x95\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCC"],
        ["\x77\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],

        ["\xF3\xB0\x95\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCD"],
        ["\x77\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],

        ["\xF3\xB0\x95\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCE"],
        ["\x77\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],

        ["\xF3\xB0\x95\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xCF"],
        ["\x77\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],

        ["\xF3\xB0\x95\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],
        ["\x77\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],

        ["\xF3\xB0\x95\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],
        ["\x77\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],

        ["\xF3\xB0\x95\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],
        ["\x77\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],

        ["\xF3\xB0\x95\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],
        ["\x77\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],

        ["\xF3\xB0\x95\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],
        ["\x77\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],

        ["\xF3\xB0\x95\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],
        ["\x77\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],

        ["\xF3\xB0\x95\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],
        ["\x77\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],

        ["\xF3\xB0\x95\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],
        ["\x77\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],

        ["\xF3\xB0\x95\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],
        ["\x77\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],

        ["\xF3\xB0\x95\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],
        ["\x77\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],

        ["\xF3\xB0\x95\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDA"],
        ["\x77\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],

        ["\xF3\xB0\x95\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDB"],
        ["\x77\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],

        ["\xF3\xB0\x95\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDC"],
        ["\x77\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],

        ["\xF3\xB0\x95\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDE"],
        ["\x77\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],

        ["\xF3\xB0\x95\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xDF"],
        ["\x77\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],

        ["\xF3\xB0\x95\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],
        ["\x77\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],

        ["\xF3\xB0\x95\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE1"],
        ["\x77\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],

        ["\xF3\xB0\x96\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],
        ["\x77\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],

        ["\xF3\xB0\x96\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],
        ["\x77\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],

        ["\xF3\xB0\x96\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],
        ["\x77\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],

        ["\xF3\xB0\x96\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],
        ["\x77\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],

        ["\xF3\xB0\x96\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],
        ["\x77\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],

        ["\xF3\xB0\x96\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],
        ["\x77\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],

        ["\xF3\xB0\x96\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDA"],
        ["\x76\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],

        ["\xF3\xB0\x96\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDC"],
        ["\x76\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],

        ["\xF3\xB0\x96\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDB"],
        ["\x76\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],

        ["\xF3\xB0\x96\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],
        ["\x76\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],

        ["\xF3\xB0\x96\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xDE"],
        ["\x76\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],

        ["\xF3\xB0\x96\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],
        ["\x76\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],

        ["\xF3\xB0\x96\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],
        ["\x76\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],

        ["\xF3\xB0\x96\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\x76\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],

        ["\xF3\xB0\x96\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA1"],
        ["\x80\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],

        ["\xF3\xB0\x96\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\x76\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],

        ["\xF3\xB0\x96\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\x76\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],

        ["\xF3\xB0\x96\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\x76\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],

        ["\xF3\xB0\x96\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\x76\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],

        ["\xF3\xB0\x96\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\x76\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],

        ["\xF3\xB0\x96\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\x76\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],

        ["\xF3\xB0\x96\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],
        ["\x76\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],

        ["\xF3\xB0\x96\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBC"],
        ["\x76\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],

        ["\xF3\xB0\x96\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBD"],
        ["\x76\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],

        ["\xF3\xB0\x96\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xBE"],
        ["\x76\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],

        ["\xF3\xB0\x96\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],
        ["\x76\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],

        ["\xF3\xB0\x96\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],
        ["\x76\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],

        ["\xF3\xB0\x96\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],
        ["\x76\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],

        ["\xF3\xB0\x96\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],
        ["\x76\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],

        ["\xF3\xB0\x96\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA2"],
        ["\x80\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],

        ["\xF3\xB0\x96\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA3"],
        ["\x80\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],

        ["\xF3\xB0\x96\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA4"],
        ["\x80\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],

        ["\xF3\xB0\x96\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],
        ["\x76\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],

        ["\xF3\xB0\x96\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\x76\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],

        ["\xF3\xB0\x96\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\x76\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],

        ["\xF3\xB0\x96\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA5"],
        ["\x80\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],

        ["\xF3\xB0\x96\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA6"],
        ["\x80\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],

        ["\xF3\xB0\x96\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA7"],
        ["\x80\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],

        ["\xF3\xB0\x96\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA8"],
        ["\x80\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],

        ["\xF3\xB0\x96\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xA9"],
        ["\x80\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],

        ["\xF3\xB0\x96\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],
        ["\x78\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],

        ["\xF3\xB0\x96\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xCF"],
        ["\x78\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],

        ["\xF3\xB0\x96\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xCB"],
        ["\x78\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],

        ["\xF3\xB0\x96\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAA"],
        ["\x80\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],

        ["\xF3\xB0\x96\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAB"],
        ["\x80\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],

        ["\xF3\xB0\x96\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAC"],
        ["\x80\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],

        ["\xF3\xB0\x96\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAD"],
        ["\x80\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],

        ["\xF3\xB0\x96\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAE"],
        ["\x80\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],

        ["\xF3\xB0\x96\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xAF"],
        ["\x80\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],

        ["\xF3\xB0\x97\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80\xB0"],
        ["\x80\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],

        ["\xF3\xB0\x9A\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xB0\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],

        ["\xF3\xB0\x9A\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xB0\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],

        ["\xF3\xB0\x9A\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xB0\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],

        ["\xF3\xB0\x9A\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xB0\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],

        ["\xF3\xB0\x9A\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xB0\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],

        ["\xF3\xB0\x9A\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xB0\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],

        ["\xF3\xB0\x9A\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xB0\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],

        ["\xF3\xB0\x9A\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xB0\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],

        ["\xF3\xB0\x9A\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xB0\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],

        ["\xF3\xB0\x9A\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xB0\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],

        ["\xF3\xB0\x9A\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xB0\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],

        ["\xF3\xB0\x9A\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xB0\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],

        ["\xF3\xB0\x9A\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xB0\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],

        ["\xF3\xB0\x9A\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xB0\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],

        ["\xF3\xB0\x9A\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xB0\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],

        ["\xF3\xB0\x9A\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xB0\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],

        ["\xF3\xB0\x9A\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xB0\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],

        ["\xF3\xB0\x9A\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\xB0\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],

        ["\xF3\xB0\x9A\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF2\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],

        ["\xF3\xB0\x9A\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xB0\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],

        ["\xF3\xB0\x9A\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xB0\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],

        ["\xF3\xB0\x9A\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xB0\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],

        ["\xF3\xB0\x9A\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xB0\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],

        ["\xF3\xB0\x9A\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xB0\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],

        ["\xF3\xB0\x9A\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xB0\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],

        ["\xF3\xB0\x9A\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xB0\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],

        ["\xF3\xB0\x9A\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xB0\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],

        ["\xF3\xB0\x9A\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xB0\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],

        ["\xF3\xB0\x9A\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xB0\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],

        ["\xF3\xB0\x9A\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xB0\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],

        ["\xF3\xB0\x9A\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xB0\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],

        ["\xF3\xB0\x9A\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xB0\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],

        ["\xF3\xB0\x9A\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xB0\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],

        ["\xF3\xB0\x9A\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xB0\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],

        ["\xF3\xB0\x9A\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xB0\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],

        ["\xF3\xB0\x9A\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xB0\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],

        ["\xF3\xB0\x9A\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xB0\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],

        ["\xF3\xB0\x9A\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xB0\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],

        ["\xF3\xB0\x9A\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xB0\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],

        ["\xF3\xB0\x9A\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xB0\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],

        ["\xF3\xB0\x9A\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xB0\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],

        ["\xF3\xB0\x9A\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xB0\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],

        ["\xF3\xB0\x9A\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xB0\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],

        ["\xF3\xB0\x9A\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xB0\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],

        ["\xF3\xB0\x9A\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xB0\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],

        ["\xF3\xB0\x9A\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xB0\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],

        ["\xF3\xB0\x9A\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xB0\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],

        ["\xF3\xB0\x9A\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xB0\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],

        ["\xF3\xB0\x9A\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xB0\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],

        ["\xF3\xB0\x9A\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xB0\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],

        ["\xF3\xB0\x9A\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xB0\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],

        ["\xF3\xB0\x9A\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xB0\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],

        ["\xF3\xB0\x9A\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xB0\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],

        ["\xF3\xB0\x9A\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xB0\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],

        ["\xF3\xB0\x9A\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xB0\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],

        ["\xF3\xB0\x9A\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xB0\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],

        ["\xF3\xB0\x9A\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xB0\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],

        ["\xF3\xB0\x9A\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xB0\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],

        ["\xF3\xB0\x9A\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xB0\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],

        ["\xF3\xB0\x9A\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xB0\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],

        ["\xF3\xB0\x9A\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xB0\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],

        ["\xF3\xB0\x9A\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xB0\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],

        ["\xF3\xB0\x9B\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xB0\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],

        ["\xF3\xB0\x9B\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xB0\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],

        ["\xF3\xB0\x9B\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xB0\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],

        ["\xF3\xB0\x9B\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xB0\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],

        ["\xF3\xB0\x9B\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xB0\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],

        ["\xF3\xB0\x9B\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xB0\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],

        ["\xF3\xB0\x9B\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xB0\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],

        ["\xF3\xB0\x9B\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xB0\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],

        ["\xF3\xB0\x9B\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xB0\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],

        ["\xF3\xB0\x9B\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xB0\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],

        ["\xF3\xB0\x9B\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xB0\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],

        ["\xF3\xB0\x9B\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xB0\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],

        ["\xF3\xB0\x9B\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xB0\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],

        ["\xF3\xB0\x9B\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xB0\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],

        ["\xF3\xB0\x9B\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xB0\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],

        ["\xF3\xB0\x9B\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xB0\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],

        ["\xF3\xB0\x9B\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xB0\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],

        ["\xF3\xB0\x9B\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xB0\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],

        ["\xF3\xB0\x9B\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xB0\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],

        ["\xF3\xB0\x9B\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xB0\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],

        ["\xF3\xB0\x9B\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xB0\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],

        ["\xF3\xB0\x9B\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xB0\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],

        ["\xF3\xB0\x9B\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xB0\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],

        ["\xF3\xB0\x9B\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xB0\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],

        ["\xF3\xB0\x9B\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xB0\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],

        ["\xF3\xB0\x9B\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xB0\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],

        ["\xF3\xB0\x9B\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xB0\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],

        ["\xF3\xB0\x9B\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xB0\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],

        ["\xF3\xB0\x9B\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xB0\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],

        ["\xF3\xB0\x9B\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xB0\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],

        ["\xF3\xB0\x9B\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xB0\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],

        ["\xF3\xB0\x9B\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xB0\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],

        ["\xF3\xB0\x9B\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xB1\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],

        ["\xF3\xB0\x9B\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xB1\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],

        ["\xF3\xB0\x9B\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xB1\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],

        ["\xF3\xB0\x9B\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xB1\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],

        ["\xF3\xB0\x9B\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xB1\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],

        ["\xF3\xB0\x9B\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xB1\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],

        ["\xF3\xB0\x9B\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xB1\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],

        ["\xF3\xB0\x9B\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xB1\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],

        ["\xF3\xB0\x9B\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xB1\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],

        ["\xF3\xB0\x9B\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xB1\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],

        ["\xF3\xB0\x9B\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xB1\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],

        ["\xF3\xB0\x9B\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xB1\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],

        ["\xF3\xB0\x9B\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xB1\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],

        ["\xF3\xB0\x9B\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xB1\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],

        ["\xF3\xB0\x9B\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xB1\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],

        ["\xF3\xB0\x9B\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xB1\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],

        ["\xF3\xB0\x9B\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xB1\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],

        ["\xF3\xB0\x9B\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xB1\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],

        ["\xF3\xB0\x9B\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xB1\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],

        ["\xF3\xB0\x9B\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xB1\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],

        ["\xF3\xB0\x9B\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xB1\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],

        ["\xF3\xB0\x9B\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xB1\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],

        ["\xF3\xB0\x9B\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xB1\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],

        ["\xF3\xB0\x9B\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xB1\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],

        ["\xF3\xB0\x9B\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xB1\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],

        ["\xF3\xB0\x9B\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xB1\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],

        ["\xF3\xB0\x9B\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xB1\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],

        ["\xF3\xB0\x9B\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xB1\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],

        ["\xF3\xB0\x9B\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xB1\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],

        ["\xF3\xB0\x9B\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xB1\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],

        ["\xF3\xB0\x9B\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xB1\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],

        ["\xF3\xB0\x9B\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xB1\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],

        ["\xF3\xB0\x9C\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xB1\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],

        ["\xF3\xB0\x9C\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xB1\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],

        ["\xF3\xB0\x9C\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xB1\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],

        ["\xF3\xB0\x9C\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xB1\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],

        ["\xF3\xB0\x9C\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xB1\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],

        ["\xF3\xB0\x9C\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xB1\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],

        ["\xF3\xB0\x9C\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xB1\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],

        ["\xF3\xB0\x9C\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xB1\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],

        ["\xF3\xB0\x9C\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xB1\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],

        ["\xF3\xB0\x9C\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xB1\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],

        ["\xF3\xB0\x9C\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xB1\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],

        ["\xF3\xB0\x9C\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xB1\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],

        ["\xF3\xB0\x9C\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xB1\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],

        ["\xF3\xB0\x9C\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xB1\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],

        ["\xF3\xB0\x9C\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xB1\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],

        ["\xF3\xB0\x9C\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xB1\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],

        ["\xF3\xB0\x9C\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xB1\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],

        ["\xF3\xB0\x9C\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xB1\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],

        ["\xF3\xB0\x9C\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xB1\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],

        ["\xF3\xB0\x9C\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xB1\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],

        ["\xF3\xB0\x9C\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xB1\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],

        ["\xF3\xB0\x9C\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xB1\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],

        ["\xF3\xB0\x9C\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xB1\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],

        ["\xF3\xB0\x9C\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xB1\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],

        ["\xF3\xB0\x9C\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xB1\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],

        ["\xF3\xB0\x9C\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xB1\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],

        ["\xF3\xB0\x9C\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xB1\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],

        ["\xF3\xB0\x9C\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xB1\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],

        ["\xF3\xB0\x9C\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xB1\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],

        ["\xF3\xB0\x9C\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xB1\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],

        ["\xF3\xB0\x9C\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xB1\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],

        ["\xF3\xB0\x9C\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xB1\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],

        ["\xF3\xB0\x9C\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xB1\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],

        ["\xF3\xB0\x9C\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xB1\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],

        ["\xF3\xB0\x9C\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xB1\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],

        ["\xF3\xB0\x9C\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xB1\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],

        ["\xF3\xB0\x9C\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xB1\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],

        ["\xF3\xB0\x9C\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xB1\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],

        ["\xF3\xB0\x9C\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xB1\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],

        ["\xF3\xB0\x9C\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xB1\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],

        ["\xF3\xB0\x9C\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xB1\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],

        ["\xF3\xB0\x9C\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xB1\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],

        ["\xF3\xB0\x9C\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xB1\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],

        ["\xF3\xB0\x9C\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xB1\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],

        ["\xF3\xB0\x9C\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xB1\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],

        ["\xF3\xB0\x9C\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xB1\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],

        ["\xF3\xB0\x9C\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xB1\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],

        ["\xF3\xB0\x9C\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xB1\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],

        ["\xF3\xB0\x9C\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xB1\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],

        ["\xF3\xB0\x9C\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xB1\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],

        ["\xF3\xB0\x9C\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xB1\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],

        ["\xF3\xB0\x9C\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xB1\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],

        ["\xF3\xB0\x9C\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xB1\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],

        ["\xF3\xB0\x9C\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xB1\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],

        ["\xF3\xB0\x9C\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xB1\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],

        ["\xF3\xB0\x9C\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xB1\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],

        ["\xF3\xB0\x9C\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xB1\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],

        ["\xF3\xB0\x9C\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xB1\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],

        ["\xF3\xB0\x9C\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xB1\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],

        ["\xF3\xB0\x9C\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xB1\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],

        ["\xF3\xB0\x9C\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xB1\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],

        ["\xF3\xB0\x9C\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xB1\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],

        ["\xF3\xB0\x9C\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xB2\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],

        ["\xF3\xB0\x9C\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xB2\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],

        ["\xF3\xB0\x9D\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xB2\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],

        ["\xF3\xB0\x9D\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xB2\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],

        ["\xF3\xB0\x9D\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xB2\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],

        ["\xF3\xB0\x9D\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xB2\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],

        ["\xF3\xB0\x9D\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xB2\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],

        ["\xF3\xB0\x9D\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\xB2\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],

        ["\xF3\xB0\x9D\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF2\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],

        ["\xF3\xB0\x9D\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xB2\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],

        ["\xF3\xB0\x9D\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xB2\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],

        ["\xF3\xB0\x9D\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xB2\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],

        ["\xF3\xB0\x9D\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xB2\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],

        ["\xF3\xB0\x9D\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xB2\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],

        ["\xF3\xB0\x9D\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xB2\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],

        ["\xF3\xB0\x9D\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xB2\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],

        ["\xF3\xB0\x9D\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xB2\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],

        ["\xF3\xB0\x9D\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xB2\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],

        ["\xF3\xB0\x9D\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xB2\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],

        ["\xF3\xB0\x9D\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xB2\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],

        ["\xF3\xB0\x9D\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xB2\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],

        ["\xF3\xB0\x9D\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xB2\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],

        ["\xF3\xB0\x9D\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xB2\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],

        ["\xF3\xB0\x9D\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xB2\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],

        ["\xF3\xB0\x9D\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xB2\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],

        ["\xF3\xB0\x9D\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xB2\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],

        ["\xF3\xB0\x9D\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xB2\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],

        ["\xF3\xB0\x9D\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xB2\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],

        ["\xF3\xB0\x9D\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xB2\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],

        ["\xF3\xB0\x9D\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xB2\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],

        ["\xF3\xB0\x9D\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xB2\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],

        ["\xF3\xB0\x9D\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xB2\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],

        ["\xF3\xB0\x9D\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xB2\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],

        ["\xF3\xB0\x9D\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xB2\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],

        ["\xF3\xB0\x9D\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xB2\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],

        ["\xF3\xB0\x9D\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xB2\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],

        ["\xF3\xB0\x9D\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xB2\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],

        ["\xF3\xB0\x9D\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xB2\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],

        ["\xF3\xB0\x9D\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xB2\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],

        ["\xF3\xB0\x9D\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xB2\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],

        ["\xF3\xB0\x9D\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xB2\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],

        ["\xF3\xB0\x9D\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xB2\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],

        ["\xF3\xB0\x9D\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xB2\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],

        ["\xF3\xB0\x9D\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xB2\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],

        ["\xF3\xB0\x9D\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xB2\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],

        ["\xF3\xB0\x9D\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xB2\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],

        ["\xF3\xB0\x9D\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xB2\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],

        ["\xF3\xB0\x9D\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xB2\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],

        ["\xF3\xB0\x9D\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xB2\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],

        ["\xF3\xB0\x9D\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xB2\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],

        ["\xF3\xB0\x9D\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xB2\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],

        ["\xF3\xB0\x9D\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xB2\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],

        ["\xF3\xB0\x9D\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xB2\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],

        ["\xF3\xB0\x9D\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xB2\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],

        ["\xF3\xB0\x9D\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xB2\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],

        ["\xF3\xB0\x9D\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xB2\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],

        ["\xF3\xB0\x9D\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xB2\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],

        ["\xF3\xB0\x9D\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xB2\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],

        ["\xF3\xB0\x9D\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xB2\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],

        ["\xF3\xB0\x9D\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xB2\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],

        ["\xF3\xB0\x9D\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xB2\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],

        ["\xF3\xB0\x9D\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xB2\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],

        ["\xF3\xB0\x9D\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xB2\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],

        ["\xF3\xB0\x9D\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xB2\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],

        ["\xF3\xB0\x9D\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xB2\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],

        ["\xF3\xB0\x9D\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xB2\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],

        ["\xF3\xB0\x9E\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xB2\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],

        ["\xF3\xB0\x9E\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xB2\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],

        ["\xF3\xB0\x9E\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xB2\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],

        ["\xF3\xB0\x9E\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xB2\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],

        ["\xF3\xB0\x9E\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xB2\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],

        ["\xF3\xB0\x9E\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xB2\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],

        ["\xF3\xB0\x9E\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xB2\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],

        ["\xF3\xB0\x9E\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xB2\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],

        ["\xF3\xB0\x9E\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xB2\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],

        ["\xF3\xB0\x9E\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xB2\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],

        ["\xF3\xB0\x9E\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xB2\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],

        ["\xF3\xB0\x9E\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xB2\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],

        ["\xF3\xB0\x9E\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xB2\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],

        ["\xF3\xB0\x9E\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xB2\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],

        ["\xF3\xB0\x9E\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xB2\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],

        ["\xF3\xB0\x9E\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xB2\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],

        ["\xF3\xB0\x9E\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xB2\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],

        ["\xF3\xB0\x9E\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xB2\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],

        ["\xF3\xB0\x9E\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xB2\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],

        ["\xF3\xB0\x9E\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xB2\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],

        ["\xF3\xB0\x9E\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xB2\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],

        ["\xF3\xB0\x9E\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xB2\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],

        ["\xF3\xB0\x9E\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xB2\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],

        ["\xF3\xB0\x9E\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xB2\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],

        ["\xF3\xB0\x9E\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xB2\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],

        ["\xF3\xB0\x9E\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xB2\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],

        ["\xF3\xB0\x9E\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xB2\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],

        ["\xF3\xB0\x9E\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xB2\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],

        ["\xF3\xB0\x9E\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xB3\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],

        ["\xF3\xB0\x9E\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xB3\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],

        ["\xF3\xB0\x9E\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xB3\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],

        ["\xF3\xB0\x9E\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xB3\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],

        ["\xF3\xB0\x9E\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xB3\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],

        ["\xF3\xB0\x9E\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xB3\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],

        ["\xF3\xB0\x9E\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xB3\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],

        ["\xF3\xB0\x9E\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xB3\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],

        ["\xF3\xB0\x9E\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xB3\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],

        ["\xF3\xB0\x9E\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xB3\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],

        ["\xF3\xB0\x9E\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xB3\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],

        ["\xF3\xB0\x9E\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xB3\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],

        ["\xF3\xB0\x9E\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xB3\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],

        ["\xF3\xB0\x9E\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xB3\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],

        ["\xF3\xB0\x9E\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xB3\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],

        ["\xF3\xB0\x9E\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xB3\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],

        ["\xF3\xB0\x9E\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xB3\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],

        ["\xF3\xB0\x9E\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xB3\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],

        ["\xF3\xB0\x9E\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xB3\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],

        ["\xF3\xB0\x9E\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xB3\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],

        ["\xF3\xB0\x9E\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xB3\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],

        ["\xF3\xB0\x9E\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xB3\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],

        ["\xF3\xB0\x9E\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xB3\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],

        ["\xF3\xB0\x9E\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xB3\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],

        ["\xF3\xB0\x9E\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xB3\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],

        ["\xF3\xB0\x9E\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xB3\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],

        ["\xF3\xB0\x9E\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xB3\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],

        ["\xF3\xB0\x9E\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xB3\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],

        ["\xF3\xB0\x9E\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xB3\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],

        ["\xF3\xB0\x9E\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xB3\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],

        ["\xF3\xB0\x9E\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xB3\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],

        ["\xF3\xB0\x9E\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xB3\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],

        ["\xF3\xB0\x9E\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xB3\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],

        ["\xF3\xB0\x9E\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],

        ["\xF3\xB0\x9E\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xB3\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],

        ["\xF3\xB0\x9E\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xB3\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],

        ["\xF3\xB0\x9F\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xB3\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],

        ["\xF3\xB0\x9F\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xB3\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],

        ["\xF3\xB0\x9F\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xB3\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],

        ["\xF3\xB0\x9F\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xB3\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],

        ["\xF3\xB0\x9F\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xD9\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],

        ["\xF3\xB0\x9F\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xB3\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],

        ["\xF3\xB0\x9F\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xB3\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],

        ["\xF3\xB0\x9F\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xB3\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],

        ["\xF3\xB0\x9F\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xB3\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],

        ["\xF3\xB0\x9F\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xB3\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],

        ["\xF3\xB0\x9F\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xB3\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],

        ["\xF3\xB0\x9F\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xB3\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],

        ["\xF3\xB0\x9F\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xB3\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],

        ["\xF3\xB0\x9F\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xB3\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],

        ["\xF3\xB0\x9F\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xB3\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],

        ["\xF3\xB0\x9F\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xB3\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],

        ["\xF3\xB0\x9F\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xB3\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],

        ["\xF3\xB0\x9F\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xB3\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],

        ["\xF3\xB0\x9F\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xB3\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],

        ["\xF3\xB0\x9F\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xB3\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],

        ["\xF3\xB0\x9F\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xB3\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],

        ["\xF3\xB0\x9F\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xB3\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],

        ["\xF3\xB0\x9F\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xB3\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],

        ["\xF3\xB0\x9F\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xB3\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],

        ["\xF3\xB0\x9F\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xB3\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],

        ["\xF3\xB0\x9F\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xB3\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],

        ["\xF3\xB0\x9F\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xB3\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],

        ["\xF3\xB0\x9F\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xB3\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],

        ["\xF3\xB0\x9F\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xB3\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],

        ["\xF3\xB0\x9F\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xB3\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],

        ["\xF3\xB0\x9F\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xB3\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],

        ["\xF3\xB0\x9F\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xB3\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],

        ["\xF3\xB0\x9F\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xB3\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],

        ["\xF3\xB0\x9F\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xB3\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],

        ["\xF3\xB0\x9F\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xB3\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],

        ["\xF3\xB0\x9F\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xB3\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],

        ["\xF3\xB0\x9F\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xB3\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],

        ["\xF3\xB0\x9F\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xB3\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],

        ["\xF3\xB0\x9F\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xB3\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],

        ["\xF3\xB0\x9F\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xB3\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],

        ["\xF3\xB0\x9F\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xB3\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],

        ["\xF3\xB0\x9F\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xB3\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],

        ["\xF3\xB0\x9F\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xB3\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],

        ["\xF3\xB0\x9F\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xB3\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],

        ["\xF3\xB0\x9F\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xB3\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],

        ["\xF3\xB0\x9F\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xB3\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],

        ["\xF3\xB0\x9F\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xB3\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],

        ["\xF3\xB0\x9F\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xB3\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],

        ["\xF3\xB0\x9F\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xB3\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],

        ["\xF3\xB0\x9F\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],

        ["\xF3\xB0\x9F\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xB3\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],

        ["\xF3\xB0\x9F\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xB3\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],

        ["\xF3\xB0\x9F\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xB3\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],

        ["\xF3\xB0\x9F\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xB3\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],

        ["\xF3\xB0\x9F\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xB3\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],

        ["\xF3\xB0\x9F\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xB3\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],

        ["\xF3\xB0\x9F\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xB3\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],

        ["\xF3\xB0\x9F\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xB3\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],

        ["\xF3\xB0\x9F\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xB4\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],

        ["\xF3\xB0\x9F\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xB4\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],

        ["\xF3\xB0\x9F\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xB4\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],

        ["\xF3\xB0\x9F\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xB4\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],

        ["\xF3\xB0\x9F\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xB4\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],

        ["\xF3\xB0\x9F\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xB4\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],

        ["\xF3\xB0\xA0\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xB4\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],

        ["\xF3\xB0\xA0\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xB4\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],

        ["\xF3\xB0\xA0\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xB4\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],

        ["\xF3\xB0\xA0\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xB4\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],

        ["\xF3\xB0\xA0\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xB4\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],

        ["\xF3\xB0\xA0\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xB4\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],

        ["\xF3\xB0\xA0\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xB4\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],

        ["\xF3\xB0\xA0\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xB4\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],

        ["\xF3\xB0\xA0\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xB4\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],

        ["\xF3\xB0\xA0\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xB4\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],

        ["\xF3\xB0\xA0\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xB4\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],

        ["\xF3\xB0\xA0\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xB4\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],

        ["\xF3\xB0\xA0\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xB4\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],

        ["\xF3\xB0\xA0\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xB4\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],

        ["\xF3\xB0\xA0\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xB4\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],

        ["\xF3\xB0\xA0\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xB4\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],

        ["\xF3\xB0\xA0\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xB4\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],

        ["\xF3\xB0\xA0\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xB4\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],

        ["\xF3\xB0\xA0\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xB4\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],

        ["\xF3\xB0\xA0\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xB4\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],

        ["\xF3\xB0\xA0\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xB4\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],

        ["\xF3\xB0\xA0\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xB4\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],

        ["\xF3\xB0\xA0\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xB4\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],

        ["\xF3\xB0\xA0\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xB4\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],

        ["\xF3\xB0\xA0\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xB4\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],

        ["\xF3\xB0\xA0\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xB4\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],

        ["\xF3\xB0\xA0\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xB4\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],

        ["\xF3\xB0\xA0\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xB4\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],

        ["\xF3\xB0\xA0\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xDE\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],

        ["\xF3\xB0\xA0\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xB4\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],

        ["\xF3\xB0\xA0\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xB4\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],

        ["\xF3\xB0\xA0\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xB4\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],

        ["\xF3\xB0\xA0\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xB4\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],

        ["\xF3\xB0\xA0\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xB4\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],

        ["\xF3\xB0\xA0\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xB4\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],

        ["\xF3\xB0\xA0\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xB4\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],

        ["\xF3\xB0\xA0\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xB4\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],

        ["\xF3\xB0\xA0\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xB4\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],

        ["\xF3\xB0\xA0\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xB4\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],

        ["\xF3\xB0\xA0\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xB4\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],

        ["\xF3\xB0\xA0\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xB4\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],

        ["\xF3\xB0\xA0\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xB4\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],

        ["\xF3\xB0\xA0\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xB4\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],

        ["\xF3\xB0\xA0\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xEB\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],

        ["\xF3\xB0\xA0\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xB4\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],

        ["\xF3\xB0\xA0\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xB4\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],

        ["\xF3\xB0\xA0\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xB4\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],

        ["\xF3\xB0\xA0\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xB4\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],

        ["\xF3\xB0\xA0\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xB4\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],

        ["\xF3\xB0\xA0\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xB4\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],

        ["\xF3\xB0\xA0\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xB4\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],

        ["\xF3\xB0\xA0\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xB4\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],

        ["\xF3\xB0\xA0\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xB4\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],

        ["\xF3\xB0\xA0\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xB4\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],

        ["\xF3\xB0\xA0\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xB4\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],

        ["\xF3\xB0\xA0\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xB4\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],

        ["\xF3\xB0\xA0\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xB4\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],

        ["\xF3\xB0\xA0\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xB4\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],

        ["\xF3\xB0\xA0\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xB4\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],

        ["\xF3\xB0\xA0\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xB4\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],

        ["\xF3\xB0\xA0\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xB4\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],

        ["\xF3\xB0\xA0\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xB4\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],

        ["\xF3\xB0\xA0\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xB4\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],

        ["\xF3\xB0\xA0\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xB4\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],

        ["\xF3\xB0\xA1\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xB4\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],

        ["\xF3\xB0\xA1\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xB4\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],

        ["\xF3\xB0\xA1\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xB4\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],

        ["\xF3\xB0\xA1\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xB4\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],

        ["\xF3\xB0\xA1\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xB4\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],

        ["\xF3\xB0\xA1\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xB4\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],

        ["\xF3\xB0\xA1\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xB4\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],

        ["\xF3\xB0\xA1\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xB4\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],

        ["\xF3\xB0\xA1\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xB4\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],

        ["\xF3\xB0\xA1\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xB4\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],

        ["\xF3\xB0\xA1\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xB4\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],

        ["\xF3\xB0\xA1\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xB4\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],

        ["\xF3\xB0\xA1\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xB4\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],

        ["\xF3\xB0\xA1\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xB4\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],

        ["\xF3\xB0\xA1\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xB4\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],

        ["\xF3\xB0\xA1\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xB4\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],

        ["\xF3\xB0\xA1\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xB4\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],

        ["\xF3\xB0\xA1\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xB4\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],

        ["\xF3\xB0\xA1\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xB4\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],

        ["\xF3\xB0\xA1\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xB4\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],

        ["\xF3\xB0\xA1\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xB4\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],

        ["\xF3\xB0\xA1\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xB4\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],

        ["\xF3\xB0\xA1\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xB4\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],

        ["\xF3\xB0\xA1\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xB4\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],

        ["\xF3\xB0\xA1\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xB5\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],

        ["\xF3\xB0\xA1\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xB5\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],

        ["\xF3\xB0\xA1\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xB5\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],

        ["\xF3\xB0\xA1\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xB5\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],

        ["\xF3\xB0\xA1\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xB5\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],

        ["\xF3\xB0\xA1\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xB5\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],

        ["\xF3\xB0\xA1\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xB5\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],

        ["\xF3\xB0\xA1\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xB5\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],

        ["\xF3\xB0\xA1\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xB5\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],

        ["\xF3\xB0\xA1\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xB5\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],

        ["\xF3\xB0\xA1\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xB5\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],

        ["\xF3\xB0\xA1\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xB5\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],

        ["\xF3\xB0\xA1\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xB5\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],

        ["\xF3\xB0\xA1\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xB5\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],

        ["\xF3\xB0\xA1\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xB5\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],

        ["\xF3\xB0\xA1\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xB5\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],

        ["\xF3\xB0\xA1\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xB5\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],

        ["\xF3\xB0\xA1\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xB5\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],

        ["\xF3\xB0\xA1\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xB5\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],

        ["\xF3\xB0\xA1\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xB5\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],

        ["\xF3\xB0\xA1\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xB5\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],

        ["\xF3\xB0\xA1\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xB5\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],

        ["\xF3\xB0\xA1\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xB5\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],

        ["\xF3\xB0\xA1\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xB5\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],

        ["\xF3\xB0\xA1\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xB5\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],

        ["\xF3\xB0\xA1\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xB5\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],

        ["\xF3\xB0\xA1\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xB5\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],

        ["\xF3\xB0\xA1\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xB5\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],

        ["\xF3\xB0\xA1\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xB5\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],

        ["\xF3\xB0\xA1\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xB5\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],

        ["\xF3\xB0\xA1\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xB5\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],

        ["\xF3\xB0\xA1\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xB5\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],

        ["\xF3\xB0\xA1\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xB5\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],

        ["\xF3\xB0\xA1\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xB5\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],

        ["\xF3\xB0\xA1\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xB5\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],

        ["\xF3\xB0\xA1\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xB5\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],

        ["\xF3\xB0\xA1\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xB5\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],

        ["\xF3\xB0\xA1\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xB5\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],

        ["\xF3\xB0\xA1\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xB5\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],

        ["\xF3\xB0\xA1\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xB5\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],

        ["\xF3\xB0\xA2\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xB5\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],

        ["\xF3\xB0\xA2\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xB5\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],

        ["\xF3\xB0\xA2\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xB5\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],

        ["\xF3\xB0\xA2\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xB5\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],

        ["\xF3\xB0\xA2\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xB5\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],

        ["\xF3\xB0\xA2\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xB5\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],

        ["\xF3\xB0\xA2\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xB5\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],

        ["\xF3\xB0\xA2\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xB5\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],

        ["\xF3\xB0\xA2\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xB5\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],

        ["\xF3\xB0\xA2\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xB5\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],

        ["\xF3\xB0\xA2\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xB5\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],

        ["\xF3\xB0\xA2\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xB5\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],

        ["\xF3\xB0\xA2\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xB5\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],

        ["\xF3\xB0\xA2\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xB5\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],

        ["\xF3\xB0\xA2\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xB5\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],

        ["\xF3\xB0\xA2\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xB5\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],

        ["\xF3\xB0\xA2\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xB5\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],

        ["\xF3\xB0\xA2\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xB5\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],

        ["\xF3\xB0\xA2\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xB5\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],

        ["\xF3\xB0\xA2\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xB5\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],

        ["\xF3\xB0\xA2\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xB5\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],

        ["\xF3\xB0\xA2\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xB5\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],

        ["\xF3\xB0\xA2\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xB5\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],

        ["\xF3\xB0\xA2\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xB5\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],

        ["\xF3\xB0\xA2\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xB5\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],

        ["\xF3\xB0\xA2\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xB5\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],

        ["\xF3\xB0\xA2\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xB5\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],

        ["\xF3\xB0\xA2\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xB5\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],

        ["\xF3\xB0\xA2\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xB5\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],

        ["\xF3\xB0\xA2\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xB5\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],

        ["\xF3\xB0\xA2\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xB5\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],

        ["\xF3\xB0\xA2\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xB5\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],

        ["\xF3\xB0\xA2\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xB5\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],

        ["\xF3\xB0\xA2\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xB5\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],

        ["\xF3\xB0\xA2\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xB5\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],

        ["\xF3\xB0\xA2\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xB5\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],

        ["\xF3\xB0\xA2\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xB5\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],

        ["\xF3\xB0\xA2\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xB5\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],

        ["\xF3\xB0\xA2\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xB5\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],

        ["\xF3\xB0\xA2\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xB5\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],

        ["\xF3\xB0\xA2\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xB5\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],

        ["\xF3\xB0\xA2\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xB5\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],

        ["\xF3\xB0\xA2\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xB5\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],

        ["\xF3\xB0\xA2\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xB5\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],

        ["\xF3\xB0\xA2\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xB5\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],

        ["\xF3\xB0\xA2\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xB5\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],

        ["\xF3\xB0\xA2\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xB5\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],

        ["\xF3\xB0\xA2\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xB5\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],

        ["\xF3\xB0\xA2\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xB5\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],

        ["\xF3\xB0\xA2\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xB5\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],

        ["\xF3\xB0\xA2\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xB5\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],

        ["\xF3\xB0\xA2\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xB5\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],

        ["\xF3\xB0\xA2\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xB5\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],

        ["\xF3\xB0\xA2\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xB5\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],

        ["\xF3\xB0\xA2\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xB6\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],

        ["\xF3\xB0\xA2\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xB6\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],

        ["\xF3\xB0\xA2\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xB6\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],

        ["\xF3\xB0\xA2\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xB6\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],

        ["\xF3\xB0\xA2\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xB6\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],

        ["\xF3\xB0\xA2\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xB6\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],

        ["\xF3\xB0\xA2\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xB6\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],

        ["\xF3\xB0\xA2\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xB6\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],

        ["\xF3\xB0\xA2\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xB6\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],

        ["\xF3\xB0\xA2\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xB6\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],

        ["\xF3\xB0\xA3\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xB6\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],

        ["\xF3\xB0\xA3\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xB6\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],

        ["\xF3\xB0\xA3\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xB6\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],

        ["\xF3\xB0\xA3\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xB6\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],

        ["\xF3\xB0\xA3\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xB6\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],

        ["\xF3\xB0\xA3\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xB6\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],

        ["\xF3\xB0\xA3\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xB6\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],

        ["\xF3\xB0\xA3\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xB6\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],

        ["\xF3\xB0\xA3\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xB6\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],

        ["\xF3\xB0\xA3\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xB6\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],

        ["\xF3\xB0\xA3\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xB6\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],

        ["\xF3\xB0\xA3\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xB6\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],

        ["\xF3\xB0\xA3\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xB6\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],

        ["\xF3\xB0\xA3\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xB6\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],

        ["\xF3\xB0\xA3\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xB6\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],

        ["\xF3\xB0\xA3\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xB6\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],

        ["\xF3\xB0\xA3\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xB6\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],

        ["\xF3\xB0\xA3\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xB6\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],

        ["\xF3\xB0\xA3\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xB6\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],

        ["\xF3\xB0\xA3\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xB6\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],

        ["\xF3\xB0\xA3\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xB6\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],

        ["\xF3\xB0\xA3\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xB6\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],

        ["\xF3\xB0\xA3\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xB6\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],

        ["\xF3\xB0\xA3\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xB6\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],

        ["\xF3\xB0\xA3\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xB6\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],

        ["\xF3\xB0\xA3\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xB6\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],

        ["\xF3\xB0\xA3\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xB6\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],

        ["\xF3\xB0\xA3\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\x47\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],

        ["\xF3\xB0\xA3\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xB6\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],

        ["\xF3\xB0\xA3\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xB6\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],

        ["\xF3\xB0\xA3\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xB6\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],

        ["\xF3\xB0\xA3\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xB6\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],

        ["\xF3\xB0\xA3\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xB6\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],

        ["\xF3\xB0\xA3\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xB6\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],

        ["\xF3\xB0\xA3\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xB6\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],

        ["\xF3\xB0\xA3\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xB6\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],

        ["\xF3\xB0\xA3\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xB6\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],

        ["\xF3\xB0\xA3\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xB6\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],

        ["\xF3\xB0\xA3\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xB6\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],

        ["\xF3\xB0\xA3\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xB6\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],

        ["\xF3\xB0\xA3\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xB6\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],

        ["\xF3\xB0\xA3\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xB6\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],

        ["\xF3\xB0\xA3\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xB6\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],

        ["\xF3\xB0\xA3\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xB6\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],

        ["\xF3\xB0\xA3\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xB6\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],

        ["\xF3\xB0\xA3\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xB6\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],

        ["\xF3\xB0\xA3\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xB6\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],

        ["\xF3\xB0\xA3\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xB6\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],

        ["\xF3\xB0\xA3\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xB6\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],

        ["\xF3\xB0\xA3\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xB6\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],

        ["\xF3\xB0\xA3\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xB6\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],

        ["\xF3\xB0\xA3\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xB6\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],

        ["\xF3\xB0\xA3\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xB6\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],

        ["\xF3\xB0\xA3\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xB6\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],

        ["\xF3\xB0\xA3\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xB6\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],

        ["\xF3\xB0\xA3\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xB6\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],

        ["\xF3\xB0\xA3\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xB6\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],

        ["\xF3\xB0\xA3\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xB6\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],

        ["\xF3\xB0\xA3\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xB6\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],

        ["\xF3\xB0\xA3\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xB6\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],

        ["\xF3\xB0\xA3\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xB6\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],

        ["\xF3\xB0\xA3\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xB6\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],

        ["\xF3\xB0\xA3\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xB6\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],

        ["\xF3\xB0\xA3\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xB6\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],

        ["\xF3\xB0\xA4\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xB6\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],

        ["\xF3\xB0\xA4\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xB6\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],

        ["\xF3\xB0\xA4\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xB6\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],

        ["\xF3\xB0\xA4\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xB6\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],

        ["\xF3\xB0\xA4\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xB6\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],

        ["\xF3\xB0\xA4\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xB6\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],

        ["\xF3\xB0\xA4\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xB6\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],

        ["\xF3\xB0\xA4\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xB6\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],

        ["\xF3\xB0\xA4\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xB6\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],

        ["\xF3\xB0\xA4\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xB6\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],

        ["\xF3\xB0\xA4\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xB6\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],

        ["\xF3\xB0\xA4\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xB6\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],

        ["\xF3\xB0\xA4\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xB6\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],

        ["\xF3\xB0\xA4\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xB6\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],

        ["\xF3\xB0\xA4\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xB6\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],

        ["\xF3\xB0\xA4\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xB6\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],

        ["\xF3\xB0\xA4\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xB6\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],

        ["\xF3\xB0\xA4\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xB6\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],

        ["\xF3\xB0\xA4\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xB6\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],

        ["\xF3\xB0\xA4\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xB6\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],

        ["\xF3\xB0\xA4\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xB7\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],

        ["\xF3\xB0\xA4\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xB7\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],

        ["\xF3\xB0\xA4\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xB7\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],

        ["\xF3\xB0\xA4\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xB7\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],

        ["\xF3\xB0\xA4\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xB7\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],

        ["\xF3\xB0\xA4\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xB7\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],

        ["\xF3\xB0\xA4\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xB7\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],

        ["\xF3\xB0\xA4\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xB7\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],

        ["\xF3\xB0\xA4\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xB7\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],

        ["\xF3\xB0\xA4\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xB7\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],

        ["\xF3\xB0\xA4\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xB7\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],

        ["\xF3\xB0\xA4\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xB7\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],

        ["\xF3\xB0\xA4\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xB7\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],

        ["\xF3\xB0\xA4\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xB7\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],

        ["\xF3\xB0\xA4\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xB7\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],

        ["\xF3\xB0\xA4\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xB7\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],

        ["\xF3\xB0\xA4\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xB7\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],

        ["\xF3\xB0\xA4\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xB7\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],

        ["\xF3\xB0\xA4\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xB7\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],

        ["\xF3\xB0\xA4\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xB7\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],

        ["\xF3\xB0\xA4\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xB7\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],

        ["\xF3\xB0\xA4\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xB7\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],

        ["\xF3\xB0\xA4\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xB7\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],

        ["\xF3\xB0\xA4\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xB7\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],

        ["\xF3\xB0\xA4\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xB7\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],

        ["\xF3\xB0\xA4\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xB7\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],

        ["\xF3\xB0\xA4\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xB7\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],

        ["\xF3\xB0\xA4\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xB7\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],

        ["\xF3\xB0\xA4\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xB7\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],

        ["\xF3\xB0\xA4\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xB7\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],

        ["\xF3\xB0\xA4\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xB7\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],

        ["\xF3\xB0\xA4\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xB7\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],

        ["\xF3\xB0\xA4\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xB7\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],

        ["\xF3\xB0\xA4\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xB7\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],

        ["\xF3\xB0\xA4\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xB7\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],

        ["\xF3\xB0\xA4\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xB7\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],

        ["\xF3\xB0\xA4\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xB7\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],

        ["\xF3\xB0\xA4\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xB7\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],

        ["\xF3\xB0\xA4\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xB7\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],

        ["\xF3\xB0\xA4\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xB7\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],

        ["\xF3\xB0\xA4\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xB7\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],

        ["\xF3\xB0\xA4\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xB7\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],

        ["\xF3\xB0\xA4\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xB7\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],

        ["\xF3\xB0\xA4\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xB7\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],

        ["\xF3\xB0\xA5\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xB7\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],

        ["\xF3\xB0\xA5\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xB7\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],

        ["\xF3\xB0\xA5\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xB7\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],

        ["\xF3\xB0\xA5\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xB7\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],

        ["\xF3\xB0\xA5\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xB7\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],

        ["\xF3\xB0\xA5\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xB7\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],

        ["\xF3\xB0\xA5\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xB7\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],

        ["\xF3\xB0\xA5\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xB7\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],

        ["\xF3\xB0\xA5\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xB7\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],

        ["\xF3\xB0\xA5\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xB7\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],

        ["\xF3\xB0\xA5\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xB7\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],

        ["\xF3\xB0\xA5\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xB7\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],

        ["\xF3\xB0\xA5\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xB7\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],

        ["\xF3\xB0\xA5\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\xB7\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],

        ["\xF3\xB0\xA5\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF0\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],

        ["\xF3\xB0\xA5\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xB7\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],

        ["\xF3\xB0\xA5\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xB7\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],

        ["\xF3\xB0\xA5\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xB7\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],

        ["\xF3\xB0\xA5\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xB7\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],

        ["\xF3\xB0\xA5\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xB7\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],

        ["\xF3\xB0\xA5\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xB7\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],

        ["\xF3\xB0\xA5\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xB7\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],

        ["\xF3\xB0\xA5\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xB7\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],

        ["\xF3\xB0\xA5\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xB7\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],

        ["\xF3\xB0\xA5\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xB7\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],

        ["\xF3\xB0\xA5\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xB7\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],

        ["\xF3\xB0\xA5\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xB7\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],

        ["\xF3\xB0\xA5\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xB7\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],

        ["\xF3\xB0\xA5\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xB7\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],

        ["\xF3\xB0\xA5\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xB7\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],

        ["\xF3\xB0\xA5\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xB7\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],

        ["\xF3\xB0\xA5\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xB7\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],

        ["\xF3\xB0\xA5\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xB7\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],

        ["\xF3\xB0\xA5\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xB7\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],

        ["\xF3\xB0\xA5\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xB7\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],

        ["\xF3\xB0\xA5\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xB7\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],

        ["\xF3\xB0\xA5\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xB7\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],

        ["\xF3\xB0\xA5\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xB7\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],

        ["\xF3\xB0\xA5\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xB7\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],

        ["\xF3\xB0\xA5\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xB7\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],

        ["\xF3\xB0\xA5\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xB7\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],

        ["\xF3\xB0\xA5\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xB7\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],

        ["\xF3\xB0\xA5\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xB7\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],

        ["\xF3\xB0\xA5\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xB7\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],

        ["\xF3\xB0\xA5\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xB7\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],

        ["\xF3\xB0\xA5\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xB7\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],

        ["\xF3\xB0\xA5\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xB7\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],

        ["\xF3\xB0\xA5\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xB7\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],

        ["\xF3\xB0\xA5\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xB7\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],

        ["\xF3\xB0\xA5\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xB7\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],

        ["\xF3\xB0\xA5\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xB8\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],

        ["\xF3\xB0\xA5\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xB8\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],

        ["\xF3\xB0\xA5\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xB8\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],

        ["\xF3\xB0\xA5\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xB8\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],

        ["\xF3\xB0\xA5\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xB8\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],

        ["\xF3\xB0\xA5\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xB8\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],

        ["\xF3\xB0\xA5\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xB8\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],

        ["\xF3\xB0\xA5\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xB8\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],

        ["\xF3\xB0\xA5\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xB8\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],

        ["\xF3\xB0\xA5\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xB8\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],

        ["\xF3\xB0\xA5\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xB8\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],

        ["\xF3\xB0\xA5\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xB8\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],

        ["\xF3\xB0\xA5\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xB8\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],

        ["\xF3\xB0\xA5\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xB8\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],

        ["\xF3\xB0\xA6\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xB8\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],

        ["\xF3\xB0\xA6\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xB8\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],

        ["\xF3\xB0\xA6\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xB8\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],

        ["\xF3\xB0\xA6\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xB8\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],

        ["\xF3\xB0\xA6\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xB8\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],

        ["\xF3\xB0\xA6\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xB8\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],

        ["\xF3\xB0\xA6\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xB8\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],

        ["\xF3\xB0\xA6\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xB8\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],

        ["\xF3\xB0\xA6\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xB8\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],

        ["\xF3\xB0\xA6\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xB8\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],

        ["\xF3\xB0\xA6\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xB8\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],

        ["\xF3\xB0\xA6\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xB8\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],

        ["\xF3\xB0\xA6\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xB8\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],

        ["\xF3\xB0\xA6\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xB8\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],

        ["\xF3\xB0\xA6\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xB8\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],

        ["\xF3\xB0\xA6\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xB8\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],

        ["\xF3\xB0\xA6\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xB8\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],

        ["\xF3\xB0\xA6\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xB8\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],

        ["\xF3\xB0\xA6\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xB8\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],

        ["\xF3\xB0\xA6\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xB8\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],

        ["\xF3\xB0\xA6\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xB8\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],

        ["\xF3\xB0\xA6\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xB8\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],

        ["\xF3\xB0\xA6\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xB8\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],

        ["\xF3\xB0\xA6\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xB8\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],

        ["\xF3\xB0\xA6\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xB8\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],

        ["\xF3\xB0\xA6\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xB8\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],

        ["\xF3\xB0\xA6\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xB8\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],

        ["\xF3\xB0\xA6\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xB8\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],

        ["\xF3\xB0\xA6\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xB8\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],

        ["\xF3\xB0\xA6\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xB8\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],

        ["\xF3\xB0\xA6\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xB8\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],

        ["\xF3\xB0\xA6\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xB8\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],

        ["\xF3\xB0\xA6\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xB8\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],

        ["\xF3\xB0\xA6\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xB8\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],

        ["\xF3\xB0\xA6\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xB8\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],

        ["\xF3\xB0\xA6\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xB8\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],

        ["\xF3\xB0\xA6\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xB8\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],

        ["\xF3\xB0\xA6\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xB8\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],

        ["\xF3\xB0\xA6\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xB8\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],

        ["\xF3\xB0\xA6\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xB8\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],

        ["\xF3\xB0\xA6\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xB8\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],

        ["\xF3\xB0\xA6\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xB8\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],

        ["\xF3\xB0\xA6\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xB8\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],

        ["\xF3\xB0\xA6\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xB8\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],

        ["\xF3\xB0\xA6\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xB8\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],

        ["\xF3\xB0\xA6\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xB8\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],

        ["\xF3\xB0\xA6\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xB8\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],

        ["\xF3\xB0\xA6\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xB8\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],

        ["\xF3\xB0\xA6\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xB8\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],

        ["\xF3\xB0\xA6\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xB8\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],

        ["\xF3\xB0\xA6\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xB8\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],

        ["\xF3\xB0\xA6\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xB8\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],

        ["\xF3\xB0\xA6\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xB8\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],

        ["\xF3\xB0\xA6\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xB8\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],

        ["\xF3\xB0\xA6\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xB8\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],

        ["\xF3\xB0\xA6\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xB8\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],

        ["\xF3\xB0\xA6\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xB8\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],

        ["\xF3\xB0\xA6\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xB8\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],

        ["\xF3\xB0\xA6\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xB8\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],

        ["\xF3\xB0\xA6\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xB8\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],

        ["\xF3\xB0\xA6\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xB8\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],

        ["\xF3\xB0\xA6\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xB8\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],

        ["\xF3\xB0\xA6\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xB8\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],

        ["\xF3\xB0\xA6\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xB8\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],

        ["\xF3\xB0\xA7\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xB8\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],

        ["\xF3\xB0\xA7\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xB8\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],

        ["\xF3\xB0\xA7\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xB8\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],

        ["\xF3\xB0\xA7\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xB8\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],

        ["\xF3\xB0\xA7\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xB8\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],

        ["\xF3\xB0\xA7\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xB8\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],

        ["\xF3\xB0\xA7\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xB8\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],

        ["\xF3\xB0\xA7\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xB8\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],

        ["\xF3\xB0\xA7\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xB8\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],

        ["\xF3\xB0\xA7\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xB8\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],

        ["\xF3\xB0\xA7\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xB8\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],

        ["\xF3\xB0\xA7\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xB8\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],

        ["\xF3\xB0\xA7\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xB8\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],

        ["\xF3\xB0\xA7\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xB8\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],

        ["\xF3\xB0\xA7\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xB8\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],

        ["\xF3\xB0\xA7\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xB8\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],

        ["\xF3\xB0\xA7\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xB9\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],

        ["\xF3\xB0\xA7\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xB9\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],

        ["\xF3\xB0\xA7\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xB9\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],

        ["\xF3\xB0\xA7\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xB9\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],

        ["\xF3\xB0\xA7\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xB9\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],

        ["\xF3\xB0\xA7\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xB9\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],

        ["\xF3\xB0\xA7\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xB9\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],

        ["\xF3\xB0\xA7\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xB9\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],

        ["\xF3\xB0\xA7\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xB9\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],

        ["\xF3\xB0\xA7\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xB9\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],

        ["\xF3\xB0\xA7\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xB9\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],

        ["\xF3\xB0\xA7\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xB9\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],

        ["\xF3\xB0\xA7\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xB9\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],

        ["\xF3\xB0\xA7\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xB9\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],

        ["\xF3\xB0\xA7\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xB9\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],

        ["\xF3\xB0\xA7\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xB9\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],

        ["\xF3\xB0\xA7\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xB9\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],

        ["\xF3\xB0\xA7\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xB9\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],

        ["\xF3\xB0\xA7\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xB9\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],

        ["\xF3\xB0\xA7\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xB9\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],

        ["\xF3\xB0\xA7\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xB9\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],

        ["\xF3\xB0\xA7\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xB9\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],

        ["\xF3\xB0\xA7\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\x50\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],

        ["\xF3\xB0\xA7\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xB9\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],

        ["\xF3\xB0\xA7\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xB9\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],

        ["\xF3\xB0\xA7\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xB9\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],

        ["\xF3\xB0\xA7\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xB9\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],

        ["\xF3\xB0\xA7\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xB9\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],

        ["\xF3\xB0\xA7\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xB9\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],

        ["\xF3\xB0\xA7\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xB9\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],

        ["\xF3\xB0\xA7\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xB9\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],

        ["\xF3\xB0\xA7\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xB9\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],

        ["\xF3\xB0\xA7\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xB9\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],

        ["\xF3\xB0\xA7\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xB9\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],

        ["\xF3\xB0\xA7\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xB9\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],

        ["\xF3\xB0\xA7\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xB9\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],

        ["\xF3\xB0\xA7\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xB9\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],

        ["\xF3\xB0\xA7\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xB9\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],

        ["\xF3\xB0\xA7\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xB9\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],

        ["\xF3\xB0\xA7\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xB9\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],

        ["\xF3\xB0\xA7\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xB9\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],

        ["\xF3\xB0\xA7\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xB9\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],

        ["\xF3\xB0\xA7\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xB9\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],

        ["\xF3\xB0\xA7\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xB9\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],

        ["\xF3\xB0\xA7\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xB9\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],

        ["\xF3\xB0\xA7\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xB9\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],

        ["\xF3\xB0\xA7\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xB9\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],

        ["\xF3\xB0\xA7\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xB9\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],

        ["\xF3\xB0\xA8\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xB9\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],

        ["\xF3\xB0\xA8\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xB9\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],

        ["\xF3\xB0\xA8\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xB9\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],

        ["\xF3\xB0\xA8\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xB9\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],

        ["\xF3\xB0\xA8\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xB9\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],

        ["\xF3\xB0\xA8\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xB9\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],

        ["\xF3\xB0\xA8\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xB9\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],

        ["\xF3\xB0\xA8\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xB9\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],

        ["\xF3\xB0\xA8\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xB9\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],

        ["\xF3\xB0\xA8\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xB9\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],

        ["\xF3\xB0\xA8\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\xB9\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],

        ["\xF3\xB0\xA8\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],

        ["\xF3\xB0\xA8\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xB9\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],

        ["\xF3\xB0\xA8\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xB9\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],

        ["\xF3\xB0\xA8\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xB9\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],

        ["\xF3\xB0\xA8\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xB9\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],

        ["\xF3\xB0\xA8\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xB9\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],

        ["\xF3\xB0\xA8\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xB9\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],

        ["\xF3\xB0\xA8\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xB9\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],

        ["\xF3\xB0\xA8\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xB9\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],

        ["\xF3\xB0\xA8\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xB9\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],

        ["\xF3\xB0\xA8\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xB9\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],

        ["\xF3\xB0\xA8\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xB9\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],

        ["\xF3\xB0\xA8\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xB9\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],

        ["\xF3\xB0\xA8\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xB9\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],

        ["\xF3\xB0\xA8\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xB9\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],

        ["\xF3\xB0\xA8\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xB9\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],

        ["\xF3\xB0\xA8\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xB9\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],

        ["\xF3\xB0\xA8\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],
        ["\x6F\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],

        ["\xF3\xB0\xA8\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xB9\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],

        ["\xF3\xB0\xA8\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xB9\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],

        ["\xF3\xB0\xA8\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xB9\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],

        ["\xF3\xB0\xA8\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xB9\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],

        ["\xF3\xB0\xA8\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xB9\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],

        ["\xF3\xB0\xA8\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xB9\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],

        ["\xF3\xB0\xA8\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xB9\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],

        ["\xF3\xB0\xA8\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xB9\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],

        ["\xF3\xB0\xA8\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xB9\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],

        ["\xF3\xB0\xA8\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xB9\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],

        ["\xF3\xB0\xA8\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xB9\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],

        ["\xF3\xB0\xA8\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xB9\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],

        ["\xF3\xB0\xA8\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xB9\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],

        ["\xF3\xB0\xA8\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xB9\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],

        ["\xF3\xB0\xA8\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xB9\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],

        ["\xF3\xB0\xA8\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xB9\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],

        ["\xF3\xB0\xA8\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\xB9\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],

        ["\xF3\xB0\xA8\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\xBA\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],

        ["\xF3\xB0\xA8\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xBA\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],

        ["\xF3\xB0\xA8\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\xBA\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],

        ["\xF3\xB0\xA8\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xBA\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],

        ["\xF3\xB0\xA8\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\xBA\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],

        ["\xF3\xB0\xA8\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\xBA\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],

        ["\xF3\xB0\xA8\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xBA\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],

        ["\xF3\xB0\xA8\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\xBA\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],

        ["\xF3\xB0\xA8\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xBA\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],

        ["\xF3\xB0\xA8\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xBA\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],

        ["\xF3\xB0\xA8\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\xBA\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],

        ["\xF3\xB0\xA8\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xBA\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],

        ["\xF3\xB0\xA8\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\xBA\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],

        ["\xF3\xB0\xA8\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xBA\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],

        ["\xF3\xB0\xA8\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\xBA\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],

        ["\xF3\xB0\xA8\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\xBA\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],

        ["\xF3\xB0\xA8\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xBA\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],

        ["\xF3\xB0\xA8\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\xBA\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],

        ["\xF3\xB0\xA9\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xBA\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],

        ["\xF3\xB0\xA9\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xBA\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],

        ["\xF3\xB0\xA9\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xBA\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],

        ["\xF3\xB0\xA9\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xBA\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],

        ["\xF3\xB0\xA9\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\xBA\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],

        ["\xF3\xB0\xA9\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xBA\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],

        ["\xF3\xB0\xA9\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xBA\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],

        ["\xF3\xB0\xA9\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xBA\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],

        ["\xF3\xB0\xA9\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xBA\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],

        ["\xF3\xB0\xA9\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xBA\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],

        ["\xF3\xB0\xA9\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\xBA\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],

        ["\xF3\xB0\xA9\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xBA\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],

        ["\xF3\xB0\xA9\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xBA\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],

        ["\xF3\xB0\xA9\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\xBA\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],

        ["\xF3\xB0\xA9\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xBA\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],

        ["\xF3\xB0\xA9\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xBA\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],

        ["\xF3\xB0\xA9\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\xBA\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],

        ["\xF3\xB0\xA9\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\xBA\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],

        ["\xF3\xB0\xA9\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xBA\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],

        ["\xF3\xB0\xA9\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xBA\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],

        ["\xF3\xB0\xA9\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xBA\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],

        ["\xF3\xB0\xA9\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\xBA\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],

        ["\xF3\xB0\xA9\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\xBA\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],

        ["\xF3\xB0\xA9\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\xBA\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],

        ["\xF3\xB0\xA9\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xBA\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],

        ["\xF3\xB0\xA9\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\xBA\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],

        ["\xF3\xB0\xA9\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xBA\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],

        ["\xF3\xB0\xA9\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xBA\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],

        ["\xF3\xB0\xA9\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xBA\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],

        ["\xF3\xB0\xA9\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xBA\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],

        ["\xF3\xB0\xA9\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xBA\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],

        ["\xF3\xB0\xA9\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\xBA\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],

        ["\xF3\xB0\xA9\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\xBA\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],

        ["\xF3\xB0\xA9\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\xBA\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],

        ["\xF3\xB0\xA9\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\xBA\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],

        ["\xF3\xB0\xA9\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xBA\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],

        ["\xF3\xB0\xA9\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xBA\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],

        ["\xF3\xB0\xA9\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\xBA\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],

        ["\xF3\xB0\xA9\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xBA\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],

        ["\xF3\xB0\xA9\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xBA\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],

        ["\xF3\xB0\xA9\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xBA\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],

        ["\xF3\xB0\xA9\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xBA\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],

        ["\xF3\xB0\xA9\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\xBA\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],

        ["\xF3\xB0\xA9\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xBA\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],

        ["\xF3\xB0\xA9\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\xBA\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],

        ["\xF3\xB0\xA9\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xBA\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],

        ["\xF3\xB0\xA9\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\xBA\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],

        ["\xF3\xB0\xA9\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\xBA\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],

        ["\xF3\xB0\xA9\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\xBA\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],

        ["\xF3\xB0\xA9\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\xBA\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],

        ["\xF3\xB0\xA9\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xBA\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],

        ["\xF3\xB0\xA9\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\xBA\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],

        ["\xF3\xB0\xA9\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\xBA\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],

        ["\xF3\xB0\xA9\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xBA\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],

        ["\xF3\xB0\xA9\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\xBA\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],

        ["\xF3\xB0\xA9\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xBA\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],

        ["\xF3\xB0\xA9\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\xBA\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],

        ["\xF3\xB0\xA9\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xBA\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],

        ["\xF3\xB0\xA9\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xBA\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],

        ["\xF3\xB0\xA9\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xBA\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],

        ["\xF3\xB0\xA9\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\xBA\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],

        ["\xF3\xB0\xA9\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xBA\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],

        ["\xF3\xB0\xA9\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xBA\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],

        ["\xF3\xB0\xA9\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\xBA\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],

        ["\xF3\xB0\xAA\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xBA\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],

        ["\xF3\xB0\xAA\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xBA\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],

        ["\xF3\xB0\xAA\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xBA\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],

        ["\xF3\xB0\xAA\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\xBA\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],

        ["\xF3\xB0\xAA\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xBA\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],

        ["\xF3\xB0\xAA\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xBA\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],

        ["\xF3\xB0\xAA\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xBA\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],

        ["\xF3\xB0\xAA\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\xBA\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],

        ["\xF3\xB0\xAA\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\xBA\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],

        ["\xF3\xB0\xAA\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\xBA\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],

        ["\xF3\xB0\xAA\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xBA\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],

        ["\xF3\xB0\xAA\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xBA\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],

        ["\xF3\xB0\xAA\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xBB\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],

        ["\xF3\xB0\xAA\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xBB\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],

        ["\xF3\xB0\xAA\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xBB\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],

        ["\xF3\xB0\xAA\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xBB\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],

        ["\xF3\xB0\xAA\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\xBB\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],

        ["\xF3\xB0\xAA\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xBB\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],

        ["\xF3\xB0\xAA\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\xBB\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],

        ["\xF3\xB0\xAA\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\xBB\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],

        ["\xF3\xB0\xAA\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xBB\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],

        ["\xF3\xB0\xAA\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xBB\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],

        ["\xF3\xB0\xAA\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xBB\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],

        ["\xF3\xB0\xAA\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xBB\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],

        ["\xF3\xB0\xAA\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xBB\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],

        ["\xF3\xB0\xAA\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\xBB\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],

        ["\xF3\xB0\xAA\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\xBB\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],

        ["\xF3\xB0\xAA\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\xBB\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],

        ["\xF3\xB0\xAA\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xBB\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],

        ["\xF3\xB0\xAA\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xBB\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],

        ["\xF3\xB0\xAA\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xBB\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],

        ["\xF3\xB0\xAA\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\xBB\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],

        ["\xF3\xB0\xAA\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xBB\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],

        ["\xF3\xB0\xAA\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xBB\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],

        ["\xF3\xB0\xAA\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\xBB\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],

        ["\xF3\xB0\xAA\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\xBB\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],

        ["\xF3\xB0\xAA\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xBB\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],

        ["\xF3\xB0\xAA\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\xBB\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],

        ["\xF3\xB0\xAA\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xBB\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],

        ["\xF3\xB0\xAA\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xBB\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],

        ["\xF3\xB0\xAA\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xBB\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],

        ["\xF3\xB0\xAA\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xBB\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],

        ["\xF3\xB0\xAA\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xBB\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],

        ["\xF3\xB0\xAA\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xBB\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],

        ["\xF3\xB0\xAA\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xBB\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],

        ["\xF3\xB0\xAA\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xBB\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],

        ["\xF3\xB0\xAA\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xBB\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],

        ["\xF3\xB0\xAA\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xBB\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],

        ["\xF3\xB0\xAA\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\xBB\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],

        ["\xF3\xB0\xAA\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xBB\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],

        ["\xF3\xB0\xAA\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\xBB\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],

        ["\xF3\xB0\xAA\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xBB\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],

        ["\xF3\xB0\xAA\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xBB\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],

        ["\xF3\xB0\xAA\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xBB\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],

        ["\xF3\xB0\xAA\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xBB\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],

        ["\xF3\xB0\xAA\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xBB\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],

        ["\xF3\xB0\xAA\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xBB\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],

        ["\xF3\xB0\xAA\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xBB\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],

        ["\xF3\xB0\xAA\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\xBB\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],

        ["\xF3\xB0\xAA\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xBB\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],

        ["\xF3\xB0\xAA\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\xBB\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],

        ["\xF3\xB0\xAA\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xBB\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],

        ["\xF3\xB0\xAA\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\xBB\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],

        ["\xF3\xB0\xAA\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xBB\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],

        ["\xF3\xB0\xAB\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xBB\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],

        ["\xF3\xB0\xAB\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xBB\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],

        ["\xF3\xB0\xAB\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xBB\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],

        ["\xF3\xB0\xAB\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xBB\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],

        ["\xF3\xB0\xAB\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\xBB\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],

        ["\xF3\xB0\xAB\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xBB\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],

        ["\xF3\xB0\xAB\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\xBB\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],

        ["\xF3\xB0\xAB\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\xBB\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],

        ["\xF3\xB0\xAB\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\xBB\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],

        ["\xF3\xB0\xAB\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xBB\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],

        ["\xF3\xB0\xAB\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xBB\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],

        ["\xF3\xB0\xAB\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xBB\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],

        ["\xF3\xB0\xAB\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\xBB\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],

        ["\xF3\xB0\xAB\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\xBB\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],

        ["\xF3\xB0\xAB\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xBB\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],

        ["\xF3\xB0\xAB\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\xBB\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],

        ["\xF3\xB0\xAB\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\xBB\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],

        ["\xF3\xB0\xAB\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xBB\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],

        ["\xF3\xB0\xAB\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xBB\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],

        ["\xF3\xB0\xAB\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xBB\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],

        ["\xF3\xB0\xAB\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xBB\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],

        ["\xF3\xB0\xAB\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xBB\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],

        ["\xF3\xB0\xAB\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\xBB\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],

        ["\xF3\xB0\xAB\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xBB\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],

        ["\xF3\xB0\xAB\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xBB\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],

        ["\xF3\xB0\xAB\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xBB\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],

        ["\xF3\xB0\xAB\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xBB\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],

        ["\xF3\xB0\xAB\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xBB\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],

        ["\xF3\xB0\xAB\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xBB\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],

        ["\xF3\xB0\xAB\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\xBB\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],

        ["\xF3\xB0\xAB\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\xBB\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],

        ["\xF3\xB0\xAB\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\xBB\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],

        ["\xF3\xB0\xAB\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\xBB\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],

        ["\xF3\xB0\xAB\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xBB\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],

        ["\xF3\xB0\xAB\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xBB\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],

        ["\xF3\xB0\xAB\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\xBB\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],

        ["\xF3\xB0\xAB\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xBB\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],

        ["\xF3\xB0\xAB\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\xBB\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],

        ["\xF3\xB0\xAB\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xBB\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],

        ["\xF3\xB0\xAB\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xBB\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],

        ["\xF3\xB0\xAB\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xBB\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],

        ["\xF3\xB0\xAB\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\xBB\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],

        ["\xF3\xB0\xAB\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\xBC\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],

        ["\xF3\xB0\xAB\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xBC\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],

        ["\xF3\xB0\xAB\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xBC\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],

        ["\xF3\xB0\xAB\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\xBC\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],

        ["\xF3\xB0\xAB\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xBC\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],

        ["\xF3\xB0\xAB\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xBC\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],

        ["\xF3\xB0\xAB\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xBC\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],

        ["\xF3\xB0\xAB\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xBC\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],

        ["\xF3\xB0\xAB\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xBC\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],

        ["\xF3\xB0\xAB\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xBC\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],

        ["\xF3\xB0\xAB\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xBC\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],

        ["\xF3\xB0\xAB\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xBC\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],

        ["\xF3\xB0\xAB\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xBC\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],

        ["\xF3\xB0\xAB\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xBC\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],

        ["\xF3\xB0\xAB\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\xBC\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],

        ["\xF3\xB0\xAB\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\xBC\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],

        ["\xF3\xB0\xAB\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xBC\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],

        ["\xF3\xB0\xAB\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xBC\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],

        ["\xF3\xB0\xAB\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xBC\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],

        ["\xF3\xB0\xAB\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xBC\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],

        ["\xF3\xB0\xAB\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xBC\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],

        ["\xF3\xB0\xAB\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xBC\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],

        ["\xF3\xB0\xAC\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\xBC\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],

        ["\xF3\xB0\xAC\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xBC\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],

        ["\xF3\xB0\xAC\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xBC\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],

        ["\xF3\xB0\xAC\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xBC\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],

        ["\xF3\xB0\xAC\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xBC\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],

        ["\xF3\xB0\xAC\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\xBC\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],

        ["\xF3\xB0\xAC\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xBC\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],

        ["\xF3\xB0\xAC\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xBC\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],

        ["\xF3\xB0\xAC\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xBC\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],

        ["\xF3\xB0\xAC\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xBC\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],

        ["\xF3\xB0\xAC\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\xBC\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],

        ["\xF3\xB0\xAC\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\xBC\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],

        ["\xF3\xB0\xAC\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\xBC\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],

        ["\xF3\xB0\xAC\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xBC\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],

        ["\xF3\xB0\xAC\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xBC\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],

        ["\xF3\xB0\xAC\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xBC\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],

        ["\xF3\xB0\xAC\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xBC\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],

        ["\xF3\xB0\xAC\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xBC\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],

        ["\xF3\xB0\xAC\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],

        ["\xF3\xB0\xAC\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xBC\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],

        ["\xF3\xB0\xAC\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\xBC\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],

        ["\xF3\xB0\xAC\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xBC\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],

        ["\xF3\xB0\xAC\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xBC\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],

        ["\xF3\xB0\xAC\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xBC\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],

        ["\xF3\xB0\xAC\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xBC\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],

        ["\xF3\xB0\xAC\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xBC\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],

        ["\xF3\xB0\xAC\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xBC\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],

        ["\xF3\xB0\xAC\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\xBC\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],

        ["\xF3\xB0\xAC\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xBC\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],

        ["\xF3\xB0\xAC\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\xBC\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],

        ["\xF3\xB0\xAC\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xBC\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],

        ["\xF3\xB0\xAC\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xBC\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],

        ["\xF3\xB0\xAC\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xBC\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],

        ["\xF3\xB0\xAC\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xBC\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],

        ["\xF3\xB0\xAC\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xBC\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],

        ["\xF3\xB0\xAC\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\xBC\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],

        ["\xF3\xB0\xAC\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xBC\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],

        ["\xF3\xB0\xAC\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xBC\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],

        ["\xF3\xB0\xAC\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\xBC\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],

        ["\xF3\xB0\xAC\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xBC\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],

        ["\xF3\xB0\xAC\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xBC\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],

        ["\xF3\xB0\xAC\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xBC\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],

        ["\xF3\xB0\xAC\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xBC\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],

        ["\xF3\xB0\xAC\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xBC\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],

        ["\xF3\xB0\xAC\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\xBC\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],

        ["\xF3\xB0\xAC\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xBC\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],

        ["\xF3\xB0\xAC\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xBC\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],

        ["\xF3\xB0\xAC\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xBC\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],

        ["\xF3\xB0\xAC\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\xBC\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],

        ["\xF3\xB0\xAC\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xBC\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],

        ["\xF3\xB0\xAC\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\xBC\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],

        ["\xF3\xB0\xAC\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xBC\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],

        ["\xF3\xB0\xAC\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xBC\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],

        ["\xF3\xB0\xAC\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xBC\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],

        ["\xF3\xB0\xAC\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\xBC\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],

        ["\xF3\xB0\xAC\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xBC\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],

        ["\xF3\xB0\xAC\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\xBC\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],

        ["\xF3\xB0\xAC\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xBC\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],

        ["\xF3\xB0\xAC\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xBC\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],

        ["\xF3\xB0\xAC\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\xBC\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],

        ["\xF3\xB0\xAC\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\xBC\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],

        ["\xF3\xB0\xAC\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xBC\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],

        ["\xF3\xB0\xAC\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\xBC\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],

        ["\xF3\xB0\xAC\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\xBC\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],

        ["\xF3\xB0\xAD\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\xBC\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],

        ["\xF3\xB0\xAD\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\xBC\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],

        ["\xF3\xB0\xAD\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xBC\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],

        ["\xF3\xB0\xAD\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\xBC\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],

        ["\xF3\xB0\xAD\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\xBC\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],

        ["\xF3\xB0\xAD\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xBC\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],

        ["\xF3\xB0\xAD\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\xBC\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],

        ["\xF3\xB0\xAD\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\xBC\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],

        ["\xF3\xB0\xAD\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\xBD\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],

        ["\xF3\xB0\xAD\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xBD\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],

        ["\xF3\xB0\xAD\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\xBD\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],

        ["\xF3\xB0\xAD\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\xBD\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],

        ["\xF3\xB0\xAD\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xBD\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],

        ["\xF3\xB0\xAD\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xBD\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],

        ["\xF3\xB0\xAD\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\xBD\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],

        ["\xF3\xB0\xAD\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xBD\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],

        ["\xF3\xB0\xAD\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xBD\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],

        ["\xF3\xB0\xAD\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xBD\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],

        ["\xF3\xB0\xAD\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\xBD\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],

        ["\xF3\xB0\xAD\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xBD\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],

        ["\xF3\xB0\xAD\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xBD\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],

        ["\xF3\xB0\xAD\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\xBD\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],

        ["\xF3\xB0\xAD\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xBD\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],

        ["\xF3\xB0\xAD\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\xBD\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],

        ["\xF3\xB0\xAD\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xBD\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],

        ["\xF3\xB0\xAD\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xBD\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],

        ["\xF3\xB0\xAD\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xBD\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],

        ["\xF3\xB0\xAD\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\xBD\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],

        ["\xF3\xB0\xAD\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xBD\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],

        ["\xF3\xB0\xAD\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xBD\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],

        ["\xF3\xB0\xAD\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xBD\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],

        ["\xF3\xB0\xAD\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xBD\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],

        ["\xF3\xB0\xAD\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xBD\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],

        ["\xF3\xB0\xAD\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xBD\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],

        ["\xF3\xB0\xAD\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xBD\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],

        ["\xF3\xB0\xAD\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xBD\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],

        ["\xF3\xB0\xAD\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xBD\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],

        ["\xF3\xB0\xAD\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\xBD\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],

        ["\xF3\xB0\xAD\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xBD\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],

        ["\xF3\xB0\xAD\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xBD\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],

        ["\xF3\xB0\xAD\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\xBD\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],

        ["\xF3\xB0\xAD\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xBD\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],

        ["\xF3\xB0\xAD\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xBD\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],

        ["\xF3\xB0\xAD\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xBD\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],

        ["\xF3\xB0\xAD\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\xBD\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],

        ["\xF3\xB0\xAD\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xBD\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],

        ["\xF3\xB0\xAD\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xBD\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],

        ["\xF3\xB0\xAD\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xBD\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],

        ["\xF3\xB0\xAD\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xBD\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],

        ["\xF3\xB0\xAD\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xBD\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],

        ["\xF3\xB0\xAD\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\xBD\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],

        ["\xF3\xB0\xAD\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xBD\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],

        ["\xF3\xB0\xAD\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xBD\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],

        ["\xF3\xB0\xAD\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xBD\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],

        ["\xF3\xB0\xAD\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xBD\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],

        ["\xF3\xB0\xAD\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xBD\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],

        ["\xF3\xB0\xAD\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xBD\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],

        ["\xF3\xB0\xAD\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xBD\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],

        ["\xF3\xB0\xAD\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\xBD\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],

        ["\xF3\xB0\xAD\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\xBD\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],

        ["\xF3\xB0\xAD\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xBD\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],

        ["\xF3\xB0\xAD\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xBD\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],

        ["\xF3\xB0\xAD\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\xBD\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],

        ["\xF3\xB0\xAD\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\xBD\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],

        ["\xF3\xB0\xAE\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xBD\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],

        ["\xF3\xB0\xAE\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\xBD\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],

        ["\xF3\xB0\xAE\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xBD\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],

        ["\xF3\xB0\xAE\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xBD\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],

        ["\xF3\xB0\xAE\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xBD\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],

        ["\xF3\xB0\xAE\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xBD\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],

        ["\xF3\xB0\xAE\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\xBD\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],

        ["\xF3\xB0\xAE\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xBD\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],

        ["\xF3\xB0\xAE\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xBD\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],

        ["\xF3\xB0\xAE\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xBD\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],

        ["\xF3\xB0\xAE\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xBD\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],

        ["\xF3\xB0\xAE\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xBD\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],

        ["\xF3\xB0\xAE\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\xBD\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],

        ["\xF3\xB0\xAE\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xBD\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],

        ["\xF3\xB0\xAE\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xBD\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],

        ["\xF3\xB0\xAE\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\xBD\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],

        ["\xF3\xB0\xAE\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xBD\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],

        ["\xF3\xB0\xAE\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xBD\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],

        ["\xF3\xB0\xAE\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\xBD\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],

        ["\xF3\xB0\xAE\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\xBD\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],

        ["\xF3\xB0\xAE\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\xBD\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],

        ["\xF3\xB0\xAE\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xBD\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],

        ["\xF3\xB0\xAE\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xBD\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],

        ["\xF3\xB0\xAE\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xBD\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],

        ["\xF3\xB0\xAE\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xBD\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],

        ["\xF3\xB0\xAE\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xBD\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],

        ["\xF3\xB0\xAE\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xBD\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],

        ["\xF3\xB0\xAE\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xBD\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],

        ["\xF3\xB0\xAE\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xBD\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],

        ["\xF3\xB0\xAE\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\xBD\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],

        ["\xF3\xB0\xAE\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xBD\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],

        ["\xF3\xB0\xAE\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\xBD\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],

        ["\xF3\xB0\xAE\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\xBD\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],

        ["\xF3\xB0\xAE\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\xBD\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],

        ["\xF3\xB0\xAE\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\xBD\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],

        ["\xF3\xB0\xAE\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\xBD\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],

        ["\xF3\xB0\xAE\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\xBD\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],

        ["\xF3\xB0\xAE\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xBD\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],

        ["\xF3\xB0\xAE\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xBE\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],

        ["\xF3\xB0\xAE\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xBE\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],

        ["\xF3\xB0\xAE\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xBE\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],

        ["\xF3\xB0\xAE\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\xBE\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],

        ["\xF3\xB0\xAE\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xBE\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],

        ["\xF3\xB0\xAE\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xBE\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],

        ["\xF3\xB0\xAE\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xBE\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],

        ["\xF3\xB0\xAE\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xBE\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],

        ["\xF3\xB0\xAE\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\xBE\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],

        ["\xF3\xB0\xAE\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xBE\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],

        ["\xF3\xB0\xAE\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xBE\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],

        ["\xF3\xB0\xAE\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xBE\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],

        ["\xF3\xB0\xAE\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\xBE\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],

        ["\xF3\xB0\xAE\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xBE\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],

        ["\xF3\xB0\xAE\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\xBE\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],

        ["\xF3\xB0\xAE\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\xBE\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],

        ["\xF3\xB0\xAE\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xBE\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],

        ["\xF3\xB0\xAE\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\xBE\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],

        ["\xF3\xB0\xAE\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xBE\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],

        ["\xF3\xB0\xAE\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xBE\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],

        ["\xF3\xB0\xAE\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xBE\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],

        ["\xF3\xB0\xAE\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xBE\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],

        ["\xF3\xB0\xAE\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xBE\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],

        ["\xF3\xB0\xAE\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\xBE\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],

        ["\xF3\xB0\xAE\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xBE\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],

        ["\xF3\xB0\xAE\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xBE\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],

        ["\xF3\xB0\xAF\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xBE\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],

        ["\xF3\xB0\xAF\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xBE\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],

        ["\xF3\xB0\xAF\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xBE\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],

        ["\xF3\xB0\xAF\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xBE\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],

        ["\xF3\xB0\xAF\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\xBE\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],

        ["\xF3\xB0\xAF\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xBE\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],

        ["\xF3\xB0\xAF\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\xBE\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],

        ["\xF3\xB0\xAF\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xBE\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],

        ["\xF3\xB0\xAF\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xBE\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],

        ["\xF3\xB0\xAF\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xBE\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],

        ["\xF3\xB0\xAF\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\xBE\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],

        ["\xF3\xB0\xAF\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\xBE\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],

        ["\xF3\xB0\xAF\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xBE\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],

        ["\xF3\xB0\xAF\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xBE\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],

        ["\xF3\xB0\xAF\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xBE\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],

        ["\xF3\xB0\xAF\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xBE\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],

        ["\xF3\xB0\xAF\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\xBE\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],

        ["\xF3\xB0\xAF\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xBE\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],

        ["\xF3\xB0\xAF\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xBE\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],

        ["\xF3\xB0\xAF\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\xBE\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],

        ["\xF3\xB0\xAF\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xBE\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],

        ["\xF3\xB0\xAF\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\xBE\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],

        ["\xF3\xB0\xAF\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\xBE\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],

        ["\xF3\xB0\xAF\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xBE\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],

        ["\xF3\xB0\xAF\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\xBE\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],

        ["\xF3\xB0\xAF\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xBE\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],

        ["\xF3\xB0\xAF\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\xBE\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],

        ["\xF3\xB0\xAF\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\xBE\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],

        ["\xF3\xB0\xAF\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xBE\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],

        ["\xF3\xB0\xAF\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xBE\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],

        ["\xF3\xB0\xAF\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xBE\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],

        ["\xF3\xB0\xAF\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\xBE\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],

        ["\xF3\xB0\xAF\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xBE\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],

        ["\xF3\xB0\xAF\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xBE\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],

        ["\xF3\xB0\xAF\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xBE\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],

        ["\xF3\xB0\xAF\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\xBE\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],

        ["\xF3\xB0\xAF\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\xBE\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],

        ["\xF3\xB0\xAF\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xBE\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],

        ["\xF3\xB0\xAF\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\xBE\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],

        ["\xF3\xB0\xAF\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xBE\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],

        ["\xF3\xB0\xAF\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xBE\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],

        ["\xF3\xB0\xAF\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xBE\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],

        ["\xF3\xB0\xAF\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xBE\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],

        ["\xF3\xB0\xAF\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xBE\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],

        ["\xF3\xB0\xAF\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\xBE\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],

        ["\xF3\xB0\xAF\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xBE\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],

        ["\xF3\xB0\xAF\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\xBE\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],

        ["\xF3\xB0\xAF\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xBE\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],

        ["\xF3\xB0\xAF\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xBE\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],

        ["\xF3\xB0\xAF\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xBE\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],

        ["\xF3\xB0\xAF\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xBE\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],

        ["\xF3\xB0\xAF\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xBE\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],

        ["\xF3\xB0\xAF\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\xBE\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],

        ["\xF3\xB0\xAF\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xBE\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],

        ["\xF3\xB0\xAF\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xBE\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],

        ["\xF3\xB0\xAF\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\xBE\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],

        ["\xF3\xB0\xAF\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\xBE\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],

        ["\xF3\xB0\xAF\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\xBE\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],

        ["\xF3\xB0\xAF\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\xBE\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],

        ["\xF3\xB0\xAF\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\xBE\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],

        ["\xF3\xB0\xAF\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xBE\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],

        ["\xF3\xB0\xAF\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\xBE\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],

        ["\xF3\xB0\xAF\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xBE\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],

        ["\xF3\xB0\xAF\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\xBE\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],

        ["\xF3\xB0\xB0\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xBE\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],

        ["\xF3\xB0\xB0\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\xBE\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],

        ["\xF3\xB0\xB0\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\xBE\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],

        ["\xF3\xB0\xB0\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\xBE\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],

        ["\xF3\xB0\xB0\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\xBF\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],

        ["\xF3\xB0\xB0\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\xBF\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],

        ["\xF3\xB0\xB0\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xBF\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],

        ["\xF3\xB0\xB0\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xBF\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],

        ["\xF3\xB0\xB0\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xBF\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],

        ["\xF3\xB0\xB0\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\xBF\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],

        ["\xF3\xB0\xB0\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\xBF\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],

        ["\xF3\xB0\xB0\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xBF\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],

        ["\xF3\xB0\xB0\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xBF\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],

        ["\xF3\xB0\xB0\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xBF\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],

        ["\xF3\xB0\xB0\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xBF\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],

        ["\xF3\xB0\xB0\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xBF\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],

        ["\xF3\xB0\xB0\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xBF\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],

        ["\xF3\xB0\xB0\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xBF\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],

        ["\xF3\xB0\xB0\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\xBF\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],

        ["\xF3\xB0\xB0\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xBF\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],

        ["\xF3\xB0\xB0\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xBF\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],

        ["\xF3\xB0\xB0\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xBF\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],

        ["\xF3\xB0\xB0\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xBF\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],

        ["\xF3\xB0\xB0\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\xBF\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],

        ["\xF3\xB0\xB0\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\xBF\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],

        ["\xF3\xB0\xB0\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\xBF\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],

        ["\xF3\xB0\xB0\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xBF\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],

        ["\xF3\xB0\xB0\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\xBF\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],

        ["\xF3\xB0\xB0\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xBF\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],

        ["\xF3\xB0\xB0\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xBF\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],

        ["\xF3\xB0\xB0\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xBF\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],

        ["\xF3\xB0\xB0\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xBF\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],

        ["\xF3\xB0\xB0\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xBF\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],

        ["\xF3\xB0\xB0\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\xBF\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],

        ["\xF3\xB0\xB0\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xBF\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],

        ["\xF3\xB0\xB0\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xBF\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],

        ["\xF3\xB0\xB0\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xBF\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],

        ["\xF3\xB0\xB0\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\xBF\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],

        ["\xF3\xB0\xB0\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xBF\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],

        ["\xF3\xB0\xB0\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xBF\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],

        ["\xF3\xB0\xB0\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xBF\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],

        ["\xF3\xB0\xB0\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xBF\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],

        ["\xF3\xB0\xB0\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\xBF\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],

        ["\xF3\xB0\xB0\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xBF\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],

        ["\xF3\xB0\xB0\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\xBF\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],

        ["\xF3\xB0\xB0\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xBF\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],

        ["\xF3\xB0\xB0\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\xBF\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],

        ["\xF3\xB0\xB0\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xBF\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],

        ["\xF3\xB0\xB0\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\xBF\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],

        ["\xF3\xB0\xB0\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xBF\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],

        ["\xF3\xB0\xB0\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xBF\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],

        ["\xF3\xB0\xB0\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\xBF\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],

        ["\xF3\xB0\xB0\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xBF\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],

        ["\xF3\xB0\xB0\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xBF\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],

        ["\xF3\xB0\xB0\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\xBF\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],

        ["\xF3\xB0\xB0\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\xBF\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],

        ["\xF3\xB0\xB0\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\xBF\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],

        ["\xF3\xB0\xB0\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\xBF\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],

        ["\xF3\xB0\xB0\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xBF\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],

        ["\xF3\xB0\xB0\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xBF\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],

        ["\xF3\xB0\xB0\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF0\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],

        ["\xF3\xB0\xB0\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\xBF\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],

        ["\xF3\xB0\xB0\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xBF\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],

        ["\xF3\xB0\xB0\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xBF\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],

        ["\xF3\xB0\xB1\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xBF\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],

        ["\xF3\xB0\xB1\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\xBF\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],

        ["\xF3\xB0\xB1\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xBF\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],

        ["\xF3\xB0\xB1\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xBF\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],

        ["\xF3\xB0\xB1\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\xBF\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],

        ["\xF3\xB0\xB1\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\xBF\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],

        ["\xF3\xB0\xB1\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xBF\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],

        ["\xF3\xB0\xB1\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xBF\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],

        ["\xF3\xB0\xB1\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xBF\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],

        ["\xF3\xB0\xB1\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xBF\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],

        ["\xF3\xB0\xB1\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xBF\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],

        ["\xF3\xB0\xB1\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xBF\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],

        ["\xF3\xB0\xB1\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xBF\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],

        ["\xF3\xB0\xB1\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xBF\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],

        ["\xF3\xB0\xB1\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\xBF\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],

        ["\xF3\xB0\xB1\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xBF\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],

        ["\xF3\xB0\xB1\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\xBF\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],

        ["\xF3\xB0\xB1\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\xBF\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],

        ["\xF3\xB0\xB1\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xBF\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],

        ["\xF3\xB0\xB1\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xBF\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],

        ["\xF3\xB0\xB1\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\xBF\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],

        ["\xF3\xB0\xB1\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xBF\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],

        ["\xF3\xB0\xB1\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\xBF\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],

        ["\xF3\xB0\xB1\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xBF\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],

        ["\xF3\xB0\xB1\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\xBF\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],

        ["\xF3\xB0\xB1\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\xBF\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],

        ["\xF3\xB0\xB1\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\xBF\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],

        ["\xF3\xB0\xB1\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xBF\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],

        ["\xF3\xB0\xB1\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xBF\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],

        ["\xF3\xB0\xB1\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xBF\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],

        ["\xF3\xB0\xB1\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xBF\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],

        ["\xF3\xB0\xB1\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xBF\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],

        ["\xF3\xB0\xB1\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xBF\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],

        ["\xF3\xB0\xB1\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xBF\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],

        ["\xF3\xB0\xB1\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\xC0\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],

        ["\xF3\xB0\xB1\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\xC0\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],

        ["\xF3\xB0\xB1\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xC0\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],

        ["\xF3\xB0\xB1\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\xC0\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],

        ["\xF3\xB0\xB1\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xC0\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],

        ["\xF3\xB0\xB1\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xC0\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],

        ["\xF3\xB0\xB1\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xC0\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],

        ["\xF3\xB0\xB1\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xC0\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],

        ["\xF3\xB0\xB1\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xC0\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],

        ["\xF3\xB0\xB1\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xC0\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],

        ["\xF3\xB0\xB1\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xC0\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],

        ["\xF3\xB0\xB1\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\xC0\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],

        ["\xF3\xB0\xB1\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xC0\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],

        ["\xF3\xB0\xB1\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xC0\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],

        ["\xF3\xB0\xB1\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xC0\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],

        ["\xF3\xB0\xB1\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xC0\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],

        ["\xF3\xB0\xB1\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xC0\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],

        ["\xF3\xB0\xB1\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xC0\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],

        ["\xF3\xB0\xB1\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xC0\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],

        ["\xF3\xB0\xB1\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\xC0\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],

        ["\xF3\xB0\xB1\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xC0\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],

        ["\xF3\xB0\xB1\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xC0\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],

        ["\xF3\xB0\xB1\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\xC0\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],

        ["\xF3\xB0\xB1\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\xC0\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],

        ["\xF3\xB0\xB1\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xC0\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],

        ["\xF3\xB0\xB1\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xC0\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],

        ["\xF3\xB0\xB1\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xC0\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],

        ["\xF3\xB0\xB1\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xC0\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],

        ["\xF3\xB0\xB1\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xC0\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],

        ["\xF3\xB0\xB1\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xC0\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],

        ["\xF3\xB0\xB2\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xC0\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],

        ["\xF3\xB0\xB2\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\xC0\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],

        ["\xF3\xB0\xB2\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\xC0\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],

        ["\xF3\xB0\xB2\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\xC0\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],

        ["\xF3\xB0\xB2\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\xC0\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],

        ["\xF3\xB0\xB2\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xC0\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],

        ["\xF3\xB0\xB2\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xC0\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],

        ["\xF3\xB0\xB2\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xC0\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],

        ["\xF3\xB0\xB2\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xC0\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],

        ["\xF3\xB0\xB2\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\xC0\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],

        ["\xF3\xB0\xB2\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xC0\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],

        ["\xF3\xB0\xB2\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\xC0\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],

        ["\xF3\xB0\xB2\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xC0\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],

        ["\xF3\xB0\xB2\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\xC0\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],

        ["\xF3\xB0\xB2\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xC0\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],

        ["\xF3\xB0\xB2\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\xC0\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],

        ["\xF3\xB0\xB2\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xC0\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],

        ["\xF3\xB0\xB2\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xC0\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],

        ["\xF3\xB0\xB2\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\xC0\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],

        ["\xF3\xB0\xB2\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xC0\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],

        ["\xF3\xB0\xB2\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\xC0\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],

        ["\xF3\xB0\xB2\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xC0\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],

        ["\xF3\xB0\xB2\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xC0\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],

        ["\xF3\xB0\xB2\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xC0\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],

        ["\xF3\xB0\xB2\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\xC0\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],

        ["\xF3\xB0\xB2\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xC0\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],

        ["\xF3\xB0\xB2\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xC0\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],

        ["\xF3\xB0\xB2\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\xC0\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],

        ["\xF3\xB0\xB2\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\xC0\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],

        ["\xF3\xB0\xB2\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xC0\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],

        ["\xF3\xB0\xB2\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xC0\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],

        ["\xF3\xB0\xB2\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xC0\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],

        ["\xF3\xB0\xB2\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\xC0\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],

        ["\xF3\xB0\xB2\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xC0\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],

        ["\xF3\xB0\xB2\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xC0\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],

        ["\xF3\xB0\xB2\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xC0\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],

        ["\xF3\xB0\xB2\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xC0\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],

        ["\xF3\xB0\xB2\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xC0\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],

        ["\xF3\xB0\xB2\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xC0\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],

        ["\xF3\xB0\xB2\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\xC0\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],

        ["\xF3\xB0\xB2\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xC0\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],

        ["\xF3\xB0\xB2\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xC0\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],

        ["\xF3\xB0\xB2\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xC0\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],

        ["\xF3\xB0\xB2\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xC0\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],

        ["\xF3\xB0\xB2\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xC0\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],

        ["\xF3\xB0\xB2\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\xC0\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],

        ["\xF3\xB0\xB2\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xC0\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],

        ["\xF3\xB0\xB2\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\xC0\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],

        ["\xF3\xB0\xB2\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\xC0\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],

        ["\xF3\xB0\xB2\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xC0\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],

        ["\xF3\xB0\xB2\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xC0\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],

        ["\xF3\xB0\xB2\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xC0\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],

        ["\xF3\xB0\xB2\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xC0\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],

        ["\xF3\xB0\xB2\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xC0\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],

        ["\xF3\xB0\xB2\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xC0\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],

        ["\xF3\xB0\xB2\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\xC0\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],

        ["\xF3\xB0\xB2\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xC0\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],

        ["\xF3\xB0\xB2\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xC0\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],

        ["\xF3\xB0\xB2\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\xC0\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],

        ["\xF3\xB0\xB2\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xC0\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],

        ["\xF3\xB0\xB2\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xC0\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],

        ["\xF3\xB0\xB2\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xC0\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],

        ["\xF3\xB0\xB2\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\xC0\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],

        ["\xF3\xB0\xB2\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xC0\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],

        ["\xF3\xB0\xB3\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xC1\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],

        ["\xF3\xB0\xB3\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xC1\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],

        ["\xF3\xB0\xB3\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xC1\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],

        ["\xF3\xB0\xB3\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xC1\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],

        ["\xF3\xB0\xB3\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xC1\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],

        ["\xF3\xB0\xB3\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xC1\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],

        ["\xF3\xB0\xB3\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xC1\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],

        ["\xF3\xB0\xB3\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xEC\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],

        ["\xF3\xB0\xB3\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xC1\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],

        ["\xF3\xB0\xB3\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xC1\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],

        ["\xF3\xB0\xB3\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xC1\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],

        ["\xF3\xB0\xB3\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xC1\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],

        ["\xF3\xB0\xB3\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xC1\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],

        ["\xF3\xB0\xB3\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xC1\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],

        ["\xF3\xB0\xB3\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xC1\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],

        ["\xF3\xB0\xB3\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xC1\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],

        ["\xF3\xB0\xB3\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xC1\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],

        ["\xF3\xB0\xB3\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xC1\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],

        ["\xF3\xB0\xB3\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xC1\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],

        ["\xF3\xB0\xB3\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xC1\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],

        ["\xF3\xB0\xB3\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xC1\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],

        ["\xF3\xB0\xB3\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xC1\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],

        ["\xF3\xB0\xB3\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xC1\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],

        ["\xF3\xB0\xB3\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xC1\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],

        ["\xF3\xB0\xB3\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xC1\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],

        ["\xF3\xB0\xB3\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xC1\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],

        ["\xF3\xB0\xB3\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xC1\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],

        ["\xF3\xB0\xB3\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xC1\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],

        ["\xF3\xB0\xB3\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xC1\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],

        ["\xF3\xB0\xB3\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xC1\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],

        ["\xF3\xB0\xB3\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xC1\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],

        ["\xF3\xB0\xB3\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xC1\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],

        ["\xF3\xB0\xB3\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xC1\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],

        ["\xF3\xB0\xB3\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xC1\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],

        ["\xF3\xB0\xB3\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xC1\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],

        ["\xF3\xB0\xB3\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xC1\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],

        ["\xF3\xB0\xB3\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xC1\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],

        ["\xF3\xB0\xB3\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xC1\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],

        ["\xF3\xB0\xB3\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xC1\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],

        ["\xF3\xB0\xB3\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xC1\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],

        ["\xF3\xB0\xB3\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xC1\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],

        ["\xF3\xB0\xB3\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xC1\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],

        ["\xF3\xB0\xB3\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xC1\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],

        ["\xF3\xB0\xB3\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xC1\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],

        ["\xF3\xB0\xB3\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xC1\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],

        ["\xF3\xB0\xB3\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xC1\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],

        ["\xF3\xB0\xB3\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xC1\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],

        ["\xF3\xB0\xB3\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xC1\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],

        ["\xF3\xB0\xB3\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xC1\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],

        ["\xF3\xB0\xB3\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xC1\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],

        ["\xF3\xB0\xB3\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xC1\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],

        ["\xF3\xB0\xB3\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xC1\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],

        ["\xF3\xB0\xB3\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xC1\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],

        ["\xF3\xB0\xB3\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xC1\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],

        ["\xF3\xB0\xB3\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xC1\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],

        ["\xF3\xB0\xB3\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xC1\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],

        ["\xF3\xB0\xB3\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xC1\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],

        ["\xF3\xB0\xB3\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xC1\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],

        ["\xF3\xB0\xB3\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xC1\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],

        ["\xF3\xB0\xB3\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xC1\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],

        ["\xF3\xB0\xB3\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xC1\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],

        ["\xF3\xB0\xB3\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xC1\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],

        ["\xF3\xB0\xB3\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xC1\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],

        ["\xF3\xB0\xB3\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xC1\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],

        ["\xF3\xB0\xB4\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xC1\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],

        ["\xF3\xB0\xB4\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xC1\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],

        ["\xF3\xB0\xB4\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xC1\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],

        ["\xF3\xB0\xB4\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xC1\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],

        ["\xF3\xB0\xB4\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xC1\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],

        ["\xF3\xB0\xB4\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xC1\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],

        ["\xF3\xB0\xB4\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xC1\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],

        ["\xF3\xB0\xB4\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xC1\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],

        ["\xF3\xB0\xB4\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xC1\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],

        ["\xF3\xB0\xB4\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xC1\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],

        ["\xF3\xB0\xB4\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xC1\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],

        ["\xF3\xB0\xB4\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xC1\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],

        ["\xF3\xB0\xB4\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xC1\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],

        ["\xF3\xB0\xB4\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xC1\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],

        ["\xF3\xB0\xB4\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xC1\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],

        ["\xF3\xB0\xB4\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xC1\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],

        ["\xF3\xB0\xB4\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xC1\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],

        ["\xF3\xB0\xB4\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xC1\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],

        ["\xF3\xB0\xB4\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xC1\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],

        ["\xF3\xB0\xB4\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xC1\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],

        ["\xF3\xB0\xB4\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xC1\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],

        ["\xF3\xB0\xB4\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xC1\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],

        ["\xF3\xB0\xB4\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xC1\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],

        ["\xF3\xB0\xB4\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xC1\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],

        ["\xF3\xB0\xB4\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xC1\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],

        ["\xF3\xB0\xB4\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xC1\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],

        ["\xF3\xB0\xB4\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xC1\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],

        ["\xF3\xB0\xB4\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xC1\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],

        ["\xF3\xB0\xB4\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xC1\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],

        ["\xF3\xB0\xB4\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xC1\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],

        ["\xF3\xB0\xB4\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xC2\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],

        ["\xF3\xB0\xB4\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xC2\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],

        ["\xF3\xB0\xB4\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xC2\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],

        ["\xF3\xB0\xB4\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xC2\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],

        ["\xF3\xB0\xB4\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xC2\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],

        ["\xF3\xB0\xB4\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xC2\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],

        ["\xF3\xB0\xB4\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xC2\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],

        ["\xF3\xB0\xB4\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xC2\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],

        ["\xF3\xB0\xB4\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xC2\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],

        ["\xF3\xB0\xB4\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xC2\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],

        ["\xF3\xB0\xB4\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xC2\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],

        ["\xF3\xB0\xB4\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xC2\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],

        ["\xF3\xB0\xB4\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xC2\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],

        ["\xF3\xB0\xB4\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xC2\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],

        ["\xF3\xB0\xB4\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xC2\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],

        ["\xF3\xB0\xB4\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],

        ["\xF3\xB0\xB4\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xC2\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],

        ["\xF3\xB0\xB4\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xC2\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],

        ["\xF3\xB0\xB4\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xC2\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],

        ["\xF3\xB0\xB4\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xC2\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],

        ["\xF3\xB0\xB4\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xC2\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],

        ["\xF3\xB0\xB4\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xC2\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],

        ["\xF3\xB0\xB4\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xC2\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],

        ["\xF3\xB0\xB4\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xC2\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],

        ["\xF3\xB0\xB4\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xC2\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],

        ["\xF3\xB0\xB4\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xC2\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],

        ["\xF3\xB0\xB4\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xC2\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],

        ["\xF3\xB0\xB4\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xC2\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],

        ["\xF3\xB0\xB4\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xC2\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],

        ["\xF3\xB0\xB4\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xC2\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],

        ["\xF3\xB0\xB4\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xC2\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],

        ["\xF3\xB0\xB4\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xC2\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],

        ["\xF3\xB0\xB4\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xC2\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],

        ["\xF3\xB0\xB4\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xC2\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],

        ["\xF3\xB0\xB5\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xC2\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],

        ["\xF3\xB0\xB5\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xC2\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],

        ["\xF3\xB0\xB5\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xC2\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],

        ["\xF3\xB0\xB5\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xC2\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],

        ["\xF3\xB0\xB5\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xC2\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],

        ["\xF3\xB0\xB5\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xC2\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],

        ["\xF3\xB0\xB5\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xC2\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],

        ["\xF3\xB0\xB5\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xC2\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],

        ["\xF3\xB0\xB5\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xC2\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],

        ["\xF3\xB0\xB5\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xC2\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],

        ["\xF3\xB0\xB5\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xC2\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],

        ["\xF3\xB0\xB5\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xC2\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],

        ["\xF3\xB0\xB5\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xC2\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],

        ["\xF3\xB0\xB5\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xC2\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],

        ["\xF3\xB0\xB5\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xC2\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],

        ["\xF3\xB0\xB5\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xC2\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],

        ["\xF3\xB0\xB5\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xC2\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],

        ["\xF3\xB0\xB5\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xC2\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],

        ["\xF3\xB0\xB5\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xC2\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],

        ["\xF3\xB0\xB5\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xC2\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],

        ["\xF3\xB0\xB5\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xC2\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],

        ["\xF3\xB0\xB5\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xC2\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],

        ["\xF3\xB0\xB5\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xC2\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],

        ["\xF3\xB0\xB5\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xC2\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],

        ["\xF3\xB0\xB5\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xC2\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],

        ["\xF3\xB0\xB5\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xC2\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],

        ["\xF3\xB0\xB5\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xC2\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],

        ["\xF3\xB0\xB5\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xC2\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],

        ["\xF3\xB0\xB5\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xC2\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],

        ["\xF3\xB0\xB5\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xC2\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],

        ["\xF3\xB0\xB5\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xC2\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],

        ["\xF3\xB0\xB5\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xC2\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],

        ["\xF3\xB0\xB5\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xC2\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],

        ["\xF3\xB0\xB5\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xC2\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],

        ["\xF3\xB0\xB5\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xC2\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],

        ["\xF3\xB0\xB5\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xC2\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],

        ["\xF3\xB0\xB5\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xC2\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],

        ["\xF3\xB0\xB5\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xC2\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],

        ["\xF3\xB0\xB5\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xC2\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],

        ["\xF3\xB0\xB5\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xC2\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],

        ["\xF3\xB0\xB5\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xC2\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],

        ["\xF3\xB0\xB5\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xC2\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],

        ["\xF3\xB0\xB5\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xC2\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],

        ["\xF3\xB0\xB5\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xC2\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],

        ["\xF3\xB0\xB5\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xC2\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],

        ["\xF3\xB0\xB5\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xC2\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],

        ["\xF3\xB0\xB5\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xC2\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],

        ["\xF3\xB0\xB5\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xC2\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],

        ["\xF3\xB0\xB5\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xC2\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],

        ["\xF3\xB0\xB5\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xC2\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],

        ["\xF3\xB0\xB5\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xC2\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],

        ["\xF3\xB0\xB5\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xC2\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],

        ["\xF3\xB0\xB5\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xC2\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],

        ["\xF3\xB0\xB5\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xC2\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],

        ["\xF3\xB0\xB5\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xC2\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],

        ["\xF3\xB0\xB5\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xC2\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],

        ["\xF3\xB0\xB5\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xC2\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],

        ["\xF3\xB0\xB5\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xC2\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],

        ["\xF3\xB0\xB5\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xC2\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],

        ["\xF3\xB0\xB5\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xC2\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],

        ["\xF3\xB0\xB5\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xC3\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],

        ["\xF3\xB0\xB5\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xC3\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],

        ["\xF3\xB0\xB5\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xC3\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],

        ["\xF3\xB0\xB5\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xC3\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],

        ["\xF3\xB0\xB6\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xC3\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],

        ["\xF3\xB0\xB6\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xC3\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],

        ["\xF3\xB0\xB6\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xC3\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],

        ["\xF3\xB0\xB6\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xC3\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],

        ["\xF3\xB0\xB6\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xC3\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],

        ["\xF3\xB0\xB6\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xC3\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],

        ["\xF3\xB0\xB6\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xC3\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],

        ["\xF3\xB0\xB6\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xC3\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],

        ["\xF3\xB0\xB6\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xC3\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],

        ["\xF3\xB0\xB6\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xC3\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],

        ["\xF3\xB0\xB6\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xC3\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],

        ["\xF3\xB0\xB6\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xC3\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],

        ["\xF3\xB0\xB6\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xC3\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],

        ["\xF3\xB0\xB6\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xC3\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],

        ["\xF3\xB0\xB6\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xC3\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],

        ["\xF3\xB0\xB6\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xC3\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],

        ["\xF3\xB0\xB6\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xC3\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],

        ["\xF3\xB0\xB6\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xC3\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],

        ["\xF3\xB0\xB6\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xC3\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],

        ["\xF3\xB0\xB6\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xC3\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],

        ["\xF3\xB0\xB6\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xC3\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],

        ["\xF3\xB0\xB6\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xC3\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],

        ["\xF3\xB0\xB6\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xC3\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],

        ["\xF3\xB0\xB6\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xC3\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],

        ["\xF3\xB0\xB6\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xC3\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],

        ["\xF3\xB0\xB6\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xC3\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],

        ["\xF3\xB0\xB6\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xC3\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],

        ["\xF3\xB0\xB6\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xC3\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],

        ["\xF3\xB0\xB6\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xC3\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],

        ["\xF3\xB0\xB6\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xC3\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],

        ["\xF3\xB0\xB6\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xC3\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],

        ["\xF3\xB0\xB6\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xC3\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],

        ["\xF3\xB0\xB6\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xC3\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],

        ["\xF3\xB0\xB6\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xC3\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],

        ["\xF3\xB0\xB6\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xC3\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],

        ["\xF3\xB0\xB6\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xC3\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],

        ["\xF3\xB0\xB6\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xC3\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],

        ["\xF3\xB0\xB6\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xC3\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],

        ["\xF3\xB0\xB6\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xC3\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],

        ["\xF3\xB0\xB6\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xC3\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],

        ["\xF3\xB0\xB6\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xC3\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],

        ["\xF3\xB0\xB6\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xC3\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],

        ["\xF3\xB0\xB6\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xC3\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],

        ["\xF3\xB0\xB6\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xC3\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],

        ["\xF3\xB0\xB6\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xC3\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],

        ["\xF3\xB0\xB6\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xC3\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],

        ["\xF3\xB0\xB6\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xC3\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],

        ["\xF3\xB0\xB6\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xC3\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],

        ["\xF3\xB0\xB6\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xC3\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],

        ["\xF3\xB0\xB6\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xC3\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],

        ["\xF3\xB0\xB6\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xC3\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],

        ["\xF3\xB0\xB6\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xC3\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],

        ["\xF3\xB0\xB6\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xC3\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],

        ["\xF3\xB0\xB6\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xC3\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],

        ["\xF3\xB0\xB6\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xC3\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],

        ["\xF3\xB0\xB6\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xC3\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],

        ["\xF3\xB0\xB6\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xC3\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],

        ["\xF3\xB0\xB6\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xC3\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],

        ["\xF3\xB0\xB6\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xC3\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],

        ["\xF3\xB0\xB6\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xC3\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],

        ["\xF3\xB0\xB6\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xC3\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],

        ["\xF3\xB0\xB6\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xC3\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],

        ["\xF3\xB0\xB6\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xC3\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],

        ["\xF3\xB0\xB6\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xC3\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],

        ["\xF3\xB0\xB7\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xC3\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],

        ["\xF3\xB0\xB7\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xC3\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],

        ["\xF3\xB0\xB7\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xC3\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],

        ["\xF3\xB0\xB7\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xC3\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],

        ["\xF3\xB0\xB7\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xC3\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],

        ["\xF3\xB0\xB7\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xC3\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],

        ["\xF3\xB0\xB7\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xC3\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],

        ["\xF3\xB0\xB7\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xC3\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],

        ["\xF3\xB0\xB7\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xC3\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],

        ["\xF3\xB0\xB7\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xC3\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],

        ["\xF3\xB0\xB7\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xC3\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],

        ["\xF3\xB0\xB7\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xC3\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],

        ["\xF3\xB0\xB7\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xC3\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],

        ["\xF3\xB0\xB7\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xC3\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],

        ["\xF3\xB0\xB7\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xC3\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],

        ["\xF3\xB0\xB7\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xC3\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],

        ["\xF3\xB0\xB7\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xC3\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],

        ["\xF3\xB0\xB7\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xC3\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],

        ["\xF3\xB0\xB7\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xC3\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],

        ["\xF3\xB0\xB7\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xC3\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],

        ["\xF3\xB0\xB7\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xC3\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],

        ["\xF3\xB0\xB7\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xC3\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],

        ["\xF3\xB0\xB7\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xC3\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],

        ["\xF3\xB0\xB7\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xC3\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],

        ["\xF3\xB0\xB7\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xC3\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],

        ["\xF3\xB0\xB7\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xC3\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],

        ["\xF3\xB0\xB7\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xC4\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],

        ["\xF3\xB0\xB7\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xC4\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],

        ["\xF3\xB0\xB7\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xC4\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],

        ["\xF3\xB0\xB7\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xC4\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],

        ["\xF3\xB0\xB7\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xC4\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],

        ["\xF3\xB0\xB7\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xC4\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],

        ["\xF3\xB0\xB7\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xC4\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],

        ["\xF3\xB0\xB7\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xC4\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],

        ["\xF3\xB0\xB7\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xC4\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],

        ["\xF3\xB0\xB7\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xC4\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],

        ["\xF3\xB0\xB7\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xC4\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],

        ["\xF3\xB0\xB7\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xC4\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],

        ["\xF3\xB0\xB7\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xC4\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],

        ["\xF3\xB0\xB7\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xC4\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],

        ["\xF3\xB0\xB7\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xC4\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],

        ["\xF3\xB0\xB7\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xC4\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],

        ["\xF3\xB0\xB7\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xC4\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],

        ["\xF3\xB0\xB7\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xC4\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],

        ["\xF3\xB0\xB7\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xC4\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],

        ["\xF3\xB0\xB7\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xC4\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],

        ["\xF3\xB0\xB7\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xC4\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],

        ["\xF3\xB0\xB7\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xC4\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],

        ["\xF3\xB0\xB7\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xC4\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],

        ["\xF3\xB0\xB7\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xC4\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],

        ["\xF3\xB0\xB7\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xC4\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],

        ["\xF3\xB0\xB7\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xC4\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],

        ["\xF3\xB0\xB7\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xC4\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],

        ["\xF3\xB0\xB7\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xC4\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],

        ["\xF3\xB0\xB7\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xC4\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],

        ["\xF3\xB0\xB7\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xC4\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],

        ["\xF3\xB0\xB7\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xC4\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],

        ["\xF3\xB0\xB7\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xC4\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],

        ["\xF3\xB0\xB7\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xC4\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],

        ["\xF3\xB0\xB7\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xC4\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],

        ["\xF3\xB0\xB7\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xC4\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],

        ["\xF3\xB0\xB7\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xC4\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],

        ["\xF3\xB0\xB7\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xC4\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],

        ["\xF3\xB0\xB7\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xC4\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],

        ["\xF3\xB0\xB8\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xC4\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],

        ["\xF3\xB0\xB8\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xC4\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],

        ["\xF3\xB0\xB8\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xC4\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],

        ["\xF3\xB0\xB8\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xC4\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],

        ["\xF3\xB0\xB8\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xC4\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],

        ["\xF3\xB0\xB8\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xC4\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],

        ["\xF3\xB0\xB8\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\x47\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],

        ["\xF3\xB0\xB8\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xC4\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],

        ["\xF3\xB0\xB8\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xC4\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],

        ["\xF3\xB0\xB8\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xC4\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],

        ["\xF3\xB0\xB8\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xC4\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],

        ["\xF3\xB0\xB8\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xC4\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],

        ["\xF3\xB0\xB8\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xC4\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],

        ["\xF3\xB0\xB8\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xC4\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],

        ["\xF3\xB0\xB8\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xC4\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],

        ["\xF3\xB0\xB8\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xC4\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],

        ["\xF3\xB0\xB8\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xC4\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],

        ["\xF3\xB0\xB8\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xC4\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],

        ["\xF3\xB0\xB8\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xC4\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],

        ["\xF3\xB0\xB8\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xC4\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],

        ["\xF3\xB0\xB8\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xD4\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],

        ["\xF3\xB0\xB8\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xC4\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],

        ["\xF3\xB0\xB8\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xC4\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],

        ["\xF3\xB0\xB8\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xC4\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],

        ["\xF3\xB0\xB8\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xC4\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],

        ["\xF3\xB0\xB8\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xC4\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],

        ["\xF3\xB0\xB8\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xC4\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],

        ["\xF3\xB0\xB8\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xC4\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],

        ["\xF3\xB0\xB8\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xC4\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],

        ["\xF3\xB0\xB8\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xC4\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],

        ["\xF3\xB0\xB8\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xC4\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],

        ["\xF3\xB0\xB8\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xC4\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],

        ["\xF3\xB0\xB8\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xC4\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],

        ["\xF3\xB0\xB8\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],

        ["\xF3\xB0\xB8\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xC4\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],

        ["\xF3\xB0\xB8\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xC4\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],

        ["\xF3\xB0\xB8\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xC4\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],

        ["\xF3\xB0\xB8\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xC4\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],

        ["\xF3\xB0\xB8\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xC4\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],

        ["\xF3\xB0\xB8\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xC4\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],

        ["\xF3\xB0\xB8\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xC4\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],

        ["\xF3\xB0\xB8\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xC4\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],

        ["\xF3\xB0\xB8\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xC4\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],

        ["\xF3\xB0\xB8\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xC4\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],

        ["\xF3\xB0\xB8\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xC4\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],

        ["\xF3\xB0\xB8\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xC4\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],

        ["\xF3\xB0\xB8\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xC4\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],

        ["\xF3\xB0\xB8\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xC4\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],

        ["\xF3\xB0\xB8\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xC4\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],

        ["\xF3\xB0\xB8\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xC4\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],

        ["\xF3\xB0\xB8\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xC4\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],

        ["\xF3\xB0\xB8\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xC4\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],

        ["\xF3\xB0\xB8\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xC4\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],

        ["\xF3\xB0\xB8\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xC4\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],

        ["\xF3\xB0\xB8\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xC4\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],

        ["\xF3\xB0\xB8\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xC4\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],

        ["\xF3\xB0\xB8\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xC5\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],

        ["\xF3\xB0\xB8\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xC5\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],

        ["\xF3\xB0\xB8\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xC5\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],

        ["\xF3\xB0\xB8\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xC5\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],

        ["\xF3\xB0\xB8\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xC5\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],

        ["\xF3\xB0\xB8\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xC5\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],

        ["\xF3\xB0\xB8\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xC5\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],

        ["\xF3\xB0\xB8\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xC5\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],

        ["\xF3\xB0\xB9\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xC5\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],

        ["\xF3\xB0\xB9\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xC5\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],

        ["\xF3\xB0\xB9\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xC5\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],

        ["\xF3\xB0\xB9\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xC5\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],

        ["\xF3\xB0\xB9\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xC5\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],

        ["\xF3\xB0\xB9\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xC5\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],

        ["\xF3\xB0\xB9\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xC5\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],

        ["\xF3\xB0\xB9\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xC5\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],

        ["\xF3\xB0\xB9\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xC5\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],

        ["\xF3\xB0\xB9\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xC5\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],

        ["\xF3\xB0\xB9\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xC5\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],

        ["\xF3\xB0\xB9\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xC5\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],

        ["\xF3\xB0\xB9\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xC5\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],

        ["\xF3\xB0\xB9\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\x47\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],

        ["\xF3\xB0\xB9\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xC5\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],

        ["\xF3\xB0\xB9\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xC5\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],

        ["\xF3\xB0\xB9\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xC5\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],

        ["\xF3\xB0\xB9\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xC5\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],

        ["\xF3\xB0\xB9\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xC5\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],

        ["\xF3\xB0\xB9\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xC5\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],

        ["\xF3\xB0\xB9\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xC5\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],

        ["\xF3\xB0\xB9\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xC5\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],

        ["\xF3\xB0\xB9\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xFC"],
        ["\x6C\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],

        ["\xF3\xB0\xB9\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xC5\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],

        ["\xF3\xB0\xB9\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xC5\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],

        ["\xF3\xB0\xB9\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xC5\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],

        ["\xF3\xB0\xB9\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xC5\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],

        ["\xF3\xB0\xB9\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xC5\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],

        ["\xF3\xB0\xB9\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xC5\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],

        ["\xF3\xB0\xB9\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xC5\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],

        ["\xF3\xB0\xB9\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xC5\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],

        ["\xF3\xB0\xB9\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xC5\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],

        ["\xF3\xB0\xB9\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xC5\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],

        ["\xF3\xB0\xB9\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xC5\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],

        ["\xF3\xB0\xB9\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xC5\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],

        ["\xF3\xB0\xB9\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xC5\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],

        ["\xF3\xB0\xB9\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xC5\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],

        ["\xF3\xB0\xB9\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xC5\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],

        ["\xF3\xB0\xB9\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xC5\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],

        ["\xF3\xB0\xB9\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xC5\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],

        ["\xF3\xB0\xB9\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xC5\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],

        ["\xF3\xB0\xB9\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xC5\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],

        ["\xF3\xB0\xB9\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xC5\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],

        ["\xF3\xB0\xB9\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xC5\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],

        ["\xF3\xB0\xB9\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xC5\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],

        ["\xF3\xB0\xB9\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xC5\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],

        ["\xF3\xB0\xB9\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],

        ["\xF3\xB0\xB9\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xC5\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],

        ["\xF3\xB0\xB9\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xC5\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],

        ["\xF3\xB0\xB9\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xC5\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],

        ["\xF3\xB0\xB9\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xC5\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],

        ["\xF3\xB0\xB9\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xC5\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],

        ["\xF3\xB0\xB9\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xC5\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],

        ["\xF3\xB0\xB9\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xC5\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],

        ["\xF3\xB0\xB9\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xC5\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],

        ["\xF3\xB0\xB9\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xC5\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],

        ["\xF3\xB0\xB9\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xC5\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],

        ["\xF3\xB0\xB9\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xC5\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],

        ["\xF3\xB0\xB9\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xC5\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],

        ["\xF3\xB0\xB9\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xC5\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],

        ["\xF3\xB0\xB9\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xC5\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],

        ["\xF3\xB0\xB9\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xC5\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],

        ["\xF3\xB0\xB9\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xC5\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],

        ["\xF3\xB0\xB9\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xC5\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],

        ["\xF3\xB0\xBA\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xC5\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],

        ["\xF3\xB0\xBA\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xC5\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],

        ["\xF3\xB0\xBA\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xC5\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],

        ["\xF3\xB0\xBA\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xC5\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],

        ["\xF3\xB0\xBA\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xC5\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],

        ["\xF3\xB0\xBA\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\xDB\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],

        ["\xF3\xB0\xBA\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xC5\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],

        ["\xF3\xB0\xBA\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xC5\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],

        ["\xF3\xB0\xBA\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xC5\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],

        ["\xF3\xB0\xBA\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xC5\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],

        ["\xF3\xB0\xBA\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xDE\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],

        ["\xF3\xB0\xBA\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xC5\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],

        ["\xF3\xB0\xBA\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xC5\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],

        ["\xF3\xB0\xBA\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xC5\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],

        ["\xF3\xB0\xBA\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xC5\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],

        ["\xF3\xB0\xBA\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xC5\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],

        ["\xF3\xB0\xBA\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xC5\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],

        ["\xF3\xB0\xBA\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xC5\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],

        ["\xF3\xB0\xBA\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xC5\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],

        ["\xF3\xB0\xBA\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xC5\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],

        ["\xF3\xB0\xBA\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xC5\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],

        ["\xF3\xB0\xBA\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xC5\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],

        ["\xF3\xB0\xBA\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xC6\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],

        ["\xF3\xB0\xBA\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xC6\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],

        ["\xF3\xB0\xBA\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xC6\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],

        ["\xF3\xB0\xBA\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xC6\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],

        ["\xF3\xB0\xBA\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xC6\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],

        ["\xF3\xB0\xBA\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xC6\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],

        ["\xF3\xB0\xBA\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xC6\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],

        ["\xF3\xB0\xBA\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xC6\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],

        ["\xF3\xB0\xBA\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xC6\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],

        ["\xF3\xB0\xBA\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xC6\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],

        ["\xF3\xB0\xBA\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xC6\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],

        ["\xF3\xB0\xBA\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xC6\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],

        ["\xF3\xB0\xBA\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xC6\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],

        ["\xF3\xB0\xBA\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xC6\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],

        ["\xF3\xB0\xBA\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xC6\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],

        ["\xF3\xB0\xBA\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xC6\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],

        ["\xF3\xB0\xBA\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xC6\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],

        ["\xF3\xB0\xBA\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xC6\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],

        ["\xF3\xB0\xBA\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xC6\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],

        ["\xF3\xB0\xBA\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xC6\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],

        ["\xF3\xB0\xBA\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xC6\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],

        ["\xF3\xB0\xBA\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xC6\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],

        ["\xF3\xB0\xBA\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xC6\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],

        ["\xF3\xB0\xBA\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xC6\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],

        ["\xF3\xB0\xBA\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xC6\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],

        ["\xF3\xB0\xBA\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xC6\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],

        ["\xF3\xB0\xBA\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xC6\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],

        ["\xF3\xB0\xBA\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xC6\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],

        ["\xF3\xB0\xBA\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xC6\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],

        ["\xF3\xB0\xBA\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xC6\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],

        ["\xF3\xB0\xBA\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xC6\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],

        ["\xF3\xB0\xBA\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xC6\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],

        ["\xF3\xB0\xBA\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xC6\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],

        ["\xF3\xB0\xBA\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xC6\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],

        ["\xF3\xB0\xBA\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xC6\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],

        ["\xF3\xB0\xBA\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xC6\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],

        ["\xF3\xB0\xBA\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xC6\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],

        ["\xF3\xB0\xBA\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xC6\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],

        ["\xF3\xB0\xBA\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xC6\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],

        ["\xF3\xB0\xBA\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xC6\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],

        ["\xF3\xB0\xBA\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xC6\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],

        ["\xF3\xB0\xBA\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xC6\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],

        ["\xF3\xB0\xBB\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xC6\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],

        ["\xF3\xB0\xBB\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xC6\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],

        ["\xF3\xB0\xBB\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xC6\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],

        ["\xF3\xB0\xBB\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xC6\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],

        ["\xF3\xB0\xBB\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xC6\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],

        ["\xF3\xB0\xBB\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xC6\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],

        ["\xF3\xB0\xBB\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xC6\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],

        ["\xF3\xB0\xBB\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xC6\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],

        ["\xF3\xB0\xBB\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xC6\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],

        ["\xF3\xB0\xBB\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xC6\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],

        ["\xF3\xB0\xBB\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xC6\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],

        ["\xF3\xB0\xBB\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xC6\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],

        ["\xF3\xB0\xBB\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xC6\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],

        ["\xF3\xB0\xBB\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xC6\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],

        ["\xF3\xB0\xBB\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xC6\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],

        ["\xF3\xB0\xBB\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xC6\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],

        ["\xF3\xB0\xBB\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xC6\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],

        ["\xF3\xB0\xBB\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xC6\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],

        ["\xF3\xB0\xBB\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xC6\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],

        ["\xF3\xB0\xBB\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xC6\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],

        ["\xF3\xB0\xBB\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xC6\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],

        ["\xF3\xB0\xBB\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xC6\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],

        ["\xF3\xB0\xBB\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xC6\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],

        ["\xF3\xB0\xBB\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xC6\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],

        ["\xF3\xB0\xBB\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xC6\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],

        ["\xF3\xB0\xBB\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xC6\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],

        ["\xF3\xB0\xBB\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xC6\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],

        ["\xF3\xB0\xBB\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xC6\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],

        ["\xF3\xB0\xBB\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xC6\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],

        ["\xF3\xB0\xBB\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xC6\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],

        ["\xF3\xB0\xBB\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xC6\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],

        ["\xF3\xB0\xBB\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xC6\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],

        ["\xF3\xB0\xBB\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xC6\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],

        ["\xF3\xB0\xBB\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xC6\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],

        ["\xF3\xB0\xBB\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xC6\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],

        ["\xF3\xB0\xBB\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xC6\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],

        ["\xF3\xB0\xBB\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xC6\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],

        ["\xF3\xB0\xBB\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xC6\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],

        ["\xF3\xB0\xBB\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xC6\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],

        ["\xF3\xB0\xBB\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xC6\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],

        ["\xF3\xB0\xBB\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xC6\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],

        ["\xF3\xB0\xBB\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xC6\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],

        ["\xF3\xB0\xBB\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xC6\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],

        ["\xF3\xB0\xBB\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xED\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],

        ["\xF3\xB0\xBB\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xC6\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],

        ["\xF3\xB0\xBB\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xC6\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],

        ["\xF3\xB0\xBB\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xC6\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],

        ["\xF3\xB0\xBB\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xC6\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],

        ["\xF3\xB0\xBB\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xC6\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],

        ["\xF3\xB0\xBB\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xC6\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],

        ["\xF3\xB0\xBB\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xC6\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],

        ["\xF3\xB0\xBB\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xC6\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],

        ["\xF3\xB0\xBB\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xC7\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],

        ["\xF3\xB0\xBB\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xC7\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],

        ["\xF3\xB0\xBB\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xC7\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],

        ["\xF3\xB0\xBB\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xC7\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],

        ["\xF3\xB0\xBB\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xC7\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],

        ["\xF3\xB0\xBB\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xC7\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],

        ["\xF3\xB0\xBB\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xC7\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],

        ["\xF3\xB0\xBB\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xC7\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],

        ["\xF3\xB0\xBB\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xC7\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],

        ["\xF3\xB0\xBB\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xC7\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],

        ["\xF3\xB0\xBB\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xC7\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],

        ["\xF3\xB0\xBB\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xC7\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],

        ["\xF3\xB0\xBC\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xC7\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],

        ["\xF3\xB0\xBC\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xC7\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],

        ["\xF3\xB0\xBC\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xC7\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],

        ["\xF3\xB0\xBC\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xC7\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],

        ["\xF3\xB0\xBC\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xC7\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],

        ["\xF3\xB0\xBC\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xC7\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],

        ["\xF3\xB0\xBC\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xC7\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],

        ["\xF3\xB0\xBC\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xC7\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],

        ["\xF3\xB0\xBC\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xC7\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],

        ["\xF3\xB0\xBC\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xC7\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],

        ["\xF3\xB0\xBC\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xC7\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],

        ["\xF3\xB0\xBC\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xC7\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],

        ["\xF3\xB0\xBC\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xC7\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],

        ["\xF3\xB0\xBC\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xC7\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],

        ["\xF3\xB0\xBC\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xC7\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],

        ["\xF3\xB0\xBC\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xC7\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],

        ["\xF3\xB0\xBC\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xC7\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],

        ["\xF3\xB0\xBC\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xC7\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],

        ["\xF3\xB0\xBC\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xC7\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],

        ["\xF3\xB0\xBC\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xC7\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],

        ["\xF3\xB0\xBC\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xC7\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],

        ["\xF3\xB0\xBC\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xC7\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],

        ["\xF3\xB0\xBC\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xC7\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],

        ["\xF3\xB0\xBC\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xC7\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],

        ["\xF3\xB0\xBC\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xC7\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],

        ["\xF3\xB0\xBC\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xC7\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],

        ["\xF3\xB0\xBC\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xC7\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],

        ["\xF3\xB0\xBC\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xC7\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],

        ["\xF3\xB0\xBC\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xC7\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],

        ["\xF3\xB0\xBC\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xC7\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],

        ["\xF3\xB0\xBC\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xC7\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],

        ["\xF3\xB0\xBC\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xC7\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],

        ["\xF3\xB0\xBC\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xC7\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],

        ["\xF3\xB0\xBC\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xC7\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],

        ["\xF3\xB0\xBC\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xC7\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],

        ["\xF3\xB0\xBC\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xC7\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],

        ["\xF3\xB0\xBC\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xC7\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],

        ["\xF3\xB0\xBC\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xC7\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],

        ["\xF3\xB0\xBC\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xC7\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],

        ["\xF3\xB0\xBC\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xC7\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],

        ["\xF3\xB0\xBC\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xC7\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],

        ["\xF3\xB0\xBC\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xC7\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],

        ["\xF3\xB0\xBC\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xC7\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],

        ["\xF3\xB0\xBC\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xC7\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],

        ["\xF3\xB0\xBC\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xC7\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],

        ["\xF3\xB0\xBC\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xC7\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],

        ["\xF3\xB0\xBC\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xC7\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],

        ["\xF3\xB0\xBC\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xC7\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],

        ["\xF3\xB0\xBC\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xC7\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],

        ["\xF3\xB0\xBC\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xC7\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],

        ["\xF3\xB0\xBC\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xC7\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],

        ["\xF3\xB0\xBC\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xC7\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],

        ["\xF3\xB0\xBC\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xC7\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],

        ["\xF3\xB0\xBC\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xC7\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],

        ["\xF3\xB0\xBC\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xC7\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],

        ["\xF3\xB0\xBC\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xC7\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],

        ["\xF3\xB0\xBC\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xC7\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],

        ["\xF3\xB0\xBC\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xC7\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],

        ["\xF3\xB0\xBC\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xC7\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],

        ["\xF3\xB0\xBC\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xEA\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],

        ["\xF3\xB0\xBC\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xC7\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],

        ["\xF3\xB0\xBC\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xC7\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],

        ["\xF3\xB0\xBC\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xC7\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],

        ["\xF3\xB0\xBC\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xC7\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],

        ["\xF3\xB0\xBD\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xC7\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],

        ["\xF3\xB0\xBD\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xC7\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],

        ["\xF3\xB0\xBD\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xC7\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],

        ["\xF3\xB0\xBD\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xC7\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],

        ["\xF3\xB0\xBD\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xC7\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],

        ["\xF3\xB0\xBD\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xC7\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],

        ["\xF3\xB0\xBD\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xC7\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],

        ["\xF3\xB0\xBD\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xC7\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],

        ["\xF3\xB0\xBD\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xC7\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],

        ["\xF3\xB0\xBD\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xC7\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],

        ["\xF3\xB0\xBD\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xC7\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],

        ["\xF3\xB0\xBD\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xC7\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],

        ["\xF3\xB0\xBD\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xC7\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],

        ["\xF3\xB0\xBD\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xC7\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],

        ["\xF3\xB0\xBD\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xC7\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],

        ["\xF3\xB0\xBD\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xC7\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],

        ["\xF3\xB0\xBD\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xC7\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],

        ["\xF3\xB0\xBD\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xC7\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],

        ["\xF3\xB0\xBD\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xC8\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],

        ["\xF3\xB0\xBD\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xC8\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],

        ["\xF3\xB0\xBD\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xC8\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],

        ["\xF3\xB0\xBD\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xC8\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],

        ["\xF3\xB0\xBD\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xC8\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],

        ["\xF3\xB0\xBD\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xC8\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],

        ["\xF3\xB0\xBD\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xC8\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],

        ["\xF3\xB0\xBD\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xC8\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],

        ["\xF3\xB0\xBD\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xC8\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],

        ["\xF3\xB0\xBD\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xC8\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],

        ["\xF3\xB0\xBD\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xC8\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],

        ["\xF3\xB0\xBD\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xC8\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],

        ["\xF3\xB0\xBD\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xC8\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],

        ["\xF3\xB0\xBD\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xC8\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],

        ["\xF3\xB0\xBD\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xC8\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],

        ["\xF3\xB0\xBD\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xC8\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],

        ["\xF3\xB0\xBD\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xC8\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],

        ["\xF3\xB0\xBD\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xC8\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],

        ["\xF3\xB0\xBD\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xC8\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],

        ["\xF3\xB0\xBD\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xC8\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],

        ["\xF3\xB0\xBD\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xC8\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],

        ["\xF3\xB0\xBD\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xC8\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],

        ["\xF3\xB0\xBD\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xC8\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],

        ["\xF3\xB0\xBD\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xC8\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],

        ["\xF3\xB0\xBD\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xC8\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],

        ["\xF3\xB0\xBD\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xC8\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],

        ["\xF3\xB0\xBD\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xC8\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],

        ["\xF3\xB0\xBD\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xC8\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],

        ["\xF3\xB0\xBD\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xC8\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],

        ["\xF3\xB0\xBD\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xC8\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],

        ["\xF3\xB0\xBD\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xC8\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],

        ["\xF3\xB0\xBD\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xC8\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],

        ["\xF3\xB0\xBD\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xC8\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],

        ["\xF3\xB0\xBD\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xC8\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],

        ["\xF3\xB0\xBD\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xC8\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],

        ["\xF3\xB0\xBD\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xC8\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],

        ["\xF3\xB0\xBD\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xC8\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],

        ["\xF3\xB0\xBD\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xC8\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],

        ["\xF3\xB0\xBD\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xC8\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],

        ["\xF3\xB0\xBD\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xC8\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],

        ["\xF3\xB0\xBD\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xC8\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],

        ["\xF3\xB0\xBD\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xC8\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],

        ["\xF3\xB0\xBD\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xC8\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],

        ["\xF3\xB0\xBD\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xC8\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],

        ["\xF3\xB0\xBD\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xC8\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],

        ["\xF3\xB0\xBD\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xC8\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],

        ["\xF3\xB0\xBE\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xC8\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],

        ["\xF3\xB0\xBE\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xC8\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],

        ["\xF3\xB0\xBE\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xC8\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],

        ["\xF3\xB0\xBE\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xC8\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],

        ["\xF3\xB0\xBE\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xC8\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],

        ["\xF3\xB0\xBE\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xC8\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],

        ["\xF3\xB0\xBE\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xC8\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],

        ["\xF3\xB0\xBE\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xC8\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],

        ["\xF3\xB0\xBE\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xC8\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],

        ["\xF3\xB0\xBE\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xC8\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],

        ["\xF3\xB0\xBE\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xC8\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],

        ["\xF3\xB0\xBE\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xC8\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],

        ["\xF3\xB0\xBE\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xC8\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],

        ["\xF3\xB0\xBE\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xC8\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],

        ["\xF3\xB0\xBE\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xC8\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],

        ["\xF3\xB0\xBE\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xC8\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],

        ["\xF3\xB0\xBE\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xC8\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],

        ["\xF3\xB0\xBE\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xC8\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],

        ["\xF3\xB0\xBE\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xC8\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],

        ["\xF3\xB0\xBE\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xC8\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],

        ["\xF3\xB0\xBE\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xC8\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],

        ["\xF3\xB0\xBE\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xC8\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],

        ["\xF3\xB0\xBE\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xC8\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],

        ["\xF3\xB0\xBE\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xC8\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],

        ["\xF3\xB0\xBE\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xC8\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],

        ["\xF3\xB0\xBE\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xC8\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],

        ["\xF3\xB0\xBE\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xC8\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],

        ["\xF3\xB0\xBE\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xC8\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],

        ["\xF3\xB0\xBE\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xC8\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],

        ["\xF3\xB0\xBE\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xC8\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],

        ["\xF3\xB0\xBE\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xC8\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],

        ["\xF3\xB0\xBE\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xC8\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],

        ["\xF3\xB0\xBE\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xC8\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],

        ["\xF3\xB0\xBE\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xC8\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],

        ["\xF3\xB0\xBE\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xC8\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],

        ["\xF3\xB0\xBE\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xC8\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],

        ["\xF3\xB0\xBE\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xC8\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],

        ["\xF3\xB0\xBE\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xC8\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],

        ["\xF3\xB0\xBE\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xC8\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],

        ["\xF3\xB0\xBE\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xC8\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],

        ["\xF3\xB0\xBE\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xC8\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],

        ["\xF3\xB0\xBE\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xC8\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],

        ["\xF3\xB0\xBE\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xC8\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],

        ["\xF3\xB0\xBE\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xC8\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],

        ["\xF3\xB0\xBE\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xC8\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],

        ["\xF3\xB0\xBE\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xC8\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],

        ["\xF3\xB0\xBE\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xC8\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],

        ["\xF3\xB0\xBE\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xC8\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],

        ["\xF3\xB0\xBE\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xC9\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],

        ["\xF3\xB0\xBE\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xC9\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],

        ["\xF3\xB0\xBE\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xC9\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],

        ["\xF3\xB0\xBE\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xC9\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],

        ["\xF3\xB0\xBE\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xC9\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],

        ["\xF3\xB0\xBE\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xC9\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],

        ["\xF3\xB0\xBE\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xC9\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],

        ["\xF3\xB0\xBE\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xC9\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],

        ["\xF3\xB0\xBE\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xC9\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],

        ["\xF3\xB0\xBE\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xC9\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],

        ["\xF3\xB0\xBE\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xC9\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],

        ["\xF3\xB0\xBE\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xC9\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],

        ["\xF3\xB0\xBE\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xC9\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],

        ["\xF3\xB0\xBE\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xC9\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],

        ["\xF3\xB0\xBE\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xC9\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],

        ["\xF3\xB0\xBE\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\xDB\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],

        ["\xF3\xB0\xBF\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xC9\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],

        ["\xF3\xB0\xBF\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xC9\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],

        ["\xF3\xB0\xBF\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xC9\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],

        ["\xF3\xB0\xBF\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xC9\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],

        ["\xF3\xB0\xBF\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xC9\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],

        ["\xF3\xB0\xBF\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xC9\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],

        ["\xF3\xB0\xBF\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xC9\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],

        ["\xF3\xB0\xBF\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xC9\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],

        ["\xF3\xB0\xBF\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xC9\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],

        ["\xF3\xB0\xBF\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xC9\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],

        ["\xF3\xB0\xBF\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xC9\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],

        ["\xF3\xB0\xBF\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xC9\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],

        ["\xF3\xB0\xBF\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xC9\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],

        ["\xF3\xB0\xBF\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xC9\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],

        ["\xF3\xB0\xBF\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xC9\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],

        ["\xF3\xB0\xBF\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xC9\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],

        ["\xF3\xB0\xBF\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xC9\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],

        ["\xF3\xB0\xBF\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xC9\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],

        ["\xF3\xB0\xBF\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xC9\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],

        ["\xF3\xB0\xBF\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xC9\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],

        ["\xF3\xB0\xBF\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xC9\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],

        ["\xF3\xB0\xBF\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xC9\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],

        ["\xF3\xB0\xBF\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xC9\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],

        ["\xF3\xB0\xBF\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xC9\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],

        ["\xF3\xB0\xBF\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xC9\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],

        ["\xF3\xB0\xBF\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xC9\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],

        ["\xF3\xB0\xBF\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xC9\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],

        ["\xF3\xB0\xBF\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xC9\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],

        ["\xF3\xB0\xBF\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xC9\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],

        ["\xF3\xB0\xBF\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xC9\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],

        ["\xF3\xB0\xBF\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xC9\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],

        ["\xF3\xB0\xBF\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xC9\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],

        ["\xF3\xB0\xBF\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xC9\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],

        ["\xF3\xB0\xBF\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xC9\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],

        ["\xF3\xB0\xBF\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xC9\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],

        ["\xF3\xB0\xBF\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xC9\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],

        ["\xF3\xB0\xBF\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xC9\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],

        ["\xF3\xB0\xBF\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xC9\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],

        ["\xF3\xB0\xBF\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xC9\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],

        ["\xF3\xB0\xBF\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],

        ["\xF3\xB0\xBF\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xC9\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],

        ["\xF3\xB0\xBF\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xC9\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],

        ["\xF3\xB0\xBF\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xC9\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],

        ["\xF3\xB0\xBF\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xC9\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],

        ["\xF3\xB0\xBF\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xC9\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],

        ["\xF3\xB0\xBF\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xC9\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],

        ["\xF3\xB0\xBF\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xC9\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],

        ["\xF3\xB0\xBF\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xC9\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],

        ["\xF3\xB0\xBF\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xC9\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],

        ["\xF3\xB0\xBF\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xC9\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],

        ["\xF3\xB0\xBF\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xC9\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],

        ["\xF3\xB0\xBF\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xC9\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],

        ["\xF3\xB0\xBF\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xC9\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],

        ["\xF3\xB0\xBF\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xC9\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],

        ["\xF3\xB0\xBF\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xC9\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],

        ["\xF3\xB0\xBF\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xC9\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],

        ["\xF3\xB0\xBF\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xC9\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],

        ["\xF3\xB0\xBF\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xC9\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],

        ["\xF3\xB0\xBF\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xC9\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],

        ["\xF3\xB0\xBF\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xC9\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],

        ["\xF3\xB0\xBF\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xC9\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],

        ["\xF3\xB0\xBF\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xC9\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],

        ["\xF3\xB0\xBF\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xC9\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],

        ["\xF3\xB0\xBF\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xC9\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],

        ["\xF3\xB1\x80\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xC9\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],

        ["\xF3\xB1\x80\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xC9\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],

        ["\xF3\xB1\x80\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xC9\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],

        ["\xF3\xB1\x80\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xC9\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],

        ["\xF3\xB1\x80\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xC9\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],

        ["\xF3\xB1\x80\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xC9\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],

        ["\xF3\xB1\x80\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xC9\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],

        ["\xF3\xB1\x80\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xC9\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],

        ["\xF3\xB1\x80\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xC9\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],

        ["\xF3\xB1\x80\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xC9\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],

        ["\xF3\xB1\x80\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xC9\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],

        ["\xF3\xB1\x80\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xC9\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],

        ["\xF3\xB1\x80\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xC9\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],

        ["\xF3\xB1\x80\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xC9\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],

        ["\xF3\xB1\x80\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xCA\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],

        ["\xF3\xB1\x80\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xCA\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],

        ["\xF3\xB1\x80\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xCA\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],

        ["\xF3\xB1\x80\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xCA\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],

        ["\xF3\xB1\x80\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xCA\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],

        ["\xF3\xB1\x80\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xCA\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],

        ["\xF3\xB1\x80\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xCA\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],

        ["\xF3\xB1\x80\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xCA\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],

        ["\xF3\xB1\x80\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xCA\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],

        ["\xF3\xB1\x80\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xCA\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],

        ["\xF3\xB1\x80\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xCA\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],

        ["\xF3\xB1\x80\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xCA\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],

        ["\xF3\xB1\x80\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xCA\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],

        ["\xF3\xB1\x80\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xCA\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],

        ["\xF3\xB1\x80\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xCA\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],

        ["\xF3\xB1\x80\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xCA\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],

        ["\xF3\xB1\x80\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xCA\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],

        ["\xF3\xB1\x80\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xCA\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],

        ["\xF3\xB1\x80\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xCA\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],

        ["\xF3\xB1\x80\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xCA\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],

        ["\xF3\xB1\x80\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xCA\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],

        ["\xF3\xB1\x80\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xCA\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],

        ["\xF3\xB1\x80\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xCA\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],

        ["\xF3\xB1\x80\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xCA\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],

        ["\xF3\xB1\x80\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xCA\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],

        ["\xF3\xB1\x80\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xCA\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],

        ["\xF3\xB1\x80\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xCA\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],

        ["\xF3\xB1\x80\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xCA\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],

        ["\xF3\xB1\x80\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xCA\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],

        ["\xF3\xB1\x80\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xCA\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],

        ["\xF3\xB1\x80\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xCA\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],

        ["\xF3\xB1\x80\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xCA\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],

        ["\xF3\xB1\x80\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xCA\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],

        ["\xF3\xB1\x80\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xCA\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],

        ["\xF3\xB1\x80\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xCA\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],

        ["\xF3\xB1\x80\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xCA\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],

        ["\xF3\xB1\x80\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xCA\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],

        ["\xF3\xB1\x80\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xCA\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],

        ["\xF3\xB1\x80\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xCA\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],

        ["\xF3\xB1\x80\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xCA\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],

        ["\xF3\xB1\x80\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xCA\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],

        ["\xF3\xB1\x80\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xCA\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],

        ["\xF3\xB1\x80\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xCA\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],

        ["\xF3\xB1\x80\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xCA\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],

        ["\xF3\xB1\x80\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xCA\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],

        ["\xF3\xB1\x80\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xCA\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],

        ["\xF3\xB1\x80\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xCA\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],

        ["\xF3\xB1\x80\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xCA\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],

        ["\xF3\xB1\x80\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xCA\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],

        ["\xF3\xB1\x80\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xCA\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],

        ["\xF3\xB1\x81\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xCA\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],

        ["\xF3\xB1\x81\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xCA\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],

        ["\xF3\xB1\x81\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xCA\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],

        ["\xF3\xB1\x81\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xCA\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],

        ["\xF3\xB1\x81\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xCA\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],

        ["\xF3\xB1\x81\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xCA\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],

        ["\xF3\xB1\x81\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xCA\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],

        ["\xF3\xB1\x81\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xCA\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],

        ["\xF3\xB1\x81\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xCA\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],

        ["\xF3\xB1\x81\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xCA\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],

        ["\xF3\xB1\x81\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xCA\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],

        ["\xF3\xB1\x81\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xCA\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],

        ["\xF3\xB1\x81\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xCA\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],

        ["\xF3\xB1\x81\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xCA\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],

        ["\xF3\xB1\x81\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xCA\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],

        ["\xF3\xB1\x81\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xCA\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],

        ["\xF3\xB1\x81\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xCA\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],

        ["\xF3\xB1\x81\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xCA\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],

        ["\xF3\xB1\x81\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xCA\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],

        ["\xF3\xB1\x81\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xCA\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],

        ["\xF3\xB1\x81\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xCA\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],

        ["\xF3\xB1\x81\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xCA\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],

        ["\xF3\xB1\x81\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xCA\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],

        ["\xF3\xB1\x81\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xCA\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],

        ["\xF3\xB1\x81\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xCA\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],

        ["\xF3\xB1\x81\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xCA\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],

        ["\xF3\xB1\x81\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xCA\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],

        ["\xF3\xB1\x81\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xCA\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],

        ["\xF3\xB1\x81\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xCA\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],

        ["\xF3\xB1\x81\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xCA\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],

        ["\xF3\xB1\x81\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xCA\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],

        ["\xF3\xB1\x81\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xCA\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],

        ["\xF3\xB1\x81\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xCA\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],

        ["\xF3\xB1\x81\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xCA\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],

        ["\xF3\xB1\x81\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xCA\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],

        ["\xF3\xB1\x81\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xCA\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],

        ["\xF3\xB1\x81\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xCA\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],

        ["\xF3\xB1\x81\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xCA\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],

        ["\xF3\xB1\x81\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xCA\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],

        ["\xF3\xB1\x81\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xCA\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],

        ["\xF3\xB1\x81\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xCA\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],

        ["\xF3\xB1\x81\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xCA\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],

        ["\xF3\xB1\x81\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xCA\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],

        ["\xF3\xB1\x81\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xCA\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],

        ["\xF3\xB1\x81\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xCB\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],

        ["\xF3\xB1\x81\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xCB\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],

        ["\xF3\xB1\x81\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xCB\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],

        ["\xF3\xB1\x81\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xCB\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],

        ["\xF3\xB1\x81\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xCB\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],

        ["\xF3\xB1\x81\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xCB\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],

        ["\xF3\xB1\x81\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xCB\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],

        ["\xF3\xB1\x81\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xCB\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],

        ["\xF3\xB1\x81\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xCB\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],

        ["\xF3\xB1\x81\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xCB\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],

        ["\xF3\xB1\x81\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xCB\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],

        ["\xF3\xB1\x81\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xCB\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],

        ["\xF3\xB1\x81\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xCB\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],

        ["\xF3\xB1\x81\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xCB\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],

        ["\xF3\xB1\x81\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xCB\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],

        ["\xF3\xB1\x81\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xCB\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],

        ["\xF3\xB1\x81\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xCB\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],

        ["\xF3\xB1\x81\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xCB\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],

        ["\xF3\xB1\x81\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xCB\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],

        ["\xF3\xB1\x81\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xCB\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],

        ["\xF3\xB1\x82\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xCB\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],

        ["\xF3\xB1\x82\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xCB\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],

        ["\xF3\xB1\x82\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xCB\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],

        ["\xF3\xB1\x82\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xCB\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],

        ["\xF3\xB1\x82\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xCB\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],

        ["\xF3\xB1\x82\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xCB\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],

        ["\xF3\xB1\x82\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xCB\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],

        ["\xF3\xB1\x82\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xCB\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],

        ["\xF3\xB1\x82\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xCB\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],

        ["\xF3\xB1\x82\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xCB\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],

        ["\xF3\xB1\x82\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xCB\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],

        ["\xF3\xB1\x82\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xCB\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],

        ["\xF3\xB1\x82\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xCB\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],

        ["\xF3\xB1\x82\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xCB\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],

        ["\xF3\xB1\x82\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xCB\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],

        ["\xF3\xB1\x82\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xCB\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],

        ["\xF3\xB1\x82\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xCB\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],

        ["\xF3\xB1\x82\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xCB\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],

        ["\xF3\xB1\x82\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xCB\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],

        ["\xF3\xB1\x82\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xCB\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],

        ["\xF3\xB1\x82\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xCB\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],

        ["\xF3\xB1\x82\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xCB\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],

        ["\xF3\xB1\x82\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xCB\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],

        ["\xF3\xB1\x82\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xCB\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],

        ["\xF3\xB1\x82\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xCB\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],

        ["\xF3\xB1\x82\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xCB\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],

        ["\xF3\xB1\x82\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xCB\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],

        ["\xF3\xB1\x82\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xCB\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],

        ["\xF3\xB1\x82\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xCB\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],

        ["\xF3\xB1\x82\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xCB\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],

        ["\xF3\xB1\x82\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xCB\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],

        ["\xF3\xB1\x82\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xCB\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],

        ["\xF3\xB1\x82\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xCB\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],

        ["\xF3\xB1\x82\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xCB\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],

        ["\xF3\xB1\x82\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xCB\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],

        ["\xF3\xB1\x82\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xCB\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],

        ["\xF3\xB1\x82\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xCB\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],

        ["\xF3\xB1\x82\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xCB\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],

        ["\xF3\xB1\x82\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xCB\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],

        ["\xF3\xB1\x82\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xCB\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],

        ["\xF3\xB1\x82\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xCB\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],

        ["\xF3\xB1\x82\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xCB\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],

        ["\xF3\xB1\x82\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xCB\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],

        ["\xF3\xB1\x82\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xCB\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],

        ["\xF3\xB1\x82\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xCB\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],

        ["\xF3\xB1\x82\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xCB\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],

        ["\xF3\xB1\x82\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xCB\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],

        ["\xF3\xB1\x82\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xCB\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],

        ["\xF3\xB1\x82\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xCB\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],

        ["\xF3\xB1\x82\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xCB\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],

        ["\xF3\xB1\x82\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xCB\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],

        ["\xF3\xB1\x82\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xCB\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],

        ["\xF3\xB1\x82\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xCB\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],

        ["\xF3\xB1\x82\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\x54\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],

        ["\xF3\xB1\x82\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xCB\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],

        ["\xF3\xB1\x82\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xCB\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],

        ["\xF3\xB1\x82\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xCB\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],

        ["\xF3\xB1\x82\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xCB\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],

        ["\xF3\xB1\x82\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xCB\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],

        ["\xF3\xB1\x82\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xCB\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],

        ["\xF3\xB1\x82\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xCB\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],

        ["\xF3\xB1\x82\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xCB\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],

        ["\xF3\xB1\x82\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xCB\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],

        ["\xF3\xB1\x82\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xCB\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],

        ["\xF3\xB1\x83\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xCB\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],

        ["\xF3\xB1\x83\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xCB\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],

        ["\xF3\xB1\x83\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xCB\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],

        ["\xF3\xB1\x83\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xCB\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],

        ["\xF3\xB1\x83\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xD0\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],

        ["\xF3\xB1\x83\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xCB\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],

        ["\xF3\xB1\x83\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xCB\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],

        ["\xF3\xB1\x83\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xCB\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],

        ["\xF3\xB1\x83\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xCB\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],

        ["\xF3\xB1\x83\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xCB\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],

        ["\xF3\xB1\x83\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xCC\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],

        ["\xF3\xB1\x83\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xCC\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],

        ["\xF3\xB1\x83\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xCC\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],

        ["\xF3\xB1\x83\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xCC\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],

        ["\xF3\xB1\x83\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xCC\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],

        ["\xF3\xB1\x83\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xCC\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],

        ["\xF3\xB1\x83\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xCC\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],

        ["\xF3\xB1\x83\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xCC\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],

        ["\xF3\xB1\x83\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xCC\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],

        ["\xF3\xB1\x83\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xCC\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],

        ["\xF3\xB1\x83\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xCC\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],

        ["\xF3\xB1\x83\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xCC\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],

        ["\xF3\xB1\x83\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xCC\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],

        ["\xF3\xB1\x83\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xCC\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],

        ["\xF3\xB1\x83\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xCC\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],

        ["\xF3\xB1\x83\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xCC\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],

        ["\xF3\xB1\x83\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xCC\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],

        ["\xF3\xB1\x83\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xCC\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],

        ["\xF3\xB1\x83\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xCC\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],

        ["\xF3\xB1\x83\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xCC\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],

        ["\xF3\xB1\x83\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xCC\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],

        ["\xF3\xB1\x83\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xCC\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],

        ["\xF3\xB1\x83\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xCC\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],

        ["\xF3\xB1\x83\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xCC\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],

        ["\xF3\xB1\x83\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xCC\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],

        ["\xF3\xB1\x83\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xCC\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],

        ["\xF3\xB1\x83\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xCC\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],

        ["\xF3\xB1\x83\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xCC\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],

        ["\xF3\xB1\x83\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xCC\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],

        ["\xF3\xB1\x83\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xCC\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],

        ["\xF3\xB1\x83\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xCC\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],

        ["\xF3\xB1\x83\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xCC\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],

        ["\xF3\xB1\x83\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xCC\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],

        ["\xF3\xB1\x83\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xCC\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],

        ["\xF3\xB1\x83\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xCC\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],

        ["\xF3\xB1\x83\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xCC\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],

        ["\xF3\xB1\x83\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xCC\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],

        ["\xF3\xB1\x83\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xCC\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],

        ["\xF3\xB1\x83\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xCC\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],

        ["\xF3\xB1\x83\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xCC\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],

        ["\xF3\xB1\x83\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xCC\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],

        ["\xF3\xB1\x83\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xCC\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],

        ["\xF3\xB1\x83\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xCC\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],

        ["\xF3\xB1\x83\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xCC\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],

        ["\xF3\xB1\x83\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],
        ["\x6F\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],

        ["\xF3\xB1\x83\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xCC\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],

        ["\xF3\xB1\x83\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xCC\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],

        ["\xF3\xB1\x83\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xCC\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],

        ["\xF3\xB1\x83\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xCC\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],

        ["\xF3\xB1\x83\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xCC\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],

        ["\xF3\xB1\x83\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xCC\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],

        ["\xF3\xB1\x83\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xCC\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],

        ["\xF3\xB1\x83\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xCC\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],

        ["\xF3\xB1\x83\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xCC\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],

        ["\xF3\xB1\x84\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xCC\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],

        ["\xF3\xB1\x84\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xCC\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],

        ["\xF3\xB1\x84\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xCC\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],

        ["\xF3\xB1\x84\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xCC\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],

        ["\xF3\xB1\x84\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xCC\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],

        ["\xF3\xB1\x84\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xCC\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],

        ["\xF3\xB1\x84\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xCC\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],

        ["\xF3\xB1\x84\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xCC\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],

        ["\xF3\xB1\x84\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xCC\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],

        ["\xF3\xB1\x84\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xCC\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],

        ["\xF3\xB1\x84\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xCC\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],

        ["\xF3\xB1\x84\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xCC\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],

        ["\xF3\xB1\x84\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xCC\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],

        ["\xF3\xB1\x84\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xCC\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],

        ["\xF3\xB1\x84\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xCC\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],

        ["\xF3\xB1\x84\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xCC\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],

        ["\xF3\xB1\x84\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xCC\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],

        ["\xF3\xB1\x84\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xCC\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],

        ["\xF3\xB1\x84\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xCC\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],

        ["\xF3\xB1\x84\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xCC\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],

        ["\xF3\xB1\x84\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xCC\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],

        ["\xF3\xB1\x84\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xCC\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],

        ["\xF3\xB1\x84\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xCC\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],

        ["\xF3\xB1\x84\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xCC\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],

        ["\xF3\xB1\x84\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xCC\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],

        ["\xF3\xB1\x84\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xCC\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],

        ["\xF3\xB1\x84\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xCC\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],

        ["\xF3\xB1\x84\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xCC\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],

        ["\xF3\xB1\x84\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xCC\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],

        ["\xF3\xB1\x84\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xCC\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],

        ["\xF3\xB1\x84\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xCC\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],

        ["\xF3\xB1\x84\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xCC\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],

        ["\xF3\xB1\x84\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xCC\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],

        ["\xF3\xB1\x84\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xCC\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],

        ["\xF3\xB1\x84\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],

        ["\xF3\xB1\x84\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xCC\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],

        ["\xF3\xB1\x84\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xCC\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],

        ["\xF3\xB1\x84\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xCC\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],

        ["\xF3\xB1\x84\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xCC\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],

        ["\xF3\xB1\x84\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xCC\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],

        ["\xF3\xB1\x84\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xCD\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],

        ["\xF3\xB1\x84\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xCD\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],

        ["\xF3\xB1\x84\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xCD\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],

        ["\xF3\xB1\x84\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xCD\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],

        ["\xF3\xB1\x84\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xCD\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],

        ["\xF3\xB1\x84\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xCD\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],

        ["\xF3\xB1\x84\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xCD\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],

        ["\xF3\xB1\x84\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xCD\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],

        ["\xF3\xB1\x84\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xCD\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],

        ["\xF3\xB1\x84\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xCD\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],

        ["\xF3\xB1\x84\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xCD\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],

        ["\xF3\xB1\x84\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xCD\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],

        ["\xF3\xB1\x84\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xCD\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],

        ["\xF3\xB1\x84\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xCD\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],

        ["\xF3\xB1\x84\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xCD\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],

        ["\xF3\xB1\x84\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xCD\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],

        ["\xF3\xB1\x84\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xCD\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],

        ["\xF3\xB1\x84\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xCD\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],

        ["\xF3\xB1\x84\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xCD\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],

        ["\xF3\xB1\x84\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xCD\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],

        ["\xF3\xB1\x84\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xCD\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],

        ["\xF3\xB1\x84\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xCD\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],

        ["\xF3\xB1\x84\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xCD\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],

        ["\xF3\xB1\x84\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xCD\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],

        ["\xF3\xB1\x85\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xCD\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],

        ["\xF3\xB1\x85\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xCD\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],

        ["\xF3\xB1\x85\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xCD\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],

        ["\xF3\xB1\x85\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xCD\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],

        ["\xF3\xB1\x85\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xCD\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],

        ["\xF3\xB1\x85\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xCD\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],

        ["\xF3\xB1\x85\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xCD\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],

        ["\xF3\xB1\x85\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xCD\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],

        ["\xF3\xB1\x85\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xCD\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],

        ["\xF3\xB1\x85\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xCD\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],

        ["\xF3\xB1\x85\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xCD\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],

        ["\xF3\xB1\x85\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xCD\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],

        ["\xF3\xB1\x85\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xCD\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],

        ["\xF3\xB1\x85\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xCD\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],

        ["\xF3\xB1\x85\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xCD\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],

        ["\xF3\xB1\x85\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xCD\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],

        ["\xF3\xB1\x85\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xCD\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],

        ["\xF3\xB1\x85\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xCD\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],

        ["\xF3\xB1\x85\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xCD\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],

        ["\xF3\xB1\x85\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xCD\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],

        ["\xF3\xB1\x85\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xCD\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],

        ["\xF3\xB1\x85\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xCD\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],

        ["\xF3\xB1\x85\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xCD\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],

        ["\xF3\xB1\x85\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xCD\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],

        ["\xF3\xB1\x85\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xCD\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],

        ["\xF3\xB1\x85\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xCD\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],

        ["\xF3\xB1\x85\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xCD\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],

        ["\xF3\xB1\x85\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xCD\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],

        ["\xF3\xB1\x85\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xCD\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],

        ["\xF3\xB1\x85\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xCD\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],

        ["\xF3\xB1\x85\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xCD\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],

        ["\xF3\xB1\x85\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xCD\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],

        ["\xF3\xB1\x85\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xCD\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],

        ["\xF3\xB1\x85\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xEB"],
        ["\x70\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],

        ["\xF3\xB1\x85\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xCD\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],

        ["\xF3\xB1\x85\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xCD\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],

        ["\xF3\xB1\x85\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xCD\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],

        ["\xF3\xB1\x85\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xCD\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],

        ["\xF3\xB1\x85\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xCD\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],

        ["\xF3\xB1\x85\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xCD\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],

        ["\xF3\xB1\x85\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xCD\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],

        ["\xF3\xB1\x85\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xCD\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],

        ["\xF3\xB1\x85\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xCD\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],

        ["\xF3\xB1\x85\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xCD\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],

        ["\xF3\xB1\x85\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xCD\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],

        ["\xF3\xB1\x85\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xCD\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],

        ["\xF3\xB1\x85\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xCD\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],

        ["\xF3\xB1\x85\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xCD\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],

        ["\xF3\xB1\x85\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xCD\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],

        ["\xF3\xB1\x85\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xCD\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],

        ["\xF3\xB1\x85\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xCD\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],

        ["\xF3\xB1\x85\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xCD\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],

        ["\xF3\xB1\x85\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xCD\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],

        ["\xF3\xB1\x85\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xCD\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],

        ["\xF3\xB1\x85\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xCD\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],

        ["\xF3\xB1\x85\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xCD\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],

        ["\xF3\xB1\x85\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xCD\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],

        ["\xF3\xB1\x85\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xCD\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],

        ["\xF3\xB1\x85\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xCD\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],

        ["\xF3\xB1\x85\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xCD\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],

        ["\xF3\xB1\x85\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xCD\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],

        ["\xF3\xB1\x85\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xCD\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],

        ["\xF3\xB1\x85\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xCD\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],

        ["\xF3\xB1\x85\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xCD\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],

        ["\xF3\xB1\x86\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xCD\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],

        ["\xF3\xB1\x86\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xCD\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],

        ["\xF3\xB1\x86\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xCD\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],

        ["\xF3\xB1\x86\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xCD\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],

        ["\xF3\xB1\x86\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xCD\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],

        ["\xF3\xB1\x86\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xCD\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],

        ["\xF3\xB1\x86\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xCE\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],

        ["\xF3\xB1\x86\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xCE\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],

        ["\xF3\xB1\x86\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xCE\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],

        ["\xF3\xB1\x86\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xCE\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],

        ["\xF3\xB1\x86\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xCE\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],

        ["\xF3\xB1\x86\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xCE\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],

        ["\xF3\xB1\x86\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xCE\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],

        ["\xF3\xB1\x86\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xCE\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],

        ["\xF3\xB1\x86\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xCE\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],

        ["\xF3\xB1\x86\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xCE\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],

        ["\xF3\xB1\x86\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xCE\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],

        ["\xF3\xB1\x86\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xCE\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],

        ["\xF3\xB1\x86\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xCE\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],

        ["\xF3\xB1\x86\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xCE\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],

        ["\xF3\xB1\x86\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xCE\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],

        ["\xF3\xB1\x86\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xCE\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],

        ["\xF3\xB1\x86\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xCE\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],

        ["\xF3\xB1\x86\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xCE\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],

        ["\xF3\xB1\x86\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xCE\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],

        ["\xF3\xB1\x86\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xCE\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],

        ["\xF3\xB1\x86\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xCE\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],

        ["\xF3\xB1\x86\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xCE\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],

        ["\xF3\xB1\x86\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xCE\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],

        ["\xF3\xB1\x86\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xCE\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],

        ["\xF3\xB1\x86\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xCE\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],

        ["\xF3\xB1\x86\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xCE\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],

        ["\xF3\xB1\x86\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xCE\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],

        ["\xF3\xB1\x86\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xCE\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],

        ["\xF3\xB1\x86\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xCE\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],

        ["\xF3\xB1\x86\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xCE\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],

        ["\xF3\xB1\x86\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xCE\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],

        ["\xF3\xB1\x86\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xCE\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],

        ["\xF3\xB1\x86\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xCE\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],

        ["\xF3\xB1\x86\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xCE\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],

        ["\xF3\xB1\x86\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xCE\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],

        ["\xF3\xB1\x86\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xCE\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],

        ["\xF3\xB1\x86\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xCE\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],

        ["\xF3\xB1\x86\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xCE\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],

        ["\xF3\xB1\x86\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xCE\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],

        ["\xF3\xB1\x86\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xCE\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],

        ["\xF3\xB1\x86\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xCE\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],

        ["\xF3\xB1\x86\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xCE\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],

        ["\xF3\xB1\x86\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xCE\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],

        ["\xF3\xB1\x86\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xCE\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],

        ["\xF3\xB1\x86\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xCE\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],

        ["\xF3\xB1\x86\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xCE\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],

        ["\xF3\xB1\x86\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xCE\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],

        ["\xF3\xB1\x86\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xCE\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],

        ["\xF3\xB1\x86\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xCE\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],

        ["\xF3\xB1\x86\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xCE\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],

        ["\xF3\xB1\x86\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xCE\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],

        ["\xF3\xB1\x86\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xCE\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],

        ["\xF3\xB1\x86\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xCE\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],

        ["\xF3\xB1\x86\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xCE\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],

        ["\xF3\xB1\x86\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xCE\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],

        ["\xF3\xB1\x86\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xCE\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],

        ["\xF3\xB1\x86\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xCE\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],

        ["\xF3\xB1\x86\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xCE\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],

        ["\xF3\xB1\x87\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xCE\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],

        ["\xF3\xB1\x87\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xCE\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],

        ["\xF3\xB1\x87\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xCE\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],

        ["\xF3\xB1\x87\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xCE\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],

        ["\xF3\xB1\x87\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xCE\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],

        ["\xF3\xB1\x87\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xCE\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],

        ["\xF3\xB1\x87\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xCE\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],

        ["\xF3\xB1\x87\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xCE\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],

        ["\xF3\xB1\x87\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xCE\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],

        ["\xF3\xB1\x87\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xCE\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],

        ["\xF3\xB1\x87\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xCE\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],

        ["\xF3\xB1\x87\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xCE\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],

        ["\xF3\xB1\x87\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xCE\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],

        ["\xF3\xB1\x87\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xCE\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],

        ["\xF3\xB1\x87\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xCE\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],

        ["\xF3\xB1\x87\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xCE\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],

        ["\xF3\xB1\x87\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xCE\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],

        ["\xF3\xB1\x87\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xCE\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],

        ["\xF3\xB1\x87\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xCE\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],

        ["\xF3\xB1\x87\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xCE\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],

        ["\xF3\xB1\x87\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xCE\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],

        ["\xF3\xB1\x87\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xCE\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],

        ["\xF3\xB1\x87\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xCE\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],

        ["\xF3\xB1\x87\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xCE\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],

        ["\xF3\xB1\x87\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xCE\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],

        ["\xF3\xB1\x87\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xCE\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],

        ["\xF3\xB1\x87\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xCE\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],

        ["\xF3\xB1\x87\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xCE\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],

        ["\xF3\xB1\x87\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xCE\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],

        ["\xF3\xB1\x87\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xCE\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],

        ["\xF3\xB1\x87\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xCE\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],

        ["\xF3\xB1\x87\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xCE\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],

        ["\xF3\xB1\x87\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xCE\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],

        ["\xF3\xB1\x87\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xCE\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],

        ["\xF3\xB1\x87\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xCE\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],

        ["\xF3\xB1\x87\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xCE\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],

        ["\xF3\xB1\x87\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xCF\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],

        ["\xF3\xB1\x87\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xCF\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],

        ["\xF3\xB1\x87\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xCF\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],

        ["\xF3\xB1\x87\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xCF\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],

        ["\xF3\xB1\x87\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xCF\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],

        ["\xF3\xB1\x87\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xCF\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],

        ["\xF3\xB1\x87\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xCF\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],

        ["\xF3\xB1\x87\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xCF\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],

        ["\xF3\xB1\x87\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xCF\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],

        ["\xF3\xB1\x87\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xCF\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],

        ["\xF3\xB1\x87\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xCF\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],

        ["\xF3\xB1\x87\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xCF\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],

        ["\xF3\xB1\x87\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xCF\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],

        ["\xF3\xB1\x87\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xCF\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],

        ["\xF3\xB1\x87\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xCF\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],

        ["\xF3\xB1\x87\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xCF\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],

        ["\xF3\xB1\x87\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xCF\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],

        ["\xF3\xB1\x87\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xCF\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],

        ["\xF3\xB1\x87\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xCF\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],

        ["\xF3\xB1\x87\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xCF\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],

        ["\xF3\xB1\x87\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xCF\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],

        ["\xF3\xB1\x87\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],

        ["\xF3\xB1\x87\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xCF\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],

        ["\xF3\xB1\x87\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xCF\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],

        ["\xF3\xB1\x87\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xCF\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],

        ["\xF3\xB1\x87\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xCF\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],

        ["\xF3\xB1\x87\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xCF\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],

        ["\xF3\xB1\x87\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xCF\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],

        ["\xF3\xB1\x88\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xCF\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],

        ["\xF3\xB1\x88\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xCF\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],

        ["\xF3\xB1\x88\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xCF\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],

        ["\xF3\xB1\x88\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xCF\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],

        ["\xF3\xB1\x88\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xCF\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],

        ["\xF3\xB1\x88\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xCF\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],

        ["\xF3\xB1\x88\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xCF\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],

        ["\xF3\xB1\x88\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xCF\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],

        ["\xF3\xB1\x88\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xCF\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],

        ["\xF3\xB1\x88\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xCF\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],

        ["\xF3\xB1\x88\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xCF\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],

        ["\xF3\xB1\x88\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xCF\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],

        ["\xF3\xB1\x88\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xCF\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],

        ["\xF3\xB1\x88\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xCF\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],

        ["\xF3\xB1\x88\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xCF\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],

        ["\xF3\xB1\x88\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xCF\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],

        ["\xF3\xB1\x88\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xCF\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],

        ["\xF3\xB1\x88\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xCF\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],

        ["\xF3\xB1\x88\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xCF\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],

        ["\xF3\xB1\x88\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xCF\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],

        ["\xF3\xB1\x88\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xCF\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],

        ["\xF3\xB1\x88\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xCF\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],

        ["\xF3\xB1\x88\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xCF\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],

        ["\xF3\xB1\x89\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xD0\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],

        ["\xF3\xB1\x89\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xD0\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],

        ["\xF3\xB1\x89\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xD0\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],

        ["\xF3\xB1\x89\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xD0\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],

        ["\xF3\xB1\x89\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xD0\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],

        ["\xF3\xB1\x89\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xD0\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],

        ["\xF3\xB1\x89\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xD0\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],

        ["\xF3\xB1\x89\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xD0\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],

        ["\xF3\xB1\x89\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xD0\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],

        ["\xF3\xB1\x89\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xD0\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],

        ["\xF3\xB1\x89\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xD0\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],

        ["\xF3\xB1\x89\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xD0\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],

        ["\xF3\xB1\x89\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xD0\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],

        ["\xF3\xB1\x89\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xD0\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],

        ["\xF3\xB1\x89\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xD0\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],

        ["\xF3\xB1\x89\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xD0\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],

        ["\xF3\xB1\x89\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xD0\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],

        ["\xF3\xB1\x89\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xD0\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],

        ["\xF3\xB1\x89\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xD0\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],

        ["\xF3\xB1\x89\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xD0\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],

        ["\xF3\xB1\x89\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xD0\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],

        ["\xF3\xB1\x89\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xD0\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],

        ["\xF3\xB1\x89\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xD0\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],

        ["\xF3\xB1\x89\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xD0\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],

        ["\xF3\xB1\x89\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xD0\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],

        ["\xF3\xB1\x89\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xD0\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],

        ["\xF3\xB1\x89\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xD0\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],

        ["\xF3\xB1\x89\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xD0\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],

        ["\xF3\xB1\x89\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xD0\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],

        ["\xF3\xB1\x89\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xD0\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],

        ["\xF3\xB1\x89\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xD0\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],

        ["\xF3\xB1\x89\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xD0\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],

        ["\xF3\xB1\x89\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xD0\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],

        ["\xF3\xB1\x89\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xD0\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],

        ["\xF3\xB1\x89\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xD0\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],

        ["\xF3\xB1\x89\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xD0\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],

        ["\xF3\xB1\x89\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xD0\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],

        ["\xF3\xB1\x89\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xD0\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],

        ["\xF3\xB1\x89\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xD0\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],

        ["\xF3\xB1\x89\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xD0\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],

        ["\xF3\xB1\x89\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xD0\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],

        ["\xF3\xB1\x89\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xD0\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],

        ["\xF3\xB1\x89\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xD0\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],

        ["\xF3\xB1\x89\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xD0\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],

        ["\xF3\xB1\x89\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xD0\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],

        ["\xF3\xB1\x89\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xD0\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],

        ["\xF3\xB1\x89\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xD0\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],

        ["\xF3\xB1\x89\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xD0\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],

        ["\xF3\xB1\x89\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xD0\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],

        ["\xF3\xB1\x89\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xD0\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],

        ["\xF3\xB1\x89\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xD0\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],

        ["\xF3\xB1\x89\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xD0\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],

        ["\xF3\xB1\x89\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xD0\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],

        ["\xF3\xB1\x89\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xCB\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],

        ["\xF3\xB1\x89\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xD0\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],

        ["\xF3\xB1\x89\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xD0\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],

        ["\xF3\xB1\x89\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xD0\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],

        ["\xF3\xB1\x89\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xD0\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],

        ["\xF3\xB1\x89\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xD0\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],

        ["\xF3\xB1\x89\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xD0\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],

        ["\xF3\xB1\x89\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xD0\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],

        ["\xF3\xB1\x89\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xD0\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],

        ["\xF3\xB1\x8A\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xD0\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],

        ["\xF3\xB1\x8A\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xD0\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],

        ["\xF3\xB1\x8A\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xD0\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],

        ["\xF3\xB1\x8A\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xD0\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],

        ["\xF3\xB1\x8A\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xD0\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],

        ["\xF3\xB1\x8A\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xD0\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],

        ["\xF3\xB1\x8A\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xD0\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],

        ["\xF3\xB1\x8A\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xD0\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],

        ["\xF3\xB1\x8A\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xD0\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],

        ["\xF3\xB1\x8A\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xD0\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],

        ["\xF3\xB1\x8A\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xD0\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],

        ["\xF3\xB1\x8A\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xD0\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],

        ["\xF3\xB1\x8A\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xD0\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],

        ["\xF3\xB1\x8A\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xD0\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],

        ["\xF3\xB1\x8A\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xD0\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],

        ["\xF3\xB1\x8A\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xD0\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],

        ["\xF3\xB1\x8A\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xD0\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],

        ["\xF3\xB1\x8A\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xD0\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],

        ["\xF3\xB1\x8A\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xD0\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],

        ["\xF3\xB1\x8A\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xD0\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],

        ["\xF3\xB1\x8A\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xD0\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],

        ["\xF3\xB1\x8A\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xD0\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],

        ["\xF3\xB1\x8A\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xD0\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],

        ["\xF3\xB1\x8A\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xD0\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],

        ["\xF3\xB1\x8A\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xD0\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],

        ["\xF3\xB1\x8A\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xD0\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],

        ["\xF3\xB1\x8A\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xD0\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],

        ["\xF3\xB1\x8A\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xD0\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],

        ["\xF3\xB1\x8A\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xD0\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],

        ["\xF3\xB1\x8A\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xD0\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],

        ["\xF3\xB1\x8A\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xD0\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],

        ["\xF3\xB1\x8A\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xD0\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],

        ["\xF3\xB1\x8A\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xD1\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],

        ["\xF3\xB1\x8A\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xD1\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],

        ["\xF3\xB1\x8A\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xD1\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],

        ["\xF3\xB1\x8A\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xD1\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],

        ["\xF3\xB1\x8A\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xD1\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],

        ["\xF3\xB1\x8A\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xD1\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],

        ["\xF3\xB1\x8A\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xD1\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],

        ["\xF3\xB1\x8A\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xD1\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],

        ["\xF3\xB1\x8A\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xD1\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],

        ["\xF3\xB1\x8A\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xD1\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],

        ["\xF3\xB1\x8A\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xD1\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],

        ["\xF3\xB1\x8A\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xD1\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],

        ["\xF3\xB1\x8A\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xD1\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],

        ["\xF3\xB1\x8A\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xD1\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],

        ["\xF3\xB1\x8A\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xD1\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],

        ["\xF3\xB1\x8A\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xD1\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],

        ["\xF3\xB1\x8A\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xD1\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],

        ["\xF3\xB1\x8A\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xD1\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],

        ["\xF3\xB1\x8A\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xD1\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],

        ["\xF3\xB1\x8A\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xD1\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],

        ["\xF3\xB1\x8A\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xD1\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],

        ["\xF3\xB1\x8A\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xD1\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],

        ["\xF3\xB1\x8A\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xD1\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],

        ["\xF3\xB1\x8A\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xD1\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],

        ["\xF3\xB1\x8A\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xD1\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],

        ["\xF3\xB1\x8A\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xD1\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],

        ["\xF3\xB1\x8A\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xD1\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],

        ["\xF3\xB1\x8A\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xD1\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],

        ["\xF3\xB1\x8A\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xD1\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],

        ["\xF3\xB1\x8A\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xD1\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],

        ["\xF3\xB1\x8A\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xD1\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],

        ["\xF3\xB1\x8A\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xD1\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],

        ["\xF3\xB1\x8B\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xD1\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],

        ["\xF3\xB1\x8B\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xD1\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],

        ["\xF3\xB1\x8B\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xD1\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],

        ["\xF3\xB1\x8B\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xD1\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],

        ["\xF3\xB1\x8B\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xD1\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],

        ["\xF3\xB1\x8B\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xD1\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],

        ["\xF3\xB1\x8B\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xD1\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],

        ["\xF3\xB1\x8B\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xD1\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],

        ["\xF3\xB1\x8B\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xD1\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],

        ["\xF3\xB1\x8B\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xD1\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],

        ["\xF3\xB1\x8B\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xD1\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],

        ["\xF3\xB1\x8B\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xD1\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],

        ["\xF3\xB1\x8B\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xD1\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],

        ["\xF3\xB1\x8B\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xD1\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],

        ["\xF3\xB1\x8B\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xD1\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],

        ["\xF3\xB1\x8B\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xD1\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],

        ["\xF3\xB1\x8B\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xD1\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],

        ["\xF3\xB1\x8B\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xD1\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],

        ["\xF3\xB1\x8B\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xD1\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],

        ["\xF3\xB1\x8B\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xD1\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],

        ["\xF3\xB1\x8B\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xD1\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],

        ["\xF3\xB1\x8B\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xD1\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],

        ["\xF3\xB1\x8B\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xD1\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],

        ["\xF3\xB1\x8B\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xD1\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],

        ["\xF3\xB1\x8B\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xD1\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],

        ["\xF3\xB1\x8B\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xD1\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],

        ["\xF3\xB1\x8B\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xD1\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],

        ["\xF3\xB1\x8B\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xD1\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],

        ["\xF3\xB1\x8B\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xD1\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],

        ["\xF3\xB1\x8B\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xD1\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],

        ["\xF3\xB1\x8B\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xD1\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],

        ["\xF3\xB1\x8B\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xD1\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],

        ["\xF3\xB1\x8B\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xD1\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],

        ["\xF3\xB1\x8B\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xD1\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],

        ["\xF3\xB1\x8B\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xD1\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],

        ["\xF3\xB1\x8B\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xD1\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],

        ["\xF3\xB1\x8B\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xD1\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],

        ["\xF3\xB1\x8B\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xD1\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],

        ["\xF3\xB1\x8B\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xD1\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],

        ["\xF3\xB1\x8B\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xD1\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],

        ["\xF3\xB1\x8B\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xD1\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],

        ["\xF3\xB1\x8B\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xD1\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],

        ["\xF3\xB1\x8B\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xD1\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],

        ["\xF3\xB1\x8B\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xD1\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],

        ["\xF3\xB1\x8B\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xD1\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],

        ["\xF3\xB1\x8B\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xD1\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],

        ["\xF3\xB1\x8B\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xD1\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],

        ["\xF3\xB1\x8B\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xD1\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],

        ["\xF3\xB1\x8B\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xD1\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],

        ["\xF3\xB1\x8B\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xD1\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],

        ["\xF3\xB1\x8B\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xD1\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],

        ["\xF3\xB1\x8B\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xD1\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],

        ["\xF3\xB1\x8B\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xD1\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],

        ["\xF3\xB1\x8B\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xD1\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],

        ["\xF3\xB1\x8B\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xD1\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],

        ["\xF3\xB1\x8B\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xD1\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],

        ["\xF3\xB1\x8B\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xD1\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],

        ["\xF3\xB1\x8B\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xD1\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],

        ["\xF3\xB1\x8B\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xD1\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],

        ["\xF3\xB1\x8B\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xD1\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],

        ["\xF3\xB1\x8B\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xD1\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],

        ["\xF3\xB1\x8B\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xD1\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],

        ["\xF3\xB1\x8B\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xD2\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],

        ["\xF3\xB1\x8B\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xD2\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],

        ["\xF3\xB1\x8C\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xD2\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],

        ["\xF3\xB1\x8C\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xD2\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],

        ["\xF3\xB1\x8C\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xD2\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],

        ["\xF3\xB1\x8C\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xD2\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],

        ["\xF3\xB1\x8C\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xD2\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],

        ["\xF3\xB1\x8C\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xD2\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],

        ["\xF3\xB1\x8C\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xD2\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],

        ["\xF3\xB1\x8C\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xD2\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],

        ["\xF3\xB1\x8C\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xD2\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],

        ["\xF3\xB1\x8C\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xD2\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],

        ["\xF3\xB1\x8C\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xD2\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],

        ["\xF3\xB1\x8C\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xD2\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],

        ["\xF3\xB1\x8C\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xD2\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],

        ["\xF3\xB1\x8C\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xD2\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],

        ["\xF3\xB1\x8C\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xD2\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],

        ["\xF3\xB1\x8C\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xD2\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],

        ["\xF3\xB1\x8C\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xD2\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],

        ["\xF3\xB1\x8C\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xD2\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],

        ["\xF3\xB1\x8C\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xD2\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],

        ["\xF3\xB1\x8C\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xD2\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],

        ["\xF3\xB1\x8C\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xD2\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],

        ["\xF3\xB1\x8C\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xD2\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],

        ["\xF3\xB1\x8C\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xD2\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],

        ["\xF3\xB1\x8C\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xD2\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],

        ["\xF3\xB1\x8C\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xD2\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],

        ["\xF3\xB1\x8C\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xD2\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],

        ["\xF3\xB1\x8C\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xD2\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],

        ["\xF3\xB1\x8C\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xD2\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],

        ["\xF3\xB1\x8C\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xD2\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],

        ["\xF3\xB1\x8C\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xD2\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],

        ["\xF3\xB1\x8C\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xD2\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],

        ["\xF3\xB1\x8C\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xD2\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],

        ["\xF3\xB1\x8C\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xD2\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],

        ["\xF3\xB1\x8C\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xD2\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],

        ["\xF3\xB1\x8C\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xD2\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],

        ["\xF3\xB1\x8C\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xD2\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],

        ["\xF3\xB1\x8C\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xD2\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],

        ["\xF3\xB1\x8C\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xD2\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],

        ["\xF3\xB1\x8C\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xD2\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],

        ["\xF3\xB1\x8C\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xD2\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],

        ["\xF3\xB1\x8C\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xD2\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],

        ["\xF3\xB1\x8C\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xD2\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],

        ["\xF3\xB1\x8C\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xD2\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],

        ["\xF3\xB1\x8C\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xD2\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],

        ["\xF3\xB1\x8C\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xD2\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],

        ["\xF3\xB1\x8C\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xD2\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],

        ["\xF3\xB1\x8C\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xD2\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],

        ["\xF3\xB1\x8C\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xD2\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],

        ["\xF3\xB1\x8C\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xD2\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],

        ["\xF3\xB1\x8C\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xD2\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],

        ["\xF3\xB1\x8C\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xD2\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],

        ["\xF3\xB1\x8C\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xD2\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],

        ["\xF3\xB1\x8C\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xD2\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],

        ["\xF3\xB1\x8C\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xD2\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],

        ["\xF3\xB1\x8C\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xD2\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],

        ["\xF3\xB1\x8C\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xD2\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],

        ["\xF3\xB1\x8C\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xD2\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],

        ["\xF3\xB1\x8C\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xD2\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],

        ["\xF3\xB1\x8C\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xD2\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],

        ["\xF3\xB1\x8C\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xD2\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],

        ["\xF3\xB1\x8C\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xD2\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],

        ["\xF3\xB1\x8C\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xD2\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],

        ["\xF3\xB1\x8C\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xD2\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],

        ["\xF3\xB1\x8C\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xD2\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],

        ["\xF3\xB1\x8D\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xD2\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],

        ["\xF3\xB1\x8D\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xD2\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],

        ["\xF3\xB1\x8D\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xD2\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],

        ["\xF3\xB1\x8D\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xD2\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],

        ["\xF3\xB1\x8D\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xD2\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],

        ["\xF3\xB1\x8D\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xD2\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],

        ["\xF3\xB1\x8D\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xD2\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],

        ["\xF3\xB1\x8D\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xD2\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],

        ["\xF3\xB1\x8D\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xD2\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],

        ["\xF3\xB1\x8D\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xD2\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],

        ["\xF3\xB1\x8D\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xD2\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],

        ["\xF3\xB1\x8D\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xD2\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],

        ["\xF3\xB1\x8D\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xD2\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],

        ["\xF3\xB1\x8D\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xD2\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],

        ["\xF3\xB1\x8D\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xD2\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],

        ["\xF3\xB1\x8D\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xD2\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],

        ["\xF3\xB1\x8D\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xD2\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],

        ["\xF3\xB1\x8D\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xD2\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],

        ["\xF3\xB1\x8D\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xD2\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],

        ["\xF3\xB1\x8D\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xD2\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],

        ["\xF3\xB1\x8D\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xD2\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],

        ["\xF3\xB1\x8D\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xD2\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],

        ["\xF3\xB1\x8D\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xD2\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],

        ["\xF3\xB1\x8D\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xD2\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],

        ["\xF3\xB1\x8D\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xD2\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],

        ["\xF3\xB1\x8D\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xD2\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],

        ["\xF3\xB1\x8D\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xD2\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],

        ["\xF3\xB1\x8D\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xD2\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],

        ["\xF3\xB1\x8D\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xD3\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],

        ["\xF3\xB1\x8D\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xD3\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],

        ["\xF3\xB1\x8D\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xD3\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],

        ["\xF3\xB1\x8D\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xD3\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],

        ["\xF3\xB1\x8D\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xD3\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],

        ["\xF3\xB1\x8D\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xD3\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],

        ["\xF3\xB1\x8D\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xD3\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],

        ["\xF3\xB1\x8D\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xD3\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],

        ["\xF3\xB1\x8D\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xD3\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],

        ["\xF3\xB1\x8D\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xD3\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],

        ["\xF3\xB1\x8D\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xD3\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],

        ["\xF3\xB1\x8D\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xD3\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],

        ["\xF3\xB1\x8D\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xD3\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],

        ["\xF3\xB1\x8D\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xD3\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],

        ["\xF3\xB1\x8D\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xD3\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],

        ["\xF3\xB1\x8D\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xD3\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],

        ["\xF3\xB1\x8D\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xD3\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],

        ["\xF3\xB1\x8D\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xD3\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],

        ["\xF3\xB1\x8D\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xD3\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],

        ["\xF3\xB1\x8D\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xD3\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],

        ["\xF3\xB1\x8D\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xD3\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],

        ["\xF3\xB1\x8D\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xD3\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],

        ["\xF3\xB1\x8D\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xD3\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],

        ["\xF3\xB1\x8D\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xD3\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],

        ["\xF3\xB1\x8D\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xD3\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],

        ["\xF3\xB1\x8D\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xD3\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],

        ["\xF3\xB1\x8D\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xD3\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],

        ["\xF3\xB1\x8D\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xD3\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],

        ["\xF3\xB1\x8D\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xD3\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],

        ["\xF3\xB1\x8D\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xD3\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],

        ["\xF3\xB1\x8D\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xD3\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],

        ["\xF3\xB1\x8D\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xD3\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],

        ["\xF3\xB1\x8D\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xD3\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],

        ["\xF3\xB1\x8D\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xD3\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],

        ["\xF3\xB1\x8D\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xD3\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],

        ["\xF3\xB1\x8D\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xD3\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],

        ["\xF3\xB1\x8E\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xD3\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],

        ["\xF3\xB1\x8E\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xD3\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],

        ["\xF3\xB1\x8E\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xD3\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],

        ["\xF3\xB1\x8E\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xD3\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],

        ["\xF3\xB1\x8E\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xD3\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],

        ["\xF3\xB1\x8E\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xD3\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],

        ["\xF3\xB1\x8E\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xD3\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],

        ["\xF3\xB1\x8E\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xD3\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],

        ["\xF3\xB1\x8E\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xD3\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],

        ["\xF3\xB1\x8E\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xD3\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],

        ["\xF3\xB1\x8E\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xD3\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],

        ["\xF3\xB1\x8E\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xD3\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],

        ["\xF3\xB1\x8E\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xD3\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],

        ["\xF3\xB1\x8E\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xD3\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],

        ["\xF3\xB1\x8E\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xD3\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],

        ["\xF3\xB1\x8E\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xD3\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],

        ["\xF3\xB1\x8E\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xD3\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],

        ["\xF3\xB1\x8E\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xD3\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],

        ["\xF3\xB1\x8E\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xD3\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],

        ["\xF3\xB1\x8E\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xD3\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],

        ["\xF3\xB1\x8E\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xD3\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],

        ["\xF3\xB1\x8E\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xD3\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],

        ["\xF3\xB1\x8E\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xD3\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],

        ["\xF3\xB1\x8E\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xD3\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],

        ["\xF3\xB1\x8E\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xD3\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],

        ["\xF3\xB1\x8E\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xD3\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],

        ["\xF3\xB1\x8E\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xD3\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],

        ["\xF3\xB1\x8E\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xD3\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],

        ["\xF3\xB1\x8E\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xD3\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],

        ["\xF3\xB1\x8E\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xD3\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],

        ["\xF3\xB1\x8E\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xD3\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],

        ["\xF3\xB1\x8E\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xD3\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],

        ["\xF3\xB1\x8E\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xD3\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],

        ["\xF3\xB1\x8E\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xD3\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],

        ["\xF3\xB1\x8E\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xD3\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],

        ["\xF3\xB1\x8E\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xD3\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],

        ["\xF3\xB1\x8E\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xD3\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],

        ["\xF3\xB1\x8E\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xD3\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],

        ["\xF3\xB1\x8E\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xD3\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],

        ["\xF3\xB1\x8E\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xD3\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],

        ["\xF3\xB1\x8E\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xD3\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],

        ["\xF3\xB1\x8E\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xD3\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],

        ["\xF3\xB1\x8E\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xD3\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],

        ["\xF3\xB1\x8E\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xD3\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],

        ["\xF3\xB1\x8E\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xD3\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],

        ["\xF3\xB1\x8E\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xD3\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],

        ["\xF3\xB1\x8E\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xD3\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],

        ["\xF3\xB1\x8E\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xD3\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],

        ["\xF3\xB1\x8E\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xD3\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],

        ["\xF3\xB1\x8E\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xD3\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],

        ["\xF3\xB1\x8E\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xD3\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],

        ["\xF3\xB1\x8E\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xD3\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],

        ["\xF3\xB1\x8E\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xD3\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],

        ["\xF3\xB1\x8E\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xD3\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],

        ["\xF3\xB1\x8E\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xD3\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],

        ["\xF3\xB1\x8E\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xD3\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],

        ["\xF3\xB1\x8E\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xD3\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],

        ["\xF3\xB1\x8E\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xD3\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],

        ["\xF3\xB1\x8E\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xD4\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],

        ["\xF3\xB1\x8E\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xD4\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],

        ["\xF3\xB1\x8E\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xD4\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],

        ["\xF3\xB1\x8E\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xD4\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],

        ["\xF3\xB1\x8E\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xD4\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],

        ["\xF3\xB1\x8E\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xD4\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],

        ["\xF3\xB1\x8F\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xD4\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],

        ["\xF3\xB1\x8F\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xD4\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],

        ["\xF3\xB1\x8F\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xD4\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],

        ["\xF3\xB1\x8F\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xD4\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],

        ["\xF3\xB1\x8F\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xD4\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],

        ["\xF3\xB1\x8F\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xD4\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],

        ["\xF3\xB1\x8F\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xD4\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],

        ["\xF3\xB1\x8F\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xD4\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],

        ["\xF3\xB1\x8F\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xD4\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],

        ["\xF3\xB1\x8F\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xD4\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],

        ["\xF3\xB1\x8F\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xD4\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],

        ["\xF3\xB1\x8F\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xD4\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],

        ["\xF3\xB1\x8F\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xD4\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],

        ["\xF3\xB1\x8F\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xD4\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],

        ["\xF3\xB1\x8F\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xD4\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],

        ["\xF3\xB1\x8F\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xD4\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],

        ["\xF3\xB1\x8F\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xD4\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],

        ["\xF3\xB1\x8F\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xD4\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],

        ["\xF3\xB1\x8F\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xD4\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],

        ["\xF3\xB1\x8F\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xD4\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],

        ["\xF3\xB1\x8F\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xD4\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],

        ["\xF3\xB1\x8F\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xD4\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],

        ["\xF3\xB1\x8F\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xD4\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],

        ["\xF3\xB1\x8F\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xD4\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],

        ["\xF3\xB1\x8F\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xD4\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],

        ["\xF3\xB1\x8F\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xD4\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],

        ["\xF3\xB1\x8F\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xD4\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],

        ["\xF3\xB1\x8F\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xD4\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],

        ["\xF3\xB1\x8F\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xD4\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],

        ["\xF3\xB1\x8F\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xD4\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],

        ["\xF3\xB1\x8F\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xD4\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],

        ["\xF3\xB1\x8F\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xD4\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],

        ["\xF3\xB1\x8F\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xD4\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],

        ["\xF3\xB1\x8F\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xD4\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],

        ["\xF3\xB1\x8F\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xD4\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],

        ["\xF3\xB1\x8F\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xD4\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],

        ["\xF3\xB1\x8F\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xD4\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],

        ["\xF3\xB1\x8F\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xD4\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],

        ["\xF3\xB1\x8F\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xD4\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],

        ["\xF3\xB1\x8F\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xD4\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],

        ["\xF3\xB1\x8F\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xD4\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],

        ["\xF3\xB1\x8F\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xD4\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],

        ["\xF3\xB1\x8F\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xD4\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],

        ["\xF3\xB1\x8F\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xD4\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],

        ["\xF3\xB1\x8F\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xD4\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],

        ["\xF3\xB1\x8F\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xD4\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],

        ["\xF3\xB1\x8F\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xD4\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],

        ["\xF3\xB1\x8F\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xD4\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],

        ["\xF3\xB1\x8F\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xD4\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],

        ["\xF3\xB1\x8F\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xD4\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],

        ["\xF3\xB1\x8F\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xD4\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],

        ["\xF3\xB1\x8F\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xD4\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],

        ["\xF3\xB1\x8F\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xD4\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],

        ["\xF3\xB1\x8F\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xD4\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],

        ["\xF3\xB1\x8F\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xD4\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],

        ["\xF3\xB1\x8F\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xD4\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],

        ["\xF3\xB1\x8F\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xD4\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],

        ["\xF3\xB1\x8F\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xD4\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],

        ["\xF3\xB1\x8F\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xD4\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],

        ["\xF3\xB1\x8F\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xD4\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],

        ["\xF3\xB1\x8F\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xD4\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],

        ["\xF3\xB1\x8F\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xC4\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],

        ["\xF3\xB1\x8F\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xD4\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],

        ["\xF3\xB1\x8F\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xD4\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],

        ["\xF3\xB1\x90\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xD4\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],

        ["\xF3\xB1\x90\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xD4\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],

        ["\xF3\xB1\x90\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xD4\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],

        ["\xF3\xB1\x90\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xD4\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],

        ["\xF3\xB1\x90\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xD4\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],

        ["\xF3\xB1\x90\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xD4\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],

        ["\xF3\xB1\x90\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xD4\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],

        ["\xF3\xB1\x90\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xD4\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],

        ["\xF3\xB1\x90\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xD4\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],

        ["\xF3\xB1\x90\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xD4\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],

        ["\xF3\xB1\x90\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xD4\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],

        ["\xF3\xB1\x90\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xD4\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],

        ["\xF3\xB1\x90\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xD4\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],

        ["\xF3\xB1\x90\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xD4\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],

        ["\xF3\xB1\x90\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xD4\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],

        ["\xF3\xB1\x90\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xD4\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],

        ["\xF3\xB1\x90\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xD4\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],

        ["\xF3\xB1\x90\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xD4\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],

        ["\xF3\xB1\x90\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xD4\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],

        ["\xF3\xB1\x90\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xD4\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],

        ["\xF3\xB1\x90\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xD4\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],

        ["\xF3\xB1\x90\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xD4\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],

        ["\xF3\xB1\x90\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xD4\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],

        ["\xF3\xB1\x90\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xD4\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],

        ["\xF3\xB1\x90\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xD5\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],

        ["\xF3\xB1\x90\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xD5\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],

        ["\xF3\xB1\x90\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xD5\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],

        ["\xF3\xB1\x90\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xD5\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],

        ["\xF3\xB1\x90\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xD5\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],

        ["\xF3\xB1\x90\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xD5\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],

        ["\xF3\xB1\x90\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xD5\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],

        ["\xF3\xB1\x90\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xD5\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],

        ["\xF3\xB1\x90\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xD5\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],

        ["\xF3\xB1\x90\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xD5\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],

        ["\xF3\xB1\x90\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xD5\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],

        ["\xF3\xB1\x90\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xD5\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],

        ["\xF3\xB1\x90\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xD5\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],

        ["\xF3\xB1\x90\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xD5\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],

        ["\xF3\xB1\x90\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xD5\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],

        ["\xF3\xB1\x90\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xD5\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],

        ["\xF3\xB1\x90\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xD5\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],

        ["\xF3\xB1\x90\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xD5\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],

        ["\xF3\xB1\x90\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xD5\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],

        ["\xF3\xB1\x90\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xD5\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],

        ["\xF3\xB1\x90\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xD5\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],

        ["\xF3\xB1\x90\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xD5\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],

        ["\xF3\xB1\x90\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xD5\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],

        ["\xF3\xB1\x90\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xD5\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],

        ["\xF3\xB1\x90\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xD5\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],

        ["\xF3\xB1\x90\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xD5\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],

        ["\xF3\xB1\x90\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xD5\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],

        ["\xF3\xB1\x90\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xD5\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],

        ["\xF3\xB1\x90\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xD5\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],

        ["\xF3\xB1\x90\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xD5\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],

        ["\xF3\xB1\x90\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xD5\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],

        ["\xF3\xB1\x90\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xD5\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],

        ["\xF3\xB1\x90\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xD5\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],

        ["\xF3\xB1\x90\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xD5\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],

        ["\xF3\xB1\x90\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xD5\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],

        ["\xF3\xB1\x90\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xD5\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],

        ["\xF3\xB1\x90\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xD5\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],

        ["\xF3\xB1\x90\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xD5\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],

        ["\xF3\xB1\x90\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xD5\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],

        ["\xF3\xB1\x90\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xD5\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],

        ["\xF3\xB1\x91\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xD5\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],

        ["\xF3\xB1\x91\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xD5\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],

        ["\xF3\xB1\x91\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xD5\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],

        ["\xF3\xB1\x91\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xD5\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],

        ["\xF3\xB1\x91\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xD5\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],

        ["\xF3\xB1\x91\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xD5\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],

        ["\xF3\xB1\x91\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xD5\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],

        ["\xF3\xB1\x91\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xD5\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],

        ["\xF3\xB1\x91\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xD5\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],

        ["\xF3\xB1\x91\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xD5\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],

        ["\xF3\xB1\x91\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xD5\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],

        ["\xF3\xB1\x91\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xD5\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],

        ["\xF3\xB1\x91\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xD5\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],

        ["\xF3\xB1\x91\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xD5\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],

        ["\xF3\xB1\x91\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xD5\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],

        ["\xF3\xB1\x91\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xD5\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],

        ["\xF3\xB1\x91\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xD5\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],

        ["\xF3\xB1\x91\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xD5\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],

        ["\xF3\xB1\x91\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xD5\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],

        ["\xF3\xB1\x91\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xD5\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],

        ["\xF3\xB1\x91\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xD5\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],

        ["\xF3\xB1\x91\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xD5\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],

        ["\xF3\xB1\x91\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xD5\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],

        ["\xF3\xB1\x91\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xD5\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],

        ["\xF3\xB1\x91\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xD5\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],

        ["\xF3\xB1\x91\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xD5\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],

        ["\xF3\xB1\x91\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xD5\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],

        ["\xF3\xB1\x91\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xD5\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],

        ["\xF3\xB1\x91\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xD5\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],

        ["\xF3\xB1\x91\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xD5\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],

        ["\xF3\xB1\x91\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xD5\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],

        ["\xF3\xB1\x91\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xD5\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],

        ["\xF3\xB1\x91\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xD5\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],

        ["\xF3\xB1\x91\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xD5\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],

        ["\xF3\xB1\x91\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xD5\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],

        ["\xF3\xB1\x91\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xD5\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],

        ["\xF3\xB1\x91\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xD5\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],

        ["\xF3\xB1\x91\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xD5\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],

        ["\xF3\xB1\x91\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xD5\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],

        ["\xF3\xB1\x91\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xD5\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],

        ["\xF3\xB1\x91\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xD5\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],

        ["\xF3\xB1\x91\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xD5\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],

        ["\xF3\xB1\x91\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xD5\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],

        ["\xF3\xB1\x91\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xD5\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],

        ["\xF3\xB1\x91\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xD5\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],

        ["\xF3\xB1\x91\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xD5\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],

        ["\xF3\xB1\x91\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xD5\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],

        ["\xF3\xB1\x91\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xD5\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],

        ["\xF3\xB1\x91\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xD5\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],

        ["\xF3\xB1\x91\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xD5\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],

        ["\xF3\xB1\x91\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xD5\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],

        ["\xF3\xB1\x91\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xD5\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],

        ["\xF3\xB1\x91\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xD5\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],

        ["\xF3\xB1\x91\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xD5\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],

        ["\xF3\xB1\x91\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xD6\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],

        ["\xF3\xB1\x91\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xD6\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],

        ["\xF3\xB1\x91\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xD6\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],

        ["\xF3\xB1\x91\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xD6\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],

        ["\xF3\xB1\x91\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xD6\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],

        ["\xF3\xB1\x91\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xD6\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],

        ["\xF3\xB1\x91\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xD6\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],

        ["\xF3\xB1\x91\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xD6\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],

        ["\xF3\xB1\x91\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xD6\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],

        ["\xF3\xB1\x91\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xD6\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],

        ["\xF3\xB1\x92\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xD6\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],

        ["\xF3\xB1\x92\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xD6\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],

        ["\xF3\xB1\x92\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xD6\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],

        ["\xF3\xB1\x92\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xD6\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],

        ["\xF3\xB1\x92\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xD6\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],

        ["\xF3\xB1\x92\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xD6\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],

        ["\xF3\xB1\x92\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xD6\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],

        ["\xF3\xB1\x92\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xD6\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],

        ["\xF3\xB1\x92\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xD6\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],

        ["\xF3\xB1\x92\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xD6\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],

        ["\xF3\xB1\x92\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xD6\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],

        ["\xF3\xB1\x92\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xD6\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],

        ["\xF3\xB1\x92\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xD6\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],

        ["\xF3\xB1\x92\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xD6\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],

        ["\xF3\xB1\x92\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xD6\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],

        ["\xF3\xB1\x92\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xD6\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],

        ["\xF3\xB1\x92\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xD6\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],

        ["\xF3\xB1\x92\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xD6\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],

        ["\xF3\xB1\x92\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xD6\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],

        ["\xF3\xB1\x92\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xD6\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],

        ["\xF3\xB1\x92\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xD6\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],

        ["\xF3\xB1\x92\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xD6\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],

        ["\xF3\xB1\x92\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xD6\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],

        ["\xF3\xB1\x92\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xD6\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],

        ["\xF3\xB1\x92\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xD6\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],

        ["\xF3\xB1\x92\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xD6\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],

        ["\xF3\xB1\x92\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xD6\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],

        ["\xF3\xB1\x92\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xD6\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],

        ["\xF3\xB1\x92\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xD6\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],

        ["\xF3\xB1\x92\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xD6\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],

        ["\xF3\xB1\x92\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xD6\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],

        ["\xF3\xB1\x92\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xD6\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],

        ["\xF3\xB1\x92\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xD6\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],

        ["\xF3\xB1\x92\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xD6\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],

        ["\xF3\xB1\x92\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xD6\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],

        ["\xF3\xB1\x92\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xD6\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],

        ["\xF3\xB1\x92\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xD6\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],

        ["\xF3\xB1\x92\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xD6\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],

        ["\xF3\xB1\x92\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xD6\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],

        ["\xF3\xB1\x92\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xD6\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],

        ["\xF3\xB1\x92\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xD6\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],

        ["\xF3\xB1\x92\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xD6\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],

        ["\xF3\xB1\x92\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xD6\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],

        ["\xF3\xB1\x92\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xD6\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],

        ["\xF3\xB1\x92\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xD6\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],

        ["\xF3\xB1\x92\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xD6\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],

        ["\xF3\xB1\x92\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xD6\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],

        ["\xF3\xB1\x92\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xD6\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],

        ["\xF3\xB1\x92\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xD6\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],

        ["\xF3\xB1\x92\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xD6\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],

        ["\xF3\xB1\x92\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xD6\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],

        ["\xF3\xB1\x92\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xD6\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],

        ["\xF3\xB1\x92\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xD6\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],

        ["\xF3\xB1\x92\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xD6\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],

        ["\xF3\xB1\x92\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xD6\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],

        ["\xF3\xB1\x92\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xD6\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],

        ["\xF3\xB1\x92\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xD6\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],

        ["\xF3\xB1\x92\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xD6\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],

        ["\xF3\xB1\x92\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xD6\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],

        ["\xF3\xB1\x92\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xD6\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],

        ["\xF3\xB1\x92\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xD6\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],

        ["\xF3\xB1\x92\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xD6\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],

        ["\xF3\xB1\x92\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xD6\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],

        ["\xF3\xB1\x92\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xD6\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],

        ["\xF3\xB1\x93\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xD6\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],

        ["\xF3\xB1\x93\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xD6\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],

        ["\xF3\xB1\x93\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xD6\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],

        ["\xF3\xB1\x93\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xD6\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],

        ["\xF3\xB1\x93\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xD6\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],

        ["\xF3\xB1\x93\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xD6\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],

        ["\xF3\xB1\x93\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xD6\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],

        ["\xF3\xB1\x93\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xD6\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],

        ["\xF3\xB1\x93\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xD6\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],

        ["\xF3\xB1\x93\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xD6\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],

        ["\xF3\xB1\x93\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xD6\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],

        ["\xF3\xB1\x93\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xD6\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],

        ["\xF3\xB1\x93\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xD6\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],

        ["\xF3\xB1\x93\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xD6\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],

        ["\xF3\xB1\x93\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xD6\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],

        ["\xF3\xB1\x93\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xD6\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],

        ["\xF3\xB1\x93\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xD6\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],

        ["\xF3\xB1\x93\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xD6\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],

        ["\xF3\xB1\x93\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xD6\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],

        ["\xF3\xB1\x93\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xD6\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],

        ["\xF3\xB1\x93\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xD7\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],

        ["\xF3\xB1\x93\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xD7\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],

        ["\xF3\xB1\x93\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xD7\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],

        ["\xF3\xB1\x93\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xD7\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],

        ["\xF3\xB1\x93\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xD7\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],

        ["\xF3\xB1\x93\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xD7\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],

        ["\xF3\xB1\x93\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xD7\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],

        ["\xF3\xB1\x93\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xD7\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],

        ["\xF3\xB1\x93\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xD7\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],

        ["\xF3\xB1\x93\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xD7\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],

        ["\xF3\xB1\x93\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xD7\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],

        ["\xF3\xB1\x93\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xD7\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],

        ["\xF3\xB1\x93\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xD7\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],

        ["\xF3\xB1\x93\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xD7\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],

        ["\xF3\xB1\x93\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xD7\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],

        ["\xF3\xB1\x93\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xD7\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],

        ["\xF3\xB1\x93\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xD7\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],

        ["\xF3\xB1\x93\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xD7\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],

        ["\xF3\xB1\x93\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xD7\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],

        ["\xF3\xB1\x93\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xD7\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],

        ["\xF3\xB1\x93\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xD7\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],

        ["\xF3\xB1\x93\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xD7\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],

        ["\xF3\xB1\x93\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xD7\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],

        ["\xF3\xB1\x93\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xD7\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],

        ["\xF3\xB1\x93\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xD7\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],

        ["\xF3\xB1\x93\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xD7\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],

        ["\xF3\xB1\x93\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xD7\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],

        ["\xF3\xB1\x93\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xD7\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],

        ["\xF3\xB1\x93\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xD7\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],

        ["\xF3\xB1\x93\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xD7\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],

        ["\xF3\xB1\x93\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xD7\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],

        ["\xF3\xB1\x93\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xD7\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],

        ["\xF3\xB1\x93\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xD7\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],

        ["\xF3\xB1\x93\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xD7\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],

        ["\xF3\xB1\x93\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xD7\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],

        ["\xF3\xB1\x93\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xD7\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],

        ["\xF3\xB1\x93\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xD7\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],

        ["\xF3\xB1\x93\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xD7\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],

        ["\xF3\xB1\x93\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xD7\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],

        ["\xF3\xB1\x93\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xD7\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],

        ["\xF3\xB1\x93\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xD7\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],

        ["\xF3\xB1\x93\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xD7\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],

        ["\xF3\xB1\x93\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xD7\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],

        ["\xF3\xB1\x94\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xD7\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],

        ["\xF3\xB1\x94\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xD7\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],

        ["\xF3\xB1\x94\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xD7\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],

        ["\xF3\xB1\x94\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xD7\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],

        ["\xF3\xB1\x94\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xD7\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],

        ["\xF3\xB1\x94\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xD7\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],

        ["\xF3\xB1\x94\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xD7\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],

        ["\xF3\xB1\x94\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xD7\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],

        ["\xF3\xB1\x94\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xD7\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],

        ["\xF3\xB1\x94\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xD7\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],

        ["\xF3\xB1\x94\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xD7\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],

        ["\xF3\xB1\x94\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xD7\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],

        ["\xF3\xB1\x94\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xD7\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],

        ["\xF3\xB1\x94\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xD7\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],

        ["\xF3\xB1\x94\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xD7\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],

        ["\xF3\xB1\x94\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xD7\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],

        ["\xF3\xB1\x94\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xD7\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],

        ["\xF3\xB1\x94\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xD7\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],

        ["\xF3\xB1\x94\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xD7\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],

        ["\xF3\xB1\x94\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xD7\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],

        ["\xF3\xB1\x94\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xD7\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],

        ["\xF3\xB1\x94\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xD7\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],

        ["\xF3\xB1\x94\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xD7\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],

        ["\xF3\xB1\x94\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xD7\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],

        ["\xF3\xB1\x94\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xD7\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],

        ["\xF3\xB1\x94\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xD7\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],

        ["\xF3\xB1\x94\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xD7\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],

        ["\xF3\xB1\x94\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xD7\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],

        ["\xF3\xB1\x94\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xD7\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],

        ["\xF3\xB1\x94\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xD7\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],

        ["\xF3\xB1\x94\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xD7\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],

        ["\xF3\xB1\x94\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xD7\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],

        ["\xF3\xB1\x94\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xD7\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],

        ["\xF3\xB1\x94\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xD7\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],

        ["\xF3\xB1\x94\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xD7\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],

        ["\xF3\xB1\x94\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xD7\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],

        ["\xF3\xB1\x94\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xD7\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],

        ["\xF3\xB1\x94\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xD7\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],

        ["\xF3\xB1\x94\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xD7\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],

        ["\xF3\xB1\x94\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xD7\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],

        ["\xF3\xB1\x94\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xD7\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],

        ["\xF3\xB1\x94\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xD7\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],

        ["\xF3\xB1\x94\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xD7\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],

        ["\xF3\xB1\x94\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xD7\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],

        ["\xF3\xB1\x94\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xD7\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],

        ["\xF3\xB1\x94\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xD7\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],

        ["\xF3\xB1\x94\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xD7\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],

        ["\xF3\xB1\x94\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xD7\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],

        ["\xF3\xB1\x94\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xD7\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],

        ["\xF3\xB1\x94\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xD7\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],

        ["\xF3\xB1\x94\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xD8\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],

        ["\xF3\xB1\x94\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xD8\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],

        ["\xF3\xB1\x94\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xD8\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],

        ["\xF3\xB1\x94\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xD8\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],

        ["\xF3\xB1\x94\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xD8\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],

        ["\xF3\xB1\x94\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xD8\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],

        ["\xF3\xB1\x94\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xD8\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],

        ["\xF3\xB1\x94\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xD8\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],

        ["\xF3\xB1\x94\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xD8\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],

        ["\xF3\xB1\x94\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xD8\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],

        ["\xF3\xB1\x94\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xD8\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],

        ["\xF3\xB1\x94\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xD8\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],

        ["\xF3\xB1\x94\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xD8\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],

        ["\xF3\xB1\x94\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xD8\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],

        ["\xF3\xB1\x95\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xD8\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],

        ["\xF3\xB1\x95\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xD8\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],

        ["\xF3\xB1\x95\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xD8\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],

        ["\xF3\xB1\x95\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xD8\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],

        ["\xF3\xB1\x95\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xD8\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],

        ["\xF3\xB1\x95\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xD8\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],

        ["\xF3\xB1\x95\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xD8\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],

        ["\xF3\xB1\x95\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xD8\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],

        ["\xF3\xB1\x95\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xD8\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],

        ["\xF3\xB1\x95\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xD8\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],

        ["\xF3\xB1\x95\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xD8\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],

        ["\xF3\xB1\x95\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xD8\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],

        ["\xF3\xB1\x95\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xD8\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],

        ["\xF3\xB1\x95\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xD8\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],

        ["\xF3\xB1\x95\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xD8\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],

        ["\xF3\xB1\x95\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xD8\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],

        ["\xF3\xB1\x95\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xD8\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],

        ["\xF3\xB1\x95\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xD8\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],

        ["\xF3\xB1\x95\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xD8\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],

        ["\xF3\xB1\x95\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xD8\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],

        ["\xF3\xB1\x95\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xD8\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],

        ["\xF3\xB1\x95\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xD8\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],

        ["\xF3\xB1\x95\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xD8\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],

        ["\xF3\xB1\x95\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xD8\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],

        ["\xF3\xB1\x95\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xD8\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],

        ["\xF3\xB1\x95\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xD8\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],

        ["\xF3\xB1\x95\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xD8\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],

        ["\xF3\xB1\x95\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xD8\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],

        ["\xF3\xB1\x95\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xD8\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],

        ["\xF3\xB1\x95\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xD8\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],

        ["\xF3\xB1\x95\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xD8\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],

        ["\xF3\xB1\x95\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xD8\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],

        ["\xF3\xB1\x95\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xD8\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],

        ["\xF3\xB1\x95\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xD8\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],

        ["\xF3\xB1\x95\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xD8\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],

        ["\xF3\xB1\x95\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xD8\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],

        ["\xF3\xB1\x95\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xD8\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],

        ["\xF3\xB1\x95\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xD8\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],

        ["\xF3\xB1\x95\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xD8\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],

        ["\xF3\xB1\x95\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xD8\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],

        ["\xF3\xB1\x95\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xD8\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],

        ["\xF3\xB1\x95\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xD8\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],

        ["\xF3\xB1\x95\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xD8\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],

        ["\xF3\xB1\x95\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xD8\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],

        ["\xF3\xB1\x95\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xD8\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],

        ["\xF3\xB1\x95\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xD8\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],

        ["\xF3\xB1\x95\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xD8\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],

        ["\xF3\xB1\x95\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xD8\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],

        ["\xF3\xB1\x95\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xD8\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],

        ["\xF3\xB1\x95\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xD8\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],

        ["\xF3\xB1\x95\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xD8\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],

        ["\xF3\xB1\x95\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xD8\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],

        ["\xF3\xB1\x95\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xD8\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],

        ["\xF3\xB1\x95\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xD8\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],

        ["\xF3\xB1\x95\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xD8\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],

        ["\xF3\xB1\x95\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xD8\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],

        ["\xF3\xB1\x95\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xD8\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],

        ["\xF3\xB1\x95\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xD8\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],

        ["\xF3\xB1\x95\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xD8\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],

        ["\xF3\xB1\x95\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xD8\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],

        ["\xF3\xB1\x95\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xD8\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],

        ["\xF3\xB1\x95\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xD8\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],

        ["\xF3\xB1\x95\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xD8\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],

        ["\xF3\xB1\x95\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xD8\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],

        ["\xF3\xB1\x96\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xD8\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],

        ["\xF3\xB1\x96\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xD8\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],

        ["\xF3\xB1\x96\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xD8\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],

        ["\xF3\xB1\x96\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xD8\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],

        ["\xF3\xB1\x96\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xD8\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],

        ["\xF3\xB1\x96\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xD8\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],

        ["\xF3\xB1\x96\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xD8\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],

        ["\xF3\xB1\x96\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xD8\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],

        ["\xF3\xB1\x96\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xD8\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],

        ["\xF3\xB1\x96\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xD8\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],

        ["\xF3\xB1\x96\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xD8\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],

        ["\xF3\xB1\x96\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xD8\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],

        ["\xF3\xB1\x96\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xD8\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],

        ["\xF3\xB1\x96\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xD8\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],

        ["\xF3\xB1\x96\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xD8\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],

        ["\xF3\xB1\x96\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xD8\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],

        ["\xF3\xB1\x96\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xD9\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],

        ["\xF3\xB1\x96\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xD9\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],

        ["\xF3\xB1\x96\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xD9\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],

        ["\xF3\xB1\x96\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xD9\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],

        ["\xF3\xB1\x96\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xD9\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],

        ["\xF3\xB1\x96\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xD9\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],

        ["\xF3\xB1\x96\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xD9\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],

        ["\xF3\xB1\x96\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xD9\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],

        ["\xF3\xB1\x96\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xD9\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],

        ["\xF3\xB1\x96\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xD9\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],

        ["\xF3\xB1\x96\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xD9\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],

        ["\xF3\xB1\x96\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xD9\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],

        ["\xF3\xB1\x96\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xD9\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],

        ["\xF3\xB1\x96\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xD9\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],

        ["\xF3\xB1\x96\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xD9\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],

        ["\xF3\xB1\x96\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xD9\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],

        ["\xF3\xB1\x96\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xD9\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],

        ["\xF3\xB1\x96\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xD9\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],

        ["\xF3\xB1\x96\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xD9\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],

        ["\xF3\xB1\x96\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xD9\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],

        ["\xF3\xB1\x96\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xD9\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],

        ["\xF3\xB1\x96\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xD9\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],

        ["\xF3\xB1\x96\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xD9\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],

        ["\xF3\xB1\x96\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xD9\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],

        ["\xF3\xB1\x96\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xD9\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],

        ["\xF3\xB1\x96\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xD9\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],

        ["\xF3\xB1\x96\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xD9\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],

        ["\xF3\xB1\x96\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xD9\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],

        ["\xF3\xB1\x96\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xD9\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],

        ["\xF3\xB1\x96\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xD9\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],

        ["\xF3\xB1\x96\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xD9\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],

        ["\xF3\xB1\x96\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xD9\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],

        ["\xF3\xB1\x96\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xD9\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],

        ["\xF3\xB1\x96\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xD9\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],

        ["\xF3\xB1\x96\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xD9\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],

        ["\xF3\xB1\x96\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xD9\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],

        ["\xF3\xB1\x96\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xD9\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],

        ["\xF3\xB1\x96\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xD9\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],

        ["\xF3\xB1\x96\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xD9\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],

        ["\xF3\xB1\x96\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xD9\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],

        ["\xF3\xB1\x96\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xD9\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],

        ["\xF3\xB1\x96\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xD9\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],

        ["\xF3\xB1\x96\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xD9\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],

        ["\xF3\xB1\x96\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xD9\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],

        ["\xF3\xB1\x96\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xD9\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],

        ["\xF3\xB1\x96\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xD9\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],

        ["\xF3\xB1\x96\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xD9\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],

        ["\xF3\xB1\x96\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xD9\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],

        ["\xF3\xB1\x97\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xD9\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],

        ["\xF3\xB1\x97\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xD9\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],

        ["\xF3\xB1\x97\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xD9\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],

        ["\xF3\xB1\x97\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xD9\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],

        ["\xF3\xB1\x97\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xD9\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],

        ["\xF3\xB1\x97\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xD9\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],

        ["\xF3\xB1\x97\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xD9\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],

        ["\xF3\xB1\x97\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xD9\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],

        ["\xF3\xB1\x97\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xD9\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],

        ["\xF3\xB1\x97\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xD9\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],

        ["\xF3\xB1\x97\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xD9\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],

        ["\xF3\xB1\x97\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xD9\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],

        ["\xF3\xB1\x97\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xD9\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],

        ["\xF3\xB1\x97\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xD9\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],

        ["\xF3\xB1\x97\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xD9\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],

        ["\xF3\xB1\x97\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xD9\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],

        ["\xF3\xB1\x97\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xD9\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],

        ["\xF3\xB1\x97\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xD9\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],

        ["\xF3\xB1\x97\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xD9\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],

        ["\xF3\xB1\x97\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xD9\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],

        ["\xF3\xB1\x97\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xD9\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],

        ["\xF3\xB1\x97\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xD9\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],

        ["\xF3\xB1\x97\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xD9\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],

        ["\xF3\xB1\x97\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xD9\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],

        ["\xF3\xB1\x97\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xD9\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],

        ["\xF3\xB1\x97\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xD9\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],

        ["\xF3\xB1\x97\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xD9\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],

        ["\xF3\xB1\x97\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xD9\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],

        ["\xF3\xB1\x97\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xD9\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],

        ["\xF3\xB1\x97\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xD9\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],

        ["\xF3\xB1\x97\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xD9\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],

        ["\xF3\xB1\x97\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xD9\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],

        ["\xF3\xB1\x97\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xD9\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],

        ["\xF3\xB1\x97\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xD9\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],

        ["\xF3\xB1\x97\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xD9\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],

        ["\xF3\xB1\x97\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xD9\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],

        ["\xF3\xB1\x97\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xD9\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],

        ["\xF3\xB1\x97\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xD9\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],

        ["\xF3\xB1\x97\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xD9\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],

        ["\xF3\xB1\x97\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xB3\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],

        ["\xF3\xB1\x97\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xD9\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],

        ["\xF3\xB1\x97\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xD9\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],

        ["\xF3\xB1\x97\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xD9\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],

        ["\xF3\xB1\x97\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xD9\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],

        ["\xF3\xB1\x97\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xD9\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],

        ["\xF3\xB1\x97\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xD9\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],

        ["\xF3\xB1\x97\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xDA\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],

        ["\xF3\xB1\x97\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xDA\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],

        ["\xF3\xB1\x97\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xDA\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],

        ["\xF3\xB1\x97\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xDA\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],

        ["\xF3\xB1\x97\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xDA\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],

        ["\xF3\xB1\x97\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xDA\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],

        ["\xF3\xB1\x97\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xDA\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],

        ["\xF3\xB1\x97\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xDA\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],

        ["\xF3\xB1\x97\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xDA\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],

        ["\xF3\xB1\x97\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xDA\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],

        ["\xF3\xB1\x97\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xDA\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],

        ["\xF3\xB1\x97\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xDA\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],

        ["\xF3\xB1\x97\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xDA\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],

        ["\xF3\xB1\x97\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xDA\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],

        ["\xF3\xB1\x97\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xDA\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],

        ["\xF3\xB1\x97\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xDA\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],

        ["\xF3\xB1\x97\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xDA\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],

        ["\xF3\xB1\x97\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xDA\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],

        ["\xF3\xB1\x98\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xDA\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],

        ["\xF3\xB1\x98\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xDA\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],

        ["\xF3\xB1\x98\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xDA\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],

        ["\xF3\xB1\x98\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xDA\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],

        ["\xF3\xB1\x98\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xDA\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],

        ["\xF3\xB1\x98\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xDA\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],

        ["\xF3\xB1\x98\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xDA\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],

        ["\xF3\xB1\x98\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xDA\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],

        ["\xF3\xB1\x98\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xDA\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],

        ["\xF3\xB1\x98\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xDA\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],

        ["\xF3\xB1\x98\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xDA\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],

        ["\xF3\xB1\x98\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xDA\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],

        ["\xF3\xB1\x98\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xDA\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],

        ["\xF3\xB1\x98\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xDA\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],

        ["\xF3\xB1\x98\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xDA\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],

        ["\xF3\xB1\x98\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xDA\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],

        ["\xF3\xB1\x98\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xDA\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],

        ["\xF3\xB1\x98\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xDA\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],

        ["\xF3\xB1\x98\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xDA\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],

        ["\xF3\xB1\x98\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xDA\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],

        ["\xF3\xB1\x98\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xDA\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],

        ["\xF3\xB1\x98\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xDA\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],

        ["\xF3\xB1\x98\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xDA\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],

        ["\xF3\xB1\x98\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xDA\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],

        ["\xF3\xB1\x98\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xDA\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],

        ["\xF3\xB1\x98\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xDA\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],

        ["\xF3\xB1\x98\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xDA\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],

        ["\xF3\xB1\x98\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xDA\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],

        ["\xF3\xB1\x98\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xDA\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],

        ["\xF3\xB1\x98\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xDA\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],

        ["\xF3\xB1\x98\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xDA\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],

        ["\xF3\xB1\x98\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xDA\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],

        ["\xF3\xB1\x98\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xDA\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],

        ["\xF3\xB1\x98\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xDA\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],

        ["\xF3\xB1\x98\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xDA\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],

        ["\xF3\xB1\x98\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xDA\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],

        ["\xF3\xB1\x98\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xDA\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],

        ["\xF3\xB1\x98\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xDA\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],

        ["\xF3\xB1\x98\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xDA\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],

        ["\xF3\xB1\x98\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xDA\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],

        ["\xF3\xB1\x98\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xDA\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],

        ["\xF3\xB1\x98\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xDA\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],

        ["\xF3\xB1\x98\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xDA\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],

        ["\xF3\xB1\x98\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xDA\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],

        ["\xF3\xB1\x98\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xDA\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],

        ["\xF3\xB1\x98\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xDA\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],

        ["\xF3\xB1\x98\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xDA\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],

        ["\xF3\xB1\x98\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xDA\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],

        ["\xF3\xB1\x98\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xDA\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],

        ["\xF3\xB1\x98\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xDA\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],

        ["\xF3\xB1\x98\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xDA\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],

        ["\xF3\xB1\x98\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xDA\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],

        ["\xF3\xB1\x98\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xDA\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],

        ["\xF3\xB1\x98\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xDA\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],

        ["\xF3\xB1\x98\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xDA\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],

        ["\xF3\xB1\x98\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xDA\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],

        ["\xF3\xB1\x98\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xDA\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],

        ["\xF3\xB1\x98\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xDA\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],

        ["\xF3\xB1\x98\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xDA\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],

        ["\xF3\xB1\x98\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xDA\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],

        ["\xF3\xB1\x98\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xDA\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],

        ["\xF3\xB1\x98\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xDA\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],

        ["\xF3\xB1\x98\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xDA\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],

        ["\xF3\xB1\x98\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xDA\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],

        ["\xF3\xB1\x99\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xDA\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],

        ["\xF3\xB1\x99\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xDA\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],

        ["\xF3\xB1\x99\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xDA\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],

        ["\xF3\xB1\x99\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xDA\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],

        ["\xF3\xB1\x99\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xDA\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],

        ["\xF3\xB1\x99\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xDA\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],

        ["\xF3\xB1\x99\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xDA\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],

        ["\xF3\xB1\x99\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xDA\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],

        ["\xF3\xB1\x99\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xDA\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],

        ["\xF3\xB1\x99\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xDA\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],

        ["\xF3\xB1\x99\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xDA\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],

        ["\xF3\xB1\x99\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\xDA\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],

        ["\xF3\xB1\x99\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\xDB\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],

        ["\xF3\xB1\x99\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\xDB\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],

        ["\xF3\xB1\x99\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\xDB\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],

        ["\xF3\xB1\x99\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\xDB\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],

        ["\xF3\xB1\x99\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\xDB\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],

        ["\xF3\xB1\x99\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\xDB\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],

        ["\xF3\xB1\x99\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\xDB\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],

        ["\xF3\xB1\x99\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\xDB\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],

        ["\xF3\xB1\x99\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\xDB\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],

        ["\xF3\xB1\x99\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\xDB\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],

        ["\xF3\xB1\x99\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\xDB\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],

        ["\xF3\xB1\x99\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\xDB\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],

        ["\xF3\xB1\x99\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\xDB\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],

        ["\xF3\xB1\x99\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\xDB\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],

        ["\xF3\xB1\x99\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\xDB\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],

        ["\xF3\xB1\x99\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\xDB\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],

        ["\xF3\xB1\x99\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\xDB\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],

        ["\xF3\xB1\x99\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\xDB\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],

        ["\xF3\xB1\x99\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\xDB\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],

        ["\xF3\xB1\x99\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\xDB\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],

        ["\xF3\xB1\x99\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\xDB\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],

        ["\xF3\xB1\x99\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\xDB\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],

        ["\xF3\xB1\x99\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\xDB\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],

        ["\xF3\xB1\x99\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\xDB\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],

        ["\xF3\xB1\x99\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\xDB\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],

        ["\xF3\xB1\x99\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\xDB\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],

        ["\xF3\xB1\x99\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\xDB\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],

        ["\xF3\xB1\x99\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\xDB\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],

        ["\xF3\xB1\x99\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\xDB\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],

        ["\xF3\xB1\x99\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\xDB\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],

        ["\xF3\xB1\x99\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\xDB\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],

        ["\xF3\xB1\x99\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\xDB\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],

        ["\xF3\xB1\x99\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\xDB\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],

        ["\xF3\xB1\x99\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\xDB\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],

        ["\xF3\xB1\x99\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\xDB\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],

        ["\xF3\xB1\x99\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\xDB\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],

        ["\xF3\xB1\x99\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\xDB\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],

        ["\xF3\xB1\x99\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\xDB\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],

        ["\xF3\xB1\x99\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\xDB\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],

        ["\xF3\xB1\x99\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\xDB\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],

        ["\xF3\xB1\x99\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\xDB\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],

        ["\xF3\xB1\x99\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\xDB\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],

        ["\xF3\xB1\x99\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\xDB\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],

        ["\xF3\xB1\x99\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\xDB\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],

        ["\xF3\xB1\x99\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\xDB\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],

        ["\xF3\xB1\x99\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\xDB\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],

        ["\xF3\xB1\x99\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\xDB\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],

        ["\xF3\xB1\x99\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\xDB\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],

        ["\xF3\xB1\x99\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\xDB\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],

        ["\xF3\xB1\x99\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\xDB\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],

        ["\xF3\xB1\x99\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\xDB\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],

        ["\xF3\xB1\x99\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\xDB\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],

        ["\xF3\xB1\x9A\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\xDB\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],

        ["\xF3\xB1\x9A\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\xDB\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],

        ["\xF3\xB1\x9A\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xDB\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],

        ["\xF3\xB1\x9A\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xC9\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],

        ["\xF3\xB1\x9A\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\xDB\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],

        ["\xF3\xB1\x9A\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\xDB\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],

        ["\xF3\xB1\x9A\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\xDB\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],

        ["\xF3\xB1\x9A\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\xDB\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],

        ["\xF3\xB1\x9A\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\xDB\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],

        ["\xF3\xB1\x9A\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\xDB\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],

        ["\xF3\xB1\x9A\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\xDB\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],

        ["\xF3\xB1\x9A\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\xDB\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],

        ["\xF3\xB1\x9A\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\xDB\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],

        ["\xF3\xB1\x9A\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\xDB\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],

        ["\xF3\xB1\x9A\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\xDB\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],

        ["\xF3\xB1\x9A\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\xDB\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],

        ["\xF3\xB1\x9A\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\xDB\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],

        ["\xF3\xB1\x9A\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\xDB\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],

        ["\xF3\xB1\x9A\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\xDB\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],

        ["\xF3\xB1\x9A\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\xDB\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],

        ["\xF3\xB1\x9A\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\xDB\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],

        ["\xF3\xB1\x9A\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\xDB\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],

        ["\xF3\xB1\x9A\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\xDB\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],

        ["\xF3\xB1\x9A\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xDB\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],

        ["\xF3\xB1\x9A\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xC5\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],

        ["\xF3\xB1\x9A\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\xDB\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],

        ["\xF3\xB1\x9A\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\xDB\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],

        ["\xF3\xB1\x9A\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\xDB\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],

        ["\xF3\xB1\x9A\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\xDB\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],

        ["\xF3\xB1\x9A\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\xDB\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],

        ["\xF3\xB1\x9A\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\xDB\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],

        ["\xF3\xB1\x9A\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\xDB\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],

        ["\xF3\xB1\x9A\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\xDB\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],

        ["\xF3\xB1\x9A\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\xDB\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],

        ["\xF3\xB1\x9A\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\xDB\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],

        ["\xF3\xB1\x9A\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\xDB\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],

        ["\xF3\xB1\x9A\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\xDB\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],

        ["\xF3\xB1\x9A\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\xDB\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],

        ["\xF3\xB1\x9A\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\xDB\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],

        ["\xF3\xB1\x9A\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\xDB\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],

        ["\xF3\xB1\x9A\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\xDB\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],

        ["\xF3\xB1\x9A\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\xDB\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],

        ["\xF3\xB1\x9A\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\xDC\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],

        ["\xF3\xB1\x9A\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\xDC\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],

        ["\xF3\xB1\x9A\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\xDC\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],

        ["\xF3\xB1\x9A\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\xDC\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],

        ["\xF3\xB1\x9A\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\xDC\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],

        ["\xF3\xB1\x9A\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\xDC\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],

        ["\xF3\xB1\x9A\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\xDC\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],

        ["\xF3\xB1\x9A\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\xDC\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],

        ["\xF3\xB1\x9A\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\xDC\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],

        ["\xF3\xB1\x9A\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\xDC\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],

        ["\xF3\xB1\x9A\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\xDC\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],

        ["\xF3\xB1\x9A\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\xDC\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],

        ["\xF3\xB1\x9A\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\xDC\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],

        ["\xF3\xB1\x9A\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\xDC\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],

        ["\xF3\xB1\x9A\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\xDC\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],

        ["\xF3\xB1\x9A\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\xDC\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],

        ["\xF3\xB1\x9A\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\xDC\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],

        ["\xF3\xB1\x9A\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\xDC\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],

        ["\xF3\xB1\x9A\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\xDC\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],

        ["\xF3\xB1\x9A\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\xDC\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],

        ["\xF3\xB1\x9A\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\xDC\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],

        ["\xF3\xB1\x9A\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\xDC\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],

        ["\xF3\xB1\x9B\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\xDC\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],

        ["\xF3\xB1\x9B\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\xDC\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],

        ["\xF3\xB1\x9B\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\xDC\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],

        ["\xF3\xB1\x9B\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\xDC\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],

        ["\xF3\xB1\x9B\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\xDC\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],

        ["\xF3\xB1\x9B\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\xDC\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],

        ["\xF3\xB1\x9B\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\xDC\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],

        ["\xF3\xB1\x9B\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\xDC\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],

        ["\xF3\xB1\x9B\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\xDC\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],

        ["\xF3\xB1\x9B\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\xDC\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],

        ["\xF3\xB1\x9B\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\xDC\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],

        ["\xF3\xB1\x9B\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\xDC\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],

        ["\xF3\xB1\x9B\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\xDC\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],

        ["\xF3\xB1\x9B\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\xDC\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],

        ["\xF3\xB1\x9B\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\xDC\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],

        ["\xF3\xB1\x9B\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\xDC\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],

        ["\xF3\xB1\x9B\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\xDC\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],

        ["\xF3\xB1\x9B\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\xDC\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],

        ["\xF3\xB1\x9B\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\xDC\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],

        ["\xF3\xB1\x9B\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\xDC\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],

        ["\xF3\xB1\x9B\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\xDC\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],

        ["\xF3\xB1\x9B\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\xDC\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],

        ["\xF3\xB1\x9B\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\xDC\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],

        ["\xF3\xB1\x9B\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\xDC\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],

        ["\xF3\xB1\x9B\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\xDC\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],

        ["\xF3\xB1\x9B\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\xDC\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],

        ["\xF3\xB1\x9B\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\xDC\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],

        ["\xF3\xB1\x9B\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\xDC\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],

        ["\xF3\xB1\x9B\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\xDC\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],

        ["\xF3\xB1\x9B\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\xDC\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],

        ["\xF3\xB1\x9B\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\xDC\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],

        ["\xF3\xB1\x9B\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\xDC\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],

        ["\xF3\xB1\x9B\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\xDC\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],

        ["\xF3\xB1\x9B\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\xDC\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],

        ["\xF3\xB1\x9B\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\xDC\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],

        ["\xF3\xB1\x9B\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\xDC\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],

        ["\xF3\xB1\x9B\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\xDC\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],

        ["\xF3\xB1\x9B\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\xDC\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],

        ["\xF3\xB1\x9B\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\xDC\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],

        ["\xF3\xB1\x9B\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\xDC\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],

        ["\xF3\xB1\x9B\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\xDC\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],

        ["\xF3\xB1\x9B\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\xDC\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],

        ["\xF3\xB1\x9B\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\xDC\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],

        ["\xF3\xB1\x9B\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\xDC\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],

        ["\xF3\xB1\x9B\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\xDC\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],

        ["\xF3\xB1\x9B\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\xDC\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],

        ["\xF3\xB1\x9B\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\xDC\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],

        ["\xF3\xB1\x9B\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\xDC\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],

        ["\xF3\xB1\x9B\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\xDC\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],

        ["\xF3\xB1\x9B\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\xDC\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],

        ["\xF3\xB1\x9B\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\xDC\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],

        ["\xF3\xB1\x9B\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\xDC\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],

        ["\xF3\xB1\x9B\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\xDC\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],

        ["\xF3\xB1\x9B\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\xDC\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],

        ["\xF3\xB1\x9B\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\xDC\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],

        ["\xF3\xB1\x9B\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\xDC\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],

        ["\xF3\xB1\x9B\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\xDC\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],

        ["\xF3\xB1\x9B\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\xDC\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],

        ["\xF3\xB1\x9B\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\xDC\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],

        ["\xF3\xB1\x9B\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\xDC\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],

        ["\xF3\xB1\x9B\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\xDC\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],

        ["\xF3\xB1\x9B\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\xDC\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],

        ["\xF3\xB1\x9B\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\xDC\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],

        ["\xF3\xB1\x9B\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\xDC\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],

        ["\xF3\xB1\x9C\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\xDC\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],

        ["\xF3\xB1\x9C\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\xDC\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],

        ["\xF3\xB1\x9C\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\xDC\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],

        ["\xF3\xB1\x9C\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\xDC\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],

        ["\xF3\xB1\x9C\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\xDC\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],

        ["\xF3\xB1\x9C\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\xDC\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],

        ["\xF3\xB1\x9C\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\xDC\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],

        ["\xF3\xB1\x9C\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\xDC\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],

        ["\xF3\xB1\x9C\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\xDD\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],

        ["\xF3\xB1\x9C\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\xDD\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],

        ["\xF3\xB1\x9C\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\xDD\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],

        ["\xF3\xB1\x9C\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\xDD\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],

        ["\xF3\xB1\x9C\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\xDD\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],

        ["\xF3\xB1\x9C\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\xDD\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],

        ["\xF3\xB1\x9C\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\xDD\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],

        ["\xF3\xB1\x9C\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\xDD\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],

        ["\xF3\xB1\x9C\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\xDD\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],

        ["\xF3\xB1\x9C\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\xDD\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],

        ["\xF3\xB1\x9C\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\xDD\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],

        ["\xF3\xB1\x9C\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\xDD\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],

        ["\xF3\xB1\x9C\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\xDD\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],

        ["\xF3\xB1\x9C\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\xDD\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],

        ["\xF3\xB1\x9C\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\xDD\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],

        ["\xF3\xB1\x9C\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\xDD\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],

        ["\xF3\xB1\x9C\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\xDD\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],

        ["\xF3\xB1\x9C\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\xDD\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],

        ["\xF3\xB1\x9C\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\xDD\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],

        ["\xF3\xB1\x9C\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\xDD\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],

        ["\xF3\xB1\x9C\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\xDD\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],

        ["\xF3\xB1\x9C\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xDD\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],

        ["\xF3\xB1\x9C\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xDD\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],

        ["\xF3\xB1\x9C\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\xDD\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],

        ["\xF3\xB1\x9C\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\xDD\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],

        ["\xF3\xB1\x9C\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\xDD\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],

        ["\xF3\xB1\x9C\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\xDD\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],

        ["\xF3\xB1\x9C\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\xDD\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],

        ["\xF3\xB1\x9C\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xDD\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],

        ["\xF3\xB1\x9C\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\xDD\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],

        ["\xF3\xB1\x9C\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\xDD\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],

        ["\xF3\xB1\x9C\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\xDD\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],

        ["\xF3\xB1\x9C\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\xDD\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],

        ["\xF3\xB1\x9C\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\xDD\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],

        ["\xF3\xB1\x9C\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\xDD\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],

        ["\xF3\xB1\x9C\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\xDD\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],

        ["\xF3\xB1\x9C\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\xDD\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],

        ["\xF3\xB1\x9C\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\xDD\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],

        ["\xF3\xB1\x9C\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\xDD\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],

        ["\xF3\xB1\x9C\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\xDD\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],

        ["\xF3\xB1\x9C\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\xDD\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],

        ["\xF3\xB1\x9C\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\xDD\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],

        ["\xF3\xB1\x9C\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\xDD\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],

        ["\xF3\xB1\x9C\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\xDD\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],

        ["\xF3\xB1\x9C\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\xDD\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],

        ["\xF3\xB1\x9C\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\xDD\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],

        ["\xF3\xB1\x9C\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\xDD\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],

        ["\xF3\xB1\x9C\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xDD\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],

        ["\xF3\xB1\x9C\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\xDD\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],

        ["\xF3\xB1\x9C\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xDD\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],

        ["\xF3\xB1\x9C\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\xDD\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],

        ["\xF3\xB1\x9C\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\xDD\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],

        ["\xF3\xB1\x9C\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xDD\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],

        ["\xF3\xB1\x9C\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\xDD\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],

        ["\xF3\xB1\x9C\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\xDD\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],

        ["\xF3\xB1\x9C\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\xDD\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],

        ["\xF3\xB1\x9D\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\xDD\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],

        ["\xF3\xB1\x9D\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xDD\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],

        ["\xF3\xB1\x9D\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xDD\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],

        ["\xF3\xB1\x9D\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xDD\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],

        ["\xF3\xB1\x9D\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xDD\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],

        ["\xF3\xB1\x9D\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\xDD\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],

        ["\xF3\xB1\x9D\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\xDD\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],

        ["\xF3\xB1\x9D\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\xDD\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],

        ["\xF3\xB1\x9D\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\xDD\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],

        ["\xF3\xB1\x9D\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\xDD\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],

        ["\xF3\xB1\x9D\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\xDD\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],

        ["\xF3\xB1\x9D\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\xDD\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],

        ["\xF3\xB1\x9D\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\xDD\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],

        ["\xF3\xB1\x9D\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\xDD\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],

        ["\xF3\xB1\x9D\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\xDD\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],

        ["\xF3\xB1\x9D\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\xDD\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],

        ["\xF3\xB1\x9D\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\xDD\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],

        ["\xF3\xB1\x9D\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\xDD\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],

        ["\xF3\xB1\x9D\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\xDD\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],

        ["\xF3\xB1\x9D\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\xDD\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],

        ["\xF3\xB1\x9D\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\xDD\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],

        ["\xF3\xB1\x9D\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\xDD\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],

        ["\xF3\xB1\x9D\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\xDD\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],

        ["\xF3\xB1\x9D\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\xDD\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],

        ["\xF3\xB1\x9D\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\xDD\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],

        ["\xF3\xB1\x9D\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\xDD\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],

        ["\xF3\xB1\x9D\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\xDD\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],

        ["\xF3\xB1\x9D\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\xDD\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],

        ["\xF3\xB1\x9D\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\xDD\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],

        ["\xF3\xB1\x9D\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\xDD\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],

        ["\xF3\xB1\x9D\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\xDD\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],

        ["\xF3\xB1\x9D\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\xDD\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],

        ["\xF3\xB1\x9D\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\xDD\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],

        ["\xF3\xB1\x9D\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\xDD\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],

        ["\xF3\xB1\x9D\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\xDD\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],

        ["\xF3\xB1\x9D\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\xDD\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],

        ["\xF3\xB1\x9D\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\xDD\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],

        ["\xF3\xB1\x9D\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\xDD\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],

        ["\xF3\xB1\x9D\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\xDE\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],

        ["\xF3\xB1\x9D\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\xDE\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],

        ["\xF3\xB1\x9D\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\xDE\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],

        ["\xF3\xB1\x9D\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\xDE\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],

        ["\xF3\xB1\x9D\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\xDE\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],

        ["\xF3\xB1\x9D\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\xDE\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],

        ["\xF3\xB1\x9D\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\xDE\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],

        ["\xF3\xB1\x9D\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\xDE\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],

        ["\xF3\xB1\x9D\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\xDE\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],

        ["\xF3\xB1\x9D\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\xDE\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],

        ["\xF3\xB1\x9D\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\xDE\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],

        ["\xF3\xB1\x9D\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\xDE\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],

        ["\xF3\xB1\x9D\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\xDE\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],

        ["\xF3\xB1\x9D\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\xDE\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],

        ["\xF3\xB1\x9D\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\xDE\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],

        ["\xF3\xB1\x9D\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\xDE\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],

        ["\xF3\xB1\x9D\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\xDE\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],

        ["\xF3\xB1\x9D\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\xDE\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],

        ["\xF3\xB1\x9D\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\xDE\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],

        ["\xF3\xB1\x9D\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\xDE\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],

        ["\xF3\xB1\x9D\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xDE\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],

        ["\xF3\xB1\x9D\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\xDE\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],

        ["\xF3\xB1\x9D\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\xDE\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],

        ["\xF3\xB1\x9D\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xDE\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],

        ["\xF3\xB1\x9D\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xC5\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],

        ["\xF3\xB1\x9D\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\xDE\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],

        ["\xF3\xB1\x9E\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\xDE\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],

        ["\xF3\xB1\x9E\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\xDE\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],

        ["\xF3\xB1\x9E\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\xDE\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],

        ["\xF3\xB1\x9E\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\xDE\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],

        ["\xF3\xB1\x9E\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\xDE\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],

        ["\xF3\xB1\x9E\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\xDE\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],

        ["\xF3\xB1\x9E\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\xDE\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],

        ["\xF3\xB1\x9E\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\xDE\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],

        ["\xF3\xB1\x9E\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\xDE\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],

        ["\xF3\xB1\x9E\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\xDE\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],

        ["\xF3\xB1\x9E\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\xDE\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],

        ["\xF3\xB1\x9E\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\xDE\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],

        ["\xF3\xB1\x9E\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\xDE\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],

        ["\xF3\xB1\x9E\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\xDE\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],

        ["\xF3\xB1\x9E\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\xDE\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],

        ["\xF3\xB1\x9E\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\xDE\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],

        ["\xF3\xB1\x9E\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xDE\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],

        ["\xF3\xB1\x9E\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\xDE\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],

        ["\xF3\xB1\x9E\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\xDE\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],

        ["\xF3\xB1\x9E\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\xDE\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],

        ["\xF3\xB1\x9E\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\xDE\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],

        ["\xF3\xB1\x9E\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\xDE\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],

        ["\xF3\xB1\x9E\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\xDE\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],

        ["\xF3\xB1\x9E\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\xDE\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],

        ["\xF3\xB1\x9E\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\xDE\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],

        ["\xF3\xB1\x9E\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\xDE\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],

        ["\xF3\xB1\x9E\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\xDE\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],

        ["\xF3\xB1\x9E\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\xDE\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],

        ["\xF3\xB1\x9E\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\xDE\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],

        ["\xF3\xB1\x9E\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xDE\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],

        ["\xF3\xB1\x9E\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\xDE\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],

        ["\xF3\xB1\x9E\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\xDE\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],

        ["\xF3\xB1\x9E\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\xDE\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],

        ["\xF3\xB1\x9E\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\xDE\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],

        ["\xF3\xB1\x9E\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\xDE\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],

        ["\xF3\xB1\x9E\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\xDE\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],

        ["\xF3\xB1\x9E\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\xDE\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],

        ["\xF3\xB1\x9E\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\xDE\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],

        ["\xF3\xB1\x9E\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\xDE\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],

        ["\xF3\xB1\x9E\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\xDE\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],

        ["\xF3\xB1\x9E\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\xDE\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],

        ["\xF3\xB1\x9E\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\xDE\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],

        ["\xF3\xB1\x9E\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\xDE\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],

        ["\xF3\xB1\x9E\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\xDE\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],

        ["\xF3\xB1\x9E\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\xDE\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],

        ["\xF3\xB1\x9E\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\xDE\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],

        ["\xF3\xB1\x9E\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\xDE\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],

        ["\xF3\xB1\x9E\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\xDE\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],

        ["\xF3\xB1\x9E\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\xDE\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],

        ["\xF3\xB1\x9E\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\xDE\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],

        ["\xF3\xB1\x9E\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\xDE\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],

        ["\xF3\xB1\x9E\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\xDE\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],

        ["\xF3\xB1\x9E\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\xDE\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],

        ["\xF3\xB1\x9E\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\xDE\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],

        ["\xF3\xB1\x9E\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\xDE\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],

        ["\xF3\xB1\x9E\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\xDE\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],

        ["\xF3\xB1\x9E\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xDE\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],

        ["\xF3\xB1\x9E\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xDE\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],

        ["\xF3\xB1\x9E\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xB4\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],

        ["\xF3\xB1\x9E\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\xDE\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],

        ["\xF3\xB1\x9E\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\xDE\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],

        ["\xF3\xB1\x9E\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\xDE\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],

        ["\xF3\xB1\x9E\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\xDE\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],

        ["\xF3\xB1\x9E\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\xDE\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],

        ["\xF3\xB1\x9F\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\xDE\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],

        ["\xF3\xB1\x9F\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\xDE\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],

        ["\xF3\xB1\x9F\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\xDE\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],

        ["\xF3\xB1\x9F\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\xDE\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],

        ["\xF3\xB1\x9F\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\xDF\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],

        ["\xF3\xB1\x9F\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\xDF\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],

        ["\xF3\xB1\x9F\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\xDF\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],

        ["\xF3\xB1\x9F\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\xDF\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],

        ["\xF3\xB1\x9F\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\xDF\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],

        ["\xF3\xB1\x9F\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\xDF\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],

        ["\xF3\xB1\x9F\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\xDF\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],

        ["\xF3\xB1\x9F\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\xDF\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],

        ["\xF3\xB1\x9F\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\xDF\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],

        ["\xF3\xB1\x9F\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\xDF\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],

        ["\xF3\xB1\x9F\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\xDF\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],

        ["\xF3\xB1\x9F\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\xDF\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],

        ["\xF3\xB1\x9F\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\xDF\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],

        ["\xF3\xB1\x9F\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\xDF\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],

        ["\xF3\xB1\x9F\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\xDF\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],

        ["\xF3\xB1\x9F\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\xDF\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],

        ["\xF3\xB1\x9F\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xDF\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],

        ["\xF3\xB1\x9F\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xDF\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],

        ["\xF3\xB1\x9F\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xDF\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],

        ["\xF3\xB1\x9F\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xDF\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],

        ["\xF3\xB1\x9F\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\xDF\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],

        ["\xF3\xB1\x9F\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\xDF\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],

        ["\xF3\xB1\x9F\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\xDF\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],

        ["\xF3\xB1\x9F\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\xDF\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],

        ["\xF3\xB1\x9F\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\xDF\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],

        ["\xF3\xB1\x9F\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\xDF\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],

        ["\xF3\xB1\x9F\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\xDF\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],

        ["\xF3\xB1\x9F\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\xDF\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],

        ["\xF3\xB1\x9F\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\xDF\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],

        ["\xF3\xB1\x9F\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\xDF\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],

        ["\xF3\xB1\x9F\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\xDF\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],

        ["\xF3\xB1\x9F\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\xDF\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],

        ["\xF3\xB1\x9F\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\xDF\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],

        ["\xF3\xB1\x9F\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\xDF\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],

        ["\xF3\xB1\x9F\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\xDF\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],

        ["\xF3\xB1\x9F\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\xDF\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],

        ["\xF3\xB1\x9F\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\xDF\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],

        ["\xF3\xB1\x9F\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\xDF\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],

        ["\xF3\xB1\x9F\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\xDF\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],

        ["\xF3\xB1\x9F\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\xDF\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],

        ["\xF3\xB1\x9F\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\xDF\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],

        ["\xF3\xB1\x9F\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\xDF\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],

        ["\xF3\xB1\x9F\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\xDF\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],

        ["\xF3\xB1\x9F\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\xDF\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],

        ["\xF3\xB1\x9F\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xDF\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],

        ["\xF3\xB1\x9F\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\xDF\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],

        ["\xF3\xB1\x9F\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xDF\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],

        ["\xF3\xB1\x9F\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\xDF\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],

        ["\xF3\xB1\x9F\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\xDF\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],

        ["\xF3\xB1\x9F\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\xDF\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],

        ["\xF3\xB1\x9F\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\xDF\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],

        ["\xF3\xB1\x9F\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\xDF\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],

        ["\xF3\xB1\x9F\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\xDF\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],

        ["\xF3\xB1\x9F\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xDF\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],

        ["\xF3\xB1\x9F\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xDF\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],

        ["\xF3\xB1\x9F\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\xDF\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],

        ["\xF3\xB1\x9F\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\xDF\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],

        ["\xF3\xB1\x9F\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\xDF\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],

        ["\xF3\xB1\x9F\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\xDF\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],

        ["\xF3\xB1\x9F\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\xDF\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],

        ["\xF3\xB1\xA0\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\xDF\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],

        ["\xF3\xB1\xA0\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\xDF\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],

        ["\xF3\xB1\xA0\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\xDF\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],

        ["\xF3\xB1\xA0\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xDF\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],

        ["\xF3\xB1\xA0\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\xDF\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],

        ["\xF3\xB1\xA0\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\xDF\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],

        ["\xF3\xB1\xA0\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\xDF\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],

        ["\xF3\xB1\xA0\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\xDF\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],

        ["\xF3\xB1\xA0\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xDF\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],

        ["\xF3\xB1\xA0\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xDF\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],

        ["\xF3\xB1\xA0\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\xDF\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],

        ["\xF3\xB1\xA0\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xDF\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],

        ["\xF3\xB1\xA0\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\xDF\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],

        ["\xF3\xB1\xA0\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\xDF\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],

        ["\xF3\xB1\xA0\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\xDF\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],

        ["\xF3\xB1\xA0\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\xDF\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],

        ["\xF3\xB1\xA0\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\xDF\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],

        ["\xF3\xB1\xA0\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\xDF\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],

        ["\xF3\xB1\xA0\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\xDF\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],

        ["\xF3\xB1\xA0\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\xDF\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],

        ["\xF3\xB1\xA0\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\xDF\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],

        ["\xF3\xB1\xA0\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\xDF\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],

        ["\xF3\xB1\xA0\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\xDF\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],

        ["\xF3\xB1\xA0\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\xDF\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],

        ["\xF3\xB1\xA0\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\xDF\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],

        ["\xF3\xB1\xA0\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\xDF\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],

        ["\xF3\xB1\xA0\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\xDF\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],

        ["\xF3\xB1\xA0\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\xDF\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],

        ["\xF3\xB1\xA0\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\xDF\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],

        ["\xF3\xB1\xA0\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xDF\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],

        ["\xF3\xB1\xA0\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\xDF\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],

        ["\xF3\xB1\xA0\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xDF\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],

        ["\xF3\xB1\xA0\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\xDF\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],

        ["\xF3\xB1\xA0\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\xDF\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],

        ["\xF3\xB1\xA0\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],

        ["\xF3\xB1\xA0\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],

        ["\xF3\xB1\xA0\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],

        ["\xF3\xB1\xA0\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],

        ["\xF3\xB1\xA0\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],

        ["\xF3\xB1\xA0\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],

        ["\xF3\xB1\xA0\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],

        ["\xF3\xB1\xA0\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],

        ["\xF3\xB1\xA0\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],

        ["\xF3\xB1\xA0\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],

        ["\xF3\xB1\xA0\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],

        ["\xF3\xB1\xA0\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],

        ["\xF3\xB1\xA0\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],

        ["\xF3\xB1\xA0\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],

        ["\xF3\xB1\xA0\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],

        ["\xF3\xB1\xA0\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],

        ["\xF3\xB1\xA0\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],

        ["\xF3\xB1\xA0\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],

        ["\xF3\xB1\xA0\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],

        ["\xF3\xB1\xA0\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],

        ["\xF3\xB1\xA0\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],

        ["\xF3\xB1\xA0\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],

        ["\xF3\xB1\xA0\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],

        ["\xF3\xB1\xA0\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],

        ["\xF3\xB1\xA0\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],

        ["\xF3\xB1\xA0\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],

        ["\xF3\xB1\xA0\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],

        ["\xF3\xB1\xA0\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],

        ["\xF3\xB1\xA0\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],

        ["\xF3\xB1\xA0\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],

        ["\xF3\xB1\xA1\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],

        ["\xF3\xB1\xA1\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],

        ["\xF3\xB1\xA1\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],

        ["\xF3\xB1\xA1\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],

        ["\xF3\xB1\xA1\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],

        ["\xF3\xB1\xA1\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],

        ["\xF3\xB1\xA1\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],

        ["\xF3\xB1\xA1\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],

        ["\xF3\xB1\xA1\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],

        ["\xF3\xB1\xA1\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],

        ["\xF3\xB1\xA1\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],

        ["\xF3\xB1\xA1\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],

        ["\xF3\xB1\xA1\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],

        ["\xF3\xB1\xA1\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],

        ["\xF3\xB1\xA1\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],

        ["\xF3\xB1\xA1\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],

        ["\xF3\xB1\xA1\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],

        ["\xF3\xB1\xA1\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],

        ["\xF3\xB1\xA1\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],

        ["\xF3\xB1\xA1\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],

        ["\xF3\xB1\xA1\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],

        ["\xF3\xB1\xA1\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],

        ["\xF3\xB1\xA1\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],

        ["\xF3\xB1\xA1\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],

        ["\xF3\xB1\xA1\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],

        ["\xF3\xB1\xA1\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],

        ["\xF3\xB1\xA1\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],

        ["\xF3\xB1\xA1\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],

        ["\xF3\xB1\xA1\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],

        ["\xF3\xB1\xA1\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],

        ["\xF3\xB1\xA1\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],

        ["\xF3\xB1\xA1\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],

        ["\xF3\xB1\xA1\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],

        ["\xF3\xB1\xA1\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],

        ["\xF3\xB1\xA1\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],

        ["\xF3\xB1\xA1\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],

        ["\xF3\xB1\xA1\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],

        ["\xF3\xB1\xA1\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],

        ["\xF3\xB1\xA1\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],

        ["\xF3\xB1\xA1\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],

        ["\xF3\xB1\xA1\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],

        ["\xF3\xB1\xA1\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],

        ["\xF3\xB1\xA1\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],

        ["\xF3\xB1\xA1\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],

        ["\xF3\xB1\xA1\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],

        ["\xF3\xB1\xA1\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],

        ["\xF3\xB1\xA1\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],

        ["\xF3\xB1\xA1\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],

        ["\xF3\xB1\xA1\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],

        ["\xF3\xB1\xA1\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],

        ["\xF3\xB1\xA1\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],

        ["\xF3\xB1\xA1\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],

        ["\xF3\xB1\xA1\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],

        ["\xF3\xB1\xA1\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],

        ["\xF3\xB1\xA1\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],

        ["\xF3\xB1\xA1\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\x59\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],

        ["\xF3\xB1\xA1\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],

        ["\xF3\xB1\xA1\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],

        ["\xF3\xB1\xA1\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],

        ["\xF3\xB1\xA1\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],

        ["\xF3\xB1\xA1\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],

        ["\xF3\xB1\xA1\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],

        ["\xF3\xB1\xA1\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xE0\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],

        ["\xF3\xB1\xA1\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xE0\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],

        ["\xF3\xB1\xA2\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],

        ["\xF3\xB1\xA2\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],

        ["\xF3\xB1\xA2\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],

        ["\xF3\xB1\xA2\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],

        ["\xF3\xB1\xA2\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],

        ["\xF3\xB1\xA2\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],

        ["\xF3\xB1\xA2\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],

        ["\xF3\xB1\xA2\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],

        ["\xF3\xB1\xA2\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],

        ["\xF3\xB1\xA2\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],

        ["\xF3\xB1\xA2\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],

        ["\xF3\xB1\xA2\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],

        ["\xF3\xB1\xA2\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],

        ["\xF3\xB1\xA2\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],

        ["\xF3\xB1\xA2\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],

        ["\xF3\xB1\xA2\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],

        ["\xF3\xB1\xA2\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],

        ["\xF3\xB1\xA2\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],

        ["\xF3\xB1\xA2\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],

        ["\xF3\xB1\xA2\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],

        ["\xF3\xB1\xA2\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],

        ["\xF3\xB1\xA2\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],

        ["\xF3\xB1\xA2\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],

        ["\xF3\xB1\xA2\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],

        ["\xF3\xB1\xA2\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],

        ["\xF3\xB1\xA2\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],

        ["\xF3\xB1\xA2\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],

        ["\xF3\xB1\xA2\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],

        ["\xF3\xB1\xA2\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],

        ["\xF3\xB1\xA2\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],

        ["\xF3\xB1\xA2\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],

        ["\xF3\xB1\xA2\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],

        ["\xF3\xB1\xA2\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],

        ["\xF3\xB1\xA2\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],

        ["\xF3\xB1\xA2\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],

        ["\xF3\xB1\xA2\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],

        ["\xF3\xB1\xA2\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],

        ["\xF3\xB1\xA2\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],

        ["\xF3\xB1\xA2\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],

        ["\xF3\xB1\xA2\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],

        ["\xF3\xB1\xA2\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],

        ["\xF3\xB1\xA2\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],

        ["\xF3\xB1\xA2\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],

        ["\xF3\xB1\xA2\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],

        ["\xF3\xB1\xA2\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],

        ["\xF3\xB1\xA2\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],

        ["\xF3\xB1\xA2\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],

        ["\xF3\xB1\xA2\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],

        ["\xF3\xB1\xA2\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],

        ["\xF3\xB1\xA2\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],

        ["\xF3\xB1\xA2\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],

        ["\xF3\xB1\xA2\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],

        ["\xF3\xB1\xA2\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],

        ["\xF3\xB1\xA2\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],

        ["\xF3\xB1\xA2\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],

        ["\xF3\xB1\xA2\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],

        ["\xF3\xB1\xA2\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],

        ["\xF3\xB1\xA2\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],

        ["\xF3\xB1\xA2\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],

        ["\xF3\xB1\xA2\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],

        ["\xF3\xB1\xA2\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],

        ["\xF3\xB1\xA2\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],

        ["\xF3\xB1\xA2\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],

        ["\xF3\xB1\xA2\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],

        ["\xF3\xB1\xA3\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],

        ["\xF3\xB1\xA3\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],

        ["\xF3\xB1\xA3\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],

        ["\xF3\xB1\xA3\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],

        ["\xF3\xB1\xA3\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],

        ["\xF3\xB1\xA3\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],

        ["\xF3\xB1\xA3\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],

        ["\xF3\xB1\xA3\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],

        ["\xF3\xB1\xA3\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],

        ["\xF3\xB1\xA3\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],

        ["\xF3\xB1\xA3\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],

        ["\xF3\xB1\xA3\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],

        ["\xF3\xB1\xA3\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],

        ["\xF3\xB1\xA3\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],

        ["\xF3\xB1\xA3\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],

        ["\xF3\xB1\xA3\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],

        ["\xF3\xB1\xA3\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],

        ["\xF3\xB1\xA3\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],

        ["\xF3\xB1\xA3\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],

        ["\xF3\xB1\xA3\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],

        ["\xF3\xB1\xA3\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],

        ["\xF3\xB1\xA3\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],

        ["\xF3\xB1\xA3\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],

        ["\xF3\xB1\xA3\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],

        ["\xF3\xB1\xA3\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],

        ["\xF3\xB1\xA3\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],

        ["\xF3\xB1\xA3\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],

        ["\xF3\xB1\xA3\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],

        ["\xF3\xB1\xA3\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\xE1\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],

        ["\xF3\xB1\xA3\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\xE1\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],

        ["\xF3\xB1\xA3\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],

        ["\xF3\xB1\xA3\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],

        ["\xF3\xB1\xA3\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],

        ["\xF3\xB1\xA3\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],

        ["\xF3\xB1\xA3\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],

        ["\xF3\xB1\xA3\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],

        ["\xF3\xB1\xA3\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],

        ["\xF3\xB1\xA3\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],

        ["\xF3\xB1\xA3\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],

        ["\xF3\xB1\xA3\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],

        ["\xF3\xB1\xA3\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],

        ["\xF3\xB1\xA3\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],

        ["\xF3\xB1\xA3\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],

        ["\xF3\xB1\xA3\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],

        ["\xF3\xB1\xA3\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],

        ["\xF3\xB1\xA3\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],

        ["\xF3\xB1\xA3\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],

        ["\xF3\xB1\xA3\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],

        ["\xF3\xB1\xA3\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],

        ["\xF3\xB1\xA3\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],

        ["\xF3\xB1\xA3\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],

        ["\xF3\xB1\xA3\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],

        ["\xF3\xB1\xA3\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],

        ["\xF3\xB1\xA3\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],

        ["\xF3\xB1\xA3\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],

        ["\xF3\xB1\xA3\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],

        ["\xF3\xB1\xA3\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],

        ["\xF3\xB1\xA3\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],

        ["\xF3\xB1\xA3\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],

        ["\xF3\xB1\xA3\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],

        ["\xF3\xB1\xA3\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],

        ["\xF3\xB1\xA3\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],

        ["\xF3\xB1\xA3\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],

        ["\xF3\xB1\xA3\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],

        ["\xF3\xB1\xA4\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],

        ["\xF3\xB1\xA4\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],

        ["\xF3\xB1\xA4\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],

        ["\xF3\xB1\xA4\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],

        ["\xF3\xB1\xA4\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],

        ["\xF3\xB1\xA4\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],

        ["\xF3\xB1\xA4\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],

        ["\xF3\xB1\xA4\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],

        ["\xF3\xB1\xA4\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],

        ["\xF3\xB1\xA4\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],

        ["\xF3\xB1\xA4\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],

        ["\xF3\xB1\xA4\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],

        ["\xF3\xB1\xA4\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],

        ["\xF3\xB1\xA4\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],

        ["\xF3\xB1\xA4\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],

        ["\xF3\xB1\xA4\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],

        ["\xF3\xB1\xA4\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],

        ["\xF3\xB1\xA4\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],

        ["\xF3\xB1\xA4\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],

        ["\xF3\xB1\xA4\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],

        ["\xF3\xB1\xA4\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],

        ["\xF3\xB1\xA4\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],

        ["\xF3\xB1\xA4\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],

        ["\xF3\xB1\xA4\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],

        ["\xF3\xB1\xA4\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],

        ["\xF3\xB1\xA4\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],

        ["\xF3\xB1\xA4\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],

        ["\xF3\xB1\xA4\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],

        ["\xF3\xB1\xA4\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],

        ["\xF3\xB1\xA4\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],

        ["\xF3\xB1\xA4\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],

        ["\xF3\xB1\xA4\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],

        ["\xF3\xB1\xA4\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],

        ["\xF3\xB1\xA4\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],

        ["\xF3\xB1\xA4\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],

        ["\xF3\xB1\xA4\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],

        ["\xF3\xB1\xA4\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],

        ["\xF3\xB1\xA4\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xB9\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],

        ["\xF3\xB1\xA4\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],

        ["\xF3\xB1\xA4\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xC5\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],

        ["\xF3\xB1\xA4\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],

        ["\xF3\xB1\xA4\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],

        ["\xF3\xB1\xA4\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],

        ["\xF3\xB1\xA4\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],

        ["\xF3\xB1\xA4\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],

        ["\xF3\xB1\xA4\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],

        ["\xF3\xB1\xA4\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],

        ["\xF3\xB1\xA4\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],

        ["\xF3\xB1\xA4\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],

        ["\xF3\xB1\xA4\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],

        ["\xF3\xB1\xA4\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],

        ["\xF3\xB1\xA4\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],

        ["\xF3\xB1\xA4\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],

        ["\xF3\xB1\xA4\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],

        ["\xF3\xB1\xA4\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],

        ["\xF3\xB1\xA4\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],

        ["\xF3\xB1\xA4\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],

        ["\xF3\xB1\xA4\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],

        ["\xF3\xB1\xA4\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xE2\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],

        ["\xF3\xB1\xA4\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xE2\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],

        ["\xF3\xB1\xA4\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],

        ["\xF3\xB1\xA4\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],

        ["\xF3\xB1\xA4\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],

        ["\xF3\xB1\xA4\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],

        ["\xF3\xB1\xA5\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],

        ["\xF3\xB1\xA5\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],

        ["\xF3\xB1\xA5\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],

        ["\xF3\xB1\xA5\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],

        ["\xF3\xB1\xA5\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],

        ["\xF3\xB1\xA5\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],

        ["\xF3\xB1\xA5\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],

        ["\xF3\xB1\xA5\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],

        ["\xF3\xB1\xA5\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],

        ["\xF3\xB1\xA5\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],

        ["\xF3\xB1\xA5\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],

        ["\xF3\xB1\xA5\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],

        ["\xF3\xB1\xA5\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],

        ["\xF3\xB1\xA5\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],

        ["\xF3\xB1\xA5\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],

        ["\xF3\xB1\xA5\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],

        ["\xF3\xB1\xA5\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],

        ["\xF3\xB1\xA5\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],

        ["\xF3\xB1\xA5\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],

        ["\xF3\xB1\xA5\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],

        ["\xF3\xB1\xA5\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],

        ["\xF3\xB1\xA5\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],

        ["\xF3\xB1\xA5\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],

        ["\xF3\xB1\xA5\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],

        ["\xF3\xB1\xA5\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],

        ["\xF3\xB1\xA5\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],

        ["\xF3\xB1\xA5\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],

        ["\xF3\xB1\xA5\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],

        ["\xF3\xB1\xA5\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],

        ["\xF3\xB1\xA5\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],

        ["\xF3\xB1\xA5\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],

        ["\xF3\xB1\xA5\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],

        ["\xF3\xB1\xA5\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],

        ["\xF3\xB1\xA5\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],

        ["\xF3\xB1\xA5\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],

        ["\xF3\xB1\xA5\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],

        ["\xF3\xB1\xA5\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],

        ["\xF3\xB1\xA5\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],

        ["\xF3\xB1\xA5\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],

        ["\xF3\xB1\xA5\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],

        ["\xF3\xB1\xA5\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],

        ["\xF3\xB1\xA5\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],

        ["\xF3\xB1\xA5\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],

        ["\xF3\xB1\xA5\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],

        ["\xF3\xB1\xA5\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],

        ["\xF3\xB1\xA5\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],

        ["\xF3\xB1\xA5\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],

        ["\xF3\xB1\xA5\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],

        ["\xF3\xB1\xA5\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],

        ["\xF3\xB1\xA5\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],

        ["\xF3\xB1\xA5\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],

        ["\xF3\xB1\xA5\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],

        ["\xF3\xB1\xA5\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],

        ["\xF3\xB1\xA5\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],

        ["\xF3\xB1\xA5\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],

        ["\xF3\xB1\xA5\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],

        ["\xF3\xB1\xA5\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],

        ["\xF3\xB1\xA5\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xB3\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],

        ["\xF3\xB1\xA5\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],

        ["\xF3\xB1\xA5\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],

        ["\xF3\xB1\xA5\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],

        ["\xF3\xB1\xA5\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],

        ["\xF3\xB1\xA5\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],

        ["\xF3\xB1\xA5\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],

        ["\xF3\xB1\xA6\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],

        ["\xF3\xB1\xA6\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],

        ["\xF3\xB1\xA6\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],

        ["\xF3\xB1\xA6\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],

        ["\xF3\xB1\xA6\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],

        ["\xF3\xB1\xA6\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],

        ["\xF3\xB1\xA6\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],

        ["\xF3\xB1\xA6\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],

        ["\xF3\xB1\xA6\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],

        ["\xF3\xB1\xA6\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],

        ["\xF3\xB1\xA6\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],

        ["\xF3\xB1\xA6\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],

        ["\xF3\xB1\xA6\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],

        ["\xF3\xB1\xA6\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],

        ["\xF3\xB1\xA6\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],

        ["\xF3\xB1\xA6\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],

        ["\xF3\xB1\xA6\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],

        ["\xF3\xB1\xA6\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],

        ["\xF3\xB1\xA6\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],

        ["\xF3\xB1\xA6\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],

        ["\xF3\xB1\xA6\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],

        ["\xF3\xB1\xA6\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],

        ["\xF3\xB1\xA6\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],

        ["\xF3\xB1\xA6\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],

        ["\xF3\xB1\xA6\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\xE3\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],

        ["\xF3\xB1\xA6\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\xE3\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],

        ["\xF3\xB1\xA6\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],

        ["\xF3\xB1\xA6\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],

        ["\xF3\xB1\xA6\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],

        ["\xF3\xB1\xA6\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],

        ["\xF3\xB1\xA6\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],

        ["\xF3\xB1\xA6\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],

        ["\xF3\xB1\xA6\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],

        ["\xF3\xB1\xA6\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],

        ["\xF3\xB1\xA6\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],

        ["\xF3\xB1\xA6\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],

        ["\xF3\xB1\xA6\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],

        ["\xF3\xB1\xA6\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],

        ["\xF3\xB1\xA6\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],

        ["\xF3\xB1\xA6\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],

        ["\xF3\xB1\xA6\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],

        ["\xF3\xB1\xA6\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],

        ["\xF3\xB1\xA6\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],

        ["\xF3\xB1\xA6\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],

        ["\xF3\xB1\xA6\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],

        ["\xF3\xB1\xA6\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],

        ["\xF3\xB1\xA6\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],

        ["\xF3\xB1\xA6\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],

        ["\xF3\xB1\xA6\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],

        ["\xF3\xB1\xA6\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],

        ["\xF3\xB1\xA6\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],

        ["\xF3\xB1\xA6\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],

        ["\xF3\xB1\xA6\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],

        ["\xF3\xB1\xA6\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],

        ["\xF3\xB1\xA6\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],

        ["\xF3\xB1\xA6\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],

        ["\xF3\xB1\xA6\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],

        ["\xF3\xB1\xA6\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],

        ["\xF3\xB1\xA6\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],

        ["\xF3\xB1\xA6\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],

        ["\xF3\xB1\xA6\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],

        ["\xF3\xB1\xA6\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],

        ["\xF3\xB1\xA6\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],

        ["\xF3\xB1\xA6\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xCF\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],

        ["\xF3\xB1\xA7\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],

        ["\xF3\xB1\xA7\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],

        ["\xF3\xB1\xA7\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],

        ["\xF3\xB1\xA7\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],

        ["\xF3\xB1\xA7\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],

        ["\xF3\xB1\xA7\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],

        ["\xF3\xB1\xA7\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],

        ["\xF3\xB1\xA7\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],

        ["\xF3\xB1\xA7\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],

        ["\xF3\xB1\xA7\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],

        ["\xF3\xB1\xA7\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],

        ["\xF3\xB1\xA7\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],

        ["\xF3\xB1\xA7\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],

        ["\xF3\xB1\xA7\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],

        ["\xF3\xB1\xA7\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],

        ["\xF3\xB1\xA7\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],

        ["\xF3\xB1\xA7\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],

        ["\xF3\xB1\xA7\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],

        ["\xF3\xB1\xA7\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],

        ["\xF3\xB1\xA7\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],

        ["\xF3\xB1\xA7\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],

        ["\xF3\xB1\xA7\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],

        ["\xF3\xB1\xA7\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],

        ["\xF3\xB1\xA7\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],

        ["\xF3\xB1\xA7\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],

        ["\xF3\xB1\xA7\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],

        ["\xF3\xB1\xA7\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],

        ["\xF3\xB1\xA7\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],

        ["\xF3\xB1\xA7\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],

        ["\xF3\xB1\xA7\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],

        ["\xF3\xB1\xA7\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],

        ["\xF3\xB1\xA7\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],

        ["\xF3\xB1\xA7\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],

        ["\xF3\xB1\xA7\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],

        ["\xF3\xB1\xA7\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],

        ["\xF3\xB1\xA7\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],

        ["\xF3\xB1\xA7\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],

        ["\xF3\xB1\xA7\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],

        ["\xF3\xB1\xA7\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],

        ["\xF3\xB1\xA7\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],

        ["\xF3\xB1\xA7\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],

        ["\xF3\xB1\xA7\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],

        ["\xF3\xB1\xA7\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],

        ["\xF3\xB1\xA7\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],

        ["\xF3\xB1\xA7\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],

        ["\xF3\xB1\xA7\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],

        ["\xF3\xB1\xA7\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],

        ["\xF3\xB1\xA7\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],

        ["\xF3\xB1\xA7\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],

        ["\xF3\xB1\xA7\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],

        ["\xF3\xB1\xA7\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],

        ["\xF3\xB1\xA7\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],

        ["\xF3\xB1\xA7\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],

        ["\xF3\xB1\xA7\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],

        ["\xF3\xB1\xA7\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\xE4\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],

        ["\xF3\xB1\xA7\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\xE4\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],

        ["\xF3\xB1\xA7\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],

        ["\xF3\xB1\xA7\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],

        ["\xF3\xB1\xA7\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],

        ["\xF3\xB1\xA7\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],

        ["\xF3\xB1\xA7\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],

        ["\xF3\xB1\xA7\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],

        ["\xF3\xB1\xA7\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],

        ["\xF3\xB1\xA7\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],

        ["\xF3\xB1\xA8\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],

        ["\xF3\xB1\xA8\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],

        ["\xF3\xB1\xA8\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],

        ["\xF3\xB1\xA8\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],

        ["\xF3\xB1\xA8\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],

        ["\xF3\xB1\xA8\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],

        ["\xF3\xB1\xA8\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],

        ["\xF3\xB1\xA8\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],

        ["\xF3\xB1\xA8\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],

        ["\xF3\xB1\xA8\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],

        ["\xF3\xB1\xA8\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],

        ["\xF3\xB1\xA8\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],

        ["\xF3\xB1\xA8\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],

        ["\xF3\xB1\xA8\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],

        ["\xF3\xB1\xA8\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],

        ["\xF3\xB1\xA8\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],

        ["\xF3\xB1\xA8\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],

        ["\xF3\xB1\xA8\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],

        ["\xF3\xB1\xA8\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],

        ["\xF3\xB1\xA8\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],

        ["\xF3\xB1\xA8\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],

        ["\xF3\xB1\xA8\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],

        ["\xF3\xB1\xA8\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],

        ["\xF3\xB1\xA8\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],

        ["\xF3\xB1\xA8\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],

        ["\xF3\xB1\xA8\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],

        ["\xF3\xB1\xA8\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],

        ["\xF3\xB1\xA8\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],

        ["\xF3\xB1\xA8\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],

        ["\xF3\xB1\xA8\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],

        ["\xF3\xB1\xA8\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],

        ["\xF3\xB1\xA8\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],

        ["\xF3\xB1\xA8\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],

        ["\xF3\xB1\xA8\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],

        ["\xF3\xB1\xA8\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],

        ["\xF3\xB1\xA8\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],

        ["\xF3\xB1\xA8\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],

        ["\xF3\xB1\xA8\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],

        ["\xF3\xB1\xA8\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],

        ["\xF3\xB1\xA8\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],

        ["\xF3\xB1\xA8\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],

        ["\xF3\xB1\xA8\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],

        ["\xF3\xB1\xA8\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],

        ["\xF3\xB1\xA8\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],

        ["\xF3\xB1\xA8\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],

        ["\xF3\xB1\xA8\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],

        ["\xF3\xB1\xA8\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],

        ["\xF3\xB1\xA8\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],

        ["\xF3\xB1\xA8\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],

        ["\xF3\xB1\xA8\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],

        ["\xF3\xB1\xA8\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],

        ["\xF3\xB1\xA8\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],

        ["\xF3\xB1\xA8\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],

        ["\xF3\xB1\xA8\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],

        ["\xF3\xB1\xA8\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],

        ["\xF3\xB1\xA8\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],

        ["\xF3\xB1\xA8\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],

        ["\xF3\xB1\xA8\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],

        ["\xF3\xB1\xA8\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],

        ["\xF3\xB1\xA8\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],

        ["\xF3\xB1\xA8\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],

        ["\xF3\xB1\xA8\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],

        ["\xF3\xB1\xA8\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],

        ["\xF3\xB1\xA8\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],

        ["\xF3\xB1\xA9\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],

        ["\xF3\xB1\xA9\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],

        ["\xF3\xB1\xA9\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],

        ["\xF3\xB1\xA9\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],

        ["\xF3\xB1\xA9\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],

        ["\xF3\xB1\xA9\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],

        ["\xF3\xB1\xA9\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],

        ["\xF3\xB1\xA9\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],

        ["\xF3\xB1\xA9\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],

        ["\xF3\xB1\xA9\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],

        ["\xF3\xB1\xA9\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],

        ["\xF3\xB1\xA9\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],

        ["\xF3\xB1\xA9\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],

        ["\xF3\xB1\xA9\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],

        ["\xF3\xB1\xA9\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],

        ["\xF3\xB1\xA9\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],

        ["\xF3\xB1\xA9\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],

        ["\xF3\xB1\xA9\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],

        ["\xF3\xB1\xA9\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],

        ["\xF3\xB1\xA9\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],

        ["\xF3\xB1\xA9\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\xE5\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],

        ["\xF3\xB1\xA9\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xE5\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],

        ["\xF3\xB1\xA9\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],

        ["\xF3\xB1\xA9\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE6\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],

        ["\xF3\xB1\xA9\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE6\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],

        ["\xF3\xB1\xA9\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE6\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],

        ["\xF3\xB1\xA9\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE6\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],

        ["\xF3\xB1\xA9\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE6\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],

        ["\xF3\xB1\xA9\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE6\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],

        ["\xF3\xB1\xA9\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE6\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],

        ["\xF3\xB1\xA9\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE6\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],

        ["\xF3\xB1\xA9\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE6\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],

        ["\xF3\xB1\xA9\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],

        ["\xF3\xB1\xA9\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],

        ["\xF3\xB1\xA9\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE6\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],

        ["\xF3\xB1\xA9\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],

        ["\xF3\xB1\xA9\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE6\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],

        ["\xF3\xB1\xA9\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],

        ["\xF3\xB1\xA9\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE6\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],

        ["\xF3\xB1\xA9\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE6\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],

        ["\xF3\xB1\xA9\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE6\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],

        ["\xF3\xB1\xA9\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE6\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],

        ["\xF3\xB1\xA9\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE6\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],

        ["\xF3\xB1\xA9\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE6\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],

        ["\xF3\xB1\xA9\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE6\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],

        ["\xF3\xB1\xA9\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE6\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],

        ["\xF3\xB1\xA9\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE6\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],

        ["\xF3\xB1\xA9\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE6\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],

        ["\xF3\xB1\xA9\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE6\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],

        ["\xF3\xB1\xA9\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE6\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],

        ["\xF3\xB1\xA9\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE6\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],

        ["\xF3\xB1\xA9\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE6\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],

        ["\xF3\xB1\xA9\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE6\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],

        ["\xF3\xB1\xA9\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],

        ["\xF3\xB1\xA9\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],

        ["\xF3\xB1\xA9\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],

        ["\xF3\xB1\xA9\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],

        ["\xF3\xB1\xA9\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],

        ["\xF3\xB1\xA9\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],

        ["\xF3\xB1\xA9\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],

        ["\xF3\xB1\xA9\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],

        ["\xF3\xB1\xA9\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],

        ["\xF3\xB1\xA9\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],

        ["\xF3\xB1\xA9\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE6\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],

        ["\xF3\xB1\xAA\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE6\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],

        ["\xF3\xB1\xAA\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE6\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],

        ["\xF3\xB1\xAA\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE6\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],

        ["\xF3\xB1\xAA\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE6\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],

        ["\xF3\xB1\xAA\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE6\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],

        ["\xF3\xB1\xAA\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],

        ["\xF3\xB1\xAA\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],

        ["\xF3\xB1\xAA\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],

        ["\xF3\xB1\xAA\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],

        ["\xF3\xB1\xAA\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],

        ["\xF3\xB1\xAA\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],

        ["\xF3\xB1\xAA\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],

        ["\xF3\xB1\xAA\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],

        ["\xF3\xB1\xAA\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],

        ["\xF3\xB1\xAA\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],

        ["\xF3\xB1\xAA\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE6\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],

        ["\xF3\xB1\xAA\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE6\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],

        ["\xF3\xB1\xAA\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE6\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],

        ["\xF3\xB1\xAA\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE6\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],

        ["\xF3\xB1\xAA\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE6\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],

        ["\xF3\xB1\xAA\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE6\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],

        ["\xF3\xB1\xAA\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],

        ["\xF3\xB1\xAA\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE6\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],

        ["\xF3\xB1\xAA\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],

        ["\xF3\xB1\xAA\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],

        ["\xF3\xB1\xAA\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],

        ["\xF3\xB1\xAA\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],

        ["\xF3\xB1\xAA\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],

        ["\xF3\xB1\xAA\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],

        ["\xF3\xB1\xAA\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],

        ["\xF3\xB1\xAA\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],

        ["\xF3\xB1\xAA\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE6\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],

        ["\xF3\xB1\xAA\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE6\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],

        ["\xF3\xB1\xAA\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE6\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],

        ["\xF3\xB1\xAA\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE6\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],

        ["\xF3\xB1\xAA\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE6\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],

        ["\xF3\xB1\xAA\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],

        ["\xF3\xB1\xAA\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],

        ["\xF3\xB1\xAA\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],

        ["\xF3\xB1\xAA\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],

        ["\xF3\xB1\xAA\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],

        ["\xF3\xB1\xAA\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],

        ["\xF3\xB1\xAA\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],

        ["\xF3\xB1\xAA\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],

        ["\xF3\xB1\xAA\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],

        ["\xF3\xB1\xAA\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],

        ["\xF3\xB1\xAA\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],

        ["\xF3\xB1\xAA\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE6\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],

        ["\xF3\xB1\xAA\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE6\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],

        ["\xF3\xB1\xAA\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE6\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],

        ["\xF3\xB1\xAA\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\xE6\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],

        ["\xF3\xB1\xAA\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\xE6\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],

        ["\xF3\xB1\xAA\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],

        ["\xF3\xB1\xAA\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE7\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],

        ["\xF3\xB1\xAA\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE7\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],

        ["\xF3\xB1\xAA\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE7\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],

        ["\xF3\xB1\xAA\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE7\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],

        ["\xF3\xB1\xAA\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE7\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],

        ["\xF3\xB1\xAA\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE7\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],

        ["\xF3\xB1\xAA\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE7\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],

        ["\xF3\xB1\xAA\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE7\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],

        ["\xF3\xB1\xAA\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE7\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],

        ["\xF3\xB1\xAA\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],

        ["\xF3\xB1\xAA\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE7\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],

        ["\xF3\xB1\xAB\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE7\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],

        ["\xF3\xB1\xAB\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE7\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],

        ["\xF3\xB1\xAB\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE7\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],

        ["\xF3\xB1\xAB\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],

        ["\xF3\xB1\xAB\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE7\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],

        ["\xF3\xB1\xAB\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE7\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],

        ["\xF3\xB1\xAB\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE7\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],

        ["\xF3\xB1\xAB\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE7\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],

        ["\xF3\xB1\xAB\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE7\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],

        ["\xF3\xB1\xAB\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE7\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],

        ["\xF3\xB1\xAB\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE7\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],

        ["\xF3\xB1\xAB\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE7\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],

        ["\xF3\xB1\xAB\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE7\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],

        ["\xF3\xB1\xAB\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE7\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],

        ["\xF3\xB1\xAB\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE7\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],

        ["\xF3\xB1\xAB\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE7\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],

        ["\xF3\xB1\xAB\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE7\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],

        ["\xF3\xB1\xAB\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE7\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],

        ["\xF3\xB1\xAB\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE7\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],

        ["\xF3\xB1\xAB\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],

        ["\xF3\xB1\xAB\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],

        ["\xF3\xB1\xAB\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],

        ["\xF3\xB1\xAB\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],

        ["\xF3\xB1\xAB\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],

        ["\xF3\xB1\xAB\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],

        ["\xF3\xB1\xAB\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],

        ["\xF3\xB1\xAB\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],

        ["\xF3\xB1\xAB\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],

        ["\xF3\xB1\xAB\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],

        ["\xF3\xB1\xAB\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE7\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],

        ["\xF3\xB1\xAB\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE7\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],

        ["\xF3\xB1\xAB\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE7\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],

        ["\xF3\xB1\xAB\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE7\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],

        ["\xF3\xB1\xAB\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE7\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],

        ["\xF3\xB1\xAB\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE7\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],

        ["\xF3\xB1\xAB\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],

        ["\xF3\xB1\xAB\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],

        ["\xF3\xB1\xAB\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],

        ["\xF3\xB1\xAB\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],

        ["\xF3\xB1\xAB\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],

        ["\xF3\xB1\xAB\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],

        ["\xF3\xB1\xAB\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],

        ["\xF3\xB1\xAB\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],

        ["\xF3\xB1\xAB\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],

        ["\xF3\xB1\xAB\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],

        ["\xF3\xB1\xAB\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE7\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],

        ["\xF3\xB1\xAB\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE7\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],

        ["\xF3\xB1\xAB\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE7\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],

        ["\xF3\xB1\xAB\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE7\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],

        ["\xF3\xB1\xAB\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE7\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],

        ["\xF3\xB1\xAB\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE7\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],

        ["\xF3\xB1\xAB\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],

        ["\xF3\xB1\xAB\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE7\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],

        ["\xF3\xB1\xAB\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],

        ["\xF3\xB1\xAB\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],

        ["\xF3\xB1\xAB\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],

        ["\xF3\xB1\xAB\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],

        ["\xF3\xB1\xAB\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],

        ["\xF3\xB1\xAB\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],

        ["\xF3\xB1\xAB\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],

        ["\xF3\xB1\xAB\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],

        ["\xF3\xB1\xAB\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE7\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],

        ["\xF3\xB1\xAB\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE7\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],

        ["\xF3\xB1\xAB\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE7\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],

        ["\xF3\xB1\xAC\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE7\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],

        ["\xF3\xB1\xAC\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE7\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],

        ["\xF3\xB1\xAC\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE7\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],

        ["\xF3\xB1\xAC\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],

        ["\xF3\xB1\xAC\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],

        ["\xF3\xB1\xAC\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],

        ["\xF3\xB1\xAC\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],

        ["\xF3\xB1\xAC\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],

        ["\xF3\xB1\xAC\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],

        ["\xF3\xB1\xAC\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],

        ["\xF3\xB1\xAC\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],

        ["\xF3\xB1\xAC\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],

        ["\xF3\xB1\xAC\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],

        ["\xF3\xB1\xAC\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE7\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],

        ["\xF3\xB1\xAC\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE7\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],

        ["\xF3\xB1\xAC\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE7\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],

        ["\xF3\xB1\xAC\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\xE7\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],

        ["\xF3\xB1\xAC\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\xE7\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],

        ["\xF3\xB1\xAC\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],

        ["\xF3\xB1\xAC\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],

        ["\xF3\xB1\xAC\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],

        ["\xF3\xB1\xAC\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],

        ["\xF3\xB1\xAC\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],

        ["\xF3\xB1\xAC\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],

        ["\xF3\xB1\xAC\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],

        ["\xF3\xB1\xAC\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],

        ["\xF3\xB1\xAC\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],

        ["\xF3\xB1\xAC\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],

        ["\xF3\xB1\xAC\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],

        ["\xF3\xB1\xAC\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],

        ["\xF3\xB1\xAC\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],

        ["\xF3\xB1\xAC\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],

        ["\xF3\xB1\xAC\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],

        ["\xF3\xB1\xAC\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],

        ["\xF3\xB1\xAC\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],

        ["\xF3\xB1\xAC\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],

        ["\xF3\xB1\xAC\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],

        ["\xF3\xB1\xAC\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],

        ["\xF3\xB1\xAC\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],

        ["\xF3\xB1\xAC\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],

        ["\xF3\xB1\xAC\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],

        ["\xF3\xB1\xAC\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],

        ["\xF3\xB1\xAC\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],

        ["\xF3\xB1\xAC\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],

        ["\xF3\xB1\xAC\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],

        ["\xF3\xB1\xAC\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],

        ["\xF3\xB1\xAC\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],

        ["\xF3\xB1\xAC\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],

        ["\xF3\xB1\xAC\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],

        ["\xF3\xB1\xAC\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],

        ["\xF3\xB1\xAC\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],

        ["\xF3\xB1\xAC\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],

        ["\xF3\xB1\xAC\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],

        ["\xF3\xB1\xAC\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],

        ["\xF3\xB1\xAC\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],

        ["\xF3\xB1\xAC\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],

        ["\xF3\xB1\xAC\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],

        ["\xF3\xB1\xAC\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],

        ["\xF3\xB1\xAC\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],

        ["\xF3\xB1\xAC\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],

        ["\xF3\xB1\xAC\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],

        ["\xF3\xB1\xAC\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],

        ["\xF3\xB1\xAC\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],

        ["\xF3\xB1\xAC\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],

        ["\xF3\xB1\xAD\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],

        ["\xF3\xB1\xAD\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],

        ["\xF3\xB1\xAD\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],

        ["\xF3\xB1\xAD\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],

        ["\xF3\xB1\xAD\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],

        ["\xF3\xB1\xAD\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],

        ["\xF3\xB1\xAD\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],

        ["\xF3\xB1\xAD\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],

        ["\xF3\xB1\xAD\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],

        ["\xF3\xB1\xAD\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],

        ["\xF3\xB1\xAD\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],

        ["\xF3\xB1\xAD\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],

        ["\xF3\xB1\xAD\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],

        ["\xF3\xB1\xAD\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],

        ["\xF3\xB1\xAD\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],

        ["\xF3\xB1\xAD\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],

        ["\xF3\xB1\xAD\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],

        ["\xF3\xB1\xAD\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],

        ["\xF3\xB1\xAD\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],

        ["\xF3\xB1\xAD\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],

        ["\xF3\xB1\xAD\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],

        ["\xF3\xB1\xAD\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],

        ["\xF3\xB1\xAD\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],

        ["\xF3\xB1\xAD\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],

        ["\xF3\xB1\xAD\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],

        ["\xF3\xB1\xAD\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],

        ["\xF3\xB1\xAD\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],

        ["\xF3\xB1\xAD\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],

        ["\xF3\xB1\xAD\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],

        ["\xF3\xB1\xAD\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],

        ["\xF3\xB1\xAD\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],

        ["\xF3\xB1\xAD\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],

        ["\xF3\xB1\xAD\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],

        ["\xF3\xB1\xAD\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],

        ["\xF3\xB1\xAD\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],

        ["\xF3\xB1\xAD\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],

        ["\xF3\xB1\xAD\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],

        ["\xF3\xB1\xAD\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],

        ["\xF3\xB1\xAD\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],

        ["\xF3\xB1\xAD\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],

        ["\xF3\xB1\xAD\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],

        ["\xF3\xB1\xAD\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],

        ["\xF3\xB1\xAD\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],

        ["\xF3\xB1\xAD\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],

        ["\xF3\xB1\xAD\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],

        ["\xF3\xB1\xAD\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],

        ["\xF3\xB1\xAD\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\xE8\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],

        ["\xF3\xB1\xAD\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],

        ["\xF3\xB1\xAD\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],

        ["\xF3\xB1\xAD\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xBC\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],

        ["\xF3\xB1\xAD\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],

        ["\xF3\xB1\xAD\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],

        ["\xF3\xB1\xAD\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],

        ["\xF3\xB1\xAD\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],

        ["\xF3\xB1\xAD\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],

        ["\xF3\xB1\xAD\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],

        ["\xF3\xB1\xAD\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],

        ["\xF3\xB1\xAD\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],

        ["\xF3\xB1\xAD\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],

        ["\xF3\xB1\xAD\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],

        ["\xF3\xB1\xAD\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],

        ["\xF3\xB1\xAD\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xCC\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],

        ["\xF3\xB1\xAD\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],

        ["\xF3\xB1\xAD\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],

        ["\xF3\xB1\xAE\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],

        ["\xF3\xB1\xAE\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],

        ["\xF3\xB1\xAE\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],

        ["\xF3\xB1\xAE\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],

        ["\xF3\xB1\xAE\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],

        ["\xF3\xB1\xAE\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],

        ["\xF3\xB1\xAE\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],

        ["\xF3\xB1\xAE\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],

        ["\xF3\xB1\xAE\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],

        ["\xF3\xB1\xAE\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],

        ["\xF3\xB1\xAE\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],

        ["\xF3\xB1\xAE\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],

        ["\xF3\xB1\xAE\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],

        ["\xF3\xB1\xAE\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],

        ["\xF3\xB1\xAE\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],

        ["\xF3\xB1\xAE\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],

        ["\xF3\xB1\xAE\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],

        ["\xF3\xB1\xAE\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],

        ["\xF3\xB1\xAE\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],

        ["\xF3\xB1\xAE\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],

        ["\xF3\xB1\xAE\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],

        ["\xF3\xB1\xAE\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],

        ["\xF3\xB1\xAE\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],

        ["\xF3\xB1\xAE\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],

        ["\xF3\xB1\xAE\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],

        ["\xF3\xB1\xAE\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],

        ["\xF3\xB1\xAE\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],

        ["\xF3\xB1\xAE\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],

        ["\xF3\xB1\xAE\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],

        ["\xF3\xB1\xAE\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],

        ["\xF3\xB1\xAE\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],

        ["\xF3\xB1\xAE\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],

        ["\xF3\xB1\xAE\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],

        ["\xF3\xB1\xAE\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],

        ["\xF3\xB1\xAE\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],

        ["\xF3\xB1\xAE\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],

        ["\xF3\xB1\xAE\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],

        ["\xF3\xB1\xAE\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],

        ["\xF3\xB1\xAE\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],

        ["\xF3\xB1\xAE\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],

        ["\xF3\xB1\xAE\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],

        ["\xF3\xB1\xAE\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xB3\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],

        ["\xF3\xB1\xAE\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],

        ["\xF3\xB1\xAE\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],

        ["\xF3\xB1\xAE\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],

        ["\xF3\xB1\xAE\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],

        ["\xF3\xB1\xAE\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],

        ["\xF3\xB1\xAE\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],

        ["\xF3\xB1\xAE\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],

        ["\xF3\xB1\xAE\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],

        ["\xF3\xB1\xAE\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],

        ["\xF3\xB1\xAE\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],

        ["\xF3\xB1\xAE\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],

        ["\xF3\xB1\xAE\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],

        ["\xF3\xB1\xAE\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],

        ["\xF3\xB1\xAE\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],

        ["\xF3\xB1\xAE\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],

        ["\xF3\xB1\xAE\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],

        ["\xF3\xB1\xAE\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],

        ["\xF3\xB1\xAE\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],

        ["\xF3\xB1\xAE\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],

        ["\xF3\xB1\xAE\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],

        ["\xF3\xB1\xAE\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],

        ["\xF3\xB1\xAE\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],

        ["\xF3\xB1\xAF\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],

        ["\xF3\xB1\xAF\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],

        ["\xF3\xB1\xAF\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],

        ["\xF3\xB1\xAF\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],

        ["\xF3\xB1\xAF\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],

        ["\xF3\xB1\xAF\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],

        ["\xF3\xB1\xAF\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],

        ["\xF3\xB1\xAF\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],

        ["\xF3\xB1\xAF\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],

        ["\xF3\xB1\xAF\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],

        ["\xF3\xB1\xAF\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],

        ["\xF3\xB1\xAF\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],

        ["\xF3\xB1\xAF\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\xE9\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],

        ["\xF3\xB1\xAF\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\xE9\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],

        ["\xF3\xB1\xAF\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xEA\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],

        ["\xF3\xB1\xAF\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xEA\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],

        ["\xF3\xB1\xAF\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xEA\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],

        ["\xF3\xB1\xAF\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xC7\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],

        ["\xF3\xB1\xAF\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xEA\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],

        ["\xF3\xB1\xAF\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xEA\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],

        ["\xF3\xB1\xAF\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xEA\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],

        ["\xF3\xB1\xAF\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xEA\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],

        ["\xF3\xB1\xAF\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xEA\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],

        ["\xF3\xB1\xAF\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xEA\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],

        ["\xF3\xB1\xAF\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xEA\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],

        ["\xF3\xB1\xAF\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xEA\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],

        ["\xF3\xB1\xAF\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xEA\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],

        ["\xF3\xB1\xAF\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xEA\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],

        ["\xF3\xB1\xAF\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xEA\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],

        ["\xF3\xB1\xAF\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xEA\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],

        ["\xF3\xB1\xAF\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xEA\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],

        ["\xF3\xB1\xAF\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xEA\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],

        ["\xF3\xB1\xAF\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xEA\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],

        ["\xF3\xB1\xAF\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xEA\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],

        ["\xF3\xB1\xAF\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xEA\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],

        ["\xF3\xB1\xAF\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xEA\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],

        ["\xF3\xB1\xAF\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xEA\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],

        ["\xF3\xB1\xAF\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xEA\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],

        ["\xF3\xB1\xAF\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xEA\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],

        ["\xF3\xB1\xAF\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xEA\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],

        ["\xF3\xB1\xAF\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xEA\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],

        ["\xF3\xB1\xAF\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xEA\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],

        ["\xF3\xB1\xAF\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xEA\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],

        ["\xF3\xB1\xAF\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xEA\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],

        ["\xF3\xB1\xAF\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xEA\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],

        ["\xF3\xB1\xAF\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xEA\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],

        ["\xF3\xB1\xAF\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xEA\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],

        ["\xF3\xB1\xAF\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xEA\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],

        ["\xF3\xB1\xAF\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xEA\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],

        ["\xF3\xB1\xAF\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xEA\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],

        ["\xF3\xB1\xAF\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xEA\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],

        ["\xF3\xB1\xAF\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xEA\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],

        ["\xF3\xB1\xAF\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xEA\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],

        ["\xF3\xB1\xAF\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xEA\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],

        ["\xF3\xB1\xAF\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xEA\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],

        ["\xF3\xB1\xAF\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xEA\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],

        ["\xF3\xB1\xAF\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xEA\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],

        ["\xF3\xB1\xAF\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xEA\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],

        ["\xF3\xB1\xAF\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xEA\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],

        ["\xF3\xB1\xAF\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xEA\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],

        ["\xF3\xB1\xAF\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xEA\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],

        ["\xF3\xB1\xAF\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xEA\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],

        ["\xF3\xB1\xAF\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xEA\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],

        ["\xF3\xB1\xAF\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xEA\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],

        ["\xF3\xB1\xB0\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xEA\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],

        ["\xF3\xB1\xB0\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xEA\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],

        ["\xF3\xB1\xB0\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xEA\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],

        ["\xF3\xB1\xB0\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xEA\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],

        ["\xF3\xB1\xB0\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xEA\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],

        ["\xF3\xB1\xB0\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xEA\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],

        ["\xF3\xB1\xB0\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xEA\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],

        ["\xF3\xB1\xB0\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xEA\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],

        ["\xF3\xB1\xB0\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xEA\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],

        ["\xF3\xB1\xB0\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xEA\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],

        ["\xF3\xB1\xB0\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xEA\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],

        ["\xF3\xB1\xB0\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xEA\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],

        ["\xF3\xB1\xB0\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xEA\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],

        ["\xF3\xB1\xB0\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xEA\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],

        ["\xF3\xB1\xB0\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xEA\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],

        ["\xF3\xB1\xB0\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xEA\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],

        ["\xF3\xB1\xB0\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xEA\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],

        ["\xF3\xB1\xB0\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xEA\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],

        ["\xF3\xB1\xB0\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xEA\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],

        ["\xF3\xB1\xB0\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xEA\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],

        ["\xF3\xB1\xB0\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xEA\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],

        ["\xF3\xB1\xB0\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xEA\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],

        ["\xF3\xB1\xB0\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xEA\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],

        ["\xF3\xB1\xB0\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xEA\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],

        ["\xF3\xB1\xB0\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xEA\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],

        ["\xF3\xB1\xB0\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xEA\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],

        ["\xF3\xB1\xB0\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xEA\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],

        ["\xF3\xB1\xB0\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xEA\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],

        ["\xF3\xB1\xB0\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xEA\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],

        ["\xF3\xB1\xB0\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xEA\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],

        ["\xF3\xB1\xB0\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xEA\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],

        ["\xF3\xB1\xB0\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xEA\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],

        ["\xF3\xB1\xB0\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xEA\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],

        ["\xF3\xB1\xB0\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xEA\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],

        ["\xF3\xB1\xB0\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xEA\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],

        ["\xF3\xB1\xB0\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xEA\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],

        ["\xF3\xB1\xB0\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xEA\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],

        ["\xF3\xB1\xB0\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xEA\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],

        ["\xF3\xB1\xB0\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xEA\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],

        ["\xF3\xB1\xB0\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xEA\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],

        ["\xF3\xB1\xB0\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xEA\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],

        ["\xF3\xB1\xB0\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xEA\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],

        ["\xF3\xB1\xB0\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\xEA\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],

        ["\xF3\xB1\xB0\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\xEA\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],

        ["\xF3\xB1\xB0\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xEB\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],

        ["\xF3\xB1\xB0\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xEB\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],

        ["\xF3\xB1\xB0\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xEB\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],

        ["\xF3\xB1\xB0\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xEB\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],

        ["\xF3\xB1\xB0\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xEB\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],

        ["\xF3\xB1\xB0\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xEB\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],

        ["\xF3\xB1\xB0\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xEB\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],

        ["\xF3\xB1\xB0\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xEB\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],

        ["\xF3\xB1\xB0\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xEB\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],

        ["\xF3\xB1\xB0\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xEB\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],

        ["\xF3\xB1\xB0\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xEB\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],

        ["\xF3\xB1\xB0\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xEB\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],

        ["\xF3\xB1\xB0\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xEB\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],

        ["\xF3\xB1\xB0\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xEB\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],

        ["\xF3\xB1\xB0\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xEB\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],

        ["\xF3\xB1\xB0\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xEB\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],

        ["\xF3\xB1\xB0\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xEB\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],

        ["\xF3\xB1\xB0\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xEB\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],

        ["\xF3\xB1\xB0\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xEB\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],

        ["\xF3\xB1\xB0\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xEB\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],

        ["\xF3\xB1\xB1\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xEB\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],

        ["\xF3\xB1\xB1\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xEB\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],

        ["\xF3\xB1\xB1\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xEB\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],

        ["\xF3\xB1\xB1\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xEB\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],

        ["\xF3\xB1\xB1\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xEB\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],

        ["\xF3\xB1\xB1\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xEB\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],

        ["\xF3\xB1\xB1\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xEB\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],

        ["\xF3\xB1\xB1\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xEB\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],

        ["\xF3\xB1\xB1\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xEB\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],

        ["\xF3\xB1\xB1\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xEB\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],

        ["\xF3\xB1\xB1\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xEB\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],

        ["\xF3\xB1\xB1\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xEB\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],

        ["\xF3\xB1\xB1\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xEB\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],

        ["\xF3\xB1\xB1\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xEB\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],

        ["\xF3\xB1\xB1\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xEB\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],

        ["\xF3\xB1\xB1\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xEB\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],

        ["\xF3\xB1\xB1\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xEB\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],

        ["\xF3\xB1\xB1\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xEB\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],

        ["\xF3\xB1\xB1\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xEB\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],

        ["\xF3\xB1\xB1\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xEB\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],

        ["\xF3\xB1\xB1\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xEB\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],

        ["\xF3\xB1\xB1\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xEB\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],

        ["\xF3\xB1\xB1\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xEB\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],

        ["\xF3\xB1\xB1\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xEB\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],

        ["\xF3\xB1\xB1\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xEB\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],

        ["\xF3\xB1\xB1\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xEB\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],

        ["\xF3\xB1\xB1\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xEB\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],

        ["\xF3\xB1\xB1\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xEB\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],

        ["\xF3\xB1\xB1\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xEB\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],

        ["\xF3\xB1\xB1\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xEB\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],

        ["\xF3\xB1\xB1\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xEB\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],

        ["\xF3\xB1\xB1\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xEB\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],

        ["\xF3\xB1\xB1\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xEB\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],

        ["\xF3\xB1\xB1\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xEB\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],

        ["\xF3\xB1\xB1\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xEB\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],

        ["\xF3\xB1\xB1\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xEB\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],

        ["\xF3\xB1\xB1\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xEB\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],

        ["\xF3\xB1\xB1\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xEB\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],

        ["\xF3\xB1\xB1\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xEB\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],

        ["\xF3\xB1\xB1\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xEB\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],

        ["\xF3\xB1\xB1\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xB4\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],

        ["\xF3\xB1\xB1\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xEB\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],

        ["\xF3\xB1\xB1\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xEB\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],

        ["\xF3\xB1\xB1\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xEB\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],

        ["\xF3\xB1\xB1\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xEB\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],

        ["\xF3\xB1\xB1\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xEB\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],

        ["\xF3\xB1\xB1\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xEB\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],

        ["\xF3\xB1\xB1\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xEB\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],

        ["\xF3\xB1\xB1\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xEB\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],

        ["\xF3\xB1\xB1\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xEB\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],

        ["\xF3\xB1\xB1\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xEB\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],

        ["\xF3\xB1\xB1\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xEB\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],

        ["\xF3\xB1\xB1\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xEB\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],

        ["\xF3\xB1\xB1\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xEB\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],

        ["\xF3\xB1\xB1\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xEB\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],

        ["\xF3\xB1\xB1\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xEB\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],

        ["\xF3\xB1\xB1\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xEB\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],

        ["\xF3\xB1\xB1\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xEB\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],

        ["\xF3\xB1\xB1\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xEB\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],

        ["\xF3\xB1\xB1\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xEB\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],

        ["\xF3\xB1\xB1\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xEB\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],

        ["\xF3\xB1\xB1\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xEB\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],

        ["\xF3\xB1\xB1\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xEB\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],

        ["\xF3\xB1\xB1\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xEB\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],

        ["\xF3\xB1\xB2\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xEB\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],

        ["\xF3\xB1\xB2\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xEB\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],

        ["\xF3\xB1\xB2\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xEB\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],

        ["\xF3\xB1\xB2\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xEB\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],

        ["\xF3\xB1\xB2\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xEB\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],

        ["\xF3\xB1\xB2\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xEB\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],

        ["\xF3\xB1\xB2\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xEB\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],

        ["\xF3\xB1\xB2\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xEB\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],

        ["\xF3\xB1\xB2\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\xEB\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],

        ["\xF3\xB1\xB2\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\xEB\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],

        ["\xF3\xB1\xB2\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xEC\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],

        ["\xF3\xB1\xB2\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xEC\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],

        ["\xF3\xB1\xB2\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xEC\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],

        ["\xF3\xB1\xB2\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xEC\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],

        ["\xF3\xB1\xB2\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xEC\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],

        ["\xF3\xB1\xB2\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xEC\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],

        ["\xF3\xB1\xB2\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xEC\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],

        ["\xF3\xB1\xB2\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xEC\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],

        ["\xF3\xB1\xB2\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xEC\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],

        ["\xF3\xB1\xB2\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xEC\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],

        ["\xF3\xB1\xB2\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xEC\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],

        ["\xF3\xB1\xB2\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xEC\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],

        ["\xF3\xB1\xB2\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xEC\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],

        ["\xF3\xB1\xB2\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xEC\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],

        ["\xF3\xB1\xB2\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xEC\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],

        ["\xF3\xB1\xB2\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xEC\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],

        ["\xF3\xB1\xB2\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xEC\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],

        ["\xF3\xB1\xB2\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xEC\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],

        ["\xF3\xB1\xB2\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xEC\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],

        ["\xF3\xB1\xB2\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xEC\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],

        ["\xF3\xB1\xB2\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xEC\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],

        ["\xF3\xB1\xB2\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xEC\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],

        ["\xF3\xB1\xB2\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xEC\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],

        ["\xF3\xB1\xB2\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xEC\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],

        ["\xF3\xB1\xB2\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xEC\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],

        ["\xF3\xB1\xB2\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xEC\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],

        ["\xF3\xB1\xB2\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xEC\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],

        ["\xF3\xB1\xB2\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xEC\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],

        ["\xF3\xB1\xB2\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xEC\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],

        ["\xF3\xB1\xB2\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xEC\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],

        ["\xF3\xB1\xB2\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xEC\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],

        ["\xF3\xB1\xB2\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xEC\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],

        ["\xF3\xB1\xB2\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xEC\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],

        ["\xF3\xB1\xB2\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xEC\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],

        ["\xF3\xB1\xB2\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xEC\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],

        ["\xF3\xB1\xB2\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xEC\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],

        ["\xF3\xB1\xB2\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xEC\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],

        ["\xF3\xB1\xB2\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xEC\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],

        ["\xF3\xB1\xB2\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xEC\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],

        ["\xF3\xB1\xB2\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xEC\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],

        ["\xF3\xB1\xB2\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xEC\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],

        ["\xF3\xB1\xB2\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xEC\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],

        ["\xF3\xB1\xB2\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xEC\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],

        ["\xF3\xB1\xB2\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xEC\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],

        ["\xF3\xB1\xB2\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xC1\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],

        ["\xF3\xB1\xB2\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xEC\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],

        ["\xF3\xB1\xB2\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xEC\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],

        ["\xF3\xB1\xB2\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xEC\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],

        ["\xF3\xB1\xB2\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xEC\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],

        ["\xF3\xB1\xB2\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xEC\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],

        ["\xF3\xB1\xB2\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xEC\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],

        ["\xF3\xB1\xB2\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xEC\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],

        ["\xF3\xB1\xB2\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xEC\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],

        ["\xF3\xB1\xB2\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xEC\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],

        ["\xF3\xB1\xB3\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xEC\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],

        ["\xF3\xB1\xB3\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xEC\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],

        ["\xF3\xB1\xB3\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xEC\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],

        ["\xF3\xB1\xB3\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xEC\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],

        ["\xF3\xB1\xB3\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xEC\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],

        ["\xF3\xB1\xB3\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xEC\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],

        ["\xF3\xB1\xB3\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xEC\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],

        ["\xF3\xB1\xB3\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xEC\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],

        ["\xF3\xB1\xB3\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xEC\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],

        ["\xF3\xB1\xB3\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xEC\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],

        ["\xF3\xB1\xB3\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xEC\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],

        ["\xF3\xB1\xB3\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xEC\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],

        ["\xF3\xB1\xB3\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xEC\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],

        ["\xF3\xB1\xB3\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xEC\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],

        ["\xF3\xB1\xB3\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xEC\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],

        ["\xF3\xB1\xB3\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xEC\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],

        ["\xF3\xB1\xB3\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xEC\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],

        ["\xF3\xB1\xB3\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xEC\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],

        ["\xF3\xB1\xB3\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xEC\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],

        ["\xF3\xB1\xB3\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xEC\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],

        ["\xF3\xB1\xB3\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xEC\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],

        ["\xF3\xB1\xB3\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xEC\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],

        ["\xF3\xB1\xB3\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xEC\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],

        ["\xF3\xB1\xB3\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xEC\xEE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],

        ["\xF3\xB1\xB3\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xEC\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],

        ["\xF3\xB1\xB3\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xEC\xF0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],

        ["\xF3\xB1\xB3\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xEC\xF1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],

        ["\xF3\xB1\xB3\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xEC\xF2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],

        ["\xF3\xB1\xB3\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xEC\xF3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],

        ["\xF3\xB1\xB3\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xEC\xF4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],

        ["\xF3\xB1\xB3\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xEC\xF5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],

        ["\xF3\xB1\xB3\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xEC\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],

        ["\xF3\xB1\xB3\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xEC\xF7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],

        ["\xF3\xB1\xB3\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xEC\xF8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],

        ["\xF3\xB1\xB3\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xEC\xF9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],

        ["\xF3\xB1\xB3\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xEC\xFA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],

        ["\xF3\xB1\xB3\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xEC\xFB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],

        ["\xF3\xB1\xB3\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xEC\xFC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],

        ["\xF3\xB1\xB3\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\xEC\xFD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],

        ["\xF3\xB1\xB3\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\xEC\xFE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],

        ["\xF3\xB1\xB3\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xED\xA1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],

        ["\xF3\xB1\xB3\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xED\xA2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],

        ["\xF3\xB1\xB3\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xED\xA3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],

        ["\xF3\xB1\xB3\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xED\xA4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],

        ["\xF3\xB1\xB3\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xED\xA5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],

        ["\xF3\xB1\xB3\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xED\xA6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],

        ["\xF3\xB1\xB3\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xED\xA7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],

        ["\xF3\xB1\xB3\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xED\xA8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],

        ["\xF3\xB1\xB3\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xED\xA9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],

        ["\xF3\xB1\xB3\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xED\xAA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],

        ["\xF3\xB1\xB3\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xED\xAB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],

        ["\xF3\xB1\xB3\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xED\xAC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],

        ["\xF3\xB1\xB3\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xED\xAD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],

        ["\xF3\xB1\xB3\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xED\xAE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],

        ["\xF3\xB1\xB3\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xED\xAF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],

        ["\xF3\xB1\xB3\xB7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xED\xB0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],

        ["\xF3\xB1\xB3\xB8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xED\xB1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],

        ["\xF3\xB1\xB3\xB9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xED\xB2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],

        ["\xF3\xB1\xB3\xBA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xED\xB3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],

        ["\xF3\xB1\xB3\xBB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xED\xB4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],

        ["\xF3\xB1\xB3\xBC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xED\xB5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],

        ["\xF3\xB1\xB3\xBD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xED\xB6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],

        ["\xF3\xB1\xB3\xBE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xED\xB7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],

        ["\xF3\xB1\xB3\xBF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xED\xB8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],

        ["\xF3\xB1\xB4\x80",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xED\xB9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],

        ["\xF3\xB1\xB4\x81",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xED\xBA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],

        ["\xF3\xB1\xB4\x82",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xED\xBB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],

        ["\xF3\xB1\xB4\x83",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xED\xBC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],

        ["\xF3\xB1\xB4\x84",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xED\xBD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],

        ["\xF3\xB1\xB4\x85",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xED\xBE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],

        ["\xF3\xB1\xB4\x86",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xED\xBF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],

        ["\xF3\xB1\xB4\x87",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xED\xC0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],

        ["\xF3\xB1\xB4\x88",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xED\xC1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],

        ["\xF3\xB1\xB4\x89",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xED\xC2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],

        ["\xF3\xB1\xB4\x8A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xED\xC3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],

        ["\xF3\xB1\xB4\x8B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xED\xC4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],

        ["\xF3\xB1\xB4\x8C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xED\xC5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],

        ["\xF3\xB1\xB4\x8D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xED\xC6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],

        ["\xF3\xB1\xB4\x8E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xED\xC7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],

        ["\xF3\xB1\xB4\x8F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xED\xC8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],

        ["\xF3\xB1\xB4\x90",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xED\xC9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],

        ["\xF3\xB1\xB4\x91",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xED\xCA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],

        ["\xF3\xB1\xB4\x92",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xED\xCB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],

        ["\xF3\xB1\xB4\x93",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xED\xCC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],

        ["\xF3\xB1\xB4\x94",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xED\xCD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],

        ["\xF3\xB1\xB4\x95",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xED\xCE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],

        ["\xF3\xB1\xB4\x96",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xED\xCF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],

        ["\xF3\xB1\xB4\x97",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xED\xD0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],

        ["\xF3\xB1\xB4\x98",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xED\xD1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],

        ["\xF3\xB1\xB4\x99",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xED\xD2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],

        ["\xF3\xB1\xB4\x9A",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xED\xD3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],

        ["\xF3\xB1\xB4\x9B",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xED\xD4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],

        ["\xF3\xB1\xB4\x9C",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xED\xD5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],

        ["\xF3\xB1\xB4\x9D",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xED\xD6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],

        ["\xF3\xB1\xB4\x9E",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xED\xD7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],

        ["\xF3\xB1\xB4\x9F",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xED\xD8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],

        ["\xF3\xB1\xB4\xA0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xED\xD9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],

        ["\xF3\xB1\xB4\xA1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xED\xDA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],

        ["\xF3\xB1\xB4\xA2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xED\xDB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],

        ["\xF3\xB1\xB4\xA3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xED\xDC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],

        ["\xF3\xB1\xB4\xA4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xED\xDD",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],

        ["\xF3\xB1\xB4\xA5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xED\xDE",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],

        ["\xF3\xB1\xB4\xA6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xED\xDF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],

        ["\xF3\xB1\xB4\xA7",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xED\xE0",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],

        ["\xF3\xB1\xB4\xA8",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xED\xE1",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],

        ["\xF3\xB1\xB4\xA9",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xED\xE2",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],

        ["\xF3\xB1\xB4\xAA",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xED\xE3",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],

        ["\xF3\xB1\xB4\xAB",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xED\xE4",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],

        ["\xF3\xB1\xB4\xAC",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xED\xE5",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],

        ["\xF3\xB1\xB4\xAD",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xED\xE6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],

        ["\xF3\xB1\xB4\xAE",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xED\xE7",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],

        ["\xF3\xB1\xB4\xAF",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xED\xE8",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],

        ["\xF3\xB1\xB4\xB0",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xED\xE9",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],

        ["\xF3\xB1\xB4\xB1",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xED\xEA",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],

        ["\xF3\xB1\xB4\xB2",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xED\xEB",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],

        ["\xF3\xB1\xB4\xB3",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xED\xEC",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],

        ["\xF3\xB1\xB4\xB4",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xED\xED",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],

        ["\xF3\xB1\xB4\xB5",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xC6\xF6",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],

        ["\xF3\xB1\xB4\xB6",'jef','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xED\xEF",'utf8jp','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],

        ["\xF3\xB1\xB4\xB7",'je