package Venus::Role::Testable;

use 5.018;

use strict;
use warnings;

use Venus::Role 'with';

# METHODS

sub is_false {
  my ($self, $code, @args) = @_;

  $code ||= $self->can('value') ? 'value' : sub{};

  require Venus::Boolean;

  return $self->$code(@args) ? Venus::Boolean::FALSE() : Venus::Boolean::TRUE();
}

sub is_true {
  my ($self, $code, @args) = @_;

  $code ||= $self->can('value') ? 'value' : sub{};

  require Venus::Boolean;

  return $self->$code(@args) ? Venus::Boolean::TRUE() : Venus::Boolean::FALSE();
}

# EXPORTS

sub EXPORT {
  ['is_false', 'is_true']
}

1;



=head1 NAME

Venus::Role::Testable - Testable Role

=cut

=head1 ABSTRACT

Testable Role for Perl 5

=cut

=head1 SYNOPSIS

  package Example;

  use Venus::Class;

  with 'Venus::Role::Testable';

  attr 'value';

  sub execute {
    return pop;
  }

  package main;

  my $example = Example->new;

  # $example->is_true(sub{0});

=cut

=head1 DESCRIPTION

This package modifies the consuming package and provides methods for
dispatching method calls and returning truthy returns as true and falsy returns
as false boolean values.

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 is_false

  is_false(Str | CodeRef $method, Any @args) (Bool)

The is_false method dispatches the method call or executes the callback and
returns truthy returns as C<false> and falsy returns as C<true>
L<"boolean"|Venus::Boolean> values.

I<Since C<0.08>>

=over 4

=item is_false example 1

  package main;

  my $example = Example->new;

  my $true = $example->is_false(execute => 0);

  # 1

=back

=over 4

=item is_false example 2

  package main;

  my $example = Example->new;

  my $true = $example->is_false(sub{0});

  # 1

=back

=over 4

=item is_false example 3

  package main;

  my $example = Example->new;

  my $false = $example->is_false(execute => 1);

  # 0

=back

=cut

=head2 is_true

  is_true(Str | CodeRef $method, Any @args) (Bool)

The is_true method dispatches the method call or executes the callback and
returns truthy returns as C<true> and falsy returns as C<false>
L<"boolean"|Venus::Boolean> values.

I<Since C<0.08>>

=over 4

=item is_true example 1

  package main;

  my $example = Example->new;

  my $true = $example->is_true(execute => 1);

  # 1

=back

=over 4

=item is_true example 2

  package main;

  my $example = Example->new;

  my $true = $example->is_true(sub{1});

  # 1

=back

=over 4

=item is_true example 3

  package main;

  my $example = Example->new;

  my $false = $example->is_true(execute => 0);

  # 0

=back

=cut