#!/usr/bin/perl

package eBay::API::XML::Call::GetItemRecommendations::GetItemRecommendationsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetItemRecommendationsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetItemRecommendations::GetItemRecommendationsRequestType

=head1 DESCRIPTION

Examines potential item data that a seller
has specified and returns recommended changes or opportunities for
improvement. The types of recommendations returned for a given
item can be configured by choosing one or more recommendation
engines in the request. This call supports batch requests. That
is, you can retrieve recommendations for multiple items at once.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetItemRecommendations::GetItemRecommendationsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::GetRecommendationsRequestContainerType;


my @gaProperties = ( [ 'GetRecommendationsRequestContainer', 'ns:GetRecommendationsRequestContainerType', '1'
	     ,'eBay::API::XML::DataType::GetRecommendationsRequestContainerType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setGetRecommendationsRequestContainer()

Specifies the data for a single item and configures the recommendation engines to use
when processing the item.
To retrieve recommendations for multiple items, pass a separate
GetRecommendationsRequestContainer for each item. In this case,
pass a user-defined correlation ID for each item to identify the matching response.

  RequiredInput: Yes
#    Argument: reference to an array  
                      of 'ns:GetRecommendationsRequestContainerType'

=cut

sub setGetRecommendationsRequestContainer {
  my $self = shift;
  $self->{'GetRecommendationsRequestContainer'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getGetRecommendationsRequestContainer()

#    Returns: reference to an array  
                      of 'ns:GetRecommendationsRequestContainerType'

=cut

sub getGetRecommendationsRequestContainer {
  my $self = shift;
  return $self->_getDataTypeArray('GetRecommendationsRequestContainer');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
