#!/usr/bin/env perl
package Data::Resolver::Base;
use v5.24;
use warnings;
use Carp;
use English '-no_match_vars';
use experimental 'signatures';

use Moo;
no warnings 'experimental::signatures';
use namespace::clean;

with 'Data::Resolver::RoleComplain';

has _ac         => (is => 'lazy', init_arg => 'asset_class');
has asset_class => (is => 'lazy', init_arg => undef);

sub _build__ac ($self) { return 'Data::Resolver::Asset' }

sub _build_asset_class ($self) {
   my $class = $self->_ac;
   my $path  = "$class.pm" =~ s{::}{/}rgmxs;
   require $path;
   $class;
} ## end sub _build_asset_class

sub asset ($self, $key, $type, $value) {
   return $self->asset_class->new(
      {
         key   => $key,
         $type => $value,
         ouch  => $self->_ouch,
      }
   );
}

sub get_asset              ($self, $key) { ... }
sub get_sub_resolver       ($self, $key) { ... }
sub has_asset              ($self, $key) { ... }
sub has_sub_resolver       ($self, $key) { ... }
sub list_asset_keys        ($self)       { ... }
sub list_sub_resolver_keys ($self)       { ... }

1;
