BEGIN {
  my $rc;
  $rc = eval {
    require PDF::Builder;
    1;
  };
  if (!defined $rc) { $rc = 0; }
  unless($rc) {
    print qq{1..0 # SKIP these tests; PDF::Builder is not installed\n};
    exit;
  }
}

use Test::More tests => 6;

# Bold some words and hyperlink a few other things

use PDF::Builder;
use PDF::TextBlock;

ok(my $pdf = PDF::Builder->new( -file => "41-demo.pdf" ),   "PDF::Builder->new()");
ok(my $tb  = PDF::TextBlock->new({
   pdf       => $pdf,
   fonts     => {
      b => PDF::TextBlock::Font->new({
         pdf  => $pdf,
         font => $pdf->corefont( 'Helvetica-Bold',    -encoding => 'latin1' ),
      }),
   },
}),                                                   "new()");
ok($tb->text(
   $tb->garbledy_gook . 
   ' <b>This fairly lengthy</b>, rather verbose sentence <b>is tagged</b> to appear ' .
   'in a <b>different font, specifically the one we tagged b for "bold".</b> ' .
   $tb->garbledy_gook . 
   ' <href="http://www.omnihotels.com">Click here to visit Omni Hotels.</href> ' .
   $tb->garbledy_gook . "\n\n" . 
   "New paragraph.\n\n" .
   "Another paragraph."
),                                                    "text()");
ok(my ($endw, $ypos) = $tb->apply(),                  "apply()");

$tb->y($ypos);
$tb->text("Generated by t/41-demo.t");
$tb->fonts->{default}->fillcolor('darkblue');
ok(() = $tb->apply(),                                 "apply()");

$pdf->save;    # Doesn't return true, even when it succeeds. -sigh-
$pdf->end;     # Doesn't return true, even when it succeeds. -sigh-
ok(-r "41-demo.pdf",                                  "41-demo.pdf created");

diag( "Testing PDF::TextBlock $PDF::TextBlock::VERSION, Perl $], $^X" );



