# Generated by default/object.tt
package Paws::NetworkFirewall::LoggingConfiguration;
  use Moose;
  has LogDestinationConfigs => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::LogDestinationConfig]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::LoggingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::LoggingConfiguration object:

  $service_obj->Method(Att1 => { LogDestinationConfigs => $value, ..., LogDestinationConfigs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::LoggingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->LogDestinationConfigs

=head1 DESCRIPTION

Defines how AWS Network Firewall performs logging for a Firewall.

=head1 ATTRIBUTES


=head2 B<REQUIRED> LogDestinationConfigs => ArrayRef[L<Paws::NetworkFirewall::LogDestinationConfig>]

Defines the logging destinations for the logs for a firewall. Network
Firewall generates logs for stateful rule groups.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

