# Generated by default/object.tt
package Paws::S3::ReplicaModifications;
  use Moose;
  has Status => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3::ReplicaModifications

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3::ReplicaModifications object:

  $service_obj->Method(Att1 => { Status => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3::ReplicaModifications object:

  $result = $service_obj->Method(...);
  $result->Att1->Status

=head1 DESCRIPTION

A filter that you can specify for selection for modifications on
replicas. Amazon S3 doesn't replicate replica modifications by default.
In the latest version of replication configuration (when C<Filter> is
specified), you can specify this element and set the status to
C<Enabled> to replicate modifications on replicas.

If you don't specify the C<Filter> element, Amazon S3 assumes that the
replication configuration is the earlier version, V1. In the earlier
version, this element is not allowed.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Status => Str

Specifies whether Amazon S3 replicates modifications on replicas.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

