# Generated by default/object.tt
package Paws::GlueDataBrew::Input;
  use Moose;
  has DatabaseInputDefinition => (is => 'ro', isa => 'Paws::GlueDataBrew::DatabaseInputDefinition');
  has DataCatalogInputDefinition => (is => 'ro', isa => 'Paws::GlueDataBrew::DataCatalogInputDefinition');
  has S3InputDefinition => (is => 'ro', isa => 'Paws::GlueDataBrew::S3Location');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Input

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Input object:

  $service_obj->Method(Att1 => { DatabaseInputDefinition => $value, ..., S3InputDefinition => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Input object:

  $result = $service_obj->Method(...);
  $result->Att1->DatabaseInputDefinition

=head1 DESCRIPTION

Represents information on how DataBrew can find data, in either the
Glue Data Catalog or Amazon S3.

=head1 ATTRIBUTES


=head2 DatabaseInputDefinition => L<Paws::GlueDataBrew::DatabaseInputDefinition>

Connection information for dataset input files stored in a database.


=head2 DataCatalogInputDefinition => L<Paws::GlueDataBrew::DataCatalogInputDefinition>

The Glue Data Catalog parameters for the data.


=head2 S3InputDefinition => L<Paws::GlueDataBrew::S3Location>

The Amazon S3 location where the data is stored.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

