/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.misc;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeeChars {
    private SeeChars() {
    }

    public static void seeChars(String str, String outputEncoding) {
        PrintWriter pw;
        try {
            pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, outputEncoding), true);
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println("Unsupported encoding: " + outputEncoding);
            pw = new PrintWriter(System.out, true);
        }
        SeeChars.seeChars(str, pw);
    }

    public static void seeChars(String str, PrintWriter pw) {
        int numCodePoints = str.codePointCount(0, str.length());
        for (int i = 0; i < numCodePoints; ++i) {
            int index = str.offsetByCodePoints(0, i);
            int ch = str.codePointAt(index);
            SeeChars.seeCodePoint(ch, pw);
        }
    }

    public static void seeList(List<?> sentence, String outputEncoding) {
        int len = sentence.size();
        for (int ii = 0; ii < len; ++ii) {
            System.out.println("Word " + ii + " in " + outputEncoding);
            SeeChars.seeChars(sentence.get(ii).toString(), outputEncoding);
        }
    }

    public static void seeCodePoint(int ch, PrintWriter pw) {
        String chstr;
        if (ch == 10) {
            chstr = "nl";
        } else if (ch == 13) {
            chstr = "cr";
        } else {
            char[] chArr = Character.toChars(ch);
            chstr = new String(chArr);
        }
        int ty = Character.getType(ch);
        String tyStr = "";
        switch (ty) {
            case 1: {
                tyStr = " uppercase";
                break;
            }
            case 2: {
                tyStr = " lowercase";
                break;
            }
            case 5: {
                tyStr = " otherLetter";
                break;
            }
            case 12: {
                tyStr = " spaceSeparator";
                break;
            }
            case 20: {
                tyStr = " dashPunct";
                break;
            }
            case 21: {
                tyStr = " startPunct";
                break;
            }
            case 22: {
                tyStr = " endPunct";
                break;
            }
            case 24: {
                tyStr = " otherPunct";
                break;
            }
        }
        Character.UnicodeBlock cub = Character.UnicodeBlock.of(ch);
        pw.println("Character " + ch + " [" + chstr + ", U+" + Integer.toHexString(ch).toUpperCase() + ", valid=" + Character.isValidCodePoint(ch) + ", suppl=" + Character.isSupplementaryCodePoint(ch) + ", mirror=" + Character.isMirrored(ch) + ", type=" + Character.getType(ch) + tyStr + ", uBlock=" + cub + "]");
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1 || args.length > 3) {
                System.err.println("usage: java SeeChars file [inCharEncoding [outCharEncoding]]");
            } else {
                int ch;
                String outEncoding;
                String inEncoding = System.getProperty("file.encoding");
                if (args.length < 3) {
                    System.out.println("Using system default character encoding \"" + inEncoding + "\" for not explicitly specified encodings");
                    if (args.length > 1) {
                        inEncoding = args[1];
                    }
                    outEncoding = inEncoding;
                } else {
                    outEncoding = args[3];
                }
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), inEncoding));
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, outEncoding), true);
                while ((ch = ((Reader)r).read()) >= 0) {
                    int ch2;
                    if (ch >= 0 && Character.isHighSurrogate((char)ch) && (ch2 = ((Reader)r).read()) >= 0) {
                        String chStr = new String(new char[]{(char)ch, (char)ch2});
                        ch = chStr.codePointAt(0);
                    }
                    SeeChars.seeCodePoint(ch, pw);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

