package App::InteractivePerlTutorial::Chapter::Scalar::Strings;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Strings';

1;
__DATA__

=encoding utf-8

=head1 Strings

Strings can be represented in one of two ways.

=head2 Single quoted

Single quoted string literals are delimited by '. Every character (except for \ and '), including newlines, stands for itself. A backslash followed by a single quote means a literal single quote (and does not end the string), a backslash followed by another backslash means a literal backslash. Examples:

 'hello'
 'hello world'
 ''      # an empty string
 'hello
  world' # this string contains a newline
  'a\nb' # 4 characters, a, \, n, b
  'a\'s' # a'b
  'a\\b' # a\b

=head2 Double quoted

Double quoted string literals are delimited by ". Backslashes in double quoted strings can be used to insert any character inside, for example:

  "hello"            # identical to 'hello'
  "hello\nworld"     # hello, a newline, then world
  "\"scare quotes\"" # "scare quotes"
  "\x7f"             # a single delete character

=head2 Operators

You can concatenate strings with the . operator, like this:

  'hello' . " world"             # identical to 'hello world'
  'something' . 'something else' # identical to 'somethingsomething else'

Another string operator is x, the repetition operator. For example,

  'hello' x 4 # equivalent to hellohellohellohello
  'abc ' x 3  # equivalent to 'abc abc abc '

Note that the string repetition operator is NOT commutative (C<A x B> is different from C<B x A>).

=head2 Number-String conversion

Perl converts numbers to strings and vice-versa transparently. For example C<'3' * '4'> is C<12>. This is the reason operators are different for strings and numbers.

If a non-numeric string is used as a number, leading whitespace is ignored and the longest numeric prefix is converted. For example C<' 10hello'> is converted to C<10> and C<'ab'> is converted to C<0>.


=cut
