#!/usr/bin/perl -w
# based on he_mode.bin
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 128) * 7 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer3, "frame is layer III");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 128, 'bitrate');
	is($frame->sample, 44100, 'sample rate');
	my $mode = (qw/
		mono
		dual_channel
		stereo
		normal_joint_stereo
		ms_stereo_only
		intensity_stereo_only
		ms_and_intensity_stereo
		intensity_stereo_only
		intensity_and_ms_stereo
		intensity_stereo_only
		ms_and_intensity_stereo
		mono
		mono
	/)[($_-1) / 10];
	ok(eval "\$frame->$mode", "frame is $mode"); # UGG! fscking 5.005 won't let me just say $obj->$meth.
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
  g, X ,y_kE<" ,y_kE<"                                                                                                                                                                                                 ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kE<"                                                                      g, X                                                                                                                                                                                                                                                                                            ,y_kEc+s1,y_V27??                       g, X                                                                                                                                                                                                                                                                             ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                       :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                         :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                             ,y_kE<"?WZc?+s1                                           :@#9`vHg, X                                                                                                                                                                                                                                                             ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                          :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kE<"?WZc?+s1                                        @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              @ :@#9`vHg, X                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                              ,y_kEc`ǕV_@F6                                                              ` :@`i g, -
H                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                        ` :@`i g, -
H                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]X<#F731wpc+\`                                                       P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 P :@ct"{, 2eP                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_kE ]c|                                                                 p :@ٳP"{, f@                                                                                                                                                                                                                                                             ,y_kE ]c|,y_k`F#t ]c                                                             p :@ٳP"{, f@                                                                                                                                                                                                                                                             .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P :@ٳP"d{,ր !e                                                                                                                                                                                                                                                               .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                             .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380          P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                             .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            P 'KT ɳʜ ,S p%*p                                                                                                                                                                                                                                                              .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAoǕVo?Og@F7~                                           p 'KT ɳ ,S J&$                                                                                                                                                                                                                                                               .PeG#   TPeqWZX? w a                                                p 'KT ɳ d{,ր !fϨ                                                                                                                                                                                                                                                               .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K:"ɳHFd{,ր !e                                                                                                                                                                                                                                                               .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380         P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                             .Pe<G83?__ $- r.Pe0?\˔r#x0pgwG I [@ 2\˗a#380          P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                             .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            P 'K ɳڜ ,S p%jp                                                                                                                                                                                                                                                              .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAh2\˗a#383_=H  AT_                            p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               .Pe<G83?__ $- PeAoǕVo?Og@F7~                                           p 'K ɳ ,S J&d                                                                                                                                                                                                                                                               ,y_kE<"?                                                                                 p 'K ɳ d{,ր !f                                                                                                                                                                                                                                                                              ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                           ,y_kE<"?                                                                   {, `e                                                                                                                                                                                                                                                                                           ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  {, `e                                                                                                                                                                                                                                                                                            ,y_kE<"?                                                                  
