/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.hemf.extractor.HemfExtractor;
import org.apache.poi.hemf.record.AbstractHemfComment;
import org.apache.poi.hemf.record.HemfCommentPublic;
import org.apache.poi.hemf.record.HemfCommentRecord;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.hemf.record.HemfText;
import org.apache.poi.util.RecordFormatException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EMFParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.image("emf");
    private static final MediaType WMF_MEDIA_TYPE = MediaType.image("wmf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedDocumentExtractor = null;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            HemfExtractor ex = new HemfExtractor(stream);
            long lastY = -1L;
            long lastX = -1L;
            long fudgeFactorX = 1000L;
            StringBuilder buffer = new StringBuilder();
            for (HemfRecord record : ex) {
                if (record.getRecordType() == HemfRecordType.comment) {
                    AbstractHemfComment comment = ((HemfCommentRecord)record).getComment();
                    if (comment instanceof HemfCommentPublic.MultiFormats) {
                        if (embeddedDocumentExtractor == null) {
                            embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
                        }
                        this.handleMultiFormats((HemfCommentPublic.MultiFormats)comment, xhtml, embeddedDocumentExtractor);
                        continue;
                    }
                    if (!(comment instanceof HemfCommentPublic.WindowsMetafile)) continue;
                    if (embeddedDocumentExtractor == null) {
                        embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
                    }
                    this.handleWMF((HemfCommentPublic.WindowsMetafile)comment, xhtml, embeddedDocumentExtractor);
                    continue;
                }
                if (!record.getRecordType().equals((Object)HemfRecordType.exttextoutw)) continue;
                HemfText.ExtTextOutW extTextOutW = (HemfText.ExtTextOutW)record;
                if (lastY > -1L && lastY != extTextOutW.getY()) {
                    xhtml.startElement("p");
                    xhtml.characters(buffer.toString());
                    xhtml.endElement("p");
                    buffer.setLength(0);
                    lastX = -1L;
                }
                if (lastX > -1L && extTextOutW.getX() - lastX > fudgeFactorX) {
                    buffer.append(" ");
                }
                String txt = extTextOutW.getText();
                buffer.append(txt);
                lastY = extTextOutW.getY();
                lastX = extTextOutW.getX();
            }
            if (buffer.length() > 0) {
                xhtml.startElement("p");
                xhtml.characters(buffer.toString());
                xhtml.endElement("p");
            }
        }
        catch (RecordFormatException e) {
            throw new TikaException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new TikaException(e.getMessage(), e);
        }
        xhtml.endDocument();
    }

    private void handleWMF(HemfCommentPublic.WindowsMetafile comment, ContentHandler contentHandler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException, TikaException {
        Metadata embeddedMetadata = new Metadata();
        embeddedMetadata.set("Content-Type", WMF_MEDIA_TYPE.toString());
        if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            try (TikaInputStream is = TikaInputStream.get(comment.getWmfInputStream());){
                embeddedDocumentExtractor.parseEmbedded(is, new EmbeddedContentHandler(contentHandler), embeddedMetadata, false);
            }
        }
    }

    private void handleMultiFormats(HemfCommentPublic.MultiFormats comment, ContentHandler handler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, TikaException, SAXException {
        for (HemfCommentPublic.HemfMultiFormatsData data : comment.getData()) {
            EMFParser.handleEmbedded(data.getData(), embeddedDocumentExtractor, handler);
        }
    }

    private static void handleEmbedded(byte[] data, EmbeddedDocumentExtractor embeddedDocumentExtractor, ContentHandler handler) throws TikaException, SAXException {
        try (TikaInputStream is = TikaInputStream.get(data);){
            Metadata embeddedMetadata = new Metadata();
            if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
                embeddedDocumentExtractor.parseEmbedded(is, new EmbeddedContentHandler(handler), embeddedMetadata, false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

