/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.Codes;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static AxisDirection parseAxisDirection(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", string);
        string = CharSequences.trimWhitespaces(string);
        AxisDirection axisDirection = AxisDirections.valueOf(string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == AxisDirections.valueOf(directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new IllegalArgumentException(Resources.format((short)67, string));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection axisDirection, double d) {
        return new DirectionAlongMeridian(axisDirection, d).getDirection();
    }

    public static Angle angle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        ArgumentChecks.ensureNonNull("source", axisDirection);
        ArgumentChecks.ensureNonNull("target", axisDirection2);
        int n = AxisDirections.angleForCompass(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle((double)n * 22.5);
        }
        n = AxisDirections.angleForGeocentric(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle(n * 90);
        }
        n = AxisDirections.angleForDisplay(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return new Angle(n * 90);
        }
        DirectionAlongMeridian directionAlongMeridian2 = AxisDirections.isUserDefined(axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
        DirectionAlongMeridian directionAlongMeridian3 = directionAlongMeridian = AxisDirections.isUserDefined(axisDirection2) ? DirectionAlongMeridian.parse(axisDirection2) : null;
        if (directionAlongMeridian2 != null && directionAlongMeridian != null) {
            return new Angle(directionAlongMeridian2.angle(directionAlongMeridian));
        }
        boolean bl = AxisDirections.isVertical(axisDirection);
        boolean bl2 = AxisDirections.isVertical(axisDirection2);
        if (bl2) {
            if (bl) {
                return new Angle(axisDirection.equals(axisDirection2) ? 0.0 : (axisDirection2.equals(AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(axisDirection) || directionAlongMeridian2 != null) {
                return axisDirection2.equals(AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (bl && (AxisDirections.isCompass(axisDirection2) || directionAlongMeridian != null)) {
            return axisDirection.equals(AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, IncommensurableException {
        ArgumentChecks.ensureNonNull("sourceCS", coordinateSystem);
        ArgumentChecks.ensureNonNull("targetCS", coordinateSystem2);
        if (!Classes.implementSameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Resources.format((short)27));
        }
        Object[] objectArray = CoordinateSystems.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = CoordinateSystems.getAxisDirections(coordinateSystem2);
        MatrixSIS matrixSIS = Matrices.createTransform((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == matrixSIS.isIdentity()) : matrixSIS;
        int n = matrixSIS.getNumCol() - 1;
        int n2 = matrixSIS.getNumRow() - 1;
        for (int i = 0; i < n2; ++i) {
            Unit<?> unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit<?> unit2;
                if (matrixSIS.getElement(i, j) == 0.0 || Objects.equals(unit2 = coordinateSystem.getAxis(j).getUnit(), unit)) continue;
                Number number = 1;
                Number number2 = 0;
                Number[] numberArray = Units.coefficients(unit2.getConverterToAny(unit));
                switch (numberArray != null ? numberArray.length : -1) {
                    case 2: {
                        number = numberArray[1];
                    }
                    case 1: {
                        number2 = numberArray[0];
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IncommensurableException(Resources.format((short)54, unit2, unit));
                    }
                }
                DoubleDouble doubleDouble = DoubleDouble.castOrCopy(matrixSIS.getNumber(i, j));
                DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
                doubleDouble2.multiply(number);
                matrixSIS.setNumber(i, j, doubleDouble2);
                doubleDouble2.setFrom(doubleDouble);
                doubleDouble2.multiply(number2);
                doubleDouble2.add(matrixSIS.getNumber(i, n));
                matrixSIS.setNumber(i, n, doubleDouble2);
            }
        }
        return matrixSIS;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem coordinateSystem, AxisFilter axisFilter) {
        ArgumentChecks.ensureNonNull("filter", axisFilter);
        if (coordinateSystem != null) {
            AbstractCS abstractCS;
            if (axisFilter instanceof AxesConvention) {
                if (coordinateSystem instanceof AbstractCS) {
                    return ((AbstractCS)coordinateSystem).forConvention((AxesConvention)axisFilter);
                }
                abstractCS = Normalizer.forConvention(coordinateSystem, (AxesConvention)axisFilter);
            } else {
                abstractCS = Normalizer.normalize(coordinateSystem, axisFilter, false);
            }
            if (abstractCS != null) {
                return abstractCS;
            }
        }
        return coordinateSystem;
    }

    public static CoordinateSystem replaceLinearUnit(CoordinateSystem coordinateSystem, final Unit<Length> unit) {
        ArgumentChecks.ensureNonNull("newUnit", unit);
        return CoordinateSystems.replaceAxes(coordinateSystem, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> unit2) {
                return Units.isLinear(unit2) ? unit : unit2;
            }

            @Override
            public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
                return true;
            }

            @Override
            public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
                return axisDirection;
            }
        });
    }

    public static CoordinateSystem replaceAngularUnit(CoordinateSystem coordinateSystem, final Unit<javax.measure.quantity.Angle> unit) {
        ArgumentChecks.ensureNonNull("newUnit", unit);
        return CoordinateSystems.replaceAxes(coordinateSystem, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> unit2) {
                return Units.isAngular(unit2) ? unit : unit2;
            }

            @Override
            public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
                return true;
            }

            @Override
            public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
                return axisDirection;
            }
        });
    }

    public static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        ArgumentChecks.ensureNonNull("cs", coordinateSystem);
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            ArgumentChecks.ensureNonNullElement("cs", i, coordinateSystem);
            axisDirectionArray[i] = coordinateSystemAxis.getDirection();
            ArgumentChecks.ensureNonNullElement("cs[#].direction", i, axisDirectionArray[i]);
        }
        return axisDirectionArray;
    }

    public static Integer getEpsgCode(Unit<?> unit, AxisDirection ... axisDirectionArray) {
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("directions", axisDirectionArray);
        short s = Codes.lookup(unit, axisDirectionArray);
        return s != 0 ? Integer.valueOf(s) : null;
    }
}

