/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import javax.media.jai.JaiI18N;

public class ComponentSampleModelJAI
extends ComponentSampleModel {
    public ComponentSampleModelJAI(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, n4, n5, nArray);
    }

    public ComponentSampleModelJAI(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, n4, n5, nArray, nArray2);
    }

    private long getBufferSize() {
        int n = this.bandOffsets[0];
        int n2 = 1;
        while (n2 < this.bandOffsets.length) {
            n = Math.max(n, this.bandOffsets[n2]);
            ++n2;
        }
        long l = 0L;
        if (n >= 0) {
            l += (long)(n + 1);
        }
        if (this.pixelStride > 0) {
            l += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l += (long)(this.scanlineStride * (this.height - 1));
        }
        return l;
    }

    private int[] JAIorderBands(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray2[n2] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray3.length) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < nArray3.length) {
                if (nArray[nArray2[n4]] > nArray[nArray2[n5]]) {
                    n4 = n5;
                }
                ++n5;
            }
            nArray3[nArray2[n4]] = n3 * n;
            nArray2[n4] = nArray2[n3];
            ++n3;
        }
        return nArray3;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int[] nArray;
        Object var3_3 = null;
        int n4 = this.bandOffsets[0];
        int n5 = this.bandOffsets[0];
        int n6 = 1;
        while (n6 < this.bandOffsets.length) {
            n4 = Math.min(n4, this.bandOffsets[n6]);
            n5 = Math.max(n5, this.bandOffsets[n6]);
            ++n6;
        }
        int n7 = this.bandOffsets.length;
        int n8 = Math.abs(this.pixelStride);
        int n9 = Math.abs(this.scanlineStride);
        int n10 = Math.abs(n5 -= n4);
        if (n8 > n9) {
            if (n8 > n10) {
                if (n9 > n10) {
                    nArray = new int[this.bandOffsets.length];
                    n3 = 0;
                    while (n3 < n7) {
                        nArray[n3] = this.bandOffsets[n3] - n4;
                        ++n3;
                    }
                    n9 = n10 + 1;
                    n8 = n9 * n2;
                } else {
                    nArray = this.JAIorderBands(this.bandOffsets, n9 * n2);
                    n8 = n7 * n9 * n2;
                }
            } else {
                n8 = n9 * n2;
                nArray = this.JAIorderBands(this.bandOffsets, n8 * n);
            }
        } else if (n8 > n10) {
            nArray = new int[this.bandOffsets.length];
            n3 = 0;
            while (n3 < n7) {
                nArray[n3] = this.bandOffsets[n3] - n4;
                ++n3;
            }
            n8 = n10 + 1;
            n9 = n8 * n;
        } else if (n9 > n10) {
            nArray = this.JAIorderBands(this.bandOffsets, n8 * n);
            n9 = n7 * n8 * n;
        } else {
            n9 = n8 * n;
            nArray = this.JAIorderBands(this.bandOffsets, n9 * n2);
        }
        n3 = 0;
        if (this.scanlineStride < 0) {
            n3 += n9 * n2;
            n9 *= -1;
        }
        if (this.pixelStride < 0) {
            n3 += n8 * n;
            n8 *= -1;
        }
        int n11 = 0;
        while (n11 < n7) {
            int n12 = n11++;
            nArray[n12] = nArray[n12] + n3;
        }
        return new ComponentSampleModelJAI(this.dataType, n, n2, n8, n9, this.bankIndices, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            nArray2[n] = this.bankIndices[n2];
            nArray3[n] = this.bandOffsets[n2];
            ++n;
        }
        return new ComponentSampleModelJAI(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat(n, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble(n, this.numBanks);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    byArray[n6] = (byte)dataBuffer.getElem(this.bankIndices[n6], n5 + this.bandOffsets[n6]);
                    ++n6;
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    sArray[n7] = (short)dataBuffer.getElem(this.bankIndices[n7], n5 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    nArray[n8] = dataBuffer.getElem(this.bankIndices[n8], n5 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                int n9 = 0;
                while (n9 < n4) {
                    sArray[n9] = (short)dataBuffer.getElem(this.bankIndices[n9], n5 + this.bandOffsets[n9]);
                    ++n9;
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n4] : (float[])object;
                int n10 = 0;
                while (n10 < n4) {
                    fArray[n10] = dataBuffer.getElemFloat(this.bankIndices[n10], n5 + this.bandOffsets[n10]);
                    ++n10;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n4] : (double[])object;
                int n11 = 0;
                while (n11 < n4) {
                    dArray[n11] = dataBuffer.getElemDouble(this.bankIndices[n11], n5 + this.bandOffsets[n11]);
                    ++n11;
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = this.getTransferType();
        int n6 = this.getNumDataElements();
        int n7 = 0;
        Object object2 = null;
        switch (n5) {
            case 0: {
                byte[] byArray = object == null ? new byte[n6 * n3 * n4] : (byte[])object;
                int n8 = n2;
                while (n8 < n2 + n4) {
                    int n9 = n;
                    while (n9 < n + n3) {
                        object2 = this.getDataElements(n9, n8, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        int n10 = 0;
                        while (n10 < n6) {
                            byArray[n7++] = byArray2[n10];
                            ++n10;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                int n11 = n2;
                while (n11 < n2 + n4) {
                    int n12 = n;
                    while (n12 < n + n3) {
                        object2 = this.getDataElements(n12, n11, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        int n13 = 0;
                        while (n13 < n6) {
                            sArray[n7++] = sArray2[n13];
                            ++n13;
                        }
                        ++n12;
                    }
                    ++n11;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n6 * n3 * n4] : (int[])object;
                int n14 = n2;
                while (n14 < n2 + n4) {
                    int n15 = n;
                    while (n15 < n + n3) {
                        object2 = this.getDataElements(n15, n14, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        int n16 = 0;
                        while (n16 < n6) {
                            nArray[n7++] = nArray2[n16];
                            ++n16;
                        }
                        ++n15;
                    }
                    ++n14;
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                int n17 = n2;
                while (n17 < n2 + n4) {
                    int n18 = n;
                    while (n18 < n + n3) {
                        object2 = this.getDataElements(n18, n17, object2, dataBuffer);
                        short[] sArray3 = (short[])object2;
                        int n19 = 0;
                        while (n19 < n6) {
                            sArray[n7++] = sArray3[n19];
                            ++n19;
                        }
                        ++n18;
                    }
                    ++n17;
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n6 * n3 * n4] : (float[])object;
                int n20 = n2;
                while (n20 < n2 + n4) {
                    int n21 = n;
                    while (n21 < n + n3) {
                        object2 = this.getDataElements(n21, n20, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        int n22 = 0;
                        while (n22 < n6) {
                            fArray[n7++] = fArray2[n22];
                            ++n22;
                        }
                        ++n21;
                    }
                    ++n20;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n6 * n3 * n4] : (double[])object;
                int n23 = n2;
                while (n23 < n2 + n4) {
                    int n24 = n;
                    while (n24 < n + n3) {
                        object2 = this.getDataElements(n24, n23, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        int n25 = 0;
                        while (n25 < n6) {
                            dArray[n7++] = dArray2[n25];
                            ++n25;
                        }
                        ++n24;
                    }
                    ++n23;
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    dataBuffer.setElem(this.bankIndices[n6], n5 + this.bandOffsets[n6], byArray[n6] & 0xFF);
                    ++n6;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    dataBuffer.setElem(this.bankIndices[n7], n5 + this.bandOffsets[n7], sArray[n7] & 0xFFFF);
                    ++n7;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    dataBuffer.setElem(this.bankIndices[n8], n5 + this.bandOffsets[n8], nArray[n8]);
                    ++n8;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                int n9 = 0;
                while (n9 < n4) {
                    dataBuffer.setElem(this.bankIndices[n9], n5 + this.bandOffsets[n9], sArray[n9]);
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n10 = 0;
                while (n10 < n4) {
                    dataBuffer.setElemFloat(this.bankIndices[n10], n5 + this.bandOffsets[n10], fArray[n10]);
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                while (n11 < n4) {
                    dataBuffer.setElemDouble(this.bankIndices[n11], n5 + this.bandOffsets[n11], dArray[n11]);
                    ++n11;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = 0;
        Object var8_8 = null;
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        switch (n6) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n7];
                int n8 = n2;
                while (n8 < n2 + n4) {
                    int n9 = n;
                    while (n9 < n + n3) {
                        int n10 = 0;
                        while (n10 < n7) {
                            byArray2[n10] = byArray[n5++];
                            ++n10;
                        }
                        this.setDataElements(n9, n8, byArray2, dataBuffer);
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n7];
                int n11 = n2;
                while (n11 < n2 + n4) {
                    int n12 = n;
                    while (n12 < n + n3) {
                        int n13 = 0;
                        while (n13 < n7) {
                            sArray2[n13] = sArray[n5++];
                            ++n13;
                        }
                        this.setDataElements(n12, n11, sArray2, dataBuffer);
                        ++n12;
                    }
                    ++n11;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n7];
                int n14 = n2;
                while (n14 < n2 + n4) {
                    int n15 = n;
                    while (n15 < n + n3) {
                        int n16 = 0;
                        while (n16 < n7) {
                            nArray2[n16] = nArray[n5++];
                            ++n16;
                        }
                        this.setDataElements(n15, n14, nArray2, dataBuffer);
                        ++n15;
                    }
                    ++n14;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray3 = new short[n7];
                int n17 = n2;
                while (n17 < n2 + n4) {
                    int n18 = n;
                    while (n18 < n + n3) {
                        int n19 = 0;
                        while (n19 < n7) {
                            sArray3[n19] = sArray[n5++];
                            ++n19;
                        }
                        this.setDataElements(n18, n17, sArray3, dataBuffer);
                        ++n18;
                    }
                    ++n17;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n7];
                int n20 = n2;
                while (n20 < n2 + n4) {
                    int n21 = n;
                    while (n21 < n + n3) {
                        int n22 = 0;
                        while (n22 < n7) {
                            fArray2[n22] = fArray[n5++];
                            ++n22;
                        }
                        this.setDataElements(n21, n20, fArray2, dataBuffer);
                        ++n21;
                    }
                    ++n20;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n7];
                int n23 = n2;
                while (n23 < n2 + n4) {
                    int n24 = n;
                    while (n24 < n + n3) {
                        int n25 = 0;
                        while (n25 < n7) {
                            dArray2[n25] = dArray[n5++];
                            ++n25;
                        }
                        this.setDataElements(n24, n23, dArray2, dataBuffer);
                        ++n24;
                    }
                    ++n23;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], f);
    }

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return f;
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], d);
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return d;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n3 * n4];
        int n6 = n2;
        while (n6 < n4 + n2) {
            int n7 = n;
            while (n7 < n3 + n) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    dArray2[n5++] = this.getSampleDouble(n7, n6, n8, dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return dArray2;
    }

    public String toString() {
        String string = "ComponentSampleModelJAI:   dataType=" + this.getDataType() + "  numBands=" + this.getNumBands() + "  width=" + this.getWidth() + "  height=" + this.getHeight() + "  bandOffsets=[ ";
        int n = 0;
        while (n < this.numBands) {
            string = string + this.getBandOffsets()[n] + " ";
            ++n;
        }
        string = string + "]";
        return string;
    }
}

