/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.nio.ByteBuffer;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.unidata.util.Parameter;

@Immutable
public class Attribute {
    private final String name;
    private String svalue;
    private DataType dataType;
    private int nelems;
    private Array values;
    private int hashCode = 0;

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isString() {
        return this.dataType == DataType.STRING;
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public int getLength() {
        return this.nelems;
    }

    public boolean isUnsigned() {
        return this.values != null && this.values.isUnsigned();
    }

    public Array getValues() {
        if (this.values == null && this.svalue != null) {
            this.values = Array.factory(String.class, new int[]{1});
            this.values.setObject(this.values.getIndex(), (Object)this.svalue);
        }
        return this.values;
    }

    public Object getValue(int index) {
        if (this.isString()) {
            return this.getStringValue(index);
        }
        return this.getNumericValue(index);
    }

    public String getStringValue() {
        return this.svalue != null ? this.svalue : this.getStringValue(0);
    }

    public String getStringValue(int index) {
        if (!this.isString() || index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.svalue != null && index == 0) {
            return this.svalue;
        }
        return (String)this.values.getObject(index);
    }

    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    public Number getNumericValue(int index) {
        if (this.isString() || index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.dataType == DataType.STRING) {
            try {
                return new Double(this.getStringValue(index));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.dataType == DataType.BYTE) {
            return this.values.getByte(index);
        }
        if (this.dataType == DataType.SHORT) {
            return this.values.getShort(index);
        }
        if (this.dataType == DataType.INT) {
            return this.values.getInt(index);
        }
        if (this.dataType == DataType.FLOAT) {
            return Float.valueOf(this.values.getFloat(index));
        }
        if (this.dataType == DataType.DOUBLE) {
            return this.values.getDouble(index);
        }
        if (this.dataType == DataType.LONG) {
            return this.values.getLong(index);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Attribute)) {
            return false;
        }
        Attribute att = (Attribute)o;
        if (!this.name.equals(att.name)) {
            return false;
        }
        if (this.nelems != att.nelems) {
            return false;
        }
        if (!this.dataType.equals((Object)att.dataType)) {
            return false;
        }
        if (this.svalue != null) {
            return this.svalue.equals(att.getStringValue());
        }
        if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int r2;
                int r1 = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                int n = r2 = att.isString() ? att.getStringValue(i).hashCode() : att.getNumericValue(i).hashCode();
                if (r1 == r2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.nelems;
            result = 37 * result + this.getDataType().hashCode();
            if (this.svalue != null) {
                result = 37 * result + this.svalue.hashCode();
            } else if (this.values != null) {
                for (int i = 0; i < this.getLength(); ++i) {
                    int h = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                    result = 37 * result + h;
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean strict) {
        StringBuilder buff = new StringBuilder();
        buff.append(strict ? NetcdfFile.escapeName(this.getName()) : this.getName());
        if (this.isString()) {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                String val;
                if (i != 0) {
                    buff.append(", ");
                }
                if ((val = this.getStringValue(i)) == null) continue;
                buff.append("\"").append(NCdumpW.encodeString(val)).append("\"");
            }
        } else {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append(this.getNumericValue(i));
                if (this.dataType == DataType.FLOAT) {
                    buff.append("f");
                    continue;
                }
                if (this.dataType == DataType.SHORT) {
                    if (this.isUnsigned()) {
                        buff.append("US");
                        continue;
                    }
                    buff.append("S");
                    continue;
                }
                if (this.dataType == DataType.BYTE) {
                    if (this.isUnsigned()) {
                        buff.append("UB");
                        continue;
                    }
                    buff.append("B");
                    continue;
                }
                if (this.dataType == DataType.LONG) {
                    if (this.isUnsigned()) {
                        buff.append("UL");
                        continue;
                    }
                    buff.append("L");
                    continue;
                }
                if (this.dataType != DataType.INT || !this.isUnsigned()) continue;
                buff.append("U");
            }
        }
        return buff.toString();
    }

    public Attribute(String name, Attribute from) {
        this.name = name;
        this.dataType = from.dataType;
        this.nelems = from.nelems;
        this.svalue = from.svalue;
        this.values = from.values;
    }

    public Attribute(String name, String val) {
        this.name = name;
        this.setStringValue(val);
    }

    public Attribute(String name, Number val) {
        this.name = name;
        int[] shape = new int[]{1};
        DataType dt = DataType.getType(val.getClass());
        Array vala = Array.factory(dt.getPrimitiveClassType(), shape);
        Index ima = vala.getIndex();
        vala.setDouble(ima.set0(0), val.doubleValue());
        this.setValues(vala);
    }

    public Attribute(String name, Array values) {
        this.name = name;
        this.setValues(values);
    }

    public Attribute(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType == DataType.CHAR ? DataType.STRING : dataType;
        this.nelems = 0;
    }

    public Attribute(String name, List values) {
        this.name = name;
        int n = values.size();
        Object[] pa = null;
        Class<?> c = values.get(0).getClass();
        if (c == String.class) {
            String[] va;
            pa = va = new String[n];
            for (int i = 0; i < n; ++i) {
                va[i] = (String)values.get(i);
            }
        } else if (c == Integer.class) {
            int[] va = new int[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Integer)values.get(i);
            }
        } else if (c == Double.class) {
            double[] va = new double[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Double)values.get(i);
            }
        } else if (c == Float.class) {
            float[] va = new float[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = ((Float)values.get(i)).floatValue();
            }
        } else if (c == Short.class) {
            short[] va = new short[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Short)values.get(i);
            }
        } else if (c == Byte.class) {
            byte[] va = new byte[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Byte)values.get(i);
            }
        } else if (c == Long.class) {
            long[] va = new long[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Long)values.get(i);
            }
        } else {
            throw new IllegalArgumentException("unknown type for Attribute = " + c.getName());
        }
        this.setValues(Array.factory(c, new int[]{n}, (Object)pa));
    }

    public Attribute(Parameter param) {
        this.name = param.getName();
        if (param.isString()) {
            this.setStringValue(param.getStringValue());
        } else {
            double[] values = param.getNumericValues();
            int n = values.length;
            Array vala = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{n}, (Object)values);
            this.setValues(vala);
        }
    }

    protected Attribute(String name) {
        this.name = name;
    }

    private void setStringValue(String val) {
        int len;
        if (val == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        for (len = val.length(); len > 0 && val.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != val.length()) {
            val = val.substring(0, len);
        }
        this.svalue = val;
        this.nelems = 1;
        this.dataType = DataType.STRING;
    }

    protected void setValues(Array arr) {
        if (DataType.getType(arr.getElementType()) == null) {
            throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
        }
        if (arr.getElementType() == Character.TYPE) {
            ArrayChar carr = (ArrayChar)arr;
            if (carr.getRank() == 1) {
                this.svalue = carr.getString();
                this.nelems = 1;
                this.dataType = DataType.STRING;
                return;
            }
            arr = carr.make1DStringArray();
        }
        if (arr.getElementType() == ByteBuffer.class) {
            int totalLen = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                totalLen += bb.limit();
            }
            byte[] ba = new byte[totalLen];
            int pos = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                System.arraycopy(bb.array(), 0, ba, pos, bb.limit());
                pos += bb.limit();
            }
            arr = Array.factory(DataType.BYTE, new int[]{totalLen}, (Object)ba);
        }
        if (arr.getRank() > 1) {
            arr = arr.reshape(new int[]{(int)arr.getSize()});
        }
        this.values = arr;
        this.nelems = (int)arr.getSize();
        this.dataType = DataType.getType(arr.getElementType());
        this.hashCode = 0;
    }
}

