/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.function.PDDictionaryFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType3
extends PDDictionaryFunction {
    protected PDFunctionType3() {
        super(3);
    }

    public PDFunctionType3(COSDictionary functionDictionary) {
        super(functionDictionary);
    }

    public COSArray Eval(COSArray input) throws IOException {
        PDFunction F = null;
        float x = ((COSFloat)input.get(0)).floatValue();
        COSArray Domain = this.getDomainForInput(1).getCOSArray();
        if (this.getBounds().size() == 0) {
            F = PDFunction.create(this.getFunctions().get(0));
        } else if (x < ((COSFloat)Domain.get(0)).floatValue()) {
            F = PDFunction.create(this.getFunctions().get(0));
        } else if (x > ((COSFloat)Domain.get(1)).floatValue()) {
            F = PDFunction.create(this.getFunctions().get(this.getFunctions().size() - 1));
        } else {
            float[] fBounds = this.getBounds().toFloatArray();
            for (int k = 0; k < this.getBounds().size(); ++k) {
                if (!(x <= fBounds[k])) continue;
                F = PDFunction.create(this.getFunctions().get(k));
                break;
            }
            if (F == null) {
                F = PDFunction.create(this.getFunctions().get(this.getFunctions().size() - 1));
            }
        }
        return F.Eval(input);
    }

    protected COSArray getFunctions() {
        return (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.getPDFName("Functions"));
    }

    protected COSArray getBounds() {
        return (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.getPDFName("Bounds"));
    }

    protected COSArray getEncode() {
        return (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.getPDFName("Encode"));
    }
}

