use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg MD));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(256);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	my $MD = shift @vecs;
	my $computed = $sha3->add_bits($Msg, $Len, 1)->hexdigest;
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# Keccak(input|01)[r=1088, c=512] truncated to 256 bits, or SHA3-256 as in FIPS 202 draft

Len = 7
Msg = 4C
MD = A760C277ADA43D6377D3B12DBD27A1402EC0DD84E73058E69EDD90DBE5460DDF

Len = 1083
Msg = A676AE811E49EDACA42C55FF4305E2A12648C465B8FCE4828598D85B6F8821E7DC35731B21AE6A963CDB6CC3D35F1E30B165D42E5844B64475A9E75D6474D9A044BD46696D44929FC185AC54580165FC74BB855FF1CA1E31041B960E6E5AFA62B3E9E216EA004D3EDA3C893B5C2A091161314EDD55DDE464460152684C5154298E0FDEA58C692E02
MD = F0E255991AAB1A085F04AEAF81CEEDF0843FFA113348992A3ABE371F7D9969C1

Len = 2047
Msg = 1F42ADD25C0A80A4C82AAE3A0E302ABF9261DCA7E7884FD869D96ED4CE88AAAA25304D2D79E1FA5CC1FA2C95899229BC87431AD06DA524F2140E70BD0536E9685EE7808F598D8A9FE15D40A72AEFF431239292C5F64BDB7F620E5D160B329DEB58CF6D5C0665A3DED61AE4ADBCA94DC2B7B02CDF3992FDF79B3D93E546D5823C3A630923064ED24C3D974C4602A49DF75E49CF7BD51EDC7382214CBA850C4D3D11B40A70B1D926E3755EC79693620C242AB0F23EA206BA337A7EDC5421D63126CB6C7094F6BC1CF9943796BE2A0D9EB74FC726AA0C0D3B3D39039DEAD39A7169F8C3E2365DD349E358BF08C717D2E436D65172A76ED5E1F1E694A75C19280B15
MD = 740E7E1C3348107E67728DDA6F95ED48D4387B84650FBE67A9789215222E77D7
