use warnings;
use strict;

use Test::More;

eval { require DateTime; };
plan skip_all => "DateTime not available" unless $@ eq "";
plan tests => 93;

require_ok "DateTime::TimeZone::SystemV";

my $tz;

sub try($$) {
	my($timespec, $offset) = @_;
	$timespec =~ /\A([0-9]{4})-([0-9]{2})-([0-9]{2})T
			([0-9]{2}):([0-9]{2}):([0-9]{2})\z/x or die;
	my $dt = DateTime->new(year => $1, month => $2, day => $3,
			       hour => $4, minute => $5, second => $6,
			       time_zone => "floating");
	is eval { $tz->offset_for_local_datetime($dt) }, $offset;
}

$tz = DateTime::TimeZone::SystemV->new("EST5");
try "2004-12-31T19:00:00", -18000;
try "2005-03-03T01:00:00", -18000;
try "2005-06-07T04:01:10", -18000;
try "2005-09-20T07:00:00", -18000;
try "2005-11-02T15:00:00", -18000;
try "2005-12-31T18:59:59", -18000;

foreach("EST5EDT", "EDT4EST5,M10.5.0,M4.5.0") {
	$tz = DateTime::TimeZone::SystemV->new($_);
	try "2004-12-31T19:00:00", -18000;
	try "2005-03-03T01:00:00", -18000;
	try "2005-04-23T23:00:00", -18000;
	try "2005-04-23T23:59:59", -18000;
	try "2005-04-24T00:00:00", -18000;
	try "2005-04-24T00:59:59", -18000;
	try "2005-04-24T01:00:00", -18000;
	try "2005-04-24T01:59:59", -18000;
	try "2005-04-24T02:00:00", undef;
	try "2005-04-24T02:59:59", undef;
	try "2005-04-24T03:00:00", -14400;
	try "2005-04-24T03:59:59", -14400;
	try "2005-04-24T04:00:00", -14400;
	try "2005-04-24T04:59:59", -14400;
	try "2005-04-24T05:00:00", -14400;
	try "2005-04-24T05:59:59", -14400;
	try "2005-04-24T19:59:59", -14400;
	try "2005-04-24T20:00:00", -14400;
	try "2005-04-24T23:59:59", -14400;
	try "2005-04-25T00:00:00", -14400;
	try "2005-04-25T00:59:59", -14400;
	try "2005-04-25T01:00:00", -14400;
	try "2005-06-07T05:01:10", -14400;
	try "2005-09-20T08:00:00", -14400;
	try "2005-10-30T00:00:00", -14400;
	try "2005-10-30T00:59:59", -14400;
	try "2005-10-30T01:00:00", -18000;
	try "2005-10-30T01:59:59", -18000;
	try "2005-10-30T02:00:00", -18000;
	try "2005-10-30T02:59:59", -18000;
	try "2005-10-30T03:00:00", -18000;
	try "2005-10-30T03:59:59", -18000;
	try "2005-10-30T04:00:00", -18000;
	try "2005-10-30T04:59:59", -18000;
	try "2005-10-30T18:59:59", -18000;
	try "2005-10-30T19:00:00", -18000;
	try "2005-10-30T22:59:59", -18000;
	try "2005-10-30T23:00:00", -18000;
	try "2005-10-30T23:59:59", -18000;
	try "2005-10-31T00:00:00", -18000;
	try "2005-11-02T15:00:00", -18000;
	try "2005-12-31T18:59:59", -18000;
	try "2004-12-31T19:00:00", -18000;
}

1;
