#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

সার্বজনীন ঘোষণাপত্র[সম্পাদনা]
মুখবন্ধ[সম্পাদনা]
যেহেতু মানব পরিবারের সকল সদস্যের সহজাত মর্যাদা ও সম অবিচ্ছেদ্য অধিকারসমূহের স্বীকৃতি বিশ্বে স্বাধীনতা, ন্যায়-বিচার ও শান্তির ভিত্তি; যেহেতু মানবিক অধিকারসমূহের প্রতি অবজ্ঞা ও ঘৃণা মানবজাতির বিবেকের পক্ষে অপমানজনক বর্বরোচিত কাযর্কলাপে পরিণতি লাভ করেছে এবং সাধারণ মানুষের সর্বোচ্চ আশা-আকাঙ্খার প্রতীক হিসেবে এমন একটি পৃথিবীর সূচনা ঘোষিত হয়েছে যেখানে মানুষ বাক ও বিশ্বাসের স্বাধীনতা এবং ভয় ও অভাব থেকে নিষ্কৃতি ভোগ করবে;

যেহেতু চূড়ান্ত পদক্ষেপ হিসেবে মানুষকে অত্যাচার ও নিপীড়নের বিরুদ্ধে বিদ্রোহী হতে বাধ্য করা না হলে মানবিক অধিকারসমূহ অবশ্যই আইনের শাসনের দ্বারা সংরক্ষিত করা উচিত;

যেহেতু জাতিসমূহের মধ্যে বন্ধুত্বপূর্ণ সম্পর্কের উন্নয়নে সহায়তা করা অবশ্যক; যেহেতু জাতিসংঘভুক্ত জনগণ সনদের মাধ্যমে মৌল মানবিক অধিকারসমূহ অধিকারসমূহ, মানুষের মর্যাদা ও মূল্য এবং নারী ও পুরুষের সম-অধিকারের প্রতি আস্থা পুনর্ব্যক্ত করেছে এবং সামাজিক অগ্রগতি ও ব্যাপকতর স্বাধীনতা উন্নততর জীবনমান প্রতিষ্ঠাকল্পে দৃঢপ্রতিজ্ঞ;

যেহেতু সদস্যরাষ্ট্রসমূহ জাতিসংঘের সহযোগিতায় মানবিক অধিকার ও মৌল স্বাধিকারসমূহের প্রতি সার্বজনীন শ্রদ্ধা ও মান্যতা বৃদ্ধি অর্জনে অঙ্গীকারাবদ্ধ; যেহেতু সকল অধিকার ও স্বাধিকারের ব্যাপারে একটি সাধারণ সমঝোতা উক্ত অঙ্গীকার সম্পূর্ণরূপে আদায় করার জন্য সর্বাপেক্ষা গুরুত্বপূর্ণ;

তাই সাধারণ পরিষদ সকল জাতি ও জনগোষ্ঠীর অগ্রগতির একটি সাধারণ মানদণ্ড হিসেবে জারি করছে এই মানবাধিকারের সর্বজনীন ঘোষণাপত্র;

ঐ লক্ষ্যে প্রত্যেক ব্যক্তি ও সমাজের প্রত্যেক অঙ্গ মানবিক অধিকারসমূহের এই সর্বজনীন ঘোষণাপত্রটিকে সর্বদা স্মরণ রেখে শিক্ষাদান ও জ্ঞান প্রসারের মাধ্যমে এ সকল অধিকার ও স্বাধিকারের প্রতি শ্রদ্ধাবোধে জাগ্রত করতে এবং জাতীয় ও আন্তর্জাতিক পর্যায়ে প্রগতিশীল ব্যবস্থাদির দ্বারা সদস্য-রাষ্ট্রসমুহের জনগণ ও তাদের অধীনস্থ অঞ্চলসমূহের অধিবাসীবৃন্দ উভয়ের মধ্যে ঐগুলোর সর্বজনীন ও কার্যকর স্বীকৃতি ও মান্যতা অর্জনের জন্য জোর প্রচেষ্টা চালাবে৷

অনুচ্ছেদসমূহ[সম্পাদনা]
অনুচ্ছেদ-১[সম্পাদনা]
বন্ধনহীন অবস্থায় এবং সম-মর্যাদা ও অধিকারাদি নিয়ে সকল মানুষই জন্মগ্রহণ করে৷ বুদ্ধি ও বিবেক তাদের অর্পণ করা হয়েছে; অতএব ভ্রাতৃত্বসুলভ মনোভাব নিয়ে তাদের একে অন্যের প্রতি আচরণ করা উচিত৷

অনুচ্ছেদ-২[সম্পাদনা]
যে কোন প্রকার পার্থক্য যথা - জাতি, গোত্র, বর্ণ, নারী-পুরুষ, ভাষা, ধর্ম, রাজনৈতিক বা অন্য মতবাদ, জাতীয় বা সামাজিক উত্পত্তি, সম্পক্তি, জন্ম, বা অন্য মর্যাদা নির্বিশেষে প্রত্যেকেই ঘোষণাপত্রে উল্লিখিত সকল অধিকার ও স্বাধিকারে স্বত্ববান৷
অধিকন্তু, কোন ব্যক্তি যে দেশ বা অঞ্চলের অধিবাসী, তা স্বাধীন, অছিভুক্ত এলাকা, অসায়ত্ত্বশাসিত অথবা অন্য যে কোন প্রকার সীমিত সার্বভৌমত্বের মধ্যে থাকুক না কেন, তার রাজনৈতিক, সীমানাগত ও আন্তর্জাতিক মর্যাদার ভিত্তিতে কোন পার্থক্য করা চলবে না৷
অনুচ্ছেদ-৩[সম্পাদনা]
প্রত্যেকেরই জীবন-ধারণ, স্বাধীনতা ও ব্যক্তি নিরাপত্তার অধিকার রয়েছে৷

অনুচ্ছেদ-৪[সম্পাদনা]
কাউকে দাস হিসেবে বা দাসত্বের বন্ধনে আবদ্ধ রাখা চলবে না। সকল প্রকার দাস-প্রথা ও দাস-ব্যবসা নিষিদ্ধ থাকবে৷

অনুচ্ছেদ-৫[সম্পাদনা]
কাউকে নির্যাতন অথবা নিষ্ঠুর, অমানুষিক অথবা অবমাননাকর আচরণ অথবা শাস্তি ভোগে বাধ্য করা চলবে না৷

অনুচ্ছেদ-৬[সম্পাদনা]
আইনের সমক্ষে প্রত্যেকেরই সর্বত্র ব্যক্তি হিসেবে স্বীকৃতিলাভের অধিকার রয়েছে৷

অনুচ্ছেদ-৭[সম্পাদনা]
আইনের কাছে সকলেরই সমান এবং কোনরূপ বৈষম্য ব্যতিরেকে সকলেরই আইনের দ্বারা সমভাবে রক্ষিত হওয়ার অধিকার রয়েছে৷ এই ঘোষণাপত্রের লঙ্ঘনজনিত বৈষম্য বা এরূপ বৈষম্যের উস্কানির বিরুদ্ধে সমভাবে রক্ষিত হওয়ার অধিকার সকলেরই আছে৷

অনুচ্ছেদ-৮[সম্পাদনা]
যে কার্যাদির ফলে শাসনতন্ত্র বা আইন কর্তৃক প্রদত্ত মৌল অধিকারসমূহ লঙ্ঘিত হয় সে সবের জন্য উপযুক্ত জাতীয় বিচার আদালতের মারফত কার্যকর প্রতিকার লাভের অধিকার প্রত্যেকেরই রয়েছে৷

অনুচ্ছেদ-৯[সম্পাদনা]
কাউকে খেয়াল-খুশিমত গ্রেফতার, আটক অথবা নির্বাসন দণ্ডে দণ্ডিত করা যাবে না৷

অনুচ্ছেদ-১০[সম্পাদনা]
প্রত্যেকেরই তার অধিকার ও দায়িত্বসমূহ এবং তার বিরুদ্ধে আনীত যে কোন ফৌজদারী অভিযোগ নিরূপণের জন্য পূর্ণ সমতারভিত্তিতে একটি স্বাধীন ও নিরপেক্ষ বিচার-আদালতে ন্যায্যভাবে ও প্রকাশ্যে শুনানী লাভের অধিকার রয়েছে৷

অনুচ্ছেদ-১১[সম্পাদনা]
কোন দণ্ডযোগ্য অপরাধে অভিযুক্ত হলে প্রত্যেকেরই আত্মপক্ষ সমর্থনের নিশ্চয়তা দেয় এমন গণ-আদালত কর্তৃক আইন অনুযায়ী দোষী সাব্যস্ত না হওয়া পর্যন্ত নির্দোষ বলে বিবেচিত হওয়ার অধিকার রয়েছে৷
কাউকেই কোন কাজ বা ক্রটির জন্য দণ্ডযোগ্য অপরাধে দোষী সাবাস্ত করা চলবে না, যদি সংঘটনকালে তা জাতীয় বা আন্তর্জাতিক আইন অনুযায়ী দণ্ডযোগ্য অপরাধ বলে গণ্য না হয়ে থাকে৷ আবার দণ্ডযোগ্য অপরাধ সংঘটনকালে যতটুকু শাস্তি প্রযোজ্য ছিল তার চেয়ে শাস্তি প্রয়োগ চলবে না৷
অনুচ্ছেদ-১২[সম্পাদনা]
কাউকে তার ব্যক্তিগত গোপনীয়তা, পরিবার, বসতবাড়ি বা চিঠিপত্রের ব্যাপারে খেয়ালখুশিমত হস্তক্ষেপ অথবা সম্মান ও সুনামের ওপর আক্রমণ করা চলবে না৷

অনুচ্ছেদ-১৩[সম্পাদনা]
নিজ রাষ্ট্রের সীমানার মধ্যে চলাচল ও বসতি স্থাপনের অধিকার প্রত্যেকেরই রয়েছে৷
প্রত্যেকেরই নিজ দেশসহ যে কোন দেশ ছেড়ে যাওয়ার ও স্বদেশ প্রত্যাবর্তনের অধিকার রয়েছে৷
অনুচ্ছেদ-১৪[সম্পাদনা]
নির্যাতন এড়ানোর জন্য প্রত্যেকেরই অপর দেশসমূহে আশ্রয় প্রার্থনা ও আশ্রয় লাভ করার অধিকার রয়েছে৷
অ-রাজনৈতিক অপরাধসমূহ অথবা জাতিসংঘের উদ্দেশ্যে ও মূলনীতি বিরোধী কার্যকলাপ থেকে সত্যিকারভাবে উদ্ভূত নির্যাতনের ক্ষেত্রে এই অধিকার নাও পাওয়া যেতে পারে৷
অনুচ্ছেদ-১৫[সম্পাদনা]
প্রত্যেকেরই একটি জাতীয়তার অধিকার রয়েছে৷
কাউকেই যথেচ্ছভাবে তার জাতীয়তা থেকে বঞ্চিত করা অথবা তাকে তার জাতীয়তা পরিবর্তনের অধিকার অস্বীকার করা চলবে না৷
অনুচ্ছেদ-১৬[সম্পাদনা]
পূর্ণ-বয়স্ক পুরুষ ও নারীদের জাতিগত, জাতীয়তা অথবা ধর্মের কারণে কোন সীমাবব্ধতা ব্যতিরেকে বিবাহ করা ও পরিবার গঠনের অধিকার রয়েছে৷ বিবাহের ব্যাপারে, বিবাহিত অবস্থায় এবং বিবাহ বিচ্ছেদকালে তাদের সম-অধিকার রয়েছে৷
কেবল বিবাহ-ইচ্ছুক পাত্র-পাত্রীর অবাধ ও পূর্ণ সম্মতির দ্বারা বিবাহবন্ধনে আবদ্ধ হওয়া যাবে৷
পরিবার হচ্ছে সমাজের স্বাভাবিক ও মৌলিক একক গোষ্ঠী; সমাজ ও রাষ্ট্র কর্তৃক এর সংরক্ষিত হওয়ার অধিকার রয়েছে৷
অনুচ্ছেদ-১৭[সম্পাদনা]
প্রত্যেকেরই একাকী এবং অপরের সহযোগিতায় সম্পত্তির মালিক হওয়ার অধিকার রয়েছে৷
কাউকেই তার সম্পত্তি থেকে খেয়ালখুশিমত বঞ্চিত করা চলবে না৷
অনুচ্ছেদ-১৮[সম্পাদনা]
প্রত্যেকেরই চিন্তা, বিবেক ও ধর্মের স্বাধীনতার অধিকার রয়েছে৷ নিজ ধর্ম অথবা বিশ্বাস পরিবর্তনের স্বাধীনতা এবং একাই অথবা অপরের যোগসাজশে ও প্রকাশ্যে বা গোপনের নিজ ধর্ম বা বিশ্বাস শিক্ষাদান, প্রচার, উপাসনা ও পালনের মাধ্যমে প্রকাশ করার স্বাধীনতা এই অধিকারের অন্তর্ভুক্ত৷

অনুচ্ছেদ-১৯[সম্পাদনা]
প্রত্যেকেরই মতামতের ও মতামত প্রকাশের স্বাধিকার রয়েছে; বিনা হস্তক্ষেপে মতামত পোষণ এবং যে কোন উপায়ে ও রাষ্ট্রীয় সীমানা নির্বিশেষে তথ্য ও মতামত সন্ধান, গ্রহণ ও জ্ঞাত করার স্বাধীনতা এই অধিকারের অন্তর্ভুক্ত৷

অনুচ্ছেদ-২০[সম্পাদনা]
প্রত্যেকেরই শান্তিপূর্ণভাবে সম্মিলিত হওয়ার অধিকার রয়েছে৷
কাউকেই কোন সংঘভুক্ত হতে বাধ্য করা যাবে না৷
অনুচ্ছেদ-২১[সম্পাদনা]
প্রত্যক্ষভাবে অথবা অবাধে নির্বাচিত প্রতিনিধিদের মাধ্যমে নিজ দেশের সরকারে অংশগ্রহণের অধিকার প্রত্যেকেরই রয়েছে৷
প্রত্যেকেরই নিজ দেশের সরকারী চাকুরীতে সমান সুযোগ লাভের অধিকার রয়েছে৷
জনগণের ইচ্ছাই হবে সরকারের ক্ষমতার ভিত্তি; এই ইচ্ছা সর্বজনীন ও সমান ভোটাধিকারের ভিত্তিতে নৈমিত্তিকভাবে এবং প্রকৃত নির্বাচন দ্বারা ব্যক্ত হবে; গোপন ব্যালট অথবা অনুরূপ অবাধ ভোটদান পদ্ধতিতে এরূপ নির্বাচন অনুষ্ঠিত হবে৷
অনুচ্ছেদ-২২[সম্পাদনা]
সমাজের সদস্য হিসেবে প্রত্যেকেরই সামাজিক নিরাপত্তার অধিকার রয়েছে; প্রত্যেকেই জাতীয় প্রচেষ্টা ও আন্তর্জাতিক সহযোগিতার মাধ্যমে এবং প্রতিটি রাষ্ট্রের সংগঠন ও সম্পদ অনুসারে তার মর্যাদা ও অবাধে ব্যক্তিত্ব বিকাশের জন্য অপরিহার্য অর্থনৈতিক, সামাজিক ও সাংস্কৃতিক অধিকারসমূহ আদায় করতে পারবে৷

অনুচ্ছেদ-২৩[সম্পাদনা]
প্রত্যেকেরই কাজ করার, অবাধে চাকুরী নির্বাচনের, কাজের জন্য ন্যায্য অনুকূল অবস্থা লাভের এবং বেকারত্ব থেকে রক্ষিত হওয়ার অধিকার রয়েছে৷
প্রত্যেকেরই কোন বৈষম্য ব্যতিরেকে সমান কাজের জন্য সমান বেতন পাওয়ার অধিকার রয়েছে৷
প্রত্যেক কর্মী তার নিজের ও পরিবারের মানবিক মর্যাদা রক্ষার নিশ্চয়তা দিতে সক্ষম এমন ন্যায্য ও অনুকূল পারিশ্রমিক এবং প্রয়োজনবোধে সেই সঙ্গে সামাজেক নিরাপত্তার জন্য অন্যান্য সুবিধা লাভের অধিকারী৷
প্রত্যেকেরই নিজ স্বার্থ রক্ষার্থে শ্রমিক ইউনিয়ন গঠন ও এতে যোগদানের অধিকার রয়েছে৷
অনুচ্ছেদ-২৪[সম্পাদনা]
প্রত্যেকেরই বিশ্রাম ও অবসর বিনোদনের অধিকার রয়েছে৷ কাজের সময়ের যুক্তিসঙ্গত সীমা ও বেতনসহ নৈমিত্তিক ছুটি এ অধিকারের অন্তর্ভুক্ত৷

অনুচ্ছেদ-২৫[সম্পাদনা]
নিজের এবং নিজ পরিবারের স্বাস্থ্য ও কল্যাণের নিমিত্ত পর্যাপ্ত জীবনমানের অধিকার প্রত্যেকেরই রয়েছে৷ খাদ্য, বস্ত্র, বাসস্থান, চিকিত্সা ও প্রয়োজনীয় সামাজিক সেবামূলক কার্যাদির সুযোগ এবং বেকারত্ব, পীড়া, অক্ষমতা, বৈধব্য, বার্ধক্য অথবা অনিবার্য কারণে জীবন যাপনে অন্যান্য অপারগতার ক্ষেত্রে নিরাপত্তা এই অধিকারের অন্তর্ভুক্ত৷
মাতৃত্বকালে ও শৈশব অবস্থায় প্রত্যেকের বিশেষ যত্ন ও সহায়তা লাভের অধিকার রয়েছে৷ জন্ম বৈবাহিক বন্ধনের ফলে বা বৈবাহিক বন্ধনের বাইরে হোক, সকল শিশুই অভিন্ন সামাজিক নিরাপত্তা ভোগ করবে৷
অনুচ্ছেদ-২৬[সম্পাদনা]
প্রত্যেকেরই শিক্ষালাভের অধিকার রয়েছে৷ অন্ততপক্ষে প্রাথমিক ও মৌলিক পর্যায়ে শিক্ষা অবৈতনিক হবে৷ প্রাথমিক শিক্ষা বাধ্যতামূলক হবে৷ কারিগরী ও বৃত্তিমূলক শিক্ষা সাধারণভাবে লভ্য থাকবে এবং উচ্চতর শিক্ষা মেধার ভিত্তিতে সকলের জন্য উণ্মুক্ত থাকবে৷
ব্যক্তিত্বের পূর্ণ বিকাশ ও মানবিক অধিকার এবং মৌলিক স্বাধিকারসমূহের প্রতি শ্রদ্ধাবোধ দৃঢ করার উদ্দেশ্যে শিক্ষা পরিচালিত হবে৷ সমঝোতা, সহিষ্ণুতা ও সকল জাতি, বর্ণ ও ধর্মীয় গোষ্ঠীর মধ্যে বন্ধুত্ব উন্নয়ন এবং শান্তি রক্ষার্থে জাতিসংঘ কর্মতত্পরতা বৃদ্ধি করবে৷
যে প্রকার শিক্ষা তাদের সন্তানদের দেওয়া হবে তা পূর্ব থেকে বেছে নেওয়ার অধিকার পিতামাতার রয়েছে৷
অনুচ্ছেদ-২৭[সম্পাদনা]
প্রত্যেকেরই গোষ্ঠীমত সাংস্কৃতিক জীবনে অবাধে অংশগ্রহণ, শিল্পকলা চর্চা করা এবং বৈজ্ঞানিক অগ্রগতি ও এর সুফলসমূহের অংশীদার হওয়ার অধিকার রয়েছে৷
প্রত্যেকেরই বিজ্ঞান, সাহিত্য অথবা শিল্পকলাভিত্তিক সৃজনশীল কাজ থেকে উদ্ভূত নৈতিক ও বৈষয়িক স্বার্থসমূহ রক্ষনের অধিকার রয়েছে৷
অনুচ্ছেদ-২৮[সম্পাদনা]
প্রত্যেকেই এমন একটি সামাজিক ও আন্তর্জাতিক ব্যবস্থার জন্য স্বত্ববান যেখানে এই ঘোষণাপত্রে উল্লিখিত অধিকার ও স্বাধীনতাসমূহ পূর্ণভাবে আদায় করা যেতে পারে৷

অনুচ্ছেদ-২৯[সম্পাদনা]
প্রত্যেকেরই সমাজের প্রতি কর্তব্যাদি রয়েছে কেবল যার অন্তর্গত হয়েই তার ব্যক্তিত্বের অবাধ ও পূর্ণ বিকাশ সম্ভব৷
স্বীয় অধিকার ও স্বাধীনতাসমূহ প্রয়োগকালে প্রত্যেকেরই শুধু ঐ ধরনের সীমাবদ্ধ থাকবে যা কেবল অপরের অধিকার ও স্বাধীনতাসমূহের যর্থাথ স্বীকৃতি ও শ্রদ্ধা নিশ্চিত করতে পারে৷ এরূপ সীমাবদ্ধ একটি গণতান্ত্রিক সমাজে নৈতিকতা, গণশৃঙ্খলা ও সাধারণ কল্যাণের ন্যায্য প্রয়োজনসমূহ মিটানোর উদ্দেশ্যে আইনের দ্বারা নিরূপিত হবে৷
এ সকল অধিকার ও স্বাধীনতা ভোগকালে কোন ক্ষেত্রেই জাতিসংঘের উদ্দেশ্য ও মূলনীতি লঙ্ঘন করা চলবে না।
অনুচ্ছেদ-৩০[সম্পাদনা]
এই ঘোষণার উল্লিখিত কোন বিষয়কে এরূপভাবে ব্যাখ্যা করা চলবে না যাতে মনে হয় যে এই ঘোষণার অন্তর্ভুক্ত কোন অধিকার বা স্বাধীনতা ক্ষুণ্ন করার উদ্দেশ্যে কোন রাষ্ট্র, দল বা ব্যক্তি বিশেষের আত্মনিয়োগের অধিকার রয়েছে৷




TEXT

is(Text::Guess::Language->guess($text),'bn','is bn');

done_testing;
