# Generated by default/object.tt
package Paws::Quicksight::DashboardSearchFilter;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has Operator => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::DashboardSearchFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::DashboardSearchFilter object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::DashboardSearchFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A filter that you apply when searching for dashboards.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the value that you want to use as a filter, for example,
C<"Name": "QUICKSIGHT_USER">.


=head2 B<REQUIRED> Operator => Str

The comparison operator that you want to use as a filter, for example,
C<"Operator": "StringEquals">.


=head2 Value => Str

The value of the named item, in this case C<QUICKSIGHT_USER>, that you
want to use as a filter, for example, C<"Value":
"arn:aws:quicksight:us-east-1:1:user/default/UserName1">.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

