# Generated by default/object.tt
package Paws::CodeArtifact::PackageVersionSummary;
  use Moose;
  has Revision => (is => 'ro', isa => 'Str', request_name => 'revision', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has Version => (is => 'ro', isa => 'Str', request_name => 'version', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::PackageVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::PackageVersionSummary object:

  $service_obj->Method(Att1 => { Revision => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::PackageVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Revision

=head1 DESCRIPTION

Details about a package version, including its status, version, and
revision. The ListPackageVersions
(https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)
operation returns a list of C<PackageVersionSummary> objects.

=head1 ATTRIBUTES


=head2 Revision => Str

The revision associated with a package version.


=head2 B<REQUIRED> Status => Str

A string that contains the status of the package version. It can be one
of the following:

=over

=item *

C<Published>

=item *

C<Unfinished>

=item *

C<Unlisted>

=item *

C<Archived>

=item *

C<Disposed>

=back



=head2 B<REQUIRED> Version => Str

Information about a package version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

