/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.HIGH_AVAILABILITY})
public abstract class ChunkEventHandler {
    private final TaskManager taskManager;
    private final AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private final AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private static final Pattern eventAttrFmt;
    private static final Pattern tsFmt;
    private static final Pattern tzFmt;
    private static final Pattern tsStrFmt;
    private static final Pattern tzStrFmt;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public ChunkEventHandler() {
        this(UniversalConnectionPoolManagerBase.getTaskManager());
    }

    public ChunkEventHandler(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public boolean start(ONSDriver onsDriver) {
        if (this.task.compareAndSet(null, this.prepareTask(onsDriver))) {
            this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
            ClioSupport.ilogFinest(null, null, null, null, "started");
        }
        return true;
    }

    private Task<Object> prepareTask(final ONSDriver onsDriver) {
        return new UCPTaskBase<Object>(){
            Subscriber subscriber = null;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public boolean isCritical() {
                return true;
            }

            @Override
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            public void run() {
                try {
                    this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Subscriber run() throws UniversalConnectionPoolException {
                            try {
                                return onsDriver.createSubscriber("(%\"eventType=database/event/chunk\")|(%\"eventType=database/event/routing\")");
                            }
                            catch (Exception e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                                throw new UniversalConnectionPoolException(e);
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (null == this.subscriber) {
                        return;
                    }
                    this.handleNotifications();
                }
                catch (PrivilegedActionException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    if (null != this.subscriber) {
                        this.subscriber.close();
                        this.subscriber = null;
                    }
                }
            }

            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            private void handleNotifications() {
                ChunkEventHandler.this.terminate.set(false);
                while (!Thread.currentThread().isInterrupted() && !ChunkEventHandler.this.terminate.get()) {
                    try {
                        Notification notification = this.subscriber.receive(true);
                        if (notification == null) {
                            ClioSupport.ilogFine(null, null, null, null, "empty notification");
                            continue;
                        }
                        String nType = notification.type();
                        ClioSupport.ilogFinest(null, null, null, null, nType.toString());
                        String nBody = new String(notification.body());
                        ClioSupport.ilogFinest(null, null, null, null, nBody.toString());
                        Event event = ChunkEventHandler.this.parseNotification(nType.toLowerCase(), nBody.toLowerCase());
                        if (ChunkEventHandler.this.outOfOrder(event)) continue;
                        ChunkEventHandler.this.recentEvent = event;
                        ChunkEventHandler.this.onEvent(event);
                        continue;
                    }
                    catch (Throwable e) {
                        ClioSupport.ilogFine(null, null, null, null, e.toString());
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                        continue;
                    }
                    break;
                }
                return;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(ChunkEventHandler.class, ONSDriver.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("handleNotifications", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isCritical", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private boolean outOfOrder(Event newEvent) {
        if (this.recentEvent != null && newEvent.timeStamp().before(this.recentEvent.timeStamp())) {
            ClioSupport.ilogFinest(null, null, null, null, "Out-of-order chunk event received and ignored");
            return true;
        }
        return false;
    }

    Event parseNotification(String nTypeLowerCase, String nBodyLowerCase) {
        Matcher mg3;
        final Properties props = new Properties();
        Matcher mg1 = eventAttrFmt.matcher(nBodyLowerCase);
        while (mg1.find()) {
            props.setProperty(mg1.group(1), mg1.group(2));
        }
        Matcher mg2 = tsFmt.matcher(nBodyLowerCase);
        if (mg2.find()) {
            if (tsStrFmt.matcher(mg2.group(2)).find()) {
                props.setProperty(mg2.group(1), mg2.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + mg2.group(2));
            }
        }
        if ((mg3 = tzFmt.matcher(nBodyLowerCase)).find()) {
            if (tzStrFmt.matcher(mg3.group(2)).find()) {
                props.setProperty(mg3.group(1), mg3.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + mg3.group(2));
            }
        }
        return new Event(){
            private final String version;
            private String event_type;
            private final String database;
            private final String instance;
            private final String host;
            private final String dbDomain;
            private final String chunk;
            private final String newChunk;
            private final String hashBoundary;
            private final int priority;
            private final Event.Status status;
            private Date timestamp;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                this.version = props.getProperty("version");
                this.event_type = props.getProperty("event_type", "UNKNOWN");
                this.database = props.getProperty("database");
                this.instance = props.getProperty("instance");
                this.host = props.getProperty("host");
                this.dbDomain = props.getProperty("db_domain");
                this.chunk = props.getProperty("chunk");
                this.newChunk = props.getProperty("newchunk");
                this.hashBoundary = props.getProperty("hash");
                this.priority = Integer.parseInt(props.getProperty("priority", "0"));
                this.status = Event.Status.parse(props.getProperty("status", "down"));
                if (this.status == Event.Status.SPLIT) {
                    if (null == this.newChunk) {
                        throw new IllegalArgumentException("wrong chunk split notification format, New Chunk name is NULL");
                    }
                    if (this.event_type.equals("chunk") && (null == this.version || null == this.chunk || null == this.database || null == this.instance)) {
                        throw new IllegalArgumentException("Wrong chunk event format");
                    }
                    if (!this.event_type.equals("chunk")) {
                        throw new IllegalArgumentException("Wrong chunk event type");
                    }
                }
                String ts = props.getProperty("timestamp", "");
                String tz = props.getProperty("timezone", "");
                if ("".equals(ts) && !"".equals(tz)) {
                    throw new IllegalStateException("single timezone (without timestamp) is not allowed");
                }
                if ("".equals(ts)) {
                    this.timestamp = new Date();
                } else {
                    try {
                        this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(ts + " GMT" + tz);
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }

            @DisableTrace
            public String toString() {
                return ", version=" + this.version() + ", chunk=" + this.chunkName() + ", event_type=" + this.eventType() + ", db_domain=" + this.dbDomain() + ", instance=" + this.instanceName() + ", host=" + this.host() + ", database=" + this.database() + ", status=" + (Object)((Object)this.status()) + ", priority=" + this.priority() + ", newchunk=" + this.newChunkName() + ", hash split boundary=" + this.hashSplitBoundary() + ", timestamp=" + this.timeStamp();
            }

            @Override
            @DisableTrace
            public String version() {
                return this.version;
            }

            @Override
            @DisableTrace
            public String chunkName() {
                return this.chunk;
            }

            @Override
            @DisableTrace
            public String database() {
                return this.database;
            }

            @DisableTrace
            public String host() {
                return this.host;
            }

            @Override
            @DisableTrace
            public String hashSplitBoundary() {
                return this.hashBoundary;
            }

            @Override
            @DisableTrace
            public Event.Status status() {
                return this.status;
            }

            @Override
            @DisableTrace
            public int priority() {
                return this.priority;
            }

            @Override
            @DisableTrace
            public String newChunkName() {
                return this.newChunk;
            }

            @Override
            @DisableTrace
            public String eventType() {
                return this.event_type;
            }

            @Override
            @DisableTrace
            public String instanceName() {
                return this.instance;
            }

            @Override
            @DisableTrace
            public String dbDomain() {
                return this.dbDomain;
            }

            @Override
            public Date timeStamp() {
                return this.timestamp;
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(ChunkEventHandler.class, Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("timeStamp", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public void stop() {
        Task t = this.task.getAndSet(null);
        if (null != t) {
            block4: {
                t.release();
                this.terminate.set(true);
                try {
                    TaskHandle th = this.taskHandle.getAndSet(null);
                    if (null != th) {
                        th.get(100000L);
                    }
                }
                catch (TaskManagerException e) {
                    if (e.getCause() instanceof CancellationException) break block4;
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }
            ClioSupport.ilogFinest(null, null, null, null, "stopped");
        }
    }

    protected abstract void onEvent(Event var1);

    static {
        try {
            $$$methodRef$$$9 = ChunkEventHandler.class.getDeclaredConstructor(TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = ChunkEventHandler.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = ChunkEventHandler.class.getDeclaredMethod("access$202", ChunkEventHandler.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = ChunkEventHandler.class.getDeclaredMethod("access$100", ChunkEventHandler.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = ChunkEventHandler.class.getDeclaredMethod("access$000", ChunkEventHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = ChunkEventHandler.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = ChunkEventHandler.class.getDeclaredMethod("parseNotification", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = ChunkEventHandler.class.getDeclaredMethod("outOfOrder", Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = ChunkEventHandler.class.getDeclaredMethod("prepareTask", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = ChunkEventHandler.class.getDeclaredMethod("start", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        eventAttrFmt = Pattern.compile("(version|event_type|chunk|instance|database|db_domain|newchunk|priority|hash|host|status)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
        tsFmt = Pattern.compile("(timestamp)=\\s*(\\S+\\s\\S+)");
        tzFmt = Pattern.compile("(timezone)=(.*)");
        tsStrFmt = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}");
        tzStrFmt = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
    }

    public static interface Event {
        public String version();

        public String eventType();

        public String chunkName();

        public String instanceName();

        public String database();

        public String dbDomain();

        public Status status();

        public String newChunkName();

        public String hashSplitBoundary();

        public Date timeStamp();

        public int priority();

        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status DOWN;
            public static final /* enum */ Status UP;
            public static final /* enum */ Status SPLIT;
            public static final /* enum */ Status READONLY;
            private static final /* synthetic */ Status[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String name) {
                return Enum.valueOf(Status.class, name);
            }

            static Status parse(String status) {
                for (Status s : Status.values()) {
                    if (!s.toString().toLowerCase().equals(status)) continue;
                    return s;
                }
                throw new IllegalStateException("unknown status " + status);
            }

            static {
                try {
                    $$$methodRef$$$3 = Status.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Status.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Status.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Status.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                DOWN = new Status();
                UP = new Status();
                SPLIT = new Status();
                READONLY = new Status();
                $VALUES = new Status[]{DOWN, UP, SPLIT, READONLY};
            }
        }
    }
}

