## NOTICE

This is the new home of "pyexploitdb".

##

pyexploitdb (https://shanewilliamscott.com)
==
[![Python package](https://github.com/Hackman238/pyExploitDb/actions/workflows/master.yml/badge.svg)](https://github.com/Hackman238/pyExploitDb/actions/workflows/master.yml)
[![Known Vulnerabilities](https://snyk.io/test/github/Hackman238/pyExploitDb/badge.svg?targetFile=requirements.txt)](https://snyk.io/test/github/Hackman238/pyExploitDb?targetFile=requirements.txt)


## Authors:
Shane William Scott

## About pyexploitdb
pyexploitdb builds and maintains local CVE↔EDB indexes from the official exploit-db repository with a focus on resilience and observability.

### Highlights
- Validates on-disk caches and normalises mappings to keep indexes trustworthy.
- Rebuilds quickly by parsing `files_exploits.csv` first and only scraping missing CVEs with bounded concurrency.
- Ships with a practical smoke-test suite (`python -m tests.smoke_test`) so releases can be verified before publishing.

## Upcoming features
> CPE database, indexes and mappings

## Installation
pip install pyexploitdb
> Note: This assumes pip is for your python3 environment. Use pip3 if pip is for your python2 environment.

## Example Usage
```python
from pyexploitdb import PyExploitDb
exploit_db = PyExploitDb()
exploit_db.debug = False
exploit_db.open_file()
results = exploit_db.search_cve("CVE-2018-14592")
for exploit in results:
    print(f"{exploit['id']} -> {exploit['file']}")
```

`search_cve` returns a list of dictionaries (one per matching exploit). The library raises `pyexploitdb.PyExploitDbError` when required data is missing or network/git operations fail after retrying.

To rebuild the CVE caches from scratch without hammering exploit-db, metadata is extracted from `files_exploits.csv` first and any missing CVEs fall back to concurrent (throttled) scraping:

```python
from pyexploitdb import PyExploitDb

with PyExploitDb() as exploit_db:
    exploit_db.update_db(workers=6)  # adjust workers to control parallel HTTP fetches
```

## Tests
Run the practical smoke tests before publishing to PyPI:

```
python -m tests.smoke_test
```

## Example debug/verbose output
CVE-2018-1459
Found
Exploit DB Id: 45447
File: ./exploit-database/exploits/php/webapps/45447.txt
Date: 2018-09-24
Author: Haboob Team
Platform: webapps
Type: php
Port: 80
{'edbid': '45447', 'exploit': './exploit-database/exploits/php/webapps/45447.txt', 'date': '2018-09-24', 'author': 'Haboob Team', 'platform': 'webapps', 'type': 'php', 'port': '80'}

## Credits
Based on fork from https://github.com/GoVanguard/pyExploitDb by Shane Scott.
Originally based on fork of cve_searchsploit by Andrea Fioraldi.
