# -*- coding: binary -*-

module Msf
  module Exploit::Remote::HTTP::Spip
    include Msf::Exploit::Remote::HttpClient

    def initialize(info = {})
      super

      register_options([
        OptString.new('TARGETURI', [true, 'Path to Spip install', '/'])
      ])
    end

    # Determine Spip version
    #
    # @return [Rex::Version] Version as Rex::Version
    def spip_version
      res = send_request_cgi(
        'method' => 'GET',
        'uri' => normalize_uri(target_uri.path, 'spip.php')
      )

      return unless res

      version = nil

      potential_sources = [
        res.get_html_document.at('head/meta[@name="generator"]/@content')&.text,
        res.headers['Composed-By']
      ]

      potential_sources.each do |text|
        next unless text

        if text =~ /SPIP\s(\d+(\.\d+)+)/
          version = ::Regexp.last_match(1)
          break
        end
      end

      return version ? Rex::Version.new(version) : nil
    end

    # Determine Spip plugin version by name
    #
    # @param [String] plugin_name Name of the plugin to search for
    # @return [Rex::Version, nil] Version of the plugin as Rex::Version, or nil if not found
    def spip_plugin_version(plugin_name)
      res = send_request_cgi('method' => 'GET', 'uri' => normalize_uri(target_uri.path, 'spip.php'))
      return unless res

      composed_by = res.headers['Composed-By']
      # Case 1: Check if 'Composed-By' header is present and not empty
      version = composed_by&.present? ? parse_plugin_version(composed_by, plugin_name) : nil
      return version if version

      # Case 2: Extract URL from 'Composed-By' header and send a request to fetch the config.txt file
      config_url = composed_by =~ %r{(https?://[^\s]+/local/config\.txt)}i ? ::Regexp.last_match(1) : normalize_uri(target_uri.path, 'local', 'config.txt')
      config_res = send_request_cgi('method' => 'GET', 'uri' => config_url)
      return parse_plugin_version(config_res.body, plugin_name) if config_res&.code == 200

      nil
    end

    # Parse the plugin version from config.txt or composed-by
    #
    # @param [String] body The body content to parse
    # @param [String] plugin_name Name of the plugin to find the version for
    # @return [Rex::Version, nil] Version of the plugin as Rex::Version, or nil if not found
    def parse_plugin_version(body, plugin_name)
      body.each_line do |line|
        if line =~ /#{plugin_name}\((\d+(\.\d+)+)\)/
          return Rex::Version.new(::Regexp.last_match(1))
        end
      end
      nil
    end
  end
end
