/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.Run;
import com.google.caliper.runner.CaliperRc;
import com.google.caliper.runner.ResultProcessor;
import com.google.caliper.util.Util;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.annotation.Nullable;

final class WebappUploader
implements ResultProcessor {
    @Nullable
    private final String postUrl;
    @Nullable
    private final String apiKey;
    private final String benchmarkName;
    private final Proxy proxy;

    private WebappUploader(@Nullable String postUrl, @Nullable String apiKey, String benchmarkName, Proxy proxy) {
        this.postUrl = postUrl;
        this.apiKey = apiKey;
        this.benchmarkName = (String)Preconditions.checkNotNull((Object)benchmarkName);
        this.proxy = (Proxy)Preconditions.checkNotNull((Object)proxy);
    }

    public static WebappUploader create(String benchmarkName, CaliperRc rc) {
        String postUrl = rc.getProperty("results.upload.url");
        String apiKey = rc.getProperty("results.upload.key");
        return new WebappUploader(postUrl, apiKey, benchmarkName, WebappUploader.getProxy(rc));
    }

    private static Proxy getProxy(CaliperRc rc) {
        Proxy proxy;
        String proxyAddress = rc.getProperty("results.upload.proxy");
        if (proxyAddress == null || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)proxyAddress)) {
            proxy = Proxy.NO_PROXY;
        } else {
            String[] proxyHostAndPort = proxyAddress.trim().split(":");
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostAndPort[0], Integer.parseInt(proxyHostAndPort[1])));
        }
        return proxy;
    }

    @Override
    public void handleResults(Run results) {
        if (this.postUrl == null || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)this.postUrl) || this.apiKey == null || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)this.apiKey)) {
            System.out.println("To upload results to the Caliper web application, specify your Caliper API key\nin your caliper configuration file (typically ~/.caliperrc)");
        } else {
            String jsonResults = Util.GSON.toJson((Object)results);
            this.uploadResults(jsonResults);
        }
    }

    private void uploadResults(String json) {
        try {
            URL url = new URL(this.postUrl + this.apiKey + "/" + this.benchmarkName);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(this.proxy);
            urlConnection.setDoOutput(true);
            urlConnection.getOutputStream().write(json.getBytes(Charsets.UTF_8));
            if (urlConnection.getResponseCode() == 200) {
                System.out.println("");
                System.out.println("View current and previous benchmark results online:");
            } else {
                System.out.println("Posting to " + this.postUrl + " failed: " + urlConnection.getResponseMessage());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            System.out.println("  " + in.readLine());
            in.close();
        }
        catch (IOException e) {
            System.out.println("Posting to " + this.postUrl + " failed: " + e);
        }
    }
}

