/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1;

import com.sun.electric.tool.placement.PlacementFrame;
import java.util.logging.Level;

public class Chromosome
implements Comparable<Chromosome> {
    static final Level LOG_LEVEL = Level.FINEST;
    public boolean altered;
    public Double fitness;
    static final boolean DEBUG = false;
    public int[] Index2GenePositionInChromosome;
    public int[] GeneXPos;
    public int[] GeneYPos;
    public short[] GeneRotation;
    public short[] GeneYPadding;
    public short[] GeneXPadding;

    public Chromosome() {
    }

    public Chromosome(int nbrOfGenes) {
        this.altered = true;
        this.GeneXPos = new int[nbrOfGenes];
        this.GeneYPos = new int[nbrOfGenes];
        this.GeneRotation = new short[nbrOfGenes];
        this.GeneYPadding = new short[nbrOfGenes];
        this.GeneXPadding = new short[nbrOfGenes];
        this.Index2GenePositionInChromosome = new int[nbrOfGenes];
        this.fitness = Double.MAX_VALUE;
    }

    public void rotate(int angle, int geneIndex) {
        this.GeneRotation[geneIndex] = (short)((this.GeneRotation[geneIndex] + angle) % 3600);
        this.altered = true;
    }

    public int size() {
        return this.Index2GenePositionInChromosome.length;
    }

    @Override
    public int compareTo(Chromosome o) {
        return this.fitness.compareTo(o.fitness);
    }

    public Chromosome clone() {
        Chromosome newChromosome = new Chromosome(this.GeneXPos.length);
        newChromosome.fitness = this.fitness;
        newChromosome.Index2GenePositionInChromosome = (int[])this.Index2GenePositionInChromosome.clone();
        assert (newChromosome.isIndex2GenePosValid());
        newChromosome.GeneRotation = (short[])this.GeneRotation.clone();
        newChromosome.GeneXPos = (int[])this.GeneXPos.clone();
        newChromosome.GeneYPos = (int[])this.GeneYPos.clone();
        newChromosome.GeneXPadding = (short[])this.GeneXPadding.clone();
        newChromosome.GeneYPadding = (short[])this.GeneYPadding.clone();
        assert (newChromosome.altered);
        return newChromosome;
    }

    public double getPortXOffset(PlacementFrame.PlacementPort port, int geneIndex) {
        switch (this.GeneRotation[geneIndex]) {
            case 0: {
                return port.getOffX();
            }
            case 900: {
                return -port.getOffY();
            }
            case 1800: {
                return -port.getOffX();
            }
            case 2700: {
                return port.getOffY();
            }
        }
        System.err.println(this.getClass().getName() + " unsupported rotation angle: " + this.GeneRotation[geneIndex]);
        return -1.0;
    }

    public double getPortYOffset(PlacementFrame.PlacementPort port, int geneIndex) {
        switch (this.GeneRotation[geneIndex]) {
            case 0: {
                return port.getOffY();
            }
            case 900: {
                return port.getOffX();
            }
            case 1800: {
                return -port.getOffY();
            }
            case 2700: {
                return -port.getOffX();
            }
        }
        System.err.println(this.getClass().getName() + " unsupported rotation angle: " + this.GeneRotation[geneIndex]);
        return -1.0;
    }

    public boolean isIndex2GenePosValid() {
        for (int i = 0; i < this.Index2GenePositionInChromosome.length; ++i) {
            int matchCount = 0;
            for (int z = 0; z < this.Index2GenePositionInChromosome.length; ++z) {
                if (this.Index2GenePositionInChromosome[z] != i) continue;
                ++matchCount;
            }
            if (matchCount == true) continue;
            return false;
        }
        return true;
    }
}

