// Source: https://github.com/atlassian/react-beautiful-dnd

import getDistanceThresholds from './get-distance-thresholds';
import getValue from './get-value';
export default (function (_ref) {
  var container = _ref.container,
    distanceToEdges = _ref.distanceToEdges,
    dragStartTime = _ref.dragStartTime,
    axis = _ref.axis,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  var thresholds = getDistanceThresholds(container, axis);
  var isCloserToEnd = distanceToEdges[axis.end] < distanceToEdges[axis.start];
  if (isCloserToEnd) {
    return getValue({
      distanceToEdge: distanceToEdges[axis.end],
      thresholds: thresholds,
      dragStartTime: dragStartTime,
      shouldUseTimeDampening: shouldUseTimeDampening
    });
  }
  return -1 * getValue({
    distanceToEdge: distanceToEdges[axis.start],
    thresholds: thresholds,
    dragStartTime: dragStartTime,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
});