/*
 * This software is supplied by Renesas Electronics Corporation and is only intended for
 * use with Renesas products. No other uses are authorized. This software is owned by
 * Renesas Electronics Corporation and is protected under all applicable laws, including
 * copyright laws.
 *
 * THIS SOFTWARE IS PROVIDED 'AS IS' AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM EXTENT PERMITTED NOT
 * PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED
 * COMPANIES SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Renesas reserves the right, without notice, to make changes to this software and to
 * discontinue the availability of this software. By using this software, you agree to
 * the additional terms and conditions found by accessing the following link:
 * http://www.renesas.com/disclaimer
 *
 *
 * @file     ./out/R7FA2E2A7.h
 * @brief    CMSIS HeaderFile
 * @version  1.00.00
 */

/** @addtogroup Renesas Electronics Corporation
 * @{
 */

/** @addtogroup R7FA2E2A7
 * @{
 */

#ifndef R7FA2E2A7_H
 #define R7FA2E2A7_H

 #ifdef __cplusplus
extern "C" {
 #endif

/** @addtogroup Configuration_of_CMSIS
 * @{
 */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M23 Processor and Core Peripherals  =========================== */
 #define __CM23_REV                0x0100U /*!< CM23 Core Revision                                                        */
 #define __NVIC_PRIO_BITS          2       /*!< Number of Bits used for Priority Levels                                   */
 #define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used                              */
 #define __VTOR_PRESENT            1       /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
 #define __MPU_PRESENT             1       /*!< MPU present                                                               */
 #define __FPU_PRESENT             0       /*!< FPU present                                                               */
 #define __SAUREGION_PRESENT       0       /*!< SAU region present                                                        */

/** @} */ /* End of group Configuration_of_CMSIS */

 #include "core_cm23.h"                    /*!< ARM Cortex-M23 processor and core peripherals                             */
 #include "system.h"                       /*!< R7FA2E2A7 System                                                          */

 #ifndef __IM                              /*!< Fallback for older CMSIS versions                                         */
  #define __IM     __I
 #endif
 #ifndef __OM                              /*!< Fallback for older CMSIS versions                                         */
  #define __OM     __O
 #endif
 #ifndef __IOM                             /*!< Fallback for older CMSIS versions                                         */
  #define __IOM    __IO
 #endif

/* ========================================  Start of section using anonymous unions  ======================================== */
 #if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
 #elif defined(__ICCARM__)
  #pragma language=extended
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning 586
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #else
  #warning Not supported compiler type
 #endif

/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
 * @{
 */

/**
 * @brief R_BUS_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_CSa_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_CSb_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_SDRAM [SDRAM] (SDRAM Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t SDCCR;           /*!< (@ 0x00000000) SDC Control Register                                       */

        struct
        {
            __IOM uint8_t EXENB : 1;   /*!< [0..0] Operation Enable                                                   */
            uint8_t             : 3;
            __IOM uint8_t BSIZE : 2;   /*!< [5..4] SDRAM Bus Width Select                                             */
            uint8_t             : 2;
        } SDCCR_b;
    };

    union
    {
        __IOM uint8_t SDCMOD;          /*!< (@ 0x00000001) SDC Mode Register                                          */

        struct
        {
            __IOM uint8_t EMODE : 1;   /*!< [0..0] Endian Mode                                                        */
            uint8_t             : 7;
        } SDCMOD_b;
    };

    union
    {
        __IOM uint8_t SDAMOD;          /*!< (@ 0x00000002) SDRAM Access Mode Register                                 */

        struct
        {
            __IOM uint8_t BE : 1;      /*!< [0..0] Continuous Access Enable                                           */
            uint8_t          : 7;
        } SDAMOD_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint8_t SDSELF;          /*!< (@ 0x00000010) SDRAM Self-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t SFEN : 1;    /*!< [0..0] SDRAM Self-Refresh Enable                                          */
            uint8_t            : 7;
        } SDSELF_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t SDRFCR;         /*!< (@ 0x00000014) SDRAM Refresh Control Register                             */

        struct
        {
            __IOM uint16_t RFC  : 12;  /*!< [11..0] Auto-Refresh Request Interval Setting                             */
            __IOM uint16_t REFW : 4;   /*!< [15..12] Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count
                                        *   Setting. ( REFW+1 Cycles )                                                */
        } SDRFCR_b;
    };

    union
    {
        __IOM uint8_t SDRFEN;          /*!< (@ 0x00000016) SDRAM Auto-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t RFEN : 1;    /*!< [0..0] Auto-Refresh Operation Enable                                      */
            uint8_t            : 7;
        } SDRFEN_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint8_t SDICR;           /*!< (@ 0x00000020) SDRAM Initialization Sequence Control Register             */

        struct
        {
            __IOM uint8_t INIRQ : 1;   /*!< [0..0] Initialization Sequence Start                                      */
            uint8_t             : 7;
        } SDICR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t SDIR;           /*!< (@ 0x00000024) SDRAM Initialization Register                              */

        struct
        {
            __IOM uint16_t ARFI : 4;   /*!< [3..0] Initialization Auto-Refresh Interval ( PRF+3 cycles )              */
            __IOM uint16_t ARFC : 4;   /*!< [7..4] Initialization Auto-Refresh Count                                  */
            __IOM uint16_t PRC  : 3;   /*!< [10..8] Initialization Precharge Cycle Count ( PRF+3 cycles
                                        *   )                                                                         */
            uint16_t : 5;
        } SDIR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[6];

    union
    {
        __IOM uint8_t SDADR;           /*!< (@ 0x00000040) SDRAM Address Register                                     */

        struct
        {
            __IOM uint8_t MXC : 2;     /*!< [1..0] Address Multiplex Select                                           */
            uint8_t           : 6;
        } SDADR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint32_t SDTR;           /*!< (@ 0x00000044) SDRAM Timing Register                                      */

        struct
        {
            __IOM uint32_t CL  : 3;    /*!< [2..0] SDRAMC Column Latency                                              */
            uint32_t           : 5;
            __IOM uint32_t WR  : 1;    /*!< [8..8] Write Recovery Interval                                            */
            __IOM uint32_t RP  : 3;    /*!< [11..9] Row Precharge Interval ( RP+1 cycles )                            */
            __IOM uint32_t RCD : 2;    /*!< [13..12] Row Column Latency ( RCD+1 cycles )                              */
            uint32_t           : 2;
            __IOM uint32_t RAS : 3;    /*!< [18..16] Row Active Interval                                              */
            uint32_t           : 13;
        } SDTR_b;
    };

    union
    {
        __IOM uint16_t SDMOD;          /*!< (@ 0x00000048) SDRAM Mode Register                                        */

        struct
        {
            __IOM uint16_t MR : 15;    /*!< [14..0] Mode Register SettingWriting to these bits: Mode register
                                        *   set command is issued.                                                    */
            uint16_t : 1;
        } SDMOD_b;
    };
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IM uint8_t SDSR;             /*!< (@ 0x00000050) SDRAM Status Register                                      */

        struct
        {
            __IM uint8_t MRSST : 1;    /*!< [0..0] Mode Register Setting Status                                       */
            uint8_t            : 2;
            __IM uint8_t INIST : 1;    /*!< [3..3] Initialization Status                                              */
            __IM uint8_t SRFST : 1;    /*!< [4..4] Self-Refresh Transition/Recovery Status                            */
            uint8_t            : 3;
        } SDSR_b;
    };
    __IM uint8_t  RESERVED14;
    __IM uint16_t RESERVED15;
} R_BUS_SDRAM_Type;                    /*!< Size = 84 (0x54)                                                          */

/**
 * @brief R_BUS_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t STAT;             /*!< (@ 0x00000004) Bus Error Status Register                                  */

        struct
        {
            __IM uint8_t ACCSTAT : 1;  /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t              : 6;
            __IM uint8_t ERRSTAT : 1;  /*!< [7..7] Bus Error StatusWhen bus error assert, error flag occurs.          */
        } STAT_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BUSERR_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BUSM [BUSM] (Master Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Master Bus Control Register                                */

        struct
        {
            uint16_t             : 15;
            __IOM uint16_t IERES : 1;  /*!< [15..15] Ignore Error Responses                                           */
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSM_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_BUS_BUSS [BUSS] (Slave Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Slave Bus Control Register                                 */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t ARBMET : 2; /*!< [5..4] Arbitration MethodSpecify the priority between groups              */
            uint16_t              : 10;
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSS_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_ELC_ELSEGR [ELSEGR] (Event Link Software Event Generation Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t BY;              /*!< (@ 0x00000000) Event Link Software Event Generation Register              */

        struct
        {
            __OM uint8_t SEG : 1;      /*!< [0..0] Software Event Generation                                          */
            uint8_t          : 5;
            __IOM uint8_t WE : 1;      /*!< [6..6] SEG Bit Write Enable                                               */
            __OM uint8_t  WI : 1;      /*!< [7..7] ELSEGR Register Write Disable                                      */
        } BY_b;
    };
    __IM uint8_t RESERVED;
} R_ELC_ELSEGR_Type;                   /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_ELC_ELSR [ELSR] (Event Link Setting Register [0..22])
 */
typedef struct
{
    union
    {
        __IOM uint16_t HA;             /*!< (@ 0x00000000) Event Link Setting Register                                */

        struct
        {
            __IOM uint16_t ELS : 9;    /*!< [8..0] Event Link Select                                                  */
            uint16_t           : 7;
        } HA_b;
    };
    __IM uint16_t RESERVED;
} R_ELC_ELSR_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_IIC0_SAR [SAR] (Slave Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t L;               /*!< (@ 0x00000000) Slave Address Register L                                   */

        struct
        {
            __IOM uint8_t SVA : 8;     /*!< [7..0] A slave address is set.7-Bit Address = SVA[7:1] 10-Bit
                                        *   Address = { SVA9,SVA8,SVA[7:0] }                                          */
        } L_b;
    };

    union
    {
        __IOM uint8_t U;               /*!< (@ 0x00000001) Slave Address Register U                                   */

        struct
        {
            __IOM uint8_t FS   : 1;    /*!< [0..0] 7-Bit/10-Bit Address Format Selection                              */
            __IOM uint8_t SVA8 : 1;    /*!< [1..1] 10-Bit Address(bit8)                                               */
            __IOM uint8_t SVA9 : 1;    /*!< [2..2] 10-Bit Address(bit9)                                               */
            uint8_t            : 5;
        } U_b;
    };
} R_IIC0_SAR_Type;                     /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_MPU_MMPU_MMPU_REGION [REGION] (Address Region registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t C;              /*!< (@ 0x00000000) Access Control Register                                    */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Region enable                                                      */
            __IOM uint16_t RP     : 1; /*!< [1..1] Read protection                                                    */
            __IOM uint16_t WP     : 1; /*!< [2..2] Write protection                                                   */
            uint16_t              : 13;
        } C_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t S;                /*!< (@ 0x00000004) Start Address Register                                     */

        struct
        {
            __IOM uint32_t MMPUSmn : 32; /*!< [31..0] Address where the region starts, for use in region determination.NOTE:
                                          *   The low-order 2 bits are fixed to 0.                                      */
        } S_b;
    };

    union
    {
        __IOM uint32_t E;                /*!< (@ 0x00000008) End Address Register                                       */

        struct
        {
            __IOM uint32_t MMPUEmn : 32; /*!< [31..0] Region end address registerAddress where the region
                                          *   end, for use in region determination.NOTE: The low-order
                                          *   2 bits are fixed to 1.                                                    */
        } E_b;
    };
    __IM uint32_t RESERVED1;
} R_MPU_MMPU_MMPU_REGION_Type;           /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU [MMPU] (Bus Master MPU Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000000) Bus Master MPU Control Register                            */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t OAD    : 1; /*!< [1..1] Operation after detection                                          */
            uint16_t              : 6;
            __OM uint16_t KEY     : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } CTL_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[63];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t PT;                        /*!< (@ 0x00000102) Protection of Register                                     */

        struct
        {
            __IOM uint16_t PROTECT : 1;           /*!< [0..0] Protection of region register                                      */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8;           /*!< [15..8] Write Keyword The data written to these bits are not
                                                   *   stored.                                                                   */
        } PT_b;
    };
    __IM uint32_t RESERVED3[63];
    __IOM R_MPU_MMPU_MMPU_REGION_Type REGION[32]; /*!< (@ 0x00000200) Address Region registers                                   */
} R_MPU_MMPU_MMPU_Type;                           /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_MPU_SMPU_SMPU [SMPU] (Access Control Structure for MBIU)
 */
typedef struct
{
    union
    {
        __IOM uint16_t R;              /*!< (@ 0x00000000) Access Control Register for MBIU                           */

        struct
        {
            uint16_t              : 2;
            __IOM uint16_t RPGRPA : 1;   /*!< [2..2] Master Group A Read protection                                     */
            __IOM uint16_t WPGRPA : 1;   /*!< [3..3] Master Group A Write protection                                    */
            __IOM uint16_t RPGRPB : 1;   /*!< [4..4] Master Group B Read protection                                     */
            __IOM uint16_t WPGRPB : 1;   /*!< [5..5] Master Group B Write protection                                    */
            __IOM uint16_t RPGRPC : 1;   /*!< [6..6] Master Group C Read protection                                     */
            __IOM uint16_t WPGRPC : 1;   /*!< [7..7] Master Group C Write protection                                    */
            uint16_t              : 4;
            __IOM uint16_t RPFLI  : 1;   /*!< [12..12] Code Flash Memory Read Protection                                */
            __IOM uint16_t WPFLI  : 1;   /*!< [13..13] Code Flash Memory Write Protection (Note: This bit
                                          *   is read as 1. The write value should be 1.)                               */
            __IOM uint16_t RPSRAMHS : 1; /*!< [14..14] SRAMHS Read Protection                                           */
            __IOM uint16_t WPSRAMHS : 1; /*!< [15..15] SRAMHS Write Protection                                          */
        } R_b;
    };
    __IM uint16_t RESERVED;
} R_MPU_SMPU_SMPU_Type;                  /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_MPU_SPMON_SP [SP] (Stack Pointer Monitor)
 */
typedef struct
{
    union
    {
        __IOM uint16_t OAD;            /*!< (@ 0x00000000) Stack Pointer Monitor Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } OAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000004) Stack Pointer Monitor Access Control Register              */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Stack Pointer Monitor Enable                                       */
            uint16_t              : 7;
            __IOM uint16_t ERROR  : 1; /*!< [8..8] Stack Pointer Monitor Error Flag                                   */
            uint16_t              : 7;
        } CTL_b;
    };

    union
    {
        __IOM uint16_t PT;              /*!< (@ 0x00000006) Stack Pointer Monitor Protection Register                  */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register (MSPMPUAC, MSPMPUSA and MSPMPUSE)           */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                         *   stored.                                                                   */
        } PT_b;
    };

    union
    {
        __IOM uint32_t SA;                /*!< (@ 0x00000008) Stack Pointer Monitor Start Address Register               */

        struct
        {
            __IOM uint32_t MSPMPUSA : 32; /*!< [31..0] Region start address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFF
                                           *   The low-order 2 bits are fixed to 0.                                      */
        } SA_b;
    };

    union
    {
        __IOM uint32_t EA;                /*!< (@ 0x0000000C) Stack Pointer Monitor End Address Register                 */

        struct
        {
            __IOM uint32_t MSPMPUEA : 32; /*!< [31..0] Region end address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFF
                                           *   The low-order 2 bits are fixed to 1.                                      */
        } EA_b;
    };
} R_MPU_SPMON_SP_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_PFS_PORT_PIN [PIN] (Pin Function Selects)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t PmnPFS;        /*!< (@ 0x00000000) Pin Function Control Register                              */

            struct
            {
                __IOM uint32_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                __IM uint32_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                __IOM uint32_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                uint32_t             : 1;
                __IOM uint32_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                __IOM uint32_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                __IOM uint32_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                uint32_t             : 3;
                __IOM uint32_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                __IOM uint32_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                __IOM uint32_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                __IOM uint32_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                __IOM uint32_t PMR   : 1; /*!< [16..16] Port Mode Control                                                */
                uint32_t             : 7;
                __IOM uint32_t PSEL  : 5; /*!< [28..24] Port Function SelectThese bits select the peripheral
                                           *   function. For individual pin functions, see the MPC table                 */
                uint32_t : 3;
            } PmnPFS_b;
        };

        struct
        {
            union
            {
                struct
                {
                    __IM uint16_t RESERVED;

                    union
                    {
                        __IOM uint16_t PmnPFS_HA;     /*!< (@ 0x00000002) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint16_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint16_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint16_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint16_t             : 1;
                            __IOM uint16_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint16_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint16_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint16_t             : 3;
                            __IOM uint16_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                            __IOM uint16_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                            __IOM uint16_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                            __IOM uint16_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                        } PmnPFS_HA_b;
                    };
                };

                struct
                {
                    __IM uint16_t RESERVED1;
                    __IM uint8_t  RESERVED2;

                    union
                    {
                        __IOM uint8_t PmnPFS_BY;     /*!< (@ 0x00000003) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint8_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint8_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint8_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint8_t             : 1;
                            __IOM uint8_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint8_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint8_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint8_t             : 1;
                        } PmnPFS_BY_b;
                    };
                };
            };
        };
    };
} R_PFS_PORT_PIN_Type;                 /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_PFS_PORT [PORT] (Port [0..14])
 */
typedef struct
{
    __IOM R_PFS_PORT_PIN_Type PIN[16]; /*!< (@ 0x00000000) Pin Function Selects                                       */
} R_PFS_PORT_Type;                     /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_PFS_VLSEL [VLSEL] (VLSEL)
 */
typedef struct
{
    __IM uint8_t RESERVED[389];

    union
    {
        __IOM uint8_t VL1SEL;          /*!< (@ 0x00000185) VL1 Select Control Register                                */

        struct
        {
            __IOM uint8_t SELVL : 1;   /*!< [0..0] VL1 Voltage Connection Switching Control                           */
            uint8_t             : 7;
        } VL1SEL_b;
    };
} R_PFS_VLSEL_Type;                    /*!< Size = 390 (0x186)                                                        */

/**
 * @brief R_PMISC_PMSAR [PMSAR] (Port Security Attribution Register)
 */
typedef struct
{
    __IOM uint16_t PMSAR;              /*!< (@ 0x00000000) Port Security Attribution Register                         */
} R_PMISC_PMSAR_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_AGTX0_AGT16_CTRL [CTRL] (CTRL)
 */
typedef struct
{
    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x00000000) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x00000001) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x00000002) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL_ALT;    /*!< (@ 0x00000003) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_ALT_b;
    };

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x00000004) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x00000005) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x00000006) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x00000007) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };
} R_AGTX0_AGT16_CTRL_Type;             /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_AGTX0_AGT16 [AGT16] (AGT (16-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint16_t AGT : 16;   /*!< [15..0] 16bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint16_t AGTCMA;          /*!< (@ 0x00000002) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint16_t AGTCMA : 16; /*!< [15..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint16_t AGTCMB;          /*!< (@ 0x00000004) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint16_t AGTCMB : 16; /*!< [15..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IM uint16_t                 RESERVED;
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x00000008) CTRL                                                       */
} R_AGTX0_AGT16_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_AGTX0_AGT32 [AGT32] (AGTW (32-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t AGT;            /*!< (@ 0x00000000) AGT 32-bit Counter Register                                */

        struct
        {
            __IOM uint32_t AGT : 32;   /*!< [31..0] 32bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint32_t AGTCMA;          /*!< (@ 0x00000004) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint32_t AGTCMA : 32; /*!< [31..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint32_t AGTCMB;          /*!< (@ 0x00000008) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint32_t AGTCMB : 32; /*!< [31..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x0000000C) CTRL                                                       */
} R_AGTX0_AGT32_Type;                   /*!< Size = 20 (0x14)                                                          */

/** @} */ /* End of group Device_Peripheral_clusters */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief A/D Converter (R_ADC0)
 */

typedef struct                         /*!< (@ 0x4005C000) R_ADC0 Structure                                           */
{
    union
    {
        __IOM uint16_t ADCSR;          /*!< (@ 0x00000000) A/D Control Register                                       */

        struct
        {
            __IOM uint16_t DBLANS : 5; /*!< [4..0] Double Trigger Channel SelectThese bits select one analog
                                        *   input channel for double triggered operation. The setting
                                        *   is only effective while double trigger mode is selected.                  */
            uint16_t              : 1;
            __IOM uint16_t GBADIE : 1; /*!< [6..6] Group B Scan End Interrupt Enable                                  */
            __IOM uint16_t DBLE   : 1; /*!< [7..7] Double Trigger Mode Select                                         */
            __IOM uint16_t EXTRG  : 1; /*!< [8..8] Trigger Select                                                     */
            __IOM uint16_t TRGE   : 1; /*!< [9..9] Trigger Start Enable                                               */
            __IOM uint16_t ADHSC  : 1; /*!< [10..10] A/D Conversion Operation Mode Select                             */
            uint16_t              : 1;
            __IOM uint16_t ADIE   : 1; /*!< [12..12] Scan End Interrupt Enable                                        */
            __IOM uint16_t ADCS   : 2; /*!< [14..13] Scan Mode Select                                                 */
            __IOM uint16_t ADST   : 1; /*!< [15..15] A/D Conversion Start                                             */
        } ADCSR_b;
    };

    union
    {
        __IOM uint8_t ADREF;           /*!< (@ 0x00000002) A/D status register                                        */

        struct
        {
            __IOM uint8_t ADF : 1;     /*!< [0..0] Scanning end flag bitThis bit is a status bit that becomes
                                        *   '1' while scanning.                                                       */
            uint8_t              : 6;
            __IM uint8_t ADSCACT : 1;  /*!< [7..7] Scanning status bit                                                */
        } ADREF_b;
    };

    union
    {
        __IOM uint8_t ADEXREF;         /*!< (@ 0x00000003) A/D enhancing status register                              */

        struct
        {
            __IOM uint8_t GBADF : 1;   /*!< [0..0] Group B scanning end flag bit.                                     */
            uint8_t             : 7;
        } ADEXREF_b;
    };

    union
    {
        __IOM uint16_t ADANSA[2];      /*!< (@ 0x00000004) A/D Channel Select Register                                */

        struct
        {
            __IOM uint16_t ANSA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSA_b[2];
    };

    union
    {
        __IOM uint16_t ADADS[2];       /*!< (@ 0x00000008) A/D-Converted Value Addition/Average Channel
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint16_t ADS0  : 1;  /*!< [0..0] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS1  : 1;  /*!< [1..1] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS2  : 1;  /*!< [2..2] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS3  : 1;  /*!< [3..3] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS4  : 1;  /*!< [4..4] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS5  : 1;  /*!< [5..5] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS6  : 1;  /*!< [6..6] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS7  : 1;  /*!< [7..7] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS8  : 1;  /*!< [8..8] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS9  : 1;  /*!< [9..9] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS10 : 1;  /*!< [10..10] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS11 : 1;  /*!< [11..11] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS12 : 1;  /*!< [12..12] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS13 : 1;  /*!< [13..13] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS14 : 1;  /*!< [14..14] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS15 : 1;  /*!< [15..15] A/D-Converted Value Addition/Average Channel Select              */
        } ADADS_b[2];
    };

    union
    {
        __IOM uint8_t ADADC;           /*!< (@ 0x0000000C) A/D-Converted Value Addition/Average Count Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t ADC : 3;     /*!< [2..0] Addition frequency selection bit.NOTE: AVEE bit is valid
                                        *   at the only setting of ADC[2:0] bits = 001b or 011b. When
                                        *   average mode is selected by setting the ADADC.AVEE bit
                                        *   to 1, do not set the addition count to three times (ADADC.ADC[2:0]
                                        *   = 010b)                                                                   */
            uint8_t            : 4;
            __IOM uint8_t AVEE : 1;    /*!< [7..7] Average Mode Enable. NOTE:When average mode is deselected
                                        *   by setting the ADADC.AVEE bit to 0, set the addition count
                                        *   to 1, 2, 3, 4 or 16-time conversion. 16-time conversion
                                        *   can only be used with 12-bit accuracy selected. NOTE: AVEE
                                        *   bit is valid at the only setting of ADC[2:0] bits = 001b
                                        *   or 011b. When average mode is selected by setting the ADADC.AVEE
                                        *   bit to 1, do not set the addition count to three times
                                        *   (ADADC.ADC[2:0] = 010b)                                                   */
        } ADADC_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t ADCER;          /*!< (@ 0x0000000E) A/D Control Extended Register                              */

        struct
        {
            uint16_t               : 1;
            __IOM uint16_t ADPRC   : 2; /*!< [2..1] A/D Conversion Accuracy Specify                                    */
            uint16_t               : 1;
            __IOM uint16_t DCE     : 1; /*!< [4..4] Discharge Enable                                                   */
            __IOM uint16_t ACE     : 1; /*!< [5..5] A/D Data Register Automatic Clearing Enable                        */
            uint16_t               : 2;
            __IOM uint16_t DIAGVAL : 2; /*!< [9..8] Self-Diagnosis Conversion Voltage Select                           */
            __IOM uint16_t DIAGLD  : 1; /*!< [10..10] Self-Diagnosis Mode Select                                       */
            __IOM uint16_t DIAGM   : 1; /*!< [11..11] Self-Diagnosis Enable                                            */
            uint16_t               : 2;
            __IOM uint16_t ADINV   : 1; /*!< [14..14] Single-Ended Input A/D Converted Data Inversion Select           */
            __IOM uint16_t ADRFMT  : 1; /*!< [15..15] A/D Data Register Format Select                                  */
        } ADCER_b;
    };

    union
    {
        __IOM uint16_t ADSTRGR;        /*!< (@ 0x00000010) A/D Conversion Start Trigger Select Register               */

        struct
        {
            __IOM uint16_t TRSB : 6;   /*!< [5..0] A/D Conversion Start Trigger Select for Group BSelect
                                        *   the A/D conversion start trigger for group B in group scan
                                        *   mode.                                                                     */
            uint16_t            : 2;
            __IOM uint16_t TRSA : 6;   /*!< [13..8] A/D Conversion Start Trigger SelectSelect the A/D conversion
                                        *   start trigger in single scan mode and continuous mode.
                                        *   In group scan mode, the A/D conversion start trigger for
                                        *   group A is selected.                                                      */
            uint16_t : 2;
        } ADSTRGR_b;
    };

    union
    {
        __IOM uint16_t ADEXICR;        /*!< (@ 0x00000012) A/D Conversion Extended Input Control Register             */

        struct
        {
            __IOM uint16_t TSSAD : 1;  /*!< [0..0] Temperature Sensor Output A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            __IOM uint16_t OCSAD : 1;  /*!< [1..1] Internal Reference Voltage A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            uint16_t            : 6;
            __IOM uint16_t TSSA : 1;   /*!< [8..8] Temperature Sensor Output A/D Conversion Select                    */
            __IOM uint16_t OCSA : 1;   /*!< [9..9] Internal Reference Voltage A/D Conversion Select                   */
            __IOM uint16_t TSSB : 1;   /*!< [10..10] Temperature Sensor Output A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            __IOM uint16_t OCSB : 1;   /*!< [11..11] Internal Reference Voltage A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            uint16_t             : 2;
            __IOM uint16_t EXSEL : 1;  /*!< [14..14] Extended Analog Input Select                                     */
            __IOM uint16_t EXOEN : 1;  /*!< [15..15] Extended Analog Output Control                                   */
        } ADEXICR_b;
    };

    union
    {
        __IOM uint16_t ADANSB[2];      /*!< (@ 0x00000014) A/D Channel Select Register B                              */

        struct
        {
            __IOM uint16_t ANSB0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSB1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSB2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSB3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSB4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSB5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSB6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSB7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSB8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSB9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSB10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSB11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSB12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSB13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSB14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSB15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSB_b[2];
    };

    union
    {
        __IM uint16_t ADDBLDR;          /*!< (@ 0x00000018) A/D Data Duplication Register                              */

        struct
        {
            __IM uint16_t ADDBLDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                         *   result of A/D conversion in response to the second trigger
                                         *   in double trigger mode.                                                   */
        } ADDBLDR_b;
    };

    union
    {
        __IM uint16_t ADTSDR;          /*!< (@ 0x0000001A) A/D Temperature Sensor Data Register                       */

        struct
        {
            __IM uint16_t ADTSDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D conversion result of temperature sensor output.                       */
        } ADTSDR_b;
    };

    union
    {
        __IM uint16_t ADOCDR;          /*!< (@ 0x0000001C) A/D Internal Reference Voltage Data Register               */

        struct
        {
            __IM uint16_t ADOCDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D result of internal reference voltage.                                 */
        } ADOCDR_b;
    };

    union
    {
        union
        {
            __IM uint16_t ADRD_RIGHT;     /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Right Justified           */

            struct
            {
                __IM uint16_t AD : 14;    /*!< [13..0] A/D-converted value (right-justified)The format for
                                           *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
                __IM uint16_t DIAGST : 2; /*!< [15..14] Self-Diagnosis Status                                            */
            } ADRD_RIGHT_b;
        };

        union
        {
            __IM uint16_t ADRD_LEFT;       /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Left Justified            */

            struct
            {
                __IM uint16_t DIAGST : 2;  /*!< [1..0] Self-Diagnosis Status                                              */
                __IM uint16_t AD     : 14; /*!< [15..2] A/D-converted value (right-justified)The format for
                                            *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
            } ADRD_LEFT_b;
        };
    };

    union
    {
        __IM uint16_t ADDR[29];        /*!< (@ 0x00000020) A/D Data Register                                          */

        struct
        {
            __IM uint16_t ADDR : 16;   /*!< [15..0] The ADDR register is a 16-bit read-only registers for
                                        *   storing the result of A/D conversion.                                     */
        } ADDR_b[29];
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint8_t ADAMPOFF;        /*!< (@ 0x00000062) A/D RRAMP off state register                               */

        struct
        {
            __IOM uint8_t OPOFF : 8;   /*!< [7..0] OPOFF                                                              */
        } ADAMPOFF_b;
    };

    union
    {
        __IOM uint8_t ADTSTPR;         /*!< (@ 0x00000063) A/D Test Protecting Release Register                       */

        struct
        {
            __IOM uint8_t PRO  : 1;    /*!< [0..0] Test register protecting bit.                                      */
            __IOM uint8_t B0WI : 1;    /*!< [1..1] Bit 0 writing permission bit.                                      */
            uint8_t            : 6;
        } ADTSTPR_b;
    };

    union
    {
        __IOM uint16_t ADDDACER;       /*!< (@ 0x00000064) A/D RRAMP Discharge Period Register                        */

        struct
        {
            __IOM uint16_t WRION  : 5; /*!< [4..0] WRION                                                              */
            uint16_t              : 3;
            __IOM uint16_t WRIOFF : 5; /*!< [12..8] WRIOFF                                                            */
            uint16_t              : 2;
            __IOM uint16_t ADHS   : 1; /*!< [15..15] ADHS                                                             */
        } ADDDACER_b;
    };

    union
    {
        __IOM uint16_t ADSHCR;         /*!< (@ 0x00000066) A/D Sample and Hold Circuit Control Register               */

        struct
        {
            __IOM uint16_t SSTSH : 8;  /*!< [7..0] Channel-Dedicated Sample-and-Hold Circuit Sampling Time
                                        *   Setting Set the sampling time (4 to 255 states)                           */
            __IOM uint16_t SHANS0 : 1; /*!< [8..8] AN000 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS1 : 1; /*!< [9..9] AN001 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS2 : 1; /*!< [10..10] AN002 sample-and-hold circuit Select                             */
            uint16_t              : 5;
        } ADSHCR_b;
    };

    union
    {
        __IOM uint16_t ADEXTSTR;       /*!< (@ 0x00000068) A/D Enhancing Test Register                                */

        struct
        {
            __IOM uint16_t SHTEST : 3; /*!< [2..0] Test mode bit for S&H circuit.Test mode bit of S&H circuit
                                        *   only for channel.                                                         */
            uint16_t             : 1;
            __IOM uint16_t SWTST : 2;  /*!< [5..4] Test selection bit for pressure switch.                            */
            uint16_t             : 2;
            __IOM uint16_t SHTRM : 2;  /*!< [9..8] Current adjustment trim bit for S&H circuit.Trim bit
                                        *   for adjustment to hardening of process.                                   */
            uint16_t              : 1;
            __IOM uint16_t ADTRM3 : 1; /*!< [11..11] Trim bit 3 for A/D hard macro.3bit Flash comparator
                                        *   power save bit for A/D hard macro to hardening of process.                */
            __IOM uint16_t ADTRM2 : 2; /*!< [13..12] Trim bit 2 for A/D hard macro.Bias adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
            __IOM uint16_t ADTRM1 : 2; /*!< [15..14] Trim bit 1 for A/D hard macro.Timing adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
        } ADEXTSTR_b;
    };

    union
    {
        __IOM uint16_t ADTSTRA;           /*!< (@ 0x0000006A) A/D Test Register A                                        */

        struct
        {
            __IOM uint16_t ATBUSSEL : 1;  /*!< [0..0] Analog test bus selection bit.                                     */
            __IOM uint16_t TSTSWREF : 3;  /*!< [3..1] Pressure switch refreshing setting bit for S&H circuit
                                           *   amplifier test.Refreshing the pressure switch that opens
                                           *   for the DAC output voltage charge period when the amplifier
                                           *   of the S&H circuit is tested only for the channel is set.                 */
            uint16_t            : 1;
            __IOM uint16_t OCSW : 1;      /*!< [5..5] Internal reference voltage analog switch test control
                                           *   bit.                                                                      */
            __IOM uint16_t TSSW : 1;      /*!< [6..6] Temperature sensor output analogue switch test control
                                           *   bit                                                                       */
            uint16_t                 : 1;
            __IOM uint16_t ADTEST_AD : 4; /*!< [11..8] Test bit for A/D analog module Bit for test of A/D analog
                                           *   module Details are described to the bit explanation.                      */
            __IOM uint16_t ADTEST_IO : 4; /*!< [15..12] Test bit for analog I/ODetails are described to the
                                           *   bit explanation.                                                          */
        } ADTSTRA_b;
    };

    union
    {
        __IOM uint16_t ADTSTRB;        /*!< (@ 0x0000006C) A/D Test Register B                                        */

        struct
        {
            __IOM uint16_t ADVAL : 15; /*!< [14..0] Signal input bit bit14-0 for A/D analog module test.It
                                        *   corresponds to ADVAL 14:0 input of A/D analog module.                     */
            uint16_t : 1;
        } ADTSTRB_b;
    };

    union
    {
        __IOM uint16_t ADTSTRC;         /*!< (@ 0x0000006E) A/D Test Register C                                        */

        struct
        {
            __IOM uint16_t ADMD : 8;    /*!< [7..0] Bit for A/D analog module test.ADMODE 6:0 input of A/D
                                         *   analog module.                                                            */
            uint16_t               : 4;
            __IOM uint16_t SYNCERR : 1; /*!< [12..12] Synchronous analog to digital conversion error bit.              */
            uint16_t               : 3;
        } ADTSTRC_b;
    };

    union
    {
        __IOM uint16_t ADTSTRD;         /*!< (@ 0x00000070) A/D Test Register D                                        */

        struct
        {
            __IOM uint16_t ADVAL16 : 1; /*!< [0..0] Signal input bit bit16 for A/D analog module test.It
                                         *   corresponds to ADVAL 16 input of A/D analog module.                       */
            uint16_t : 15;
        } ADTSTRD_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR0;      /*!< (@ 0x00000072) A/D Channel Switch Test Control Register 0                 */

        struct
        {
            __IOM uint16_t CHSW00 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW01 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW02 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW03 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW04 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW05 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR0_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR1;      /*!< (@ 0x00000074) A/D Channel Switch Test Control Register 1                 */

        struct
        {
            __IOM uint16_t CHSW16 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW17 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW18 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW19 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW20 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW21 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR1_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR2;        /*!< (@ 0x00000076) A/D Channel Switch Test Control Register 2                 */

        struct
        {
            __IOM uint16_t EX0SW : 1;    /*!< [0..0] Test control of 0 enhancing input channel switches bit
                                          *   (ANEX0 switch)                                                            */
            __IOM uint16_t EX1SW : 1;    /*!< [1..1] Test control of one enhancing input channel switch bit
                                          *   (ANEX1 switch).                                                           */
            uint16_t                : 2;
            __IOM uint16_t SHBYPS0  : 1; /*!< [4..4] S&H circuit by-pass switch control bit 0.                          */
            __IOM uint16_t SHBYPS1  : 1; /*!< [5..5] S&H circuit by-pass switch control bit 1.                          */
            __IOM uint16_t SHBYPS2  : 1; /*!< [6..6] S&H circuit by-pass switch control bit 2.                          */
            uint16_t                : 1;
            __IOM uint16_t GRP0SW   : 1; /*!< [8..8] Test control of 0 group switches bit.                              */
            __IOM uint16_t GRP1SW   : 1; /*!< [9..9] Test control of one group switch bit.                              */
            __IOM uint16_t GRP2SW   : 1; /*!< [10..10] Test control of two group switches bit                           */
            __IOM uint16_t GRP3SW   : 1; /*!< [11..11] Test control of two group switches bit                           */
            __IOM uint16_t GRPEX1SW : 1; /*!< [12..12] Switch test control bit of enhancing analog ANEX1                */
            uint16_t                : 3;
        } ADSWTSTR2_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t ADDISCR;         /*!< (@ 0x0000007A) A/D Disconnection Detection Control Register               */

        struct
        {
            __IOM uint8_t ADNDIS : 4;  /*!< [3..0] The charging time                                                  */
            __IOM uint8_t CHARGE : 1;  /*!< [4..4] Selection of Precharge or Discharge                                */
            uint8_t              : 3;
        } ADDISCR_b;
    };

    union
    {
        __IOM uint8_t ADSWCR;          /*!< (@ 0x0000007B) A/D Pressure Switch Control Register                       */

        struct
        {
            __IOM uint8_t ADSWREF : 3; /*!< [2..0] These bits are read as 0. The write value should be 0.Refreshing
                                        *   the pressure switch in A/D analog module is set.                          */
            uint8_t               : 1;
            __IOM uint8_t SHSWREF : 3; /*!< [6..4] S&H Boost Switch Refresh Interval Setting                          */
            uint8_t               : 1;
        } ADSWCR_b;
    };

    union
    {
        __IOM uint8_t ADSHMSR;         /*!< (@ 0x0000007C) A/D Sample and Hold Operation Mode Select Register         */

        struct
        {
            __IOM uint8_t SHMD : 1;    /*!< [0..0] Channel-Dedicated Sample-and-Hold Circuit Operation Mode
                                        *   Select                                                                    */
            uint8_t : 7;
        } ADSHMSR_b;
    };

    union
    {
        __IOM uint8_t ADICR;           /*!< (@ 0x0000007D) A/D Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t ADIC : 2;    /*!< [1..0] A/D Interrupt Control                                              */
            uint8_t            : 6;
        } ADICR_b;
    };

    union
    {
        __IOM uint8_t ADACSR;          /*!< (@ 0x0000007E) A/D Conversion Operation Mode Select Register              */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t ADSAC : 1;   /*!< [1..1] Successive Approximation Control Setting                           */
            uint8_t             : 6;
        } ADACSR_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint16_t ADGSPCR;         /*!< (@ 0x00000080) A/D Group Scan Priority Control Register                   */

        struct
        {
            __IOM uint16_t PGS : 1;     /*!< [0..0] Group A priority control setting bit.Note: When the PGS
                                         *   bit is to be set to 1, the ADCSR.ADCS[1:0] bits must be
                                         *   set to 01b (group scan mode). If the bits are set to any
                                         *   other values, proper operation is not guaranteed.                         */
            __IOM uint16_t GBRSCN : 1;  /*!< [1..1] Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                         *   when PGS = 0.)                                                            */
            uint16_t               : 6;
            __IOM uint16_t GBEXTRG : 1; /*!< [8..8] External trigger selection bit for group B.                        */
            uint16_t               : 6;
            __IOM uint16_t GBRP    : 1; /*!< [15..15] Group B Single Scan Continuous Start(Enabled only when
                                         *   PGS = 1. Reserved when PGS = 0.)Note: When the GBRP bit
                                         *   has been set to 1, single scan is performed continuously
                                         *   for group B regardless of the setting of the GBRSCN bit.                  */
        } ADGSPCR_b;
    };

    union
    {
        __IM uint16_t ADGSCS;          /*!< (@ 0x00000082) A/D Conversion Channel Status Register (for Group
                                        *                  Scan)                                                      */

        struct
        {
            __IM uint16_t CHSELGB : 8; /*!< [7..0] Channel status of Group B scan                                     */
            __IM uint16_t CHSELGA : 8; /*!< [15..8] Channel status of Group A scan                                    */
        } ADGSCS_b;
    };

    union
    {
        __IM uint16_t ADDBLDRA;          /*!< (@ 0x00000084) A/D Data Duplexing Register A                              */

        struct
        {
            __IM uint16_t ADDBLDRA : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRA_b;
    };

    union
    {
        __IM uint16_t ADDBLDRB;          /*!< (@ 0x00000086) A/D Data Duplexing Register B                              */

        struct
        {
            __IM uint16_t ADDBLDRB : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRB_b;
    };

    union
    {
        __IOM uint8_t ADSER;           /*!< (@ 0x00000088) A/D Sampling Extension Register                            */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t SMPEX : 1;   /*!< [7..7] Sampling extension control                                         */
        } ADSER_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint8_t ADHVREFCNT;      /*!< (@ 0x0000008A) A/D High-Potential/Low-Potential Reference Voltage
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint8_t HVSEL : 2;   /*!< [1..0] High-Potential Reference Voltage Select                            */
            uint8_t             : 2;
            __IOM uint8_t LVSEL : 1;   /*!< [4..4] Low-Potential Reference Voltage Select                             */
            uint8_t             : 2;
            __IOM uint8_t ADSLP : 1;   /*!< [7..7] Sleep                                                              */
        } ADHVREFCNT_b;
    };
    __IM uint8_t RESERVED7;

    union
    {
        __IM uint8_t ADWINMON;         /*!< (@ 0x0000008C) A/D Compare Function Window A/B Status Monitor
                                        *                  Register                                                   */

        struct
        {
            __IM uint8_t MONCOMB : 1;  /*!< [0..0] Combination result monitorThis bit indicates the combination
                                        *   result.This bit is valid when both window A operation and
                                        *   window B operation are enabled.                                           */
            uint8_t              : 3;
            __IM uint8_t MONCMPA : 1;  /*!< [4..4] Comparison Result Monitor A                                        */
            __IM uint8_t MONCMPB : 1;  /*!< [5..5] Comparison Result Monitor B                                        */
            uint8_t              : 2;
        } ADWINMON_b;
    };
    __IM uint8_t  RESERVED8;
    __IM uint16_t RESERVED9;

    union
    {
        __IOM uint16_t ADCMPCR;        /*!< (@ 0x00000090) A/D Compare Function Control Register                      */

        struct
        {
            __IOM uint16_t CMPAB : 2;  /*!< [1..0] Window A/B Composite Conditions SettingNOTE: These bits
                                        *   are valid when both window A and window B are enabled (CMPAE
                                        *   = 1 and CMPBE = 1).                                                       */
            uint16_t              : 7;
            __IOM uint16_t CMPBE  : 1; /*!< [9..9] Compare Window B Operation Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t CMPAE  : 1; /*!< [11..11] Compare Window A Operation Enable                                */
            uint16_t              : 1;
            __IOM uint16_t CMPBIE : 1; /*!< [13..13] Compare B Interrupt Enable                                       */
            __IOM uint16_t WCMPE  : 1; /*!< [14..14] Window Function Setting                                          */
            __IOM uint16_t CMPAIE : 1; /*!< [15..15] Compare A Interrupt Enable                                       */
        } ADCMPCR_b;
    };

    union
    {
        __IOM uint8_t ADCMPANSER;      /*!< (@ 0x00000092) A/D Compare Function Window A Extended Input
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint8_t CMPTSA : 1;  /*!< [0..0] Temperature sensor output Compare selection bit.                   */
            __IOM uint8_t CMPOCA : 1;  /*!< [1..1] Internal reference voltage Compare selection bit.                  */
            uint8_t              : 6;
        } ADCMPANSER_b;
    };

    union
    {
        __IOM uint8_t ADCMPLER;        /*!< (@ 0x00000093) A/D Compare Function Window A Extended Input
                                        *                  Comparison Condition Setting Register                      */

        struct
        {
            __IOM uint8_t CMPLTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Comparison
                                        *   Condition Select                                                          */
            __IOM uint8_t CMPLOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage ComparisonCondition
                                        *   Select                                                                    */
            uint8_t : 6;
        } ADCMPLER_b;
    };

    union
    {
        __IOM uint16_t ADCMPANSR[2];     /*!< (@ 0x00000094) A/D Compare Function Window A Channel Select
                                          *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPCHA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t CMPCHA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t CMPCHA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t CMPCHA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t CMPCHA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t CMPCHA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t CMPCHA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t CMPCHA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t CMPCHA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t CMPCHA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t CMPCHA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t CMPCHA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t CMPCHA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t CMPCHA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t CMPCHA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t CMPCHA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADCMPANSR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPLR[2];        /*!< (@ 0x00000098) A/D Compare Function Window A Comparison Condition
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t CMPLCHA0  : 1; /*!< [0..0] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA1  : 1; /*!< [1..1] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA2  : 1; /*!< [2..2] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA3  : 1; /*!< [3..3] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA4  : 1; /*!< [4..4] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA5  : 1; /*!< [5..5] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA6  : 1; /*!< [6..6] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA7  : 1; /*!< [7..7] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA8  : 1; /*!< [8..8] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA9  : 1; /*!< [9..9] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA10 : 1; /*!< [10..10] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA11 : 1; /*!< [11..11] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA12 : 1; /*!< [12..12] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA13 : 1; /*!< [13..13] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA14 : 1; /*!< [14..14] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA15 : 1; /*!< [15..15] Comparison condition of input                                    */
        } ADCMPLR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPDR0;          /*!< (@ 0x0000009C) A/D Compare Function Window A Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR0 : 16; /*!< [15..0] The ADCMPDR0 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR0 sets the lower-side
                                           *   level of window A.                                                        */
        } ADCMPDR0_b;
    };

    union
    {
        __IOM uint16_t ADCMPDR1;          /*!< (@ 0x0000009E) A/D Compare Function Window A Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR1 : 16; /*!< [15..0] The ADCMPDR1 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR1 sets the upper-side
                                           *   level of window A..                                                       */
        } ADCMPDR1_b;
    };

    union
    {
        __IOM uint16_t ADCMPSR[2];         /*!< (@ 0x000000A0) A/D Compare Function Window A Channel Status
                                            *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPSTCHA0  : 1; /*!< [0..0] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA1  : 1; /*!< [1..1] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA2  : 1; /*!< [2..2] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA3  : 1; /*!< [3..3] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA4  : 1; /*!< [4..4] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA5  : 1; /*!< [5..5] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA6  : 1; /*!< [6..6] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA7  : 1; /*!< [7..7] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA8  : 1; /*!< [8..8] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA9  : 1; /*!< [9..9] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA10 : 1; /*!< [10..10] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA11 : 1; /*!< [11..11] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA12 : 1; /*!< [12..12] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA13 : 1; /*!< [13..13] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA14 : 1; /*!< [14..14] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA15 : 1; /*!< [15..15] Compare window A flag of input                                   */
        } ADCMPSR_b[2];
    };

    union
    {
        __IOM uint8_t ADCMPSER;         /*!< (@ 0x000000A4) A/D Compare Function Window A Extended Input
                                         *                  Channel Status Register                                    */

        struct
        {
            __IOM uint8_t CMPSTTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            __IOM uint8_t CMPSTOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            uint8_t : 6;
        } ADCMPSER_b;
    };
    __IM uint8_t RESERVED10;

    union
    {
        __IOM uint8_t ADCMPBNSR;       /*!< (@ 0x000000A6) A/D Compare Function Window B Channel Selection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t CMPCHB : 6;  /*!< [5..0] Compare window B channel selection bit.The channel that
                                        *   compares it on the condition of compare window B is selected.             */
            uint8_t             : 1;
            __IOM uint8_t CMPLB : 1;   /*!< [7..7] Compare window B Compare condition setting bit.                    */
        } ADCMPBNSR_b;
    };
    __IM uint8_t RESERVED11;

    union
    {
        __IOM uint16_t ADWINLLB;          /*!< (@ 0x000000A8) A/D Compare Function Window B Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINLLB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the lower level of the window B.                              */
        } ADWINLLB_b;
    };

    union
    {
        __IOM uint16_t ADWINULB;          /*!< (@ 0x000000AA) A/D Compare Function Window B Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINULB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the higher level of the window B.                             */
        } ADWINULB_b;
    };

    union
    {
        __IOM uint8_t ADCMPBSR;        /*!< (@ 0x000000AC) A/D Compare Function Window B Status Register              */

        struct
        {
            __IOM uint8_t CMPSTB : 1;  /*!< [0..0] Compare window B flag.It is a status flag that shows
                                        *   the comparative result of CH (AN000-AN027, temperature
                                        *   sensor, and internal reference voltage) made the object
                                        *   of window B relation condition.                                           */
            uint8_t : 7;
        } ADCMPBSR_b;
    };
    __IM uint8_t  RESERVED12;
    __IM uint16_t RESERVED13;

    union
    {
        __IM uint16_t ADBUF0;          /*!< (@ 0x000000B0) A/D Data Buffer Register 0                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF0_b;
    };

    union
    {
        __IM uint16_t ADBUF1;          /*!< (@ 0x000000B2) A/D Data Buffer Register 1                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF1_b;
    };

    union
    {
        __IM uint16_t ADBUF2;          /*!< (@ 0x000000B4) A/D Data Buffer Register 2                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF2_b;
    };

    union
    {
        __IM uint16_t ADBUF3;          /*!< (@ 0x000000B6) A/D Data Buffer Register 3                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF3_b;
    };

    union
    {
        __IM uint16_t ADBUF4;          /*!< (@ 0x000000B8) A/D Data Buffer Register 4                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF4_b;
    };

    union
    {
        __IM uint16_t ADBUF5;          /*!< (@ 0x000000BA) A/D Data Buffer Register 5                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF5_b;
    };

    union
    {
        __IM uint16_t ADBUF6;          /*!< (@ 0x000000BC) A/D Data Buffer Register 6                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF6_b;
    };

    union
    {
        __IM uint16_t ADBUF7;          /*!< (@ 0x000000BE) A/D Data Buffer Register 7                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF7_b;
    };

    union
    {
        __IM uint16_t ADBUF8;          /*!< (@ 0x000000C0) A/D Data Buffer Register 8                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF8_b;
    };

    union
    {
        __IM uint16_t ADBUF9;          /*!< (@ 0x000000C2) A/D Data Buffer Register 9                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF9_b;
    };

    union
    {
        __IM uint16_t ADBUF10;         /*!< (@ 0x000000C4) A/D Data Buffer Register 10                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF10_b;
    };

    union
    {
        __IM uint16_t ADBUF11;         /*!< (@ 0x000000C6) A/D Data Buffer Register 11                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF11_b;
    };

    union
    {
        __IM uint16_t ADBUF12;         /*!< (@ 0x000000C8) A/D Data Buffer Register 12                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF12_b;
    };

    union
    {
        __IM uint16_t ADBUF13;         /*!< (@ 0x000000CA) A/D Data Buffer Register 13                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF13_b;
    };

    union
    {
        __IM uint16_t ADBUF14;         /*!< (@ 0x000000CC) A/D Data Buffer Register 14                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF14_b;
    };

    union
    {
        __IM uint16_t ADBUF15;         /*!< (@ 0x000000CE) A/D Data Buffer Register 15                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF15_b;
    };

    union
    {
        __IOM uint8_t ADBUFEN;         /*!< (@ 0x000000D0) A/D Data Buffer Enable Register                            */

        struct
        {
            __IOM uint8_t BUFEN : 1;   /*!< [0..0] Data Buffer Enable                                                 */
            uint8_t             : 7;
        } ADBUFEN_b;
    };
    __IM uint8_t RESERVED14;

    union
    {
        __IOM uint8_t ADBUFPTR;        /*!< (@ 0x000000D2) A/D Data Buffer Pointer Register                           */

        struct
        {
            __IM uint8_t BUFPTR : 4;   /*!< [3..0] Data Buffer PointerThese bits indicate the number of
                                        *   data buffer to which the next A/D converted data is transferred.          */
            __IM uint8_t PTROVF : 1;   /*!< [4..4] Pointer Overflow Flag                                              */
            uint8_t             : 3;
        } ADBUFPTR_b;
    };
    __IM uint8_t  RESERVED15;
    __IM uint32_t RESERVED16[2];
    __IM uint8_t  RESERVED17;

    union
    {
        __IOM uint8_t ADSSTRL;         /*!< (@ 0x000000DD) A/D Sampling State Register L                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (AN016-AN027)                                */
        } ADSSTRL_b;
    };

    union
    {
        __IOM uint8_t ADSSTRT;         /*!< (@ 0x000000DE) A/D Sampling State Register T                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (temperature sensor output)                  */
        } ADSSTRT_b;
    };

    union
    {
        __IOM uint8_t ADSSTRO;         /*!< (@ 0x000000DF) A/D Sampling State Register O                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (Internal reference voltage)                 */
        } ADSSTRO_b;
    };

    union
    {
        __IOM uint8_t ADSSTR[16];      /*!< (@ 0x000000E0) A/D Sampling State Registers                               */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling time setting                                              */
        } ADSSTR_b[16];
    };

    union
    {
        __IOM uint16_t ADANIM;         /*!< (@ 0x000000F0) A/D Channel Input Mode Select Register                     */

        struct
        {
            __IOM uint16_t ANIM0 : 1;  /*!< [0..0] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM1 : 1;  /*!< [1..1] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM2 : 1;  /*!< [2..2] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM3 : 1;  /*!< [3..3] Analog Channel Input Mode Select                                   */
            uint16_t             : 12;
        } ADANIM_b;
    };

    union
    {
        __IOM uint8_t ADCALEXE;        /*!< (@ 0x000000F2) A/D Calibration Execution Register                         */

        struct
        {
            uint8_t              : 6;
            __IM uint8_t  CALMON : 1;  /*!< [6..6] Calibration Status Flag                                            */
            __IOM uint8_t CALEXE : 1;  /*!< [7..7] Calibration Start                                                  */
        } ADCALEXE_b;
    };
    __IM uint8_t RESERVED18;

    union
    {
        __IOM uint8_t VREFAMPCNT;        /*!< (@ 0x000000F4) A/D Dedicated Reference Voltage Circuit Control
                                          *                  Register                                                   */

        struct
        {
            __IOM uint8_t OLDETEN   : 1; /*!< [0..0] OLDET Enable                                                       */
            __IOM uint8_t VREFADCG  : 2; /*!< [2..1] VREFADC Output Voltage Control                                     */
            __IOM uint8_t VREFADCEN : 1; /*!< [3..3] VREFADCG Enable                                                    */
            __IOM uint8_t BGREN     : 1; /*!< [4..4] BGR Enable                                                         */
            uint8_t                 : 2;
            __IOM uint8_t ADSLP     : 1; /*!< [7..7] Sleep                                                              */
        } VREFAMPCNT_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint16_t ADRD;           /*!< (@ 0x000000F8) A/D Self-Diagnosis Data Register                           */

        struct
        {
            __IM uint16_t AD : 16;     /*!< [15..0] Converted Value 15 to 0                                           */
        } ADRD_b;
    };

    union
    {
        __IM uint8_t ADRST;            /*!< (@ 0x000000FA) A/D Self-Diagnostic Status Register                        */

        struct
        {
            __IM uint8_t DIAGST : 2;   /*!< [1..0] Self-Diagnosis Status                                              */
            uint8_t             : 6;
        } ADRST_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint32_t RESERVED22[41];

    union
    {
        __IOM uint16_t ADPGACR;           /*!< (@ 0x000001A0) A/D Programmable Gain Amplifier Control Register           */

        struct
        {
            __IOM uint16_t P000SEL0  : 1; /*!< [0..0] A through amplifier is enable for PGA P000                         */
            __IOM uint16_t P000SEL1  : 1; /*!< [1..1] The amplifier passing is enable for PGA P000                       */
            __IOM uint16_t P000ENAMP : 1; /*!< [2..2] Amplifier enable bit for PGA P000                                  */
            __IOM uint16_t P000GEN   : 1; /*!< [3..3] PGA P000 gain setting and enable bit                               */
            __IOM uint16_t P001SEL0  : 1; /*!< [4..4] A through amplifier is enable for PGA P001                         */
            __IOM uint16_t P001SEL1  : 1; /*!< [5..5] The amplifier passing is enable for PGA P001                       */
            __IOM uint16_t P001ENAMP : 1; /*!< [6..6] Amplifier enable bit for PGA P001                                  */
            __IOM uint16_t P001GEN   : 1; /*!< [7..7] PGA P001 gain setting and enable bit                               */
            __IOM uint16_t P002SEL0  : 1; /*!< [8..8] A through amplifier is enable for PGA P002                         */
            __IOM uint16_t P002SEL1  : 1; /*!< [9..9] The amplifier passing is enable for PGA P002                       */
            __IOM uint16_t P002ENAMP : 1; /*!< [10..10] Amplifier enable bit for PGA P002                                */
            __IOM uint16_t P002GEN   : 1; /*!< [11..11] PGA P002 gain setting and enable bit                             */
            __IOM uint16_t P003SEL0  : 1; /*!< [12..12] A through amplifier is enable for PGA P003                       */
            __IOM uint16_t P003SEL1  : 1; /*!< [13..13] The amplifier passing is enable for PGA P003                     */
            __IOM uint16_t P003ENAMP : 1; /*!< [14..14] Amplifier enable bit for PGA P003                                */
            __IOM uint16_t P003GEN   : 1; /*!< [15..15] PGA P003 gain setting and enable bit                             */
        } ADPGACR_b;
    };

    union
    {
        __IOM uint16_t ADPGAGS0;         /*!< (@ 0x000001A2) A/D Programmable Gain Amplifier Gain Setting
                                          *                  Register 0                                                 */

        struct
        {
            __IOM uint16_t P000GAIN : 4; /*!< [3..0] PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=
                                          *   b) when the shingle end is input and each PGA P000 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P000GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P000DG 1:0.                    */
            __IOM uint16_t P001GAIN : 4; /*!< [7..4] PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=
                                          *   b) when the shingle end is input and each PGA P001 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P001GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P001DG 1:0.                    */
            __IOM uint16_t P002GAIN : 4; /*!< [11..8] PGA P002 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P002GEN=0b) when the shingle end is input and
                                          *   each PGA P002 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P002GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P002DG 1:0.                                                     */
            __IOM uint16_t P003GAIN : 4; /*!< [15..12] PGA P003 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P003GEN=0b) when the shingle end is input and
                                          *   each PGA P003 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P003GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P003DG 1:0.                                                     */
        } ADPGAGS0_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint16_t ADPGADCR0;       /*!< (@ 0x000001B0) A/D Programmable Gain Amplifier Differential
                                         *                  Input Control Register                                     */

        struct
        {
            __IOM uint16_t P000DG : 2;  /*!< [1..0] P000 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P000DEN, P000GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P000DEN : 1; /*!< [3..3] P000 Differential Input Enable                                     */
            __IOM uint16_t P001DG  : 2; /*!< [5..4] P001 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P001DEN, P001GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P001DEN : 1; /*!< [7..7] P001 Differential Input Enable                                     */
            __IOM uint16_t P002DG  : 2; /*!< [9..8] P002 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P002DEN, P002GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P002DEN : 1; /*!< [11..11] P002 Differential Input Enable                                   */
            __IOM uint16_t P003DG  : 2; /*!< [13..12] P003 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P003DEN, P003GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P003DEN : 1; /*!< [15..15] P003 Differential Input Enable                                   */
        } ADPGADCR0_b;
    };
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t ADPGADBS0;       /*!< (@ 0x000001B4) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 0                               */

        struct
        {
            __IOM uint8_t P0BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P000 to P002 Bias Voltage
                                        *   SelectNOTE: This bit selects the input bias voltage value
                                        *   when differential inputs are used.                                        */
            uint8_t : 7;
        } ADPGADBS0_b;
    };

    union
    {
        __IOM uint8_t ADPGADBS1;       /*!< (@ 0x000001B5) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 1                               */

        struct
        {
            __IOM uint8_t P3BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE:
                                        *   This bit selects the input bias voltage value when differential
                                        *   inputs are used.                                                          */
            uint8_t : 7;
        } ADPGADBS1_b;
    };
    __IM uint16_t RESERVED25;
    __IM uint32_t RESERVED26[10];

    union
    {
        __IOM uint32_t ADREFMON;       /*!< (@ 0x000001E0) A/D External Reference Voltage Monitor Register            */

        struct
        {
            __IOM uint32_t PGAMON : 3; /*!< [2..0] PGA Monitor Output Enable                                          */
            uint32_t              : 13;
            __IOM uint32_t MONSEL : 4; /*!< [19..16] Monitor output selection bit.                                    */
            uint32_t              : 12;
        } ADREFMON_b;
    };
} R_ADC0_Type;                         /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS Structure                                            */
{
    __IOM R_BUS_CSa_Type CSa[8];        /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t        RESERVED[480];
    __IOM R_BUS_CSb_Type CSb[8];        /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t           RESERVED1;
    __IM uint32_t           RESERVED2[223];
    __IOM R_BUS_SDRAM_Type  SDRAM;      /*!< (@ 0x00000C00) SDRAM Registers                                            */
    __IM uint32_t           RESERVED3[235];
    __IOM R_BUS_BUSM_Type   BUSM[6];    /*!< (@ 0x00001000) Master Bus Control Register Array                          */
    __IM uint32_t           RESERVED4[58];
    __IOM R_BUS_BUSS_Type   BUSS[16];   /*!< (@ 0x00001100) Slave Bus Control Register Array                           */
    __IM uint32_t           RESERVED5[432];
    __IOM R_BUS_BUSERR_Type BUSERR[11]; /*!< (@ 0x00001800) Bus Error Registers                                        */
} R_BUS_Type;                           /*!< Size = 6320 (0x18b0)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Clock Frequency Accuracy Measurement Circuit (R_CAC)
 */

typedef struct                         /*!< (@ 0x40044600) R_CAC Structure                                            */
{
    union
    {
        __IOM uint8_t CACR0;           /*!< (@ 0x00000000) CAC Control Register 0                                     */

        struct
        {
            __IOM uint8_t CFME : 1;    /*!< [0..0] Clock Frequency Measurement Enable.                                */
            uint8_t            : 7;
        } CACR0_b;
    };

    union
    {
        __IOM uint8_t CACR1;           /*!< (@ 0x00000001) CAC Control Register 1                                     */

        struct
        {
            __IOM uint8_t CACREFE : 1; /*!< [0..0] CACREF Pin Input Enable                                            */
            __IOM uint8_t FMCS    : 3; /*!< [3..1] Measurement Target Clock Select                                    */
            __IOM uint8_t TCSS    : 2; /*!< [5..4] Measurement Target Clock Frequency Division Ratio Select           */
            __IOM uint8_t EDGES   : 2; /*!< [7..6] Valid Edge Select                                                  */
        } CACR1_b;
    };

    union
    {
        __IOM uint8_t CACR2;           /*!< (@ 0x00000002) CAC Control Register 2                                     */

        struct
        {
            __IOM uint8_t RPS  : 1;    /*!< [0..0] Reference Signal Select                                            */
            __IOM uint8_t RSCS : 3;    /*!< [3..1] Measurement Reference Clock Select                                 */
            __IOM uint8_t RCDS : 2;    /*!< [5..4] Measurement Reference Clock Frequency Division Ratio
                                        *   Select                                                                    */
            __IOM uint8_t DFS : 2;     /*!< [7..6] Digital Filter Selection                                           */
        } CACR2_b;
    };

    union
    {
        __IOM uint8_t CAICR;           /*!< (@ 0x00000003) CAC Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t FERRIE : 1;  /*!< [0..0] Frequency Error Interrupt Request Enable                           */
            __IOM uint8_t MENDIE : 1;  /*!< [1..1] Measurement End Interrupt Request Enable                           */
            __IOM uint8_t OVFIE  : 1;  /*!< [2..2] Overflow Interrupt Request Enable                                  */
            uint8_t              : 1;
            __OM uint8_t FERRFCL : 1;  /*!< [4..4] FERRF Clear                                                        */
            __OM uint8_t MENDFCL : 1;  /*!< [5..5] MENDF Clear                                                        */
            __OM uint8_t OVFFCL  : 1;  /*!< [6..6] OVFF Clear                                                         */
            uint8_t              : 1;
        } CAICR_b;
    };

    union
    {
        __IM uint8_t CASTR;            /*!< (@ 0x00000004) CAC Status Register                                        */

        struct
        {
            __IM uint8_t FERRF : 1;    /*!< [0..0] Frequency Error Flag                                               */
            __IM uint8_t MENDF : 1;    /*!< [1..1] Measurement End Flag                                               */
            __IM uint8_t OVFF  : 1;    /*!< [2..2] Counter Overflow Flag                                              */
            uint8_t            : 5;
        } CASTR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t CAULVR;          /*!< (@ 0x00000006) CAC Upper-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CAULVR : 16; /*!< [15..0] CAULVR is a 16-bit readable/writable register that stores
                                         *   the upper-limit value of the frequency.                                   */
        } CAULVR_b;
    };

    union
    {
        __IOM uint16_t CALLVR;          /*!< (@ 0x00000008) CAC Lower-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CALLVR : 16; /*!< [15..0] CALLVR is a 16-bit readable/writable register that stores
                                         *   the lower-limit value of the frequency.                                   */
        } CALLVR_b;
    };

    union
    {
        __IM uint16_t CACNTBR;          /*!< (@ 0x0000000A) CAC Counter Buffer Register                                */

        struct
        {
            __IM uint16_t CACNTBR : 16; /*!< [15..0] CACNTBR is a 16-bit read-only register that retains
                                         *   the counter value at the time a valid reference signal
                                         *   edge is input                                                             */
        } CACNTBR_b;
    };
} R_CAC_Type;                           /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Cyclic Redundancy Check (CRC) Calculator (R_CRC)
 */

typedef struct                         /*!< (@ 0x40074000) R_CRC Structure                                            */
{
    union
    {
        __IOM uint8_t CRCCR0;          /*!< (@ 0x00000000) CRC Control Register0                                      */

        struct
        {
            __IOM uint8_t GPS    : 3;  /*!< [2..0] CRC Generating Polynomial Switching                                */
            uint8_t              : 3;
            __IOM uint8_t LMS    : 1;  /*!< [6..6] CRC Calculation Switching                                          */
            __OM uint8_t  DORCLR : 1;  /*!< [7..7] CRCDOR Register Clear                                              */
        } CRCCR0_b;
    };

    union
    {
        __IOM uint8_t CRCCR1;          /*!< (@ 0x00000001) CRC Control Register1                                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t CRCSWR : 1;  /*!< [6..6] Snoop-on-write/read switch bit                                     */
            __IOM uint8_t CRCSEN : 1;  /*!< [7..7] Snoop enable bit                                                   */
        } CRCCR1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        union
        {
            __IOM uint32_t CRCDIR;          /*!< (@ 0x00000004) CRC Data Input Register                                    */

            struct
            {
                __IOM uint32_t CRCDIR : 32; /*!< [31..0] Calculation input Data (Case of CRC-32, CRC-32C )                 */
            } CRCDIR_b;
        };

        union
        {
            __IOM uint8_t CRCDIR_BY;         /*!< (@ 0x00000004) CRC Data Input Register (byte access)                      */

            struct
            {
                __IOM uint8_t CRCDIR_BY : 8; /*!< [7..0] Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                              *   )                                                                         */
            } CRCDIR_BY_b;
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CRCDOR;          /*!< (@ 0x00000008) CRC Data Output Register                                   */

            struct
            {
                __IOM uint32_t CRCDOR : 32; /*!< [31..0] Calculation output Data (Case of CRC-32, CRC-32C )                */
            } CRCDOR_b;
        };

        union
        {
            __IOM uint16_t CRCDOR_HA;          /*!< (@ 0x00000008) CRC Data Output Register (halfword access)                 */

            struct
            {
                __IOM uint16_t CRCDOR_HA : 16; /*!< [15..0] Calculation output Data (Case of CRC-16 or CRC-CCITT
                                                *   )                                                                         */
            } CRCDOR_HA_b;
        };

        union
        {
            __IOM uint8_t CRCDOR_BY;         /*!< (@ 0x00000008) CRC Data Output Register(byte access)                      */

            struct
            {
                __IOM uint8_t CRCDOR_BY : 8; /*!< [7..0] Calculation output Data (Case of CRC-8 )                           */
            } CRCDOR_BY_b;
        };
    };

    union
    {
        __IOM uint16_t CRCSAR;         /*!< (@ 0x0000000C) Snoop Address Register                                     */

        struct
        {
            __IOM uint16_t CRCSA : 14; /*!< [13..0] snoop address bitSet the I/O register address to snoop            */
            uint16_t             : 2;
        } CRCSAR_b;
    };
    __IM uint16_t RESERVED1;
} R_CRC_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Debug Function (R_DEBUG)
 */

typedef struct                         /*!< (@ 0x4001B000) R_DEBUG Structure                                          */
{
    union
    {
        __IM uint32_t DBGSTR;          /*!< (@ 0x00000000) Debug Status Register                                      */

        struct
        {
            uint32_t                   : 28;
            __IM uint32_t CDBGPWRUPREQ : 1; /*!< [28..28] Debug power-up request                                           */
            __IM uint32_t CDBGPWRUPACK : 1; /*!< [29..29] Debug power-up acknowledge                                       */
            uint32_t                   : 2;
        } DBGSTR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t DBGSTOPCR;             /*!< (@ 0x00000010) Debug Stop Control Register                                */

        struct
        {
            __IOM uint32_t DBGSTOP_IWDT  : 1; /*!< [0..0] Mask bit for IWDT reset/interrupt                                  */
            __IOM uint32_t DBGSTOP_WDT   : 1; /*!< [1..1] Mask bit for WDT reset/interrupt                                   */
            uint32_t                     : 14;
            __IOM uint32_t DBGSTOP_LVD0  : 1; /*!< [16..16] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD1  : 1; /*!< [17..17] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD2  : 1; /*!< [18..18] Mask bit for LVD reset/interupt                                  */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_RPER  : 1; /*!< [24..24] Mask bit for SRAM parity error                                   */
            __IOM uint32_t DBGSTOP_RECCR : 1; /*!< [25..25] Mask bit for SRAM ECC error                                      */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_CPER  : 1; /*!< [31..31] Mask bit for Cache SRAM parity error reset/interrupt             */
        } DBGSTOPCR_b;
    };
} R_DEBUG_Type;                               /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Operation Circuit (R_DOC)
 */

typedef struct                         /*!< (@ 0x40054100) R_DOC Structure                                            */
{
    union
    {
        __IOM uint8_t DOCR;            /*!< (@ 0x00000000) DOC Control Register                                       */

        struct
        {
            __IOM uint8_t OMS     : 2; /*!< [1..0] Operating Mode Select                                              */
            __IOM uint8_t DCSEL   : 1; /*!< [2..2] Detection Condition Select                                         */
            uint8_t               : 2;
            __IM uint8_t  DOPCF   : 1; /*!< [5..5] Data Operation Circuit Flag                                        */
            __IOM uint8_t DOPCFCL : 1; /*!< [6..6] DOPCF Clear                                                        */
            uint8_t               : 1;
        } DOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t DODIR;          /*!< (@ 0x00000002) DOC Data Input Register                                    */

        struct
        {
            __IOM uint16_t DODIR : 16; /*!< [15..0] 16-bit read-write register in which 16-bit data for
                                        *   use in the operations are stored.                                         */
        } DODIR_b;
    };

    union
    {
        __IOM uint16_t DODSR;          /*!< (@ 0x00000004) DOC Data Setting Register                                  */

        struct
        {
            __IOM uint16_t DODSR : 16; /*!< [15..0] This register stores 16-bit data for use as a reference
                                        *   in data comparison mode. This register also stores the
                                        *   results of operations in data addition and data subtraction
                                        *   modes.                                                                    */
        } DODSR_b;
    };
} R_DOC_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Transfer Controller (R_DTC)
 */

typedef struct                         /*!< (@ 0x40005400) R_DTC Structure                                            */
{
    union
    {
        __IOM uint8_t DTCCR;           /*!< (@ 0x00000000) DTC Control Register                                       */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DTCVBR;          /*!< (@ 0x00000004) DTC Vector Base Register                                   */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.Note: A value cannot be set
                                         *   in the lower-order 10 bits. These bits are fixed to 0.                    */
        } DTCVBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint8_t DTCST;           /*!< (@ 0x0000000C) DTC Module Start Register                                  */

        struct
        {
            __IOM uint8_t DTCST : 1;   /*!< [0..0] DTC Module Start                                                   */
            uint8_t             : 7;
        } DTCST_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IM uint16_t DTCSTS;          /*!< (@ 0x0000000E) DTC Status Register                                        */

        struct
        {
            __IM uint16_t VECN : 8;    /*!< [7..0] DTC-Activating Vector Number MonitoringThese bits indicate
                                        *   the vector number for the activating source when DTC transfer
                                        *   is in progress.The value is only valid if DTC transfer
                                        *   is in progress (the value of the ACT flag is 1)                           */
            uint16_t          : 7;
            __IM uint16_t ACT : 1;     /*!< [15..15] DTC Active Flag                                                  */
        } DTCSTS_b;
    };

    union
    {
        __IOM uint8_t DTCCR_SEC;       /*!< (@ 0x00000010) DTC Control Register for secure Region                     */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t RRSS : 1;    /*!< [4..4] DTC Transfer Information Read Skip Enable for Secure               */
            uint8_t            : 3;
        } DTCCR_SEC_b;
    };
    __IM uint8_t   RESERVED4;
    __IM uint16_t  RESERVED5;
    __IOM uint32_t DTCVBR_SEC;         /*!< (@ 0x00000014) DTC Vector Base Register for secure Region                 */
    __IM uint32_t  RESERVED6[2];

    union
    {
        __IOM uint32_t DTEVR;          /*!< (@ 0x00000020) DTC Error Vector Register                                  */

        struct
        {
            __IM uint32_t DTEV    : 8; /*!< [7..0] DTC Error Vector Number                                            */
            __IM uint32_t DTEVSAM : 1; /*!< [8..8] DTC Error Vector Number SA Monitor                                 */
            uint32_t              : 7;
            __IOM uint32_t DTESTA : 1; /*!< [16..16] DTC Error Status Flag                                            */
            uint32_t              : 15;
        } DTEVR_b;
    };
} R_DTC_Type;                          /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Event Link Controller (R_ELC)
 */

typedef struct                         /*!< (@ 0x40041000) R_ELC Structure                                            */
{
    union
    {
        __IOM uint8_t ELCR;            /*!< (@ 0x00000000) Event Link Controller Register                             */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t ELCON : 1;   /*!< [7..7] All Event Link Enable                                              */
        } ELCR_b;
    };
    __IM uint8_t            RESERVED;
    __IOM R_ELC_ELSEGR_Type ELSEGR[2]; /*!< (@ 0x00000002) Event Link Software Event Generation Register              */
    __IM uint16_t           RESERVED1[5];
    __IOM R_ELC_ELSR_Type   ELSR[23];  /*!< (@ 0x00000010) Event Link Setting Register [0..22]                        */
    __IM uint16_t           RESERVED2[4];

    union
    {
        __IOM uint16_t ELCSARA;         /*!< (@ 0x00000074) Event Link Controller Security Attribution Register
                                         *                  A                                                          */

        struct
        {
            __IOM uint16_t ELCR    : 1; /*!< [0..0] Event Link Controller RegisterSecurity Attribution                 */
            __IOM uint16_t ELSEGR0 : 1; /*!< [1..1] Event Link Software Event Generation Register 0 Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELSEGR1 : 1; /*!< [2..2] Event Link Software Event Generation Register 1Security
                                         *   Attribution                                                               */
            uint16_t : 13;
        } ELCSARA_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ELCSARB;        /*!< (@ 0x00000078) Event Link Controller Security Attribution Register
                                        *                  B                                                          */

        struct
        {
            __IOM uint16_t ELSR0  : 1; /*!< [0..0] Event Link Setting Register 0Security Attribution                  */
            __IOM uint16_t ELSR1  : 1; /*!< [1..1] Event Link Setting Register 1Security Attribution                  */
            __IOM uint16_t ELSR2  : 1; /*!< [2..2] Event Link Setting Register 2Security Attribution                  */
            __IOM uint16_t ELSR3  : 1; /*!< [3..3] Event Link Setting Register 3Security Attribution                  */
            __IOM uint16_t ELSR4  : 1; /*!< [4..4] Event Link Setting Register 4Security Attribution                  */
            __IOM uint16_t ELSR5  : 1; /*!< [5..5] Event Link Setting Register 5Security Attribution                  */
            __IOM uint16_t ELSR6  : 1; /*!< [6..6] Event Link Setting Register 6Security Attribution                  */
            __IOM uint16_t ELSR7  : 1; /*!< [7..7] Event Link Setting Register 7Security Attribution                  */
            __IOM uint16_t ELSR8  : 1; /*!< [8..8] Event Link Setting Register 8Security Attribution                  */
            __IOM uint16_t ELSR9  : 1; /*!< [9..9] Event Link Setting Register 9Security Attribution                  */
            __IOM uint16_t ELSR10 : 1; /*!< [10..10] Event Link Setting Register 10Security Attribution               */
            __IOM uint16_t ELSR11 : 1; /*!< [11..11] Event Link Setting Register 11Security Attribution               */
            __IOM uint16_t ELSR12 : 1; /*!< [12..12] Event Link Setting Register 12Security Attribution               */
            __IOM uint16_t ELSR13 : 1; /*!< [13..13] Event Link Setting Register 13Security Attribution               */
            __IOM uint16_t ELSR14 : 1; /*!< [14..14] Event Link Setting Register 14Security Attribution               */
            __IOM uint16_t ELSR15 : 1; /*!< [15..15] Event Link Setting Register 15Security Attribution               */
        } ELCSARB_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint16_t ELCSARC;        /*!< (@ 0x0000007C) Event Link Controller Security Attribution Register
                                        *                  C                                                          */

        struct
        {
            __IOM uint16_t ELSR16 : 1; /*!< [0..0] Event Link Setting Register 16Security Attribution                 */
            __IOM uint16_t ELSR17 : 1; /*!< [1..1] Event Link Setting Register 17Security Attribution                 */
            __IOM uint16_t ELSR18 : 1; /*!< [2..2] Event Link Setting Register 18Security Attribution                 */
            uint16_t              : 13;
        } ELCSARC_b;
    };
} R_ELC_Type;                          /*!< Size = 126 (0x7e)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_FACI_LP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_LP)
 */

typedef struct                         /*!< (@ 0x407EC000) R_FACI_LP Structure                                        */
{
    __IM uint32_t RESERVED[36];
    __IOM uint8_t DFLCTL;              /*!< (@ 0x00000090) Flash P/E Mode Control Register                            */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[27];

    union
    {
        __IOM uint8_t FPMCR;           /*!< (@ 0x00000100) Flash P/E Mode Control Register                            */

        struct
        {
            uint8_t            : 1;
            __IOM uint8_t FMS0 : 1;    /*!< [1..1] Flash Operating Mode Select 0FMS2,1,0: 000: Read mode
                                        *   011: Discharge mode 1 111: Discharge mode 2 101: Code Flash
                                        *   P/E mode 010: Data flash P/E mode Others: Setting prohibited.             */
            uint8_t             : 1;
            __IOM uint8_t RPDIS : 1;   /*!< [3..3] Code Flash P/E Disable                                             */
            __IOM uint8_t FMS1  : 1;   /*!< [4..4] The bit to make data flash a programming modeRefer to
                                        *   the description of the FMS0 bit.                                          */
            uint8_t            : 1;
            __IOM uint8_t VLPE : 1;    /*!< [6..6] Low-Voltage P/E Mode Enable                                        */
            __IOM uint8_t FMS2 : 1;    /*!< [7..7] Flash Operating Mode Select 2.Refer to the description
                                        *   of the FMS0 bit.                                                          */
        } FPMCR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;

    union
    {
        __IOM uint8_t FASR;            /*!< (@ 0x00000104) Flash Area Select Register                                 */

        struct
        {
            __IOM uint8_t EXS : 1;     /*!< [0..0] Extra area select                                                  */
            uint8_t           : 7;
        } FASR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t FSARL;             /*!< (@ 0x00000108) Flash Processing Start Address Register L                  */

        struct
        {
            __IOM uint16_t FSAR15_0 : 16; /*!< [15..0] Start address                                                     */
        } FSARL_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint16_t FSARH;             /*!< (@ 0x00000110) Flash Processing Start Address Register H                  */

        struct
        {
            __IOM uint16_t FSAR20_16 : 5; /*!< [4..0] Start address                                                      */
            uint16_t                 : 4;
            __IOM uint16_t FSAR31_25 : 7; /*!< [15..9] Start address                                                     */
        } FSARH_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint8_t FCR;             /*!< (@ 0x00000114) Flash Control Register                                     */

        struct
        {
            __IOM uint8_t CMD  : 4;    /*!< [3..0] Software Command Setting                                           */
            __IOM uint8_t DRC  : 1;    /*!< [4..4] Data Read Completion                                               */
            uint8_t            : 1;
            __IOM uint8_t STOP : 1;    /*!< [6..6] Forced Processing Stop                                             */
            __IOM uint8_t OPST : 1;    /*!< [7..7] Processing Start                                                   */
        } FCR_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;

    union
    {
        __IOM uint16_t FEARL;             /*!< (@ 0x00000118) Flash Processing End Address Register L                    */

        struct
        {
            __IOM uint16_t FEAR15_0 : 16; /*!< [15..0] End address                                                       */
        } FEARL_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t FEARH;             /*!< (@ 0x00000120) Flash Processing End Address Register H                    */

        struct
        {
            __IOM uint32_t FEAR20_16 : 5; /*!< [4..0] End address                                                        */
            uint32_t                 : 4;
            __IOM uint32_t FEAR31_25 : 7; /*!< [15..9] End address                                                       */
            uint32_t                 : 16;
        } FEARH_b;
    };

    union
    {
        __IOM uint32_t FRESETR;        /*!< (@ 0x00000124) Flash Reset Register                                       */

        struct
        {
            __IOM uint32_t FRESET : 1; /*!< [0..0] Software Reset of the registers                                    */
            uint32_t              : 31;
        } FRESETR_b;
    };

    union
    {
        __IM uint32_t FSTATR00;         /*!< (@ 0x00000128) Flash Status Register00                                    */

        struct
        {
            __IM uint32_t ERERR0   : 1; /*!< [0..0] Erase Error Flag0                                                  */
            __IM uint32_t PRGERR0  : 1; /*!< [1..1] Program Error Flag0                                                */
            __IM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t BCERR0   : 1; /*!< [3..3] Blank Check Error Flag0                                            */
            __IM uint32_t ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t               : 26;
        } FSTATR00_b;
    };

    union
    {
        __IM uint32_t FSTATR1;         /*!< (@ 0x0000012C) Flash Status Register1                                     */

        struct
        {
            uint32_t            : 1;
            __IM uint32_t DRRDY : 1;   /*!< [1..1] Data read request                                                  */
            uint32_t            : 4;
            __IM uint32_t FRDY  : 1;   /*!< [6..6] End status signal of a sequencer                                   */
            __IM uint32_t EXRDY : 1;   /*!< [7..7] End status signal of a Extra programming sequencer                 */
            uint32_t            : 24;
        } FSTATR1_b;
    };

    union
    {
        __IOM uint32_t FWBL0;          /*!< (@ 0x00000130) Flash Write Buffer Register L0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBL0_b;
    };
    __IM uint32_t RESERVED15;

    union
    {
        __IOM uint32_t FWBH0;          /*!< (@ 0x00000138) Flash Write Buffer Register H0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBH0_b;
    };

    union
    {
        __IM uint32_t FSTATR01;        /*!< (@ 0x0000013C) Flash Status Register01                                    */

        struct
        {
            __IM uint32_t ERERR1  : 1; /*!< [0..0] Erase Error Flag1                                                  */
            __IM uint32_t PRGERR1 : 1; /*!< [1..1] Program Error Flag1                                                */
            uint32_t              : 1;
            __IM uint32_t BCERR1  : 1; /*!< [3..3] Blank Check Error Flag1                                            */
            uint32_t              : 28;
        } FSTATR01_b;
    };

    union
    {
        __IOM uint32_t FWBL1;               /*!< (@ 0x00000140) Flash Write Buffer Register L1                             */

        struct
        {
            __IOM uint32_t WDATA47_32 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBL1_b;
    };

    union
    {
        __IOM uint32_t FWBH1;               /*!< (@ 0x00000144) Flash Write Buffer Register H1                             */

        struct
        {
            __IOM uint32_t WDATA63_48 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBH1_b;
    };

    union
    {
        __IM uint32_t FRBL1;               /*!< (@ 0x00000148) Flash Read Buffer Register L1                              */

        struct
        {
            __IM uint32_t RDATA47_32 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBL1_b;
    };

    union
    {
        __IM uint32_t FRBH1;               /*!< (@ 0x0000014C) Flash Read Buffer Register H1                              */

        struct
        {
            __IM uint32_t RDATA63_48 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBH1_b;
    };
    __IM uint32_t RESERVED16[12];

    union
    {
        __OM uint32_t FPR;             /*!< (@ 0x00000180) Protection Unlock Register                                 */

        struct
        {
            __OM uint32_t FPR : 8;     /*!< [7..0] Protection Unlock Register                                         */
            uint32_t          : 24;
        } FPR_b;
    };

    union
    {
        __IM uint32_t FPSR;            /*!< (@ 0x00000184) Protection Unlock Status Register                          */

        struct
        {
            __IM uint32_t PERR : 1;    /*!< [0..0] Protect Error Flag                                                 */
            uint32_t           : 31;
        } FPSR_b;
    };

    union
    {
        __IM uint32_t FRBL0;           /*!< (@ 0x00000188) Flash Read Buffer Register L0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBL0_b;
    };
    __IM uint32_t RESERVED17;

    union
    {
        __IM uint32_t FRBH0;           /*!< (@ 0x00000190) Flash Read Buffer Register H0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBH0_b;
    };
    __IM uint32_t RESERVED18[11];

    union
    {
        __IM uint32_t FSCMR;           /*!< (@ 0x000001C0) Flash Start-Up Setting Monitor Register                    */

        struct
        {
            uint32_t            : 8;
            __IM uint32_t SASMF : 1;   /*!< [8..8] Start-up Area Setting Monitor Flag                                 */
            uint32_t            : 5;
            __IM uint32_t FSPR  : 1;   /*!< [14..14] Access Window Protection Flag                                    */
            uint32_t            : 17;
        } FSCMR_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IM uint32_t FAWSMR;          /*!< (@ 0x000001C8) Flash Access Window Start Address Monitor Register         */

        struct
        {
            __IM uint32_t FAWS : 12;   /*!< [11..0] Flash Access Window Start Address                                 */
            uint32_t           : 20;
        } FAWSMR_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IM uint32_t FAWEMR;          /*!< (@ 0x000001D0) Flash Access Window End Address Monitor Register           */

        struct
        {
            __IM uint32_t FAWE : 12;   /*!< [11..0] Flash Access Window End Address                                   */
            uint32_t           : 20;
        } FAWEMR_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t FISR;           /*!< (@ 0x000001D8) Flash Initial Setting Register                             */

        struct
        {
            __IOM uint32_t PCKA : 6;   /*!< [5..0] Peripheral Clock Notification                                      */
            __IOM uint32_t SAS  : 2;   /*!< [7..6] Temporary boot swap mode                                           */
            uint32_t            : 24;
        } FISR_b;
    };

    union
    {
        __IOM uint32_t FEXCR;          /*!< (@ 0x000001DC) Flash Extra Area Control Register                          */

        struct
        {
            __IOM uint32_t CMD  : 3;   /*!< [2..0] Processing Start)                                                  */
            uint32_t            : 4;
            __IOM uint32_t OPST : 1;   /*!< [7..7] Software Command Setting                                           */
            uint32_t            : 24;
        } FEXCR_b;
    };

    union
    {
        __IM uint32_t FEAML;           /*!< (@ 0x000001E0) Flash Error Address Monitor Register L                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAML_b;
    };
    __IM uint32_t RESERVED22;

    union
    {
        __IM uint32_t FEAMH;           /*!< (@ 0x000001E8) Flash Error Address Monitor Register H                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAMH_b;
    };
    __IM uint32_t RESERVED23;

    union
    {
        __IM uint32_t FSTATR2;           /*!< (@ 0x000001F0) Flash Status Register2                                     */

        struct
        {
            __IM uint32_t  ERERR    : 1; /*!< [0..0] Erase Error Flag                                                   */
            __IM uint32_t  PRGERR1  : 1; /*!< [1..1] Program Error Flag                                                 */
            __IOM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t  BCERR    : 1; /*!< [3..3] Blank Check Error Flag                                             */
            __IM uint32_t  ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t  EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t                : 26;
        } FSTATR2_b;
    };
    __IM uint32_t RESERVED24[95];

    union
    {
        __IOM uint32_t FCTLFR;          /*!< (@ 0x00000370) Flash Control Flag Register                                */

        struct
        {
            __IOM uint32_t BANKSWP : 3; /*!< [2..0] Bank Swap Setting                                                  */
            uint32_t               : 29;
        } FCTLFR_b;
    };
    __IM uint32_t  RESERVED25[3855];
    __IOM uint16_t FENTRYR_MF4;        /*!< (@ 0x00003FB0) Flash P/E Mode Entry Register for MF4                      */
    __IOM uint16_t FENTRYR;            /*!< (@ 0x00003FB2) Flash P/E Mode Entry Register                              */
    __IM uint32_t  RESERVED26[3];
    __IOM uint8_t  FLWAITR;            /*!< (@ 0x00003FC0) Flash Wait Cycle Register                                  */
    __IM uint8_t   RESERVED27;
    __IM uint16_t  RESERVED28;

    union
    {
        __IOM uint8_t FLDWAITR;         /*!< (@ 0x00003FC4) Memory Wait Cycle Control Register for Data Flash          */

        struct
        {
            __IOM uint8_t FLDWAIT1 : 1; /*!< [0..0] Memory Wait Cycle Select for Data Flash                            */
            uint8_t                : 7;
        } FLDWAITR_b;
    };
    __IM uint8_t  RESERVED29;
    __IM uint16_t RESERVED30;
    __IOM uint8_t PFBER;               /*!< (@ 0x00003FC8) Prefetch Buffer Enable Register                            */
    __IM uint8_t  RESERVED31;
    __IM uint16_t RESERVED32;
    __IM uint32_t RESERVED33;

    union
    {
        __IOM uint16_t FBKPGCR;        /*!< (@ 0x00003FD0) Flash Bank Program Control Register                        */

        struct
        {
            __IOM uint16_t BKPGEN : 1; /*!< [0..0] Bank Programming Setting Enable                                    */
            uint16_t              : 7;
            __OM uint16_t FEKEY   : 8; /*!< [15..8] Key Code                                                          */
        } FBKPGCR_b;
    };
    __IM uint16_t RESERVED34;

    union
    {
        __IOM uint16_t FBKSWCR;          /*!< (@ 0x00003FD4) Flash Bank Swap Control Register                           */

        struct
        {
            __IOM uint16_t BKSWUPEN : 1; /*!< [0..0] Bank Swap Update Enable                                            */
            uint16_t                : 7;
            __OM uint16_t FEKEY     : 8; /*!< [15..8] Key Code                                                          */
        } FBKSWCR_b;
    };
    __IM uint16_t RESERVED35;
} R_FACI_LP_Type;                        /*!< Size = 16344 (0x3fd8)                                                     */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief General PWM Timer (R_GPT0)
 */

typedef struct                         /*!< (@ 0x40078000) R_GPT0 Structure                                           */
{
    union
    {
        __IOM uint32_t GTWP;           /*!< (@ 0x00000000) General PWM Timer Write-Protection Register                */

        struct
        {
            __IOM uint32_t WP    : 1;  /*!< [0..0] Register Write Disable                                             */
            __IOM uint32_t STRWP : 1;  /*!< [1..1] GTSTR.CSTRT Bit Write Disable                                      */
            __IOM uint32_t STPWP : 1;  /*!< [2..2] GTSTP.CSTOP Bit Write Disable                                      */
            __IOM uint32_t CLRWP : 1;  /*!< [3..3] GTCLR.CCLR Bit Write Disable                                       */
            __IOM uint32_t CMNWP : 1;  /*!< [4..4] Common Register Write Disabled                                     */
            uint32_t             : 3;
            __OM uint32_t PRKEY  : 8;  /*!< [15..8] GTWP Key Code                                                     */
            uint32_t             : 16;
        } GTWP_b;
    };

    union
    {
        __IOM uint32_t GTSTR;           /*!< (@ 0x00000004) General PWM Timer Software Start Register                  */

        struct
        {
            __IOM uint32_t CSTRT0 : 1;  /*!< [0..0] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT1 : 1;  /*!< [1..1] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT2 : 1;  /*!< [2..2] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT3 : 1;  /*!< [3..3] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT4 : 1;  /*!< [4..4] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT5 : 1;  /*!< [5..5] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT6 : 1;  /*!< [6..6] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT7 : 1;  /*!< [7..7] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT8 : 1;  /*!< [8..8] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT9 : 1;  /*!< [9..9] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT10 : 1; /*!< [10..10] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT11 : 1; /*!< [11..11] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT12 : 1; /*!< [12..12] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT13 : 1; /*!< [13..13] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT14 : 1; /*!< [14..14] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT15 : 1; /*!< [15..15] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT16 : 1; /*!< [16..16] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT17 : 1; /*!< [17..17] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT18 : 1; /*!< [18..18] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT19 : 1; /*!< [19..19] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT20 : 1; /*!< [20..20] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT21 : 1; /*!< [21..21] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT22 : 1; /*!< [22..22] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT23 : 1; /*!< [23..23] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT24 : 1; /*!< [24..24] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT25 : 1; /*!< [25..25] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT26 : 1; /*!< [26..26] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT27 : 1; /*!< [27..27] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT28 : 1; /*!< [28..28] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT29 : 1; /*!< [29..29] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT30 : 1; /*!< [30..30] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT31 : 1; /*!< [31..31] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
        } GTSTR_b;
    };

    union
    {
        __IOM uint32_t GTSTP;           /*!< (@ 0x00000008) General PWM Timer Software Stop Register                   */

        struct
        {
            __IOM uint32_t CSTOP0 : 1;  /*!< [0..0] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP1 : 1;  /*!< [1..1] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP2 : 1;  /*!< [2..2] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP3 : 1;  /*!< [3..3] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP4 : 1;  /*!< [4..4] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP5 : 1;  /*!< [5..5] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP6 : 1;  /*!< [6..6] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP7 : 1;  /*!< [7..7] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP8 : 1;  /*!< [8..8] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP9 : 1;  /*!< [9..9] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP10 : 1; /*!< [10..10] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP11 : 1; /*!< [11..11] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP12 : 1; /*!< [12..12] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP13 : 1; /*!< [13..13] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP14 : 1; /*!< [14..14] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP15 : 1; /*!< [15..15] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP16 : 1; /*!< [16..16] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP17 : 1; /*!< [17..17] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP18 : 1; /*!< [18..18] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP19 : 1; /*!< [19..19] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP20 : 1; /*!< [20..20] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP21 : 1; /*!< [21..21] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP22 : 1; /*!< [22..22] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP23 : 1; /*!< [23..23] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP24 : 1; /*!< [24..24] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP25 : 1; /*!< [25..25] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP26 : 1; /*!< [26..26] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP27 : 1; /*!< [27..27] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP28 : 1; /*!< [28..28] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP29 : 1; /*!< [29..29] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP30 : 1; /*!< [30..30] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP31 : 1; /*!< [31..31] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
        } GTSTP_b;
    };

    union
    {
        __OM uint32_t GTCLR;           /*!< (@ 0x0000000C) General PWM Timer Software Clear Register                  */

        struct
        {
            __OM uint32_t CCLR0  : 1;  /*!< [0..0] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR1  : 1;  /*!< [1..1] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR2  : 1;  /*!< [2..2] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR3  : 1;  /*!< [3..3] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR4  : 1;  /*!< [4..4] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR5  : 1;  /*!< [5..5] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR6  : 1;  /*!< [6..6] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR7  : 1;  /*!< [7..7] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR8  : 1;  /*!< [8..8] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR9  : 1;  /*!< [9..9] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR10 : 1;  /*!< [10..10] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR11 : 1;  /*!< [11..11] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR12 : 1;  /*!< [12..12] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR13 : 1;  /*!< [13..13] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR14 : 1;  /*!< [14..14] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR15 : 1;  /*!< [15..15] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR16 : 1;  /*!< [16..16] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR17 : 1;  /*!< [17..17] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR18 : 1;  /*!< [18..18] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR19 : 1;  /*!< [19..19] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR20 : 1;  /*!< [20..20] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR21 : 1;  /*!< [21..21] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR22 : 1;  /*!< [22..22] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR23 : 1;  /*!< [23..23] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR24 : 1;  /*!< [24..24] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR25 : 1;  /*!< [25..25] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR26 : 1;  /*!< [26..26] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR27 : 1;  /*!< [27..27] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR28 : 1;  /*!< [28..28] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR29 : 1;  /*!< [29..29] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR30 : 1;  /*!< [30..30] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR31 : 1;  /*!< [31..31] Channel GTCNT Count Clear                                        */
        } GTCLR_b;
    };

    union
    {
        __IOM uint32_t GTSSR;            /*!< (@ 0x00000010) General PWM Timer Start Source Select Register             */

        struct
        {
            __IOM uint32_t SSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Start Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTRT  : 1;   /*!< [31..31] Software Source Counter Start Enable                             */
        } GTSSR_b;
    };

    union
    {
        __IOM uint32_t GTPSR;            /*!< (@ 0x00000014) General PWM Timer Stop Source Select Register              */

        struct
        {
            __IOM uint32_t PSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Stop Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTOP  : 1;   /*!< [31..31] Software Source Counter Stop Enable                              */
        } GTPSR_b;
    };

    union
    {
        __IOM uint32_t GTCSR;            /*!< (@ 0x00000018) General PWM Timer Clear Source Select Register             */

        struct
        {
            __IOM uint32_t CSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSCMSC : 3;   /*!< [26..24] Compare Match/Input Capture/Synchronous counter clearing
                                          *   Source Counter Clear Enable.                                              */
            __IOM uint32_t CP1CCE : 1;   /*!< [27..27] Complementary PWM mode1 Crest Source Counter Clear
                                          *   Enable (This bit is only available in GPT324 to GPT329.
                                          *   In GPT320 to GPT323, this bit is read as 0. The write value
                                          *   should be 0.)                                                             */
            uint32_t            : 3;
            __IOM uint32_t CCLR : 1;     /*!< [31..31] Software Source Counter Clear Enable                             */
        } GTCSR_b;
    };

    union
    {
        __IOM uint32_t GTUPSR;           /*!< (@ 0x0000001C) General PWM Timer Up Count Source Select Register          */

        struct
        {
            __IOM uint32_t USGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USILVL : 4;   /*!< [27..24] External Input Level Source Count-Up Enable                      */
            uint32_t              : 4;
        } GTUPSR_b;
    };

    union
    {
        __IOM uint32_t GTDNSR;           /*!< (@ 0x00000020) General PWM Timer Down Count Source Select Register        */

        struct
        {
            __IOM uint32_t DSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSILVL : 4;   /*!< [27..24] External Input Level Source Count-Down Enable                    */
            uint32_t              : 4;
        } GTDNSR_b;
    };

    union
    {
        __IOM uint32_t GTICASR;          /*!< (@ 0x00000024) General PWM Timer Input Capture Source Select
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t ASGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            uint32_t              : 8;
        } GTICASR_b;
    };

    union
    {
        __IOM uint32_t GTICBSR;          /*!< (@ 0x00000028) General PWM Timer Input Capture Source Select
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t BSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            uint32_t              : 8;
        } GTICBSR_b;
    };

    union
    {
        __IOM uint32_t GTCR;            /*!< (@ 0x0000002C) General PWM Timer Control Register                         */

        struct
        {
            __IOM uint32_t CST     : 1; /*!< [0..0] Count Start                                                        */
            uint32_t               : 7;
            __IOM uint32_t ICDS    : 1; /*!< [8..8] Input Capture Operation Select During Count Stop                   */
            __IOM uint32_t SCGTIOC : 1; /*!< [9..9] GTIOC input Source Synchronous Clear Enable                        */
            __IOM uint32_t SSCGRP  : 2; /*!< [11..10] Synchronous Set/Clear Group Select                               */
            __IOM uint32_t CPSCD   : 1; /*!< [12..12] Complementary PWM Mode Synchronous Clear Disable                 */
            uint32_t               : 2;
            __IOM uint32_t SSCEN   : 1; /*!< [15..15] Synchronous Set/Clear Enable                                     */
            __IOM uint32_t MD      : 4; /*!< [19..16] Mode Select                                                      */
            uint32_t               : 4;
            __IOM uint32_t TPCS    : 3; /*!< [26..24] Timer Prescaler Select                                           */
            __IOM uint32_t CKEG    : 2; /*!< [28..27] Clock Edge Select                                                */
            uint32_t               : 3;
        } GTCR_b;
    };

    union
    {
        __IOM uint32_t GTUDDTYC;       /*!< (@ 0x00000030) General PWM Timer Count Direction and Duty Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t UD     : 1; /*!< [0..0] Count Direction Setting                                            */
            __IOM uint32_t UDF    : 1; /*!< [1..1] Forcible Count Direction Setting                                   */
            uint32_t              : 14;
            __IOM uint32_t OADTY  : 2; /*!< [17..16] GTIOCA Output Duty Setting                                       */
            __IOM uint32_t OADTYF : 1; /*!< [18..18] Forcible GTIOCA Output Duty Setting                              */
            __IOM uint32_t OADTYR : 1; /*!< [19..19] GTIOCA Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t              : 4;
            __IOM uint32_t OBDTY  : 2; /*!< [25..24] GTIOCB Output Duty Setting                                       */
            __IOM uint32_t OBDTYF : 1; /*!< [26..26] Forcible GTIOCB Output Duty Setting                              */
            __IOM uint32_t OBDTYR : 1; /*!< [27..27] GTIOCB Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t : 4;
        } GTUDDTYC_b;
    };

    union
    {
        __IOM uint32_t GTIOR;          /*!< (@ 0x00000034) General PWM Timer I/O Control Register                     */

        struct
        {
            __IOM uint32_t GTIOA  : 5; /*!< [4..0] GTIOCA Pin Function Select                                         */
            __IOM uint32_t CPSCIR : 1; /*!< [5..5] Complementary PWM Mode Initial Output at Synchronous
                                        *   Clear Disable.(This bit is only available in GPT324 to
                                        *   GPT329. In GPT320 to GPT323, this bit is read as 0. The
                                        *   write value should be 0.)                                                 */
            __IOM uint32_t OADFLT : 1; /*!< [6..6] GTIOCA Pin Output Value Setting at the Count Stop                  */
            __IOM uint32_t OAHLD  : 1; /*!< [7..7] GTIOCA Pin Output Setting at the Start/Stop Count                  */
            __IOM uint32_t OAE    : 1; /*!< [8..8] GTIOCA Pin Output Enable                                           */
            __IOM uint32_t OADF   : 2; /*!< [10..9] GTIOCA Pin Disable Value Setting                                  */
            __IOM uint32_t OAEOCD : 1; /*!< [11..11] GTCCRA Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            __IOM uint32_t PSYE   : 1; /*!< [12..12] PWM Synchronous output Enable                                    */
            __IOM uint32_t NFAEN  : 1; /*!< [13..13] Noise Filter A Enable                                            */
            __IOM uint32_t NFCSA  : 2; /*!< [15..14] Noise Filter A Sampling Clock Select                             */
            __IOM uint32_t GTIOB  : 5; /*!< [20..16] GTIOCB Pin Function Select                                       */
            uint32_t              : 1;
            __IOM uint32_t OBDFLT : 1; /*!< [22..22] GTIOCB Pin Output Value Setting at the Count Stop                */
            __IOM uint32_t OBHLD  : 1; /*!< [23..23] GTIOCB Pin Output Setting at the Start/Stop Count                */
            __IOM uint32_t OBE    : 1; /*!< [24..24] GTIOCB Pin Output Enable                                         */
            __IOM uint32_t OBDF   : 2; /*!< [26..25] GTIOCB Pin Disable Value Setting                                 */
            __IOM uint32_t OBEOCD : 1; /*!< [27..27] GTCCRB Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            uint32_t             : 1;
            __IOM uint32_t NFBEN : 1;  /*!< [29..29] Noise Filter B Enable                                            */
            __IOM uint32_t NFCSB : 2;  /*!< [31..30] Noise Filter B Sampling Clock Select                             */
        } GTIOR_b;
    };

    union
    {
        __IOM uint32_t GTINTAD;        /*!< (@ 0x00000038) General PWM Timer Interrupt Output Setting Register        */

        struct
        {
            uint32_t            : 8;
            __IOM uint32_t SCFA : 1;     /*!< [8..8] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFB : 1;     /*!< [9..9] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFC : 1;     /*!< [10..10] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFD : 1;     /*!< [11..11] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFE : 1;     /*!< [12..12] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFF : 1;     /*!< [13..13] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFPO    : 1; /*!< [14..14] Overflow Source Synchronous Clear Enable                         */
            __IOM uint32_t SCFPU    : 1; /*!< [15..15] Underflow Source Synchronous Clear Enable                        */
            __IOM uint32_t ADTRAUEN : 1; /*!< [16..16] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRADEN : 1; /*!< [17..17] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            __IOM uint32_t ADTRBUEN : 1; /*!< [18..18] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRBDEN : 1; /*!< [19..19] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            uint32_t               : 4;
            __IOM uint32_t GRP     : 2;  /*!< [25..24] Output Disable Source Select                                     */
            uint32_t               : 2;
            __IOM uint32_t GRPDTE  : 1;  /*!< [28..28] Dead Time Error Output Disable Request Enable                    */
            __IOM uint32_t GRPABH  : 1;  /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IOM uint32_t GRPABL  : 1;  /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t GTINTPC : 1;  /*!< [31..31] Period Count Function Finish Interrupt Enable                    */
        } GTINTAD_b;
    };

    union
    {
        __IOM uint32_t GTST;            /*!< (@ 0x0000003C) General PWM Timer Status Register                          */

        struct
        {
            __IOM uint32_t TCFA  : 1;   /*!< [0..0] Input Capture/Compare Match Flag A                                 */
            __IOM uint32_t TCFB  : 1;   /*!< [1..1] Input Capture/Compare Match Flag B                                 */
            __IOM uint32_t TCFC  : 1;   /*!< [2..2] Input Compare Match Flag C                                         */
            __IOM uint32_t TCFD  : 1;   /*!< [3..3] Input Compare Match Flag D                                         */
            __IOM uint32_t TCFE  : 1;   /*!< [4..4] Input Compare Match Flag E                                         */
            __IOM uint32_t TCFF  : 1;   /*!< [5..5] Input Compare Match Flag F                                         */
            __IOM uint32_t TCFPO : 1;   /*!< [6..6] Overflow Flag                                                      */
            __IOM uint32_t TCFPU : 1;   /*!< [7..7] Underflow Flag                                                     */
            __IM uint32_t  ITCNT : 3;   /*!< [10..8] GTCIV/GTCIU Interrupt Skipping Count Counter(Counter
                                         *   for counting the number of times a timer interrupt has
                                         *   been skipped.)                                                            */
            uint32_t               : 4;
            __IM uint32_t  TUCF    : 1; /*!< [15..15] Count Direction Flag                                             */
            __IOM uint32_t ADTRAUF : 1; /*!< [16..16] GTADTRA Compare Match (Up-Counting) A/D Converter Start
                                         *   Request Interrupt Enable                                                  */
            __IOM uint32_t ADTRADF : 1; /*!< [17..17] GTADTRA Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            __IOM uint32_t ADTRBUF : 1; /*!< [18..18] GTADTRB Compare Match(Up-Counting) A/D Convertor Start
                                         *   Request Flag                                                              */
            __IOM uint32_t ADTRBDF : 1; /*!< [19..19] GTADTRB Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            uint32_t             : 4;
            __IM uint32_t ODF    : 1;   /*!< [24..24] Output Disable Flag                                              */
            uint32_t             : 3;
            __IM uint32_t  DTEF  : 1;   /*!< [28..28] Dead Time Error Flag                                             */
            __IM uint32_t  OABHF : 1;   /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IM uint32_t  OABLF : 1;   /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t PCF   : 1;   /*!< [31..31] Period Count Function Finish Flag                                */
        } GTST_b;
    };

    union
    {
        __IOM uint32_t GTBER;           /*!< (@ 0x00000040) General PWM Timer Buffer Enable Register                   */

        struct
        {
            __IOM uint32_t BD0     : 1; /*!< [0..0] BD[0]: GTCCR Buffer Operation Disable                              */
            __IOM uint32_t BD1     : 1; /*!< [1..1] BD[1]: GTPR Buffer Operation Disable                               */
            __IOM uint32_t BD2     : 1; /*!< [2..2] BD[2]: GTADTR Buffer Operation DisableBD                           */
            __IOM uint32_t BD3     : 1; /*!< [3..3] BD[3]: GTDV Buffer Operation DisableBD[2]                          */
            uint32_t               : 4;
            __IOM uint32_t DBRTECA : 1; /*!< [8..8] GTCCRn Register Double Buffer Repeat Operation Enable              */
            uint32_t               : 1;
            __IOM uint32_t DBRTECB : 1; /*!< [10..10] GTCCRn Register Double Buffer Repeat Operation Enable            */
            uint32_t               : 5;
            __IOM uint32_t CCRA    : 2; /*!< [17..16] GTCCRA Buffer Operation                                          */
            __IOM uint32_t CCRB    : 2; /*!< [19..18] GTCCRB Buffer Operation                                          */
            __IOM uint32_t PR      : 2; /*!< [21..20] GTPR Buffer Operation                                            */
            __OM uint32_t  CCRSWT  : 1; /*!< [22..22] GTCCRA and GTCCRB Forcible Buffer OperationThis bit
                                         *   is read as 0.                                                             */
            uint32_t             : 1;
            __IOM uint32_t ADTTA : 2;   /*!< [25..24] GTADTRA Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDA : 1;   /*!< [26..26] GTADTRA Double Buffer Operation                                  */
            uint32_t             : 1;
            __IOM uint32_t ADTTB : 2;   /*!< [29..28] GTADTRB Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDB : 1;   /*!< [30..30] GTADTRB Double Buffer Operation                                  */
            uint32_t             : 1;
        } GTBER_b;
    };

    union
    {
        __IOM uint32_t GTITC;          /*!< (@ 0x00000044) General PWM Timer Interrupt and A/D Converter
                                        *                  Start Request Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ITLA  : 1;  /*!< [0..0] GTCCRA Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLB  : 1;  /*!< [1..1] GTCCRB Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLC  : 1;  /*!< [2..2] GTCCRC Compare Match Interrupt Link                                */
            __IOM uint32_t ITLD  : 1;  /*!< [3..3] GTCCRD Compare Match Interrupt Link                                */
            __IOM uint32_t ITLE  : 1;  /*!< [4..4] GTCCRE Compare Match Interrupt Link                                */
            __IOM uint32_t ITLF  : 1;  /*!< [5..5] GTCCRF Compare Match Interrupt Link                                */
            __IOM uint32_t IVTC  : 2;  /*!< [7..6] GPT_OVF/GPT_UDF Interrupt Skipping Function Select                 */
            __IOM uint32_t IVTT  : 3;  /*!< [10..8] GPT_OVF/GPT_UDF Interrupt Skipping Count Select                   */
            uint32_t             : 1;
            __IOM uint32_t ADTAL : 1;  /*!< [12..12] GTADTRA A/D Converter Start Request Link                         */
            uint32_t             : 1;
            __IOM uint32_t ADTBL : 1;  /*!< [14..14] GTADTRB A/D Converter Start Request Link                         */
            uint32_t             : 17;
        } GTITC_b;
    };

    union
    {
        __IOM uint32_t GTCNT;          /*!< (@ 0x00000048) General PWM Timer Counter                                  */

        struct
        {
            __IOM uint32_t GTCNT : 32; /*!< [31..0] Counter                                                           */
        } GTCNT_b;
    };

    union
    {
        __IOM uint32_t GTCCR[6];       /*!< (@ 0x0000004C) General PWM Timer Compare Capture Register                 */

        struct
        {
            __IOM uint32_t GTCCR : 32; /*!< [31..0] Compare Capture Register A                                        */
        } GTCCR_b[6];
    };

    union
    {
        __IOM uint32_t GTPR;           /*!< (@ 0x00000064) General PWM Timer Cycle Setting Register                   */

        struct
        {
            __IOM uint32_t GTPR : 32;  /*!< [31..0] Cycle Setting Register                                            */
        } GTPR_b;
    };

    union
    {
        __IOM uint32_t GTPBR;          /*!< (@ 0x00000068) General PWM Timer Cycle Setting Buffer Register            */

        struct
        {
            __IOM uint32_t GTPBR : 32; /*!< [31..0] Cycle Setting Buffer Register                                     */
        } GTPBR_b;
    };

    union
    {
        __IOM uint32_t GTPDBR;          /*!< (@ 0x0000006C) General PWM Timer Cycle Setting Double-Buffer
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t GTPDBR : 32; /*!< [31..0] Cycle Setting Double-Buffer Register                              */
        } GTPDBR_b;
    };

    union
    {
        __IOM uint32_t GTADTRA;          /*!< (@ 0x00000070) A/D Converter Start Request Timing Register A              */

        struct
        {
            __IOM uint32_t GTADTRA : 32; /*!< [31..0] A/D Converter Start Request Timing Register A                     */
        } GTADTRA_b;
    };

    union
    {
        __IOM uint32_t GTADTBRA;          /*!< (@ 0x00000074) A/D Converter Start Request Timing Buffer Register
                                           *                  A                                                          */

        struct
        {
            __IOM uint32_t GTADTBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register A              */
        } GTADTBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRA;          /*!< (@ 0x00000078) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register A                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   A                                                                         */
        } GTADTDBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTRB;          /*!< (@ 0x0000007C) A/D Converter Start Request Timing Register B              */

        struct
        {
            __IOM uint32_t GTADTRB : 32; /*!< [31..0] A/D Converter Start Request Timing Register B                     */
        } GTADTRB_b;
    };

    union
    {
        __IOM uint32_t GTADTBRB;          /*!< (@ 0x00000080) A/D Converter Start Request Timing Buffer Register
                                           *                  B                                                          */

        struct
        {
            __IOM uint32_t GTADTBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register B              */
        } GTADTBRB_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRB;          /*!< (@ 0x00000084) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register B                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   B                                                                         */
        } GTADTDBRB_b;
    };

    union
    {
        __IOM uint32_t GTDTCR;         /*!< (@ 0x00000088) General PWM Timer Dead Time Control Register               */

        struct
        {
            __IOM uint32_t TDE   : 1;  /*!< [0..0] Negative-Phase Waveform Setting                                    */
            uint32_t             : 3;
            __IOM uint32_t TDBUE : 1;  /*!< [4..4] GTDVU Buffer Operation Enable                                      */
            __IOM uint32_t TDBDE : 1;  /*!< [5..5] GTDVD Buffer Operation Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t TDFER : 1;  /*!< [8..8] GTDVD Setting                                                      */
            uint32_t             : 23;
        } GTDTCR_b;
    };

    union
    {
        __IOM uint32_t GTDVU;          /*!< (@ 0x0000008C) General PWM Timer Dead Time Value Register U               */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Value Register U                                        */
        } GTDVU_b;
    };

    union
    {
        __IOM uint32_t GTDVD;          /*!< (@ 0x00000090) General PWM Timer Dead Time Value Register D               */

        struct
        {
            __IOM uint32_t GTDVD : 32; /*!< [31..0] Dead Time Value Register D                                        */
        } GTDVD_b;
    };

    union
    {
        __IOM uint32_t GTDBU;          /*!< (@ 0x00000094) General PWM Timer Dead Time Buffer Register U              */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Buffer Register U                                       */
        } GTDBU_b;
    };

    union
    {
        __IOM uint32_t GTDBD;          /*!< (@ 0x00000098) General PWM Timer Dead Time Buffer Register D              */

        struct
        {
            __IOM uint32_t GTDBD : 32; /*!< [31..0] Dead Time Buffer Register D                                       */
        } GTDBD_b;
    };

    union
    {
        __IM uint32_t GTSOS;           /*!< (@ 0x0000009C) General PWM Timer Output Protection Function
                                        *                  Status Register                                            */

        struct
        {
            __IM uint32_t SOS : 2;     /*!< [1..0] Output Protection Function Status                                  */
            uint32_t          : 30;
        } GTSOS_b;
    };

    union
    {
        __IOM uint32_t GTSOTR;         /*!< (@ 0x000000A0) General PWM Timer Output Protection Function
                                        *                  Temporary Release Register                                 */

        struct
        {
            __IOM uint32_t SOTR : 1;   /*!< [0..0] Output Protection Function Temporary Release                       */
            uint32_t            : 31;
        } GTSOTR_b;
    };

    union
    {
        __IOM uint32_t GTADSMR;         /*!< (@ 0x000000A4) General PWM Timer A/D Conversion Start Request
                                         *                  Signal Monitoring Register                                 */

        struct
        {
            __IOM uint32_t ADSMS0  : 2; /*!< [1..0] A/D Conversion Start Request Signal Monitor 0 Selection            */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN0 : 1; /*!< [8..8] A/D Conversion Start Request Signal Monitor 0 Output
                                         *   Enabling                                                                  */
            uint32_t               : 7;
            __IOM uint32_t ADSMS1  : 2; /*!< [17..16] A/D Conversion Start Request Signal Monitor 1 Selection          */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN1 : 1; /*!< [24..24] A/D Conversion Start Request Signal Monitor 1 Output
                                         *   Enabling                                                                  */
            uint32_t : 7;
        } GTADSMR_b;
    };

    union
    {
        __IOM uint32_t GTEITC;            /*!< (@ 0x000000A8) General PWM Timer Extended Interrupt Skipping
                                           *                  Counter Control Register                                   */

        struct
        {
            __IOM uint32_t EIVTC1  : 2;   /*!< [1..0] Extended Interrupt Skipping Counter 1 Count Source Select          */
            uint32_t               : 2;
            __IOM uint32_t EIVTT1  : 4;   /*!< [7..4] Extended Interrupt Skipping 1 Skipping Count Setting               */
            uint32_t               : 4;
            __IM uint32_t  EITCNT1 : 4;   /*!< [15..12] Extended Interrupt Skipping Counter 1                            */
            __IOM uint32_t EIVTC2  : 2;   /*!< [17..16] Extended Interrupt Skipping Counter 2 Count Source
                                           *   select                                                                    */
            uint32_t                 : 2;
            __IOM uint32_t EIVTT2    : 4; /*!< [23..20] Extended Interrupt Skipping 2 Skipping Count Setting             */
            __IOM uint32_t EITCNT2IV : 4; /*!< [27..24] Extended Interrupt Skipping Counter 2 Initial Value              */
            __IM uint32_t  EITCNT2   : 4; /*!< [31..28] Extended Interrupt Skipping Counter 2                            */
        } GTEITC_b;
    };

    union
    {
        __IOM uint32_t GTEITLI1;       /*!< (@ 0x000000AC) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 1                                         */

        struct
        {
            __IOM uint32_t EITLA : 3;  /*!< [2..0] GTCCRA Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLB : 3;  /*!< [6..4] GTCCRB Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLC : 3;  /*!< [10..8] GTCCRC Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLD : 3;  /*!< [14..12] GTCCRD Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLE : 3;  /*!< [18..16] GTCCRE Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLF : 3;  /*!< [22..20] GTCCRF Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLV : 3;  /*!< [26..24] Overflow Interrupt Extended Skipping Function Select             */
            uint32_t             : 1;
            __IOM uint32_t EITLU : 3;  /*!< [30..28] Underflow Interrupt Extended Skipping Function Select            */
            uint32_t             : 1;
        } GTEITLI1_b;
    };

    union
    {
        __IOM uint32_t GTEITLI2;       /*!< (@ 0x000000B0) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 2                                         */

        struct
        {
            __IOM uint32_t EADTAL : 3; /*!< [2..0] GTADTRA Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t              : 1;
            __IOM uint32_t EADTBL : 3; /*!< [6..4] GTADTRB Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t : 25;
        } GTEITLI2_b;
    };

    union
    {
        __IOM uint32_t GTEITLB;         /*!< (@ 0x000000B4) General PWM Timer Extended Buffer Transfer Skipping
                                         *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t EBTLCA : 3;  /*!< [2..0] GTCCRA Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLCB : 3;  /*!< [6..4] GTCCRB Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLPR : 3;  /*!< [10..8] GTPR Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 5;
            __IOM uint32_t EBTLADA : 3; /*!< [18..16] GTADTRA Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLADB : 3; /*!< [22..20] GTADTRB Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVU : 3; /*!< [26..24] GTDVU Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVD : 3; /*!< [30..28] GTDVD Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t : 1;
        } GTEITLB_b;
    };

    union
    {
        __IOM uint32_t GTICLF;           /*!< (@ 0x000000B8) General PWM Timer Inter Channel Logical Operation
                                          *                  Function Setting Register                                  */

        struct
        {
            __IOM uint32_t ICLFA    : 3; /*!< [2..0] GTIOCnA Output Logical Operation Function Select                   */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELC : 6; /*!< [9..4] Inter Channel Signal C Select                                      */
            uint32_t                : 6;
            __IOM uint32_t ICLFB    : 3; /*!< [18..16] GTIOCnB Output Logical Operation Function Select                 */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELD : 6; /*!< [25..20] Inter Channel Signal D Select                                    */
            uint32_t                : 6;
        } GTICLF_b;
    };

    union
    {
        __IOM uint32_t GTPC;           /*!< (@ 0x000000BC) General PWM Timer Period Count Register                    */

        struct
        {
            __IOM uint32_t PCEN : 1;   /*!< [0..0] Period Count Function Enable                                       */
            uint32_t            : 7;
            __IOM uint32_t ASTP : 1;   /*!< [8..8] Automatic Stop Function Enable                                     */
            uint32_t            : 7;
            __IOM uint32_t PCNT : 12;  /*!< [27..16] Period Counter                                                   */
            uint32_t            : 4;
        } GTPC_b;
    };
    __IM uint32_t RESERVED[4];

    union
    {
        __IOM uint32_t GTSECSR;         /*!< (@ 0x000000D0) General PWM Timer Operation Enable Bit Simultaneous
                                         *                  Control Channel Select Register                            */

        struct
        {
            __IOM uint32_t SECSEL0 : 1; /*!< [0..0] Channel 0 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL1 : 1; /*!< [1..1] Channel 1 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL2 : 1; /*!< [2..2] Channel 2 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL3 : 1; /*!< [3..3] Channel 3 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL4 : 1; /*!< [4..4] Channel 4 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL5 : 1; /*!< [5..5] Channel 5 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL6 : 1; /*!< [6..6] Channel 6 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL7 : 1; /*!< [7..7] Channel 7 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL8 : 1; /*!< [8..8] Channel 8 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL9 : 1; /*!< [9..9] Channel 9 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            uint32_t : 22;
        } GTSECSR_b;
    };

    union
    {
        __IOM uint32_t GTSECR;         /*!< (@ 0x000000D4) General PWM Timer Operation Enable Bit Simultaneous
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t SBDCE : 1;  /*!< [0..0] GTCCR Register Buffer Operation Simultaneous Enable                */
            __IOM uint32_t SBDPE : 1;  /*!< [1..1] GTPR Register Buffer Operation Simultaneous Enable                 */
            __IOM uint32_t SBDAE : 1;  /*!< [2..2] GTADTR Register Buffer Operation Simultaneous Enable               */
            __IOM uint32_t SBDDE : 1;  /*!< [3..3] GTDV Register Buffer Operation Simultaneous Enable                 */
            uint32_t             : 4;
            __IOM uint32_t SBDCD : 1;  /*!< [8..8] GTCCR Register Buffer Operation Simultaneous Disable               */
            __IOM uint32_t SBDPD : 1;  /*!< [9..9] GTPR Register Buffer Operation Simultaneous Disable                */
            __IOM uint32_t SBDAD : 1;  /*!< [10..10] GTADTR Register Buffer Operation Simultaneous Disable            */
            __IOM uint32_t SBDDD : 1;  /*!< [11..11] GTDV Register Buffer Operation Simultaneous Disable              */
            uint32_t             : 4;
            __IOM uint32_t SPCE  : 1;  /*!< [16..16] Period Count Function Simultaneous Enable                        */
            __IOM uint32_t SSCE  : 1;  /*!< [17..17] Synchronous Set/Clear Simultaneous Enable                        */
            uint32_t             : 6;
            __IOM uint32_t SPCD  : 1;  /*!< [24..24] Period Count Function Simultaneous Disable                       */
            __IOM uint32_t SSCD  : 1;  /*!< [25..25] Synchronous Set/Clear Simultaneous Disable                       */
            uint32_t             : 6;
        } GTSECR_b;
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        __IOM uint32_t GTBER2;         /*!< (@ 0x000000E0) General PWM Timer Buffer Enable Register 2                 */

        struct
        {
            __IOM uint32_t CCTCA : 1;  /*!< [0..0] Counter Clear Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTCB : 1;  /*!< [1..1] Counter Clear Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTPR  : 1; /*!< [2..2] Counter Clear Source GTPR Register Buffer Transfer Disable         */
            __IOM uint32_t CCTADA : 1; /*!< [3..3] Counter Clear Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTADB : 1; /*!< [4..4] Counter Clear Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTDV : 1;  /*!< [5..5] Counter Clear Source GTDVU/GTDVD Register Buffer Transfer
                                        *   Disable                                                                   */
            uint32_t             : 2;
            __IOM uint32_t CMTCA : 2;  /*!< [9..8] Compare Match Source GTCCRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTCB : 2;  /*!< [11..10] Compare Match Source GTCCRB Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t              : 1;
            __IOM uint32_t CMTADA : 1; /*!< [13..13] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTADB : 1; /*!< [14..14] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t             : 1;
            __IOM uint32_t CPTCA : 1;  /*!< [16..16] Overflow/Underflow Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTCB : 1;  /*!< [17..17] Overflow/Underflow Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTPR : 1;  /*!< [18..18] Overflow/Underflow Source GTPR Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADA : 1; /*!< [19..19] Overflow/Underflow Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADB : 1; /*!< [20..20] Overflow/Underflow Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTDV : 1;  /*!< [21..21] Overflow/Underflow Source GTDVU/GTDVD Register Buffer
                                        *   Transfer Disable                                                          */
            uint32_t             : 2;
            __IOM uint32_t CP3DB : 1;  /*!< [24..24] Complementary PWM mode 3,4 Double Buffer select                  */
            __IOM uint32_t CPBTD : 1;  /*!< [25..25] Complementary PWM mode Buffer Transfer Disable                   */
            __IOM uint32_t OLTTA : 2;  /*!< [27..26] GTIOCnA Output Level Buffer Transfer Timing Select               */
            __IOM uint32_t OLTTB : 2;  /*!< [29..28] GTIOCnB Output Level Buffer Transfer Timing Select               */
            uint32_t             : 2;
        } GTBER2_b;
    };

    union
    {
        __IOM uint32_t GTOLBR;         /*!< (@ 0x000000E4) General PWM Timer Output Level Buffer Register             */

        struct
        {
            __IOM uint32_t GTIOAB : 5; /*!< [4..0] GTIOA buffer bits                                                  */
            uint32_t              : 11;
            __IOM uint32_t GTIOBB : 5; /*!< [20..16] GTIOBB buffer bits                                               */
            uint32_t              : 11;
        } GTOLBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t GTICCR;         /*!< (@ 0x000000EC) General PWM Timer Inter Channel Cooperation Input
                                        *                  Capture Control Register                                   */

        struct
        {
            __IOM uint32_t ICAFA : 1;  /*!< [0..0] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFB : 1;  /*!< [1..1] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFC : 1;  /*!< [2..2] Forwarding GTCCRC register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFD : 1;  /*!< [3..3] Forwarding GTCCRD register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFE : 1;  /*!< [4..4] Forwarding GTCCRE register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFF : 1;  /*!< [5..5] Forwarding GTCCRF register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFPO : 1; /*!< [6..6] Forwarding Overflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICAFPU : 1; /*!< [7..7] Forwarding Underflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICACLK : 1; /*!< [8..8] Forwarding Count Clock to Other Channel GTCCRA Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICAGRP : 2; /*!< [15..14] GTCCRA Input Capture Group Select                                */
            __IOM uint32_t ICBFA  : 1; /*!< [16..16] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFB : 1;  /*!< [17..17] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFC : 1;  /*!< [18..18] Forwarding GTCCRC register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFD : 1;  /*!< [19..19] Forwarding GTCCRD register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFE : 1;  /*!< [20..20] Forwarding GTCCRE register Compare Match Capture to
                                        *   Other Channel GTCCRb Input Capture Source Enable                          */
            __IOM uint32_t ICBFF : 1;  /*!< [21..21] Forwarding GTCCRF register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFPO : 1; /*!< [22..22] Forwarding Overflow to Other Channel GTCCRB Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICBFPU : 1; /*!< [23..23] Forwarding Underflow to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            __IOM uint32_t ICBCLK : 1; /*!< [24..24] Forwarding Count Clock to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICBGRP : 2; /*!< [31..30] GTCCRB Input Capture Group Select                                */
        } GTICCR_b;
    };
} R_GPT0_Type;                         /*!< Size = 240 (0xf0)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Output Phase Switching for GPT (R_GPT_OPS)
 */

typedef struct                         /*!< (@ 0x40078FF0) R_GPT_OPS Structure                                        */
{
    union
    {
        __IOM uint32_t OPSCR;          /*!< (@ 0x00000000) Output Phase Switching Control Register                    */

        struct
        {
            __IOM uint32_t UF : 1;     /*!< [0..0] Input Phase Soft Setting WFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t VF : 1;     /*!< [1..1] Input Phase Soft Setting VFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t WF : 1;     /*!< [2..2] Input Phase Soft Setting UFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            uint32_t        : 1;
            __IM uint32_t U : 1;       /*!< [4..4] Input U-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t V : 1;       /*!< [5..5] Input V-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t W : 1;       /*!< [6..6] Input W-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            uint32_t          : 1;
            __IOM uint32_t EN : 1;     /*!< [8..8] Enable-Phase Output Control                                        */
            uint32_t          : 7;
            __IOM uint32_t FB : 1;     /*!< [16..16] External Feedback Signal EnableThis bit selects the
                                        *   input phase from the software settings and external input.                */
            __IOM uint32_t P     : 1;  /*!< [17..17] Positive-Phase Output (P) Control                                */
            __IOM uint32_t N     : 1;  /*!< [18..18] Negative-Phase Output (N) Control                                */
            __IOM uint32_t INV   : 1;  /*!< [19..19] Invert-Phase Output Control                                      */
            __IOM uint32_t RV    : 1;  /*!< [20..20] Output phase rotation direction reversal                         */
            __IOM uint32_t ALIGN : 1;  /*!< [21..21] Input phase alignment                                            */
            uint32_t             : 2;
            __IOM uint32_t GRP   : 2;  /*!< [25..24] Output disabled source selection                                 */
            __IOM uint32_t GODF  : 1;  /*!< [26..26] Group output disable function                                    */
            uint32_t             : 2;
            __IOM uint32_t NFEN  : 1;  /*!< [29..29] External Input Noise Filter Enable                               */
            __IOM uint32_t NFCS  : 2;  /*!< [31..30] External Input Noise Filter Clock selectionNoise filter
                                        *   sampling clock setting of the external input.                             */
        } OPSCR_b;
    };
} R_GPT_OPS_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief Port Output Enable for GPT (R_GPT_POEG0)
 */

typedef struct                         /*!< (@ 0x40042000) R_GPT_POEG0 Structure                                      */
{
    union
    {
        __IOM uint32_t POEGG;          /*!< (@ 0x00000000) POEG Group Setting Register                                */

        struct
        {
            __IOM uint32_t PIDF  : 1;  /*!< [0..0] Port Input Detection Flag                                          */
            __IOM uint32_t IOCF  : 1;  /*!< [1..1] Real Time Overcurrent Detection Flag                               */
            __IOM uint32_t OSTPF : 1;  /*!< [2..2] Oscillation Stop Detection Flag                                    */
            __IOM uint32_t SSF   : 1;  /*!< [3..3] Software Stop Flag                                                 */
            __IOM uint32_t PIDE  : 1;  /*!< [4..4] Port Input Detection EnableNote: Can be modified only
                                        *   once after a reset.                                                       */
            __IOM uint32_t IOCE : 1;   /*!< [5..5] Enable for GPT Output-Disable RequestNote: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t OSTPE : 1;  /*!< [6..6] Oscillation Stop Detection EnableNote: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t             : 1;
            __IOM uint32_t CDRE0 : 1;  /*!< [8..8] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE1 : 1;  /*!< [9..9] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE2 : 1;  /*!< [10..10] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE3 : 1;  /*!< [11..11] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE4 : 1;  /*!< [12..12] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE5 : 1;  /*!< [13..13] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t            : 2;
            __IM uint32_t ST    : 1;   /*!< [16..16] GTETRG Input Status Flag                                         */
            uint32_t            : 11;
            __IOM uint32_t INV  : 1;   /*!< [28..28] GTETRG Input Reverse                                             */
            __IOM uint32_t NFEN : 1;   /*!< [29..29] Noise Filter Enable                                              */
            __IOM uint32_t NFCS : 2;   /*!< [31..30] Noise Filter Clock Select                                        */
        } POEGG_b;
    };
} R_GPT_POEG0_Type;                    /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Interrupt Controller Unit (R_ICU)
 */

typedef struct                         /*!< (@ 0x40006000) R_ICU Structure                                            */
{
    union
    {
        __IOM uint8_t IRQCR[16];       /*!< (@ 0x00000000) IRQ Control Register [0..15]                               */

        struct
        {
            __IOM uint8_t IRQMD   : 2; /*!< [1..0] IRQ Detection Sense Select                                         */
            uint8_t               : 2;
            __IOM uint8_t FCLKSEL : 2; /*!< [5..4] IRQ Digital Filter Sampling Clock Select                           */
            uint8_t               : 1;
            __IOM uint8_t FLTEN   : 1; /*!< [7..7] IRQ Digital Filter Enable                                          */
        } IRQCR_b[16];
    };
    __IM uint32_t RESERVED[60];

    union
    {
        __IOM uint8_t NMICR;            /*!< (@ 0x00000100) NMI Pin Interrupt Control Register                         */

        struct
        {
            __IOM uint8_t NMIMD    : 1; /*!< [0..0] NMI Detection Set                                                  */
            uint8_t                : 3;
            __IOM uint8_t NFCLKSEL : 2; /*!< [5..4] NMI Digital Filter Sampling Clock Select                           */
            uint8_t                : 1;
            __IOM uint8_t NFLTEN   : 1; /*!< [7..7] NMI Digital Filter Enable                                          */
        } NMICR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[7];

    union
    {
        __IOM uint16_t NMIER;           /*!< (@ 0x00000120) Non-Maskable Interrupt Enable Register                     */

        struct
        {
            __IOM uint16_t IWDTEN  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Interrupt Enable                      */
            __IOM uint16_t WDTEN   : 1; /*!< [1..1] WDT Underflow/Refresh Error Interrupt Enable                       */
            __IOM uint16_t LVD1EN  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Enable                              */
            __IOM uint16_t LVD2EN  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Enable                              */
            __IOM uint16_t VBATTEN : 1; /*!< [4..4] VBATT monitor Interrupt Enable                                     */
            uint16_t               : 1;
            __IOM uint16_t OSTEN   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Enable                        */
            __IOM uint16_t NMIEN   : 1; /*!< [7..7] NMI Pin Interrupt Enable                                           */
            __IOM uint16_t RPEEN   : 1; /*!< [8..8] RAM Parity Error Interrupt Enable                                  */
            __IOM uint16_t RECCEN  : 1; /*!< [9..9] RAM ECC Error Interrupt Enable                                     */
            __IOM uint16_t BUSSEN  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Enable                             */
            __IOM uint16_t BUSMEN  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Enable                            */
            __IOM uint16_t SPEEN   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Enable                       */
            __IOM uint16_t TZFEN   : 1; /*!< [13..13] TZFEN                                                            */
            uint16_t               : 1;
            __IOM uint16_t CPEEN   : 1; /*!< [15..15] CPEEN                                                            */
        } NMIER_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[3];

    union
    {
        __IOM uint16_t NMICLR;          /*!< (@ 0x00000130) Non-Maskable Interrupt Status Clear Register               */

        struct
        {
            __OM uint16_t IWDTCLR  : 1; /*!< [0..0] IWDT Clear                                                         */
            __OM uint16_t WDTCLR   : 1; /*!< [1..1] WDT Clear                                                          */
            __OM uint16_t LVD1CLR  : 1; /*!< [2..2] LVD1 Clear                                                         */
            __OM uint16_t LVD2CLR  : 1; /*!< [3..3] LVD2 Clear                                                         */
            __OM uint16_t VBATTCLR : 1; /*!< [4..4] VBATT Clear                                                        */
            uint16_t               : 1;
            __OM uint16_t  OSTCLR  : 1; /*!< [6..6] OST Clear                                                          */
            __OM uint16_t  NMICLR  : 1; /*!< [7..7] NMI Clear                                                          */
            __OM uint16_t  RPECLR  : 1; /*!< [8..8] SRAM Parity Error Clear                                            */
            __OM uint16_t  RECCCLR : 1; /*!< [9..9] SRAM ECC Error Clear                                               */
            __OM uint16_t  BUSSCLR : 1; /*!< [10..10] Bus Slave Error Clear                                            */
            __OM uint16_t  BUSMCLR : 1; /*!< [11..11] Bus Master Error Clear                                           */
            __OM uint16_t  SPECLR  : 1; /*!< [12..12] CPU Stack Pointer Monitor Interrupt Clear                        */
            __IOM uint16_t TZFCLR  : 1; /*!< [13..13] TZFCLR                                                           */
            uint16_t               : 1;
            __IOM uint16_t CPECLR  : 1; /*!< [15..15] CPECLR                                                           */
        } NMICLR_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IM uint16_t NMISR;           /*!< (@ 0x00000140) Non-Maskable Interrupt Status Register                     */

        struct
        {
            __IM uint16_t IWDTST  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Status Flag                           */
            __IM uint16_t WDTST   : 1; /*!< [1..1] WDT Underflow/Refresh Error Status Flag                            */
            __IM uint16_t LVD1ST  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Status Flag                         */
            __IM uint16_t LVD2ST  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Status Flag                         */
            __IM uint16_t VBATTST : 1; /*!< [4..4] VBATT monitor Interrupt Status Flag                                */
            uint16_t              : 1;
            __IM uint16_t OSTST   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Status Flag                   */
            __IM uint16_t NMIST   : 1; /*!< [7..7] NMI Status Flag                                                    */
            __IM uint16_t RPEST   : 1; /*!< [8..8] RAM Parity Error Interrupt Status Flag                             */
            __IM uint16_t RECCST  : 1; /*!< [9..9] RAM ECC Error Interrupt Status Flag                                */
            __IM uint16_t BUSSST  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Status Flag                        */
            __IM uint16_t BUSMST  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Status Flag                       */
            __IM uint16_t SPEST   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Status Flag                  */
            __IM uint16_t TZFST   : 1; /*!< [13..13] TZFST                                                            */
            uint16_t              : 1;
            __IM uint16_t CPEST   : 1; /*!< [15..15] CPEST                                                            */
        } NMISR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[23];

    union
    {
        __IOM uint32_t WUPEN;                /*!< (@ 0x000001A0) Wake Up Interrupt Enable Register                          */

        struct
        {
            __IOM uint32_t IRQWUPEN0    : 1; /*!< [0..0] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN1    : 1; /*!< [1..1] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN2    : 1; /*!< [2..2] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN3    : 1; /*!< [3..3] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN4    : 1; /*!< [4..4] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN5    : 1; /*!< [5..5] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN6    : 1; /*!< [6..6] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN7    : 1; /*!< [7..7] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN8    : 1; /*!< [8..8] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN9    : 1; /*!< [9..9] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN10   : 1; /*!< [10..10] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN11   : 1; /*!< [11..11] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN12   : 1; /*!< [12..12] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN13   : 1; /*!< [13..13] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN14   : 1; /*!< [14..14] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN15   : 1; /*!< [15..15] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IWDTWUPEN    : 1; /*!< [16..16] IWDT interrupt S/W standby returns enable                        */
            __IOM uint32_t KEYWUPEN     : 1; /*!< [17..17] Key interrupt S/W standby returns enable                         */
            __IOM uint32_t LVD1WUPEN    : 1; /*!< [18..18] LVD1 interrupt S/W standby returns enable                        */
            __IOM uint32_t LVD2WUPEN    : 1; /*!< [19..19] LVD2 interrupt S/W standby returns enable                        */
            __IOM uint32_t VBATTWUPEN   : 1; /*!< [20..20] VBATT monitor interrupt S/W standby returns enable               */
            uint32_t                    : 1;
            __IOM uint32_t ACMPHS0WUPEN : 1; /*!< [22..22] ACMPHS0 interrupt S/W standby returns enable bit                 */
            __IOM uint32_t ACMPLP0WUPEN : 1; /*!< [23..23] ACMPLP0 interrupt S/W standby returns enable                     */
            __IOM uint32_t RTCALMWUPEN  : 1; /*!< [24..24] RTC alarm interrupt S/W standby returns enable                   */
            __IOM uint32_t RTCPRDWUPEN  : 1; /*!< [25..25] RCT period interrupt S/W standby returns enable                  */
            __IOM uint32_t USBHSWUPEN   : 1; /*!< [26..26] USBHS interrupt S/W standby returns enable bit                   */
            __IOM uint32_t USBFSWUPEN   : 1; /*!< [27..27] USBFS interrupt S/W standby returns enable                       */
            __IOM uint32_t AGT1UDWUPEN  : 1; /*!< [28..28] AGT1 underflow interrupt S/W standby returns enable              */
            __IOM uint32_t AGT1CAWUPEN  : 1; /*!< [29..29] AGT1 compare match A interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t AGT1CBWUPEN : 1;  /*!< [30..30] AGT1 compare match B interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t IIC0WUPEN : 1;    /*!< [31..31] IIC0 address match interrupt S/W standby returns enable          */
        } WUPEN_b;
    };

    union
    {
        __IOM uint32_t WUPEN1;              /*!< (@ 0x000001A4) Wake Up interrupt enable register 1                        */

        struct
        {
            __IOM uint32_t AGT3UDWUPEN : 1; /*!< [0..0] AGT3 underflow interrupt S/W standby returns enable bit            */
            __IOM uint32_t AGT3CAWUPEN : 1; /*!< [1..1] AGT3 compare match A interrupt S/W standby returns enable
                                             *   bit                                                                       */
            __IOM uint32_t AGT3CBWUPEN : 1; /*!< [2..2] AGT3 compare match B interrupt S/W standby returns enable
                                             *   bit                                                                       */
            uint32_t : 29;
        } WUPEN1_b;
    };
    __IM uint32_t RESERVED10[6];

    union
    {
        __IOM uint8_t IELEN;            /*!< (@ 0x000001C0) ICU event Enable Register                                  */

        struct
        {
            __IOM uint8_t RTCINTEN : 1; /*!< [0..0] RTCALM and RTCPRD Interrupts Enable (when LPOPTEN bit
                                         *   = 1)                                                                      */
            __IOM uint8_t IELEN : 1;    /*!< [1..1] Parts Asynchronous Interrupts Enable except RTC (when
                                         *   LPOPTEN bit = 1)                                                          */
            uint8_t : 6;
        } IELEN_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13[15];

    union
    {
        __IOM uint16_t SELSR0;         /*!< (@ 0x00000200) Snooze Event Link Setting Register                         */

        struct
        {
            __IOM uint16_t SELS : 9;   /*!< [8..0] SYS Event Link Select                                              */
            uint16_t            : 7;
        } SELSR0_b;
    };
    __IM uint16_t RESERVED14;
    __IM uint32_t RESERVED15[31];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000280) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] Event selection to DMAC Start request                              */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
    __IM uint32_t RESERVED16[24];

    union
    {
        __IOM uint32_t IELSR[96];      /*!< (@ 0x00000300) ICU Event Link Setting Register [0..95]                    */

        struct
        {
            __IOM uint32_t IELS : 9;   /*!< [8..0] ICU Event selection to NVICSet the number for the event
                                        *   signal to be linked .                                                     */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag                                            */
            uint32_t            : 7;
            __IOM uint32_t DTCE : 1;   /*!< [24..24] DTC Activation Enable                                            */
            uint32_t            : 7;
        } IELSR_b[96];
    };
} R_ICU_Type;                          /*!< Size = 1152 (0x480)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I2C Bus Interface (R_IIC0)
 */

typedef struct                         /*!< (@ 0x40053000) R_IIC0 Structure                                           */
{
    union
    {
        __IOM uint8_t ICCR1;           /*!< (@ 0x00000000) I2C Bus Control Register 1                                 */

        struct
        {
            __IM uint8_t  SDAI   : 1;  /*!< [0..0] SDA Line Monitor                                                   */
            __IM uint8_t  SCLI   : 1;  /*!< [1..1] SCL Line Monitor                                                   */
            __IOM uint8_t SDAO   : 1;  /*!< [2..2] SDA Output Control/Monitor                                         */
            __IOM uint8_t SCLO   : 1;  /*!< [3..3] SCL Output Control/Monitor                                         */
            __IOM uint8_t SOWP   : 1;  /*!< [4..4] SCLO/SDAO Write Protect                                            */
            __IOM uint8_t CLO    : 1;  /*!< [5..5] Extra SCL Clock Cycle Output                                       */
            __IOM uint8_t IICRST : 1;  /*!< [6..6] I2C Bus Interface Internal ResetNote:If an internal reset
                                        *   is initiated using the IICRST bit for a bus hang-up occurred
                                        *   during communication with the master device in slave mode,
                                        *   the states may become different between the slave device
                                        *   and the master device (due to the difference in the bit
                                        *   counter information).                                                     */
            __IOM uint8_t ICE : 1;     /*!< [7..7] I2C Bus Interface Enable                                           */
        } ICCR1_b;
    };

    union
    {
        __IOM uint8_t ICCR2;           /*!< (@ 0x00000001) I2C Bus Control Register 2                                 */

        struct
        {
            uint8_t          : 1;
            __IOM uint8_t ST : 1;      /*!< [1..1] Start Condition Issuance RequestSet the ST bit to 1 (start
                                        *   condition issuance request) when the BBSY flag is set to
                                        *   0 (bus free state).                                                       */
            __IOM uint8_t RS : 1;      /*!< [2..2] Restart Condition Issuance RequestNote: Do not set the
                                        *   RS bit to 1 while issuing a stop condition.                               */
            __IOM uint8_t SP : 1;      /*!< [3..3] Stop Condition Issuance RequestNote: Writing to the SP
                                        *   bit is not possible while the setting of the BBSY flag
                                        *   is 0 (bus free state).Note: Do not set the SP bit to 1
                                        *   while a restart condition is being issued.                                */
            uint8_t            : 1;
            __IOM uint8_t TRS  : 1;    /*!< [5..5] Transmit/Receive Mode                                              */
            __IOM uint8_t MST  : 1;    /*!< [6..6] Master/Slave Mode                                                  */
            __IM uint8_t  BBSY : 1;    /*!< [7..7] Bus Busy Detection Flag                                            */
        } ICCR2_b;
    };

    union
    {
        __IOM uint8_t ICMR1;           /*!< (@ 0x00000002) I2C Bus Mode Register 1                                    */

        struct
        {
            __IOM uint8_t BC   : 3;    /*!< [2..0] Bit Counter                                                        */
            __OM uint8_t  BCWP : 1;    /*!< [3..3] BC Write Protect(This bit is read as 1.)                           */
            __IOM uint8_t CKS  : 3;    /*!< [6..4] Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB
                                        *   / 2^CKS )                                                                 */
            __IOM uint8_t MTWP : 1;    /*!< [7..7] MST/TRS Write Protect                                              */
        } ICMR1_b;
    };

    union
    {
        __IOM uint8_t ICMR2;           /*!< (@ 0x00000003) I2C Bus Mode Register 2                                    */

        struct
        {
            __IOM uint8_t TMOS : 1;    /*!< [0..0] Timeout Detection Time Select                                      */
            __IOM uint8_t TMOL : 1;    /*!< [1..1] Timeout L Count Control                                            */
            __IOM uint8_t TMOH : 1;    /*!< [2..2] Timeout H Count Control                                            */
            uint8_t            : 1;
            __IOM uint8_t SDDL : 3;    /*!< [6..4] SDA Output Delay Counter                                           */
            __IOM uint8_t DLCS : 1;    /*!< [7..7] SDA Output Delay Clock Source Select                               */
        } ICMR2_b;
    };

    union
    {
        __IOM uint8_t ICMR3;           /*!< (@ 0x00000004) I2C Bus Mode Register 3                                    */

        struct
        {
            __IOM uint8_t NF    : 2;   /*!< [1..0] Noise Filter Stage Selection                                       */
            __IM uint8_t  ACKBR : 1;   /*!< [2..2] Receive Acknowledge                                                */
            __IOM uint8_t ACKBT : 1;   /*!< [3..3] Transmit Acknowledge                                               */
            __IOM uint8_t ACKWP : 1;   /*!< [4..4] ACKBT Write Protect                                                */
            __IOM uint8_t RDRFS : 1;   /*!< [5..5] RDRF Flag Set Timing Selection                                     */
            __IOM uint8_t WAIT  : 1;   /*!< [6..6] WAITNote: When the value of the WAIT bit is to be read,
                                        *   be sure to read the ICDRR beforehand.                                     */
            __IOM uint8_t SMBS : 1;    /*!< [7..7] SMBus/I2C Bus Selection                                            */
        } ICMR3_b;
    };

    union
    {
        __IOM uint8_t ICFER;           /*!< (@ 0x00000005) I2C Bus Function Enable Register                           */

        struct
        {
            __IOM uint8_t TMOE  : 1;   /*!< [0..0] Timeout Function Enable                                            */
            __IOM uint8_t MALE  : 1;   /*!< [1..1] Master Arbitration-Lost Detection Enable                           */
            __IOM uint8_t NALE  : 1;   /*!< [2..2] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint8_t SALE  : 1;   /*!< [3..3] Slave Arbitration-Lost Detection Enable                            */
            __IOM uint8_t NACKE : 1;   /*!< [4..4] NACK Reception Transfer Suspension Enable                          */
            __IOM uint8_t NFE   : 1;   /*!< [5..5] Digital Noise Filter Circuit Enable                                */
            __IOM uint8_t SCLE  : 1;   /*!< [6..6] SCL Synchronous Circuit Enable                                     */
            __IOM uint8_t FMPE  : 1;   /*!< [7..7] Fast-mode Plus Enable                                              */
        } ICFER_b;
    };

    union
    {
        __IOM uint8_t ICSER;           /*!< (@ 0x00000006) I2C Bus Status Enable Register                             */

        struct
        {
            __IOM uint8_t SAR0E : 1;   /*!< [0..0] Slave Address Register 0 Enable                                    */
            __IOM uint8_t SAR1E : 1;   /*!< [1..1] Slave Address Register 1 Enable                                    */
            __IOM uint8_t SAR2E : 1;   /*!< [2..2] Slave Address Register 2 Enable                                    */
            __IOM uint8_t GCAE  : 1;   /*!< [3..3] General Call Address Enable                                        */
            uint8_t             : 1;
            __IOM uint8_t DIDE  : 1;   /*!< [5..5] Device-ID Address Detection Enable                                 */
            uint8_t             : 1;
            __IOM uint8_t HOAE  : 1;   /*!< [7..7] Host Address Enable                                                */
        } ICSER_b;
    };

    union
    {
        __IOM uint8_t ICIER;           /*!< (@ 0x00000007) I2C Bus Interrupt Enable Register                          */

        struct
        {
            __IOM uint8_t TMOIE : 1;   /*!< [0..0] Timeout Interrupt Request Enable                                   */
            __IOM uint8_t ALIE  : 1;   /*!< [1..1] Arbitration-Lost Interrupt Request Enable                          */
            __IOM uint8_t STIE  : 1;   /*!< [2..2] Start Condition Detection Interrupt Request Enable                 */
            __IOM uint8_t SPIE  : 1;   /*!< [3..3] Stop Condition Detection Interrupt Request Enable                  */
            __IOM uint8_t NAKIE : 1;   /*!< [4..4] NACK Reception Interrupt Request Enable                            */
            __IOM uint8_t RIE   : 1;   /*!< [5..5] Receive Data Full Interrupt Request Enable                         */
            __IOM uint8_t TEIE  : 1;   /*!< [6..6] Transmit End Interrupt Request Enable                              */
            __IOM uint8_t TIE   : 1;   /*!< [7..7] Transmit Data Empty Interrupt Request Enable                       */
        } ICIER_b;
    };

    union
    {
        __IOM uint8_t ICSR1;           /*!< (@ 0x00000008) I2C Bus Status Register 1                                  */

        struct
        {
            __IOM uint8_t AAS0 : 1;    /*!< [0..0] Slave Address 0 Detection Flag                                     */
            __IOM uint8_t AAS1 : 1;    /*!< [1..1] Slave Address 1 Detection Flag                                     */
            __IOM uint8_t AAS2 : 1;    /*!< [2..2] Slave Address 2 Detection Flag                                     */
            __IOM uint8_t GCA  : 1;    /*!< [3..3] General Call Address Detection Flag                                */
            uint8_t            : 1;
            __IOM uint8_t DID  : 1;    /*!< [5..5] Device-ID Address Detection Flag                                   */
            uint8_t            : 1;
            __IOM uint8_t HOA  : 1;    /*!< [7..7] Host Address Detection Flag                                        */
        } ICSR1_b;
    };

    union
    {
        __IOM uint8_t ICSR2;           /*!< (@ 0x00000009) I2C Bus Status Register 2                                  */

        struct
        {
            __IOM uint8_t TMOF  : 1;   /*!< [0..0] Timeout Detection Flag                                             */
            __IOM uint8_t AL    : 1;   /*!< [1..1] Arbitration-Lost Flag                                              */
            __IOM uint8_t START : 1;   /*!< [2..2] Start Condition Detection Flag                                     */
            __IOM uint8_t STOP  : 1;   /*!< [3..3] Stop Condition Detection Flag                                      */
            __IOM uint8_t NACKF : 1;   /*!< [4..4] NACK Detection Flag                                                */
            __IOM uint8_t RDRF  : 1;   /*!< [5..5] Receive Data Full Flag                                             */
            __IOM uint8_t TEND  : 1;   /*!< [6..6] Transmit End Flag                                                  */
            __IM uint8_t  TDRE  : 1;   /*!< [7..7] Transmit Data Empty Flag                                           */
        } ICSR2_b;
    };
    __IOM R_IIC0_SAR_Type SAR[3];      /*!< (@ 0x0000000A) Slave Address Registers                                    */

    union
    {
        __IOM uint8_t ICBRL;           /*!< (@ 0x00000010) I2C Bus Bit Rate Low-Level Register                        */

        struct
        {
            __IOM uint8_t BRL : 5;     /*!< [4..0] Bit Rate Low-Level Period(Low-level period of SCL clock)           */
            uint8_t           : 3;
        } ICBRL_b;
    };

    union
    {
        __IOM uint8_t ICBRH;           /*!< (@ 0x00000011) I2C Bus Bit Rate High-Level Register                       */

        struct
        {
            __IOM uint8_t BRH : 5;     /*!< [4..0] Bit Rate High-Level Period(High-level period of SCL clock)         */
            uint8_t           : 3;
        } ICBRH_b;
    };

    union
    {
        __IOM uint8_t ICDRT;           /*!< (@ 0x00000012) I2C Bus Transmit Data Register                             */

        struct
        {
            __IOM uint8_t ICDRT : 8;   /*!< [7..0] 8-bit read-write register that stores transmit data.               */
        } ICDRT_b;
    };

    union
    {
        __IM uint8_t ICDRR;            /*!< (@ 0x00000013) I2C Bus Receive Data Register                              */

        struct
        {
            __IM uint8_t ICDRR : 8;    /*!< [7..0] 8-bit register that stores the received data                       */
        } ICDRR_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t ICWUR;           /*!< (@ 0x00000016) I2C Bus Wake Up Unit Register                              */

        struct
        {
            __IOM uint8_t WUAFA : 1;   /*!< [0..0] Wakeup Analog Filter Additional Selection                          */
            uint8_t             : 3;
            __IOM uint8_t WUACK : 1;   /*!< [4..4] ACK bit for Wakeup Mode                                            */
            __IOM uint8_t WUF   : 1;   /*!< [5..5] Wakeup Event Occurrence Flag                                       */
            __IOM uint8_t WUIE  : 1;   /*!< [6..6] Wakeup Interrupt Request Enable                                    */
            __IOM uint8_t WUE   : 1;   /*!< [7..7] Wakeup Function Enable                                             */
        } ICWUR_b;
    };

    union
    {
        __IOM uint8_t ICWUR2;          /*!< (@ 0x00000017) I2C Bus Wake up Unit Register 2                            */

        struct
        {
            __IM uint8_t WUSEN  : 1;   /*!< [0..0] Wake-up Function Synchronous Enable                                */
            __IM uint8_t WUASYF : 1;   /*!< [1..1] Wake-up Function Asynchronous Operation Status Flag                */
            __IM uint8_t WUSYF  : 1;   /*!< [2..2] Wake-up Function Synchronous Operation Status Flag                 */
            uint8_t             : 5;
        } ICWUR2_b;
    };
} R_IIC0_Type;                         /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Independent Watchdog Timer (R_IWDT)
 */

typedef struct                         /*!< (@ 0x40044400) R_IWDT Structure                                           */
{
    union
    {
        __IOM uint8_t IWDTRR;          /*!< (@ 0x00000000) IWDT Refresh Register                                      */

        struct
        {
            __IOM uint8_t IWDTRR : 8;  /*!< [7..0] The counter is refreshed by writing 0x00 and then writing
                                        *   0xFF to this register.                                                    */
        } IWDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t IWDTCR;         /*!< (@ 0x00000002) IWDT Control Register                                      */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } IWDTCR_b;
    };

    union
    {
        __IOM uint16_t IWDTSR;          /*!< (@ 0x00000004) IWDT Status Register                                       */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } IWDTSR_b;
    };

    union
    {
        __IOM uint8_t IWDTRCR;         /*!< (@ 0x00000006) IWDT Reset Control Register                                */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } IWDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t IWDTCSTPR;       /*!< (@ 0x00000008) IWDT Count Stop Control Register                           */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } IWDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_IWDT_Type;                         /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_KINT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Key Interrupt Function (R_KINT)
 */

typedef struct                         /*!< (@ 0x40080000) R_KINT Structure                                           */
{
    union
    {
        __IOM uint8_t KRCTL;           /*!< (@ 0x00000000) KEY Return Control Register                                */

        struct
        {
            __IOM uint8_t KREG : 1;    /*!< [0..0] Detection Edge Selection (KRF0 to KRF7)                            */
            uint8_t            : 6;
            __IOM uint8_t KRMD : 1;    /*!< [7..7] Usage of Key Interrupt Flags(KR0 to KR7)                           */
        } KRCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t KRF;             /*!< (@ 0x00000004) KEY Return Flag Register                                   */

        struct
        {
            __IOM uint8_t KRF0 : 1;    /*!< [0..0] Key interrupt flag 0                                               */
            __IOM uint8_t KRF1 : 1;    /*!< [1..1] Key interrupt flag 1                                               */
            __IOM uint8_t KRF2 : 1;    /*!< [2..2] Key interrupt flag 2                                               */
            __IOM uint8_t KRF3 : 1;    /*!< [3..3] Key interrupt flag 3                                               */
            __IOM uint8_t KRF4 : 1;    /*!< [4..4] Key interrupt flag 4                                               */
            __IOM uint8_t KRF5 : 1;    /*!< [5..5] Key interrupt flag 5                                               */
            __IOM uint8_t KRF6 : 1;    /*!< [6..6] Key interrupt flag 6                                               */
            __IOM uint8_t KRF7 : 1;    /*!< [7..7] Key interrupt flag 7                                               */
        } KRF_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t KRM;             /*!< (@ 0x00000008) KEY Return Mode Register                                   */

        struct
        {
            __IOM uint8_t KRM0 : 1;    /*!< [0..0] Key interrupt mode control 0                                       */
            __IOM uint8_t KRM1 : 1;    /*!< [1..1] Key interrupt mode control 1                                       */
            __IOM uint8_t KRM2 : 1;    /*!< [2..2] Key interrupt mode control 2                                       */
            __IOM uint8_t KRM3 : 1;    /*!< [3..3] Key interrupt mode control 3                                       */
            __IOM uint8_t KRM4 : 1;    /*!< [4..4] Key interrupt mode control 4                                       */
            __IOM uint8_t KRM5 : 1;    /*!< [5..5] Key interrupt mode control 5                                       */
            __IOM uint8_t KRM6 : 1;    /*!< [6..6] Key interrupt mode control 6                                       */
            __IOM uint8_t KRM7 : 1;    /*!< [7..7] Key interrupt mode control 7                                       */
        } KRM_b;
    };
} R_KINT_Type;                         /*!< Size = 9 (0x9)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_I3C0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I3C Bus Interface (R_I3C0)
 */

typedef struct                         /*!< (@ 0x40083000) R_I3C0 Structure                                           */
{
    union
    {
        __IOM uint32_t PRTS;           /*!< (@ 0x00000000) Protocol Selection Register                                */

        struct
        {
            __IOM uint32_t PRTMD : 1;  /*!< [0..0] Protocol Mode                                                      */
            uint32_t             : 31;
        } PRTS_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t CECTL;          /*!< (@ 0x00000010) Clock Enable Control Resisters                             */

        struct
        {
            __IOM uint32_t CLKE : 1;   /*!< [0..0] Clock Enable                                                       */
            uint32_t            : 31;
        } CECTL_b;
    };

    union
    {
        __IOM uint32_t BCTL;             /*!< (@ 0x00000014) Bus Control Register                                       */

        struct
        {
            __IOM uint32_t INCBA    : 1; /*!< [0..0] Include I3C Broadcast Address                                      */
            uint32_t                : 6;
            __IOM uint32_t BMDS     : 1; /*!< [7..7] Bus Mode Selection                                                 */
            __IOM uint32_t HJACKCTL : 1; /*!< [8..8] Hot-Join Acknowledge Control                                       */
            uint32_t                : 20;
            __IOM uint32_t ABT      : 1; /*!< [29..29] Abort                                                            */
            __IOM uint32_t RSM      : 1; /*!< [30..30] Resume                                                           */
            __IOM uint32_t BUSE     : 1; /*!< [31..31] Bus Enable                                                       */
        } BCTL_b;
    };

    union
    {
        __IOM uint32_t MSDVAD;         /*!< (@ 0x00000018) Master Device Address Register                             */

        struct
        {
            uint32_t              : 16;
            __IOM uint32_t MDYAD  : 7; /*!< [22..16] Master Dynamic Address                                           */
            uint32_t              : 8;
            __IOM uint32_t MDYADV : 1; /*!< [31..31] Master Dynamic Address Valid                                     */
        } MSDVAD_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t RSTCTL;          /*!< (@ 0x00000020) Reset Control Register                                     */

        struct
        {
            __IOM uint32_t RI3CRST : 1; /*!< [0..0] I3C Software Reset                                                 */
            __IOM uint32_t CMDQRST : 1; /*!< [1..1] Command Queue Software Reset                                       */
            __IOM uint32_t RSPQRST : 1; /*!< [2..2] Response Queue Software Reset                                      */
            __IOM uint32_t TDBRST  : 1; /*!< [3..3] Transmit Data Buffer Software Reset                                */
            __IOM uint32_t RDBRST  : 1; /*!< [4..4] Receive Data Buffer Software Reset                                 */
            __IOM uint32_t IBIQRST : 1; /*!< [5..5] IBI Queue Software Reset                                           */
            __IOM uint32_t RSQRST  : 1; /*!< [6..6] Receive Status Queue Software Reset                                */
            uint32_t               : 9;
            __IOM uint32_t INTLRST : 1; /*!< [16..16] Internal Software Reset                                          */
            uint32_t               : 15;
        } RSTCTL_b;
    };

    union
    {
        __IOM uint32_t PRSST;          /*!< (@ 0x00000024) Present State Register                                     */

        struct
        {
            uint32_t              : 2;
            __IOM uint32_t CRMS   : 1; /*!< [2..2] Current Master                                                     */
            uint32_t              : 1;
            __IM uint32_t TRMD    : 1; /*!< [4..4] Transmit/Receive Mode                                              */
            uint32_t              : 2;
            __OM uint32_t PRSSTWP : 1; /*!< [7..7] Present State Write Protect                                        */
            uint32_t              : 24;
        } PRSST_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t INST;           /*!< (@ 0x00000030) Internal Status Register                                   */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEF : 1;   /*!< [10..10] Internal Error Flag                                              */
            uint32_t            : 21;
        } INST_b;
    };

    union
    {
        __IOM uint32_t INSTE;          /*!< (@ 0x00000034) Internal Status Enable Register                            */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEE : 1;   /*!< [10..10] Internal Error Enable                                            */
            uint32_t            : 21;
        } INSTE_b;
    };

    union
    {
        __IOM uint32_t INIE;           /*!< (@ 0x00000038) Internal Interrupt Enable Register                         */

        struct
        {
            uint32_t             : 10;
            __IOM uint32_t INEIE : 1;  /*!< [10..10] Internal Error Interrupt Enable                                  */
            uint32_t             : 21;
        } INIE_b;
    };

    union
    {
        __IOM uint32_t INSTFC;         /*!< (@ 0x0000003C) Internal Status Force Register                             */

        struct
        {
            uint32_t            : 10;
            __OM uint32_t INEFC : 1;   /*!< [10..10] Internal Error Force                                             */
            uint32_t            : 21;
        } INSTFC_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IM uint32_t DVCT;            /*!< (@ 0x00000044) Device Characteristic Table Register                       */

        struct
        {
            uint32_t          : 19;
            __IM uint32_t IDX : 5;     /*!< [23..19] DCT Table Index                                                  */
            uint32_t          : 8;
        } DVCT_b;
    };
    __IM uint32_t RESERVED4[4];

    union
    {
        __IOM uint32_t IBINCTL;          /*!< (@ 0x00000058) IBI Notify Control Register                                */

        struct
        {
            __IOM uint32_t NRHJCTL  : 1; /*!< [0..0] Notify Rejected Hot-Join Control                                   */
            __IOM uint32_t NRMRCTL  : 1; /*!< [1..1] Notify Rejected Master Request Control                             */
            uint32_t                : 1;
            __IOM uint32_t NRSIRCTL : 1; /*!< [3..3] Notify Rejected Slave Interrupt Request Control                    */
            uint32_t                : 28;
        } IBINCTL_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t BFCTL;          /*!< (@ 0x00000060) Bus Function Control Register                              */

        struct
        {
            __IOM uint32_t MALE   : 1; /*!< [0..0] Master Arbitration-Lost Detection Enable                           */
            __IOM uint32_t NALE   : 1; /*!< [1..1] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint32_t SALE   : 1; /*!< [2..2] Slave Arbitration-Lost Detection Enable                            */
            uint32_t              : 5;
            __IOM uint32_t SCSYNE : 1; /*!< [8..8] SCL Synchronous Circuit Enable                                     */
            uint32_t              : 3;
            __IOM uint32_t SMBS   : 1; /*!< [12..12] SMBus/I2C Bus Selection                                          */
            uint32_t              : 1;
            __IOM uint32_t FMPE   : 1; /*!< [14..14] Fast-mode Plus Enable                                            */
            __IOM uint32_t HSME   : 1; /*!< [15..15] High Speed Mode Enable                                           */
            uint32_t              : 16;
        } BFCTL_b;
    };

    union
    {
        __IOM uint32_t SVCTL;          /*!< (@ 0x00000064) Slave Control Register                                     */

        struct
        {
            __IOM uint32_t GCAE  : 1;  /*!< [0..0] General Call Address Enable                                        */
            uint32_t             : 4;
            __IOM uint32_t HSMCE : 1;  /*!< [5..5] Hs-mode Master Code Enable                                         */
            __IOM uint32_t DVIDE : 1;  /*!< [6..6] Device-ID Address Enable                                           */
            uint32_t             : 8;
            __IOM uint32_t HOAE  : 1;  /*!< [15..15] Host Address Enable                                              */
            __IOM uint32_t SVAEn : 1;  /*!< [16..16] Slave Address Enable n (n = 0)                                   */
            uint32_t             : 15;
        } SVCTL_b;
    };
    __IM uint32_t RESERVED6[2];

    union
    {
        __IOM uint32_t REFCKCTL;        /*!< (@ 0x00000070) Reference Clock Control Register                           */

        struct
        {
            __IOM uint32_t IREFCKS : 3; /*!< [2..0] Internal Reference Clock Selection                                 */
            uint32_t               : 29;
        } REFCKCTL_b;
    };

    union
    {
        __IOM uint32_t STDBR;          /*!< (@ 0x00000074) Standard Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t SBRLO  : 8; /*!< [7..0] Count value of the Low-level period of SCL clock                   */
            __IOM uint32_t SBRHO  : 8; /*!< [15..8] Count value of the High-level period of SCL clock                 */
            __IOM uint32_t SBRLP  : 6; /*!< [21..16] Standard Bit Rate Low-level Period Push-Pull                     */
            uint32_t              : 2;
            __IOM uint32_t SBRHP  : 6; /*!< [29..24] Standard Bit Rate High-Level Period Push-Pull                    */
            uint32_t              : 1;
            __IOM uint32_t DSBRPO : 1; /*!< [31..31] Double the Standard Bit Rate Period for Open-Drain               */
        } STDBR_b;
    };

    union
    {
        __IOM uint32_t EXTBR;          /*!< (@ 0x00000078) Extended Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t EBRLO : 8;  /*!< [7..0] Extended Bit Rate Low-Level Period Open-Drain                      */
            __IOM uint32_t EBRHO : 8;  /*!< [15..8] Extended Bit Rate High-Level Period Open-Drain                    */
            __IOM uint32_t EBRLP : 6;  /*!< [21..16] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
            __IOM uint32_t EBRHP : 6;  /*!< [29..24] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
        } EXTBR_b;
    };

    union
    {
        __IOM uint32_t BFRECDT;        /*!< (@ 0x0000007C) Bus Free Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t FRECYC : 9; /*!< [8..0] Bus Free Condition Detection Cycle                                 */
            uint32_t              : 23;
        } BFRECDT_b;
    };

    union
    {
        __IOM uint32_t BAVLCDT;        /*!< (@ 0x00000080) Bus Available Condition Detection Time Register            */

        struct
        {
            __IOM uint32_t AVLCYC : 9; /*!< [8..0] Bus Available Condition Detection Cycle                            */
            uint32_t              : 23;
        } BAVLCDT_b;
    };

    union
    {
        __IOM uint32_t BIDLCDT;         /*!< (@ 0x00000084) Bus Idle Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t IDLCYC : 18; /*!< [17..0] Bus Idle Condition Detection Cycle                                */
            uint32_t              : 14;
        } BIDLCDT_b;
    };

    union
    {
        __IOM uint32_t OUTCTL;         /*!< (@ 0x00000088) Output Control Register                                    */

        struct
        {
            __IOM uint32_t SDOC   : 1; /*!< [0..0] SDA Output Control                                                 */
            __IOM uint32_t SCOC   : 1; /*!< [1..1] SCL Output Control                                                 */
            __OM uint32_t  SOCWP  : 1; /*!< [2..2] SCL/SDA Output Control Write Protect                               */
            uint32_t              : 1;
            __IOM uint32_t EXCYC  : 1; /*!< [4..4] Extra SCL Clock Cycle Output                                       */
            uint32_t              : 3;
            __IOM uint32_t SDOD   : 3; /*!< [10..8] SDA Output Delay                                                  */
            uint32_t              : 4;
            __IOM uint32_t SDODCS : 1; /*!< [15..15] SDA Output Delay Clock Source Selection                          */
            uint32_t              : 16;
        } OUTCTL_b;
    };

    union
    {
        __IOM uint32_t INCTL;          /*!< (@ 0x0000008C) Input Control Register                                     */

        struct
        {
            __IOM uint32_t DNFS : 4;   /*!< [3..0] Digital Noise Filter Stage Selection                               */
            __IOM uint32_t DNFE : 1;   /*!< [4..4] Digital Noise Filter Circuit Enable                                */
            uint32_t            : 27;
        } INCTL_b;
    };

    union
    {
        __IOM uint32_t TMOCTL;         /*!< (@ 0x00000090) Timeout Control Register                                   */

        struct
        {
            __IOM uint32_t TODTS  : 2; /*!< [1..0] Timeout Detection Time Selection                                   */
            uint32_t              : 2;
            __IOM uint32_t TOLCTL : 1; /*!< [4..4] Timeout L Count Control                                            */
            __IOM uint32_t TOHCTL : 1; /*!< [5..5] Timeout H Count Control                                            */
            __IOM uint32_t TOMDS  : 2; /*!< [7..6] Timeout Operation Mode Selection                                   */
            uint32_t              : 24;
        } TMOCTL_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t WUCTL;           /*!< (@ 0x00000098) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUACKS  : 1; /*!< [0..0] Wake-Up Acknowledge Selection                                      */
            uint32_t               : 3;
            __IOM uint32_t WUANFS  : 1; /*!< [4..4] Wake-Up Analog Noise Filter Selection                              */
            uint32_t               : 1;
            __IOM uint32_t WUFSYNE : 1; /*!< [6..6] Wake-Up function PCLKA Synchronous Enable                          */
            __IOM uint32_t WUFE    : 1; /*!< [7..7] Wake-Up function Enable.                                           */
            uint32_t               : 24;
        } WUCTL_b;
    };
    __IM uint32_t RESERVED8;

    union
    {
        __IOM uint32_t ACKCTL;         /*!< (@ 0x000000A0) Acknowledge Control Register                               */

        struct
        {
            __IM uint32_t  ACKR   : 1; /*!< [0..0] Acknowledge Reception                                              */
            __IOM uint32_t ACKT   : 1; /*!< [1..1] Acknowledge Transmission                                           */
            __OM uint32_t  ACKTWP : 1; /*!< [2..2] ACKT Write Protect                                                 */
            uint32_t              : 29;
        } ACKCTL_b;
    };

    union
    {
        __IOM uint32_t SCSTRCTL;       /*!< (@ 0x000000A4) SCL Stretch Control Register                               */

        struct
        {
            __IOM uint32_t ACKTWE : 1; /*!< [0..0] Acknowledge Transmission Wait Enable                               */
            __IOM uint32_t RWE    : 1; /*!< [1..1] Receive Wait Enable                                                */
            uint32_t              : 30;
        } SCSTRCTL_b;
    };
    __IM uint32_t RESERVED9[2];

    union
    {
        __IOM uint32_t SCSTLCTL;        /*!< (@ 0x000000B0) SCL Stalling Control Register                              */

        struct
        {
            __IOM uint32_t STLCYC : 16; /*!< [15..0] Stalling Cycle                                                    */
            uint32_t              : 12;
            __IOM uint32_t AAPE   : 1;  /*!< [28..28] Assigend Address Phase Enable                                    */
            __IOM uint32_t TRAPE  : 1;  /*!< [29..29] Transition Phase Enable                                          */
            __IOM uint32_t PARPE  : 1;  /*!< [30..30] Parity Phase Enable                                              */
            __IOM uint32_t ACKPE  : 1;  /*!< [31..31] ACK phase Enable                                                 */
        } SCSTLCTL_b;
    };
    __IM uint32_t RESERVED10[3];

    union
    {
        __IOM uint32_t SVTDLG0;        /*!< (@ 0x000000C0) Slave Transfer Data Length Register 0                      */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t STDLG : 16; /*!< [31..16] Slave Transfer Data Length                                       */
        } SVTDLG0_b;
    };
    __IM uint32_t RESERVED11[31];

    union
    {
        __IOM uint32_t CNDCTL;         /*!< (@ 0x00000140) Condition Control Register                                 */

        struct
        {
            __IOM uint32_t STCND : 1;  /*!< [0..0] START (S) Condition Issuance                                       */
            __IOM uint32_t SRCND : 1;  /*!< [1..1] Repeated START (Sr) Condition Issuance                             */
            __IOM uint32_t SPCND : 1;  /*!< [2..2] STOP (P) Condition Issuance                                        */
            uint32_t             : 29;
        } CNDCTL_b;
    };
    __IM uint32_t  RESERVED12[3];
    __OM uint32_t  NCMDQP;             /*!< (@ 0x00000150) Normal Command Queue Port Register                         */
    __IM uint32_t  NRSPQP;             /*!< (@ 0x00000154) Normal Response Queue Port Register                        */
    __IOM uint32_t NTDTBP0;            /*!< (@ 0x00000158) Normal Transfer Data Buffer Port Register 0                */
    __IM uint32_t  RESERVED13[8];
    __IOM uint32_t NIBIQP;             /*!< (@ 0x0000017C) Normal IBI Queue Port Register                             */
    __IM uint32_t  NRSQP;              /*!< (@ 0x00000180) Normal Receive Status Queue Port Register                  */
    __IM uint32_t  RESERVED14[3];

    union
    {
        __IOM uint32_t NQTHCTL;         /*!< (@ 0x00000190) Normal Queue Threshold Control Register                    */

        struct
        {
            __IOM uint32_t CMDQTH  : 8; /*!< [7..0] Normal Command Ready Queue Threshold                               */
            __IOM uint32_t RSPQTH  : 8; /*!< [15..8] Normal Response Queue Threshold                                   */
            __IOM uint32_t IBIDSSZ : 8; /*!< [23..16] Normal IBI Data Segment Size                                     */
            __IOM uint32_t IBIQTH  : 8; /*!< [31..24] Normal IBI Queue Threshold                                       */
        } NQTHCTL_b;
    };

    union
    {
        __IOM uint32_t NTBTHCTL0;      /*!< (@ 0x00000194) Normal Transfer Data Buffer Threshold Control
                                        *                  Register 0                                                 */

        struct
        {
            __IOM uint32_t TXDBTH : 3; /*!< [2..0] Normal Transmit Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t RXDBTH : 3; /*!< [10..8] Normal Receive Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t TXSTTH : 3; /*!< [18..16] Normal Tx Start Threshold                                        */
            uint32_t              : 5;
            __IOM uint32_t RXSTTH : 3; /*!< [26..24] Normal Rx Start Threshold                                        */
            uint32_t              : 5;
        } NTBTHCTL0_b;
    };
    __IM uint32_t RESERVED15[10];

    union
    {
        __IOM uint32_t NRQTHCTL;       /*!< (@ 0x000001C0) Normal Receive Status Queue Threshold Control
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t RSQTH : 8;  /*!< [7..0] Normal Receive Status Queue Threshold                              */
            uint32_t             : 24;
        } NRQTHCTL_b;
    };
    __IM uint32_t RESERVED16[3];

    union
    {
        __IOM uint32_t BST;             /*!< (@ 0x000001D0) Bus Status Register                                        */

        struct
        {
            __IOM uint32_t STCNDDF : 1; /*!< [0..0] START condition Detection Flag                                     */
            __IOM uint32_t SPCNDDF : 1; /*!< [1..1] STOP condition Detection Flag                                      */
            __IOM uint32_t HDREXDF : 1; /*!< [2..2] HDR Exit Pattern Detection Flag                                    */
            uint32_t               : 1;
            __IOM uint32_t NACKDF  : 1; /*!< [4..4] NACK Detection Flag                                                */
            uint32_t               : 3;
            __IOM uint32_t TENDF   : 1; /*!< [8..8] Transmit End Flag                                                  */
            uint32_t               : 7;
            __IOM uint32_t ALF     : 1; /*!< [16..16] Arbitration Lost Flag                                            */
            uint32_t               : 3;
            __IOM uint32_t TODF    : 1; /*!< [20..20] Timeout Detection Flag                                           */
            uint32_t               : 11;
        } BST_b;
    };

    union
    {
        __IOM uint32_t BSTE;            /*!< (@ 0x000001D4) Bus Status Enable Register                                 */

        struct
        {
            __IOM uint32_t STCNDDE : 1; /*!< [0..0] START condition Detection Enable                                   */
            __IOM uint32_t SPCNDDE : 1; /*!< [1..1] STOP condition Detection Enable                                    */
            __IOM uint32_t HDREXDE : 1; /*!< [2..2] HDR Exit Pattern Detection Enable                                  */
            uint32_t               : 1;
            __IOM uint32_t NACKDE  : 1; /*!< [4..4] NACK Detection Enable                                              */
            uint32_t               : 3;
            __IOM uint32_t TENDE   : 1; /*!< [8..8] Transmit End Enable                                                */
            uint32_t               : 7;
            __IOM uint32_t ALE     : 1; /*!< [16..16] Arbitration Lost Enable                                          */
            uint32_t               : 3;
            __IOM uint32_t TODE    : 1; /*!< [20..20] Timeout Detection Enable                                         */
            uint32_t               : 11;
        } BSTE_b;
    };

    union
    {
        __IOM uint32_t BIE;              /*!< (@ 0x000001D8) Bus Interrupt Enable Register                              */

        struct
        {
            __IOM uint32_t STCNDDIE : 1; /*!< [0..0] START condition Detection Interrupt Enable                         */
            __IOM uint32_t SPCNDDIE : 1; /*!< [1..1] STOP condition Detection Interrupt Enable                          */
            __IOM uint32_t HDREXDIE : 1; /*!< [2..2] HDR Exit Pattern Detection Interrupt Enable                        */
            uint32_t                : 1;
            __IOM uint32_t NACKDIE  : 1; /*!< [4..4] NACK Detection Interrupt Enable                                    */
            uint32_t                : 3;
            __IOM uint32_t TENDIE   : 1; /*!< [8..8] Transmit End Interrupt Enable                                      */
            uint32_t                : 7;
            __IOM uint32_t ALIE     : 1; /*!< [16..16] Arbitration Lost Interrupt Enable                                */
            uint32_t                : 3;
            __IOM uint32_t TODIE    : 1; /*!< [20..20] Timeout Detection Interrupt Enable                               */
            uint32_t                : 11;
        } BIE_b;
    };

    union
    {
        __IOM uint32_t BSTFC;           /*!< (@ 0x000001DC) Bus Status Force Register                                  */

        struct
        {
            __OM uint32_t STCNDDFC : 1; /*!< [0..0] START condition Detection Force                                    */
            __OM uint32_t SPCNDDFC : 1; /*!< [1..1] STOP condition Detection Force                                     */
            __OM uint32_t HDREXDFC : 1; /*!< [2..2] HDR Exit Pattern Detection Force                                   */
            uint32_t               : 1;
            __OM uint32_t NACKDFC  : 1; /*!< [4..4] NACK Detection Force                                               */
            uint32_t               : 3;
            __OM uint32_t TENDFC   : 1; /*!< [8..8] Transmit End Force                                                 */
            uint32_t               : 7;
            __OM uint32_t ALFC     : 1; /*!< [16..16] Arbitration Lost Force                                           */
            uint32_t               : 3;
            __OM uint32_t TODFC    : 1; /*!< [20..20] Timeout Detection Force                                          */
            uint32_t               : 11;
        } BSTFC_b;
    };

    union
    {
        __IOM uint32_t NTST;            /*!< (@ 0x000001E0) Normal Transfer Status Register                            */

        struct
        {
            __IOM uint32_t TDBEF0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Flag 0                           */
            __IOM uint32_t RDBFF0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Flag 0                             */
            __IOM uint32_t IBIQEFF : 1; /*!< [2..2] Normal IBI Queue Empty/Full Flag                                   */
            __IOM uint32_t CMDQEF  : 1; /*!< [3..3] Normal Command Queue Empty Flag                                    */
            __IOM uint32_t RSPQFF  : 1; /*!< [4..4] Normal Response Queue Full Flag                                    */
            __IOM uint32_t TABTF   : 1; /*!< [5..5] Normal Transfer Abort Flag                                         */
            uint32_t               : 3;
            __IOM uint32_t TEF     : 1; /*!< [9..9] Normal Transfer Error Flag                                         */
            uint32_t               : 10;
            __IOM uint32_t RSQFF   : 1; /*!< [20..20] Normal Receive Status Queue Full Flag                            */
            uint32_t               : 11;
        } NTST_b;
    };

    union
    {
        __IOM uint32_t NTSTE;           /*!< (@ 0x000001E4) Normal Transfer Status Enable Register                     */

        struct
        {
            __IOM uint32_t TDBEE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Enable 0                         */
            __IOM uint32_t RDBFE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Enable 0                           */
            __IOM uint32_t IBIQEFE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Enable                                 */
            __IOM uint32_t CMDQEE  : 1; /*!< [3..3] Normal Command Queue Empty Enable                                  */
            __IOM uint32_t RSPQFE  : 1; /*!< [4..4] Normal Response Queue Full Enable                                  */
            __IOM uint32_t TABTE   : 1; /*!< [5..5] Normal Transfer Abort Enable                                       */
            uint32_t               : 3;
            __IOM uint32_t TEE     : 1; /*!< [9..9] Normal Transfer Error Enable                                       */
            uint32_t               : 10;
            __IOM uint32_t RSQFE   : 1; /*!< [20..20] Normal Receive Status Queue Full Enable                          */
            uint32_t               : 11;
        } NTSTE_b;
    };

    union
    {
        __IOM uint32_t NTIE;             /*!< (@ 0x000001E8) Normal Transfer Interrupt Enable Register                  */

        struct
        {
            __IOM uint32_t TDBEIE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Interrupt Enable 0               */
            __IOM uint32_t RDBFIE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Interrupt Enable 0                 */
            __IOM uint32_t IBIQEFIE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Interrupt Enable                       */
            __IOM uint32_t CMDQEIE  : 1; /*!< [3..3] Normal Command Queue Empty Interrupt Enable                        */
            __IOM uint32_t RSPQFIE  : 1; /*!< [4..4] Normal Response Queue Full Interrupt Enable                        */
            __IOM uint32_t TABTIE   : 1; /*!< [5..5] Normal Transfer Abort Interrupt Enable                             */
            uint32_t                : 3;
            __IOM uint32_t TEIE     : 1; /*!< [9..9] Normal Transfer Error Interrupt Enable                             */
            uint32_t                : 10;
            __IOM uint32_t RSQFIE   : 1; /*!< [20..20] Normal Receive Status Queue Full Interrupt Enable                */
            uint32_t                : 11;
        } NTIE_b;
    };

    union
    {
        __IOM uint32_t NTSTFC;          /*!< (@ 0x000001EC) Normal Transfer Status Force Register                      */

        struct
        {
            __OM uint32_t TDBEFC0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Force 0                          */
            __OM uint32_t RDBFFC0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Force 0                            */
            __OM uint32_t IBIQEFFC : 1; /*!< [2..2] Normal IBI Queue Empty/Full Force                                  */
            __OM uint32_t CMDQEFC  : 1; /*!< [3..3] Normal Command Queue Empty Force                                   */
            __OM uint32_t RSPQFFC  : 1; /*!< [4..4] Normal Response Queue Full Force                                   */
            __OM uint32_t TABTFC   : 1; /*!< [5..5] Normal Transfer Abort Force                                        */
            uint32_t               : 3;
            __OM uint32_t TEFC     : 1; /*!< [9..9] Normal Transfer Error Force                                        */
            uint32_t               : 10;
            __OM uint32_t RSQFFC   : 1; /*!< [20..20] Normal Receive Status Queue Full Force                           */
            uint32_t               : 11;
        } NTSTFC_b;
    };
    __IM uint32_t RESERVED17[8];

    union
    {
        __IM uint32_t BCST;            /*!< (@ 0x00000210) Bus Condition Status Register                              */

        struct
        {
            __IM uint32_t BFREF : 1;   /*!< [0..0] Bus Free Detection Flag                                            */
            __IM uint32_t BAVLF : 1;   /*!< [1..1] Bus Available Detection Flag                                       */
            __IM uint32_t BIDLF : 1;   /*!< [2..2] Bus Idle Detection Flag                                            */
            uint32_t            : 29;
        } BCST_b;
    };

    union
    {
        __IOM uint32_t SVST;           /*!< (@ 0x00000214) Slave Status Register                                      */

        struct
        {
            __IOM uint32_t GCAF  : 1;  /*!< [0..0] General Call Address Detection Flag                                */
            uint32_t             : 4;
            __IOM uint32_t HSMCF : 1;  /*!< [5..5] Hs-mode Master Code Detection Flag                                 */
            __IOM uint32_t DVIDF : 1;  /*!< [6..6] Device-ID Address Detection Flag                                   */
            uint32_t             : 8;
            __IOM uint32_t HOAF  : 1;  /*!< [15..15] Host Address Detection Flag                                      */
            __IOM uint32_t SVAFn : 1;  /*!< [16..16] Slave Address Detection Flag n (n = 0)                           */
            uint32_t             : 15;
        } SVST_b;
    };

    union
    {
        __IOM uint32_t WUST;            /*!< (@ 0x00000218) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUASYNF : 1; /*!< [0..0] Wake-up function asynchronous operation status flag.               */
            uint32_t               : 31;
        } WUST_b;
    };
    __IM uint32_t RESERVED18[2];

    union
    {
        __IOM uint32_t DATBAS0;         /*!< (@ 0x00000224) Device Address Table Basic Register 0                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS0_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IOM uint32_t DATBAS1;         /*!< (@ 0x0000022C) Device Address Table Basic Register 1                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS1_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IOM uint32_t DATBAS2;         /*!< (@ 0x00000234) Device Address Table Basic Register 2                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS2_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t DATBAS3;         /*!< (@ 0x0000023C) Device Address Table Basic Register 3                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS3_b;
    };
    __IM uint32_t RESERVED22[24];

    union
    {
        __IOM uint32_t EXDATBAS;       /*!< (@ 0x000002A0) Extended Device Address Table Basic Register               */

        struct
        {
            __IOM uint32_t EDSTAD : 7; /*!< [6..0] Extended Device Static Address                                     */
            uint32_t              : 9;
            __IOM uint32_t EDDYAD : 8; /*!< [23..16] Extended Device I3C Dynamic Address                              */
            uint32_t              : 5;
            __IOM uint32_t EDNACK : 2; /*!< [30..29] Extended Device NACK Retry Count                                 */
            __IOM uint32_t EDTYP  : 1; /*!< [31..31] Extended Device Type                                             */
        } EXDATBAS_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint32_t SDATBAS0;         /*!< (@ 0x000002B0) Slave Device Address Table Basic Register 0                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS0_b;
    };

    union
    {
        __IOM uint32_t SDATBAS1;         /*!< (@ 0x000002B4) Slave Device Address Table Basic Register 1                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS1_b;
    };

    union
    {
        __IOM uint32_t SDATBAS2;         /*!< (@ 0x000002B8) Slave Device Address Table Basic Register 2                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS2_b;
    };
    __IM uint32_t RESERVED24[5];

    union
    {
        __IOM uint32_t MSDCT0;         /*!< (@ 0x000002D0) Master Device Characteristic Table Register 0              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT0_b;
    };

    union
    {
        __IOM uint32_t MSDCT1;         /*!< (@ 0x000002D4) Master Device Characteristic Table Register 1              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT1_b;
    };

    union
    {
        __IOM uint32_t MSDCT2;         /*!< (@ 0x000002D8) Master Device Characteristic Table Register 2              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT2_b;
    };

    union
    {
        __IOM uint32_t MSDCT3;         /*!< (@ 0x000002DC) Master Device Characteristic Table Register 3              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT3_b;
    };
    __IM uint32_t RESERVED25[16];

    union
    {
        __IOM uint32_t SVDCT;          /*!< (@ 0x00000320) Slave Device Characteristic Table Register                 */

        struct
        {
            __IOM uint32_t TDCR   : 8; /*!< [7..0] Transfar Device Characteristic Register                            */
            __IOM uint32_t TBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t TBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t TBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t TBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t TBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } SVDCT_b;
    };
    __IOM uint32_t SDCTPIDL;           /*!< (@ 0x00000324) Slave Device Characteristic Table Provisional
                                        *                  ID Low Register                                            */
    __IOM uint32_t SDCTPIDH;           /*!< (@ 0x00000328) Slave Device Characteristic Table Provisional
                                        *                  ID High Register                                           */
    __IM uint32_t RESERVED26;

    union
    {
        __IM uint32_t SVDVAD0;         /*!< (@ 0x00000330) Slave Device Address Register 0                            */

        struct
        {
            uint32_t             : 16;
            __IM uint32_t SVAD   : 10; /*!< [25..16] Slave Address                                                    */
            uint32_t             : 1;
            __IM uint32_t SADLG  : 1;  /*!< [27..27] Slave Address Length                                             */
            uint32_t             : 2;
            __IM uint32_t SSTADV : 1;  /*!< [30..30] Slave Static Address Valid                                       */
            __IM uint32_t SDYADV : 1;  /*!< [31..31] Slave Dynamic Address Valid                                      */
        } SVDVAD0_b;
    };
    __IM uint32_t RESERVED27[7];

    union
    {
        __IOM uint32_t CSECMD;         /*!< (@ 0x00000350) CCC Slave Events Command Register                          */

        struct
        {
            __IOM uint32_t SVIRQE : 1; /*!< [0..0] Slave Interrupt Requests Enable                                    */
            __IOM uint32_t MSRQE  : 1; /*!< [1..1] Mastership Requests Enable                                         */
            uint32_t              : 1;
            __IOM uint32_t HJEVE  : 1; /*!< [3..3] Hot-Join Event Enable                                              */
            uint32_t              : 28;
        } CSECMD_b;
    };

    union
    {
        __IOM uint32_t CEACTST;        /*!< (@ 0x00000354) CCC Enter Activity State Register                          */

        struct
        {
            __IOM uint32_t ACTST : 4;  /*!< [3..0] Activity State                                                     */
            uint32_t             : 28;
        } CEACTST_b;
    };

    union
    {
        __IOM uint32_t CMWLG;          /*!< (@ 0x00000358) CCC Max Write Length Register                              */

        struct
        {
            __IOM uint32_t MWLG : 16;  /*!< [15..0] Max Write Length                                                  */
            uint32_t            : 16;
        } CMWLG_b;
    };

    union
    {
        __IOM uint32_t CMRLG;           /*!< (@ 0x0000035C) CCC Max Read Length Register                               */

        struct
        {
            __IOM uint32_t MRLG   : 16; /*!< [15..0] Max Read Length                                                   */
            __IOM uint32_t IBIPSZ : 8;  /*!< [23..16] IBI Payload Size                                                 */
            uint32_t              : 8;
        } CMRLG_b;
    };

    union
    {
        __IM uint32_t CETSTMD;         /*!< (@ 0x00000360) CCC Enter Test Mode Register                               */

        struct
        {
            __IM uint32_t TSTMD : 8;   /*!< [7..0] Test Mode                                                          */
            uint32_t            : 24;
        } CETSTMD_b;
    };

    union
    {
        __IOM uint32_t CGDVST;         /*!< (@ 0x00000364) CCC Get Device Status Register                             */

        struct
        {
            __IOM uint32_t PNDINT : 4; /*!< [3..0] Pending Interrupt                                                  */
            uint32_t              : 1;
            __IOM uint32_t PRTE   : 1; /*!< [5..5] Protocol Error                                                     */
            __IOM uint32_t ACTMD  : 2; /*!< [7..6] Slave Device's current Activity Mode                               */
            __IOM uint32_t VDRSV  : 8; /*!< [15..8] Vendor Reserved                                                   */
            uint32_t              : 16;
        } CGDVST_b;
    };

    union
    {
        __IOM uint32_t CMDSPW;         /*!< (@ 0x00000368) CCC Max Data Speed W (Write) Register                      */

        struct
        {
            __IOM uint32_t MSWDR : 3;  /*!< [2..0] Maximum Sustained Write Data Rate                                  */
            uint32_t             : 29;
        } CMDSPW_b;
    };

    union
    {
        __IOM uint32_t CMDSPR;         /*!< (@ 0x0000036C) CCC Max Data Speed R (Read) Register                       */

        struct
        {
            __IOM uint32_t MSRDR  : 3; /*!< [2..0] Maximum Sustained Read Data Rate                                   */
            __IOM uint32_t CDTTIM : 3; /*!< [5..3] Clock to Data Turnaround Time (TSCO)                               */
            uint32_t              : 26;
        } CMDSPR_b;
    };

    union
    {
        __IOM uint32_t CMDSPT;          /*!< (@ 0x00000370) CCC Max Data Speed T (Turnaround) Register                 */

        struct
        {
            __IOM uint32_t MRTTIM : 24; /*!< [23..0] Maximum Read Turnaround Time                                      */
            uint32_t              : 7;
            __IOM uint32_t MRTE   : 1;  /*!< [31..31] Maximum Read Turnaround Time Enable                              */
        } CMDSPT_b;
    };

    union
    {
        __IOM uint32_t CETSM;          /*!< (@ 0x00000374) CCC Exchange Timing Support Information M (Mode)
                                        *                  Register                                                   */

        struct
        {
            uint32_t            : 8;
            __IOM uint32_t FREQ : 8;   /*!< [15..8] Frequency Byte                                                    */
            __IOM uint32_t INAC : 8;   /*!< [23..16] Inaccuracy Byte                                                  */
            uint32_t            : 8;
        } CETSM_b;
    };
    __IM uint32_t RESERVED28[2];

    union
    {
        __IOM uint32_t BITCNT;         /*!< (@ 0x00000380) Bit Count Register                                         */

        struct
        {
            __IOM uint32_t BCNT  : 5;  /*!< [4..0] Bit Counter                                                        */
            uint32_t             : 2;
            __OM uint32_t BCNTWP : 1;  /*!< [7..7] BCNT Write Protect                                                 */
            uint32_t             : 24;
        } BITCNT_b;
    };
    __IM uint32_t RESERVED29[4];

    union
    {
        __IM uint32_t NQSTLV;          /*!< (@ 0x00000394) Normal Queue Status Level Register                         */

        struct
        {
            __IM uint32_t CMDQFLV : 8; /*!< [7..0] Normal Command Queue Free Level                                    */
            __IM uint32_t RSPQLV  : 8; /*!< [15..8] Normal Response Queue Level                                       */
            __IM uint32_t IBIQLV  : 8; /*!< [23..16] Normal IBI Queue Level                                           */
            __IM uint32_t IBISCNT : 5; /*!< [28..24] Normal IBI Status Count                                          */
            uint32_t              : 3;
        } NQSTLV_b;
    };

    union
    {
        __IM uint32_t NDBSTLV0;        /*!< (@ 0x00000398) Normal Data Buffer Status Level Register                   */

        struct
        {
            __IM uint32_t TDBFLV : 8;  /*!< [7..0] Normal Transmit Data Buffer Free Level                             */
            __IM uint32_t RDBLV  : 8;  /*!< [15..8] Normal Receive Data Buffer Level                                  */
            uint32_t             : 16;
        } NDBSTLV0_b;
    };
    __IM uint32_t RESERVED30[9];

    union
    {
        __IM uint32_t NRSQSTLV;        /*!< (@ 0x000003C0) Normal Receive Status Queue Status Level Register          */

        struct
        {
            __IM uint32_t RSQLV : 8;   /*!< [7..0] Normal Receive Status Queue Level                                  */
            uint32_t            : 24;
        } NRSQSTLV_b;
    };
    __IM uint32_t RESERVED31[2];

    union
    {
        __IM uint32_t PRSTDBG;         /*!< (@ 0x000003CC) Present State Debug Register                               */

        struct
        {
            __IM uint32_t SCILV : 1;   /*!< [0..0] SCL Line Signal Level                                              */
            __IM uint32_t SDILV : 1;   /*!< [1..1] SDA Line Signal Level                                              */
            __IM uint32_t SCOLV : 1;   /*!< [2..2] SCL Output Level                                                   */
            __IM uint32_t SDOLV : 1;   /*!< [3..3] SDA Output Level                                                   */
            uint32_t            : 28;
        } PRSTDBG_b;
    };

    union
    {
        __IM uint32_t MSERRCNT;        /*!< (@ 0x000003D0) Master Error Counters Register                             */

        struct
        {
            __IM uint32_t M2ECNT : 8;  /*!< [7..0] M2 Error Counter                                                   */
            uint32_t             : 24;
        } MSERRCNT_b;
    };
} R_I3C0_Type;                         /*!< Size = 980 (0x3d4)                                                        */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Master MPU (R_MPU_MMPU)
 */

typedef struct                          /*!< (@ 0x40000000) R_MPU_MMPU Structure                                       */
{
    __IOM R_MPU_MMPU_MMPU_Type MMPU[3]; /*!< (@ 0x00000000) Bus Master MPU Registers                                   */
} R_MPU_MMPU_Type;                      /*!< Size = 3072 (0xc00)                                                       */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Slave MPU (R_MPU_SMPU)
 */

typedef struct                           /*!< (@ 0x40000C00) R_MPU_SMPU Structure                                       */
{
    union
    {
        __IOM uint16_t SMPUCTL;          /*!< (@ 0x00000000) Slave MPU Control Register                                 */

        struct
        {
            __IOM uint16_t OAD     : 1;  /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t PROTECT : 1;  /*!< [1..1] Protection of register                                             */
            uint16_t               : 6;
            __OM uint16_t KEY      : 8;  /*!< [15..8] Key Code This bit is used to enable or disable rewriting
                                          *   of the PROTECT and OAD bit.                                               */
        } SMPUCTL_b;
    };
    __IM uint16_t              RESERVED[7];
    __IOM R_MPU_SMPU_SMPU_Type SMPU[10]; /*!< (@ 0x00000010) Access Control Structure for MBIU                          */
} R_MPU_SMPU_Type;                       /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU Stack Pointer Monitor (R_MPU_SPMON)
 */

typedef struct                         /*!< (@ 0x40000D00) R_MPU_SPMON Structure                                      */
{
    __IOM R_MPU_SPMON_SP_Type SP[2];   /*!< (@ 0x00000000) Stack Pointer Monitor                                      */
} R_MPU_SPMON_Type;                    /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief System-Module Stop (R_MSTP)
 */

typedef struct                          /*!< (@ 0x40047000) R_MSTP Structure                                           */
{
    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x00000000) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t MSTPCRB;         /*!< (@ 0x00000004) Module Stop Control Register B                             */

        struct
        {
            __IOM uint32_t MSTPB0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRB_b;
    };

    union
    {
        __IOM uint32_t MSTPCRC;         /*!< (@ 0x00000008) Module Stop Control Register C                             */

        struct
        {
            __IOM uint32_t MSTPC0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRC_b;
    };

    union
    {
        __IOM uint32_t MSTPCRD;         /*!< (@ 0x0000000C) Module Stop Control Register D                             */

        struct
        {
            __IOM uint32_t MSTPD0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRD_b;
    };

    union
    {
        __IOM uint32_t MSTPCRE;         /*!< (@ 0x00000010) Module Stop Control Register E                             */

        struct
        {
            __IOM uint32_t MSTPE0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRE_b;
    };
} R_MSTP_Type;                          /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports (R_PORT0)
 */

typedef struct                         /*!< (@ 0x40040000) R_PORT0 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t PCNTR1;        /*!< (@ 0x00000000) Port Control Register 1                                    */

            struct
            {
                __IOM uint32_t PDR  : 16; /*!< [15..0] Pmn Direction                                                     */
                __IOM uint32_t PODR : 16; /*!< [31..16] Pmn Output Data                                                  */
            } PCNTR1_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t PODR;           /*!< (@ 0x00000000) Output data register                                       */

                struct
                {
                    __IOM uint16_t PODR0  : 1; /*!< [0..0] Pmn Output Data                                                    */
                    __IOM uint16_t PODR1  : 1; /*!< [1..1] Pmn Output Data                                                    */
                    __IOM uint16_t PODR2  : 1; /*!< [2..2] Pmn Output Data                                                    */
                    __IOM uint16_t PODR3  : 1; /*!< [3..3] Pmn Output Data                                                    */
                    __IOM uint16_t PODR4  : 1; /*!< [4..4] Pmn Output Data                                                    */
                    __IOM uint16_t PODR5  : 1; /*!< [5..5] Pmn Output Data                                                    */
                    __IOM uint16_t PODR6  : 1; /*!< [6..6] Pmn Output Data                                                    */
                    __IOM uint16_t PODR7  : 1; /*!< [7..7] Pmn Output Data                                                    */
                    __IOM uint16_t PODR8  : 1; /*!< [8..8] Pmn Output Data                                                    */
                    __IOM uint16_t PODR9  : 1; /*!< [9..9] Pmn Output Data                                                    */
                    __IOM uint16_t PODR10 : 1; /*!< [10..10] Pmn Output Data                                                  */
                    __IOM uint16_t PODR11 : 1; /*!< [11..11] Pmn Output Data                                                  */
                    __IOM uint16_t PODR12 : 1; /*!< [12..12] Pmn Output Data                                                  */
                    __IOM uint16_t PODR13 : 1; /*!< [13..13] Pmn Output Data                                                  */
                    __IOM uint16_t PODR14 : 1; /*!< [14..14] Pmn Output Data                                                  */
                    __IOM uint16_t PODR15 : 1; /*!< [15..15] Pmn Output Data                                                  */
                } PODR_b;
            };

            union
            {
                __IOM uint16_t PDR;           /*!< (@ 0x00000002) Data direction register                                    */

                struct
                {
                    __IOM uint16_t PDR0  : 1; /*!< [0..0] Pmn Direction                                                      */
                    __IOM uint16_t PDR1  : 1; /*!< [1..1] Pmn Direction                                                      */
                    __IOM uint16_t PDR2  : 1; /*!< [2..2] Pmn Direction                                                      */
                    __IOM uint16_t PDR3  : 1; /*!< [3..3] Pmn Direction                                                      */
                    __IOM uint16_t PDR4  : 1; /*!< [4..4] Pmn Direction                                                      */
                    __IOM uint16_t PDR5  : 1; /*!< [5..5] Pmn Direction                                                      */
                    __IOM uint16_t PDR6  : 1; /*!< [6..6] Pmn Direction                                                      */
                    __IOM uint16_t PDR7  : 1; /*!< [7..7] Pmn Direction                                                      */
                    __IOM uint16_t PDR8  : 1; /*!< [8..8] Pmn Direction                                                      */
                    __IOM uint16_t PDR9  : 1; /*!< [9..9] Pmn Direction                                                      */
                    __IOM uint16_t PDR10 : 1; /*!< [10..10] Pmn Direction                                                    */
                    __IOM uint16_t PDR11 : 1; /*!< [11..11] Pmn Direction                                                    */
                    __IOM uint16_t PDR12 : 1; /*!< [12..12] Pmn Direction                                                    */
                    __IOM uint16_t PDR13 : 1; /*!< [13..13] Pmn Direction                                                    */
                    __IOM uint16_t PDR14 : 1; /*!< [14..14] Pmn Direction                                                    */
                    __IOM uint16_t PDR15 : 1; /*!< [15..15] Pmn Direction                                                    */
                } PDR_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint32_t PCNTR2;        /*!< (@ 0x00000004) Port Control Register 2                                    */

            struct
            {
                __IM uint32_t PIDR : 16; /*!< [15..0] Pmn Input Data                                                    */
                __IM uint32_t EIDR : 16; /*!< [31..16] Pmn Event Input Data                                             */
            } PCNTR2_b;
        };

        struct
        {
            union
            {
                __IM uint16_t EIDR;           /*!< (@ 0x00000004) Event input data register                                  */

                struct
                {
                    __IM uint16_t EIDR0  : 1; /*!< [0..0] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR1  : 1; /*!< [1..1] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR2  : 1; /*!< [2..2] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR3  : 1; /*!< [3..3] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR4  : 1; /*!< [4..4] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR5  : 1; /*!< [5..5] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR6  : 1; /*!< [6..6] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR7  : 1; /*!< [7..7] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR8  : 1; /*!< [8..8] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR9  : 1; /*!< [9..9] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR10 : 1; /*!< [10..10] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR11 : 1; /*!< [11..11] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR12 : 1; /*!< [12..12] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR13 : 1; /*!< [13..13] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR14 : 1; /*!< [14..14] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR15 : 1; /*!< [15..15] Pmn Event Input Data                                             */
                } EIDR_b;
            };

            union
            {
                __IM uint16_t PIDR;           /*!< (@ 0x00000006) Input data register                                        */

                struct
                {
                    __IM uint16_t PIDR0  : 1; /*!< [0..0] Pmn Input Data                                                     */
                    __IM uint16_t PIDR1  : 1; /*!< [1..1] Pmn Input Data                                                     */
                    __IM uint16_t PIDR2  : 1; /*!< [2..2] Pmn Input Data                                                     */
                    __IM uint16_t PIDR3  : 1; /*!< [3..3] Pmn Input Data                                                     */
                    __IM uint16_t PIDR4  : 1; /*!< [4..4] Pmn Input Data                                                     */
                    __IM uint16_t PIDR5  : 1; /*!< [5..5] Pmn Input Data                                                     */
                    __IM uint16_t PIDR6  : 1; /*!< [6..6] Pmn Input Data                                                     */
                    __IM uint16_t PIDR7  : 1; /*!< [7..7] Pmn Input Data                                                     */
                    __IM uint16_t PIDR8  : 1; /*!< [8..8] Pmn Input Data                                                     */
                    __IM uint16_t PIDR9  : 1; /*!< [9..9] Pmn Input Data                                                     */
                    __IM uint16_t PIDR10 : 1; /*!< [10..10] Pmn Input Data                                                   */
                    __IM uint16_t PIDR11 : 1; /*!< [11..11] Pmn Input Data                                                   */
                    __IM uint16_t PIDR12 : 1; /*!< [12..12] Pmn Input Data                                                   */
                    __IM uint16_t PIDR13 : 1; /*!< [13..13] Pmn Input Data                                                   */
                    __IM uint16_t PIDR14 : 1; /*!< [14..14] Pmn Input Data                                                   */
                    __IM uint16_t PIDR15 : 1; /*!< [15..15] Pmn Input Data                                                   */
                } PIDR_b;
            };
        };
    };

    union
    {
        union
        {
            __OM uint32_t PCNTR3;        /*!< (@ 0x00000008) Port Control Register 3                                    */

            struct
            {
                __OM uint32_t POSR : 16; /*!< [15..0] Pmn Output Set                                                    */
                __OM uint32_t PORR : 16; /*!< [31..16] Pmn Output Reset                                                 */
            } PCNTR3_b;
        };

        struct
        {
            union
            {
                __OM uint16_t PORR;           /*!< (@ 0x00000008) Output set register                                        */

                struct
                {
                    __OM uint16_t PORR0  : 1; /*!< [0..0] Pmn Output Reset                                                   */
                    __OM uint16_t PORR1  : 1; /*!< [1..1] Pmn Output Reset                                                   */
                    __OM uint16_t PORR2  : 1; /*!< [2..2] Pmn Output Reset                                                   */
                    __OM uint16_t PORR3  : 1; /*!< [3..3] Pmn Output Reset                                                   */
                    __OM uint16_t PORR4  : 1; /*!< [4..4] Pmn Output Reset                                                   */
                    __OM uint16_t PORR5  : 1; /*!< [5..5] Pmn Output Reset                                                   */
                    __OM uint16_t PORR6  : 1; /*!< [6..6] Pmn Output Reset                                                   */
                    __OM uint16_t PORR7  : 1; /*!< [7..7] Pmn Output Reset                                                   */
                    __OM uint16_t PORR8  : 1; /*!< [8..8] Pmn Output Reset                                                   */
                    __OM uint16_t PORR9  : 1; /*!< [9..9] Pmn Output Reset                                                   */
                    __OM uint16_t PORR10 : 1; /*!< [10..10] Pmn Output Reset                                                 */
                    __OM uint16_t PORR11 : 1; /*!< [11..11] Pmn Output Reset                                                 */
                    __OM uint16_t PORR12 : 1; /*!< [12..12] Pmn Output Reset                                                 */
                    __OM uint16_t PORR13 : 1; /*!< [13..13] Pmn Output Reset                                                 */
                    __OM uint16_t PORR14 : 1; /*!< [14..14] Pmn Output Reset                                                 */
                    __OM uint16_t PORR15 : 1; /*!< [15..15] Pmn Output Reset                                                 */
                } PORR_b;
            };

            union
            {
                __OM uint16_t POSR;           /*!< (@ 0x0000000A) Output reset register                                      */

                struct
                {
                    __OM uint16_t POSR0  : 1; /*!< [0..0] Pmn Output Set                                                     */
                    __OM uint16_t POSR1  : 1; /*!< [1..1] Pmn Output Set                                                     */
                    __OM uint16_t POSR2  : 1; /*!< [2..2] Pmn Output Set                                                     */
                    __OM uint16_t POSR3  : 1; /*!< [3..3] Pmn Output Set                                                     */
                    __OM uint16_t POSR4  : 1; /*!< [4..4] Pmn Output Set                                                     */
                    __OM uint16_t POSR5  : 1; /*!< [5..5] Pmn Output Set                                                     */
                    __OM uint16_t POSR6  : 1; /*!< [6..6] Pmn Output Set                                                     */
                    __OM uint16_t POSR7  : 1; /*!< [7..7] Pmn Output Set                                                     */
                    __OM uint16_t POSR8  : 1; /*!< [8..8] Pmn Output Set                                                     */
                    __OM uint16_t POSR9  : 1; /*!< [9..9] Pmn Output Set                                                     */
                    __OM uint16_t POSR10 : 1; /*!< [10..10] Pmn Output Set                                                   */
                    __OM uint16_t POSR11 : 1; /*!< [11..11] Pmn Output Set                                                   */
                    __OM uint16_t POSR12 : 1; /*!< [12..12] Pmn Output Set                                                   */
                    __OM uint16_t POSR13 : 1; /*!< [13..13] Pmn Output Set                                                   */
                    __OM uint16_t POSR14 : 1; /*!< [14..14] Pmn Output Set                                                   */
                    __OM uint16_t POSR15 : 1; /*!< [15..15] Pmn Output Set                                                   */
                } POSR_b;
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t PCNTR4;        /*!< (@ 0x0000000C) Port Control Register 4                                    */

            struct
            {
                __IOM uint32_t EOSR : 16; /*!< [15..0] Pmn Event Output Set                                              */
                __IOM uint32_t EORR : 16; /*!< [31..16] Pmn Event Output Reset                                           */
            } PCNTR4_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t EORR;           /*!< (@ 0x0000000C) Event output set register                                  */

                struct
                {
                    __IOM uint16_t EORR0  : 1; /*!< [0..0] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR1  : 1; /*!< [1..1] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR2  : 1; /*!< [2..2] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR3  : 1; /*!< [3..3] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR4  : 1; /*!< [4..4] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR5  : 1; /*!< [5..5] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR6  : 1; /*!< [6..6] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR7  : 1; /*!< [7..7] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR8  : 1; /*!< [8..8] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR9  : 1; /*!< [9..9] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR10 : 1; /*!< [10..10] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR11 : 1; /*!< [11..11] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR12 : 1; /*!< [12..12] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR13 : 1; /*!< [13..13] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR14 : 1; /*!< [14..14] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR15 : 1; /*!< [15..15] Pmn Event Output Reset                                           */
                } EORR_b;
            };

            union
            {
                __IOM uint16_t EOSR;           /*!< (@ 0x0000000E) Event output reset register                                */

                struct
                {
                    __IOM uint16_t EOSR0  : 1; /*!< [0..0] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR1  : 1; /*!< [1..1] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR2  : 1; /*!< [2..2] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR3  : 1; /*!< [3..3] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR4  : 1; /*!< [4..4] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR5  : 1; /*!< [5..5] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR6  : 1; /*!< [6..6] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR7  : 1; /*!< [7..7] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR8  : 1; /*!< [8..8] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR9  : 1; /*!< [9..9] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR10 : 1; /*!< [10..10] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR11 : 1; /*!< [11..11] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR12 : 1; /*!< [12..12] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR13 : 1; /*!< [13..13] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR14 : 1; /*!< [14..14] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR15 : 1; /*!< [15..15] Pmn Event Output Set                                             */
                } EOSR_b;
            };
        };
    };
} R_PORT0_Type;                        /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-PFS (R_PFS)
 */

typedef struct                           /*!< (@ 0x40040800) R_PFS Structure                                            */
{
    union
    {
        __IOM R_PFS_PORT_Type  PORT[15]; /*!< (@ 0x00000000) Port [0..14]                                               */
        __IOM R_PFS_VLSEL_Type VLSEL;    /*!< (@ 0x00000000) VLSEL                                                      */
    };
} R_PFS_Type;                            /*!< Size = 960 (0x3c0)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-MISC (R_PMISC)
 */

typedef struct                         /*!< (@ 0x40040D00) R_PMISC Structure                                          */
{
    union
    {
        __IOM uint8_t PFENET;          /*!< (@ 0x00000000) Ethernet Control Register                                  */

        struct
        {
            uint8_t                : 4;
            __IOM uint8_t PHYMODE0 : 1; /*!< [4..4] Ethernet Mode Setting ch0                                          */
            __IOM uint8_t PHYMODE1 : 1; /*!< [5..5] Ethernet Mode Setting ch1                                          */
            uint8_t                : 2;
        } PFENET_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t PWPR;            /*!< (@ 0x00000003) Write-Protect Register                                     */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t PWPRS;           /*!< (@ 0x00000005) Write-Protect Register for Secure                          */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;    /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;    /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPRS_b;
    };
    __IM uint16_t            RESERVED2[5];
    __IOM R_PMISC_PMSAR_Type PMSAR[12]; /*!< (@ 0x00000010) Port Security Attribution Register                         */
} R_PMISC_Type;                         /*!< Size = 40 (0x28)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SCI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Communications Interface (R_SCI0)
 */

typedef struct                         /*!< (@ 0x40070000) R_SCI0 Structure                                           */
{
    union
    {
        union
        {
            __IOM uint8_t SMR;          /*!< (@ 0x00000000) Serial Mode Register (SCMR.SMIF = 0)                       */

            struct
            {
                __IOM uint8_t CKS  : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t MP   : 1; /*!< [2..2] Multi-Processor Mode(Valid only in asynchronous mode)              */
                __IOM uint8_t STOP : 1; /*!< [3..3] Stop Bit Length(Valid only in asynchronous mode)                   */
                __IOM uint8_t PM   : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE   : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t CHR  : 1; /*!< [6..6] Character Length(Valid only in asynchronous mode)                  */
                __IOM uint8_t CM   : 1; /*!< [7..7] Communication Mode                                                 */
            } SMR_b;
        };

        union
        {
            __IOM uint8_t SMR_SMCI;    /*!< (@ 0x00000000) Serial mode register (SCMR.SMIF = 1)                       */

            struct
            {
                __IOM uint8_t CKS : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t BCP : 2; /*!< [3..2] Base Clock Pulse(Valid only in asynchronous mode)                  */
                __IOM uint8_t PM  : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE  : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t BLK : 1; /*!< [6..6] Block Transfer Mode                                                */
                __IOM uint8_t GM  : 1; /*!< [7..7] GSM Mode                                                           */
            } SMR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t BRR;             /*!< (@ 0x00000001) Bit Rate Register                                          */

        struct
        {
            __IOM uint8_t BRR : 8;     /*!< [7..0] BRR is an 8-bit register that adjusts the bit rate.                */
        } BRR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SCR;          /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF = 0)                    */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable(Valid in asynchronous
                                         *   mode when SMR.MP = 1)                                                     */
                __IOM uint8_t RE  : 1;  /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE  : 1;  /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE : 1;  /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE : 1;  /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_b;
        };

        union
        {
            __IOM uint8_t SCR_SMCI;     /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF =1)                     */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable                                   */
                __IOM uint8_t RE   : 1; /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE   : 1; /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE  : 1; /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE  : 1; /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t TDR;             /*!< (@ 0x00000003) Transmit Data Register                                     */

        struct
        {
            __IOM uint8_t TDR : 8;     /*!< [7..0] TDR is an 8-bit register that stores transmit data.                */
        } TDR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SSR;          /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=0)         */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit Transfer                                       */
                __IM uint8_t  MPB  : 1; /*!< [1..1] Multi-Processor                                                    */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_b;
        };

        union
        {
            __IOM uint8_t SSR_FIFO;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=1)         */

            struct
            {
                __IOM uint8_t DR : 1;   /*!< [0..0] Receive Data Ready flag(Valid only in asynchronous mode(including
                                         *   multi-processor) and FIFO selected)                                       */
                uint8_t            : 1;
                __IOM uint8_t TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDF  : 1; /*!< [6..6] Receive FIFO data full flag                                        */
                __IOM uint8_t TDFE : 1; /*!< [7..7] Transmit FIFO data empty flag                                      */
            } SSR_FIFO_b;
        };

        union
        {
            __IOM uint8_t SSR_SMCI;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 1)                      */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit TransferThis bit should be 0 in smart
                                         *   card interface mode.                                                      */
                __IM uint8_t MPB : 1;   /*!< [1..1] Multi-ProcessorThis bit should be 0 in smart card interface
                                         *   mode.                                                                     */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t ERS  : 1; /*!< [4..4] Error Signal Status Flag                                           */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_SMCI_b;
        };
    };

    union
    {
        __IM uint8_t RDR;              /*!< (@ 0x00000005) Receive Data Register                                      */

        struct
        {
            __IM uint8_t RDR : 8;      /*!< [7..0] RDR is an 8-bit register that stores receive data.                 */
        } RDR_b;
    };

    union
    {
        __IOM uint8_t SCMR;            /*!< (@ 0x00000006) Smart Card Mode Register                                   */

        struct
        {
            __IOM uint8_t SMIF : 1;    /*!< [0..0] Smart Card Interface Mode Select                                   */
            uint8_t            : 1;
            __IOM uint8_t SINV : 1;    /*!< [2..2] Transmitted/Received Data InvertSet this bit to 0 if
                                        *   operation is to be in simple I2C mode.                                    */
            __IOM uint8_t SDIR : 1;    /*!< [3..3] Transmitted/Received Data Transfer DirectionNOTE: The
                                        *   setting is invalid and a fixed data length of 8 bits is
                                        *   used in modes other than asynchronous mode.Set this bit
                                        *   to 1 if operation is to be in simple I2C mode.                            */
            __IOM uint8_t CHR1 : 1;    /*!< [4..4] Character Length 1(Only valid in asynchronous mode)                */
            uint8_t            : 2;
            __IOM uint8_t BCP2 : 1;    /*!< [7..7] Base Clock Pulse 2Selects the number of base clock cycles
                                        *   in combination with the SMR.BCP[1:0] bits                                 */
        } SCMR_b;
    };

    union
    {
        __IOM uint8_t SEMR;            /*!< (@ 0x00000007) Serial Extended Mode Register                              */

        struct
        {
            __IOM uint8_t ACS0 : 1;    /*!< [0..0] Asynchronous Mode Clock Source Select (Valid only in
                                        *   asynchronous mode).                                                       */
            __IOM uint8_t PADIS : 1;   /*!< [1..1] Preamble function Disable (Valid only in asynchronous
                                        *   mode).                                                                    */
            __IOM uint8_t BRME  : 1;   /*!< [2..2] Bit Rate Modulation Enable                                         */
            __IOM uint8_t ABCSE : 1;   /*!< [3..3] Asynchronous Mode Extended Base Clock Select 1(Valid
                                        *   only in asynchronous mode and SCR.CKE[1]=0)                               */
            __IOM uint8_t ABCS : 1;    /*!< [4..4] Asynchronous Mode Base Clock Select(Valid only in asynchronous
                                        *   mode)                                                                     */
            __IOM uint8_t NFEN : 1;    /*!< [5..5] Digital Noise Filter Function Enable(The NFEN bit should
                                        *   be 0 without simple I2C mode and asynchronous mode.)In
                                        *   asynchronous mode, for RXDn input only. In simple I2C mode,
                                        *   for RXDn/TxDn input.                                                      */
            __IOM uint8_t BGDM : 1;    /*!< [6..6] Baud Rate Generator Double-Speed Mode Select(Only valid
                                        *   the CKE[1] bit in SCR is 0 in asynchronous mode).                         */
            __IOM uint8_t RXDESEL : 1; /*!< [7..7] Asynchronous Start Bit Edge Detection Select(Valid only
                                        *   in asynchronous mode)                                                     */
        } SEMR_b;
    };

    union
    {
        __IOM uint8_t SNFR;            /*!< (@ 0x00000008) Noise Filter Setting Register                              */

        struct
        {
            __IOM uint8_t NFCS : 3;    /*!< [2..0] Noise Filter Clock Select                                          */
            uint8_t            : 5;
        } SNFR_b;
    };

    union
    {
        __IOM uint8_t SIMR1;           /*!< (@ 0x00000009) I2C Mode Register 1                                        */

        struct
        {
            __IOM uint8_t IICM  : 1;   /*!< [0..0] Simple I2C Mode Select                                             */
            uint8_t             : 2;
            __IOM uint8_t IICDL : 5;   /*!< [7..3] SDA Delay Output SelectCycles below are of the clock
                                        *   signal from the on-chip baud rate generator.                              */
        } SIMR1_b;
    };

    union
    {
        __IOM uint8_t SIMR2;           /*!< (@ 0x0000000A) I2C Mode Register 2                                        */

        struct
        {
            __IOM uint8_t IICINTM : 1; /*!< [0..0] I2C Interrupt Mode Select                                          */
            __IOM uint8_t IICCSC  : 1; /*!< [1..1] Clock Synchronization                                              */
            uint8_t               : 3;
            __IOM uint8_t IICACKT : 1; /*!< [5..5] ACK Transmission Data                                              */
            uint8_t               : 2;
        } SIMR2_b;
    };

    union
    {
        __IOM uint8_t SIMR3;              /*!< (@ 0x0000000B) I2C Mode Register 3                                        */

        struct
        {
            __IOM uint8_t IICSTAREQ  : 1; /*!< [0..0] Start Condition Generation                                         */
            __IOM uint8_t IICRSTAREQ : 1; /*!< [1..1] Restart Condition Generation                                       */
            __IOM uint8_t IICSTPREQ  : 1; /*!< [2..2] Stop Condition Generation                                          */
            __IOM uint8_t IICSTIF    : 1; /*!< [3..3] Issuing of Start, Restart, or Stop Condition Completed
                                           *   Flag(When 0 is written to IICSTIF, it is cleared to 0.)                   */
            __IOM uint8_t IICSDAS : 2;    /*!< [5..4] SDA Output Select                                                  */
            __IOM uint8_t IICSCLS : 2;    /*!< [7..6] SCL Output Select                                                  */
        } SIMR3_b;
    };

    union
    {
        __IM uint8_t SISR;             /*!< (@ 0x0000000C) I2C Status Register                                        */

        struct
        {
            __IM uint8_t IICACKR : 1;  /*!< [0..0] ACK Reception Data Flag                                            */
            uint8_t              : 7;
        } SISR_b;
    };

    union
    {
        __IOM uint8_t SPMR;            /*!< (@ 0x0000000D) SPI Mode Register                                          */

        struct
        {
            __IOM uint8_t SSE    : 1;  /*!< [0..0] SSn Pin Function Enable                                            */
            __IOM uint8_t CTSE   : 1;  /*!< [1..1] CTS Enable                                                         */
            __IOM uint8_t MSS    : 1;  /*!< [2..2] Master Slave Select                                                */
            __IOM uint8_t CSTPEN : 1;  /*!< [3..3] CTS external pin Enable                                            */
            __IOM uint8_t MFF    : 1;  /*!< [4..4] Mode Fault Flag                                                    */
            uint8_t              : 1;
            __IOM uint8_t CKPOL  : 1;  /*!< [6..6] Clock Polarity Select                                              */
            __IOM uint8_t CKPH   : 1;  /*!< [7..7] Clock Phase Select                                                 */
        } SPMR_b;
    };

    union
    {
        union
        {
            __IOM uint16_t TDRHL;         /*!< (@ 0x0000000E) Transmit 9-bit Data Register                               */

            struct
            {
                __OM uint16_t TDRHL : 16; /*!< [15..0] TDRHL is a 16-bit register that stores transmit data.             */
            } TDRHL_b;
        };

        union
        {
            __OM uint16_t FTDRHL;       /*!< (@ 0x0000000E) Transmit FIFO Data Register HL                             */

            struct
            {
                __OM uint16_t TDAT : 9; /*!< [8..0] Serial transmit data (Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __OM uint16_t MPBT : 1; /*!< [9..9] Multi-processor transfer bit flag(Valid only in asynchronous
                                         *   mode and SMR.MP=1 and FIFO selected)                                      */
                uint16_t : 6;
            } FTDRHL_b;
        };

        struct
        {
            union
            {
                __OM uint8_t FTDRH;         /*!< (@ 0x0000000E) Transmit FIFO Data Register H                              */

                struct
                {
                    __OM uint8_t TDATH : 1; /*!< [0..0] Serial transmit data (b8) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                    __OM uint8_t MPBT : 1;  /*!< [1..1] Multi-processor transfer bit flag(Valid only in asynchronous
                                             *   mode and SMR.MP=1 and FIFO selected)                                      */
                    uint8_t : 6;
                } FTDRH_b;
            };

            union
            {
                __OM uint8_t FTDRL;         /*!< (@ 0x0000000F) Transmit FIFO Data Register L                              */

                struct
                {
                    __OM uint8_t TDATL : 8; /*!< [7..0] Serial transmit data(b7-b0) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                } FTDRL_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint16_t RDRHL;          /*!< (@ 0x00000010) Receive 9-bit Data Register                                */

            struct
            {
                __IM uint16_t RDRHL : 16; /*!< [15..0] RDRHL is an 16-bit register that stores receive data.             */
            } RDRHL_b;
        };

        union
        {
            __IM uint16_t FRDRHL;       /*!< (@ 0x00000010) Receive FIFO Data Register HL                              */

            struct
            {
                __IM uint16_t RDAT : 9; /*!< [8..0] Serial receive data(Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __IM uint16_t MPB : 1;  /*!< [9..9] Multi-processor bit flag(Valid only in asynchronous mode
                                         *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                         *   bit corresponded to serial receive data(RDATA[8:0])                       */
                __IM uint16_t DR   : 1; /*!< [10..10] Receive data ready flag(It is same as SSR.DR)                    */
                __IM uint16_t PER  : 1; /*!< [11..11] Parity error flag                                                */
                __IM uint16_t FER  : 1; /*!< [12..12] Framing error flag                                               */
                __IM uint16_t ORER : 1; /*!< [13..13] Overrun error flag(It is same as SSR.ORER)                       */
                __IM uint16_t RDF  : 1; /*!< [14..14] Receive FIFO data full flag(It is same as SSR.RDF)               */
                uint16_t           : 1;
            } FRDRHL_b;
        };

        struct
        {
            union
            {
                __IM uint8_t FRDRH;         /*!< (@ 0x00000010) Receive FIFO Data Register H                               */

                struct
                {
                    __IM uint8_t RDATH : 1; /*!< [0..0] Serial receive data(b8)(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                    __IM uint8_t MPB : 1;   /*!< [1..1] Multi-processor bit flag(Valid only in asynchronous mode
                                             *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                             *   bit corresponded to serial receive data(RDATA[8:0])                       */
                    __IM uint8_t DR   : 1;  /*!< [2..2] Receive data ready flag(It is same as SSR.DR)                      */
                    __IM uint8_t PER  : 1;  /*!< [3..3] Parity error flag                                                  */
                    __IM uint8_t FER  : 1;  /*!< [4..4] Framing error flag                                                 */
                    __IM uint8_t ORER : 1;  /*!< [5..5] Overrun error flag(It is same as SSR.ORER)                         */
                    __IM uint8_t RDF  : 1;  /*!< [6..6] Receive FIFO data full flag(It is same as SSR.RDF)                 */
                    uint8_t           : 1;
                } FRDRH_b;
            };

            union
            {
                __IM uint8_t FRDRL;         /*!< (@ 0x00000011) Receive FIFO Data Register L                               */

                struct
                {
                    __IM uint8_t RDATL : 8; /*!< [7..0] Serial receive data(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)NOTE:
                                             *   When reading both of FRDRH register and FRDRL register,
                                             *   please read by an order of the FRDRH register and the FRDRL
                                             *   register.                                                                 */
                } FRDRL_b;
            };
        };
    };

    union
    {
        __IOM uint8_t MDDR;            /*!< (@ 0x00000012) Modulation Duty Register                                   */

        struct
        {
            __IOM uint8_t MDDR : 8;    /*!< [7..0] MDDR corrects the bit rate adjusted by the BRR register.           */
        } MDDR_b;
    };

    union
    {
        __IOM uint8_t DCCR;            /*!< (@ 0x00000013) Data Compare Match Control Register                        */

        struct
        {
            __IOM uint8_t DCMF  : 1;   /*!< [0..0] Data Compare Match Flag                                            */
            uint8_t             : 2;
            __IOM uint8_t DPER  : 1;   /*!< [3..3] Data Compare Match Parity Error Flag                               */
            __IOM uint8_t DFER  : 1;   /*!< [4..4] Data Compare Match Framing Error Flag                              */
            uint8_t             : 1;
            __IOM uint8_t IDSEL : 1;   /*!< [6..6] ID frame select(Valid only in asynchronous mode(including
                                        *   multi-processor)                                                          */
            __IOM uint8_t DCME : 1;    /*!< [7..7] Data Compare Match Enable(Valid only in asynchronous
                                        *   mode(including multi-processor)                                           */
        } DCCR_b;
    };

    union
    {
        __IOM uint16_t FCR;            /*!< (@ 0x00000014) FIFO Control Register                                      */

        struct
        {
            __IOM uint16_t FM : 1;     /*!< [0..0] FIFO Mode Select(Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode)                               */
            __IOM uint16_t RFRST : 1;  /*!< [1..1] Receive FIFO Data Register Reset(Valid only in FCR.FM=1)           */
            __IOM uint16_t TFRST : 1;  /*!< [2..2] Transmit FIFO Data Register Reset(Valid only in FCR.FM=1)          */
            __IOM uint16_t DRES  : 1;  /*!< [3..3] Receive data ready error select bit(When detecting a
                                        *   reception data ready, the interrupt request is selected.)                 */
            __IOM uint16_t TTRG : 4;   /*!< [7..4] Transmit FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RTRG : 4;   /*!< [11..8] Receive FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RSTRG : 4;  /*!< [15..12] RTS Output Active Trigger Number Select(Valid only
                                        *   in asynchronous mode(including multi-processor) or clock
                                        *   synchronous mode)                                                         */
        } FCR_b;
    };

    union
    {
        __IM uint16_t FDR;             /*!< (@ 0x00000016) FIFO Data Count Register                                   */

        struct
        {
            __IM uint16_t R : 5;       /*!< [4..0] Receive FIFO Data CountIndicate the quantity of receive
                                        *   data stored in FRDRH and FRDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t        : 3;
            __IM uint16_t T : 5;       /*!< [12..8] Transmit FIFO Data CountIndicate the quantity of non-transmit
                                        *   data stored in FTDRH and FTDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t : 3;
        } FDR_b;
    };

    union
    {
        __IM uint16_t LSR;             /*!< (@ 0x00000018) Line Status Register                                       */

        struct
        {
            __IM uint16_t ORER : 1;    /*!< [0..0] Overrun Error Flag (Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode, and FIFO selected)            */
            uint16_t           : 1;
            __IM uint16_t FNUM : 5;    /*!< [6..2] Framing Error CountIndicates the quantity of data with
                                        *   a framing error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t           : 1;
            __IM uint16_t PNUM : 5;    /*!< [12..8] Parity Error CountIndicates the quantity of data with
                                        *   a parity error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t : 3;
        } LSR_b;
    };

    union
    {
        __IOM uint16_t CDR;            /*!< (@ 0x0000001A) Compare Match Data Register                                */

        struct
        {
            __IOM uint16_t CMPD : 9;   /*!< [8..0] Compare Match DataCompare data pattern for address match
                                        *   wake-up function                                                          */
            uint16_t : 7;
        } CDR_b;
    };

    union
    {
        __IOM uint8_t SPTR;            /*!< (@ 0x0000001C) Serial Port Register                                       */

        struct
        {
            __IM uint8_t RXDMON : 1;   /*!< [0..0] Serial input data monitor bit(The state of the RXD terminal
                                        *   is shown.)                                                                */
            __IOM uint8_t SPB2DT : 1;  /*!< [1..1] Serial port break data select bit(The output level of
                                        *   TxD terminal is selected when SCR.TE = 0.)                                */
            __IOM uint8_t SPB2IO : 1;  /*!< [2..2] Serial port break I/O bit(It's selected whether the value
                                        *   of SPB2DT is output to TxD terminal.)                                     */
            uint8_t            : 1;
            __IOM uint8_t RINV : 1;    /*!< [4..4] RXD invert bit                                                     */
            __IOM uint8_t TINV : 1;    /*!< [5..5] TXD invert bit                                                     */
            __IOM uint8_t ASEN : 1;    /*!< [6..6] Adjust receive sampling timing enable                              */
            __IOM uint8_t ATEN : 1;    /*!< [7..7] Adjust transmit timing enable                                      */
        } SPTR_b;
    };

    union
    {
        __IOM uint8_t ACTR;            /*!< (@ 0x0000001D) Adjustment Communication Timing Register                   */

        struct
        {
            __IOM uint8_t AST : 3;     /*!< [2..0] Adjustment value for receive Sampling Timing                       */
            __IOM uint8_t AJD : 1;     /*!< [3..3] Adjustment Direction for receive sampling timing                   */
            __IOM uint8_t ATT : 3;     /*!< [6..4] Adjustment value for Transmit timing                               */
            __IOM uint8_t AET : 1;     /*!< [7..7] Adjustment edge for transmit timing                                */
        } ACTR_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t ESMER;           /*!< (@ 0x00000020) Extended Serial Module Enable Register                     */

        struct
        {
            __IOM uint8_t ESME : 1;    /*!< [0..0] Extended Serial Mode Enable                                        */
            uint8_t            : 7;
        } ESMER_b;
    };

    union
    {
        __IOM uint8_t CR0;             /*!< (@ 0x00000021) Control Register 0                                         */

        struct
        {
            uint8_t             : 1;
            __IM uint8_t  SFSF  : 1;   /*!< [1..1] Start Frame Status Flag                                            */
            __IM uint8_t  RXDSF : 1;   /*!< [2..2] RXDXn Input Status Flag                                            */
            __IOM uint8_t BRME  : 1;   /*!< [3..3] Bit Rate Measurement Enable                                        */
            uint8_t             : 4;
        } CR0_b;
    };

    union
    {
        __IOM uint8_t CR1;             /*!< (@ 0x00000022) Control Register 1                                         */

        struct
        {
            __IOM uint8_t BFE   : 1;   /*!< [0..0] Break Field Enable                                                 */
            __IOM uint8_t CF0RE : 1;   /*!< [1..1] Control Field 0 Reception Enable                                   */
            __IOM uint8_t CF1DS : 2;   /*!< [3..2] Control Field 1 Data Register Select                               */
            __IOM uint8_t PIBE  : 1;   /*!< [4..4] Priority Interrupt Bit Enable                                      */
            __IOM uint8_t PIBS  : 3;   /*!< [7..5] Priority Interrupt Bit Select                                      */
        } CR1_b;
    };

    union
    {
        __IOM uint8_t CR2;             /*!< (@ 0x00000023) Control Register 2                                         */

        struct
        {
            __IOM uint8_t DFCS : 3;    /*!< [2..0] RXDXn Signal Digital Filter Clock Select                           */
            uint8_t            : 1;
            __IOM uint8_t BCCS : 2;    /*!< [5..4] Bus Collision Detection Clock Select                               */
            __IOM uint8_t RTS  : 2;    /*!< [7..6] RXDXn Reception Sampling Timing Select                             */
        } CR2_b;
    };

    union
    {
        __IOM uint8_t CR3;             /*!< (@ 0x00000024) Control Register 3                                         */

        struct
        {
            __IOM uint8_t SDST : 1;    /*!< [0..0] Start Frame Detection Start                                        */
            uint8_t            : 7;
        } CR3_b;
    };

    union
    {
        __IOM uint8_t PCR;             /*!< (@ 0x00000025) Port Control Register                                      */

        struct
        {
            __IOM uint8_t TXDXPS : 1;  /*!< [0..0] TXDXn Signal Polarity Select                                       */
            __IOM uint8_t RXDXPS : 1;  /*!< [1..1] RXDXn Signal Polarity Select                                       */
            uint8_t              : 2;
            __IOM uint8_t SHARPS : 1;  /*!< [4..4] TXDXn/RXDXn Pin Multiplexing Select                                */
            uint8_t              : 3;
        } PCR_b;
    };

    union
    {
        __IOM uint8_t ICR;             /*!< (@ 0x00000026) Interrupt Control Register                                 */

        struct
        {
            __IOM uint8_t BFDIE  : 1;  /*!< [0..0] Break Field Low Width Detected Interrupt Enable                    */
            __IOM uint8_t CF0MIE : 1;  /*!< [1..1] Control Field 0 Match Detected Interrupt Enable                    */
            __IOM uint8_t CF1MIE : 1;  /*!< [2..2] Control Field 1 Match Detected Interrupt Enable                    */
            __IOM uint8_t PIBDIE : 1;  /*!< [3..3] Priority Interrupt Bit Detected Interrupt Enable                   */
            __IOM uint8_t BCDIE  : 1;  /*!< [4..4] Bus Collision Detected Interrupt Enable                            */
            __IOM uint8_t AEDIE  : 1;  /*!< [5..5] Valid Edge Detected Interrupt Enable                               */
            uint8_t              : 2;
        } ICR_b;
    };

    union
    {
        __IM uint8_t STR;              /*!< (@ 0x00000027) Status Register                                            */

        struct
        {
            __IM uint8_t BFDF  : 1;    /*!< [0..0] Break Field Low Width Detection Flag                               */
            __IM uint8_t CF0MF : 1;    /*!< [1..1] Control Field 0 Match Flag                                         */
            __IM uint8_t CF1MF : 1;    /*!< [2..2] Control Field 1 Match Flag                                         */
            __IM uint8_t PIBDF : 1;    /*!< [3..3] Priority Interrupt Bit Detection Flag                              */
            __IM uint8_t BCDF  : 1;    /*!< [4..4] Bus Collision Detected Flag                                        */
            __IM uint8_t AEDF  : 1;    /*!< [5..5] Valid Edge Detection Flag                                          */
            uint8_t            : 2;
        } STR_b;
    };

    union
    {
        __IOM uint8_t STCR;            /*!< (@ 0x00000028) Status Clear Register                                      */

        struct
        {
            __IOM uint8_t BFDCL  : 1;  /*!< [0..0] BFDF Clear                                                         */
            __IOM uint8_t CF0MCL : 1;  /*!< [1..1] CF0MF Clear                                                        */
            __IOM uint8_t CF1MCL : 1;  /*!< [2..2] CF1MF Clear                                                        */
            __IOM uint8_t PIBDCL : 1;  /*!< [3..3] PIBDF Clear                                                        */
            __IOM uint8_t BCDCL  : 1;  /*!< [4..4] BCDF Clear                                                         */
            __IOM uint8_t AEDCL  : 1;  /*!< [5..5] AEDF Clear                                                         */
            uint8_t              : 2;
        } STCR_b;
    };
    __IOM uint8_t CF0DR;               /*!< (@ 0x00000029) Control Field 0 Data Register                              */

    union
    {
        __IOM uint8_t CF0CR;           /*!< (@ 0x0000002A) Control Field 0 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF0CE0 : 1;  /*!< [0..0] Control Field 0 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE1 : 1;  /*!< [1..1] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE2 : 1;  /*!< [2..2] Control Field 2 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE3 : 1;  /*!< [3..3] Control Field 3 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE4 : 1;  /*!< [4..4] Control Field 4 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE5 : 1;  /*!< [5..5] Control Field 5 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE6 : 1;  /*!< [6..6] Control Field 6 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE7 : 1;  /*!< [7..7] Control Field 7 Bit 0 Compare Enable                               */
        } CF0CR_b;
    };
    __IOM uint8_t CF0RR;               /*!< (@ 0x0000002B) Control Field 0 Receive Data Register                      */
    __IOM uint8_t PCF1DR;              /*!< (@ 0x0000002C) Primary Control Field 1 Data Register                      */
    __IOM uint8_t SCF1DR;              /*!< (@ 0x0000002D) Secondary Control Field 1 Data Register                    */

    union
    {
        __IOM uint8_t CF1CR;           /*!< (@ 0x0000002E) Control Field 1 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF1CE0 : 1;  /*!< [0..0] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF1CE1 : 1;  /*!< [1..1] Control Field 1 Bit 1 Compare Enable                               */
            __IOM uint8_t CF1CE2 : 1;  /*!< [2..2] Control Field 1 Bit 2 Compare Enable                               */
            __IOM uint8_t CF1CE3 : 1;  /*!< [3..3] Control Field 1 Bit 3 Compare Enable                               */
            __IOM uint8_t CF1CE4 : 1;  /*!< [4..4] Control Field 1 Bit 4 Compare Enable                               */
            __IOM uint8_t CF1CE5 : 1;  /*!< [5..5] Control Field 1 Bit 5 Compare Enable                               */
            __IOM uint8_t CF1CE6 : 1;  /*!< [6..6] Control Field 1 Bit 6 Compare Enable                               */
            __IOM uint8_t CF1CE7 : 1;  /*!< [7..7] Control Field 1 Bit 7 Compare Enable                               */
        } CF1CR_b;
    };
    __IOM uint8_t CF1RR;               /*!< (@ 0x0000002F) Control Field 1 Receive Data Register                      */

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000030) Timer Control Register                                     */

        struct
        {
            __IOM uint8_t TCST : 1;    /*!< [0..0] Timer Count Start                                                  */
            uint8_t            : 7;
        } TCR_b;
    };

    union
    {
        __IOM uint8_t TMR;             /*!< (@ 0x00000031) Timer Mode Register                                        */

        struct
        {
            __IOM uint8_t TOMS : 2;    /*!< [1..0] Timer Operating Mode Select                                        */
            uint8_t            : 1;
            __IOM uint8_t TWRC : 1;    /*!< [3..3] Counter Write Control                                              */
            __IOM uint8_t TCSS : 3;    /*!< [6..4] Timer Count Clock Source Select                                    */
            uint8_t            : 1;
        } TMR_b;
    };
    __IOM uint8_t TPRE;                /*!< (@ 0x00000032) Timer Prescaler Register                                   */
    __IOM uint8_t TCNT;                /*!< (@ 0x00000033) Timer Count Register                                       */
} R_SCI0_Type;                         /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SPI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Peripheral Interface (R_SPI0)
 */

typedef struct                         /*!< (@ 0x40072000) R_SPI0 Structure                                           */
{
    union
    {
        __IOM uint8_t SPCR;            /*!< (@ 0x00000000) SPI Control Register                                       */

        struct
        {
            __IOM uint8_t SPMS   : 1;  /*!< [0..0] SPI Mode Select                                                    */
            __IOM uint8_t TXMD   : 1;  /*!< [1..1] Communications Operating Mode Select                               */
            __IOM uint8_t MODFEN : 1;  /*!< [2..2] Mode Fault Error Detection Enable                                  */
            __IOM uint8_t MSTR   : 1;  /*!< [3..3] SPI Master/Slave Mode Select                                       */
            __IOM uint8_t SPEIE  : 1;  /*!< [4..4] SPI Error Interrupt Enable                                         */
            __IOM uint8_t SPTIE  : 1;  /*!< [5..5] Transmit Buffer Empty Interrupt Enable                             */
            __IOM uint8_t SPE    : 1;  /*!< [6..6] SPI Function Enable                                                */
            __IOM uint8_t SPRIE  : 1;  /*!< [7..7] SPI Receive Buffer Full Interrupt Enable                           */
        } SPCR_b;
    };

    union
    {
        __IOM uint8_t SSLP;            /*!< (@ 0x00000001) SPI Slave Select Polarity Register                         */

        struct
        {
            __IOM uint8_t SSL0P : 1;   /*!< [0..0] SSL0 Signal Polarity Setting                                       */
            __IOM uint8_t SSL1P : 1;   /*!< [1..1] SSL1 Signal Polarity Setting                                       */
            __IOM uint8_t SSL2P : 1;   /*!< [2..2] SSL2 Signal Polarity Setting                                       */
            __IOM uint8_t SSL3P : 1;   /*!< [3..3] SSL3 Signal Polarity Setting                                       */
            __IOM uint8_t SSL4P : 1;   /*!< [4..4] SSL4 Signal Polarity Setting                                       */
            __IOM uint8_t SSL5P : 1;   /*!< [5..5] SSL5 Signal Polarity Setting                                       */
            __IOM uint8_t SSL6P : 1;   /*!< [6..6] SSL6 Signal Polarity Setting                                       */
            __IOM uint8_t SSL7P : 1;   /*!< [7..7] SSL7 Signal Polarity Setting                                       */
        } SSLP_b;
    };

    union
    {
        __IOM uint8_t SPPCR;           /*!< (@ 0x00000002) SPI Pin Control Register                                   */

        struct
        {
            __IOM uint8_t SPLP  : 1;   /*!< [0..0] SPI Loopback                                                       */
            __IOM uint8_t SPLP2 : 1;   /*!< [1..1] SPI Loopback 2                                                     */
            uint8_t             : 2;
            __IOM uint8_t MOIFV : 1;   /*!< [4..4] MOSI Idle Fixed Value                                              */
            __IOM uint8_t MOIFE : 1;   /*!< [5..5] MOSI Idle Value Fixing Enable                                      */
            uint8_t             : 2;
        } SPPCR_b;
    };

    union
    {
        __IOM uint8_t SPSR;            /*!< (@ 0x00000003) SPI Status Register                                        */

        struct
        {
            __IOM uint8_t OVRF  : 1;   /*!< [0..0] Overrun Error Flag                                                 */
            __IM uint8_t  IDLNF : 1;   /*!< [1..1] SPI Idle Flag                                                      */
            __IOM uint8_t MODF  : 1;   /*!< [2..2] Mode Fault Error Flag                                              */
            __IOM uint8_t PERF  : 1;   /*!< [3..3] Parity Error Flag                                                  */
            __IOM uint8_t UDRF  : 1;   /*!< [4..4] Underrun Error Flag(When MODF is 0, This bit is invalid.)          */
            __IOM uint8_t SPTEF : 1;   /*!< [5..5] SPI Transmit Buffer Empty Flag                                     */
            __IOM uint8_t CENDF : 1;   /*!< [6..6] Communication End Flag                                             */
            __IOM uint8_t SPRF  : 1;   /*!< [7..7] SPI Receive Buffer Full Flag                                       */
        } SPSR_b;
    };

    union
    {
        __IOM uint32_t SPDR;           /*!< (@ 0x00000004) SPI Data Register                                          */
        __IOM uint16_t SPDR_HA;        /*!< (@ 0x00000004) SPI Data Register ( halfword access )                      */
        __IOM uint8_t  SPDR_BY;        /*!< (@ 0x00000004) SPI Data Register ( byte access )                          */
    };

    union
    {
        __IOM uint8_t SPSCR;           /*!< (@ 0x00000008) SPI Sequence Control Register                              */

        struct
        {
            __IOM uint8_t SPSLN : 3;   /*!< [2..0] RSPI Sequence Length SpecificationThe order in which
                                        *   the SPCMD0 to SPCMD07 registers are to be referenced is
                                        *   changed in accordance with the sequence length that is
                                        *   set in these bits. The relationship among the setting of
                                        *   these bits, sequence length, and SPCMD0 to SPCMD7 registers
                                        *   referenced by the RSPI is shown above. However, the RSPI
                                        *   in slave mode always references SPCMD0.                                   */
            uint8_t : 5;
        } SPSCR_b;
    };

    union
    {
        __IM uint8_t SPSSR;            /*!< (@ 0x00000009) SPI Sequence Status Register                               */

        struct
        {
            __IM uint8_t SPCP  : 3;    /*!< [2..0] RSPI Command Pointer                                               */
            uint8_t            : 1;
            __IM uint8_t SPECM : 3;    /*!< [6..4] RSPI Error Command                                                 */
            uint8_t            : 1;
        } SPSSR_b;
    };

    union
    {
        __IOM uint8_t SPBR;            /*!< (@ 0x0000000A) SPI Bit Rate Register                                      */

        struct
        {
            __IOM uint8_t SPR : 8;     /*!< [7..0] SPBR sets the bit rate in master mode.                             */
        } SPBR_b;
    };

    union
    {
        __IOM uint8_t SPDCR;           /*!< (@ 0x0000000B) SPI Data Control Register                                  */

        struct
        {
            __IOM uint8_t SPFC   : 2;  /*!< [1..0] Number of Frames Specification                                     */
            __IOM uint8_t SLSEL  : 2;  /*!< [3..2] SSL Pin Output Select                                              */
            __IOM uint8_t SPRDTD : 1;  /*!< [4..4] SPI Receive/Transmit Data Selection                                */
            __IOM uint8_t SPLW   : 1;  /*!< [5..5] SPI Word Access/Halfword Access Specification                      */
            __IOM uint8_t SPBYT  : 1;  /*!< [6..6] SPI Byte Access Specification                                      */
            uint8_t              : 1;
        } SPDCR_b;
    };

    union
    {
        __IOM uint8_t SPCKD;           /*!< (@ 0x0000000C) SPI Clock Delay Register                                   */

        struct
        {
            __IOM uint8_t SCKDL : 3;   /*!< [2..0] RSPCK Delay Setting                                                */
            uint8_t             : 5;
        } SPCKD_b;
    };

    union
    {
        __IOM uint8_t SSLND;           /*!< (@ 0x0000000D) SPI Slave Select Negation Delay Register                   */

        struct
        {
            __IOM uint8_t SLNDL : 3;   /*!< [2..0] SSL Negation Delay Setting                                         */
            uint8_t             : 5;
        } SSLND_b;
    };

    union
    {
        __IOM uint8_t SPND;            /*!< (@ 0x0000000E) SPI Next-Access Delay Register                             */

        struct
        {
            __IOM uint8_t SPNDL : 3;   /*!< [2..0] SPI Next-Access Delay Setting                                      */
            uint8_t             : 5;
        } SPND_b;
    };

    union
    {
        __IOM uint8_t SPCR2;           /*!< (@ 0x0000000F) SPI Control Register 2                                     */

        struct
        {
            __IOM uint8_t SPPE   : 1;  /*!< [0..0] Parity Enable                                                      */
            __IOM uint8_t SPOE   : 1;  /*!< [1..1] Parity Mode                                                        */
            __IOM uint8_t SPIIE  : 1;  /*!< [2..2] SPI Idle Interrupt Enable                                          */
            __IOM uint8_t PTE    : 1;  /*!< [3..3] Parity Self-Testing                                                */
            __IOM uint8_t SCKASE : 1;  /*!< [4..4] RSPCK Auto-Stop Function Enable                                    */
            __IOM uint8_t SPTDDL : 3;  /*!< [7..5] RSPI Transmit Data Delay                                           */
        } SPCR2_b;
    };

    union
    {
        __IOM uint16_t SPCMD[8];       /*!< (@ 0x00000010) SPI Command Register [0..7]                                */

        struct
        {
            __IOM uint16_t CPHA   : 1; /*!< [0..0] RSPCK Phase Setting                                                */
            __IOM uint16_t CPOL   : 1; /*!< [1..1] RSPCK Polarity Setting                                             */
            __IOM uint16_t BRDV   : 2; /*!< [3..2] Bit Rate Division Setting                                          */
            __IOM uint16_t SSLA   : 3; /*!< [6..4] SSL Signal Assertion Setting                                       */
            __IOM uint16_t SSLKP  : 1; /*!< [7..7] SSL Signal Level Keeping                                           */
            __IOM uint16_t SPB    : 4; /*!< [11..8] SPI Data Length Setting                                           */
            __IOM uint16_t LSBF   : 1; /*!< [12..12] SPI LSB First                                                    */
            __IOM uint16_t SPNDEN : 1; /*!< [13..13] SPI Next-Access Delay Enable                                     */
            __IOM uint16_t SLNDEN : 1; /*!< [14..14] SSL Negation Delay Setting Enable                                */
            __IOM uint16_t SCKDEN : 1; /*!< [15..15] RSPCK Delay Setting Enable                                       */
        } SPCMD_b[8];
    };

    union
    {
        __IOM uint8_t SPDCR2;          /*!< (@ 0x00000020) SPI Data Control Register 2                                */

        struct
        {
            __IOM uint8_t BYSW : 1;    /*!< [0..0] Byte Swap Operating Mode Select                                    */
            __IOM uint8_t SINV : 1;    /*!< [1..1] Serial data invert bit                                             */
            uint8_t            : 6;
        } SPDCR2_b;
    };

    union
    {
        __IOM uint8_t SPCR3;           /*!< (@ 0x00000021) RSPI Control Register 3                                    */

        struct
        {
            __IOM uint8_t ETXMD  : 1;  /*!< [0..0] Extended Communication Mode Select                                 */
            __IOM uint8_t BFDS   : 1;  /*!< [1..1] Between Burst Transfer Frames Delay Select                         */
            uint8_t              : 2;
            __IOM uint8_t CENDIE : 1;  /*!< [4..4] RSPI Communication End Interrupt Enable                            */
            uint8_t              : 3;
        } SPCR3_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[6];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t SPPR;           /*!< (@ 0x0000003E) RSPI Parameter Read Register                               */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t BUFWID : 1; /*!< [4..4] Buffer Width check                                                 */
            uint16_t              : 3;
            __IOM uint16_t BUFNUM : 3; /*!< [10..8] Buffer Number check                                               */
            uint16_t              : 1;
            __IOM uint16_t CMDNUM : 4; /*!< [15..12] Command Number check                                             */
        } SPPR_b;
    };
} R_SPI0_Type;                         /*!< Size = 64 (0x40)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SRAM                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief SRAM (R_SRAM)
 */

typedef struct                         /*!< (@ 0x40002000) R_SRAM Structure                                           */
{
    union
    {
        __IOM uint8_t PARIOAD;         /*!< (@ 0x00000000) SRAM Parity Error Operation After Detection Register       */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } PARIOAD_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t SRAMPRCR;         /*!< (@ 0x00000004) SRAM Protection Register                                   */

        struct
        {
            __IOM uint8_t SRAMPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW       : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR_b;
    };
    __IM uint8_t  RESERVED1[3];
    __IOM uint8_t SRAMWTSC;             /*!< (@ 0x00000008) RAM Wait State Control Register                            */
    __IM uint8_t  RESERVED2[3];

    union
    {
        __IOM uint8_t SRAMPRCR2;         /*!< (@ 0x0000000C) SRAM Protection Register 2                                 */

        struct
        {
            __IOM uint8_t SRAMPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW        : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR2_b;
    };
    __IM uint8_t RESERVED3[179];

    union
    {
        __IOM uint8_t ECCMODE;         /*!< (@ 0x000000C0) ECC Operating Mode Control Register                        */

        struct
        {
            __IOM uint8_t ECCMOD : 2;  /*!< [1..0] ECC Operating Mode Select                                          */
            uint8_t              : 6;
        } ECCMODE_b;
    };

    union
    {
        __IOM uint8_t ECC2STS;         /*!< (@ 0x000000C1) ECC 2-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC2ERR : 1; /*!< [0..0] ECC 2-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC2STS_b;
    };

    union
    {
        __IOM uint8_t ECC1STSEN;       /*!< (@ 0x000000C2) ECC 1-Bit Error Information Update Enable Register         */

        struct
        {
            __IOM uint8_t E1STSEN : 1; /*!< [0..0] ECC 1-Bit Error Information Update Enable                          */
            uint8_t               : 7;
        } ECC1STSEN_b;
    };

    union
    {
        __IOM uint8_t ECC1STS;         /*!< (@ 0x000000C3) ECC 1-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC1ERR : 1; /*!< [0..0] ECC 1-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC1STS_b;
    };

    union
    {
        __IOM uint8_t ECCPRCR;         /*!< (@ 0x000000C4) ECC Protection Register                                    */

        struct
        {
            __IOM uint8_t ECCPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR_b;
    };
    __IM uint8_t RESERVED4[11];

    union
    {
        __IOM uint8_t ECCPRCR2;         /*!< (@ 0x000000D0) ECC Protection Register 2                                  */

        struct
        {
            __IOM uint8_t ECCPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW2      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR2_b;
    };
    __IM uint8_t RESERVED5[3];

    union
    {
        __IOM uint8_t ECCETST;         /*!< (@ 0x000000D4) ECC Test Control Register                                  */

        struct
        {
            __IOM uint8_t TSTBYP : 1;  /*!< [0..0] ECC Bypass Select                                                  */
            uint8_t              : 7;
        } ECCETST_b;
    };
    __IM uint8_t RESERVED6[3];

    union
    {
        __IOM uint8_t ECCOAD;          /*!< (@ 0x000000D8) SRAM ECC Error Operation After Detection Register          */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } ECCOAD_b;
    };
} R_SRAM_Type;                         /*!< Size = 217 (0xd9)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_SYSTEM                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief System Pins (R_SYSTEM)
 */

typedef struct                         /*!< (@ 0x4001E000) R_SYSTEM Structure                                         */
{
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint16_t SBYCR;          /*!< (@ 0x0000000C) Standby Control Register                                   */

        struct
        {
            uint16_t            : 14;
            __IOM uint16_t OPE  : 1;   /*!< [14..14] Output Port Enable                                               */
            __IOM uint16_t SSBY : 1;   /*!< [15..15] Software Standby                                                 */
        } SBYCR_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x0000001C) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module Stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module Stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module Stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module Stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module Stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module Stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module Stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module Stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module Stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module Stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module Stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module Stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module Stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module Stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module Stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module Stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module Stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module Stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module Stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module Stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module Stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module Stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module Stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module Stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module Stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module Stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module Stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module Stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module Stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module Stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module Stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module Stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t SCKDIVCR;       /*!< (@ 0x00000020) System Clock Division Control Register                     */

        struct
        {
            __IOM uint32_t PCKD : 3;   /*!< [2..0] Peripheral Module Clock D (PCLKD) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKC : 3;   /*!< [6..4] Peripheral Module Clock C (PCLKC) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKB : 3;   /*!< [10..8] Peripheral Module Clock B (PCLKB) Select                          */
            uint32_t            : 1;
            __IOM uint32_t PCKA : 3;   /*!< [14..12] Peripheral Module Clock A (PCLKA) Select                         */
            uint32_t            : 1;
            __IOM uint32_t BCK  : 3;   /*!< [18..16] External Bus Clock (BCLK) Select                                 */
            uint32_t            : 5;
            __IOM uint32_t ICK  : 3;   /*!< [26..24] System Clock (ICLK) Select                                       */
            uint32_t            : 1;
            __IOM uint32_t FCK  : 3;   /*!< [30..28] Flash IF Clock (FCLK) Select                                     */
            uint32_t            : 1;
        } SCKDIVCR_b;
    };

    union
    {
        __IOM uint8_t SCKDIVCR2;       /*!< (@ 0x00000024) System Clock Division Control Register 2                   */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t UCK : 3;     /*!< [6..4] USB Clock (UCLK) Select                                            */
            uint8_t           : 1;
        } SCKDIVCR2_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IOM uint8_t SCKSCR;          /*!< (@ 0x00000026) System Clock Source Control Register                       */

        struct
        {
            __IOM uint8_t CKSEL : 3;   /*!< [2..0] Clock Source Select                                                */
            uint8_t             : 5;
        } SCKSCR_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint16_t PLLCCR;           /*!< (@ 0x00000028) PLL Clock Control Register                                 */

        struct
        {
            __IOM uint16_t PLIDIV   : 2; /*!< [1..0] PLL Input Frequency Division Ratio Select                          */
            uint16_t                : 2;
            __IOM uint16_t PLSRCSEL : 1; /*!< [4..4] PLL Clock Source Select                                            */
            uint16_t                : 3;
            __IOM uint16_t PLLMUL   : 6; /*!< [13..8] PLL Frequency Multiplication Factor Select [PLL Frequency
                                          *   Multiplication Factor] = (PLLUMUL+1) / 2 Range: 0x23 -
                                          *   0x3B for example 010011: x10.0 010100: x10.5 010101: x11.0
                                          *   : 011100: x14.5 011101: x15.0 011110: x15.5 : 111010: x29.5
                                          *   111011: x30.0                                                             */
            uint16_t : 2;
        } PLLCCR_b;
    };

    union
    {
        __IOM uint8_t PLLCR;           /*!< (@ 0x0000002A) PLL Control Register                                       */

        struct
        {
            __IOM uint8_t PLLSTP : 1;  /*!< [0..0] PLL Stop Control                                                   */
            uint8_t              : 7;
        } PLLCR_b;
    };

    union
    {
        __IOM uint8_t PLLCCR2;         /*!< (@ 0x0000002B) PLL Clock Control Register2                                */

        struct
        {
            __IOM uint8_t PLLMUL : 5;  /*!< [4..0] PLL Frequency Multiplication Factor Select                         */
            uint8_t              : 1;
            __IOM uint8_t PLODIV : 2;  /*!< [7..6] PLL Output Frequency Division Ratio Select                         */
        } PLLCCR2_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint8_t BCKCR;           /*!< (@ 0x00000030) External Bus Clock Control Register                        */

        struct
        {
            __IOM uint8_t BCLKDIV : 1; /*!< [0..0] BCLK Pin Output Select                                             */
            uint8_t               : 7;
        } BCKCR_b;
    };

    union
    {
        __IOM uint8_t MEMWAIT;         /*!< (@ 0x00000031) Memory Wait Cycle Control Register                         */

        struct
        {
            __IOM uint8_t MEMWAIT : 1; /*!< [0..0] Memory Wait Cycle SelectNote: Writing 0 to the MEMWAIT
                                        *   is prohibited when SCKDIVCR.ICK selects division by 1 and
                                        *   SCKSCR.CKSEL[2:0] bits select thesystem clock source that
                                        *   is faster than 32 MHz (ICLK > 32 MHz).                                    */
            uint8_t : 7;
        } MEMWAIT_b;
    };

    union
    {
        __IOM uint8_t MOSCCR;          /*!< (@ 0x00000032) Main Clock Oscillator Control Register                     */

        struct
        {
            __IOM uint8_t MOSTP : 1;   /*!< [0..0] Main Clock Oscillator Stop                                         */
            uint8_t             : 7;
        } MOSCCR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint8_t HOCOCR;          /*!< (@ 0x00000036) High-Speed On-Chip Oscillator Control Register             */

        struct
        {
            __IOM uint8_t HCSTP : 1;   /*!< [0..0] HOCO Stop                                                          */
            uint8_t             : 7;
        } HOCOCR_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t MOCOCR;          /*!< (@ 0x00000038) Middle-Speed On-Chip Oscillator Control Register           */

        struct
        {
            __IOM uint8_t MCSTP : 1;   /*!< [0..0] MOCO Stop                                                          */
            uint8_t             : 7;
        } MOCOCR_b;
    };

    union
    {
        __IOM uint8_t FLLCR1;          /*!< (@ 0x00000039) FLL Control Register 1                                     */

        struct
        {
            __IOM uint8_t FLLEN : 1;   /*!< [0..0] FLL Enable                                                         */
            uint8_t             : 7;
        } FLLCR1_b;
    };

    union
    {
        __IOM uint16_t FLLCR2;           /*!< (@ 0x0000003A) FLL Control Register 2                                     */

        struct
        {
            __IOM uint16_t FLLCNTL : 11; /*!< [10..0] FLL Multiplication ControlMultiplication ratio of the
                                          *   FLL reference clock select                                                */
            uint16_t : 5;
        } FLLCR2_b;
    };

    union
    {
        __IM uint8_t OSCSF;            /*!< (@ 0x0000003C) Oscillation Stabilization Flag Register                    */

        struct
        {
            __IM uint8_t HOCOSF : 1;   /*!< [0..0] HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF
                                        *   bit value after a reset is 1 when the OFS1.HOCOEN bit is
                                        *   0. It is 0 when the OFS1.HOCOEN bit is 1.                                 */
            uint8_t             : 2;
            __IM uint8_t MOSCSF : 1;   /*!< [3..3] Main Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
            __IM uint8_t PLLSF  : 1;   /*!< [5..5] PLL Clock Oscillation Stabilization Flag                           */
            __IM uint8_t PLL2SF : 1;   /*!< [6..6] PLL2 Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
        } OSCSF_b;
    };
    __IM uint8_t RESERVED9;

    union
    {
        __IOM uint8_t CKOCR;           /*!< (@ 0x0000003E) Clock Out Control Register                                 */

        struct
        {
            __IOM uint8_t CKOSEL : 3;  /*!< [2..0] Clock out source select                                            */
            uint8_t              : 1;
            __IOM uint8_t CKODIV : 3;  /*!< [6..4] Clock out input frequency Division Select                          */
            __IOM uint8_t CKOEN  : 1;  /*!< [7..7] Clock out enable                                                   */
        } CKOCR_b;
    };

    union
    {
        __IOM uint8_t TRCKCR;          /*!< (@ 0x0000003F) Trace Clock Control Register                               */

        struct
        {
            __IOM uint8_t TRCK   : 4;  /*!< [3..0] Trace Clock operating frequency select                             */
            uint8_t              : 3;
            __IOM uint8_t TRCKEN : 1;  /*!< [7..7] Trace Clock operating Enable                                       */
        } TRCKCR_b;
    };

    union
    {
        __IOM uint8_t OSTDCR;          /*!< (@ 0x00000040) Oscillation Stop Detection Control Register                */

        struct
        {
            __IOM uint8_t OSTDIE : 1;  /*!< [0..0] Oscillation Stop Detection Interrupt Enable                        */
            uint8_t              : 6;
            __IOM uint8_t OSTDE  : 1;  /*!< [7..7] Oscillation Stop Detection Function Enable                         */
        } OSTDCR_b;
    };

    union
    {
        __IOM uint8_t OSTDSR;          /*!< (@ 0x00000041) Oscillation Stop Detection Status Register                 */

        struct
        {
            __IOM uint8_t OSTDF : 1;   /*!< [0..0] Oscillation Stop Detection Flag                                    */
            uint8_t             : 7;
        } OSTDSR_b;
    };
    __IM uint16_t RESERVED10;
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint16_t PLL2CCR;           /*!< (@ 0x00000048) PLL2 Clock Control Register                                */

        struct
        {
            __IOM uint16_t PL2IDIV   : 2; /*!< [1..0] PLL2 Input Frequency Division Ratio Select                         */
            uint16_t                 : 2;
            __IOM uint16_t PL2SRCSEL : 1; /*!< [4..4] PLL2 Clock Source Select                                           */
            uint16_t                 : 3;
            __IOM uint16_t PLL2MUL   : 6; /*!< [13..8] PLL2 Frequency Multiplication Factor Select                       */
            uint16_t                 : 2;
        } PLL2CCR_b;
    };

    union
    {
        __IOM uint8_t PLL2CR;          /*!< (@ 0x0000004A) PLL2 Control Register                                      */

        struct
        {
            __IOM uint8_t PLL2STP : 1; /*!< [0..0] PLL2 Stop Control                                                  */
            uint8_t               : 7;
        } PLL2CR_b;
    };
    __IM uint8_t RESERVED12;

    union
    {
        __IOM uint8_t LPOPT;             /*!< (@ 0x0000004C) Lower Power Operation Control Register                     */

        struct
        {
            __IOM uint8_t MPUDIS : 1;    /*!< [0..0] MPU Clock Disable Control. Stop the MPU operate clock
                                          *   (valid only when LPOPTEN = 1)                                             */
            __IOM uint8_t DCLKDIS   : 2; /*!< [2..1] Debug Clock Disable Control                                        */
            __IOM uint8_t BPFCLKDIS : 1; /*!< [3..3] BPF Clock Disable Control. Stop the Flash register R/W
                                          *   clock (valid only when LPOPT.LPOPTEN = 1)                                 */
            uint8_t               : 3;
            __IOM uint8_t LPOPTEN : 1;   /*!< [7..7] Lower Power Operation Enable                                       */
        } LPOPT_b;
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint8_t SLCDSCKCR;         /*!< (@ 0x00000050) Segment LCD Source Clock Control Register                  */

        struct
        {
            __IOM uint8_t LCDSCKSEL : 3; /*!< [2..0] LCD Source Clock (LCDSRCCLK) Select                                */
            uint8_t                 : 4;
            __IOM uint8_t LCDSCKEN  : 1; /*!< [7..7] LCD Source Clock Out Enable                                        */
        } SLCDSCKCR_b;
    };
    __IM uint8_t RESERVED15;

    union
    {
        __IOM uint8_t EBCKOCR;         /*!< (@ 0x00000052) External Bus Clock Output Control Register                 */

        struct
        {
            __IOM uint8_t EBCKOEN : 1; /*!< [0..0] BCLK Pin Output Control                                            */
            uint8_t               : 7;
        } EBCKOCR_b;
    };

    union
    {
        __IOM uint8_t SDCKOCR;         /*!< (@ 0x00000053) SDRAM Clock Output Control Register                        */

        struct
        {
            __IOM uint8_t SDCKOEN : 1; /*!< [0..0] SDCLK Pin Output Control                                           */
            uint8_t               : 7;
        } SDCKOCR_b;
    };
    __IM uint32_t RESERVED16[3];
    __IM uint8_t  RESERVED17;

    union
    {
        __IOM uint8_t MOCOUTCR;         /*!< (@ 0x00000061) MOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t MOCOUTRM : 8; /*!< [7..0] MOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original MOCO
                                         *   trimming bits                                                             */
        } MOCOUTCR_b;
    };

    union
    {
        __IOM uint8_t HOCOUTCR;         /*!< (@ 0x00000062) HOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t HOCOUTRM : 8; /*!< [7..0] HOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original HOCO
                                         *   trimming bits                                                             */
        } HOCOUTCR_b;
    };
    __IM uint8_t  RESERVED18;
    __IM uint32_t RESERVED19[2];

    union
    {
        __IOM uint8_t USBCKDIVCR;       /*!< (@ 0x0000006C) USB Clock Division Control Register                        */

        struct
        {
            __IOM uint8_t USBCKDIV : 3; /*!< [2..0] USB Clock (USBCLK) Division Select                                 */
            uint8_t                : 5;
        } USBCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKDIVCR;       /*!< (@ 0x0000006D) Octal-SPI Clock Division Control Register                  */

            struct
            {
                __IOM uint8_t OCTACKDIV : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Division Select                          */
                uint8_t                 : 5;
            } OCTACKDIVCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKDIVCR;       /*!< (@ 0x0000006D) SCI SPI Clock Division Control Register                    */

            struct
            {
                __IOM uint8_t SCISPICKDIV : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Division Select                          */
                uint8_t                   : 5;
            } SCISPICKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKDIVCR;       /*!< (@ 0x0000006E) CANFD Clock Division Control Register                      */

        struct
        {
            __IOM uint8_t CANFDCKDIV : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Division Select                             */
            uint8_t                  : 5;
        } CANFDCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKDIVCR;       /*!< (@ 0x0000006F) GPT Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t GPTCKDIV : 3; /*!< [2..0] GPT Clock (GPTCLK) Division Select                                 */
                uint8_t                : 5;
            } GPTCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKDIVCR;       /*!< (@ 0x0000006F) USB60 Clock Division Control Register                      */

            struct
            {
                __IOM uint8_t USB60CKDIV : 3; /*!< [2..0] USB clock (USB60CLK) Division Select                               */
                uint8_t                  : 5;
            } USB60CKDIVCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKDIVCR;       /*!< (@ 0x00000070) CEC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t CECCKDIV : 3; /*!< [2..0] CEC clock (CECCLK) Division Select                                 */
                uint8_t                : 5;
            } CECCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t IICCKDIVCR;       /*!< (@ 0x00000070) IIC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t IICCKDIV : 3; /*!< [2..0] IIC Clock (IICCLK) Division Select                                 */
                uint8_t                : 5;
            } IICCKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKDIVCR;       /*!< (@ 0x00000071) I3C clock Division control register                        */

        struct
        {
            __IOM uint8_t I3CCKDIV : 3; /*!< [2..0] I3C clock (I3CCLK) Division Select                                 */
            uint8_t                : 5;
        } I3CCKDIVCR_b;
    };
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint8_t USBCKCR;           /*!< (@ 0x00000074) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCKSEL  : 3; /*!< [2..0] USB Clock (USBCLK) Source Select                                   */
            uint8_t                 : 3;
            __IOM uint8_t USBCKSREQ : 1; /*!< [6..6] USB Clock (USBCLK) Switching Request                               */
            __IM uint8_t  USBCKSRDY : 1; /*!< [7..7] USB Clock (USBCLK) Switching Ready state flag                      */
        } USBCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKCR;           /*!< (@ 0x00000075) Octal-SPI Clock Control Register                           */

            struct
            {
                __IOM uint8_t OCTACKSEL  : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Source Select                            */
                uint8_t                  : 3;
                __IOM uint8_t OCTACKSREQ : 1; /*!< [6..6] Octal-SPI Clock (OCTACLK) Switching Request                        */
                __IM uint8_t  OCTACKSRDY : 1; /*!< [7..7] Octal-SPI Clock (OCTACLK) Switching Ready state flag               */
            } OCTACKCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKCR;           /*!< (@ 0x00000075) SCI SPI Clock Control Register                             */

            struct
            {
                __IOM uint8_t SCISPICKSEL  : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Source Select                            */
                uint8_t                    : 3;
                __IOM uint8_t SCISPICKSREQ : 1; /*!< [6..6] SCI SPI Clock (SCISPICLK) Switching Request                        */
                __IM uint8_t  SCISPICKSRDY : 1; /*!< [7..7] SCI SPI Clock (SCISPICLK) Switching Ready state flag               */
            } SCISPICKCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKCR;           /*!< (@ 0x00000076) CANFD Clock Control Register                               */

        struct
        {
            __IOM uint8_t CANFDCKSEL  : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Source Select                               */
            uint8_t                   : 3;
            __IOM uint8_t CANFDCKSREQ : 1; /*!< [6..6] CANFD Clock (CANFDCLK) Switching Request                           */
            __IM uint8_t  CANFDCKSRDY : 1; /*!< [7..7] CANFD Clock (CANFDCLK) Switching Ready state flag                  */
        } CANFDCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKCR;           /*!< (@ 0x00000077) GPT Clock Control Register                                 */

            struct
            {
                __IOM uint8_t GPTCKSEL  : 3; /*!< [2..0] GPT Clock (GPTCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t GPTCKSREQ : 1; /*!< [6..6] GPT Clock (GPTCLK) Switching Request                               */
                __IM uint8_t  GPTCKSRDY : 1; /*!< [7..7] GPT Clock (GPTCLK) Switching Ready state flag                      */
            } GPTCKCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKCR;           /*!< (@ 0x00000077) USB60 clock control register                               */

            struct
            {
                __IOM uint8_t USB60CKSEL  : 4; /*!< [3..0] USB clock (USB60CLK) Source Select                                 */
                uint8_t                   : 2;
                __IOM uint8_t USB60CKSREQ : 1; /*!< [6..6] USB clock (USB60CLK) Switching Request                             */
                __IOM uint8_t USB60CKSRDY : 1; /*!< [7..7] USB clock (USB60CLK) Switching Ready state flag                    */
            } USB60CKCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKCR;           /*!< (@ 0x00000078) CEC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t CECCKSEL  : 3; /*!< [2..0] CEC clock (CECCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t CECCKSREQ : 1; /*!< [6..6] CEC clock (CECCLK) Switching Request                               */
                __IM uint8_t  CECCKSRDY : 1; /*!< [7..7] CEC clock (CECCLK) Switching Ready state flag                      */
            } CECCKCR_b;
        };

        union
        {
            __IOM uint8_t IICCKCR;           /*!< (@ 0x00000078) IIC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t IICCKSEL  : 3; /*!< [2..0] IIC Clock (IICCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t IICCKSREQ : 1; /*!< [6..6] IIC Clock (IICCLK) Switching Request                               */
                __IM uint8_t  IICCKSRDY : 1; /*!< [7..7] IIC Clock (IICCLK) Switching Ready state flag                      */
            } IICCKCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKCR;           /*!< (@ 0x00000079) I3C Clock Control Register                                 */

        struct
        {
            __IOM uint8_t I3CCKSEL  : 3; /*!< [2..0] I3C clock (I3CCLK) source select                                   */
            uint8_t                 : 3;
            __IOM uint8_t I3CCKSREQ : 1; /*!< [6..6] I3C clock (I3CCLK) switching request                               */
            __IM uint8_t  I3CCKSRDY : 1; /*!< [7..7] I3C clock (I3CCLK) switching ready state flag                      */
        } I3CCKCR_b;
    };
    __IM uint16_t RESERVED21;
    __IM uint32_t RESERVED22[3];

    union
    {
        __IOM uint32_t SNZREQCR1;         /*!< (@ 0x00000088) Snooze Request Control Register 1                          */

        struct
        {
            __IOM uint32_t SNZREQEN0 : 1; /*!< [0..0] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN1 : 1; /*!< [1..1] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN2 : 1; /*!< [2..2] Enable AGT3 underflow snooze request                               */
            uint32_t                 : 29;
        } SNZREQCR1_b;
    };
    __IM uint32_t RESERVED23;
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t SNZCR;            /*!< (@ 0x00000092) Snooze Control Register                                    */

        struct
        {
            __IOM uint8_t RXDREQEN : 1; /*!< [0..0] RXD0 Snooze Request Enable NOTE: Do not set to 1 other
                                         *   than in asynchronous mode.                                                */
            __IOM uint8_t SNZDTCEN : 1; /*!< [1..1] DTC Enable in Snooze Mode                                          */
            uint8_t                : 5;
            __IOM uint8_t SNZE     : 1; /*!< [7..7] Snooze Mode Enable                                                 */
        } SNZCR_b;
    };
    __IM uint8_t RESERVED25;

    union
    {
        __IOM uint8_t SNZEDCR;           /*!< (@ 0x00000094) Snooze End Control Register                                */

        struct
        {
            __IOM uint8_t AGT1UNFED : 1; /*!< [0..0] AGT1 underflow Snooze End Enable                                   */
            __IOM uint8_t DTCZRED   : 1; /*!< [1..1] Last DTC transmission completion Snooze End Enable                 */
            __IOM uint8_t DTCNZRED  : 1; /*!< [2..2] Not Last DTC transmission completion Snooze End Enable             */
            __IOM uint8_t AD0MATED  : 1; /*!< [3..3] AD compare match 0 Snooze End Enable                               */
            __IOM uint8_t AD0UMTED  : 1; /*!< [4..4] AD compare mismatch 0 Snooze End Enable                            */
            __IOM uint8_t AD1MATED  : 1; /*!< [5..5] AD compare match 1 Snooze End Enable                               */
            __IOM uint8_t AD1UMTED  : 1; /*!< [6..6] AD compare mismatch 1 Snooze End Enable                            */
            __IOM uint8_t SCI0UMTED : 1; /*!< [7..7] SCI0 address unmatch Snooze End EnableNote: Do not set
                                          *   to 1 other than in asynchronous mode.                                     */
        } SNZEDCR_b;
    };

    union
    {
        __IOM uint8_t SNZEDCR1;          /*!< (@ 0x00000095) Snooze End Control Register 1                              */

        struct
        {
            __IOM uint8_t AGT3UNFED : 1; /*!< [0..0] AGT3 underflow Snooze End Enable                                   */
            uint8_t                 : 7;
        } SNZEDCR1_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint32_t SNZREQCR;           /*!< (@ 0x00000098) Snooze Request Control Register                            */

        struct
        {
            __IOM uint32_t SNZREQEN0  : 1; /*!< [0..0] Snooze Request Enable 0Enable IRQ 0 pin snooze request             */
            __IOM uint32_t SNZREQEN1  : 1; /*!< [1..1] Snooze Request Enable 0Enable IRQ 1 pin snooze request             */
            __IOM uint32_t SNZREQEN2  : 1; /*!< [2..2] Snooze Request Enable 0Enable IRQ 2 pin snooze request             */
            __IOM uint32_t SNZREQEN3  : 1; /*!< [3..3] Snooze Request Enable 0Enable IRQ 3 pin snooze request             */
            __IOM uint32_t SNZREQEN4  : 1; /*!< [4..4] Snooze Request Enable 0Enable IRQ 4 pin snooze request             */
            __IOM uint32_t SNZREQEN5  : 1; /*!< [5..5] Snooze Request Enable 0Enable IRQ 5 pin snooze request             */
            __IOM uint32_t SNZREQEN6  : 1; /*!< [6..6] Snooze Request Enable 0Enable IRQ 6 pin snooze request             */
            __IOM uint32_t SNZREQEN7  : 1; /*!< [7..7] Snooze Request Enable 0Enable IRQ 7 pin snooze request             */
            __IOM uint32_t SNZREQEN8  : 1; /*!< [8..8] Snooze Request Enable 0Enable IRQ 8 pin snooze request             */
            __IOM uint32_t SNZREQEN9  : 1; /*!< [9..9] Snooze Request Enable 0Enable IRQ 9 pin snooze request             */
            __IOM uint32_t SNZREQEN10 : 1; /*!< [10..10] Snooze Request Enable 0Enable IRQ 10 pin snooze request          */
            __IOM uint32_t SNZREQEN11 : 1; /*!< [11..11] Snooze Request Enable 0Enable IRQ 11 pin snooze request          */
            __IOM uint32_t SNZREQEN12 : 1; /*!< [12..12] Snooze Request Enable 0Enable IRQ 12 pin snooze request          */
            __IOM uint32_t SNZREQEN13 : 1; /*!< [13..13] Snooze Request Enable 0Enable IRQ 13 pin snooze request          */
            __IOM uint32_t SNZREQEN14 : 1; /*!< [14..14] Snooze Request Enable 0Enable IRQ 14 pin snooze request          */
            __IOM uint32_t SNZREQEN15 : 1; /*!< [15..15] Snooze Request Enable 0Enable IRQ 15 pin snooze request          */
            uint32_t                  : 1;
            __IOM uint32_t SNZREQEN17 : 1; /*!< [17..17] Snooze Request Enable 17Enable KR snooze request                 */
            uint32_t                  : 4;
            __IOM uint32_t SNZREQEN22 : 1; /*!< [22..22] Snooze Request Enable 22Enable Comparator-HS0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN23 : 1; /*!< [23..23] Snooze Request Enable 23Enable Comparator-LP0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN24 : 1; /*!< [24..24] Snooze Request Enable 24Enable RTC alarm snooze request          */
            __IOM uint32_t SNZREQEN25 : 1; /*!< [25..25] Snooze Request Enable 25Enable RTC period snooze request         */
            uint32_t                  : 2;
            __IOM uint32_t SNZREQEN28 : 1; /*!< [28..28] Snooze Request Enable 28Enable AGT1 underflow snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN29 : 1; /*!< [29..29] Snooze Request Enable 29Enable AGT1 compare match A
                                            *   snooze request                                                            */
            __IOM uint32_t SNZREQEN30 : 1; /*!< [30..30] Snooze Request Enable 30Enable AGT1 compare match B
                                            *   snooze request                                                            */
            uint32_t : 1;
        } SNZREQCR_b;
    };
    __IM uint16_t RESERVED27;

    union
    {
        __IOM uint8_t FLSTOP;          /*!< (@ 0x0000009E) Flash Operation Control Register                           */

        struct
        {
            __IOM uint8_t FLSTOP : 1;  /*!< [0..0] Selecting ON/OFF of the Flash Memory Operation                     */
            uint8_t              : 3;
            __IOM uint8_t FLSTPF : 1;  /*!< [4..4] Flash Memory Operation Status Flag                                 */
            uint8_t              : 3;
        } FLSTOP_b;
    };

    union
    {
        __IOM uint8_t PSMCR;           /*!< (@ 0x0000009F) Power Save Memory Control Register                         */

        struct
        {
            __IOM uint8_t PSMC : 2;    /*!< [1..0] Power save memory control.                                         */
            uint8_t            : 6;
        } PSMCR_b;
    };

    union
    {
        __IOM uint8_t OPCCR;           /*!< (@ 0x000000A0) Operating Power Control Register                           */

        struct
        {
            __IOM uint8_t OPCM   : 2;  /*!< [1..0] Operating Power Control Mode Select                                */
            uint8_t              : 2;
            __IM uint8_t OPCMTSF : 1;  /*!< [4..4] Operating Power Control Mode Transition Status Flag                */
            uint8_t              : 3;
        } OPCCR_b;
    };
    __IM uint8_t RESERVED28;

    union
    {
        __IOM uint8_t MOSCWTCR;        /*!< (@ 0x000000A2) Main Clock Oscillator Wait Control Register                */

        struct
        {
            __IOM uint8_t MSTS : 4;    /*!< [3..0] Main clock oscillator wait time setting                            */
            uint8_t            : 4;
        } MOSCWTCR_b;
    };
    __IM uint8_t RESERVED29[2];

    union
    {
        __IOM uint8_t HOCOWTCR;        /*!< (@ 0x000000A5) High-speed on-chip oscillator wait control register        */

        struct
        {
            __IOM uint8_t HSTS : 3;    /*!< [2..0] HOCO wait time settingWaiting time (sec) = setting of
                                        *   the HSTS[2:0] bits/fLOCO(Trimmed) + 3/fLOC(Untrimmed)                     */
            uint8_t : 5;
        } HOCOWTCR_b;
    };
    __IM uint16_t RESERVED30[2];

    union
    {
        __IOM uint8_t SOPCCR;          /*!< (@ 0x000000AA) Sub Operating Power Control Register                       */

        struct
        {
            __IOM uint8_t SOPCM   : 1; /*!< [0..0] Sub Operating Power Control Mode Select                            */
            uint8_t               : 3;
            __IM uint8_t SOPCMTSF : 1; /*!< [4..4] Sub Operating Power Control Mode Transition Status Flag            */
            uint8_t               : 3;
        } SOPCCR_b;
    };
    __IM uint8_t  RESERVED31;
    __IM uint32_t RESERVED32[5];

    union
    {
        __IOM uint16_t RSTSR1;         /*!< (@ 0x000000C0) Reset Status Register 1                                    */

        struct
        {
            __IOM uint16_t IWDTRF : 1; /*!< [0..0] Independent Watchdog Timer Reset Detect FlagNOTE: Writable
                                        *   only to clear the flag. Confirm the value is 1 and then
                                        *   write 0.                                                                  */
            __IOM uint16_t WDTRF : 1;  /*!< [1..1] Watchdog Timer Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t SWRF : 1;   /*!< [2..2] Software Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            uint16_t             : 5;
            __IOM uint16_t RPERF : 1;  /*!< [8..8] RAM Parity Error Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t REERF : 1;  /*!< [9..9] RAM ECC Error Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t BUSSRF : 1; /*!< [10..10] Bus Slave MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t BUSMRF : 1; /*!< [11..11] Bus Master MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t SPERF : 1;  /*!< [12..12] SP Error Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint16_t TZERF : 1;  /*!< [13..13] Trust Zone Error Reset Detect Flag                               */
            uint16_t             : 1;
            __IOM uint16_t CPERF : 1;  /*!< [15..15] Cache Parity Error Reset Detect Flag                             */
        } RSTSR1_b;
    };
    __IM uint16_t RESERVED33;
    __IM uint32_t RESERVED34[3];

    union
    {
        __IOM uint8_t USBCKCR_ALT;       /*!< (@ 0x000000D0) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCLKSEL : 1; /*!< [0..0] The USBCLKSEL bit selects the source of the USB clock
                                          *   (UCLK).                                                                   */
            uint8_t : 7;
        } USBCKCR_ALT_b;
    };

    union
    {
        __IOM uint8_t SDADCCKCR;          /*!< (@ 0x000000D1) 24-bit Sigma-Delta A/D Converter Clock Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t SDADCCKSEL : 1; /*!< [0..0] 24-bit Sigma-Delta A/D Converter Clock Select                      */
            uint8_t                  : 6;
            __IOM uint8_t SDADCCKEN  : 1; /*!< [7..7] 24-bit Sigma-Delta A/D Converter Clock Enable                      */
        } SDADCCKCR_b;
    };
    __IM uint16_t RESERVED35;
    __IM uint32_t RESERVED36[3];

    union
    {
        __IOM uint8_t LVD1CR1;         /*!< (@ 0x000000E0) Voltage Monitor 1 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD1CR1_b;
    };

    union
    {
        __IOM uint8_t LVD1SR;          /*!< (@ 0x000000E1) Voltage Monitor 1 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD1SR_b;
    };

    union
    {
        __IOM uint8_t LVD2CR1;         /*!< (@ 0x000000E2) Voltage Monitor 2 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD2CR1_b;
    };

    union
    {
        __IOM uint8_t LVD2SR;          /*!< (@ 0x000000E3) Voltage Monitor 2 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD2SR_b;
    };
    __IM uint32_t RESERVED37[183];

    union
    {
        __IOM uint32_t CGFSAR;           /*!< (@ 0x000003C0) Clock Generation Function Security Attribute
                                          *                  Register                                                   */

        struct
        {
            __IOM uint32_t NONSEC00 : 1; /*!< [0..0] Non Secure Attribute bit 00                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC02 : 1; /*!< [2..2] Non Secure Attribute bit 02                                        */
            __IOM uint32_t NONSEC03 : 1; /*!< [3..3] Non Secure Attribute bit 03                                        */
            __IOM uint32_t NONSEC04 : 1; /*!< [4..4] Non Secure Attribute bit 04                                        */
            __IOM uint32_t NONSEC05 : 1; /*!< [5..5] Non Secure Attribute bit 05                                        */
            __IOM uint32_t NONSEC06 : 1; /*!< [6..6] Non Secure Attribute bit 06                                        */
            __IOM uint32_t NONSEC07 : 1; /*!< [7..7] Non Secure Attribute bit 07                                        */
            __IOM uint32_t NONSEC08 : 1; /*!< [8..8] Non Secure Attribute bit 08                                        */
            __IOM uint32_t NONSEC09 : 1; /*!< [9..9] Non Secure Attribute bit 09                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC11 : 1; /*!< [11..11] Non Secure Attribute bit 11                                      */
            __IOM uint32_t NONSEC12 : 1; /*!< [12..12] Non Secure Attribute bit 12                                      */
            uint32_t                : 3;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            uint32_t                : 14;
        } CGFSAR_b;
    };
    __IM uint32_t RESERVED38;

    union
    {
        __IOM uint32_t LPMSAR;          /*!< (@ 0x000003C8) Low Power Mode Security Attribution Register               */

        struct
        {
            __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC4 : 1; /*!< [4..4] Non Secure Attribute bit 4                                         */
            uint32_t               : 3;
            __IOM uint32_t NONSEC8 : 1; /*!< [8..8] Non Secure Attribute bit 8                                         */
            __IOM uint32_t NONSEC9 : 1; /*!< [9..9] Non Secure Attribute bit 9                                         */
            uint32_t               : 22;
        } LPMSAR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t LVDSAR;          /*!< (@ 0x000003CC) Low Voltage Detection Security Attribution Register        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                uint32_t               : 30;
            } LVDSAR_b;
        };

        union
        {
            __IOM uint32_t RSTSAR;          /*!< (@ 0x000003CC) Reset Security Attribution Register                        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
                uint32_t               : 29;
            } RSTSAR_b;
        };
    };

    union
    {
        __IOM uint32_t BBFSAR;           /*!< (@ 0x000003D0) Battery Backup Function Security Attribute Register        */

        struct
        {
            __IOM uint32_t NONSEC0  : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            __IOM uint32_t NONSEC1  : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
            __IOM uint32_t NONSEC2  : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t                : 13;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            __IOM uint32_t NONSEC18 : 1; /*!< [18..18] Non Secure Attribute bit 18                                      */
            __IOM uint32_t NONSEC19 : 1; /*!< [19..19] Non Secure Attribute bit 19                                      */
            __IOM uint32_t NONSEC20 : 1; /*!< [20..20] Non Secure Attribute bit 20                                      */
            __IOM uint32_t NONSEC21 : 1; /*!< [21..21] Non Secure Attribute bit 21                                      */
            __IOM uint32_t NONSEC22 : 1; /*!< [22..22] Non Secure Attribute bit 22                                      */
            __IOM uint32_t NONSEC23 : 1; /*!< [23..23] Non Secure Attribute bit 23                                      */
            uint32_t                : 8;
        } BBFSAR_b;
    };
    __IM uint32_t RESERVED39[3];

    union
    {
        __IOM uint32_t DPFSAR;          /*!< (@ 0x000003E0) Deep Standby Interrupt Factor Security Attribution
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t DPFSA0 : 1;  /*!< [0..0] Deep Standby Interrupt Factor Security Attribute bit
                                         *   0                                                                         */
            __IOM uint32_t DPFSA1 : 1;  /*!< [1..1] Deep Standby Interrupt Factor Security Attribute bit
                                         *   1                                                                         */
            __IOM uint32_t DPFSA2 : 1;  /*!< [2..2] Deep Standby Interrupt Factor Security Attribute bit
                                         *   2                                                                         */
            __IOM uint32_t DPFSA3 : 1;  /*!< [3..3] Deep Standby Interrupt Factor Security Attribute bit
                                         *   3                                                                         */
            __IOM uint32_t DPFSA4 : 1;  /*!< [4..4] Deep Standby Interrupt Factor Security Attribute bit
                                         *   4                                                                         */
            __IOM uint32_t DPFSA5 : 1;  /*!< [5..5] Deep Standby Interrupt Factor Security Attribute bit
                                         *   5                                                                         */
            __IOM uint32_t DPFSA6 : 1;  /*!< [6..6] Deep Standby Interrupt Factor Security Attribute bit
                                         *   6                                                                         */
            __IOM uint32_t DPFSA7 : 1;  /*!< [7..7] Deep Standby Interrupt Factor Security Attribute bit
                                         *   7                                                                         */
            __IOM uint32_t DPFSA8 : 1;  /*!< [8..8] Deep Standby Interrupt Factor Security Attribute bit
                                         *   8                                                                         */
            __IOM uint32_t DPFSA9 : 1;  /*!< [9..9] Deep Standby Interrupt Factor Security Attribute bit
                                         *   9                                                                         */
            __IOM uint32_t DPFSA10 : 1; /*!< [10..10] Deep Standby Interrupt Factor Security Attribute bit
                                         *   10                                                                        */
            __IOM uint32_t DPFSA11 : 1; /*!< [11..11] Deep Standby Interrupt Factor Security Attribute bit
                                         *   11                                                                        */
            __IOM uint32_t DPFSA12 : 1; /*!< [12..12] Deep Standby Interrupt Factor Security Attribute bit
                                         *   12                                                                        */
            __IOM uint32_t DPFSA13 : 1; /*!< [13..13] Deep Standby Interrupt Factor Security Attribute bit
                                         *   13                                                                        */
            __IOM uint32_t DPFSA14 : 1; /*!< [14..14] Deep Standby Interrupt Factor Security Attribute bit
                                         *   14                                                                        */
            __IOM uint32_t DPFSA15 : 1; /*!< [15..15] Deep Standby Interrupt Factor Security Attribute bit
                                         *   15                                                                        */
            __IOM uint32_t DPFSA16 : 1; /*!< [16..16] Deep Standby Interrupt Factor Security Attribute bit
                                         *   16                                                                        */
            __IOM uint32_t DPFSA17 : 1; /*!< [17..17] Deep Standby Interrupt Factor Security Attribute bit
                                         *   17                                                                        */
            __IOM uint32_t DPFSA18 : 1; /*!< [18..18] Deep Standby Interrupt Factor Security Attribute bit
                                         *   18                                                                        */
            __IOM uint32_t DPFSA19 : 1; /*!< [19..19] Deep Standby Interrupt Factor Security Attribute bit
                                         *   19                                                                        */
            __IOM uint32_t DPFSA20 : 1; /*!< [20..20] Deep Standby Interrupt Factor Security Attribute bit
                                         *   20                                                                        */
            uint32_t               : 3;
            __IOM uint32_t DPFSA24 : 1; /*!< [24..24] Deep Standby Interrupt Factor Security Attribute bit
                                         *   24                                                                        */
            uint32_t               : 1;
            __IOM uint32_t DPFSA26 : 1; /*!< [26..26] Deep Standby Interrupt Factor Security Attribute bit
                                         *   26                                                                        */
            __IOM uint32_t DPFSA27 : 1; /*!< [27..27] Deep Standby Interrupt Factor Security Attribute bit
                                         *   27                                                                        */
            uint32_t : 4;
        } DPFSAR_b;
    };
    __IM uint32_t RESERVED40[6];
    __IM uint16_t RESERVED41;

    union
    {
        __IOM uint16_t PRCR;           /*!< (@ 0x000003FE) Protect Register                                           */

        struct
        {
            __IOM uint16_t PRC0 : 1;   /*!< [0..0] Enables writing to the registers related to the clock
                                        *   generation circuit.                                                       */
            __IOM uint16_t PRC1 : 1;   /*!< [1..1] Enables writing to the registers related to the operating
                                        *   modes, the low power consumption modes and the battery
                                        *   backup function.                                                          */
            uint16_t            : 1;
            __IOM uint16_t PRC3 : 1;   /*!< [3..3] Enables writing to the registers related to the LVD.               */
            __IOM uint16_t PRC4 : 1;   /*!< [4..4] PRC4                                                               */
            uint16_t            : 3;
            __OM uint16_t PRKEY : 8;   /*!< [15..8] PRKEY Key Code                                                    */
        } PRCR_b;
    };

    union
    {
        __IOM uint8_t DPSBYCR;         /*!< (@ 0x00000400) Deep Standby Control Register                              */

        struct
        {
            __IOM uint8_t DEEPCUT : 2; /*!< [1..0] Power-Supply Control                                               */
            uint8_t               : 4;
            __IOM uint8_t IOKEEP  : 1; /*!< [6..6] I/O Port Retention                                                 */
            __IOM uint8_t DPSBY   : 1; /*!< [7..7] Deep Software Standby                                              */
        } DPSBYCR_b;
    };

    union
    {
        __IOM uint8_t DPSWCR;          /*!< (@ 0x00000401) Deep Standby Wait Control Register                         */

        struct
        {
            __IOM uint8_t WTSTS : 6;   /*!< [5..0] Deep Software Wait Standby Time Setting Bit                        */
            uint8_t             : 2;
        } DPSWCR_b;
    };

    union
    {
        __IOM uint8_t DPSIER0;         /*!< (@ 0x00000402) Deep Standby Interrupt Enable Register 0                   */

        struct
        {
            __IOM uint8_t DIRQ0E : 1;  /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ1E : 1;  /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ2E : 1;  /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ3E : 1;  /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ4E : 1;  /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ5E : 1;  /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ6E : 1;  /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ7E : 1;  /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER0_b;
    };

    union
    {
        __IOM uint8_t DPSIER1;         /*!< (@ 0x00000403) Deep Standby Interrupt Enable Register 1                   */

        struct
        {
            __IOM uint8_t DIRQ8E  : 1; /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ9E  : 1; /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ10E : 1; /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ11E : 1; /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ12E : 1; /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ13E : 1; /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ14E : 1; /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ15E : 1; /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER1_b;
    };

    union
    {
        __IOM uint8_t DPSIER2;          /*!< (@ 0x00000404) Deep Standby Interrupt Enable Register 2                   */

        struct
        {
            __IOM uint8_t DLVD1IE  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DLVD2IE  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DTRTCIIE : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Signal Enable           */
            __IOM uint8_t DRTCAIE  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Signal Enable              */
            __IOM uint8_t DNMIE    : 1; /*!< [4..4] NMI Pin Enable                                                     */
            uint8_t                : 3;
        } DPSIER2_b;
    };

    union
    {
        __IOM uint8_t DPSIER3;          /*!< (@ 0x00000405) Deep Standby Interrupt Enable Register 3                   */

        struct
        {
            __IOM uint8_t DUSBFSIE : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DUSBHSIE : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DAGT1IE  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Signal Enable                   */
            __IOM uint8_t DAGT3IE  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Signal Enable                   */
            uint8_t                : 4;
        } DPSIER3_b;
    };

    union
    {
        __IOM uint8_t DPSIFR0;         /*!< (@ 0x00000406) Deep Standby Interrupt Flag Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0F : 1;  /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ1F : 1;  /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ2F : 1;  /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ3F : 1;  /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ4F : 1;  /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ5F : 1;  /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ6F : 1;  /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ7F : 1;  /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR0_b;
    };

    union
    {
        __IOM uint8_t DPSIFR1;         /*!< (@ 0x00000407) Deep Standby Interrupt Flag Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ8F  : 1; /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ9F  : 1; /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ10F : 1; /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ11F : 1; /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ12F : 1; /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ13F : 1; /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ14F : 1; /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ15F : 1; /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR1_b;
    };

    union
    {
        __IOM uint8_t DPSIFR2;          /*!< (@ 0x00000408) Deep Standby Interrupt Flag Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IF  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DLVD2IF  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DTRTCIIF : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Flag                    */
            __IOM uint8_t DRTCAIF  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Flag                       */
            __IOM uint8_t DNMIF    : 1; /*!< [4..4] NMI Pin Deep Standby Cancel Flag                                   */
            uint8_t                : 3;
        } DPSIFR2_b;
    };

    union
    {
        __IOM uint8_t DPSIFR3;          /*!< (@ 0x00000409) Deep Standby Interrupt Flag Register 3                     */

        struct
        {
            __IOM uint8_t DUSBFSIF : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DUSBHSIF : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DAGT1IF  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Flag                            */
            __IOM uint8_t DAGT3IF  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Flag                            */
            uint8_t                : 4;
        } DPSIFR3_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR0;        /*!< (@ 0x0000040A) Deep Standby Interrupt Edge Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR0_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR1;        /*!< (@ 0x0000040B) Deep Standby Interrupt Edge Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR1_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR2;         /*!< (@ 0x0000040C) Deep Standby Interrupt Edge Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IEG : 1; /*!< [0..0] LVD1 Edge Select                                                   */
            __IOM uint8_t DLVD2IEG : 1; /*!< [1..1] LVD2 Edge Select                                                   */
            uint8_t                : 2;
            __IOM uint8_t DNMIEG   : 1; /*!< [4..4] NMI Pin Edge Select                                                */
            uint8_t                : 3;
        } DPSIEGR2_b;
    };
    __IM uint8_t RESERVED42;

    union
    {
        __IOM uint8_t SYOCDCR;         /*!< (@ 0x0000040E) System Control OCD Control Register                        */

        struct
        {
            __IOM uint8_t DOCDF : 1;   /*!< [0..0] Deep Standby OCD flag                                              */
            uint8_t             : 6;
            __IOM uint8_t DBGEN : 1;   /*!< [7..7] Debugger Enable bit                                                */
        } SYOCDCR_b;
    };

    union
    {
        __IOM uint8_t STCONR;          /*!< (@ 0x0000040F) Standby Condition Register                                 */

        struct
        {
            __IOM uint8_t STCON : 2;   /*!< [1..0] SSTBY condition bit                                                */
            uint8_t             : 6;
        } STCONR_b;
    };

    union
    {
        __IOM uint8_t RSTSR0;          /*!< (@ 0x00000410) Reset Status Register 0                                    */

        struct
        {
            __IOM uint8_t PORF : 1;    /*!< [0..0] Power-On Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint8_t LVD0RF : 1;  /*!< [1..1] Voltage Monitor 0 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD1RF : 1;  /*!< [2..2] Voltage Monitor 1 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD2RF : 1;  /*!< [3..3] Voltage Monitor 2 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            uint8_t               : 3;
            __IOM uint8_t DPSRSTF : 1; /*!< [7..7] Deep Software Standby Reset FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
        } RSTSR0_b;
    };

    union
    {
        __IOM uint8_t RSTSR2;          /*!< (@ 0x00000411) Reset Status Register 2                                    */

        struct
        {
            __IOM uint8_t CWSF : 1;    /*!< [0..0] Cold/Warm Start Determination Flag                                 */
            uint8_t            : 7;
        } RSTSR2_b;
    };
    __IM uint8_t RESERVED43;

    union
    {
        __IOM uint8_t MOMCR;           /*!< (@ 0x00000413) Main Clock Oscillator Mode Oscillation Control
                                        *                  Register                                                   */

        struct
        {
            uint8_t                 : 3;
            __IOM uint8_t MODRV1    : 1; /*!< [3..3] Main Clock Oscillator Drive Capability 1 Switching                 */
            __IOM uint8_t MODRV0    : 2; /*!< [5..4] Main Clock Oscillator Drive Capability 0 Switching                 */
            __IOM uint8_t MOSEL     : 1; /*!< [6..6] Main Clock Oscillator Switching                                    */
            __IOM uint8_t AUTODRVEN : 1; /*!< [7..7] Main Clock Oscillator Drive Capability Auto Switching
                                          *   Enable                                                                    */
        } MOMCR_b;
    };
    __IM uint16_t RESERVED44;

    union
    {
        __IOM uint8_t FWEPROR;         /*!< (@ 0x00000416) Flash P/E Protect Register                                 */

        struct
        {
            __IOM uint8_t FLWE : 2;    /*!< [1..0] Flash Programming and Erasure                                      */
            uint8_t            : 6;
        } FWEPROR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t LVCMPCR;     /*!< (@ 0x00000417) Voltage Monitor Circuit Control Register                   */

            struct
            {
                uint8_t             : 5;
                __IOM uint8_t LVD1E : 1; /*!< [5..5] Voltage Detection 1 Enable                                         */
                __IOM uint8_t LVD2E : 1; /*!< [6..6] Voltage Detection 2 Enable                                         */
                uint8_t             : 1;
            } LVCMPCR_b;
        };

        union
        {
            __IOM uint8_t LVD1CMPCR;       /*!< (@ 0x00000417) Voltage Monitoring 1 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 2;
                __IOM uint8_t LVD1E : 1;   /*!< [7..7] Voltage Detection 1 Enable                                         */
            } LVD1CMPCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t LVDLVLR;         /*!< (@ 0x00000418) Voltage Detection Level Select Register                    */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
                __IOM uint8_t LVD2LVL : 3; /*!< [7..5] Voltage Detection 2 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
            } LVDLVLR_b;
        };

        union
        {
            __IOM uint8_t LVD2CMPCR;       /*!< (@ 0x00000418) Voltage Monitoring 2 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD2LVL : 3; /*!< [2..0] Voltage Detection 2 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 4;
                __IOM uint8_t LVD2E : 1;   /*!< [7..7] Voltage Detection 2 Enable                                         */
            } LVD2CMPCR_b;
        };
    };
    __IM uint8_t RESERVED45;

    union
    {
        __IOM uint8_t LVD1CR0;         /*!< (@ 0x0000041A) Voltage Monitor 1 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD1CR0_b;
    };

    union
    {
        __IOM uint8_t LVD2CR0;         /*!< (@ 0x0000041B) Voltage Monitor 2 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD2CR0_b;
    };
    __IM uint8_t RESERVED46;

    union
    {
        __IOM uint8_t VBATTMNSELR;        /*!< (@ 0x0000041D) Battery Backup Voltage Monitor Function Select
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBATTMNSEL : 1; /*!< [0..0] VBATT Low Voltage Detect Function Select Bit                       */
            uint8_t                  : 7;
        } VBATTMNSELR_b;
    };

    union
    {
        __IM uint8_t VBATTMONR;        /*!< (@ 0x0000041E) Battery Backup Voltage Monitor Register                    */

        struct
        {
            __IM uint8_t VBATTMON : 1; /*!< [0..0] VBATT Voltage Monitor Bit                                          */
            uint8_t               : 7;
        } VBATTMONR_b;
    };

    union
    {
        __IOM uint8_t VBTCR1;           /*!< (@ 0x0000041F) VBATT Control Register1                                    */

        struct
        {
            __IOM uint8_t BPWSWSTP : 1; /*!< [0..0] Battery Power supply Switch Stop                                   */
            uint8_t                : 7;
        } VBTCR1_b;
    };
    __IM uint32_t RESERVED47[8];

    union
    {
        union
        {
            __IOM uint8_t DCDCCTL;         /*!< (@ 0x00000440) DCDC/LDO Control Register                                  */

            struct
            {
                __IOM uint8_t DCDCON  : 1; /*!< [0..0] LDO/DCDC on/off Control bit                                        */
                __IOM uint8_t OCPEN   : 1; /*!< [1..1] DCDC OCP Function Enable bit                                       */
                uint8_t               : 2;
                __IOM uint8_t STOPZA  : 1; /*!< [4..4] DCDC IO Buffer Power Control bit                                   */
                __IOM uint8_t LCBOOST : 1; /*!< [5..5] LDO LCBOOST Mode Control bit                                       */
                __IOM uint8_t FST     : 1; /*!< [6..6] DCDC Fast Startup                                                  */
                __IOM uint8_t PD      : 1; /*!< [7..7] DCDC VREF Generate Disable bit                                     */
            } DCDCCTL_b;
        };

        union
        {
            __IOM uint8_t LDOSCR;          /*!< (@ 0x00000440) LDO Stop Control Register                                  */

            struct
            {
                __IOM uint8_t LDOSTP0 : 1; /*!< [0..0] LDO0 Stop                                                          */
                __IOM uint8_t LDOSTP1 : 1; /*!< [1..1] LDO1 Stop                                                          */
                uint8_t               : 6;
            } LDOSCR_b;
        };
    };

    union
    {
        __IOM uint8_t VCCSEL;          /*!< (@ 0x00000441) Voltage Level Selection Control Register                   */

        struct
        {
            __IOM uint8_t VCCSEL : 2;  /*!< [1..0] DCDC Working Voltage Level Selection                               */
            uint8_t              : 6;
        } VCCSEL_b;
    };
    __IM uint16_t RESERVED48;

    union
    {
        __IOM uint8_t PL2LDOSCR;         /*!< (@ 0x00000444) PLL2-LDO Stop Control Register                             */

        struct
        {
            __IOM uint8_t PL2LDOSTP : 1; /*!< [0..0] LDO0 Stop                                                          */
            uint8_t                 : 7;
        } PL2LDOSCR_b;
    };
    __IM uint8_t  RESERVED49;
    __IM uint16_t RESERVED50;
    __IM uint32_t RESERVED51[14];

    union
    {
        __IOM uint8_t SOSCCR;          /*!< (@ 0x00000480) Sub-Clock Oscillator Control Register                      */

        struct
        {
            __IOM uint8_t SOSTP : 1;   /*!< [0..0] Sub-Clock Oscillator Stop                                          */
            uint8_t             : 7;
        } SOSCCR_b;
    };

    union
    {
        __IOM uint8_t SOMCR;           /*!< (@ 0x00000481) Sub Clock Oscillator Mode Control Register                 */

        struct
        {
            __IOM uint8_t SODRV : 2;   /*!< [1..0] Sub-Clock Oscillator Drive Capability Switching                    */
            uint8_t             : 6;
        } SOMCR_b;
    };
    __IM uint16_t RESERVED52;
    __IM uint32_t RESERVED53[3];

    union
    {
        __IOM uint8_t LOCOCR;          /*!< (@ 0x00000490) Low-Speed On-Chip Oscillator Control Register              */

        struct
        {
            __IOM uint8_t LCSTP : 1;   /*!< [0..0] LOCO Stop                                                          */
            uint8_t             : 7;
        } LOCOCR_b;
    };
    __IM uint8_t RESERVED54;

    union
    {
        __IOM uint8_t LOCOUTCR;         /*!< (@ 0x00000492) LOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t LOCOUTRM : 8; /*!< [7..0] LOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original LOCO
                                         *   trimming bits                                                             */
        } LOCOUTCR_b;
    };
    __IM uint8_t  RESERVED55;
    __IM uint32_t RESERVED56[7];

    union
    {
        __IOM uint8_t VBTCR2;          /*!< (@ 0x000004B0) VBATT Control Register2                                    */

        struct
        {
            uint8_t                 : 4;
            __IOM uint8_t VBTLVDEN  : 1; /*!< [4..4] VBATT Pin Low Voltage Detect Enable Bit                            */
            uint8_t                 : 1;
            __IOM uint8_t VBTLVDLVL : 2; /*!< [7..6] VBATT Pin Voltage Low Voltage Detect Level Select Bit              */
        } VBTCR2_b;
    };

    union
    {
        __IOM uint8_t VBTSR;           /*!< (@ 0x000004B1) VBATT Status Register                                      */

        struct
        {
            __IOM uint8_t VBTRDF  : 1; /*!< [0..0] VBAT_R Reset Detect Flag                                           */
            __IOM uint8_t VBTBLDF : 1; /*!< [1..1] VBATT Battery Low voltage Detect Flag                              */
            uint8_t               : 2;
            __IM uint8_t VBTRVLD  : 1; /*!< [4..4] VBATT_R Valid                                                      */
            uint8_t               : 3;
        } VBTSR_b;
    };

    union
    {
        __IOM uint8_t VBTCMPCR;        /*!< (@ 0x000004B2) VBATT Comparator Control Register                          */

        struct
        {
            __IOM uint8_t VBTCMPE : 1; /*!< [0..0] VBATT pin low voltage detect circuit output enable                 */
            uint8_t               : 7;
        } VBTCMPCR_b;
    };
    __IM uint8_t RESERVED57;

    union
    {
        __IOM uint8_t VBTLVDICR;          /*!< (@ 0x000004B4) VBATT Pin Low Voltage Detect Interrupt Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBTLVDIE   : 1; /*!< [0..0] VBATT Pin Low Voltage Detect Interrupt Enable bit                  */
            __IOM uint8_t VBTLVDISEL : 1; /*!< [1..1] Pin Low Voltage Detect Interrupt Select bit                        */
            uint8_t                  : 6;
        } VBTLVDICR_b;
    };
    __IM uint8_t RESERVED58;

    union
    {
        __IOM uint8_t VBTWCTLR;        /*!< (@ 0x000004B6) VBATT Wakeup function Control Register                     */

        struct
        {
            __IOM uint8_t VWEN : 1;    /*!< [0..0] VBATT wakeup enable                                                */
            uint8_t            : 7;
        } VBTWCTLR_b;
    };
    __IM uint8_t RESERVED59;

    union
    {
        __IOM uint8_t VBTWCH0OTSR;     /*!< (@ 0x000004B8) VBATT Wakeup I/O 0 Output Trigger Select Register          */

        struct
        {
            uint8_t                  : 1;
            __IOM uint8_t CH0VCH1TE  : 1; /*!< [1..1] VBATWIO0 Output VBATWIO1 Trigger Enable                            */
            __IOM uint8_t CH0VCH2TE  : 1; /*!< [2..2] VBATWIO0 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH0VRTCTE  : 1; /*!< [3..3] VBATWIO0 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH0VRTCATE : 1; /*!< [4..4] VBATWIO0 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH0VAGTUTE : 1; /*!< [5..5] CH0 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH0OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH1OTSR;        /*!< (@ 0x000004B9) VBATT Wakeup I/O 1 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH1VCH0TE  : 1; /*!< [0..0] VBATWIO1 Output VBATWIO0 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH1VCH2TE  : 1; /*!< [2..2] VBATWIO1 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH1VRTCTE  : 1; /*!< [3..3] VBATWIO1 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH1VRTCATE : 1; /*!< [4..4] VBATWIO1 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH1VAGTUTE : 1; /*!< [5..5] CH1 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH1OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH2OTSR;        /*!< (@ 0x000004BA) VBATT Wakeup I/O 2 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH2VCH0TE  : 1; /*!< [0..0] VBATWIO2 Output VBATWIO0 Trigger Enable                            */
            __IOM uint8_t CH2VCH1TE  : 1; /*!< [1..1] VBATWIO2 Output VBATWIO1 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH2VRTCTE  : 1; /*!< [3..3] VBATWIO2 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH2VRTCATE : 1; /*!< [4..4] VBATWIO2 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH2VAGTUTE : 1; /*!< [5..5] CH2 Output AGT(CH2) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH2OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTICTLR;         /*!< (@ 0x000004BB) VBATT Input Control Register                               */

        struct
        {
            __IOM uint8_t VCH0INEN : 1; /*!< [0..0] RTCIC0 Input Enable                                                */
            __IOM uint8_t VCH1INEN : 1; /*!< [1..1] RTCIC1 Input Enable                                                */
            __IOM uint8_t VCH2INEN : 1; /*!< [2..2] RTCIC2 Input Enable                                                */
            uint8_t                : 5;
        } VBTICTLR_b;
    };

    union
    {
        __IOM uint8_t VBTOCTLR;          /*!< (@ 0x000004BC) VBATT Output Control Register                              */

        struct
        {
            __IOM uint8_t VCH0OEN   : 1; /*!< [0..0] VBATT Wakeup I/O 0 Output Enable                                   */
            __IOM uint8_t VCH1OEN   : 1; /*!< [1..1] VBATT Wakeup I/O 1 Output Enable                                   */
            __IOM uint8_t VCH2OEN   : 1; /*!< [2..2] VBATT Wakeup I/O 2 Output Enable                                   */
            __IOM uint8_t VOUT0LSEL : 1; /*!< [3..3] VBATT Wakeup I/O 0 Output Level Selection                          */
            __IOM uint8_t VCOU1LSEL : 1; /*!< [4..4] VBATT Wakeup I/O 1 Output Level Selection                          */
            __IOM uint8_t VOUT2LSEL : 1; /*!< [5..5] VBATT Wakeup I/O 2 Output Level Selection                          */
            uint8_t                 : 2;
        } VBTOCTLR_b;
    };

    union
    {
        __IOM uint8_t VBTWTER;         /*!< (@ 0x000004BD) VBATT Wakeup Trigger source Enable Register                */

        struct
        {
            __IOM uint8_t VCH0E  : 1;  /*!< [0..0] VBATWIO0 Pin Enable                                                */
            __IOM uint8_t VCH1E  : 1;  /*!< [1..1] VBATWIO1 Pin Enable                                                */
            __IOM uint8_t VCH2E  : 1;  /*!< [2..2] VBATWIO2 Pin Enable                                                */
            __IOM uint8_t VRTCIE : 1;  /*!< [3..3] RTC Periodic Signal Enable                                         */
            __IOM uint8_t VRTCAE : 1;  /*!< [4..4] RTC Alarm Signal Enable                                            */
            __IOM uint8_t VAGTUE : 1;  /*!< [5..5] AGT(ch1) underflow Signal Enable                                   */
            uint8_t              : 2;
        } VBTWTER_b;
    };

    union
    {
        __IOM uint8_t VBTWEGR;         /*!< (@ 0x000004BE) VBATT Wakeup Trigger source Edge Register                  */

        struct
        {
            __IOM uint8_t VCH0EG : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH1EG : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH2EG : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Source Edge Select                         */
            uint8_t              : 5;
        } VBTWEGR_b;
    };

    union
    {
        __IOM uint8_t VBTWFR;          /*!< (@ 0x000004BF) VBATT Wakeup trigger source Flag Register                  */

        struct
        {
            __IOM uint8_t VCH0F  : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH1F  : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH2F  : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Flag                                       */
            __IOM uint8_t VRTCIF : 1;  /*!< [3..3] VBATT RTC-Interval Wakeup Trigger Flag                             */
            __IOM uint8_t VRTCAF : 1;  /*!< [4..4] VBATT RTC-Alarm Wakeup Trigger Flag                                */
            __IOM uint8_t VAGTUF : 1;  /*!< [5..5] AGT(ch1) underflow VBATT Wakeup Trigger Flag                       */
            uint8_t              : 2;
        } VBTWFR_b;
    };

    union
    {
        __IOM uint8_t VBTBER;          /*!< (@ 0x000004C0) VBATT Backup Enable Register                               */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t VBAE : 1;    /*!< [3..3] VBATT backup register access enable bit                            */
            uint8_t            : 4;
        } VBTBER_b;
    };
    __IM uint8_t  RESERVED60;
    __IM uint16_t RESERVED61;
    __IM uint32_t RESERVED62[15];

    union
    {
        __IOM uint8_t VBTBKR[512];     /*!< (@ 0x00000500) VBATT Backup Register [0..511]                             */

        struct
        {
            __IOM uint8_t VBTBKR : 8;  /*!< [7..0] VBTBKR is a 512-byte readable/writable register to store
                                        *   data powered by VBATT.The value of this register is retained
                                        *   even when VCC is not powered but VBATT is powered.VBTBKR
                                        *   is initialized by VBATT selected voltage power-on-reset.                  */
        } VBTBKR_b[512];
    };
} R_SYSTEM_Type;                       /*!< Size = 1792 (0x700)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_TRNG                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief True Random Number Generator (R_TRNG)
 */

typedef struct                         /*!< (@ 0x400D1000) R_TRNG Structure                                           */
{
    union
    {
        __IM uint8_t TRNGSDR;          /*!< (@ 0x00000000) TRNG SEED Data Register                                    */

        struct
        {
            __IM uint8_t SDATA : 8;    /*!< [7..0] When RDRDY bit is 1, these bits hold the generated SEED.
                                        *   When RDRDY bit is 0, these bits are read as 00h.The SEED
                                        *   is generated as 32-bit data. When TRNGSDR is read 4 times
                                        *   while RDRDY = 1, SEED reading is completed and RDRDY bit
                                        *   changes to 0                                                              */
        } TRNGSDR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t TRNGSCR0;        /*!< (@ 0x00000002) TRNG SEED Command Register 0                               */

        struct
        {
            uint8_t               : 2;
            __OM uint8_t  SGSTART : 1; /*!< [2..2] SEED Generation Start                                              */
            __IOM uint8_t SGCEN   : 1; /*!< [3..3] SEED Generation Circuit Enable                                     */
            uint8_t               : 3;
            __IM uint8_t RDRDY    : 1; /*!< [7..7] When SEED geenration is completed, this bit changes to
                                        *   0                                                                         */
        } TRNGSCR0_b;
    };

    union
    {
        __IOM uint8_t TRNGSCR1;        /*!< (@ 0x00000003) TRNG SEED Command Register 1                               */

        struct
        {
            __IOM uint8_t INTEN : 1;   /*!< [0..0] TRNG Interrupt Enable                                              */
            uint8_t             : 7;
        } TRNGSCR1_b;
    };
} R_TRNG_Type;                         /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_TSN                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN)
 */

typedef struct                         /*!< (@ 0x407EC000) R_TSN Structure                                            */
{
    __IM uint8_t RESERVED[552];

    union
    {
        __IM uint8_t TSCDRL;           /*!< (@ 0x00000228) Temperature Sensor Calibration Data Register
                                        *                  L                                                          */

        struct
        {
            __IM uint8_t TSCDRL : 8;   /*!< [7..0] The calibration data stores the lower 8 bits of the convertedvalue. */
        } TSCDRL_b;
    };

    union
    {
        __IM uint8_t TSCDRH;           /*!< (@ 0x00000229) Temperature Sensor Calibration Data Register
                                        *                  H                                                          */

        struct
        {
            __IM uint8_t TSCDRH : 8;   /*!< [7..0] The calibration data stores the higher 8 bits of the
                                        *   convertedvalue.                                                           */
        } TSCDRH_b;
    };
} R_TSN_Type;                          /*!< Size = 554 (0x22a)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_WDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Watchdog Timer (R_WDT)
 */

typedef struct                         /*!< (@ 0x40044200) R_WDT Structure                                            */
{
    union
    {
        __IOM uint8_t WDTRR;           /*!< (@ 0x00000000) WDT Refresh Register                                       */

        struct
        {
            __IOM uint8_t WDTRR : 8;   /*!< [7..0] WDTRR is an 8-bit register that refreshes the down-counter
                                        *   of the WDT.                                                               */
        } WDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t WDTCR;          /*!< (@ 0x00000002) WDT Control Register                                       */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } WDTCR_b;
    };

    union
    {
        __IOM uint16_t WDTSR;           /*!< (@ 0x00000004) WDT Status Register                                        */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } WDTSR_b;
    };

    union
    {
        __IOM uint8_t WDTRCR;          /*!< (@ 0x00000006) WDT Reset Control Register                                 */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } WDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t WDTCSTPR;        /*!< (@ 0x00000008) WDT Count Stop Control Register                            */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } WDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_WDT_Type;                          /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                           R_AES                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief AES Engine (R_AES)
 */

typedef struct                         /*!< (@ 0x400D0000) R_AES Structure                                            */
{
    union
    {
        __IOM uint16_t AESMOD;         /*!< (@ 0x00000000) AES Mode Register                                          */

        struct
        {
            __IOM uint16_t MODEN  : 1; /*!< [0..0] Read Request Enable                                                */
            uint16_t              : 7;
            __IOM uint16_t RDRQEN : 1; /*!< [8..8] Read Request Enable                                                */
            __IOM uint16_t WRRQEN : 1; /*!< [9..9] Write Request Enable                                               */
            uint16_t              : 6;
        } AESMOD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t AESCMD;           /*!< (@ 0x00000004) AES Command Register                                       */

        struct
        {
            __IOM uint32_t INVCIP   : 1; /*!< [0..0] Select data encryption/decryption                                  */
            __IOM uint32_t KEYLN    : 1; /*!< [1..1] Select the Key Length                                              */
            uint32_t                : 2;
            __IOM uint32_t CHAIN    : 2; /*!< [5..4] Select the chaining mode                                           */
            uint32_t                : 2;
            __IOM uint32_t STORESEL : 2; /*!< [9..8] Read Request Enable                                                */
            uint32_t                : 2;
            __IOM uint32_t KEYSEL   : 1; /*!< [12..12] Select the Key Register                                          */
            uint32_t                : 11;
            __IM uint32_t DWRDY     : 1; /*!< [24..24] This bit indicates that AESDW is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t DRRDY : 1;     /*!< [25..25] This bit indicates that AESDW is ready to read or is
                                          *   reading                                                                   */
            __IM uint32_t CWRDY : 1;     /*!< [26..26] This bit indicates that AESCMD is ready to write                 */
            __IM uint32_t IWRDY : 1;     /*!< [27..27] This bit indicates that AESIVW is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t IRRDY : 1;     /*!< [28..28] This bit indicates that AESIVW is ready to read or
                                          *   is reading                                                                */
            __IM uint32_t KWRDY0 : 1;    /*!< [29..29] This bit indicates that AESKW0 is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t KWRDY1 : 1;    /*!< [30..30] This bit indicates that AESKW1 is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t ILOP : 1;      /*!< [31..31] This bit shows that the relation of Key Register 0
                                          *   and Key Register1 is not correct (for 256-bit key-length)                 */
        } AESCMD_b;
    };
    __IOM uint32_t AESDW;                /*!< (@ 0x00000008) AES Data Window Register                                   */
    __IOM uint32_t AESIVW;               /*!< (@ 0x0000000C) AES IV Window Register                                     */
    __IOM uint32_t AESKW0;               /*!< (@ 0x00000010) AES Key Window 0 Register                                  */
    __IOM uint32_t AESKW1;               /*!< (@ 0x00000014) AES Key Window 1 Register                                  */
} R_AES_Type;                            /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGTX0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGTX0)
 */

typedef struct                          /*!< (@ 0x40084000) R_AGTX0 Structure                                          */
{
    union
    {
        __IOM R_AGTX0_AGT32_Type AGT32; /*!< (@ 0x00000000) AGTW (32-bit) peripheral registers                         */
        __IOM R_AGTX0_AGT16_Type AGT16; /*!< (@ 0x00000000) AGT (16-bit) peripheral registers                          */
    };
} R_AGTX0_Type;                         /*!< Size = 20 (0x14)                                                          */

/** @} */ /* End of group Device_Peripheral_peripherals */

/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripheralAddr
 * @{
 */

 #define R_ADC0_BASE         0x4005C000UL
 #define R_ADC1_BASE         0x4005C200UL
 #define R_BUS_BASE          0x40003000UL
 #define R_CAC_BASE          0x40044600UL
 #define R_CRC_BASE          0x40074000UL
 #define R_DEBUG_BASE        0x4001B000UL
 #define R_DOC_BASE          0x40054100UL
 #define R_DTC_BASE          0x40005400UL
 #define R_ELC_BASE          0x40041000UL
 #define R_FACI_LP_BASE      0x407EC000UL
 #define R_GPT0_BASE         0x40078000UL
 #define R_GPT1_BASE         0x40078100UL
 #define R_GPT2_BASE         0x40078200UL
 #define R_GPT3_BASE         0x40078300UL
 #define R_GPT4_BASE         0x40078400UL
 #define R_GPT5_BASE         0x40078500UL
 #define R_GPT6_BASE         0x40078600UL
 #define R_GPT7_BASE         0x40078700UL
 #define R_GPT8_BASE         0x40078800UL
 #define R_GPT9_BASE         0x40078900UL
 #define R_GPT10_BASE        0x40078A00UL
 #define R_GPT11_BASE        0x40078B00UL
 #define R_GPT12_BASE        0x40078C00UL
 #define R_GPT13_BASE        0x40078D00UL
 #define R_GPT_OPS_BASE      0x40078FF0UL
 #define R_GPT_POEG0_BASE    0x40042000UL
 #define R_GPT_POEG1_BASE    0x40042100UL
 #define R_GPT_POEG2_BASE    0x40042200UL
 #define R_GPT_POEG3_BASE    0x40042300UL
 #define R_ICU_BASE          0x40006000UL
 #define R_IIC0_BASE         0x40053000UL
 #define R_IIC1_BASE         0x40053100UL
 #define R_IIC2_BASE         0x40053200UL
 #define R_IWDT_BASE         0x40044400UL
 #define R_KINT_BASE         0x40080000UL
 #define R_I3C0_BASE         0x40083000UL
 #define R_I3C1_BASE         0x40083400UL
 #define R_MPU_MMPU_BASE     0x40000000UL
 #define R_MPU_SMPU_BASE     0x40000C00UL
 #define R_MPU_SPMON_BASE    0x40000D00UL
 #define R_MSTP_BASE         (0x40047000UL - 4UL) /* MSTPCRA is not located in R_MSTP so the base address must be moved so that MSTPCRB is located at 0x40047000. */
 #define R_PORT0_BASE        0x40040000UL
 #define R_PORT1_BASE        0x40040020UL
 #define R_PORT2_BASE        0x40040040UL
 #define R_PORT3_BASE        0x40040060UL
 #define R_PORT4_BASE        0x40040080UL
 #define R_PORT5_BASE        0x400400A0UL
 #define R_PORT6_BASE        0x400400C0UL
 #define R_PORT7_BASE        0x400400E0UL
 #define R_PORT8_BASE        0x40040100UL
 #define R_PORT9_BASE        0x40040120UL
 #define R_PORT10_BASE       0x40040140UL
 #define R_PORT11_BASE       0x40040160UL
 #define R_PORT12_BASE       0x40040180UL
 #define R_PORT13_BASE       0x400401A0UL
 #define R_PORT14_BASE       0x400401C0UL
 #define R_PFS_BASE          0x40040800UL
 #define R_PMISC_BASE        0x40040D00UL
 #define R_SCI0_BASE         0x40070000UL
 #define R_SCI1_BASE         0x40070020UL
 #define R_SCI2_BASE         0x40070040UL
 #define R_SCI3_BASE         0x40070060UL
 #define R_SCI4_BASE         0x40070080UL
 #define R_SCI5_BASE         0x400700A0UL
 #define R_SCI6_BASE         0x400700C0UL
 #define R_SCI7_BASE         0x400700E0UL
 #define R_SCI8_BASE         0x40070100UL
 #define R_SCI9_BASE         0x40070120UL
 #define R_SPI0_BASE         0x40072000UL
 #define R_SPI1_BASE         0x40072100UL
 #define R_SRAM_BASE         0x40002000UL
 #define R_SYSTEM_BASE       0x4001E000UL
 #define R_TRNG_BASE         0x400D1000UL
 #define R_TSN_BASE          0x407EC000UL
 #define R_WDT_BASE          0x40044200UL
 #define R_AES_BASE          0x400D0000UL
 #define R_AGTX0_BASE        0x40084000UL
 #define R_AGTX1_BASE        0x40084100UL
 #define R_AGTX2_BASE        0x40084200UL
 #define R_AGTX3_BASE        0x40084300UL
 #define R_AGTX4_BASE        0x40084400UL
 #define R_AGTX5_BASE        0x40084500UL
 #define R_AGTX6_BASE        0x40084600UL
 #define R_AGTX7_BASE        0x40084700UL
 #define R_AGTX8_BASE        0x40084800UL
 #define R_AGTX9_BASE        0x40084900UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */

/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_declaration
 * @{
 */

 #define R_ADC0         ((R_ADC0_Type *) R_ADC0_BASE)
 #define R_ADC1         ((R_ADC0_Type *) R_ADC1_BASE)
 #define R_BUS          ((R_BUS_Type *) R_BUS_BASE)
 #define R_CAC          ((R_CAC_Type *) R_CAC_BASE)
 #define R_CRC          ((R_CRC_Type *) R_CRC_BASE)
 #define R_DEBUG        ((R_DEBUG_Type *) R_DEBUG_BASE)
 #define R_DOC          ((R_DOC_Type *) R_DOC_BASE)
 #define R_DTC          ((R_DTC_Type *) R_DTC_BASE)
 #define R_ELC          ((R_ELC_Type *) R_ELC_BASE)
 #define R_FACI_LP      ((R_FACI_LP_Type *) R_FACI_LP_BASE)
 #define R_GPT0         ((R_GPT0_Type *) R_GPT0_BASE)
 #define R_GPT1         ((R_GPT0_Type *) R_GPT1_BASE)
 #define R_GPT2         ((R_GPT0_Type *) R_GPT2_BASE)
 #define R_GPT3         ((R_GPT0_Type *) R_GPT3_BASE)
 #define R_GPT4         ((R_GPT0_Type *) R_GPT4_BASE)
 #define R_GPT5         ((R_GPT0_Type *) R_GPT5_BASE)
 #define R_GPT6         ((R_GPT0_Type *) R_GPT6_BASE)
 #define R_GPT7         ((R_GPT0_Type *) R_GPT7_BASE)
 #define R_GPT8         ((R_GPT0_Type *) R_GPT8_BASE)
 #define R_GPT9         ((R_GPT0_Type *) R_GPT9_BASE)
 #define R_GPT10        ((R_GPT0_Type *) R_GPT10_BASE)
 #define R_GPT11        ((R_GPT0_Type *) R_GPT11_BASE)
 #define R_GPT12        ((R_GPT0_Type *) R_GPT12_BASE)
 #define R_GPT13        ((R_GPT0_Type *) R_GPT13_BASE)
 #define R_GPT_OPS      ((R_GPT_OPS_Type *) R_GPT_OPS_BASE)
 #define R_GPT_POEG0    ((R_GPT_POEG0_Type *) R_GPT_POEG0_BASE)
 #define R_GPT_POEG1    ((R_GPT_POEG0_Type *) R_GPT_POEG1_BASE)
 #define R_GPT_POEG2    ((R_GPT_POEG0_Type *) R_GPT_POEG2_BASE)
 #define R_GPT_POEG3    ((R_GPT_POEG0_Type *) R_GPT_POEG3_BASE)
 #define R_ICU          ((R_ICU_Type *) R_ICU_BASE)
 #define R_IIC0         ((R_IIC0_Type *) R_IIC0_BASE)
 #define R_IIC1         ((R_IIC0_Type *) R_IIC1_BASE)
 #define R_IIC2         ((R_IIC0_Type *) R_IIC2_BASE)
 #define R_IWDT         ((R_IWDT_Type *) R_IWDT_BASE)
 #define R_KINT         ((R_KINT_Type *) R_KINT_BASE)
 #define R_I3C0         ((R_I3C0_Type *) R_I3C0_BASE)
 #define R_I3C1         ((R_I3C0_Type *) R_I3C1_BASE)
 #define R_MPU_MMPU     ((R_MPU_MMPU_Type *) R_MPU_MMPU_BASE)
 #define R_MPU_SMPU     ((R_MPU_SMPU_Type *) R_MPU_SMPU_BASE)
 #define R_MPU_SPMON    ((R_MPU_SPMON_Type *) R_MPU_SPMON_BASE)
 #define R_MSTP         ((R_MSTP_Type *) R_MSTP_BASE)
 #define R_PORT0        ((R_PORT0_Type *) R_PORT0_BASE)
 #define R_PORT1        ((R_PORT0_Type *) R_PORT1_BASE)
 #define R_PORT2        ((R_PORT0_Type *) R_PORT2_BASE)
 #define R_PORT3        ((R_PORT0_Type *) R_PORT3_BASE)
 #define R_PORT4        ((R_PORT0_Type *) R_PORT4_BASE)
 #define R_PORT5        ((R_PORT0_Type *) R_PORT5_BASE)
 #define R_PORT6        ((R_PORT0_Type *) R_PORT6_BASE)
 #define R_PORT7        ((R_PORT0_Type *) R_PORT7_BASE)
 #define R_PORT8        ((R_PORT0_Type *) R_PORT8_BASE)
 #define R_PORT9        ((R_PORT0_Type *) R_PORT9_BASE)
 #define R_PORT10       ((R_PORT0_Type *) R_PORT10_BASE)
 #define R_PORT11       ((R_PORT0_Type *) R_PORT11_BASE)
 #define R_PORT12       ((R_PORT0_Type *) R_PORT12_BASE)
 #define R_PORT13       ((R_PORT0_Type *) R_PORT13_BASE)
 #define R_PORT14       ((R_PORT0_Type *) R_PORT14_BASE)
 #define R_PFS          ((R_PFS_Type *) R_PFS_BASE)
 #define R_PMISC        ((R_PMISC_Type *) R_PMISC_BASE)
 #define R_SCI0         ((R_SCI0_Type *) R_SCI0_BASE)
 #define R_SCI1         ((R_SCI0_Type *) R_SCI1_BASE)
 #define R_SCI2         ((R_SCI0_Type *) R_SCI2_BASE)
 #define R_SCI3         ((R_SCI0_Type *) R_SCI3_BASE)
 #define R_SCI4         ((R_SCI0_Type *) R_SCI4_BASE)
 #define R_SCI5         ((R_SCI0_Type *) R_SCI5_BASE)
 #define R_SCI6         ((R_SCI0_Type *) R_SCI6_BASE)
 #define R_SCI7         ((R_SCI0_Type *) R_SCI7_BASE)
 #define R_SCI8         ((R_SCI0_Type *) R_SCI8_BASE)
 #define R_SCI9         ((R_SCI0_Type *) R_SCI9_BASE)
 #define R_SPI0         ((R_SPI0_Type *) R_SPI0_BASE)
 #define R_SPI1         ((R_SPI0_Type *) R_SPI1_BASE)
 #define R_SRAM         ((R_SRAM_Type *) R_SRAM_BASE)
 #define R_SYSTEM       ((R_SYSTEM_Type *) R_SYSTEM_BASE)
 #define R_TRNG         ((R_TRNG_Type *) R_TRNG_BASE)
 #define R_TSN          ((R_TSN_Type *) R_TSN_BASE)
 #define R_WDT          ((R_WDT_Type *) R_WDT_BASE)
 #define R_AES          ((R_AES_Type *) R_AES_BASE)
 #define R_AGTX0        ((R_AGTX0_Type *) R_AGTX0_BASE)
 #define R_AGTX1        ((R_AGTX0_Type *) R_AGTX1_BASE)
 #define R_AGTX2        ((R_AGTX0_Type *) R_AGTX2_BASE)
 #define R_AGTX3        ((R_AGTX0_Type *) R_AGTX3_BASE)
 #define R_AGTX4        ((R_AGTX0_Type *) R_AGTX4_BASE)
 #define R_AGTX5        ((R_AGTX0_Type *) R_AGTX5_BASE)
 #define R_AGTX6        ((R_AGTX0_Type *) R_AGTX6_BASE)
 #define R_AGTX7        ((R_AGTX0_Type *) R_AGTX7_BASE)
 #define R_AGTX8        ((R_AGTX0_Type *) R_AGTX8_BASE)
 #define R_AGTX9        ((R_AGTX0_Type *) R_AGTX9_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */

/* =========================================  End of section using anonymous unions  ========================================= */
 #if defined(__CC_ARM)
  #pragma pop
 #elif defined(__ICCARM__)

/* leave anonymous unions enabled */
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning restore
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #endif

/* =========================================================================================================================== */
/* ================                                 Pos/Mask Cluster Section                                  ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_clusters
 * @{
 */

/* =========================================================================================================================== */
/* ================                                            CSa                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  MOD  ========================================================== */
 #define R_BUS_CSa_MOD_PRMOD_Pos        (15UL)         /*!< PRMOD (Bit 15)                                        */
 #define R_BUS_CSa_MOD_PRMOD_Msk        (0x8000UL)     /*!< PRMOD (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PWENB_Pos        (9UL)          /*!< PWENB (Bit 9)                                         */
 #define R_BUS_CSa_MOD_PWENB_Msk        (0x200UL)      /*!< PWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PRENB_Pos        (8UL)          /*!< PRENB (Bit 8)                                         */
 #define R_BUS_CSa_MOD_PRENB_Msk        (0x100UL)      /*!< PRENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_EWENB_Pos        (3UL)          /*!< EWENB (Bit 3)                                         */
 #define R_BUS_CSa_MOD_EWENB_Msk        (0x8UL)        /*!< EWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_WRMOD_Pos        (0UL)          /*!< WRMOD (Bit 0)                                         */
 #define R_BUS_CSa_MOD_WRMOD_Msk        (0x1UL)        /*!< WRMOD (Bitfield-Mask: 0x01)                           */
/* =========================================================  WCR1  ========================================================== */
 #define R_BUS_CSa_WCR1_CSRWAIT_Pos     (24UL)         /*!< CSRWAIT (Bit 24)                                      */
 #define R_BUS_CSa_WCR1_CSRWAIT_Msk     (0x1f000000UL) /*!< CSRWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSWWAIT_Pos     (16UL)         /*!< CSWWAIT (Bit 16)                                      */
 #define R_BUS_CSa_WCR1_CSWWAIT_Msk     (0x1f0000UL)   /*!< CSWWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Pos    (8UL)          /*!< CSPRWAIT (Bit 8)                                      */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Msk    (0x700UL)      /*!< CSPRWAIT (Bitfield-Mask: 0x07)                        */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Pos    (0UL)          /*!< CSPWWAIT (Bit 0)                                      */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Msk    (0x7UL)        /*!< CSPWWAIT (Bitfield-Mask: 0x07)                        */
/* =========================================================  WCR2  ========================================================== */
 #define R_BUS_CSa_WCR2_CSON_Pos        (28UL)         /*!< CSON (Bit 28)                                         */
 #define R_BUS_CSa_WCR2_CSON_Msk        (0x70000000UL) /*!< CSON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WDON_Pos        (24UL)         /*!< WDON (Bit 24)                                         */
 #define R_BUS_CSa_WCR2_WDON_Msk        (0x7000000UL)  /*!< WDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WRON_Pos        (20UL)         /*!< WRON (Bit 20)                                         */
 #define R_BUS_CSa_WCR2_WRON_Msk        (0x700000UL)   /*!< WRON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_RDON_Pos        (16UL)         /*!< RDON (Bit 16)                                         */
 #define R_BUS_CSa_WCR2_RDON_Msk        (0x70000UL)    /*!< RDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_AWAIT_Pos       (12UL)         /*!< AWAIT (Bit 12)                                        */
 #define R_BUS_CSa_WCR2_AWAIT_Msk       (0x3000UL)     /*!< AWAIT (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSa_WCR2_WDOFF_Pos       (8UL)          /*!< WDOFF (Bit 8)                                         */
 #define R_BUS_CSa_WCR2_WDOFF_Msk       (0x700UL)      /*!< WDOFF (Bitfield-Mask: 0x07)                           */
 #define R_BUS_CSa_WCR2_CSWOFF_Pos      (4UL)          /*!< CSWOFF (Bit 4)                                        */
 #define R_BUS_CSa_WCR2_CSWOFF_Msk      (0x70UL)       /*!< CSWOFF (Bitfield-Mask: 0x07)                          */
 #define R_BUS_CSa_WCR2_CSROFF_Pos      (0UL)          /*!< CSROFF (Bit 0)                                        */
 #define R_BUS_CSa_WCR2_CSROFF_Msk      (0x7UL)        /*!< CSROFF (Bitfield-Mask: 0x07)                          */

/* =========================================================================================================================== */
/* ================                                            CSb                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
 #define R_BUS_CSb_CR_MPXEN_Pos    (12UL)     /*!< MPXEN (Bit 12)                                        */
 #define R_BUS_CSb_CR_MPXEN_Msk    (0x1000UL) /*!< MPXEN (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_EMODE_Pos    (8UL)      /*!< EMODE (Bit 8)                                         */
 #define R_BUS_CSb_CR_EMODE_Msk    (0x100UL)  /*!< EMODE (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_BSIZE_Pos    (4UL)      /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_CSb_CR_BSIZE_Msk    (0x30UL)   /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSb_CR_EXENB_Pos    (0UL)      /*!< EXENB (Bit 0)                                         */
 #define R_BUS_CSb_CR_EXENB_Msk    (0x1UL)    /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ==========================================================  REC  ========================================================== */
 #define R_BUS_CSb_REC_WRCV_Pos    (8UL)      /*!< WRCV (Bit 8)                                          */
 #define R_BUS_CSb_REC_WRCV_Msk    (0xf00UL)  /*!< WRCV (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_CSb_REC_RRCV_Pos    (0UL)      /*!< RRCV (Bit 0)                                          */
 #define R_BUS_CSb_REC_RRCV_Msk    (0xfUL)    /*!< RRCV (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                           SDRAM                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  SDCCR  ========================================================= */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Pos     (4UL)       /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Msk     (0x30UL)    /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_SDRAM_SDCCR_EXENB_Pos     (0UL)       /*!< EXENB (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCCR_EXENB_Msk     (0x1UL)     /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDCMOD  ========================================================= */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Pos    (0UL)       /*!< EMODE (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Msk    (0x1UL)     /*!< EMODE (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDAMOD  ========================================================= */
 #define R_BUS_SDRAM_SDAMOD_BE_Pos       (0UL)       /*!< BE (Bit 0)                                            */
 #define R_BUS_SDRAM_SDAMOD_BE_Msk       (0x1UL)     /*!< BE (Bitfield-Mask: 0x01)                              */
/* ========================================================  SDSELF  ========================================================= */
 #define R_BUS_SDRAM_SDSELF_SFEN_Pos     (0UL)       /*!< SFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDSELF_SFEN_Msk     (0x1UL)     /*!< SFEN (Bitfield-Mask: 0x01)                            */
/* ========================================================  SDRFCR  ========================================================= */
 #define R_BUS_SDRAM_SDRFCR_REFW_Pos     (12UL)      /*!< REFW (Bit 12)                                         */
 #define R_BUS_SDRAM_SDRFCR_REFW_Msk     (0xf000UL)  /*!< REFW (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDRFCR_RFC_Pos      (0UL)       /*!< RFC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDRFCR_RFC_Msk      (0xfffUL)   /*!< RFC (Bitfield-Mask: 0xfff)                            */
/* ========================================================  SDRFEN  ========================================================= */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Pos     (0UL)       /*!< RFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Msk     (0x1UL)     /*!< RFEN (Bitfield-Mask: 0x01)                            */
/* =========================================================  SDICR  ========================================================= */
 #define R_BUS_SDRAM_SDICR_INIRQ_Pos     (0UL)       /*!< INIRQ (Bit 0)                                         */
 #define R_BUS_SDRAM_SDICR_INIRQ_Msk     (0x1UL)     /*!< INIRQ (Bitfield-Mask: 0x01)                           */
/* =========================================================  SDIR  ========================================================== */
 #define R_BUS_SDRAM_SDIR_PRC_Pos        (8UL)       /*!< PRC (Bit 8)                                           */
 #define R_BUS_SDRAM_SDIR_PRC_Msk        (0x700UL)   /*!< PRC (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDIR_ARFC_Pos       (4UL)       /*!< ARFC (Bit 4)                                          */
 #define R_BUS_SDRAM_SDIR_ARFC_Msk       (0xf0UL)    /*!< ARFC (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDIR_ARFI_Pos       (0UL)       /*!< ARFI (Bit 0)                                          */
 #define R_BUS_SDRAM_SDIR_ARFI_Msk       (0xfUL)     /*!< ARFI (Bitfield-Mask: 0x0f)                            */
/* =========================================================  SDADR  ========================================================= */
 #define R_BUS_SDRAM_SDADR_MXC_Pos       (0UL)       /*!< MXC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDADR_MXC_Msk       (0x3UL)     /*!< MXC (Bitfield-Mask: 0x03)                             */
/* =========================================================  SDTR  ========================================================== */
 #define R_BUS_SDRAM_SDTR_RAS_Pos        (16UL)      /*!< RAS (Bit 16)                                          */
 #define R_BUS_SDRAM_SDTR_RAS_Msk        (0x70000UL) /*!< RAS (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDTR_RCD_Pos        (12UL)      /*!< RCD (Bit 12)                                          */
 #define R_BUS_SDRAM_SDTR_RCD_Msk        (0x3000UL)  /*!< RCD (Bitfield-Mask: 0x03)                             */
 #define R_BUS_SDRAM_SDTR_RP_Pos         (9UL)       /*!< RP (Bit 9)                                            */
 #define R_BUS_SDRAM_SDTR_RP_Msk         (0xe00UL)   /*!< RP (Bitfield-Mask: 0x07)                              */
 #define R_BUS_SDRAM_SDTR_WR_Pos         (8UL)       /*!< WR (Bit 8)                                            */
 #define R_BUS_SDRAM_SDTR_WR_Msk         (0x100UL)   /*!< WR (Bitfield-Mask: 0x01)                              */
 #define R_BUS_SDRAM_SDTR_CL_Pos         (0UL)       /*!< CL (Bit 0)                                            */
 #define R_BUS_SDRAM_SDTR_CL_Msk         (0x7UL)     /*!< CL (Bitfield-Mask: 0x07)                              */
/* =========================================================  SDMOD  ========================================================= */
 #define R_BUS_SDRAM_SDMOD_MR_Pos        (0UL)       /*!< MR (Bit 0)                                            */
 #define R_BUS_SDRAM_SDMOD_MR_Msk        (0x7fffUL)  /*!< MR (Bitfield-Mask: 0x7fff)                            */
/* =========================================================  SDSR  ========================================================== */
 #define R_BUS_SDRAM_SDSR_SRFST_Pos      (4UL)       /*!< SRFST (Bit 4)                                         */
 #define R_BUS_SDRAM_SDSR_SRFST_Msk      (0x10UL)    /*!< SRFST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_INIST_Pos      (3UL)       /*!< INIST (Bit 3)                                         */
 #define R_BUS_SDRAM_SDSR_INIST_Msk      (0x8UL)     /*!< INIST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_MRSST_Pos      (0UL)       /*!< MRSST (Bit 0)                                         */
 #define R_BUS_SDRAM_SDSR_MRSST_Msk      (0x1UL)     /*!< MRSST (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                          BUSERR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_BUSERR_ADD_BERAD_Pos       (0UL)          /*!< BERAD (Bit 0)                                         */
 #define R_BUS_BUSERR_ADD_BERAD_Msk       (0xffffffffUL) /*!< BERAD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  STAT  ========================================================== */
 #define R_BUS_BUSERR_STAT_ERRSTAT_Pos    (7UL)          /*!< ERRSTAT (Bit 7)                                       */
 #define R_BUS_BUSERR_STAT_ERRSTAT_Msk    (0x80UL)       /*!< ERRSTAT (Bitfield-Mask: 0x01)                         */
 #define R_BUS_BUSERR_STAT_ACCSTAT_Pos    (0UL)          /*!< ACCSTAT (Bit 0)                                       */
 #define R_BUS_BUSERR_STAT_ACCSTAT_Msk    (0x1UL)        /*!< ACCSTAT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                           BUSM                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSM_CNT_IERES_Pos    (15UL)     /*!< IERES (Bit 15)                                        */
 #define R_BUS_BUSM_CNT_IERES_Msk    (0x8000UL) /*!< IERES (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           BUSS                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSS_CNT_ARBMET_Pos    (4UL)    /*!< ARBMET (Bit 4)                                        */
 #define R_BUS_BUSS_CNT_ARBMET_Msk    (0x30UL) /*!< ARBMET (Bitfield-Mask: 0x03)                          */

/* =========================================================================================================================== */
/* ================                                          ELSEGR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  BY  =========================================================== */
 #define R_ELC_ELSEGR_BY_WI_Pos     (7UL)    /*!< WI (Bit 7)                                            */
 #define R_ELC_ELSEGR_BY_WI_Msk     (0x80UL) /*!< WI (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_WE_Pos     (6UL)    /*!< WE (Bit 6)                                            */
 #define R_ELC_ELSEGR_BY_WE_Msk     (0x40UL) /*!< WE (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_SEG_Pos    (0UL)    /*!< SEG (Bit 0)                                           */
 #define R_ELC_ELSEGR_BY_SEG_Msk    (0x1UL)  /*!< SEG (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           ELSR                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  HA  =========================================================== */
 #define R_ELC_ELSR_HA_ELS_Pos    (0UL)     /*!< ELS (Bit 0)                                           */
 #define R_ELC_ELSR_HA_ELS_Msk    (0x1ffUL) /*!< ELS (Bitfield-Mask: 0x1ff)                            */

/* =========================================================================================================================== */
/* ================                                            SAR                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  L  =========================================================== */
 #define R_IIC0_SAR_L_SVA_Pos     (0UL)    /*!< SVA (Bit 0)                                           */
 #define R_IIC0_SAR_L_SVA_Msk     (0xffUL) /*!< SVA (Bitfield-Mask: 0xff)                             */
/* ===========================================================  U  =========================================================== */
 #define R_IIC0_SAR_U_SVA9_Pos    (2UL)    /*!< SVA9 (Bit 2)                                          */
 #define R_IIC0_SAR_U_SVA9_Msk    (0x4UL)  /*!< SVA9 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_SVA8_Pos    (1UL)    /*!< SVA8 (Bit 1)                                          */
 #define R_IIC0_SAR_U_SVA8_Msk    (0x2UL)  /*!< SVA8 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_FS_Pos      (0UL)    /*!< FS (Bit 0)                                            */
 #define R_IIC0_SAR_U_FS_Msk      (0x1UL)  /*!< FS (Bitfield-Mask: 0x01)                              */

/* =========================================================================================================================== */
/* ================                                          REGION                                           ================ */
/* =========================================================================================================================== */

/* ===========================================================  C  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_C_WP_Pos         (2UL)          /*!< WP (Bit 2)                                            */
 #define R_MPU_MMPU_MMPU_REGION_C_WP_Msk         (0x4UL)        /*!< WP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_C_RP_Pos         (1UL)          /*!< RP (Bit 1)                                            */
 #define R_MPU_MMPU_MMPU_REGION_C_RP_Msk         (0x2UL)        /*!< RP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_C_ENABLE_Pos     (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_REGION_C_ENABLE_Msk     (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ===========================================================  S  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUSmn_Pos    (0UL)          /*!< MMPUSmn (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUSmn_Msk    (0xffffffffUL) /*!< MMPUSmn (Bitfield-Mask: 0xffffffff)                   */
/* ===========================================================  E  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUEmn_Pos    (0UL)          /*!< MMPUEmn (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUEmn_Msk    (0xffffffffUL) /*!< MMPUEmn (Bitfield-Mask: 0xffffffff)                   */

/* =========================================================================================================================== */
/* ================                                           MMPU                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Pos       (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Msk       (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Pos       (1UL)      /*!< OAD (Bit 1)                                           */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Msk       (0x2UL)    /*!< OAD (Bitfield-Mask: 0x01)                             */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Pos    (0UL)      /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Msk    (0x1UL)    /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_MMPU_MMPU_PT_KEY_Pos        (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_PT_KEY_Msk        (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Pos    (0UL)      /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Msk    (0x1UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                           SMPU                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  R  =========================================================== */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Pos    (15UL)     /*!< WPSRAMHS (Bit 15)                                     */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Msk    (0x8000UL) /*!< WPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Pos    (14UL)     /*!< RPSRAMHS (Bit 14)                                     */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Msk    (0x4000UL) /*!< RPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Pos       (13UL)     /*!< WPFLI (Bit 13)                                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Msk       (0x2000UL) /*!< WPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Pos       (12UL)     /*!< RPFLI (Bit 12)                                        */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Msk       (0x1000UL) /*!< RPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Pos      (7UL)      /*!< WPGRPC (Bit 7)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Msk      (0x80UL)   /*!< WPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Pos      (6UL)      /*!< RPGRPC (Bit 6)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Msk      (0x40UL)   /*!< RPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Pos      (5UL)      /*!< WPGRPB (Bit 5)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Msk      (0x20UL)   /*!< WPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Pos      (4UL)      /*!< RPGRPB (Bit 4)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Msk      (0x10UL)   /*!< RPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Pos      (3UL)      /*!< WPGRPA (Bit 3)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Msk      (0x8UL)    /*!< WPGRPA (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Pos      (2UL)      /*!< RPGRPA (Bit 2)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Msk      (0x4UL)    /*!< RPGRPA (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                            SP                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  OAD  ========================================================== */
 #define R_MPU_SPMON_SP_OAD_KEY_Pos        (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_OAD_KEY_Msk        (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_OAD_OAD_Pos        (0UL)          /*!< OAD (Bit 0)                                           */
 #define R_MPU_SPMON_SP_OAD_OAD_Msk        (0x1UL)        /*!< OAD (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_SPMON_SP_CTL_ERROR_Pos      (8UL)          /*!< ERROR (Bit 8)                                         */
 #define R_MPU_SPMON_SP_CTL_ERROR_Msk      (0x100UL)      /*!< ERROR (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Pos     (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Msk     (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_SPMON_SP_PT_KEY_Pos         (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_PT_KEY_Msk         (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_PT_PROTECT_Pos     (0UL)          /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_SPMON_SP_PT_PROTECT_Msk     (0x1UL)        /*!< PROTECT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  SA  =========================================================== */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Pos    (0UL)          /*!< MSPMPUSA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Msk    (0xffffffffUL) /*!< MSPMPUSA (Bitfield-Mask: 0xffffffff)                  */
/* ==========================================================  EA  =========================================================== */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Pos    (0UL)          /*!< MSPMPUEA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Msk    (0xffffffffUL) /*!< MSPMPUEA (Bitfield-Mask: 0xffffffff)                  */

/* =========================================================================================================================== */
/* ================                                            PIN                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  PmnPFS_BY  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
/* =======================================================  PmnPFS_HA  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Pos     (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Msk     (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Pos     (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Msk     (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Pos     (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Msk     (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Pos     (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Msk     (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
/* ========================================================  PmnPFS  ========================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Pos       (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Msk       (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Pos         (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Msk         (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Pos         (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Msk         (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Pos         (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Msk         (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Pos        (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Msk        (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Pos        (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Msk        (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Pos        (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Msk        (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Pos        (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Msk        (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Pos        (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Msk        (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Pos        (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Msk        (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Pos        (24UL)         /*!< PSEL (Bit 24)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Msk        (0x1f000000UL) /*!< PSEL (Bitfield-Mask: 0x1f)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Pos         (16UL)         /*!< PMR (Bit 16)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Msk         (0x10000UL)    /*!< PMR (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           PORT                                            ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                           VLSEL                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  VL1SEL  ========================================================= */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Pos    (0UL)   /*!< SELVL (Bit 0)                                         */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Msk    (0x1UL) /*!< SELVL (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           PMSAR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  PMSAR  ========================================================= */

/* =========================================================================================================================== */
/* ================                                           CTRL                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  AGTCR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Pos          (7UL)    /*!< TCMBF (Bit 7)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Msk          (0x80UL) /*!< TCMBF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Pos          (6UL)    /*!< TCMAF (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Msk          (0x40UL) /*!< TCMAF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Pos          (5UL)    /*!< TUNDF (Bit 5)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Msk          (0x20UL) /*!< TUNDF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Pos          (4UL)    /*!< TEDGF (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Msk          (0x10UL) /*!< TEDGF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Pos          (2UL)    /*!< TSTOP (Bit 2)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Msk          (0x4UL)  /*!< TSTOP (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Pos          (1UL)    /*!< TCSTF (Bit 1)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Msk          (0x2UL)  /*!< TCSTF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Pos         (0UL)    /*!< TSTART (Bit 0)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Msk         (0x1UL)  /*!< TSTART (Bitfield-Mask: 0x01)                          */
/* ========================================================  AGTMR1  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Pos           (4UL)    /*!< TCK (Bit 4)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Msk           (0x70UL) /*!< TCK (Bitfield-Mask: 0x07)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Pos        (3UL)    /*!< TEDGPL (Bit 3)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Msk        (0x8UL)  /*!< TEDGPL (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Pos          (0UL)    /*!< TMOD (Bit 0)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Msk          (0x7UL)  /*!< TMOD (Bitfield-Mask: 0x07)                            */
/* ========================================================  AGTMR2  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Pos           (7UL)    /*!< LPM (Bit 7)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Msk           (0x80UL) /*!< LPM (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Pos           (0UL)    /*!< CKS (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Msk           (0x7UL)  /*!< CKS (Bitfield-Mask: 0x07)                             */
/* =====================================================  AGTIOSEL_ALT  ====================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Pos    (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Msk    (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Pos     (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Msk     (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */
/* ========================================================  AGTIOC  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Pos         (6UL)    /*!< TIOGT (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Msk         (0xc0UL) /*!< TIOGT (Bitfield-Mask: 0x03)                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Pos          (4UL)    /*!< TIPF (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Msk          (0x30UL) /*!< TIPF (Bitfield-Mask: 0x03)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Pos           (2UL)    /*!< TOE (Bit 2)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Msk           (0x4UL)  /*!< TOE (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Pos       (0UL)    /*!< TEDGSEL (Bit 0)                                       */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Msk       (0x1UL)  /*!< TEDGSEL (Bitfield-Mask: 0x01)                         */
/* ========================================================  AGTISR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Pos          (2UL)    /*!< EEPS (Bit 2)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Msk          (0x4UL)  /*!< EEPS (Bitfield-Mask: 0x01)                            */
/* ========================================================  AGTCMSR  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Pos       (6UL)    /*!< TOPOLB (Bit 6)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Msk       (0x40UL) /*!< TOPOLB (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Pos         (5UL)    /*!< TOEB (Bit 5)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Msk         (0x20UL) /*!< TOEB (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Pos        (4UL)    /*!< TCMEB (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Msk        (0x10UL) /*!< TCMEB (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Pos       (2UL)    /*!< TOPOLA (Bit 2)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Msk       (0x4UL)  /*!< TOPOLA (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Pos         (1UL)    /*!< TOEA (Bit 1)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Msk         (0x2UL)  /*!< TOEA (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Pos        (0UL)    /*!< TCMEA (Bit 0)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Msk        (0x1UL)  /*!< TCMEA (Bitfield-Mask: 0x01)                           */
/* =======================================================  AGTIOSEL  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Pos        (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Msk        (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Pos         (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Msk         (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */

/* =========================================================================================================================== */
/* ================                                           AGT16                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT16_AGT_AGT_Pos          (0UL)      /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT16_AGT_AGT_Msk          (0xffffUL) /*!< AGT (Bitfield-Mask: 0xffff)                           */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Pos    (0UL)      /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Msk    (0xffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffff)                        */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Pos    (0UL)      /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Msk    (0xffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffff)                        */

/* =========================================================================================================================== */
/* ================                                           AGT32                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT32_AGT_AGT_Pos          (0UL)          /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT32_AGT_AGT_Msk          (0xffffffffUL) /*!< AGT (Bitfield-Mask: 0xffffffff)                       */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Pos    (0UL)          /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Msk    (0xffffffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Pos    (0UL)          /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Msk    (0xffffffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffffffff)                    */

/** @} */ /* End of group PosMask_clusters */

/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ADCSR  ========================================================= */
 #define R_ADC0_ADCSR_ADST_Pos              (15UL)      /*!< ADST (Bit 15)                                         */
 #define R_ADC0_ADCSR_ADST_Msk              (0x8000UL)  /*!< ADST (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_ADCS_Pos              (13UL)      /*!< ADCS (Bit 13)                                         */
 #define R_ADC0_ADCSR_ADCS_Msk              (0x6000UL)  /*!< ADCS (Bitfield-Mask: 0x03)                            */
 #define R_ADC0_ADCSR_ADHSC_Pos             (10UL)      /*!< ADHSC (Bit 10)                                        */
 #define R_ADC0_ADCSR_ADHSC_Msk             (0x400UL)   /*!< ADHSC (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_TRGE_Pos              (9UL)       /*!< TRGE (Bit 9)                                          */
 #define R_ADC0_ADCSR_TRGE_Msk              (0x200UL)   /*!< TRGE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_EXTRG_Pos             (8UL)       /*!< EXTRG (Bit 8)                                         */
 #define R_ADC0_ADCSR_EXTRG_Msk             (0x100UL)   /*!< EXTRG (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_DBLE_Pos              (7UL)       /*!< DBLE (Bit 7)                                          */
 #define R_ADC0_ADCSR_DBLE_Msk              (0x80UL)    /*!< DBLE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_GBADIE_Pos            (6UL)       /*!< GBADIE (Bit 6)                                        */
 #define R_ADC0_ADCSR_GBADIE_Msk            (0x40UL)    /*!< GBADIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCSR_DBLANS_Pos            (0UL)       /*!< DBLANS (Bit 0)                                        */
 #define R_ADC0_ADCSR_DBLANS_Msk            (0x1fUL)    /*!< DBLANS (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADCSR_ADIE_Pos              (12UL)      /*!< ADIE (Bit 12)                                         */
 #define R_ADC0_ADCSR_ADIE_Msk              (0x1000UL)  /*!< ADIE (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADANSA  ========================================================= */
 #define R_ADC0_ADANSA_ANSA_Pos             (0UL)       /*!< ANSA (Bit 0)                                          */
 #define R_ADC0_ADANSA_ANSA_Msk             (0x1UL)     /*!< ANSA (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADADS  ========================================================= */
 #define R_ADC0_ADADS_ADS_Pos               (0UL)       /*!< ADS (Bit 0)                                           */
 #define R_ADC0_ADADS_ADS_Msk               (0x1UL)     /*!< ADS (Bitfield-Mask: 0x01)                             */
/* =========================================================  ADADC  ========================================================= */
 #define R_ADC0_ADADC_ADC_Pos               (0UL)       /*!< ADC (Bit 0)                                           */
 #define R_ADC0_ADADC_ADC_Msk               (0x7UL)     /*!< ADC (Bitfield-Mask: 0x07)                             */
 #define R_ADC0_ADADC_AVEE_Pos              (7UL)       /*!< AVEE (Bit 7)                                          */
 #define R_ADC0_ADADC_AVEE_Msk              (0x80UL)    /*!< AVEE (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADCER  ========================================================= */
 #define R_ADC0_ADCER_ADRFMT_Pos            (15UL)      /*!< ADRFMT (Bit 15)                                       */
 #define R_ADC0_ADCER_ADRFMT_Msk            (0x8000UL)  /*!< ADRFMT (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_ADINV_Pos             (14UL)      /*!< ADINV (Bit 14)                                        */
 #define R_ADC0_ADCER_ADINV_Msk             (0x4000UL)  /*!< ADINV (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGM_Pos             (11UL)      /*!< DIAGM (Bit 11)                                        */
 #define R_ADC0_ADCER_DIAGM_Msk             (0x800UL)   /*!< DIAGM (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGLD_Pos            (10UL)      /*!< DIAGLD (Bit 10)                                       */
 #define R_ADC0_ADCER_DIAGLD_Msk            (0x400UL)   /*!< DIAGLD (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_DIAGVAL_Pos           (8UL)       /*!< DIAGVAL (Bit 8)                                       */
 #define R_ADC0_ADCER_DIAGVAL_Msk           (0x300UL)   /*!< DIAGVAL (Bitfield-Mask: 0x03)                         */
 #define R_ADC0_ADCER_ACE_Pos               (5UL)       /*!< ACE (Bit 5)                                           */
 #define R_ADC0_ADCER_ACE_Msk               (0x20UL)    /*!< ACE (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADCER_ADPRC_Pos             (1UL)       /*!< ADPRC (Bit 1)                                         */
 #define R_ADC0_ADCER_ADPRC_Msk             (0x6UL)     /*!< ADPRC (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADCER_DCE_Pos               (4UL)       /*!< DCE (Bit 4)                                           */
 #define R_ADC0_ADCER_DCE_Msk               (0x10UL)    /*!< DCE (Bitfield-Mask: 0x01)                             */
/* ========================================================  ADSTRGR  ======================================================== */
 #define R_ADC0_ADSTRGR_TRSA_Pos            (8UL)       /*!< TRSA (Bit 8)                                          */
 #define R_ADC0_ADSTRGR_TRSA_Msk            (0x3f00UL)  /*!< TRSA (Bitfield-Mask: 0x3f)                            */
 #define R_ADC0_ADSTRGR_TRSB_Pos            (0UL)       /*!< TRSB (Bit 0)                                          */
 #define R_ADC0_ADSTRGR_TRSB_Msk            (0x3fUL)    /*!< TRSB (Bitfield-Mask: 0x3f)                            */
/* ========================================================  ADEXICR  ======================================================== */
 #define R_ADC0_ADEXICR_OCSB_Pos            (11UL)      /*!< OCSB (Bit 11)                                         */
 #define R_ADC0_ADEXICR_OCSB_Msk            (0x800UL)   /*!< OCSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSB_Pos            (10UL)      /*!< TSSB (Bit 10)                                         */
 #define R_ADC0_ADEXICR_TSSB_Msk            (0x400UL)   /*!< TSSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSA_Pos            (9UL)       /*!< OCSA (Bit 9)                                          */
 #define R_ADC0_ADEXICR_OCSA_Msk            (0x200UL)   /*!< OCSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSA_Pos            (8UL)       /*!< TSSA (Bit 8)                                          */
 #define R_ADC0_ADEXICR_TSSA_Msk            (0x100UL)   /*!< TSSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSAD_Pos           (1UL)       /*!< OCSAD (Bit 1)                                         */
 #define R_ADC0_ADEXICR_OCSAD_Msk           (0x2UL)     /*!< OCSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_TSSAD_Pos           (0UL)       /*!< TSSAD (Bit 0)                                         */
 #define R_ADC0_ADEXICR_TSSAD_Msk           (0x1UL)     /*!< TSSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXSEL_Pos           (14UL)      /*!< EXSEL (Bit 14)                                        */
 #define R_ADC0_ADEXICR_EXSEL_Msk           (0x4000UL)  /*!< EXSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXOEN_Pos           (15UL)      /*!< EXOEN (Bit 15)                                        */
 #define R_ADC0_ADEXICR_EXOEN_Msk           (0x8000UL)  /*!< EXOEN (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADANSB  ========================================================= */
 #define R_ADC0_ADANSB_ANSB_Pos             (0UL)       /*!< ANSB (Bit 0)                                          */
 #define R_ADC0_ADANSB_ANSB_Msk             (0x1UL)     /*!< ANSB (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADDBLDR  ======================================================== */
 #define R_ADC0_ADDBLDR_ADDBLDR_Pos         (0UL)       /*!< ADDBLDR (Bit 0)                                       */
 #define R_ADC0_ADDBLDR_ADDBLDR_Msk         (0xffffUL)  /*!< ADDBLDR (Bitfield-Mask: 0xffff)                       */
/* ========================================================  ADTSDR  ========================================================= */
 #define R_ADC0_ADTSDR_ADTSDR_Pos           (0UL)       /*!< ADTSDR (Bit 0)                                        */
 #define R_ADC0_ADTSDR_ADTSDR_Msk           (0xffffUL)  /*!< ADTSDR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  ADOCDR  ========================================================= */
 #define R_ADC0_ADOCDR_ADOCDR_Pos           (0UL)       /*!< ADOCDR (Bit 0)                                        */
 #define R_ADC0_ADOCDR_ADOCDR_Msk           (0xffffUL)  /*!< ADOCDR (Bitfield-Mask: 0xffff)                        */
/* ======================================================  ADRD_RIGHT  ======================================================= */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Pos       (14UL)      /*!< DIAGST (Bit 14)                                       */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Msk       (0xc000UL)  /*!< DIAGST (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADRD_RIGHT_AD_Pos           (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_RIGHT_AD_Msk           (0x3fffUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
/* =======================================================  ADRD_LEFT  ======================================================= */
 #define R_ADC0_ADRD_LEFT_AD_Pos            (2UL)       /*!< AD (Bit 2)                                            */
 #define R_ADC0_ADRD_LEFT_AD_Msk            (0xfffcUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
 #define R_ADC0_ADRD_LEFT_DIAGST_Pos        (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRD_LEFT_DIAGST_Msk        (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* =========================================================  ADDR  ========================================================== */
 #define R_ADC0_ADDR_ADDR_Pos               (0UL)       /*!< ADDR (Bit 0)                                          */
 #define R_ADC0_ADDR_ADDR_Msk               (0xffffUL)  /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* ========================================================  ADSHCR  ========================================================= */
 #define R_ADC0_ADSHCR_SHANS2_Pos           (10UL)      /*!< SHANS2 (Bit 10)                                       */
 #define R_ADC0_ADSHCR_SHANS2_Msk           (0x400UL)   /*!< SHANS2 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS1_Pos           (9UL)       /*!< SHANS1 (Bit 9)                                        */
 #define R_ADC0_ADSHCR_SHANS1_Msk           (0x200UL)   /*!< SHANS1 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS0_Pos           (8UL)       /*!< SHANS0 (Bit 8)                                        */
 #define R_ADC0_ADSHCR_SHANS0_Msk           (0x100UL)   /*!< SHANS0 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SSTSH_Pos            (0UL)       /*!< SSTSH (Bit 0)                                         */
 #define R_ADC0_ADSHCR_SSTSH_Msk            (0xffUL)    /*!< SSTSH (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADDISCR  ======================================================== */
 #define R_ADC0_ADDISCR_CHARGE_Pos          (4UL)       /*!< CHARGE (Bit 4)                                        */
 #define R_ADC0_ADDISCR_CHARGE_Msk          (0x10UL)    /*!< CHARGE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADDISCR_ADNDIS_Pos          (0UL)       /*!< ADNDIS (Bit 0)                                        */
 #define R_ADC0_ADDISCR_ADNDIS_Msk          (0xfUL)     /*!< ADNDIS (Bitfield-Mask: 0x0f)                          */
/* ========================================================  ADSHMSR  ======================================================== */
 #define R_ADC0_ADSHMSR_SHMD_Pos            (0UL)       /*!< SHMD (Bit 0)                                          */
 #define R_ADC0_ADSHMSR_SHMD_Msk            (0x1UL)     /*!< SHMD (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADACSR  ========================================================= */
 #define R_ADC0_ADACSR_ADSAC_Pos            (1UL)       /*!< ADSAC (Bit 1)                                         */
 #define R_ADC0_ADACSR_ADSAC_Msk            (0x2UL)     /*!< ADSAC (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADGSPCR  ======================================================== */
 #define R_ADC0_ADGSPCR_GBRP_Pos            (15UL)      /*!< GBRP (Bit 15)                                         */
 #define R_ADC0_ADGSPCR_GBRP_Msk            (0x8000UL)  /*!< GBRP (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADGSPCR_GBRSCN_Pos          (1UL)       /*!< GBRSCN (Bit 1)                                        */
 #define R_ADC0_ADGSPCR_GBRSCN_Msk          (0x2UL)     /*!< GBRSCN (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADGSPCR_PGS_Pos             (0UL)       /*!< PGS (Bit 0)                                           */
 #define R_ADC0_ADGSPCR_PGS_Msk             (0x1UL)     /*!< PGS (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADGSPCR_GBEXTRG_Pos         (8UL)       /*!< GBEXTRG (Bit 8)                                       */
 #define R_ADC0_ADGSPCR_GBEXTRG_Msk         (0x100UL)   /*!< GBEXTRG (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADICR  ========================================================= */
 #define R_ADC0_ADICR_ADIC_Pos              (0UL)       /*!< ADIC (Bit 0)                                          */
 #define R_ADC0_ADICR_ADIC_Msk              (0x3UL)     /*!< ADIC (Bitfield-Mask: 0x03)                            */
/* =======================================================  ADDBLDRA  ======================================================== */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Pos       (0UL)       /*!< ADDBLDRA (Bit 0)                                      */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Msk       (0xffffUL)  /*!< ADDBLDRA (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADDBLDRB  ======================================================== */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Pos       (0UL)       /*!< ADDBLDRB (Bit 0)                                      */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Msk       (0xffffUL)  /*!< ADDBLDRB (Bitfield-Mask: 0xffff)                      */
/* ======================================================  ADHVREFCNT  ======================================================= */
 #define R_ADC0_ADHVREFCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_ADHVREFCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_LVSEL_Pos        (4UL)       /*!< LVSEL (Bit 4)                                         */
 #define R_ADC0_ADHVREFCNT_LVSEL_Msk        (0x10UL)    /*!< LVSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_HVSEL_Pos        (0UL)       /*!< HVSEL (Bit 0)                                         */
 #define R_ADC0_ADHVREFCNT_HVSEL_Msk        (0x3UL)     /*!< HVSEL (Bitfield-Mask: 0x03)                           */
/* =======================================================  ADWINMON  ======================================================== */
 #define R_ADC0_ADWINMON_MONCMPB_Pos        (5UL)       /*!< MONCMPB (Bit 5)                                       */
 #define R_ADC0_ADWINMON_MONCMPB_Msk        (0x20UL)    /*!< MONCMPB (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCMPA_Pos        (4UL)       /*!< MONCMPA (Bit 4)                                       */
 #define R_ADC0_ADWINMON_MONCMPA_Msk        (0x10UL)    /*!< MONCMPA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCOMB_Pos        (0UL)       /*!< MONCOMB (Bit 0)                                       */
 #define R_ADC0_ADWINMON_MONCOMB_Msk        (0x1UL)     /*!< MONCOMB (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADCMPCR  ======================================================== */
 #define R_ADC0_ADCMPCR_CMPAIE_Pos          (15UL)      /*!< CMPAIE (Bit 15)                                       */
 #define R_ADC0_ADCMPCR_CMPAIE_Msk          (0x8000UL)  /*!< CMPAIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_WCMPE_Pos           (14UL)      /*!< WCMPE (Bit 14)                                        */
 #define R_ADC0_ADCMPCR_WCMPE_Msk           (0x4000UL)  /*!< WCMPE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBIE_Pos          (13UL)      /*!< CMPBIE (Bit 13)                                       */
 #define R_ADC0_ADCMPCR_CMPBIE_Msk          (0x2000UL)  /*!< CMPBIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_CMPAE_Pos           (11UL)      /*!< CMPAE (Bit 11)                                        */
 #define R_ADC0_ADCMPCR_CMPAE_Msk           (0x800UL)   /*!< CMPAE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBE_Pos           (9UL)       /*!< CMPBE (Bit 9)                                         */
 #define R_ADC0_ADCMPCR_CMPBE_Msk           (0x200UL)   /*!< CMPBE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPAB_Pos           (0UL)       /*!< CMPAB (Bit 0)                                         */
 #define R_ADC0_ADCMPCR_CMPAB_Msk           (0x3UL)     /*!< CMPAB (Bitfield-Mask: 0x03)                           */
/* ======================================================  ADCMPANSER  ======================================================= */
 #define R_ADC0_ADCMPANSER_CMPOCA_Pos       (1UL)       /*!< CMPOCA (Bit 1)                                        */
 #define R_ADC0_ADCMPANSER_CMPOCA_Msk       (0x2UL)     /*!< CMPOCA (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPANSER_CMPTSA_Pos       (0UL)       /*!< CMPTSA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSER_CMPTSA_Msk       (0x1UL)     /*!< CMPTSA (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADCMPLER  ======================================================== */
 #define R_ADC0_ADCMPLER_CMPLOCA_Pos        (1UL)       /*!< CMPLOCA (Bit 1)                                       */
 #define R_ADC0_ADCMPLER_CMPLOCA_Msk        (0x2UL)     /*!< CMPLOCA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADCMPLER_CMPLTSA_Pos        (0UL)       /*!< CMPLTSA (Bit 0)                                       */
 #define R_ADC0_ADCMPLER_CMPLTSA_Msk        (0x1UL)     /*!< CMPLTSA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPANSR  ======================================================= */
 #define R_ADC0_ADCMPANSR_CMPCHA_Pos        (0UL)       /*!< CMPCHA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSR_CMPCHA_Msk        (0x1UL)     /*!< CMPCHA (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADCMPLR  ======================================================== */
 #define R_ADC0_ADCMPLR_CMPLCHA_Pos         (0UL)       /*!< CMPLCHA (Bit 0)                                       */
 #define R_ADC0_ADCMPLR_CMPLCHA_Msk         (0x1UL)     /*!< CMPLCHA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPDR0  ======================================================== */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Pos       (0UL)       /*!< ADCMPDR0 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Msk       (0xffffUL)  /*!< ADCMPDR0 (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPDR1  ======================================================== */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Pos       (0UL)       /*!< ADCMPDR1 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Msk       (0xffffUL)  /*!< ADCMPDR1 (Bitfield-Mask: 0xffff)                      */
/* ========================================================  ADCMPSR  ======================================================== */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Pos        (0UL)       /*!< CMPSTCHA (Bit 0)                                      */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Msk        (0x1UL)     /*!< CMPSTCHA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPSER  ======================================================== */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Pos       (1UL)       /*!< CMPSTOCA (Bit 1)                                      */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Msk       (0x2UL)     /*!< CMPSTOCA (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Pos       (0UL)       /*!< CMPSTTSA (Bit 0)                                      */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Msk       (0x1UL)     /*!< CMPSTTSA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPBNSR  ======================================================= */
 #define R_ADC0_ADCMPBNSR_CMPLB_Pos         (7UL)       /*!< CMPLB (Bit 7)                                         */
 #define R_ADC0_ADCMPBNSR_CMPLB_Msk         (0x80UL)    /*!< CMPLB (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Pos        (0UL)       /*!< CMPCHB (Bit 0)                                        */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Msk        (0x3fUL)    /*!< CMPCHB (Bitfield-Mask: 0x3f)                          */
/* =======================================================  ADWINLLB  ======================================================== */
 #define R_ADC0_ADWINLLB_ADWINLLB_Pos       (0UL)       /*!< ADWINLLB (Bit 0)                                      */
 #define R_ADC0_ADWINLLB_ADWINLLB_Msk       (0xffffUL)  /*!< ADWINLLB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADWINULB  ======================================================== */
 #define R_ADC0_ADWINULB_ADWINULB_Pos       (0UL)       /*!< ADWINULB (Bit 0)                                      */
 #define R_ADC0_ADWINULB_ADWINULB_Msk       (0xffffUL)  /*!< ADWINULB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPBSR  ======================================================== */
 #define R_ADC0_ADCMPBSR_CMPSTB_Pos         (0UL)       /*!< CMPSTB (Bit 0)                                        */
 #define R_ADC0_ADCMPBSR_CMPSTB_Msk         (0x1UL)     /*!< CMPSTB (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADSSTRL  ======================================================== */
 #define R_ADC0_ADSSTRL_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRL_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRT  ======================================================== */
 #define R_ADC0_ADSSTRT_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRT_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRO  ======================================================== */
 #define R_ADC0_ADSSTRO_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRO_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTR  ========================================================= */
 #define R_ADC0_ADSSTR_SST_Pos              (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTR_SST_Msk              (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADPGACR  ======================================================== */
 #define R_ADC0_ADPGACR_P002GEN_Pos         (11UL)      /*!< P002GEN (Bit 11)                                      */
 #define R_ADC0_ADPGACR_P002GEN_Msk         (0x800UL)   /*!< P002GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P002ENAMP_Pos       (10UL)      /*!< P002ENAMP (Bit 10)                                    */
 #define R_ADC0_ADPGACR_P002ENAMP_Msk       (0x400UL)   /*!< P002ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P002SEL1_Pos        (9UL)       /*!< P002SEL1 (Bit 9)                                      */
 #define R_ADC0_ADPGACR_P002SEL1_Msk        (0x200UL)   /*!< P002SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P002SEL0_Pos        (8UL)       /*!< P002SEL0 (Bit 8)                                      */
 #define R_ADC0_ADPGACR_P002SEL0_Msk        (0x100UL)   /*!< P002SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001GEN_Pos         (7UL)       /*!< P001GEN (Bit 7)                                       */
 #define R_ADC0_ADPGACR_P001GEN_Msk         (0x80UL)    /*!< P001GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P001ENAMP_Pos       (6UL)       /*!< P001ENAMP (Bit 6)                                     */
 #define R_ADC0_ADPGACR_P001ENAMP_Msk       (0x40UL)    /*!< P001ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P001SEL1_Pos        (5UL)       /*!< P001SEL1 (Bit 5)                                      */
 #define R_ADC0_ADPGACR_P001SEL1_Msk        (0x20UL)    /*!< P001SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001SEL0_Pos        (4UL)       /*!< P001SEL0 (Bit 4)                                      */
 #define R_ADC0_ADPGACR_P001SEL0_Msk        (0x10UL)    /*!< P001SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000GEN_Pos         (3UL)       /*!< P000GEN (Bit 3)                                       */
 #define R_ADC0_ADPGACR_P000GEN_Msk         (0x8UL)     /*!< P000GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P000ENAMP_Pos       (2UL)       /*!< P000ENAMP (Bit 2)                                     */
 #define R_ADC0_ADPGACR_P000ENAMP_Msk       (0x4UL)     /*!< P000ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P000SEL1_Pos        (1UL)       /*!< P000SEL1 (Bit 1)                                      */
 #define R_ADC0_ADPGACR_P000SEL1_Msk        (0x2UL)     /*!< P000SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000SEL0_Pos        (0UL)       /*!< P000SEL0 (Bit 0)                                      */
 #define R_ADC0_ADPGACR_P000SEL0_Msk        (0x1UL)     /*!< P000SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL0_Pos        (12UL)      /*!< P003SEL0 (Bit 12)                                     */
 #define R_ADC0_ADPGACR_P003SEL0_Msk        (0x1000UL)  /*!< P003SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL1_Pos        (13UL)      /*!< P003SEL1 (Bit 13)                                     */
 #define R_ADC0_ADPGACR_P003SEL1_Msk        (0x2000UL)  /*!< P003SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003ENAMP_Pos       (14UL)      /*!< P003ENAMP (Bit 14)                                    */
 #define R_ADC0_ADPGACR_P003ENAMP_Msk       (0x4000UL)  /*!< P003ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P003GEN_Pos         (15UL)      /*!< P003GEN (Bit 15)                                      */
 #define R_ADC0_ADPGACR_P003GEN_Msk         (0x8000UL)  /*!< P003GEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADRD  ========================================================== */
 #define R_ADC0_ADRD_AD_Pos                 (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_AD_Msk                 (0xffffUL)  /*!< AD (Bitfield-Mask: 0xffff)                            */
/* =========================================================  ADRST  ========================================================= */
 #define R_ADC0_ADRST_DIAGST_Pos            (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRST_DIAGST_Msk            (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* ======================================================  VREFAMPCNT  ======================================================= */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Pos     (1UL)       /*!< VREFADCG (Bit 1)                                      */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Msk     (0x6UL)     /*!< VREFADCG (Bitfield-Mask: 0x03)                        */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Pos    (3UL)       /*!< VREFADCEN (Bit 3)                                     */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Msk    (0x8UL)     /*!< VREFADCEN (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_VREFAMPCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_VREFAMPCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Pos      (0UL)       /*!< OLDETEN (Bit 0)                                       */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Msk      (0x1UL)     /*!< OLDETEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Pos        (4UL)       /*!< BGREN (Bit 4)                                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Msk        (0x10UL)    /*!< BGREN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADCALEXE  ======================================================== */
 #define R_ADC0_ADCALEXE_CALEXE_Pos         (7UL)       /*!< CALEXE (Bit 7)                                        */
 #define R_ADC0_ADCALEXE_CALEXE_Msk         (0x80UL)    /*!< CALEXE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCALEXE_CALMON_Pos         (6UL)       /*!< CALMON (Bit 6)                                        */
 #define R_ADC0_ADCALEXE_CALMON_Msk         (0x40UL)    /*!< CALMON (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADANIM  ========================================================= */
 #define R_ADC0_ADANIM_ANIM_Pos             (0UL)       /*!< ANIM (Bit 0)                                          */
 #define R_ADC0_ADANIM_ANIM_Msk             (0x1UL)     /*!< ANIM (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADPGAGS0  ======================================================== */
 #define R_ADC0_ADPGAGS0_P002GAIN_Pos       (8UL)       /*!< P002GAIN (Bit 8)                                      */
 #define R_ADC0_ADPGAGS0_P002GAIN_Msk       (0xf00UL)   /*!< P002GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P001GAIN_Pos       (4UL)       /*!< P001GAIN (Bit 4)                                      */
 #define R_ADC0_ADPGAGS0_P001GAIN_Msk       (0xf0UL)    /*!< P001GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P000GAIN_Pos       (0UL)       /*!< P000GAIN (Bit 0)                                      */
 #define R_ADC0_ADPGAGS0_P000GAIN_Msk       (0xfUL)     /*!< P000GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P003GAIN_Pos       (12UL)      /*!< P003GAIN (Bit 12)                                     */
 #define R_ADC0_ADPGAGS0_P003GAIN_Msk       (0xf000UL)  /*!< P003GAIN (Bitfield-Mask: 0x0f)                        */
/* =======================================================  ADPGADCR0  ======================================================= */
 #define R_ADC0_ADPGADCR0_P003DG_Pos        (12UL)      /*!< P003DG (Bit 12)                                       */
 #define R_ADC0_ADPGADCR0_P003DG_Msk        (0x3000UL)  /*!< P003DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P002DEN_Pos       (11UL)      /*!< P002DEN (Bit 11)                                      */
 #define R_ADC0_ADPGADCR0_P002DEN_Msk       (0x800UL)   /*!< P002DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P002DG_Pos        (8UL)       /*!< P002DG (Bit 8)                                        */
 #define R_ADC0_ADPGADCR0_P002DG_Msk        (0x300UL)   /*!< P002DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P001DEN_Pos       (7UL)       /*!< P001DEN (Bit 7)                                       */
 #define R_ADC0_ADPGADCR0_P001DEN_Msk       (0x80UL)    /*!< P001DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P001DG_Pos        (4UL)       /*!< P001DG (Bit 4)                                        */
 #define R_ADC0_ADPGADCR0_P001DG_Msk        (0x30UL)    /*!< P001DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P000DEN_Pos       (3UL)       /*!< P000DEN (Bit 3)                                       */
 #define R_ADC0_ADPGADCR0_P000DEN_Msk       (0x8UL)     /*!< P000DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P000DG_Pos        (0UL)       /*!< P000DG (Bit 0)                                        */
 #define R_ADC0_ADPGADCR0_P000DG_Msk        (0x3UL)     /*!< P000DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P003DEN_Pos       (15UL)      /*!< P003DEN (Bit 15)                                      */
 #define R_ADC0_ADPGADCR0_P003DEN_Msk       (0x8000UL)  /*!< P003DEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADREF  ========================================================= */
 #define R_ADC0_ADREF_ADF_Pos               (0UL)       /*!< ADF (Bit 0)                                           */
 #define R_ADC0_ADREF_ADF_Msk               (0x1UL)     /*!< ADF (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADREF_ADSCACT_Pos           (7UL)       /*!< ADSCACT (Bit 7)                                       */
 #define R_ADC0_ADREF_ADSCACT_Msk           (0x80UL)    /*!< ADSCACT (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADEXREF  ======================================================== */
 #define R_ADC0_ADEXREF_GBADF_Pos           (0UL)       /*!< GBADF (Bit 0)                                         */
 #define R_ADC0_ADEXREF_GBADF_Msk           (0x1UL)     /*!< GBADF (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADAMPOFF  ======================================================== */
 #define R_ADC0_ADAMPOFF_OPOFF_Pos          (0UL)       /*!< OPOFF (Bit 0)                                         */
 #define R_ADC0_ADAMPOFF_OPOFF_Msk          (0xffUL)    /*!< OPOFF (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADTSTPR  ======================================================== */
 #define R_ADC0_ADTSTPR_PRO_Pos             (0UL)       /*!< PRO (Bit 0)                                           */
 #define R_ADC0_ADTSTPR_PRO_Msk             (0x1UL)     /*!< PRO (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADTSTPR_B0WI_Pos            (1UL)       /*!< B0WI (Bit 1)                                          */
 #define R_ADC0_ADTSTPR_B0WI_Msk            (0x2UL)     /*!< B0WI (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADDDACER  ======================================================== */
 #define R_ADC0_ADDDACER_WRION_Pos          (0UL)       /*!< WRION (Bit 0)                                         */
 #define R_ADC0_ADDDACER_WRION_Msk          (0x1fUL)    /*!< WRION (Bitfield-Mask: 0x1f)                           */
 #define R_ADC0_ADDDACER_WRIOFF_Pos         (8UL)       /*!< WRIOFF (Bit 8)                                        */
 #define R_ADC0_ADDDACER_WRIOFF_Msk         (0x1f00UL)  /*!< WRIOFF (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADDDACER_ADHS_Pos           (15UL)      /*!< ADHS (Bit 15)                                         */
 #define R_ADC0_ADDDACER_ADHS_Msk           (0x8000UL)  /*!< ADHS (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADEXTSTR  ======================================================== */
 #define R_ADC0_ADEXTSTR_SHTEST_Pos         (0UL)       /*!< SHTEST (Bit 0)                                        */
 #define R_ADC0_ADEXTSTR_SHTEST_Msk         (0x7UL)     /*!< SHTEST (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADEXTSTR_SWTST_Pos          (4UL)       /*!< SWTST (Bit 4)                                         */
 #define R_ADC0_ADEXTSTR_SWTST_Msk          (0x30UL)    /*!< SWTST (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_SHTRM_Pos          (8UL)       /*!< SHTRM (Bit 8)                                         */
 #define R_ADC0_ADEXTSTR_SHTRM_Msk          (0x300UL)   /*!< SHTRM (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_ADTRM3_Pos         (11UL)      /*!< ADTRM3 (Bit 11)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM3_Msk         (0x800UL)   /*!< ADTRM3 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADEXTSTR_ADTRM2_Pos         (12UL)      /*!< ADTRM2 (Bit 12)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM2_Msk         (0x3000UL)  /*!< ADTRM2 (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADEXTSTR_ADTRM1_Pos         (14UL)      /*!< ADTRM1 (Bit 14)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM1_Msk         (0xc000UL)  /*!< ADTRM1 (Bitfield-Mask: 0x03)                          */
/* ========================================================  ADTSTRA  ======================================================== */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Pos        (0UL)       /*!< ATBUSSEL (Bit 0)                                      */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Msk        (0x1UL)     /*!< ATBUSSEL (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADTSTRA_TSTSWREF_Pos        (1UL)       /*!< TSTSWREF (Bit 1)                                      */
 #define R_ADC0_ADTSTRA_TSTSWREF_Msk        (0xeUL)     /*!< TSTSWREF (Bitfield-Mask: 0x07)                        */
 #define R_ADC0_ADTSTRA_OCSW_Pos            (5UL)       /*!< OCSW (Bit 5)                                          */
 #define R_ADC0_ADTSTRA_OCSW_Msk            (0x20UL)    /*!< OCSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_TSSW_Pos            (6UL)       /*!< TSSW (Bit 6)                                          */
 #define R_ADC0_ADTSTRA_TSSW_Msk            (0x40UL)    /*!< TSSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Pos       (8UL)       /*!< ADTEST_AD (Bit 8)                                     */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Msk       (0xf00UL)   /*!< ADTEST_AD (Bitfield-Mask: 0x0f)                       */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Pos       (12UL)      /*!< ADTEST_IO (Bit 12)                                    */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Msk       (0xf000UL)  /*!< ADTEST_IO (Bitfield-Mask: 0x0f)                       */
/* ========================================================  ADTSTRB  ======================================================== */
 #define R_ADC0_ADTSTRB_ADVAL_Pos           (0UL)       /*!< ADVAL (Bit 0)                                         */
 #define R_ADC0_ADTSTRB_ADVAL_Msk           (0x7fffUL)  /*!< ADVAL (Bitfield-Mask: 0x7fff)                         */
/* ========================================================  ADTSTRC  ======================================================== */
 #define R_ADC0_ADTSTRC_ADMD_Pos            (0UL)       /*!< ADMD (Bit 0)                                          */
 #define R_ADC0_ADTSTRC_ADMD_Msk            (0xffUL)    /*!< ADMD (Bitfield-Mask: 0xff)                            */
 #define R_ADC0_ADTSTRC_SYNCERR_Pos         (12UL)      /*!< SYNCERR (Bit 12)                                      */
 #define R_ADC0_ADTSTRC_SYNCERR_Msk         (0x1000UL)  /*!< SYNCERR (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADTSTRD  ======================================================== */
 #define R_ADC0_ADTSTRD_ADVAL16_Pos         (0UL)       /*!< ADVAL16 (Bit 0)                                       */
 #define R_ADC0_ADTSTRD_ADVAL16_Msk         (0x1UL)     /*!< ADVAL16 (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADSWTSTR0  ======================================================= */
 #define R_ADC0_ADSWTSTR0_CHSW00_Pos        (0UL)       /*!< CHSW00 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW00_Msk        (0x1UL)     /*!< CHSW00 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW01_Pos        (1UL)       /*!< CHSW01 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW01_Msk        (0x2UL)     /*!< CHSW01 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW02_Pos        (2UL)       /*!< CHSW02 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW02_Msk        (0x4UL)     /*!< CHSW02 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW03_Pos        (3UL)       /*!< CHSW03 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW03_Msk        (0x8UL)     /*!< CHSW03 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW04_Pos        (4UL)       /*!< CHSW04 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW04_Msk        (0x10UL)    /*!< CHSW04 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW05_Pos        (5UL)       /*!< CHSW05 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW05_Msk        (0x20UL)    /*!< CHSW05 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR1  ======================================================= */
 #define R_ADC0_ADSWTSTR1_CHSW16_Pos        (0UL)       /*!< CHSW16 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW16_Msk        (0x1UL)     /*!< CHSW16 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW17_Pos        (1UL)       /*!< CHSW17 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW17_Msk        (0x2UL)     /*!< CHSW17 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW18_Pos        (2UL)       /*!< CHSW18 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW18_Msk        (0x4UL)     /*!< CHSW18 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW19_Pos        (3UL)       /*!< CHSW19 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW19_Msk        (0x8UL)     /*!< CHSW19 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW20_Pos        (4UL)       /*!< CHSW20 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW20_Msk        (0x10UL)    /*!< CHSW20 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW21_Pos        (5UL)       /*!< CHSW21 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW21_Msk        (0x20UL)    /*!< CHSW21 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR2  ======================================================= */
 #define R_ADC0_ADSWTSTR2_EX0SW_Pos         (0UL)       /*!< EX0SW (Bit 0)                                         */
 #define R_ADC0_ADSWTSTR2_EX0SW_Msk         (0x1UL)     /*!< EX0SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_EX1SW_Pos         (1UL)       /*!< EX1SW (Bit 1)                                         */
 #define R_ADC0_ADSWTSTR2_EX1SW_Msk         (0x2UL)     /*!< EX1SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Pos       (4UL)       /*!< SHBYPS0 (Bit 4)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Msk       (0x10UL)    /*!< SHBYPS0 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Pos       (5UL)       /*!< SHBYPS1 (Bit 5)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Msk       (0x20UL)    /*!< SHBYPS1 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Pos       (6UL)       /*!< SHBYPS2 (Bit 6)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Msk       (0x40UL)    /*!< SHBYPS2 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Pos        (8UL)       /*!< GRP0SW (Bit 8)                                        */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Msk        (0x100UL)   /*!< GRP0SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Pos        (9UL)       /*!< GRP1SW (Bit 9)                                        */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Msk        (0x200UL)   /*!< GRP1SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Pos        (10UL)      /*!< GRP2SW (Bit 10)                                       */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Msk        (0x400UL)   /*!< GRP2SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Pos        (11UL)      /*!< GRP3SW (Bit 11)                                       */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Msk        (0x800UL)   /*!< GRP3SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Pos      (12UL)      /*!< GRPEX1SW (Bit 12)                                     */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Msk      (0x1000UL)  /*!< GRPEX1SW (Bitfield-Mask: 0x01)                        */
/* ========================================================  ADSWCR  ========================================================= */
 #define R_ADC0_ADSWCR_ADSWREF_Pos          (0UL)       /*!< ADSWREF (Bit 0)                                       */
 #define R_ADC0_ADSWCR_ADSWREF_Msk          (0x7UL)     /*!< ADSWREF (Bitfield-Mask: 0x07)                         */
 #define R_ADC0_ADSWCR_SHSWREF_Pos          (4UL)       /*!< SHSWREF (Bit 4)                                       */
 #define R_ADC0_ADSWCR_SHSWREF_Msk          (0x70UL)    /*!< SHSWREF (Bitfield-Mask: 0x07)                         */
/* ========================================================  ADGSCS  ========================================================= */
 #define R_ADC0_ADGSCS_CHSELGB_Pos          (0UL)       /*!< CHSELGB (Bit 0)                                       */
 #define R_ADC0_ADGSCS_CHSELGB_Msk          (0xffUL)    /*!< CHSELGB (Bitfield-Mask: 0xff)                         */
 #define R_ADC0_ADGSCS_CHSELGA_Pos          (8UL)       /*!< CHSELGA (Bit 8)                                       */
 #define R_ADC0_ADGSCS_CHSELGA_Msk          (0xff00UL)  /*!< CHSELGA (Bitfield-Mask: 0xff)                         */
/* =========================================================  ADSER  ========================================================= */
 #define R_ADC0_ADSER_SMPEX_Pos             (7UL)       /*!< SMPEX (Bit 7)                                         */
 #define R_ADC0_ADSER_SMPEX_Msk             (0x80UL)    /*!< SMPEX (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADBUF0  ========================================================= */
 #define R_ADC0_ADBUF0_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF0_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF1  ========================================================= */
 #define R_ADC0_ADBUF1_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF1_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF2  ========================================================= */
 #define R_ADC0_ADBUF2_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF2_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF3  ========================================================= */
 #define R_ADC0_ADBUF3_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF3_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF4  ========================================================= */
 #define R_ADC0_ADBUF4_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF4_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF5  ========================================================= */
 #define R_ADC0_ADBUF5_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF5_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF6  ========================================================= */
 #define R_ADC0_ADBUF6_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF6_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF7  ========================================================= */
 #define R_ADC0_ADBUF7_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF7_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF8  ========================================================= */
 #define R_ADC0_ADBUF8_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF8_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF9  ========================================================= */
 #define R_ADC0_ADBUF9_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF9_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF10  ======================================================== */
 #define R_ADC0_ADBUF10_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF10_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF11  ======================================================== */
 #define R_ADC0_ADBUF11_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF11_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF12  ======================================================== */
 #define R_ADC0_ADBUF12_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF12_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF13  ======================================================== */
 #define R_ADC0_ADBUF13_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF13_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF14  ======================================================== */
 #define R_ADC0_ADBUF14_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF14_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF15  ======================================================== */
 #define R_ADC0_ADBUF15_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF15_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUFEN  ======================================================== */
 #define R_ADC0_ADBUFEN_BUFEN_Pos           (0UL)       /*!< BUFEN (Bit 0)                                         */
 #define R_ADC0_ADBUFEN_BUFEN_Msk           (0x1UL)     /*!< BUFEN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADBUFPTR  ======================================================== */
 #define R_ADC0_ADBUFPTR_BUFPTR_Pos         (0UL)       /*!< BUFPTR (Bit 0)                                        */
 #define R_ADC0_ADBUFPTR_BUFPTR_Msk         (0xfUL)     /*!< BUFPTR (Bitfield-Mask: 0x0f)                          */
 #define R_ADC0_ADBUFPTR_PTROVF_Pos         (4UL)       /*!< PTROVF (Bit 4)                                        */
 #define R_ADC0_ADBUFPTR_PTROVF_Msk         (0x10UL)    /*!< PTROVF (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS0  ======================================================= */
 #define R_ADC0_ADPGADBS0_P0BIAS_Pos        (0UL)       /*!< P0BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS0_P0BIAS_Msk        (0x1UL)     /*!< P0BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS1  ======================================================= */
 #define R_ADC0_ADPGADBS1_P3BIAS_Pos        (0UL)       /*!< P3BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS1_P3BIAS_Msk        (0x1UL)     /*!< P3BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADREFMON  ======================================================== */
 #define R_ADC0_ADREFMON_PGAMON_Pos         (0UL)       /*!< PGAMON (Bit 0)                                        */
 #define R_ADC0_ADREFMON_PGAMON_Msk         (0x7UL)     /*!< PGAMON (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADREFMON_MONSEL_Pos         (16UL)      /*!< MONSEL (Bit 16)                                       */
 #define R_ADC0_ADREFMON_MONSEL_Msk         (0xf0000UL) /*!< MONSEL (Bitfield-Mask: 0x0f)                          */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  CSRECEN  ======================================================== */
 #define R_BUS_CSRECEN_RCVENM_Pos    (8UL)     /*!< RCVENM (Bit 8)                                        */
 #define R_BUS_CSRECEN_RCVENM_Msk    (0x100UL) /*!< RCVENM (Bitfield-Mask: 0x01)                          */
 #define R_BUS_CSRECEN_RCVEN_Pos     (0UL)     /*!< RCVEN (Bit 0)                                         */
 #define R_BUS_CSRECEN_RCVEN_Msk     (0x1UL)   /*!< RCVEN (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CACR0  ========================================================= */
 #define R_CAC_CACR0_CFME_Pos         (0UL)      /*!< CFME (Bit 0)                                          */
 #define R_CAC_CACR0_CFME_Msk         (0x1UL)    /*!< CFME (Bitfield-Mask: 0x01)                            */
/* =========================================================  CACR1  ========================================================= */
 #define R_CAC_CACR1_EDGES_Pos        (6UL)      /*!< EDGES (Bit 6)                                         */
 #define R_CAC_CACR1_EDGES_Msk        (0xc0UL)   /*!< EDGES (Bitfield-Mask: 0x03)                           */
 #define R_CAC_CACR1_TCSS_Pos         (4UL)      /*!< TCSS (Bit 4)                                          */
 #define R_CAC_CACR1_TCSS_Msk         (0x30UL)   /*!< TCSS (Bitfield-Mask: 0x03)                            */
 #define R_CAC_CACR1_FMCS_Pos         (1UL)      /*!< FMCS (Bit 1)                                          */
 #define R_CAC_CACR1_FMCS_Msk         (0xeUL)    /*!< FMCS (Bitfield-Mask: 0x07)                            */
 #define R_CAC_CACR1_CACREFE_Pos      (0UL)      /*!< CACREFE (Bit 0)                                       */
 #define R_CAC_CACR1_CACREFE_Msk      (0x1UL)    /*!< CACREFE (Bitfield-Mask: 0x01)                         */
/* =========================================================  CACR2  ========================================================= */
 #define R_CAC_CACR2_DFS_Pos          (6UL)      /*!< DFS (Bit 6)                                           */
 #define R_CAC_CACR2_DFS_Msk          (0xc0UL)   /*!< DFS (Bitfield-Mask: 0x03)                             */
 #define R_CAC_CACR2_RCDS_Pos         (4UL)      /*!< RCDS (Bit 4)                                          */
 #define R_CAC_CACR2_RCDS_Msk         (0x30UL)   /*!< RCDS (Bitfield-Mask: 0x03)                            */
 #define R_CAC_CACR2_RSCS_Pos         (1UL)      /*!< RSCS (Bit 1)                                          */
 #define R_CAC_CACR2_RSCS_Msk         (0xeUL)    /*!< RSCS (Bitfield-Mask: 0x07)                            */
 #define R_CAC_CACR2_RPS_Pos          (0UL)      /*!< RPS (Bit 0)                                           */
 #define R_CAC_CACR2_RPS_Msk          (0x1UL)    /*!< RPS (Bitfield-Mask: 0x01)                             */
/* =========================================================  CAICR  ========================================================= */
 #define R_CAC_CAICR_OVFFCL_Pos       (6UL)      /*!< OVFFCL (Bit 6)                                        */
 #define R_CAC_CAICR_OVFFCL_Msk       (0x40UL)   /*!< OVFFCL (Bitfield-Mask: 0x01)                          */
 #define R_CAC_CAICR_MENDFCL_Pos      (5UL)      /*!< MENDFCL (Bit 5)                                       */
 #define R_CAC_CAICR_MENDFCL_Msk      (0x20UL)   /*!< MENDFCL (Bitfield-Mask: 0x01)                         */
 #define R_CAC_CAICR_FERRFCL_Pos      (4UL)      /*!< FERRFCL (Bit 4)                                       */
 #define R_CAC_CAICR_FERRFCL_Msk      (0x10UL)   /*!< FERRFCL (Bitfield-Mask: 0x01)                         */
 #define R_CAC_CAICR_OVFIE_Pos        (2UL)      /*!< OVFIE (Bit 2)                                         */
 #define R_CAC_CAICR_OVFIE_Msk        (0x4UL)    /*!< OVFIE (Bitfield-Mask: 0x01)                           */
 #define R_CAC_CAICR_MENDIE_Pos       (1UL)      /*!< MENDIE (Bit 1)                                        */
 #define R_CAC_CAICR_MENDIE_Msk       (0x2UL)    /*!< MENDIE (Bitfield-Mask: 0x01)                          */
 #define R_CAC_CAICR_FERRIE_Pos       (0UL)      /*!< FERRIE (Bit 0)                                        */
 #define R_CAC_CAICR_FERRIE_Msk       (0x1UL)    /*!< FERRIE (Bitfield-Mask: 0x01)                          */
/* =========================================================  CASTR  ========================================================= */
 #define R_CAC_CASTR_OVFF_Pos         (2UL)      /*!< OVFF (Bit 2)                                          */
 #define R_CAC_CASTR_OVFF_Msk         (0x4UL)    /*!< OVFF (Bitfield-Mask: 0x01)                            */
 #define R_CAC_CASTR_MENDF_Pos        (1UL)      /*!< MENDF (Bit 1)                                         */
 #define R_CAC_CASTR_MENDF_Msk        (0x2UL)    /*!< MENDF (Bitfield-Mask: 0x01)                           */
 #define R_CAC_CASTR_FERRF_Pos        (0UL)      /*!< FERRF (Bit 0)                                         */
 #define R_CAC_CASTR_FERRF_Msk        (0x1UL)    /*!< FERRF (Bitfield-Mask: 0x01)                           */
/* ========================================================  CAULVR  ========================================================= */
 #define R_CAC_CAULVR_CAULVR_Pos      (0UL)      /*!< CAULVR (Bit 0)                                        */
 #define R_CAC_CAULVR_CAULVR_Msk      (0xffffUL) /*!< CAULVR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  CALLVR  ========================================================= */
 #define R_CAC_CALLVR_CALLVR_Pos      (0UL)      /*!< CALLVR (Bit 0)                                        */
 #define R_CAC_CALLVR_CALLVR_Msk      (0xffffUL) /*!< CALLVR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  CACNTBR  ======================================================== */
 #define R_CAC_CACNTBR_CACNTBR_Pos    (0UL)      /*!< CACNTBR (Bit 0)                                       */
 #define R_CAC_CACNTBR_CACNTBR_Msk    (0xffffUL) /*!< CACNTBR (Bitfield-Mask: 0xffff)                       */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  CRCCR0  ========================================================= */
 #define R_CRC_CRCCR0_DORCLR_Pos          (7UL)          /*!< DORCLR (Bit 7)                                        */
 #define R_CRC_CRCCR0_DORCLR_Msk          (0x80UL)       /*!< DORCLR (Bitfield-Mask: 0x01)                          */
 #define R_CRC_CRCCR0_LMS_Pos             (6UL)          /*!< LMS (Bit 6)                                           */
 #define R_CRC_CRCCR0_LMS_Msk             (0x40UL)       /*!< LMS (Bitfield-Mask: 0x01)                             */
 #define R_CRC_CRCCR0_GPS_Pos             (0UL)          /*!< GPS (Bit 0)                                           */
 #define R_CRC_CRCCR0_GPS_Msk             (0x7UL)        /*!< GPS (Bitfield-Mask: 0x07)                             */
/* ========================================================  CRCCR1  ========================================================= */
 #define R_CRC_CRCCR1_CRCSEN_Pos          (7UL)          /*!< CRCSEN (Bit 7)                                        */
 #define R_CRC_CRCCR1_CRCSEN_Msk          (0x80UL)       /*!< CRCSEN (Bitfield-Mask: 0x01)                          */
 #define R_CRC_CRCCR1_CRCSWR_Pos          (6UL)          /*!< CRCSWR (Bit 6)                                        */
 #define R_CRC_CRCCR1_CRCSWR_Msk          (0x40UL)       /*!< CRCSWR (Bitfield-Mask: 0x01)                          */
/* ========================================================  CRCDIR  ========================================================= */
 #define R_CRC_CRCDIR_CRCDIR_Pos          (0UL)          /*!< CRCDIR (Bit 0)                                        */
 #define R_CRC_CRCDIR_CRCDIR_Msk          (0xffffffffUL) /*!< CRCDIR (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  CRCDIR_BY  ======================================================= */
 #define R_CRC_CRCDIR_BY_CRCDIR_BY_Pos    (0UL)          /*!< CRCDIR_BY (Bit 0)                                     */
 #define R_CRC_CRCDIR_BY_CRCDIR_BY_Msk    (0xffUL)       /*!< CRCDIR_BY (Bitfield-Mask: 0xff)                       */
/* ========================================================  CRCDOR  ========================================================= */
 #define R_CRC_CRCDOR_CRCDOR_Pos          (0UL)          /*!< CRCDOR (Bit 0)                                        */
 #define R_CRC_CRCDOR_CRCDOR_Msk          (0xffffffffUL) /*!< CRCDOR (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  CRCDOR_HA  ======================================================= */
 #define R_CRC_CRCDOR_HA_CRCDOR_HA_Pos    (0UL)          /*!< CRCDOR_HA (Bit 0)                                     */
 #define R_CRC_CRCDOR_HA_CRCDOR_HA_Msk    (0xffffUL)     /*!< CRCDOR_HA (Bitfield-Mask: 0xffff)                     */
/* =======================================================  CRCDOR_BY  ======================================================= */
 #define R_CRC_CRCDOR_BY_CRCDOR_BY_Pos    (0UL)          /*!< CRCDOR_BY (Bit 0)                                     */
 #define R_CRC_CRCDOR_BY_CRCDOR_BY_Msk    (0xffUL)       /*!< CRCDOR_BY (Bitfield-Mask: 0xff)                       */
/* ========================================================  CRCSAR  ========================================================= */
 #define R_CRC_CRCSAR_CRCSA_Pos           (0UL)          /*!< CRCSA (Bit 0)                                         */
 #define R_CRC_CRCSAR_CRCSA_Msk           (0x3fffUL)     /*!< CRCSA (Bitfield-Mask: 0x3fff)                         */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  DBGSTR  ========================================================= */
 #define R_DEBUG_DBGSTR_CDBGPWRUPREQ_Pos        (28UL)         /*!< CDBGPWRUPREQ (Bit 28)                                 */
 #define R_DEBUG_DBGSTR_CDBGPWRUPREQ_Msk        (0x10000000UL) /*!< CDBGPWRUPREQ (Bitfield-Mask: 0x01)                    */
 #define R_DEBUG_DBGSTR_CDBGPWRUPACK_Pos        (29UL)         /*!< CDBGPWRUPACK (Bit 29)                                 */
 #define R_DEBUG_DBGSTR_CDBGPWRUPACK_Msk        (0x20000000UL) /*!< CDBGPWRUPACK (Bitfield-Mask: 0x01)                    */
/* =======================================================  DBGSTOPCR  ======================================================= */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RPER_Pos     (24UL)         /*!< DBGSTOP_RPER (Bit 24)                                 */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RPER_Msk     (0x1000000UL)  /*!< DBGSTOP_RPER (Bitfield-Mask: 0x01)                    */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_LVD_Pos      (16UL)         /*!< DBGSTOP_LVD (Bit 16)                                  */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_LVD_Msk      (0x10000UL)    /*!< DBGSTOP_LVD (Bitfield-Mask: 0x01)                     */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RECCR_Pos    (25UL)         /*!< DBGSTOP_RECCR (Bit 25)                                */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RECCR_Msk    (0x2000000UL)  /*!< DBGSTOP_RECCR (Bitfield-Mask: 0x01)                   */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_IWDT_Pos     (0UL)          /*!< DBGSTOP_IWDT (Bit 0)                                  */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_IWDT_Msk     (0x1UL)        /*!< DBGSTOP_IWDT (Bitfield-Mask: 0x01)                    */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_WDT_Pos      (1UL)          /*!< DBGSTOP_WDT (Bit 1)                                   */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_WDT_Msk      (0x2UL)        /*!< DBGSTOP_WDT (Bitfield-Mask: 0x01)                     */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_CPER_Pos     (31UL)         /*!< DBGSTOP_CPER (Bit 31)                                 */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_CPER_Msk     (0x80000000UL) /*!< DBGSTOP_CPER (Bitfield-Mask: 0x01)                    */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  DOCR  ========================================================== */
 #define R_DOC_DOCR_DOPCFCL_Pos    (6UL)      /*!< DOPCFCL (Bit 6)                                       */
 #define R_DOC_DOCR_DOPCFCL_Msk    (0x40UL)   /*!< DOPCFCL (Bitfield-Mask: 0x01)                         */
 #define R_DOC_DOCR_DOPCF_Pos      (5UL)      /*!< DOPCF (Bit 5)                                         */
 #define R_DOC_DOCR_DOPCF_Msk      (0x20UL)   /*!< DOPCF (Bitfield-Mask: 0x01)                           */
 #define R_DOC_DOCR_DCSEL_Pos      (2UL)      /*!< DCSEL (Bit 2)                                         */
 #define R_DOC_DOCR_DCSEL_Msk      (0x4UL)    /*!< DCSEL (Bitfield-Mask: 0x01)                           */
 #define R_DOC_DOCR_OMS_Pos        (0UL)      /*!< OMS (Bit 0)                                           */
 #define R_DOC_DOCR_OMS_Msk        (0x3UL)    /*!< OMS (Bitfield-Mask: 0x03)                             */
/* =========================================================  DODIR  ========================================================= */
 #define R_DOC_DODIR_DODIR_Pos     (0UL)      /*!< DODIR (Bit 0)                                         */
 #define R_DOC_DODIR_DODIR_Msk     (0xffffUL) /*!< DODIR (Bitfield-Mask: 0xffff)                         */
/* =========================================================  DODSR  ========================================================= */
 #define R_DOC_DODSR_DODSR_Pos     (0UL)      /*!< DODSR (Bit 0)                                         */
 #define R_DOC_DODSR_DODSR_Msk     (0xffffUL) /*!< DODSR (Bitfield-Mask: 0xffff)                         */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  DTCCR  ========================================================= */
 #define R_DTC_DTCCR_RRS_Pos         (4UL)          /*!< RRS (Bit 4)                                           */
 #define R_DTC_DTCCR_RRS_Msk         (0x10UL)       /*!< RRS (Bitfield-Mask: 0x01)                             */
/* ========================================================  DTCVBR  ========================================================= */
 #define R_DTC_DTCVBR_DTCVBR_Pos     (0UL)          /*!< DTCVBR (Bit 0)                                        */
 #define R_DTC_DTCVBR_DTCVBR_Msk     (0xffffffffUL) /*!< DTCVBR (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  DTCST  ========================================================= */
 #define R_DTC_DTCST_DTCST_Pos       (0UL)          /*!< DTCST (Bit 0)                                         */
 #define R_DTC_DTCST_DTCST_Msk       (0x1UL)        /*!< DTCST (Bitfield-Mask: 0x01)                           */
/* ========================================================  DTCSTS  ========================================================= */
 #define R_DTC_DTCSTS_ACT_Pos        (15UL)         /*!< ACT (Bit 15)                                          */
 #define R_DTC_DTCSTS_ACT_Msk        (0x8000UL)     /*!< ACT (Bitfield-Mask: 0x01)                             */
 #define R_DTC_DTCSTS_VECN_Pos       (0UL)          /*!< VECN (Bit 0)                                          */
 #define R_DTC_DTCSTS_VECN_Msk       (0xffUL)       /*!< VECN (Bitfield-Mask: 0xff)                            */
/* =======================================================  DTCCR_SEC  ======================================================= */
 #define R_DTC_DTCCR_SEC_RRSS_Pos    (4UL)          /*!< RRSS (Bit 4)                                          */
 #define R_DTC_DTCCR_SEC_RRSS_Msk    (0x10UL)       /*!< RRSS (Bitfield-Mask: 0x01)                            */
/* ======================================================  DTCVBR_SEC  ======================================================= */
/* =========================================================  DTEVR  ========================================================= */
 #define R_DTC_DTEVR_DTEV_Pos        (0UL)          /*!< DTEV (Bit 0)                                          */
 #define R_DTC_DTEVR_DTEV_Msk        (0xffUL)       /*!< DTEV (Bitfield-Mask: 0xff)                            */
 #define R_DTC_DTEVR_DTEVSAM_Pos     (8UL)          /*!< DTEVSAM (Bit 8)                                       */
 #define R_DTC_DTEVR_DTEVSAM_Msk     (0x100UL)      /*!< DTEVSAM (Bitfield-Mask: 0x01)                         */
 #define R_DTC_DTEVR_DTESTA_Pos      (16UL)         /*!< DTESTA (Bit 16)                                       */
 #define R_DTC_DTEVR_DTESTA_Msk      (0x10000UL)    /*!< DTESTA (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ELCR  ========================================================== */
 #define R_ELC_ELCR_ELCON_Pos         (7UL)      /*!< ELCON (Bit 7)                                         */
 #define R_ELC_ELCR_ELCON_Msk         (0x80UL)   /*!< ELCON (Bitfield-Mask: 0x01)                           */
/* ========================================================  ELCSARA  ======================================================== */
 #define R_ELC_ELCSARA_ELCR_Pos       (0UL)      /*!< ELCR (Bit 0)                                          */
 #define R_ELC_ELCSARA_ELCR_Msk       (0x1UL)    /*!< ELCR (Bitfield-Mask: 0x01)                            */
 #define R_ELC_ELCSARA_ELSEGR0_Pos    (1UL)      /*!< ELSEGR0 (Bit 1)                                       */
 #define R_ELC_ELCSARA_ELSEGR0_Msk    (0x2UL)    /*!< ELSEGR0 (Bitfield-Mask: 0x01)                         */
 #define R_ELC_ELCSARA_ELSEGR1_Pos    (2UL)      /*!< ELSEGR1 (Bit 2)                                       */
 #define R_ELC_ELCSARA_ELSEGR1_Msk    (0x4UL)    /*!< ELSEGR1 (Bitfield-Mask: 0x01)                         */
/* ========================================================  ELCSARB  ======================================================== */
 #define R_ELC_ELCSARB_ELSR0_Pos      (0UL)      /*!< ELSR0 (Bit 0)                                         */
 #define R_ELC_ELCSARB_ELSR0_Msk      (0x1UL)    /*!< ELSR0 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR1_Pos      (1UL)      /*!< ELSR1 (Bit 1)                                         */
 #define R_ELC_ELCSARB_ELSR1_Msk      (0x2UL)    /*!< ELSR1 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR2_Pos      (2UL)      /*!< ELSR2 (Bit 2)                                         */
 #define R_ELC_ELCSARB_ELSR2_Msk      (0x4UL)    /*!< ELSR2 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR3_Pos      (3UL)      /*!< ELSR3 (Bit 3)                                         */
 #define R_ELC_ELCSARB_ELSR3_Msk      (0x8UL)    /*!< ELSR3 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR4_Pos      (4UL)      /*!< ELSR4 (Bit 4)                                         */
 #define R_ELC_ELCSARB_ELSR4_Msk      (0x10UL)   /*!< ELSR4 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR5_Pos      (5UL)      /*!< ELSR5 (Bit 5)                                         */
 #define R_ELC_ELCSARB_ELSR5_Msk      (0x20UL)   /*!< ELSR5 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR6_Pos      (6UL)      /*!< ELSR6 (Bit 6)                                         */
 #define R_ELC_ELCSARB_ELSR6_Msk      (0x40UL)   /*!< ELSR6 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR7_Pos      (7UL)      /*!< ELSR7 (Bit 7)                                         */
 #define R_ELC_ELCSARB_ELSR7_Msk      (0x80UL)   /*!< ELSR7 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR8_Pos      (8UL)      /*!< ELSR8 (Bit 8)                                         */
 #define R_ELC_ELCSARB_ELSR8_Msk      (0x100UL)  /*!< ELSR8 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR9_Pos      (9UL)      /*!< ELSR9 (Bit 9)                                         */
 #define R_ELC_ELCSARB_ELSR9_Msk      (0x200UL)  /*!< ELSR9 (Bitfield-Mask: 0x01)                           */
 #define R_ELC_ELCSARB_ELSR10_Pos     (10UL)     /*!< ELSR10 (Bit 10)                                       */
 #define R_ELC_ELCSARB_ELSR10_Msk     (0x400UL)  /*!< ELSR10 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARB_ELSR11_Pos     (11UL)     /*!< ELSR11 (Bit 11)                                       */
 #define R_ELC_ELCSARB_ELSR11_Msk     (0x800UL)  /*!< ELSR11 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARB_ELSR12_Pos     (12UL)     /*!< ELSR12 (Bit 12)                                       */
 #define R_ELC_ELCSARB_ELSR12_Msk     (0x1000UL) /*!< ELSR12 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARB_ELSR13_Pos     (13UL)     /*!< ELSR13 (Bit 13)                                       */
 #define R_ELC_ELCSARB_ELSR13_Msk     (0x2000UL) /*!< ELSR13 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARB_ELSR14_Pos     (14UL)     /*!< ELSR14 (Bit 14)                                       */
 #define R_ELC_ELCSARB_ELSR14_Msk     (0x4000UL) /*!< ELSR14 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARB_ELSR15_Pos     (15UL)     /*!< ELSR15 (Bit 15)                                       */
 #define R_ELC_ELCSARB_ELSR15_Msk     (0x8000UL) /*!< ELSR15 (Bitfield-Mask: 0x01)                          */
/* ========================================================  ELCSARC  ======================================================== */
 #define R_ELC_ELCSARC_ELSR16_Pos     (0UL)      /*!< ELSR16 (Bit 0)                                        */
 #define R_ELC_ELCSARC_ELSR16_Msk     (0x1UL)    /*!< ELSR16 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARC_ELSR17_Pos     (1UL)      /*!< ELSR17 (Bit 1)                                        */
 #define R_ELC_ELCSARC_ELSR17_Msk     (0x2UL)    /*!< ELSR17 (Bitfield-Mask: 0x01)                          */
 #define R_ELC_ELCSARC_ELSR18_Pos     (2UL)      /*!< ELSR18 (Bit 2)                                        */
 #define R_ELC_ELCSARC_ELSR18_Msk     (0x4UL)    /*!< ELSR18 (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                         R_FACI_LP                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  DFLCTL  ========================================================= */
/* =========================================================  FPMCR  ========================================================= */
 #define R_FACI_LP_FPMCR_FMS2_Pos           (7UL)      /*!< FMS2 (Bit 7)                                          */
 #define R_FACI_LP_FPMCR_FMS2_Msk           (0x80UL)   /*!< FMS2 (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FPMCR_VLPE_Pos           (6UL)      /*!< VLPE (Bit 6)                                          */
 #define R_FACI_LP_FPMCR_VLPE_Msk           (0x40UL)   /*!< VLPE (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FPMCR_FMS1_Pos           (4UL)      /*!< FMS1 (Bit 4)                                          */
 #define R_FACI_LP_FPMCR_FMS1_Msk           (0x10UL)   /*!< FMS1 (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FPMCR_RPDIS_Pos          (3UL)      /*!< RPDIS (Bit 3)                                         */
 #define R_FACI_LP_FPMCR_RPDIS_Msk          (0x8UL)    /*!< RPDIS (Bitfield-Mask: 0x01)                           */
 #define R_FACI_LP_FPMCR_FMS0_Pos           (1UL)      /*!< FMS0 (Bit 1)                                          */
 #define R_FACI_LP_FPMCR_FMS0_Msk           (0x2UL)    /*!< FMS0 (Bitfield-Mask: 0x01)                            */
/* =========================================================  FASR  ========================================================== */
 #define R_FACI_LP_FASR_EXS_Pos             (0UL)      /*!< EXS (Bit 0)                                           */
 #define R_FACI_LP_FASR_EXS_Msk             (0x1UL)    /*!< EXS (Bitfield-Mask: 0x01)                             */
/* =========================================================  FSARL  ========================================================= */
 #define R_FACI_LP_FSARL_FSAR15_0_Pos       (0UL)      /*!< FSAR15_0 (Bit 0)                                      */
 #define R_FACI_LP_FSARL_FSAR15_0_Msk       (0xffffUL) /*!< FSAR15_0 (Bitfield-Mask: 0xffff)                      */
/* =========================================================  FSARH  ========================================================= */
 #define R_FACI_LP_FSARH_FSAR31_25_Pos      (9UL)      /*!< FSAR31_25 (Bit 9)                                     */
 #define R_FACI_LP_FSARH_FSAR31_25_Msk      (0xfe00UL) /*!< FSAR31_25 (Bitfield-Mask: 0x7f)                       */
 #define R_FACI_LP_FSARH_FSAR20_16_Pos      (0UL)      /*!< FSAR20_16 (Bit 0)                                     */
 #define R_FACI_LP_FSARH_FSAR20_16_Msk      (0x1fUL)   /*!< FSAR20_16 (Bitfield-Mask: 0x1f)                       */
/* ==========================================================  FCR  ========================================================== */
 #define R_FACI_LP_FCR_OPST_Pos             (7UL)      /*!< OPST (Bit 7)                                          */
 #define R_FACI_LP_FCR_OPST_Msk             (0x80UL)   /*!< OPST (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FCR_STOP_Pos             (6UL)      /*!< STOP (Bit 6)                                          */
 #define R_FACI_LP_FCR_STOP_Msk             (0x40UL)   /*!< STOP (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FCR_DRC_Pos              (4UL)      /*!< DRC (Bit 4)                                           */
 #define R_FACI_LP_FCR_DRC_Msk              (0x10UL)   /*!< DRC (Bitfield-Mask: 0x01)                             */
 #define R_FACI_LP_FCR_CMD_Pos              (0UL)      /*!< CMD (Bit 0)                                           */
 #define R_FACI_LP_FCR_CMD_Msk              (0xfUL)    /*!< CMD (Bitfield-Mask: 0x0f)                             */
/* =========================================================  FEARL  ========================================================= */
 #define R_FACI_LP_FEARL_FEAR15_0_Pos       (0UL)      /*!< FEAR15_0 (Bit 0)                                      */
 #define R_FACI_LP_FEARL_FEAR15_0_Msk       (0xffffUL) /*!< FEAR15_0 (Bitfield-Mask: 0xffff)                      */
/* =========================================================  FEARH  ========================================================= */
 #define R_FACI_LP_FEARH_FEAR31_25_Pos      (9UL)      /*!< FEAR31_25 (Bit 9)                                     */
 #define R_FACI_LP_FEARH_FEAR31_25_Msk      (0xfe00UL) /*!< FEAR31_25 (Bitfield-Mask: 0x7f)                       */
 #define R_FACI_LP_FEARH_FEAR20_16_Pos      (0UL)      /*!< FEAR20_16 (Bit 0)                                     */
 #define R_FACI_LP_FEARH_FEAR20_16_Msk      (0x1fUL)   /*!< FEAR20_16 (Bitfield-Mask: 0x1f)                       */
/* ========================================================  FRESETR  ======================================================== */
 #define R_FACI_LP_FRESETR_FRESET_Pos       (0UL)      /*!< FRESET (Bit 0)                                        */
 #define R_FACI_LP_FRESETR_FRESET_Msk       (0x1UL)    /*!< FRESET (Bitfield-Mask: 0x01)                          */
/* =======================================================  FSTATR00  ======================================================== */
 #define R_FACI_LP_FSTATR00_EILGLERR_Pos    (5UL)      /*!< EILGLERR (Bit 5)                                      */
 #define R_FACI_LP_FSTATR00_EILGLERR_Msk    (0x20UL)   /*!< EILGLERR (Bitfield-Mask: 0x01)                        */
 #define R_FACI_LP_FSTATR00_ILGLERR_Pos     (4UL)      /*!< ILGLERR (Bit 4)                                       */
 #define R_FACI_LP_FSTATR00_ILGLERR_Msk     (0x10UL)   /*!< ILGLERR (Bitfield-Mask: 0x01)                         */
 #define R_FACI_LP_FSTATR00_BCERR0_Pos      (3UL)      /*!< BCERR0 (Bit 3)                                        */
 #define R_FACI_LP_FSTATR00_BCERR0_Msk      (0x8UL)    /*!< BCERR0 (Bitfield-Mask: 0x01)                          */
 #define R_FACI_LP_FSTATR00_PRGERR01_Pos    (2UL)      /*!< PRGERR01 (Bit 2)                                      */
 #define R_FACI_LP_FSTATR00_PRGERR01_Msk    (0x4UL)    /*!< PRGERR01 (Bitfield-Mask: 0x01)                        */
 #define R_FACI_LP_FSTATR00_PRGERR0_Pos     (1UL)      /*!< PRGERR0 (Bit 1)                                       */
 #define R_FACI_LP_FSTATR00_PRGERR0_Msk     (0x2UL)    /*!< PRGERR0 (Bitfield-Mask: 0x01)                         */
 #define R_FACI_LP_FSTATR00_ERERR0_Pos      (0UL)      /*!< ERERR0 (Bit 0)                                        */
 #define R_FACI_LP_FSTATR00_ERERR0_Msk      (0x1UL)    /*!< ERERR0 (Bitfield-Mask: 0x01)                          */
/* ========================================================  FSTATR1  ======================================================== */
 #define R_FACI_LP_FSTATR1_EXRDY_Pos        (7UL)      /*!< EXRDY (Bit 7)                                         */
 #define R_FACI_LP_FSTATR1_EXRDY_Msk        (0x80UL)   /*!< EXRDY (Bitfield-Mask: 0x01)                           */
 #define R_FACI_LP_FSTATR1_FRDY_Pos         (6UL)      /*!< FRDY (Bit 6)                                          */
 #define R_FACI_LP_FSTATR1_FRDY_Msk         (0x40UL)   /*!< FRDY (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FSTATR1_DRRDY_Pos        (1UL)      /*!< DRRDY (Bit 1)                                         */
 #define R_FACI_LP_FSTATR1_DRRDY_Msk        (0x2UL)    /*!< DRRDY (Bitfield-Mask: 0x01)                           */
/* =========================================================  FWBL0  ========================================================= */
 #define R_FACI_LP_FWBL0_WDATA_Pos          (0UL)      /*!< WDATA (Bit 0)                                         */
 #define R_FACI_LP_FWBL0_WDATA_Msk          (0xffffUL) /*!< WDATA (Bitfield-Mask: 0xffff)                         */
/* =========================================================  FWBH0  ========================================================= */
 #define R_FACI_LP_FWBH0_WDATA_Pos          (0UL)      /*!< WDATA (Bit 0)                                         */
 #define R_FACI_LP_FWBH0_WDATA_Msk          (0xffffUL) /*!< WDATA (Bitfield-Mask: 0xffff)                         */
/* =======================================================  FSTATR01  ======================================================== */
 #define R_FACI_LP_FSTATR01_BCERR1_Pos      (3UL)      /*!< BCERR1 (Bit 3)                                        */
 #define R_FACI_LP_FSTATR01_BCERR1_Msk      (0x8UL)    /*!< BCERR1 (Bitfield-Mask: 0x01)                          */
 #define R_FACI_LP_FSTATR01_PRGERR1_Pos     (1UL)      /*!< PRGERR1 (Bit 1)                                       */
 #define R_FACI_LP_FSTATR01_PRGERR1_Msk     (0x2UL)    /*!< PRGERR1 (Bitfield-Mask: 0x01)                         */
 #define R_FACI_LP_FSTATR01_ERERR1_Pos      (0UL)      /*!< ERERR1 (Bit 0)                                        */
 #define R_FACI_LP_FSTATR01_ERERR1_Msk      (0x1UL)    /*!< ERERR1 (Bitfield-Mask: 0x01)                          */
/* =========================================================  FWBL1  ========================================================= */
 #define R_FACI_LP_FWBL1_WDATA47_32_Pos     (0UL)      /*!< WDATA47_32 (Bit 0)                                    */
 #define R_FACI_LP_FWBL1_WDATA47_32_Msk     (0xffffUL) /*!< WDATA47_32 (Bitfield-Mask: 0xffff)                    */
/* =========================================================  FWBH1  ========================================================= */
 #define R_FACI_LP_FWBH1_WDATA63_48_Pos     (0UL)      /*!< WDATA63_48 (Bit 0)                                    */
 #define R_FACI_LP_FWBH1_WDATA63_48_Msk     (0xffffUL) /*!< WDATA63_48 (Bitfield-Mask: 0xffff)                    */
/* =========================================================  FRBL1  ========================================================= */
 #define R_FACI_LP_FRBL1_RDATA47_32_Pos     (0UL)      /*!< RDATA47_32 (Bit 0)                                    */
 #define R_FACI_LP_FRBL1_RDATA47_32_Msk     (0xffffUL) /*!< RDATA47_32 (Bitfield-Mask: 0xffff)                    */
/* =========================================================  FRBH1  ========================================================= */
 #define R_FACI_LP_FRBH1_RDATA63_48_Pos     (0UL)      /*!< RDATA63_48 (Bit 0)                                    */
 #define R_FACI_LP_FRBH1_RDATA63_48_Msk     (0xffffUL) /*!< RDATA63_48 (Bitfield-Mask: 0xffff)                    */
/* ==========================================================  FPR  ========================================================== */
 #define R_FACI_LP_FPR_FPR_Pos              (0UL)      /*!< FPR (Bit 0)                                           */
 #define R_FACI_LP_FPR_FPR_Msk              (0xffUL)   /*!< FPR (Bitfield-Mask: 0xff)                             */
/* =========================================================  FPSR  ========================================================== */
 #define R_FACI_LP_FPSR_PERR_Pos            (0UL)      /*!< PERR (Bit 0)                                          */
 #define R_FACI_LP_FPSR_PERR_Msk            (0x1UL)    /*!< PERR (Bitfield-Mask: 0x01)                            */
/* =========================================================  FRBL0  ========================================================= */
 #define R_FACI_LP_FRBL0_RDATA_Pos          (0UL)      /*!< RDATA (Bit 0)                                         */
 #define R_FACI_LP_FRBL0_RDATA_Msk          (0xffffUL) /*!< RDATA (Bitfield-Mask: 0xffff)                         */
/* =========================================================  FRBH0  ========================================================= */
 #define R_FACI_LP_FRBH0_RDATA_Pos          (0UL)      /*!< RDATA (Bit 0)                                         */
 #define R_FACI_LP_FRBH0_RDATA_Msk          (0xffffUL) /*!< RDATA (Bitfield-Mask: 0xffff)                         */
/* =========================================================  FSCMR  ========================================================= */
 #define R_FACI_LP_FSCMR_FSPR_Pos           (14UL)     /*!< FSPR (Bit 14)                                         */
 #define R_FACI_LP_FSCMR_FSPR_Msk           (0x4000UL) /*!< FSPR (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FSCMR_SASMF_Pos          (8UL)      /*!< SASMF (Bit 8)                                         */
 #define R_FACI_LP_FSCMR_SASMF_Msk          (0x100UL)  /*!< SASMF (Bitfield-Mask: 0x01)                           */
/* ========================================================  FAWSMR  ========================================================= */
 #define R_FACI_LP_FAWSMR_FAWS_Pos          (0UL)      /*!< FAWS (Bit 0)                                          */
 #define R_FACI_LP_FAWSMR_FAWS_Msk          (0xfffUL)  /*!< FAWS (Bitfield-Mask: 0xfff)                           */
/* ========================================================  FAWEMR  ========================================================= */
 #define R_FACI_LP_FAWEMR_FAWE_Pos          (0UL)      /*!< FAWE (Bit 0)                                          */
 #define R_FACI_LP_FAWEMR_FAWE_Msk          (0xfffUL)  /*!< FAWE (Bitfield-Mask: 0xfff)                           */
/* =========================================================  FISR  ========================================================== */
 #define R_FACI_LP_FISR_SAS_Pos             (6UL)      /*!< SAS (Bit 6)                                           */
 #define R_FACI_LP_FISR_SAS_Msk             (0xc0UL)   /*!< SAS (Bitfield-Mask: 0x03)                             */
 #define R_FACI_LP_FISR_PCKA_Pos            (0UL)      /*!< PCKA (Bit 0)                                          */
 #define R_FACI_LP_FISR_PCKA_Msk            (0x3fUL)   /*!< PCKA (Bitfield-Mask: 0x3f)                            */
/* =========================================================  FEXCR  ========================================================= */
 #define R_FACI_LP_FEXCR_OPST_Pos           (7UL)      /*!< OPST (Bit 7)                                          */
 #define R_FACI_LP_FEXCR_OPST_Msk           (0x80UL)   /*!< OPST (Bitfield-Mask: 0x01)                            */
 #define R_FACI_LP_FEXCR_CMD_Pos            (0UL)      /*!< CMD (Bit 0)                                           */
 #define R_FACI_LP_FEXCR_CMD_Msk            (0x7UL)    /*!< CMD (Bitfield-Mask: 0x07)                             */
/* =========================================================  FEAML  ========================================================= */
 #define R_FACI_LP_FEAML_FEAM_Pos           (0UL)      /*!< FEAM (Bit 0)                                          */
 #define R_FACI_LP_FEAML_FEAM_Msk           (0xffffUL) /*!< FEAM (Bitfield-Mask: 0xffff)                          */
/* =========================================================  FEAMH  ========================================================= */
 #define R_FACI_LP_FEAMH_FEAM_Pos           (0UL)      /*!< FEAM (Bit 0)                                          */
 #define R_FACI_LP_FEAMH_FEAM_Msk           (0xffffUL) /*!< FEAM (Bitfield-Mask: 0xffff)                          */
/* ========================================================  FSTATR2  ======================================================== */
 #define R_FACI_LP_FSTATR2_EILGLERR_Pos     (5UL)      /*!< EILGLERR (Bit 5)                                      */
 #define R_FACI_LP_FSTATR2_EILGLERR_Msk     (0x20UL)   /*!< EILGLERR (Bitfield-Mask: 0x01)                        */
 #define R_FACI_LP_FSTATR2_ILGLERR_Pos      (4UL)      /*!< ILGLERR (Bit 4)                                       */
 #define R_FACI_LP_FSTATR2_ILGLERR_Msk      (0x10UL)   /*!< ILGLERR (Bitfield-Mask: 0x01)                         */
 #define R_FACI_LP_FSTATR2_BCERR_Pos        (3UL)      /*!< BCERR (Bit 3)                                         */
 #define R_FACI_LP_FSTATR2_BCERR_Msk        (0x8UL)    /*!< BCERR (Bitfield-Mask: 0x01)                           */
 #define R_FACI_LP_FSTATR2_PRGERR01_Pos     (2UL)      /*!< PRGERR01 (Bit 2)                                      */
 #define R_FACI_LP_FSTATR2_PRGERR01_Msk     (0x4UL)    /*!< PRGERR01 (Bitfield-Mask: 0x01)                        */
 #define R_FACI_LP_FSTATR2_PRGERR1_Pos      (1UL)      /*!< PRGERR1 (Bit 1)                                       */
 #define R_FACI_LP_FSTATR2_PRGERR1_Msk      (0x2UL)    /*!< PRGERR1 (Bitfield-Mask: 0x01)                         */
 #define R_FACI_LP_FSTATR2_ERERR_Pos        (0UL)      /*!< ERERR (Bit 0)                                         */
 #define R_FACI_LP_FSTATR2_ERERR_Msk        (0x1UL)    /*!< ERERR (Bitfield-Mask: 0x01)                           */
/* ========================================================  FCTLFR  ========================================================= */
 #define R_FACI_LP_FCTLFR_BANKSWP_Pos       (0UL)      /*!< BANKSWP (Bit 0)                                       */
 #define R_FACI_LP_FCTLFR_BANKSWP_Msk       (0x7UL)    /*!< BANKSWP (Bitfield-Mask: 0x07)                         */
/* ======================================================  FENTRYR_MF4  ====================================================== */
/* ========================================================  FENTRYR  ======================================================== */
/* ========================================================  FLWAITR  ======================================================== */
/* =======================================================  FLDWAITR  ======================================================== */
 #define R_FACI_LP_FLDWAITR_FLDWAIT1_Pos    (0UL)      /*!< FLDWAIT1 (Bit 0)                                      */
 #define R_FACI_LP_FLDWAITR_FLDWAIT1_Msk    (0x1UL)    /*!< FLDWAIT1 (Bitfield-Mask: 0x01)                        */
/* =========================================================  PFBER  ========================================================= */
/* ========================================================  FBKPGCR  ======================================================== */
 #define R_FACI_LP_FBKPGCR_BKPGEN_Pos       (0UL)      /*!< BKPGEN (Bit 0)                                        */
 #define R_FACI_LP_FBKPGCR_BKPGEN_Msk       (0x1UL)    /*!< BKPGEN (Bitfield-Mask: 0x01)                          */
 #define R_FACI_LP_FBKPGCR_FEKEY_Pos        (8UL)      /*!< FEKEY (Bit 8)                                         */
 #define R_FACI_LP_FBKPGCR_FEKEY_Msk        (0xff00UL) /*!< FEKEY (Bitfield-Mask: 0xff)                           */
/* ========================================================  FBKSWCR  ======================================================== */
 #define R_FACI_LP_FBKSWCR_BKSWUPEN_Pos     (0UL)      /*!< BKSWUPEN (Bit 0)                                      */
 #define R_FACI_LP_FBKSWCR_BKSWUPEN_Msk     (0x1UL)    /*!< BKSWUPEN (Bitfield-Mask: 0x01)                        */
 #define R_FACI_LP_FBKSWCR_FEKEY_Pos        (8UL)      /*!< FEKEY (Bit 8)                                         */
 #define R_FACI_LP_FBKSWCR_FEKEY_Msk        (0xff00UL) /*!< FEKEY (Bitfield-Mask: 0xff)                           */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  GTWP  ========================================================== */
 #define R_GPT0_GTWP_PRKEY_Pos             (8UL)          /*!< PRKEY (Bit 8)                                         */
 #define R_GPT0_GTWP_PRKEY_Msk             (0xff00UL)     /*!< PRKEY (Bitfield-Mask: 0xff)                           */
 #define R_GPT0_GTWP_WP_Pos                (0UL)          /*!< WP (Bit 0)                                            */
 #define R_GPT0_GTWP_WP_Msk                (0x1UL)        /*!< WP (Bitfield-Mask: 0x01)                              */
 #define R_GPT0_GTWP_STRWP_Pos             (1UL)          /*!< STRWP (Bit 1)                                         */
 #define R_GPT0_GTWP_STRWP_Msk             (0x2UL)        /*!< STRWP (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTWP_STPWP_Pos             (2UL)          /*!< STPWP (Bit 2)                                         */
 #define R_GPT0_GTWP_STPWP_Msk             (0x4UL)        /*!< STPWP (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTWP_CLRWP_Pos             (3UL)          /*!< CLRWP (Bit 3)                                         */
 #define R_GPT0_GTWP_CLRWP_Msk             (0x8UL)        /*!< CLRWP (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTWP_CMNWP_Pos             (4UL)          /*!< CMNWP (Bit 4)                                         */
 #define R_GPT0_GTWP_CMNWP_Msk             (0x10UL)       /*!< CMNWP (Bitfield-Mask: 0x01)                           */
/* =========================================================  GTSTR  ========================================================= */
 #define R_GPT0_GTSTR_CSTRT_Pos            (0UL)          /*!< CSTRT (Bit 0)                                         */
 #define R_GPT0_GTSTR_CSTRT_Msk            (0x1UL)        /*!< CSTRT (Bitfield-Mask: 0x01)                           */
/* =========================================================  GTSTP  ========================================================= */
 #define R_GPT0_GTSTP_CSTOP_Pos            (0UL)          /*!< CSTOP (Bit 0)                                         */
 #define R_GPT0_GTSTP_CSTOP_Msk            (0x1UL)        /*!< CSTOP (Bitfield-Mask: 0x01)                           */
/* =========================================================  GTCLR  ========================================================= */
 #define R_GPT0_GTCLR_CCLR_Pos             (0UL)          /*!< CCLR (Bit 0)                                          */
 #define R_GPT0_GTCLR_CCLR_Msk             (0x1UL)        /*!< CCLR (Bitfield-Mask: 0x01)                            */
/* =========================================================  GTSSR  ========================================================= */
 #define R_GPT0_GTSSR_CSTRT_Pos            (31UL)         /*!< CSTRT (Bit 31)                                        */
 #define R_GPT0_GTSSR_CSTRT_Msk            (0x80000000UL) /*!< CSTRT (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSSR_SSELC_Pos            (16UL)         /*!< SSELC (Bit 16)                                        */
 #define R_GPT0_GTSSR_SSELC_Msk            (0x10000UL)    /*!< SSELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSSR_SSCBFAH_Pos          (15UL)         /*!< SSCBFAH (Bit 15)                                      */
 #define R_GPT0_GTSSR_SSCBFAH_Msk          (0x8000UL)     /*!< SSCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCBFAL_Pos          (14UL)         /*!< SSCBFAL (Bit 14)                                      */
 #define R_GPT0_GTSSR_SSCBFAL_Msk          (0x4000UL)     /*!< SSCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCBRAH_Pos          (13UL)         /*!< SSCBRAH (Bit 13)                                      */
 #define R_GPT0_GTSSR_SSCBRAH_Msk          (0x2000UL)     /*!< SSCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCBRAL_Pos          (12UL)         /*!< SSCBRAL (Bit 12)                                      */
 #define R_GPT0_GTSSR_SSCBRAL_Msk          (0x1000UL)     /*!< SSCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCAFBH_Pos          (11UL)         /*!< SSCAFBH (Bit 11)                                      */
 #define R_GPT0_GTSSR_SSCAFBH_Msk          (0x800UL)      /*!< SSCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCAFBL_Pos          (10UL)         /*!< SSCAFBL (Bit 10)                                      */
 #define R_GPT0_GTSSR_SSCAFBL_Msk          (0x400UL)      /*!< SSCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCARBH_Pos          (9UL)          /*!< SSCARBH (Bit 9)                                       */
 #define R_GPT0_GTSSR_SSCARBH_Msk          (0x200UL)      /*!< SSCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSCARBL_Pos          (8UL)          /*!< SSCARBL (Bit 8)                                       */
 #define R_GPT0_GTSSR_SSCARBL_Msk          (0x100UL)      /*!< SSCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSGTRGF_Pos          (1UL)          /*!< SSGTRGF (Bit 1)                                       */
 #define R_GPT0_GTSSR_SSGTRGF_Msk          (0x2UL)        /*!< SSGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSSR_SSGTRGR_Pos          (0UL)          /*!< SSGTRGR (Bit 0)                                       */
 #define R_GPT0_GTSSR_SSGTRGR_Msk          (0x1UL)        /*!< SSGTRGR (Bitfield-Mask: 0x01)                         */
/* =========================================================  GTPSR  ========================================================= */
 #define R_GPT0_GTPSR_CSTOP_Pos            (31UL)         /*!< CSTOP (Bit 31)                                        */
 #define R_GPT0_GTPSR_CSTOP_Msk            (0x80000000UL) /*!< CSTOP (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTPSR_PSELC_Pos            (16UL)         /*!< PSELC (Bit 16)                                        */
 #define R_GPT0_GTPSR_PSELC_Msk            (0x10000UL)    /*!< PSELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTPSR_PSCBFAH_Pos          (15UL)         /*!< PSCBFAH (Bit 15)                                      */
 #define R_GPT0_GTPSR_PSCBFAH_Msk          (0x8000UL)     /*!< PSCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCBFAL_Pos          (14UL)         /*!< PSCBFAL (Bit 14)                                      */
 #define R_GPT0_GTPSR_PSCBFAL_Msk          (0x4000UL)     /*!< PSCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCBRAH_Pos          (13UL)         /*!< PSCBRAH (Bit 13)                                      */
 #define R_GPT0_GTPSR_PSCBRAH_Msk          (0x2000UL)     /*!< PSCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCBRAL_Pos          (12UL)         /*!< PSCBRAL (Bit 12)                                      */
 #define R_GPT0_GTPSR_PSCBRAL_Msk          (0x1000UL)     /*!< PSCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCAFBH_Pos          (11UL)         /*!< PSCAFBH (Bit 11)                                      */
 #define R_GPT0_GTPSR_PSCAFBH_Msk          (0x800UL)      /*!< PSCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCAFBL_Pos          (10UL)         /*!< PSCAFBL (Bit 10)                                      */
 #define R_GPT0_GTPSR_PSCAFBL_Msk          (0x400UL)      /*!< PSCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCARBH_Pos          (9UL)          /*!< PSCARBH (Bit 9)                                       */
 #define R_GPT0_GTPSR_PSCARBH_Msk          (0x200UL)      /*!< PSCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSCARBL_Pos          (8UL)          /*!< PSCARBL (Bit 8)                                       */
 #define R_GPT0_GTPSR_PSCARBL_Msk          (0x100UL)      /*!< PSCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSGTRGF_Pos          (1UL)          /*!< PSGTRGF (Bit 1)                                       */
 #define R_GPT0_GTPSR_PSGTRGF_Msk          (0x2UL)        /*!< PSGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTPSR_PSGTRGR_Pos          (0UL)          /*!< PSGTRGR (Bit 0)                                       */
 #define R_GPT0_GTPSR_PSGTRGR_Msk          (0x1UL)        /*!< PSGTRGR (Bitfield-Mask: 0x01)                         */
/* =========================================================  GTCSR  ========================================================= */
 #define R_GPT0_GTCSR_CCLR_Pos             (31UL)         /*!< CCLR (Bit 31)                                         */
 #define R_GPT0_GTCSR_CCLR_Msk             (0x80000000UL) /*!< CCLR (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTCSR_CP1CCE_Pos           (27UL)         /*!< CP1CCE (Bit 27)                                       */
 #define R_GPT0_GTCSR_CP1CCE_Msk           (0x8000000UL)  /*!< CP1CCE (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTCSR_CSCMSC_Pos           (24UL)         /*!< CSCMSC (Bit 24)                                       */
 #define R_GPT0_GTCSR_CSCMSC_Msk           (0x7000000UL)  /*!< CSCMSC (Bitfield-Mask: 0x07)                          */
 #define R_GPT0_GTCSR_CSELC_Pos            (16UL)         /*!< CSELC (Bit 16)                                        */
 #define R_GPT0_GTCSR_CSELC_Msk            (0x10000UL)    /*!< CSELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTCSR_CSCBFAH_Pos          (15UL)         /*!< CSCBFAH (Bit 15)                                      */
 #define R_GPT0_GTCSR_CSCBFAH_Msk          (0x8000UL)     /*!< CSCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCBFAL_Pos          (14UL)         /*!< CSCBFAL (Bit 14)                                      */
 #define R_GPT0_GTCSR_CSCBFAL_Msk          (0x4000UL)     /*!< CSCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCBRAH_Pos          (13UL)         /*!< CSCBRAH (Bit 13)                                      */
 #define R_GPT0_GTCSR_CSCBRAH_Msk          (0x2000UL)     /*!< CSCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCBRAL_Pos          (12UL)         /*!< CSCBRAL (Bit 12)                                      */
 #define R_GPT0_GTCSR_CSCBRAL_Msk          (0x1000UL)     /*!< CSCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCAFBH_Pos          (11UL)         /*!< CSCAFBH (Bit 11)                                      */
 #define R_GPT0_GTCSR_CSCAFBH_Msk          (0x800UL)      /*!< CSCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCAFBL_Pos          (10UL)         /*!< CSCAFBL (Bit 10)                                      */
 #define R_GPT0_GTCSR_CSCAFBL_Msk          (0x400UL)      /*!< CSCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCARBH_Pos          (9UL)          /*!< CSCARBH (Bit 9)                                       */
 #define R_GPT0_GTCSR_CSCARBH_Msk          (0x200UL)      /*!< CSCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSCARBL_Pos          (8UL)          /*!< CSCARBL (Bit 8)                                       */
 #define R_GPT0_GTCSR_CSCARBL_Msk          (0x100UL)      /*!< CSCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSGTRGF_Pos          (1UL)          /*!< CSGTRGF (Bit 1)                                       */
 #define R_GPT0_GTCSR_CSGTRGF_Msk          (0x2UL)        /*!< CSGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCSR_CSGTRGR_Pos          (0UL)          /*!< CSGTRGR (Bit 0)                                       */
 #define R_GPT0_GTCSR_CSGTRGR_Msk          (0x1UL)        /*!< CSGTRGR (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTUPSR  ========================================================= */
 #define R_GPT0_GTUPSR_USILVL_Pos          (24UL)         /*!< USILVL (Bit 24)                                       */
 #define R_GPT0_GTUPSR_USILVL_Msk          (0xf000000UL)  /*!< USILVL (Bitfield-Mask: 0x0f)                          */
 #define R_GPT0_GTUPSR_USELC_Pos           (16UL)         /*!< USELC (Bit 16)                                        */
 #define R_GPT0_GTUPSR_USELC_Msk           (0x10000UL)    /*!< USELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTUPSR_USCBFAH_Pos         (15UL)         /*!< USCBFAH (Bit 15)                                      */
 #define R_GPT0_GTUPSR_USCBFAH_Msk         (0x8000UL)     /*!< USCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCBFAL_Pos         (14UL)         /*!< USCBFAL (Bit 14)                                      */
 #define R_GPT0_GTUPSR_USCBFAL_Msk         (0x4000UL)     /*!< USCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCBRAH_Pos         (13UL)         /*!< USCBRAH (Bit 13)                                      */
 #define R_GPT0_GTUPSR_USCBRAH_Msk         (0x2000UL)     /*!< USCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCBRAL_Pos         (12UL)         /*!< USCBRAL (Bit 12)                                      */
 #define R_GPT0_GTUPSR_USCBRAL_Msk         (0x1000UL)     /*!< USCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCAFBH_Pos         (11UL)         /*!< USCAFBH (Bit 11)                                      */
 #define R_GPT0_GTUPSR_USCAFBH_Msk         (0x800UL)      /*!< USCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCAFBL_Pos         (10UL)         /*!< USCAFBL (Bit 10)                                      */
 #define R_GPT0_GTUPSR_USCAFBL_Msk         (0x400UL)      /*!< USCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCARBH_Pos         (9UL)          /*!< USCARBH (Bit 9)                                       */
 #define R_GPT0_GTUPSR_USCARBH_Msk         (0x200UL)      /*!< USCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USCARBL_Pos         (8UL)          /*!< USCARBL (Bit 8)                                       */
 #define R_GPT0_GTUPSR_USCARBL_Msk         (0x100UL)      /*!< USCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USGTRGF_Pos         (1UL)          /*!< USGTRGF (Bit 1)                                       */
 #define R_GPT0_GTUPSR_USGTRGF_Msk         (0x2UL)        /*!< USGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTUPSR_USGTRGR_Pos         (0UL)          /*!< USGTRGR (Bit 0)                                       */
 #define R_GPT0_GTUPSR_USGTRGR_Msk         (0x1UL)        /*!< USGTRGR (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTDNSR  ========================================================= */
 #define R_GPT0_GTDNSR_DSILVL_Pos          (24UL)         /*!< DSILVL (Bit 24)                                       */
 #define R_GPT0_GTDNSR_DSILVL_Msk          (0xf000000UL)  /*!< DSILVL (Bitfield-Mask: 0x0f)                          */
 #define R_GPT0_GTDNSR_DSELC_Pos           (16UL)         /*!< DSELC (Bit 16)                                        */
 #define R_GPT0_GTDNSR_DSELC_Msk           (0x10000UL)    /*!< DSELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTDNSR_DSCBFAH_Pos         (15UL)         /*!< DSCBFAH (Bit 15)                                      */
 #define R_GPT0_GTDNSR_DSCBFAH_Msk         (0x8000UL)     /*!< DSCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCBFAL_Pos         (14UL)         /*!< DSCBFAL (Bit 14)                                      */
 #define R_GPT0_GTDNSR_DSCBFAL_Msk         (0x4000UL)     /*!< DSCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCBRAH_Pos         (13UL)         /*!< DSCBRAH (Bit 13)                                      */
 #define R_GPT0_GTDNSR_DSCBRAH_Msk         (0x2000UL)     /*!< DSCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCBRAL_Pos         (12UL)         /*!< DSCBRAL (Bit 12)                                      */
 #define R_GPT0_GTDNSR_DSCBRAL_Msk         (0x1000UL)     /*!< DSCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCAFBH_Pos         (11UL)         /*!< DSCAFBH (Bit 11)                                      */
 #define R_GPT0_GTDNSR_DSCAFBH_Msk         (0x800UL)      /*!< DSCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCAFBL_Pos         (10UL)         /*!< DSCAFBL (Bit 10)                                      */
 #define R_GPT0_GTDNSR_DSCAFBL_Msk         (0x400UL)      /*!< DSCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCARBH_Pos         (9UL)          /*!< DSCARBH (Bit 9)                                       */
 #define R_GPT0_GTDNSR_DSCARBH_Msk         (0x200UL)      /*!< DSCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSCARBL_Pos         (8UL)          /*!< DSCARBL (Bit 8)                                       */
 #define R_GPT0_GTDNSR_DSCARBL_Msk         (0x100UL)      /*!< DSCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSGTRGF_Pos         (1UL)          /*!< DSGTRGF (Bit 1)                                       */
 #define R_GPT0_GTDNSR_DSGTRGF_Msk         (0x2UL)        /*!< DSGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTDNSR_DSGTRGR_Pos         (0UL)          /*!< DSGTRGR (Bit 0)                                       */
 #define R_GPT0_GTDNSR_DSGTRGR_Msk         (0x1UL)        /*!< DSGTRGR (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTICASR  ======================================================== */
 #define R_GPT0_GTICASR_ASELC_Pos          (16UL)         /*!< ASELC (Bit 16)                                        */
 #define R_GPT0_GTICASR_ASELC_Msk          (0x10000UL)    /*!< ASELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICASR_ASCBFAH_Pos        (15UL)         /*!< ASCBFAH (Bit 15)                                      */
 #define R_GPT0_GTICASR_ASCBFAH_Msk        (0x8000UL)     /*!< ASCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCBFAL_Pos        (14UL)         /*!< ASCBFAL (Bit 14)                                      */
 #define R_GPT0_GTICASR_ASCBFAL_Msk        (0x4000UL)     /*!< ASCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCBRAH_Pos        (13UL)         /*!< ASCBRAH (Bit 13)                                      */
 #define R_GPT0_GTICASR_ASCBRAH_Msk        (0x2000UL)     /*!< ASCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCBRAL_Pos        (12UL)         /*!< ASCBRAL (Bit 12)                                      */
 #define R_GPT0_GTICASR_ASCBRAL_Msk        (0x1000UL)     /*!< ASCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCAFBH_Pos        (11UL)         /*!< ASCAFBH (Bit 11)                                      */
 #define R_GPT0_GTICASR_ASCAFBH_Msk        (0x800UL)      /*!< ASCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCAFBL_Pos        (10UL)         /*!< ASCAFBL (Bit 10)                                      */
 #define R_GPT0_GTICASR_ASCAFBL_Msk        (0x400UL)      /*!< ASCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCARBH_Pos        (9UL)          /*!< ASCARBH (Bit 9)                                       */
 #define R_GPT0_GTICASR_ASCARBH_Msk        (0x200UL)      /*!< ASCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASCARBL_Pos        (8UL)          /*!< ASCARBL (Bit 8)                                       */
 #define R_GPT0_GTICASR_ASCARBL_Msk        (0x100UL)      /*!< ASCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASGTRGF_Pos        (1UL)          /*!< ASGTRGF (Bit 1)                                       */
 #define R_GPT0_GTICASR_ASGTRGF_Msk        (0x2UL)        /*!< ASGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICASR_ASGTRGR_Pos        (0UL)          /*!< ASGTRGR (Bit 0)                                       */
 #define R_GPT0_GTICASR_ASGTRGR_Msk        (0x1UL)        /*!< ASGTRGR (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTICBSR  ======================================================== */
 #define R_GPT0_GTICBSR_BSELC_Pos          (16UL)         /*!< BSELC (Bit 16)                                        */
 #define R_GPT0_GTICBSR_BSELC_Msk          (0x10000UL)    /*!< BSELC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICBSR_BSCBFAH_Pos        (15UL)         /*!< BSCBFAH (Bit 15)                                      */
 #define R_GPT0_GTICBSR_BSCBFAH_Msk        (0x8000UL)     /*!< BSCBFAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCBFAL_Pos        (14UL)         /*!< BSCBFAL (Bit 14)                                      */
 #define R_GPT0_GTICBSR_BSCBFAL_Msk        (0x4000UL)     /*!< BSCBFAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCBRAH_Pos        (13UL)         /*!< BSCBRAH (Bit 13)                                      */
 #define R_GPT0_GTICBSR_BSCBRAH_Msk        (0x2000UL)     /*!< BSCBRAH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCBRAL_Pos        (12UL)         /*!< BSCBRAL (Bit 12)                                      */
 #define R_GPT0_GTICBSR_BSCBRAL_Msk        (0x1000UL)     /*!< BSCBRAL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCAFBH_Pos        (11UL)         /*!< BSCAFBH (Bit 11)                                      */
 #define R_GPT0_GTICBSR_BSCAFBH_Msk        (0x800UL)      /*!< BSCAFBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCAFBL_Pos        (10UL)         /*!< BSCAFBL (Bit 10)                                      */
 #define R_GPT0_GTICBSR_BSCAFBL_Msk        (0x400UL)      /*!< BSCAFBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCARBH_Pos        (9UL)          /*!< BSCARBH (Bit 9)                                       */
 #define R_GPT0_GTICBSR_BSCARBH_Msk        (0x200UL)      /*!< BSCARBH (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSCARBL_Pos        (8UL)          /*!< BSCARBL (Bit 8)                                       */
 #define R_GPT0_GTICBSR_BSCARBL_Msk        (0x100UL)      /*!< BSCARBL (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSGTRGF_Pos        (1UL)          /*!< BSGTRGF (Bit 1)                                       */
 #define R_GPT0_GTICBSR_BSGTRGF_Msk        (0x2UL)        /*!< BSGTRGF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTICBSR_BSGTRGR_Pos        (0UL)          /*!< BSGTRGR (Bit 0)                                       */
 #define R_GPT0_GTICBSR_BSGTRGR_Msk        (0x1UL)        /*!< BSGTRGR (Bitfield-Mask: 0x01)                         */
/* =========================================================  GTCR  ========================================================== */
 #define R_GPT0_GTCR_CKEG_Pos              (27UL)         /*!< CKEG (Bit 27)                                         */
 #define R_GPT0_GTCR_CKEG_Msk              (0x18000000UL) /*!< CKEG (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTCR_TPCS_Pos              (24UL)         /*!< TPCS (Bit 24)                                         */
 #define R_GPT0_GTCR_TPCS_Msk              (0x7000000UL)  /*!< TPCS (Bitfield-Mask: 0x07)                            */
 #define R_GPT0_GTCR_MD_Pos                (16UL)         /*!< MD (Bit 16)                                           */
 #define R_GPT0_GTCR_MD_Msk                (0xf0000UL)    /*!< MD (Bitfield-Mask: 0x0f)                              */
 #define R_GPT0_GTCR_SSCEN_Pos             (15UL)         /*!< SSCEN (Bit 15)                                        */
 #define R_GPT0_GTCR_SSCEN_Msk             (0x8000UL)     /*!< SSCEN (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTCR_CPSCD_Pos             (12UL)         /*!< CPSCD (Bit 12)                                        */
 #define R_GPT0_GTCR_CPSCD_Msk             (0x1000UL)     /*!< CPSCD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTCR_SSCGRP_Pos            (10UL)         /*!< SSCGRP (Bit 10)                                       */
 #define R_GPT0_GTCR_SSCGRP_Msk            (0xc00UL)      /*!< SSCGRP (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTCR_SCGTIOC_Pos           (9UL)          /*!< SCGTIOC (Bit 9)                                       */
 #define R_GPT0_GTCR_SCGTIOC_Msk           (0x200UL)      /*!< SCGTIOC (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTCR_ICDS_Pos              (8UL)          /*!< ICDS (Bit 8)                                          */
 #define R_GPT0_GTCR_ICDS_Msk              (0x100UL)      /*!< ICDS (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTCR_CST_Pos               (0UL)          /*!< CST (Bit 0)                                           */
 #define R_GPT0_GTCR_CST_Msk               (0x1UL)        /*!< CST (Bitfield-Mask: 0x01)                             */
/* =======================================================  GTUDDTYC  ======================================================== */
 #define R_GPT0_GTUDDTYC_OBDTYR_Pos        (27UL)         /*!< OBDTYR (Bit 27)                                       */
 #define R_GPT0_GTUDDTYC_OBDTYR_Msk        (0x8000000UL)  /*!< OBDTYR (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTUDDTYC_OBDTYF_Pos        (26UL)         /*!< OBDTYF (Bit 26)                                       */
 #define R_GPT0_GTUDDTYC_OBDTYF_Msk        (0x4000000UL)  /*!< OBDTYF (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTUDDTYC_OBDTY_Pos         (24UL)         /*!< OBDTY (Bit 24)                                        */
 #define R_GPT0_GTUDDTYC_OBDTY_Msk         (0x3000000UL)  /*!< OBDTY (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTUDDTYC_OADTYR_Pos        (19UL)         /*!< OADTYR (Bit 19)                                       */
 #define R_GPT0_GTUDDTYC_OADTYR_Msk        (0x80000UL)    /*!< OADTYR (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTUDDTYC_OADTYF_Pos        (18UL)         /*!< OADTYF (Bit 18)                                       */
 #define R_GPT0_GTUDDTYC_OADTYF_Msk        (0x40000UL)    /*!< OADTYF (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTUDDTYC_OADTY_Pos         (16UL)         /*!< OADTY (Bit 16)                                        */
 #define R_GPT0_GTUDDTYC_OADTY_Msk         (0x30000UL)    /*!< OADTY (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTUDDTYC_UDF_Pos           (1UL)          /*!< UDF (Bit 1)                                           */
 #define R_GPT0_GTUDDTYC_UDF_Msk           (0x2UL)        /*!< UDF (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTUDDTYC_UD_Pos            (0UL)          /*!< UD (Bit 0)                                            */
 #define R_GPT0_GTUDDTYC_UD_Msk            (0x1UL)        /*!< UD (Bitfield-Mask: 0x01)                              */
/* =========================================================  GTIOR  ========================================================= */
 #define R_GPT0_GTIOR_NFCSB_Pos            (30UL)         /*!< NFCSB (Bit 30)                                        */
 #define R_GPT0_GTIOR_NFCSB_Msk            (0xc0000000UL) /*!< NFCSB (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTIOR_NFBEN_Pos            (29UL)         /*!< NFBEN (Bit 29)                                        */
 #define R_GPT0_GTIOR_NFBEN_Msk            (0x20000000UL) /*!< NFBEN (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTIOR_OBEOCD_Pos           (27UL)         /*!< OBEOCD (Bit 27)                                       */
 #define R_GPT0_GTIOR_OBEOCD_Msk           (0x8000000UL)  /*!< OBEOCD (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTIOR_OBDF_Pos             (25UL)         /*!< OBDF (Bit 25)                                         */
 #define R_GPT0_GTIOR_OBDF_Msk             (0x6000000UL)  /*!< OBDF (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTIOR_OBE_Pos              (24UL)         /*!< OBE (Bit 24)                                          */
 #define R_GPT0_GTIOR_OBE_Msk              (0x1000000UL)  /*!< OBE (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTIOR_OBHLD_Pos            (23UL)         /*!< OBHLD (Bit 23)                                        */
 #define R_GPT0_GTIOR_OBHLD_Msk            (0x800000UL)   /*!< OBHLD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTIOR_OBDFLT_Pos           (22UL)         /*!< OBDFLT (Bit 22)                                       */
 #define R_GPT0_GTIOR_OBDFLT_Msk           (0x400000UL)   /*!< OBDFLT (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTIOR_GTIOB_Pos            (16UL)         /*!< GTIOB (Bit 16)                                        */
 #define R_GPT0_GTIOR_GTIOB_Msk            (0x1f0000UL)   /*!< GTIOB (Bitfield-Mask: 0x1f)                           */
 #define R_GPT0_GTIOR_NFCSA_Pos            (14UL)         /*!< NFCSA (Bit 14)                                        */
 #define R_GPT0_GTIOR_NFCSA_Msk            (0xc000UL)     /*!< NFCSA (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTIOR_NFAEN_Pos            (13UL)         /*!< NFAEN (Bit 13)                                        */
 #define R_GPT0_GTIOR_NFAEN_Msk            (0x2000UL)     /*!< NFAEN (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTIOR_PSYE_Pos             (12UL)         /*!< PSYE (Bit 12)                                         */
 #define R_GPT0_GTIOR_PSYE_Msk             (0x1000UL)     /*!< PSYE (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTIOR_OAEOCD_Pos           (11UL)         /*!< OAEOCD (Bit 11)                                       */
 #define R_GPT0_GTIOR_OAEOCD_Msk           (0x800UL)      /*!< OAEOCD (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTIOR_OADF_Pos             (9UL)          /*!< OADF (Bit 9)                                          */
 #define R_GPT0_GTIOR_OADF_Msk             (0x600UL)      /*!< OADF (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTIOR_OAE_Pos              (8UL)          /*!< OAE (Bit 8)                                           */
 #define R_GPT0_GTIOR_OAE_Msk              (0x100UL)      /*!< OAE (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTIOR_OAHLD_Pos            (7UL)          /*!< OAHLD (Bit 7)                                         */
 #define R_GPT0_GTIOR_OAHLD_Msk            (0x80UL)       /*!< OAHLD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTIOR_OADFLT_Pos           (6UL)          /*!< OADFLT (Bit 6)                                        */
 #define R_GPT0_GTIOR_OADFLT_Msk           (0x40UL)       /*!< OADFLT (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTIOR_CPSCIR_Pos           (5UL)          /*!< CPSCIR (Bit 5)                                        */
 #define R_GPT0_GTIOR_CPSCIR_Msk           (0x20UL)       /*!< CPSCIR (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTIOR_GTIOA_Pos            (0UL)          /*!< GTIOA (Bit 0)                                         */
 #define R_GPT0_GTIOR_GTIOA_Msk            (0x1fUL)       /*!< GTIOA (Bitfield-Mask: 0x1f)                           */
/* ========================================================  GTINTAD  ======================================================== */
 #define R_GPT0_GTINTAD_GTINTPC_Pos        (31UL)         /*!< GTINTPC (Bit 31)                                      */
 #define R_GPT0_GTINTAD_GTINTPC_Msk        (0x80000000UL) /*!< GTINTPC (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTINTAD_GRPABL_Pos         (30UL)         /*!< GRPABL (Bit 30)                                       */
 #define R_GPT0_GTINTAD_GRPABL_Msk         (0x40000000UL) /*!< GRPABL (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTINTAD_GRPABH_Pos         (29UL)         /*!< GRPABH (Bit 29)                                       */
 #define R_GPT0_GTINTAD_GRPABH_Msk         (0x20000000UL) /*!< GRPABH (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTINTAD_GRPDTE_Pos         (28UL)         /*!< GRPDTE (Bit 28)                                       */
 #define R_GPT0_GTINTAD_GRPDTE_Msk         (0x10000000UL) /*!< GRPDTE (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTINTAD_GRP_Pos            (24UL)         /*!< GRP (Bit 24)                                          */
 #define R_GPT0_GTINTAD_GRP_Msk            (0x3000000UL)  /*!< GRP (Bitfield-Mask: 0x03)                             */
 #define R_GPT0_GTINTAD_ADTRDEN_Pos        (17UL)         /*!< ADTRDEN (Bit 17)                                      */
 #define R_GPT0_GTINTAD_ADTRDEN_Msk        (0x20000UL)    /*!< ADTRDEN (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTINTAD_ADTRUEN_Pos        (16UL)         /*!< ADTRUEN (Bit 16)                                      */
 #define R_GPT0_GTINTAD_ADTRUEN_Msk        (0x10000UL)    /*!< ADTRUEN (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTINTAD_SCFPU_Pos          (15UL)         /*!< SCFPU (Bit 15)                                        */
 #define R_GPT0_GTINTAD_SCFPU_Msk          (0x8000UL)     /*!< SCFPU (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTINTAD_SCFPO_Pos          (14UL)         /*!< SCFPO (Bit 14)                                        */
 #define R_GPT0_GTINTAD_SCFPO_Msk          (0x4000UL)     /*!< SCFPO (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTINTAD_SCF_Pos            (8UL)          /*!< SCF (Bit 8)                                           */
 #define R_GPT0_GTINTAD_SCF_Msk            (0x100UL)      /*!< SCF (Bitfield-Mask: 0x01)                             */
/* =========================================================  GTST  ========================================================== */
 #define R_GPT0_GTST_OABLF_Pos             (30UL)         /*!< OABLF (Bit 30)                                        */
 #define R_GPT0_GTST_OABLF_Msk             (0x40000000UL) /*!< OABLF (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTST_OABHF_Pos             (29UL)         /*!< OABHF (Bit 29)                                        */
 #define R_GPT0_GTST_OABHF_Msk             (0x20000000UL) /*!< OABHF (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTST_DTEF_Pos              (28UL)         /*!< DTEF (Bit 28)                                         */
 #define R_GPT0_GTST_DTEF_Msk              (0x10000000UL) /*!< DTEF (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_ODF_Pos               (24UL)         /*!< ODF (Bit 24)                                          */
 #define R_GPT0_GTST_ODF_Msk               (0x1000000UL)  /*!< ODF (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTST_ADTRBDF_Pos           (19UL)         /*!< ADTRBDF (Bit 19)                                      */
 #define R_GPT0_GTST_ADTRBDF_Msk           (0x80000UL)    /*!< ADTRBDF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTST_ADTRBUF_Pos           (18UL)         /*!< ADTRBUF (Bit 18)                                      */
 #define R_GPT0_GTST_ADTRBUF_Msk           (0x40000UL)    /*!< ADTRBUF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTST_ADTRADF_Pos           (17UL)         /*!< ADTRADF (Bit 17)                                      */
 #define R_GPT0_GTST_ADTRADF_Msk           (0x20000UL)    /*!< ADTRADF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTST_ADTRAUF_Pos           (16UL)         /*!< ADTRAUF (Bit 16)                                      */
 #define R_GPT0_GTST_ADTRAUF_Msk           (0x10000UL)    /*!< ADTRAUF (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTST_TUCF_Pos              (15UL)         /*!< TUCF (Bit 15)                                         */
 #define R_GPT0_GTST_TUCF_Msk              (0x8000UL)     /*!< TUCF (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_ITCNT_Pos             (8UL)          /*!< ITCNT (Bit 8)                                         */
 #define R_GPT0_GTST_ITCNT_Msk             (0x700UL)      /*!< ITCNT (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTST_TCFPU_Pos             (7UL)          /*!< TCFPU (Bit 7)                                         */
 #define R_GPT0_GTST_TCFPU_Msk             (0x80UL)       /*!< TCFPU (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTST_TCFPO_Pos             (6UL)          /*!< TCFPO (Bit 6)                                         */
 #define R_GPT0_GTST_TCFPO_Msk             (0x40UL)       /*!< TCFPO (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTST_TCFF_Pos              (5UL)          /*!< TCFF (Bit 5)                                          */
 #define R_GPT0_GTST_TCFF_Msk              (0x20UL)       /*!< TCFF (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_TCFE_Pos              (4UL)          /*!< TCFE (Bit 4)                                          */
 #define R_GPT0_GTST_TCFE_Msk              (0x10UL)       /*!< TCFE (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_TCFD_Pos              (3UL)          /*!< TCFD (Bit 3)                                          */
 #define R_GPT0_GTST_TCFD_Msk              (0x8UL)        /*!< TCFD (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_TCFC_Pos              (2UL)          /*!< TCFC (Bit 2)                                          */
 #define R_GPT0_GTST_TCFC_Msk              (0x4UL)        /*!< TCFC (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_TCFB_Pos              (1UL)          /*!< TCFB (Bit 1)                                          */
 #define R_GPT0_GTST_TCFB_Msk              (0x2UL)        /*!< TCFB (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_TCFA_Pos              (0UL)          /*!< TCFA (Bit 0)                                          */
 #define R_GPT0_GTST_TCFA_Msk              (0x1UL)        /*!< TCFA (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTST_PCF_Pos               (31UL)         /*!< PCF (Bit 31)                                          */
 #define R_GPT0_GTST_PCF_Msk               (0x80000000UL) /*!< PCF (Bitfield-Mask: 0x01)                             */
/* =========================================================  GTBER  ========================================================= */
 #define R_GPT0_GTBER_ADTDB_Pos            (30UL)         /*!< ADTDB (Bit 30)                                        */
 #define R_GPT0_GTBER_ADTDB_Msk            (0x40000000UL) /*!< ADTDB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER_ADTTB_Pos            (28UL)         /*!< ADTTB (Bit 28)                                        */
 #define R_GPT0_GTBER_ADTTB_Msk            (0x30000000UL) /*!< ADTTB (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTBER_ADTDA_Pos            (26UL)         /*!< ADTDA (Bit 26)                                        */
 #define R_GPT0_GTBER_ADTDA_Msk            (0x4000000UL)  /*!< ADTDA (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER_ADTTA_Pos            (24UL)         /*!< ADTTA (Bit 24)                                        */
 #define R_GPT0_GTBER_ADTTA_Msk            (0x3000000UL)  /*!< ADTTA (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTBER_CCRSWT_Pos           (22UL)         /*!< CCRSWT (Bit 22)                                       */
 #define R_GPT0_GTBER_CCRSWT_Msk           (0x400000UL)   /*!< CCRSWT (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER_PR_Pos               (20UL)         /*!< PR (Bit 20)                                           */
 #define R_GPT0_GTBER_PR_Msk               (0x300000UL)   /*!< PR (Bitfield-Mask: 0x03)                              */
 #define R_GPT0_GTBER_CCRB_Pos             (18UL)         /*!< CCRB (Bit 18)                                         */
 #define R_GPT0_GTBER_CCRB_Msk             (0xc0000UL)    /*!< CCRB (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTBER_CCRA_Pos             (16UL)         /*!< CCRA (Bit 16)                                         */
 #define R_GPT0_GTBER_CCRA_Msk             (0x30000UL)    /*!< CCRA (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTBER_DBRTEC_Pos           (8UL)          /*!< DBRTEC (Bit 8)                                        */
 #define R_GPT0_GTBER_DBRTEC_Msk           (0x100UL)      /*!< DBRTEC (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER_BD3_Pos              (3UL)          /*!< BD3 (Bit 3)                                           */
 #define R_GPT0_GTBER_BD3_Msk              (0x8UL)        /*!< BD3 (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTBER_BD2_Pos              (2UL)          /*!< BD2 (Bit 2)                                           */
 #define R_GPT0_GTBER_BD2_Msk              (0x4UL)        /*!< BD2 (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTBER_BD1_Pos              (1UL)          /*!< BD1 (Bit 1)                                           */
 #define R_GPT0_GTBER_BD1_Msk              (0x2UL)        /*!< BD1 (Bitfield-Mask: 0x01)                             */
 #define R_GPT0_GTBER_BD0_Pos              (0UL)          /*!< BD0 (Bit 0)                                           */
 #define R_GPT0_GTBER_BD0_Msk              (0x1UL)        /*!< BD0 (Bitfield-Mask: 0x01)                             */
/* =========================================================  GTITC  ========================================================= */
 #define R_GPT0_GTITC_ADTBL_Pos            (14UL)         /*!< ADTBL (Bit 14)                                        */
 #define R_GPT0_GTITC_ADTBL_Msk            (0x4000UL)     /*!< ADTBL (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTITC_ADTAL_Pos            (12UL)         /*!< ADTAL (Bit 12)                                        */
 #define R_GPT0_GTITC_ADTAL_Msk            (0x1000UL)     /*!< ADTAL (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTITC_IVTT_Pos             (8UL)          /*!< IVTT (Bit 8)                                          */
 #define R_GPT0_GTITC_IVTT_Msk             (0x700UL)      /*!< IVTT (Bitfield-Mask: 0x07)                            */
 #define R_GPT0_GTITC_IVTC_Pos             (6UL)          /*!< IVTC (Bit 6)                                          */
 #define R_GPT0_GTITC_IVTC_Msk             (0xc0UL)       /*!< IVTC (Bitfield-Mask: 0x03)                            */
 #define R_GPT0_GTITC_ITLF_Pos             (5UL)          /*!< ITLF (Bit 5)                                          */
 #define R_GPT0_GTITC_ITLF_Msk             (0x20UL)       /*!< ITLF (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTITC_ITLE_Pos             (4UL)          /*!< ITLE (Bit 4)                                          */
 #define R_GPT0_GTITC_ITLE_Msk             (0x10UL)       /*!< ITLE (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTITC_ITLD_Pos             (3UL)          /*!< ITLD (Bit 3)                                          */
 #define R_GPT0_GTITC_ITLD_Msk             (0x8UL)        /*!< ITLD (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTITC_ITLC_Pos             (2UL)          /*!< ITLC (Bit 2)                                          */
 #define R_GPT0_GTITC_ITLC_Msk             (0x4UL)        /*!< ITLC (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTITC_ITLB_Pos             (1UL)          /*!< ITLB (Bit 1)                                          */
 #define R_GPT0_GTITC_ITLB_Msk             (0x2UL)        /*!< ITLB (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTITC_ITLA_Pos             (0UL)          /*!< ITLA (Bit 0)                                          */
 #define R_GPT0_GTITC_ITLA_Msk             (0x1UL)        /*!< ITLA (Bitfield-Mask: 0x01)                            */
/* =========================================================  GTCNT  ========================================================= */
 #define R_GPT0_GTCNT_GTCNT_Pos            (0UL)          /*!< GTCNT (Bit 0)                                         */
 #define R_GPT0_GTCNT_GTCNT_Msk            (0xffffffffUL) /*!< GTCNT (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTCCR  ========================================================= */
 #define R_GPT0_GTCCR_GTCCR_Pos            (0UL)          /*!< GTCCR (Bit 0)                                         */
 #define R_GPT0_GTCCR_GTCCR_Msk            (0xffffffffUL) /*!< GTCCR (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTPR  ========================================================== */
 #define R_GPT0_GTPR_GTPR_Pos              (0UL)          /*!< GTPR (Bit 0)                                          */
 #define R_GPT0_GTPR_GTPR_Msk              (0xffffffffUL) /*!< GTPR (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  GTPBR  ========================================================= */
 #define R_GPT0_GTPBR_GTPBR_Pos            (0UL)          /*!< GTPBR (Bit 0)                                         */
 #define R_GPT0_GTPBR_GTPBR_Msk            (0xffffffffUL) /*!< GTPBR (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  GTPDBR  ========================================================= */
 #define R_GPT0_GTPDBR_GTPDBR_Pos          (0UL)          /*!< GTPDBR (Bit 0)                                        */
 #define R_GPT0_GTPDBR_GTPDBR_Msk          (0xffffffffUL) /*!< GTPDBR (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  GTADTRA  ======================================================== */
 #define R_GPT0_GTADTRA_GTADTRA_Pos        (0UL)          /*!< GTADTRA (Bit 0)                                       */
 #define R_GPT0_GTADTRA_GTADTRA_Msk        (0xffffffffUL) /*!< GTADTRA (Bitfield-Mask: 0xffffffff)                   */
/* ========================================================  GTADTRB  ======================================================== */
 #define R_GPT0_GTADTRB_GTADTRB_Pos        (0UL)          /*!< GTADTRB (Bit 0)                                       */
 #define R_GPT0_GTADTRB_GTADTRB_Msk        (0xffffffffUL) /*!< GTADTRB (Bitfield-Mask: 0xffffffff)                   */
/* =======================================================  GTADTBRA  ======================================================== */
 #define R_GPT0_GTADTBRA_GTADTBRA_Pos      (0UL)          /*!< GTADTBRA (Bit 0)                                      */
 #define R_GPT0_GTADTBRA_GTADTBRA_Msk      (0xffffffffUL) /*!< GTADTBRA (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  GTADTBRB  ======================================================== */
 #define R_GPT0_GTADTBRB_GTADTBRB_Pos      (0UL)          /*!< GTADTBRB (Bit 0)                                      */
 #define R_GPT0_GTADTBRB_GTADTBRB_Msk      (0xffffffffUL) /*!< GTADTBRB (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  GTADTDBRA  ======================================================= */
 #define R_GPT0_GTADTDBRA_GTADTDBRA_Pos    (0UL)          /*!< GTADTDBRA (Bit 0)                                     */
 #define R_GPT0_GTADTDBRA_GTADTDBRA_Msk    (0xffffffffUL) /*!< GTADTDBRA (Bitfield-Mask: 0xffffffff)                 */
/* =======================================================  GTADTDBRB  ======================================================= */
 #define R_GPT0_GTADTDBRB_GTADTDBRB_Pos    (0UL)          /*!< GTADTDBRB (Bit 0)                                     */
 #define R_GPT0_GTADTDBRB_GTADTDBRB_Msk    (0xffffffffUL) /*!< GTADTDBRB (Bitfield-Mask: 0xffffffff)                 */
/* ========================================================  GTDTCR  ========================================================= */
 #define R_GPT0_GTDTCR_TDFER_Pos           (8UL)          /*!< TDFER (Bit 8)                                         */
 #define R_GPT0_GTDTCR_TDFER_Msk           (0x100UL)      /*!< TDFER (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTDTCR_TDBDE_Pos           (5UL)          /*!< TDBDE (Bit 5)                                         */
 #define R_GPT0_GTDTCR_TDBDE_Msk           (0x20UL)       /*!< TDBDE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTDTCR_TDBUE_Pos           (4UL)          /*!< TDBUE (Bit 4)                                         */
 #define R_GPT0_GTDTCR_TDBUE_Msk           (0x10UL)       /*!< TDBUE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTDTCR_TDE_Pos             (0UL)          /*!< TDE (Bit 0)                                           */
 #define R_GPT0_GTDTCR_TDE_Msk             (0x1UL)        /*!< TDE (Bitfield-Mask: 0x01)                             */
/* =========================================================  GTDVU  ========================================================= */
 #define R_GPT0_GTDVU_GTDVU_Pos            (0UL)          /*!< GTDVU (Bit 0)                                         */
 #define R_GPT0_GTDVU_GTDVU_Msk            (0xffffffffUL) /*!< GTDVU (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTDVD  ========================================================= */
 #define R_GPT0_GTDVD_GTDVD_Pos            (0UL)          /*!< GTDVD (Bit 0)                                         */
 #define R_GPT0_GTDVD_GTDVD_Msk            (0xffffffffUL) /*!< GTDVD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTDBU  ========================================================= */
 #define R_GPT0_GTDBU_GTDVU_Pos            (0UL)          /*!< GTDVU (Bit 0)                                         */
 #define R_GPT0_GTDBU_GTDVU_Msk            (0xffffffffUL) /*!< GTDVU (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTDBD  ========================================================= */
 #define R_GPT0_GTDBD_GTDBD_Pos            (0UL)          /*!< GTDBD (Bit 0)                                         */
 #define R_GPT0_GTDBD_GTDBD_Msk            (0xffffffffUL) /*!< GTDBD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  GTSOS  ========================================================= */
 #define R_GPT0_GTSOS_SOS_Pos              (0UL)          /*!< SOS (Bit 0)                                           */
 #define R_GPT0_GTSOS_SOS_Msk              (0x3UL)        /*!< SOS (Bitfield-Mask: 0x03)                             */
/* ========================================================  GTSOTR  ========================================================= */
 #define R_GPT0_GTSOTR_SOTR_Pos            (0UL)          /*!< SOTR (Bit 0)                                          */
 #define R_GPT0_GTSOTR_SOTR_Msk            (0x1UL)        /*!< SOTR (Bitfield-Mask: 0x01)                            */
/* ========================================================  GTADSMR  ======================================================== */
 #define R_GPT0_GTADSMR_ADSMS0_Pos         (0UL)          /*!< ADSMS0 (Bit 0)                                        */
 #define R_GPT0_GTADSMR_ADSMS0_Msk         (0x3UL)        /*!< ADSMS0 (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTADSMR_ADSMEN0_Pos        (8UL)          /*!< ADSMEN0 (Bit 8)                                       */
 #define R_GPT0_GTADSMR_ADSMEN0_Msk        (0x100UL)      /*!< ADSMEN0 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTADSMR_ADSMS1_Pos         (16UL)         /*!< ADSMS1 (Bit 16)                                       */
 #define R_GPT0_GTADSMR_ADSMS1_Msk         (0x30000UL)    /*!< ADSMS1 (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTADSMR_ADSMEN1_Pos        (24UL)         /*!< ADSMEN1 (Bit 24)                                      */
 #define R_GPT0_GTADSMR_ADSMEN1_Msk        (0x1000000UL)  /*!< ADSMEN1 (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTEITC  ========================================================= */
 #define R_GPT0_GTEITC_EIVTC1_Pos          (0UL)          /*!< EIVTC1 (Bit 0)                                        */
 #define R_GPT0_GTEITC_EIVTC1_Msk          (0x3UL)        /*!< EIVTC1 (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTEITC_EIVTT1_Pos          (4UL)          /*!< EIVTT1 (Bit 4)                                        */
 #define R_GPT0_GTEITC_EIVTT1_Msk          (0xf0UL)       /*!< EIVTT1 (Bitfield-Mask: 0x0f)                          */
 #define R_GPT0_GTEITC_EITCNT1_Pos         (12UL)         /*!< EITCNT1 (Bit 12)                                      */
 #define R_GPT0_GTEITC_EITCNT1_Msk         (0xf000UL)     /*!< EITCNT1 (Bitfield-Mask: 0x0f)                         */
 #define R_GPT0_GTEITC_EIVTC2_Pos          (16UL)         /*!< EIVTC2 (Bit 16)                                       */
 #define R_GPT0_GTEITC_EIVTC2_Msk          (0x30000UL)    /*!< EIVTC2 (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTEITC_EIVTT2_Pos          (20UL)         /*!< EIVTT2 (Bit 20)                                       */
 #define R_GPT0_GTEITC_EIVTT2_Msk          (0xf00000UL)   /*!< EIVTT2 (Bitfield-Mask: 0x0f)                          */
 #define R_GPT0_GTEITC_EITCNT2IV_Pos       (24UL)         /*!< EITCNT2IV (Bit 24)                                    */
 #define R_GPT0_GTEITC_EITCNT2IV_Msk       (0xf000000UL)  /*!< EITCNT2IV (Bitfield-Mask: 0x0f)                       */
 #define R_GPT0_GTEITC_EITCNT2_Pos         (28UL)         /*!< EITCNT2 (Bit 28)                                      */
 #define R_GPT0_GTEITC_EITCNT2_Msk         (0xf0000000UL) /*!< EITCNT2 (Bitfield-Mask: 0x0f)                         */
/* =======================================================  GTEITLI1  ======================================================== */
 #define R_GPT0_GTEITLI1_EITLA_Pos         (0UL)          /*!< EITLA (Bit 0)                                         */
 #define R_GPT0_GTEITLI1_EITLA_Msk         (0x7UL)        /*!< EITLA (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLB_Pos         (4UL)          /*!< EITLB (Bit 4)                                         */
 #define R_GPT0_GTEITLI1_EITLB_Msk         (0x70UL)       /*!< EITLB (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLC_Pos         (8UL)          /*!< EITLC (Bit 8)                                         */
 #define R_GPT0_GTEITLI1_EITLC_Msk         (0x700UL)      /*!< EITLC (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLD_Pos         (12UL)         /*!< EITLD (Bit 12)                                        */
 #define R_GPT0_GTEITLI1_EITLD_Msk         (0x7000UL)     /*!< EITLD (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLE_Pos         (16UL)         /*!< EITLE (Bit 16)                                        */
 #define R_GPT0_GTEITLI1_EITLE_Msk         (0x70000UL)    /*!< EITLE (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLF_Pos         (20UL)         /*!< EITLF (Bit 20)                                        */
 #define R_GPT0_GTEITLI1_EITLF_Msk         (0x700000UL)   /*!< EITLF (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLV_Pos         (24UL)         /*!< EITLV (Bit 24)                                        */
 #define R_GPT0_GTEITLI1_EITLV_Msk         (0x7000000UL)  /*!< EITLV (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTEITLI1_EITLU_Pos         (28UL)         /*!< EITLU (Bit 28)                                        */
 #define R_GPT0_GTEITLI1_EITLU_Msk         (0x70000000UL) /*!< EITLU (Bitfield-Mask: 0x07)                           */
/* =======================================================  GTEITLI2  ======================================================== */
 #define R_GPT0_GTEITLI2_EADTAL_Pos        (0UL)          /*!< EADTAL (Bit 0)                                        */
 #define R_GPT0_GTEITLI2_EADTAL_Msk        (0x7UL)        /*!< EADTAL (Bitfield-Mask: 0x07)                          */
 #define R_GPT0_GTEITLI2_EADTBL_Pos        (4UL)          /*!< EADTBL (Bit 4)                                        */
 #define R_GPT0_GTEITLI2_EADTBL_Msk        (0x70UL)       /*!< EADTBL (Bitfield-Mask: 0x07)                          */
/* ========================================================  GTEITLB  ======================================================== */
 #define R_GPT0_GTEITLB_EBTLCA_Pos         (0UL)          /*!< EBTLCA (Bit 0)                                        */
 #define R_GPT0_GTEITLB_EBTLCA_Msk         (0x7UL)        /*!< EBTLCA (Bitfield-Mask: 0x07)                          */
 #define R_GPT0_GTEITLB_EBTLCB_Pos         (4UL)          /*!< EBTLCB (Bit 4)                                        */
 #define R_GPT0_GTEITLB_EBTLCB_Msk         (0x70UL)       /*!< EBTLCB (Bitfield-Mask: 0x07)                          */
 #define R_GPT0_GTEITLB_EBTLPR_Pos         (8UL)          /*!< EBTLPR (Bit 8)                                        */
 #define R_GPT0_GTEITLB_EBTLPR_Msk         (0x700UL)      /*!< EBTLPR (Bitfield-Mask: 0x07)                          */
 #define R_GPT0_GTEITLB_EBTLADA_Pos        (16UL)         /*!< EBTLADA (Bit 16)                                      */
 #define R_GPT0_GTEITLB_EBTLADA_Msk        (0x70000UL)    /*!< EBTLADA (Bitfield-Mask: 0x07)                         */
 #define R_GPT0_GTEITLB_EBTLADB_Pos        (20UL)         /*!< EBTLADB (Bit 20)                                      */
 #define R_GPT0_GTEITLB_EBTLADB_Msk        (0x700000UL)   /*!< EBTLADB (Bitfield-Mask: 0x07)                         */
 #define R_GPT0_GTEITLB_EBTLDVU_Pos        (24UL)         /*!< EBTLDVU (Bit 24)                                      */
 #define R_GPT0_GTEITLB_EBTLDVU_Msk        (0x7000000UL)  /*!< EBTLDVU (Bitfield-Mask: 0x07)                         */
 #define R_GPT0_GTEITLB_EBTLDVD_Pos        (28UL)         /*!< EBTLDVD (Bit 28)                                      */
 #define R_GPT0_GTEITLB_EBTLDVD_Msk        (0x70000000UL) /*!< EBTLDVD (Bitfield-Mask: 0x07)                         */
/* ========================================================  GTICLF  ========================================================= */
 #define R_GPT0_GTICLF_ICLFA_Pos           (0UL)          /*!< ICLFA (Bit 0)                                         */
 #define R_GPT0_GTICLF_ICLFA_Msk           (0x7UL)        /*!< ICLFA (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTICLF_ICLFSELC_Pos        (4UL)          /*!< ICLFSELC (Bit 4)                                      */
 #define R_GPT0_GTICLF_ICLFSELC_Msk        (0x3f0UL)      /*!< ICLFSELC (Bitfield-Mask: 0x3f)                        */
 #define R_GPT0_GTICLF_ICLFB_Pos           (16UL)         /*!< ICLFB (Bit 16)                                        */
 #define R_GPT0_GTICLF_ICLFB_Msk           (0x70000UL)    /*!< ICLFB (Bitfield-Mask: 0x07)                           */
 #define R_GPT0_GTICLF_ICLFSELD_Pos        (20UL)         /*!< ICLFSELD (Bit 20)                                     */
 #define R_GPT0_GTICLF_ICLFSELD_Msk        (0x3f00000UL)  /*!< ICLFSELD (Bitfield-Mask: 0x3f)                        */
/* =========================================================  GTPC  ========================================================== */
 #define R_GPT0_GTPC_PCEN_Pos              (0UL)          /*!< PCEN (Bit 0)                                          */
 #define R_GPT0_GTPC_PCEN_Msk              (0x1UL)        /*!< PCEN (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTPC_ASTP_Pos              (8UL)          /*!< ASTP (Bit 8)                                          */
 #define R_GPT0_GTPC_ASTP_Msk              (0x100UL)      /*!< ASTP (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTPC_PCNT_Pos              (16UL)         /*!< PCNT (Bit 16)                                         */
 #define R_GPT0_GTPC_PCNT_Msk              (0xfff0000UL)  /*!< PCNT (Bitfield-Mask: 0xfff)                           */
/* ========================================================  GTSECSR  ======================================================== */
 #define R_GPT0_GTSECSR_SECSEL0_Pos        (0UL)          /*!< SECSEL0 (Bit 0)                                       */
 #define R_GPT0_GTSECSR_SECSEL0_Msk        (0x1UL)        /*!< SECSEL0 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL1_Pos        (1UL)          /*!< SECSEL1 (Bit 1)                                       */
 #define R_GPT0_GTSECSR_SECSEL1_Msk        (0x2UL)        /*!< SECSEL1 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL2_Pos        (2UL)          /*!< SECSEL2 (Bit 2)                                       */
 #define R_GPT0_GTSECSR_SECSEL2_Msk        (0x4UL)        /*!< SECSEL2 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL3_Pos        (3UL)          /*!< SECSEL3 (Bit 3)                                       */
 #define R_GPT0_GTSECSR_SECSEL3_Msk        (0x8UL)        /*!< SECSEL3 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL4_Pos        (4UL)          /*!< SECSEL4 (Bit 4)                                       */
 #define R_GPT0_GTSECSR_SECSEL4_Msk        (0x10UL)       /*!< SECSEL4 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL5_Pos        (5UL)          /*!< SECSEL5 (Bit 5)                                       */
 #define R_GPT0_GTSECSR_SECSEL5_Msk        (0x20UL)       /*!< SECSEL5 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL6_Pos        (6UL)          /*!< SECSEL6 (Bit 6)                                       */
 #define R_GPT0_GTSECSR_SECSEL6_Msk        (0x40UL)       /*!< SECSEL6 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL7_Pos        (7UL)          /*!< SECSEL7 (Bit 7)                                       */
 #define R_GPT0_GTSECSR_SECSEL7_Msk        (0x80UL)       /*!< SECSEL7 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL8_Pos        (8UL)          /*!< SECSEL8 (Bit 8)                                       */
 #define R_GPT0_GTSECSR_SECSEL8_Msk        (0x100UL)      /*!< SECSEL8 (Bitfield-Mask: 0x01)                         */
 #define R_GPT0_GTSECSR_SECSEL9_Pos        (9UL)          /*!< SECSEL9 (Bit 9)                                       */
 #define R_GPT0_GTSECSR_SECSEL9_Msk        (0x200UL)      /*!< SECSEL9 (Bitfield-Mask: 0x01)                         */
/* ========================================================  GTSECR  ========================================================= */
 #define R_GPT0_GTSECR_SBDCE_Pos           (0UL)          /*!< SBDCE (Bit 0)                                         */
 #define R_GPT0_GTSECR_SBDCE_Msk           (0x1UL)        /*!< SBDCE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDPE_Pos           (1UL)          /*!< SBDPE (Bit 1)                                         */
 #define R_GPT0_GTSECR_SBDPE_Msk           (0x2UL)        /*!< SBDPE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDAE_Pos           (2UL)          /*!< SBDAE (Bit 2)                                         */
 #define R_GPT0_GTSECR_SBDAE_Msk           (0x4UL)        /*!< SBDAE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDDE_Pos           (3UL)          /*!< SBDDE (Bit 3)                                         */
 #define R_GPT0_GTSECR_SBDDE_Msk           (0x8UL)        /*!< SBDDE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDCD_Pos           (8UL)          /*!< SBDCD (Bit 8)                                         */
 #define R_GPT0_GTSECR_SBDCD_Msk           (0x100UL)      /*!< SBDCD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDPD_Pos           (9UL)          /*!< SBDPD (Bit 9)                                         */
 #define R_GPT0_GTSECR_SBDPD_Msk           (0x200UL)      /*!< SBDPD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDAD_Pos           (10UL)         /*!< SBDAD (Bit 10)                                        */
 #define R_GPT0_GTSECR_SBDAD_Msk           (0x400UL)      /*!< SBDAD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SBDDD_Pos           (11UL)         /*!< SBDDD (Bit 11)                                        */
 #define R_GPT0_GTSECR_SBDDD_Msk           (0x800UL)      /*!< SBDDD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTSECR_SPCE_Pos            (16UL)         /*!< SPCE (Bit 16)                                         */
 #define R_GPT0_GTSECR_SPCE_Msk            (0x10000UL)    /*!< SPCE (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTSECR_SSCE_Pos            (17UL)         /*!< SSCE (Bit 17)                                         */
 #define R_GPT0_GTSECR_SSCE_Msk            (0x20000UL)    /*!< SSCE (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTSECR_SPCD_Pos            (24UL)         /*!< SPCD (Bit 24)                                         */
 #define R_GPT0_GTSECR_SPCD_Msk            (0x1000000UL)  /*!< SPCD (Bitfield-Mask: 0x01)                            */
 #define R_GPT0_GTSECR_SSCD_Pos            (25UL)         /*!< SSCD (Bit 25)                                         */
 #define R_GPT0_GTSECR_SSCD_Msk            (0x2000000UL)  /*!< SSCD (Bitfield-Mask: 0x01)                            */
/* ========================================================  GTBER2  ========================================================= */
 #define R_GPT0_GTBER2_CCTCA_Pos           (0UL)          /*!< CCTCA (Bit 0)                                         */
 #define R_GPT0_GTBER2_CCTCA_Msk           (0x1UL)        /*!< CCTCA (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CCTCB_Pos           (1UL)          /*!< CCTCB (Bit 1)                                         */
 #define R_GPT0_GTBER2_CCTCB_Msk           (0x2UL)        /*!< CCTCB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CCTPR_Pos           (2UL)          /*!< CCTPR (Bit 2)                                         */
 #define R_GPT0_GTBER2_CCTPR_Msk           (0x4UL)        /*!< CCTPR (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CCTADA_Pos          (3UL)          /*!< CCTADA (Bit 3)                                        */
 #define R_GPT0_GTBER2_CCTADA_Msk          (0x8UL)        /*!< CCTADA (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CCTADB_Pos          (4UL)          /*!< CCTADB (Bit 4)                                        */
 #define R_GPT0_GTBER2_CCTADB_Msk          (0x10UL)       /*!< CCTADB (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CCTDV_Pos           (5UL)          /*!< CCTDV (Bit 5)                                         */
 #define R_GPT0_GTBER2_CCTDV_Msk           (0x20UL)       /*!< CCTDV (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CMTCA_Pos           (8UL)          /*!< CMTCA (Bit 8)                                         */
 #define R_GPT0_GTBER2_CMTCA_Msk           (0x300UL)      /*!< CMTCA (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTBER2_CMTCB_Pos           (10UL)         /*!< CMTCB (Bit 10)                                        */
 #define R_GPT0_GTBER2_CMTCB_Msk           (0xc00UL)      /*!< CMTCB (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTBER2_CMTADA_Pos          (13UL)         /*!< CMTADA (Bit 13)                                       */
 #define R_GPT0_GTBER2_CMTADA_Msk          (0x2000UL)     /*!< CMTADA (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CMTADB_Pos          (14UL)         /*!< CMTADB (Bit 14)                                       */
 #define R_GPT0_GTBER2_CMTADB_Msk          (0x4000UL)     /*!< CMTADB (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CPTCA_Pos           (16UL)         /*!< CPTCA (Bit 16)                                        */
 #define R_GPT0_GTBER2_CPTCA_Msk           (0x10000UL)    /*!< CPTCA (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CPTCB_Pos           (17UL)         /*!< CPTCB (Bit 17)                                        */
 #define R_GPT0_GTBER2_CPTCB_Msk           (0x20000UL)    /*!< CPTCB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CPTPR_Pos           (18UL)         /*!< CPTPR (Bit 18)                                        */
 #define R_GPT0_GTBER2_CPTPR_Msk           (0x40000UL)    /*!< CPTPR (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CPTADA_Pos          (19UL)         /*!< CPTADA (Bit 19)                                       */
 #define R_GPT0_GTBER2_CPTADA_Msk          (0x80000UL)    /*!< CPTADA (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CPTADB_Pos          (20UL)         /*!< CPTADB (Bit 20)                                       */
 #define R_GPT0_GTBER2_CPTADB_Msk          (0x100000UL)   /*!< CPTADB (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTBER2_CPTDV_Pos           (21UL)         /*!< CPTDV (Bit 21)                                        */
 #define R_GPT0_GTBER2_CPTDV_Msk           (0x200000UL)   /*!< CPTDV (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CP3DB_Pos           (24UL)         /*!< CP3DB (Bit 24)                                        */
 #define R_GPT0_GTBER2_CP3DB_Msk           (0x1000000UL)  /*!< CP3DB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_CPBTD_Pos           (25UL)         /*!< CPBTD (Bit 25)                                        */
 #define R_GPT0_GTBER2_CPBTD_Msk           (0x2000000UL)  /*!< CPBTD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTBER2_OLTTA_Pos           (26UL)         /*!< OLTTA (Bit 26)                                        */
 #define R_GPT0_GTBER2_OLTTA_Msk           (0xc000000UL)  /*!< OLTTA (Bitfield-Mask: 0x03)                           */
 #define R_GPT0_GTBER2_OLTTB_Pos           (28UL)         /*!< OLTTB (Bit 28)                                        */
 #define R_GPT0_GTBER2_OLTTB_Msk           (0x30000000UL) /*!< OLTTB (Bitfield-Mask: 0x03)                           */
/* ========================================================  GTOLBR  ========================================================= */
 #define R_GPT0_GTOLBR_GTIOAB_Pos          (0UL)          /*!< GTIOAB (Bit 0)                                        */
 #define R_GPT0_GTOLBR_GTIOAB_Msk          (0x1fUL)       /*!< GTIOAB (Bitfield-Mask: 0x1f)                          */
 #define R_GPT0_GTOLBR_GTIOBB_Pos          (16UL)         /*!< GTIOBB (Bit 16)                                       */
 #define R_GPT0_GTOLBR_GTIOBB_Msk          (0x1f0000UL)   /*!< GTIOBB (Bitfield-Mask: 0x1f)                          */
/* ========================================================  GTICCR  ========================================================= */
 #define R_GPT0_GTICCR_ICAFA_Pos           (0UL)          /*!< ICAFA (Bit 0)                                         */
 #define R_GPT0_GTICCR_ICAFA_Msk           (0x1UL)        /*!< ICAFA (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFB_Pos           (1UL)          /*!< ICAFB (Bit 1)                                         */
 #define R_GPT0_GTICCR_ICAFB_Msk           (0x2UL)        /*!< ICAFB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFC_Pos           (2UL)          /*!< ICAFC (Bit 2)                                         */
 #define R_GPT0_GTICCR_ICAFC_Msk           (0x4UL)        /*!< ICAFC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFD_Pos           (3UL)          /*!< ICAFD (Bit 3)                                         */
 #define R_GPT0_GTICCR_ICAFD_Msk           (0x8UL)        /*!< ICAFD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFE_Pos           (4UL)          /*!< ICAFE (Bit 4)                                         */
 #define R_GPT0_GTICCR_ICAFE_Msk           (0x10UL)       /*!< ICAFE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFF_Pos           (5UL)          /*!< ICAFF (Bit 5)                                         */
 #define R_GPT0_GTICCR_ICAFF_Msk           (0x20UL)       /*!< ICAFF (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICAFPO_Pos          (6UL)          /*!< ICAFPO (Bit 6)                                        */
 #define R_GPT0_GTICCR_ICAFPO_Msk          (0x40UL)       /*!< ICAFPO (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICAFPU_Pos          (7UL)          /*!< ICAFPU (Bit 7)                                        */
 #define R_GPT0_GTICCR_ICAFPU_Msk          (0x80UL)       /*!< ICAFPU (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICACLK_Pos          (8UL)          /*!< ICACLK (Bit 8)                                        */
 #define R_GPT0_GTICCR_ICACLK_Msk          (0x100UL)      /*!< ICACLK (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICAGRP_Pos          (14UL)         /*!< ICAGRP (Bit 14)                                       */
 #define R_GPT0_GTICCR_ICAGRP_Msk          (0xc000UL)     /*!< ICAGRP (Bitfield-Mask: 0x03)                          */
 #define R_GPT0_GTICCR_ICBFA_Pos           (16UL)         /*!< ICBFA (Bit 16)                                        */
 #define R_GPT0_GTICCR_ICBFA_Msk           (0x10000UL)    /*!< ICBFA (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFB_Pos           (17UL)         /*!< ICBFB (Bit 17)                                        */
 #define R_GPT0_GTICCR_ICBFB_Msk           (0x20000UL)    /*!< ICBFB (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFC_Pos           (18UL)         /*!< ICBFC (Bit 18)                                        */
 #define R_GPT0_GTICCR_ICBFC_Msk           (0x40000UL)    /*!< ICBFC (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFD_Pos           (19UL)         /*!< ICBFD (Bit 19)                                        */
 #define R_GPT0_GTICCR_ICBFD_Msk           (0x80000UL)    /*!< ICBFD (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFE_Pos           (20UL)         /*!< ICBFE (Bit 20)                                        */
 #define R_GPT0_GTICCR_ICBFE_Msk           (0x100000UL)   /*!< ICBFE (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFF_Pos           (21UL)         /*!< ICBFF (Bit 21)                                        */
 #define R_GPT0_GTICCR_ICBFF_Msk           (0x200000UL)   /*!< ICBFF (Bitfield-Mask: 0x01)                           */
 #define R_GPT0_GTICCR_ICBFPO_Pos          (22UL)         /*!< ICBFPO (Bit 22)                                       */
 #define R_GPT0_GTICCR_ICBFPO_Msk          (0x400000UL)   /*!< ICBFPO (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICBFPU_Pos          (23UL)         /*!< ICBFPU (Bit 23)                                       */
 #define R_GPT0_GTICCR_ICBFPU_Msk          (0x800000UL)   /*!< ICBFPU (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICBCLK_Pos          (24UL)         /*!< ICBCLK (Bit 24)                                       */
 #define R_GPT0_GTICCR_ICBCLK_Msk          (0x1000000UL)  /*!< ICBCLK (Bitfield-Mask: 0x01)                          */
 #define R_GPT0_GTICCR_ICBGRP_Pos          (30UL)         /*!< ICBGRP (Bit 30)                                       */
 #define R_GPT0_GTICCR_ICBGRP_Msk          (0xc0000000UL) /*!< ICBGRP (Bitfield-Mask: 0x03)                          */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/* =========================================================  OPSCR  ========================================================= */
 #define R_GPT_OPS_OPSCR_NFCS_Pos     (30UL)         /*!< NFCS (Bit 30)                                         */
 #define R_GPT_OPS_OPSCR_NFCS_Msk     (0xc0000000UL) /*!< NFCS (Bitfield-Mask: 0x03)                            */
 #define R_GPT_OPS_OPSCR_NFEN_Pos     (29UL)         /*!< NFEN (Bit 29)                                         */
 #define R_GPT_OPS_OPSCR_NFEN_Msk     (0x20000000UL) /*!< NFEN (Bitfield-Mask: 0x01)                            */
 #define R_GPT_OPS_OPSCR_GODF_Pos     (26UL)         /*!< GODF (Bit 26)                                         */
 #define R_GPT_OPS_OPSCR_GODF_Msk     (0x4000000UL)  /*!< GODF (Bitfield-Mask: 0x01)                            */
 #define R_GPT_OPS_OPSCR_GRP_Pos      (24UL)         /*!< GRP (Bit 24)                                          */
 #define R_GPT_OPS_OPSCR_GRP_Msk      (0x3000000UL)  /*!< GRP (Bitfield-Mask: 0x03)                             */
 #define R_GPT_OPS_OPSCR_ALIGN_Pos    (21UL)         /*!< ALIGN (Bit 21)                                        */
 #define R_GPT_OPS_OPSCR_ALIGN_Msk    (0x200000UL)   /*!< ALIGN (Bitfield-Mask: 0x01)                           */
 #define R_GPT_OPS_OPSCR_RV_Pos       (20UL)         /*!< RV (Bit 20)                                           */
 #define R_GPT_OPS_OPSCR_RV_Msk       (0x100000UL)   /*!< RV (Bitfield-Mask: 0x01)                              */
 #define R_GPT_OPS_OPSCR_INV_Pos      (19UL)         /*!< INV (Bit 19)                                          */
 #define R_GPT_OPS_OPSCR_INV_Msk      (0x80000UL)    /*!< INV (Bitfield-Mask: 0x01)                             */
 #define R_GPT_OPS_OPSCR_N_Pos        (18UL)         /*!< N (Bit 18)                                            */
 #define R_GPT_OPS_OPSCR_N_Msk        (0x40000UL)    /*!< N (Bitfield-Mask: 0x01)                               */
 #define R_GPT_OPS_OPSCR_P_Pos        (17UL)         /*!< P (Bit 17)                                            */
 #define R_GPT_OPS_OPSCR_P_Msk        (0x20000UL)    /*!< P (Bitfield-Mask: 0x01)                               */
 #define R_GPT_OPS_OPSCR_FB_Pos       (16UL)         /*!< FB (Bit 16)                                           */
 #define R_GPT_OPS_OPSCR_FB_Msk       (0x10000UL)    /*!< FB (Bitfield-Mask: 0x01)                              */
 #define R_GPT_OPS_OPSCR_EN_Pos       (8UL)          /*!< EN (Bit 8)                                            */
 #define R_GPT_OPS_OPSCR_EN_Msk       (0x100UL)      /*!< EN (Bitfield-Mask: 0x01)                              */
 #define R_GPT_OPS_OPSCR_W_Pos        (6UL)          /*!< W (Bit 6)                                             */
 #define R_GPT_OPS_OPSCR_W_Msk        (0x40UL)       /*!< W (Bitfield-Mask: 0x01)                               */
 #define R_GPT_OPS_OPSCR_V_Pos        (5UL)          /*!< V (Bit 5)                                             */
 #define R_GPT_OPS_OPSCR_V_Msk        (0x20UL)       /*!< V (Bitfield-Mask: 0x01)                               */
 #define R_GPT_OPS_OPSCR_U_Pos        (4UL)          /*!< U (Bit 4)                                             */
 #define R_GPT_OPS_OPSCR_U_Msk        (0x10UL)       /*!< U (Bitfield-Mask: 0x01)                               */
 #define R_GPT_OPS_OPSCR_WF_Pos       (2UL)          /*!< WF (Bit 2)                                            */
 #define R_GPT_OPS_OPSCR_WF_Msk       (0x4UL)        /*!< WF (Bitfield-Mask: 0x01)                              */
 #define R_GPT_OPS_OPSCR_VF_Pos       (1UL)          /*!< VF (Bit 1)                                            */
 #define R_GPT_OPS_OPSCR_VF_Msk       (0x2UL)        /*!< VF (Bitfield-Mask: 0x01)                              */
 #define R_GPT_OPS_OPSCR_UF_Pos       (0UL)          /*!< UF (Bit 0)                                            */
 #define R_GPT_OPS_OPSCR_UF_Msk       (0x1UL)        /*!< UF (Bitfield-Mask: 0x01)                              */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/* =========================================================  POEGG  ========================================================= */
 #define R_GPT_POEG0_POEGG_NFCS_Pos     (30UL)         /*!< NFCS (Bit 30)                                         */
 #define R_GPT_POEG0_POEGG_NFCS_Msk     (0xc0000000UL) /*!< NFCS (Bitfield-Mask: 0x03)                            */
 #define R_GPT_POEG0_POEGG_NFEN_Pos     (29UL)         /*!< NFEN (Bit 29)                                         */
 #define R_GPT_POEG0_POEGG_NFEN_Msk     (0x20000000UL) /*!< NFEN (Bitfield-Mask: 0x01)                            */
 #define R_GPT_POEG0_POEGG_INV_Pos      (28UL)         /*!< INV (Bit 28)                                          */
 #define R_GPT_POEG0_POEGG_INV_Msk      (0x10000000UL) /*!< INV (Bitfield-Mask: 0x01)                             */
 #define R_GPT_POEG0_POEGG_ST_Pos       (16UL)         /*!< ST (Bit 16)                                           */
 #define R_GPT_POEG0_POEGG_ST_Msk       (0x10000UL)    /*!< ST (Bitfield-Mask: 0x01)                              */
 #define R_GPT_POEG0_POEGG_CDRE_Pos     (8UL)          /*!< CDRE (Bit 8)                                          */
 #define R_GPT_POEG0_POEGG_CDRE_Msk     (0x100UL)      /*!< CDRE (Bitfield-Mask: 0x01)                            */
 #define R_GPT_POEG0_POEGG_OSTPE_Pos    (6UL)          /*!< OSTPE (Bit 6)                                         */
 #define R_GPT_POEG0_POEGG_OSTPE_Msk    (0x40UL)       /*!< OSTPE (Bitfield-Mask: 0x01)                           */
 #define R_GPT_POEG0_POEGG_IOCE_Pos     (5UL)          /*!< IOCE (Bit 5)                                          */
 #define R_GPT_POEG0_POEGG_IOCE_Msk     (0x20UL)       /*!< IOCE (Bitfield-Mask: 0x01)                            */
 #define R_GPT_POEG0_POEGG_PIDE_Pos     (4UL)          /*!< PIDE (Bit 4)                                          */
 #define R_GPT_POEG0_POEGG_PIDE_Msk     (0x10UL)       /*!< PIDE (Bitfield-Mask: 0x01)                            */
 #define R_GPT_POEG0_POEGG_SSF_Pos      (3UL)          /*!< SSF (Bit 3)                                           */
 #define R_GPT_POEG0_POEGG_SSF_Msk      (0x8UL)        /*!< SSF (Bitfield-Mask: 0x01)                             */
 #define R_GPT_POEG0_POEGG_OSTPF_Pos    (2UL)          /*!< OSTPF (Bit 2)                                         */
 #define R_GPT_POEG0_POEGG_OSTPF_Msk    (0x4UL)        /*!< OSTPF (Bitfield-Mask: 0x01)                           */
 #define R_GPT_POEG0_POEGG_IOCF_Pos     (1UL)          /*!< IOCF (Bit 1)                                          */
 #define R_GPT_POEG0_POEGG_IOCF_Msk     (0x2UL)        /*!< IOCF (Bitfield-Mask: 0x01)                            */
 #define R_GPT_POEG0_POEGG_PIDF_Pos     (0UL)          /*!< PIDF (Bit 0)                                          */
 #define R_GPT_POEG0_POEGG_PIDF_Msk     (0x1UL)        /*!< PIDF (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  IRQCR  ========================================================= */
 #define R_ICU_IRQCR_FLTEN_Pos           (7UL)          /*!< FLTEN (Bit 7)                                         */
 #define R_ICU_IRQCR_FLTEN_Msk           (0x80UL)       /*!< FLTEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_IRQCR_FCLKSEL_Pos         (4UL)          /*!< FCLKSEL (Bit 4)                                       */
 #define R_ICU_IRQCR_FCLKSEL_Msk         (0x30UL)       /*!< FCLKSEL (Bitfield-Mask: 0x03)                         */
 #define R_ICU_IRQCR_IRQMD_Pos           (0UL)          /*!< IRQMD (Bit 0)                                         */
 #define R_ICU_IRQCR_IRQMD_Msk           (0x3UL)        /*!< IRQMD (Bitfield-Mask: 0x03)                           */
/* =========================================================  NMISR  ========================================================= */
 #define R_ICU_NMISR_SPEST_Pos           (12UL)         /*!< SPEST (Bit 12)                                        */
 #define R_ICU_NMISR_SPEST_Msk           (0x1000UL)     /*!< SPEST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_BUSMST_Pos          (11UL)         /*!< BUSMST (Bit 11)                                       */
 #define R_ICU_NMISR_BUSMST_Msk          (0x800UL)      /*!< BUSMST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_BUSSST_Pos          (10UL)         /*!< BUSSST (Bit 10)                                       */
 #define R_ICU_NMISR_BUSSST_Msk          (0x400UL)      /*!< BUSSST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_RECCST_Pos          (9UL)          /*!< RECCST (Bit 9)                                        */
 #define R_ICU_NMISR_RECCST_Msk          (0x200UL)      /*!< RECCST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_RPEST_Pos           (8UL)          /*!< RPEST (Bit 8)                                         */
 #define R_ICU_NMISR_RPEST_Msk           (0x100UL)      /*!< RPEST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_NMIST_Pos           (7UL)          /*!< NMIST (Bit 7)                                         */
 #define R_ICU_NMISR_NMIST_Msk           (0x80UL)       /*!< NMIST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_OSTST_Pos           (6UL)          /*!< OSTST (Bit 6)                                         */
 #define R_ICU_NMISR_OSTST_Msk           (0x40UL)       /*!< OSTST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_VBATTST_Pos         (4UL)          /*!< VBATTST (Bit 4)                                       */
 #define R_ICU_NMISR_VBATTST_Msk         (0x10UL)       /*!< VBATTST (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMISR_LVD2ST_Pos          (3UL)          /*!< LVD2ST (Bit 3)                                        */
 #define R_ICU_NMISR_LVD2ST_Msk          (0x8UL)        /*!< LVD2ST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_LVD1ST_Pos          (2UL)          /*!< LVD1ST (Bit 2)                                        */
 #define R_ICU_NMISR_LVD1ST_Msk          (0x4UL)        /*!< LVD1ST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_WDTST_Pos           (1UL)          /*!< WDTST (Bit 1)                                         */
 #define R_ICU_NMISR_WDTST_Msk           (0x2UL)        /*!< WDTST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_IWDTST_Pos          (0UL)          /*!< IWDTST (Bit 0)                                        */
 #define R_ICU_NMISR_IWDTST_Msk          (0x1UL)        /*!< IWDTST (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMISR_TZFST_Pos           (13UL)         /*!< TZFST (Bit 13)                                        */
 #define R_ICU_NMISR_TZFST_Msk           (0x2000UL)     /*!< TZFST (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMISR_CPEST_Pos           (15UL)         /*!< CPEST (Bit 15)                                        */
 #define R_ICU_NMISR_CPEST_Msk           (0x8000UL)     /*!< CPEST (Bitfield-Mask: 0x01)                           */
/* =========================================================  NMIER  ========================================================= */
 #define R_ICU_NMIER_SPEEN_Pos           (12UL)         /*!< SPEEN (Bit 12)                                        */
 #define R_ICU_NMIER_SPEEN_Msk           (0x1000UL)     /*!< SPEEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_BUSMEN_Pos          (11UL)         /*!< BUSMEN (Bit 11)                                       */
 #define R_ICU_NMIER_BUSMEN_Msk          (0x800UL)      /*!< BUSMEN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_BUSSEN_Pos          (10UL)         /*!< BUSSEN (Bit 10)                                       */
 #define R_ICU_NMIER_BUSSEN_Msk          (0x400UL)      /*!< BUSSEN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_RECCEN_Pos          (9UL)          /*!< RECCEN (Bit 9)                                        */
 #define R_ICU_NMIER_RECCEN_Msk          (0x200UL)      /*!< RECCEN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_RPEEN_Pos           (8UL)          /*!< RPEEN (Bit 8)                                         */
 #define R_ICU_NMIER_RPEEN_Msk           (0x100UL)      /*!< RPEEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_NMIEN_Pos           (7UL)          /*!< NMIEN (Bit 7)                                         */
 #define R_ICU_NMIER_NMIEN_Msk           (0x80UL)       /*!< NMIEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_OSTEN_Pos           (6UL)          /*!< OSTEN (Bit 6)                                         */
 #define R_ICU_NMIER_OSTEN_Msk           (0x40UL)       /*!< OSTEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_VBATTEN_Pos         (4UL)          /*!< VBATTEN (Bit 4)                                       */
 #define R_ICU_NMIER_VBATTEN_Msk         (0x10UL)       /*!< VBATTEN (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMIER_LVD2EN_Pos          (3UL)          /*!< LVD2EN (Bit 3)                                        */
 #define R_ICU_NMIER_LVD2EN_Msk          (0x8UL)        /*!< LVD2EN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_LVD1EN_Pos          (2UL)          /*!< LVD1EN (Bit 2)                                        */
 #define R_ICU_NMIER_LVD1EN_Msk          (0x4UL)        /*!< LVD1EN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_WDTEN_Pos           (1UL)          /*!< WDTEN (Bit 1)                                         */
 #define R_ICU_NMIER_WDTEN_Msk           (0x2UL)        /*!< WDTEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_IWDTEN_Pos          (0UL)          /*!< IWDTEN (Bit 0)                                        */
 #define R_ICU_NMIER_IWDTEN_Msk          (0x1UL)        /*!< IWDTEN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMIER_TZFEN_Pos           (13UL)         /*!< TZFEN (Bit 13)                                        */
 #define R_ICU_NMIER_TZFEN_Msk           (0x2000UL)     /*!< TZFEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_NMIER_CPEEN_Pos           (15UL)         /*!< CPEEN (Bit 15)                                        */
 #define R_ICU_NMIER_CPEEN_Msk           (0x8000UL)     /*!< CPEEN (Bitfield-Mask: 0x01)                           */
/* ========================================================  NMICLR  ========================================================= */
 #define R_ICU_NMICLR_SPECLR_Pos         (12UL)         /*!< SPECLR (Bit 12)                                       */
 #define R_ICU_NMICLR_SPECLR_Msk         (0x1000UL)     /*!< SPECLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_BUSMCLR_Pos        (11UL)         /*!< BUSMCLR (Bit 11)                                      */
 #define R_ICU_NMICLR_BUSMCLR_Msk        (0x800UL)      /*!< BUSMCLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_BUSSCLR_Pos        (10UL)         /*!< BUSSCLR (Bit 10)                                      */
 #define R_ICU_NMICLR_BUSSCLR_Msk        (0x400UL)      /*!< BUSSCLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_RECCCLR_Pos        (9UL)          /*!< RECCCLR (Bit 9)                                       */
 #define R_ICU_NMICLR_RECCCLR_Msk        (0x200UL)      /*!< RECCCLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_RPECLR_Pos         (8UL)          /*!< RPECLR (Bit 8)                                        */
 #define R_ICU_NMICLR_RPECLR_Msk         (0x100UL)      /*!< RPECLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_NMICLR_Pos         (7UL)          /*!< NMICLR (Bit 7)                                        */
 #define R_ICU_NMICLR_NMICLR_Msk         (0x80UL)       /*!< NMICLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_OSTCLR_Pos         (6UL)          /*!< OSTCLR (Bit 6)                                        */
 #define R_ICU_NMICLR_OSTCLR_Msk         (0x40UL)       /*!< OSTCLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_VBATTCLR_Pos       (4UL)          /*!< VBATTCLR (Bit 4)                                      */
 #define R_ICU_NMICLR_VBATTCLR_Msk       (0x10UL)       /*!< VBATTCLR (Bitfield-Mask: 0x01)                        */
 #define R_ICU_NMICLR_LVD2CLR_Pos        (3UL)          /*!< LVD2CLR (Bit 3)                                       */
 #define R_ICU_NMICLR_LVD2CLR_Msk        (0x8UL)        /*!< LVD2CLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_LVD1CLR_Pos        (2UL)          /*!< LVD1CLR (Bit 2)                                       */
 #define R_ICU_NMICLR_LVD1CLR_Msk        (0x4UL)        /*!< LVD1CLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_WDTCLR_Pos         (1UL)          /*!< WDTCLR (Bit 1)                                        */
 #define R_ICU_NMICLR_WDTCLR_Msk         (0x2UL)        /*!< WDTCLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_IWDTCLR_Pos        (0UL)          /*!< IWDTCLR (Bit 0)                                       */
 #define R_ICU_NMICLR_IWDTCLR_Msk        (0x1UL)        /*!< IWDTCLR (Bitfield-Mask: 0x01)                         */
 #define R_ICU_NMICLR_TZFCLR_Pos         (13UL)         /*!< TZFCLR (Bit 13)                                       */
 #define R_ICU_NMICLR_TZFCLR_Msk         (0x2000UL)     /*!< TZFCLR (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICLR_CPECLR_Pos         (15UL)         /*!< CPECLR (Bit 15)                                       */
 #define R_ICU_NMICLR_CPECLR_Msk         (0x8000UL)     /*!< CPECLR (Bitfield-Mask: 0x01)                          */
/* =========================================================  NMICR  ========================================================= */
 #define R_ICU_NMICR_NFLTEN_Pos          (7UL)          /*!< NFLTEN (Bit 7)                                        */
 #define R_ICU_NMICR_NFLTEN_Msk          (0x80UL)       /*!< NFLTEN (Bitfield-Mask: 0x01)                          */
 #define R_ICU_NMICR_NFCLKSEL_Pos        (4UL)          /*!< NFCLKSEL (Bit 4)                                      */
 #define R_ICU_NMICR_NFCLKSEL_Msk        (0x30UL)       /*!< NFCLKSEL (Bitfield-Mask: 0x03)                        */
 #define R_ICU_NMICR_NMIMD_Pos           (0UL)          /*!< NMIMD (Bit 0)                                         */
 #define R_ICU_NMICR_NMIMD_Msk           (0x1UL)        /*!< NMIMD (Bitfield-Mask: 0x01)                           */
/* =========================================================  IELSR  ========================================================= */
 #define R_ICU_IELSR_DTCE_Pos            (24UL)         /*!< DTCE (Bit 24)                                         */
 #define R_ICU_IELSR_DTCE_Msk            (0x1000000UL)  /*!< DTCE (Bitfield-Mask: 0x01)                            */
 #define R_ICU_IELSR_IR_Pos              (16UL)         /*!< IR (Bit 16)                                           */
 #define R_ICU_IELSR_IR_Msk              (0x10000UL)    /*!< IR (Bitfield-Mask: 0x01)                              */
 #define R_ICU_IELSR_IELS_Pos            (0UL)          /*!< IELS (Bit 0)                                          */
 #define R_ICU_IELSR_IELS_Msk            (0x1ffUL)      /*!< IELS (Bitfield-Mask: 0x1ff)                           */
/* =========================================================  DELSR  ========================================================= */
 #define R_ICU_DELSR_IR_Pos              (16UL)         /*!< IR (Bit 16)                                           */
 #define R_ICU_DELSR_IR_Msk              (0x10000UL)    /*!< IR (Bitfield-Mask: 0x01)                              */
 #define R_ICU_DELSR_DELS_Pos            (0UL)          /*!< DELS (Bit 0)                                          */
 #define R_ICU_DELSR_DELS_Msk            (0x1ffUL)      /*!< DELS (Bitfield-Mask: 0x1ff)                           */
/* ========================================================  SELSR0  ========================================================= */
 #define R_ICU_SELSR0_SELS_Pos           (0UL)          /*!< SELS (Bit 0)                                          */
 #define R_ICU_SELSR0_SELS_Msk           (0x1ffUL)      /*!< SELS (Bitfield-Mask: 0x1ff)                           */
/* =========================================================  WUPEN  ========================================================= */
 #define R_ICU_WUPEN_IIC0WUPEN_Pos       (31UL)         /*!< IIC0WUPEN (Bit 31)                                    */
 #define R_ICU_WUPEN_IIC0WUPEN_Msk       (0x80000000UL) /*!< IIC0WUPEN (Bitfield-Mask: 0x01)                       */
 #define R_ICU_WUPEN_AGT1CBWUPEN_Pos     (30UL)         /*!< AGT1CBWUPEN (Bit 30)                                  */
 #define R_ICU_WUPEN_AGT1CBWUPEN_Msk     (0x40000000UL) /*!< AGT1CBWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN_AGT1CAWUPEN_Pos     (29UL)         /*!< AGT1CAWUPEN (Bit 29)                                  */
 #define R_ICU_WUPEN_AGT1CAWUPEN_Msk     (0x20000000UL) /*!< AGT1CAWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN_AGT1UDWUPEN_Pos     (28UL)         /*!< AGT1UDWUPEN (Bit 28)                                  */
 #define R_ICU_WUPEN_AGT1UDWUPEN_Msk     (0x10000000UL) /*!< AGT1UDWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN_USBFSWUPEN_Pos      (27UL)         /*!< USBFSWUPEN (Bit 27)                                   */
 #define R_ICU_WUPEN_USBFSWUPEN_Msk      (0x8000000UL)  /*!< USBFSWUPEN (Bitfield-Mask: 0x01)                      */
 #define R_ICU_WUPEN_USBHSWUPEN_Pos      (26UL)         /*!< USBHSWUPEN (Bit 26)                                   */
 #define R_ICU_WUPEN_USBHSWUPEN_Msk      (0x4000000UL)  /*!< USBHSWUPEN (Bitfield-Mask: 0x01)                      */
 #define R_ICU_WUPEN_RTCPRDWUPEN_Pos     (25UL)         /*!< RTCPRDWUPEN (Bit 25)                                  */
 #define R_ICU_WUPEN_RTCPRDWUPEN_Msk     (0x2000000UL)  /*!< RTCPRDWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN_RTCALMWUPEN_Pos     (24UL)         /*!< RTCALMWUPEN (Bit 24)                                  */
 #define R_ICU_WUPEN_RTCALMWUPEN_Msk     (0x1000000UL)  /*!< RTCALMWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN_ACMPLP0WUPEN_Pos    (23UL)         /*!< ACMPLP0WUPEN (Bit 23)                                 */
 #define R_ICU_WUPEN_ACMPLP0WUPEN_Msk    (0x800000UL)   /*!< ACMPLP0WUPEN (Bitfield-Mask: 0x01)                    */
 #define R_ICU_WUPEN_ACMPHS0WUPEN_Pos    (22UL)         /*!< ACMPHS0WUPEN (Bit 22)                                 */
 #define R_ICU_WUPEN_ACMPHS0WUPEN_Msk    (0x400000UL)   /*!< ACMPHS0WUPEN (Bitfield-Mask: 0x01)                    */
 #define R_ICU_WUPEN_VBATTWUPEN_Pos      (20UL)         /*!< VBATTWUPEN (Bit 20)                                   */
 #define R_ICU_WUPEN_VBATTWUPEN_Msk      (0x100000UL)   /*!< VBATTWUPEN (Bitfield-Mask: 0x01)                      */
 #define R_ICU_WUPEN_LVD2WUPEN_Pos       (19UL)         /*!< LVD2WUPEN (Bit 19)                                    */
 #define R_ICU_WUPEN_LVD2WUPEN_Msk       (0x80000UL)    /*!< LVD2WUPEN (Bitfield-Mask: 0x01)                       */
 #define R_ICU_WUPEN_LVD1WUPEN_Pos       (18UL)         /*!< LVD1WUPEN (Bit 18)                                    */
 #define R_ICU_WUPEN_LVD1WUPEN_Msk       (0x40000UL)    /*!< LVD1WUPEN (Bitfield-Mask: 0x01)                       */
 #define R_ICU_WUPEN_KEYWUPEN_Pos        (17UL)         /*!< KEYWUPEN (Bit 17)                                     */
 #define R_ICU_WUPEN_KEYWUPEN_Msk        (0x20000UL)    /*!< KEYWUPEN (Bitfield-Mask: 0x01)                        */
 #define R_ICU_WUPEN_IWDTWUPEN_Pos       (16UL)         /*!< IWDTWUPEN (Bit 16)                                    */
 #define R_ICU_WUPEN_IWDTWUPEN_Msk       (0x10000UL)    /*!< IWDTWUPEN (Bitfield-Mask: 0x01)                       */
 #define R_ICU_WUPEN_IRQWUPEN_Pos        (0UL)          /*!< IRQWUPEN (Bit 0)                                      */
 #define R_ICU_WUPEN_IRQWUPEN_Msk        (0x1UL)        /*!< IRQWUPEN (Bitfield-Mask: 0x01)                        */
/* ========================================================  WUPEN1  ========================================================= */
 #define R_ICU_WUPEN1_AGT3UDWUPEN_Pos    (0UL)          /*!< AGT3UDWUPEN (Bit 0)                                   */
 #define R_ICU_WUPEN1_AGT3UDWUPEN_Msk    (0x1UL)        /*!< AGT3UDWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN1_AGT3CAWUPEN_Pos    (1UL)          /*!< AGT3CAWUPEN (Bit 1)                                   */
 #define R_ICU_WUPEN1_AGT3CAWUPEN_Msk    (0x2UL)        /*!< AGT3CAWUPEN (Bitfield-Mask: 0x01)                     */
 #define R_ICU_WUPEN1_AGT3CBWUPEN_Pos    (2UL)          /*!< AGT3CBWUPEN (Bit 2)                                   */
 #define R_ICU_WUPEN1_AGT3CBWUPEN_Msk    (0x4UL)        /*!< AGT3CBWUPEN (Bitfield-Mask: 0x01)                     */
/* =========================================================  IELEN  ========================================================= */
 #define R_ICU_IELEN_IELEN_Pos           (1UL)          /*!< IELEN (Bit 1)                                         */
 #define R_ICU_IELEN_IELEN_Msk           (0x2UL)        /*!< IELEN (Bitfield-Mask: 0x01)                           */
 #define R_ICU_IELEN_RTCINTEN_Pos        (0UL)          /*!< RTCINTEN (Bit 0)                                      */
 #define R_ICU_IELEN_RTCINTEN_Msk        (0x1UL)        /*!< RTCINTEN (Bitfield-Mask: 0x01)                        */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ICCR1  ========================================================= */
 #define R_IIC0_ICCR1_ICE_Pos        (7UL)    /*!< ICE (Bit 7)                                           */
 #define R_IIC0_ICCR1_ICE_Msk        (0x80UL) /*!< ICE (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICCR1_IICRST_Pos     (6UL)    /*!< IICRST (Bit 6)                                        */
 #define R_IIC0_ICCR1_IICRST_Msk     (0x40UL) /*!< IICRST (Bitfield-Mask: 0x01)                          */
 #define R_IIC0_ICCR1_CLO_Pos        (5UL)    /*!< CLO (Bit 5)                                           */
 #define R_IIC0_ICCR1_CLO_Msk        (0x20UL) /*!< CLO (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICCR1_SOWP_Pos       (4UL)    /*!< SOWP (Bit 4)                                          */
 #define R_IIC0_ICCR1_SOWP_Msk       (0x10UL) /*!< SOWP (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICCR1_SCLO_Pos       (3UL)    /*!< SCLO (Bit 3)                                          */
 #define R_IIC0_ICCR1_SCLO_Msk       (0x8UL)  /*!< SCLO (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICCR1_SDAO_Pos       (2UL)    /*!< SDAO (Bit 2)                                          */
 #define R_IIC0_ICCR1_SDAO_Msk       (0x4UL)  /*!< SDAO (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICCR1_SCLI_Pos       (1UL)    /*!< SCLI (Bit 1)                                          */
 #define R_IIC0_ICCR1_SCLI_Msk       (0x2UL)  /*!< SCLI (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICCR1_SDAI_Pos       (0UL)    /*!< SDAI (Bit 0)                                          */
 #define R_IIC0_ICCR1_SDAI_Msk       (0x1UL)  /*!< SDAI (Bitfield-Mask: 0x01)                            */
/* =========================================================  ICCR2  ========================================================= */
 #define R_IIC0_ICCR2_BBSY_Pos       (7UL)    /*!< BBSY (Bit 7)                                          */
 #define R_IIC0_ICCR2_BBSY_Msk       (0x80UL) /*!< BBSY (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICCR2_MST_Pos        (6UL)    /*!< MST (Bit 6)                                           */
 #define R_IIC0_ICCR2_MST_Msk        (0x40UL) /*!< MST (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICCR2_TRS_Pos        (5UL)    /*!< TRS (Bit 5)                                           */
 #define R_IIC0_ICCR2_TRS_Msk        (0x20UL) /*!< TRS (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICCR2_SP_Pos         (3UL)    /*!< SP (Bit 3)                                            */
 #define R_IIC0_ICCR2_SP_Msk         (0x8UL)  /*!< SP (Bitfield-Mask: 0x01)                              */
 #define R_IIC0_ICCR2_RS_Pos         (2UL)    /*!< RS (Bit 2)                                            */
 #define R_IIC0_ICCR2_RS_Msk         (0x4UL)  /*!< RS (Bitfield-Mask: 0x01)                              */
 #define R_IIC0_ICCR2_ST_Pos         (1UL)    /*!< ST (Bit 1)                                            */
 #define R_IIC0_ICCR2_ST_Msk         (0x2UL)  /*!< ST (Bitfield-Mask: 0x01)                              */
/* =========================================================  ICMR1  ========================================================= */
 #define R_IIC0_ICMR1_MTWP_Pos       (7UL)    /*!< MTWP (Bit 7)                                          */
 #define R_IIC0_ICMR1_MTWP_Msk       (0x80UL) /*!< MTWP (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR1_CKS_Pos        (4UL)    /*!< CKS (Bit 4)                                           */
 #define R_IIC0_ICMR1_CKS_Msk        (0x70UL) /*!< CKS (Bitfield-Mask: 0x07)                             */
 #define R_IIC0_ICMR1_BCWP_Pos       (3UL)    /*!< BCWP (Bit 3)                                          */
 #define R_IIC0_ICMR1_BCWP_Msk       (0x8UL)  /*!< BCWP (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR1_BC_Pos         (0UL)    /*!< BC (Bit 0)                                            */
 #define R_IIC0_ICMR1_BC_Msk         (0x7UL)  /*!< BC (Bitfield-Mask: 0x07)                              */
/* =========================================================  ICMR2  ========================================================= */
 #define R_IIC0_ICMR2_DLCS_Pos       (7UL)    /*!< DLCS (Bit 7)                                          */
 #define R_IIC0_ICMR2_DLCS_Msk       (0x80UL) /*!< DLCS (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR2_SDDL_Pos       (4UL)    /*!< SDDL (Bit 4)                                          */
 #define R_IIC0_ICMR2_SDDL_Msk       (0x70UL) /*!< SDDL (Bitfield-Mask: 0x07)                            */
 #define R_IIC0_ICMR2_TMOH_Pos       (2UL)    /*!< TMOH (Bit 2)                                          */
 #define R_IIC0_ICMR2_TMOH_Msk       (0x4UL)  /*!< TMOH (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR2_TMOL_Pos       (1UL)    /*!< TMOL (Bit 1)                                          */
 #define R_IIC0_ICMR2_TMOL_Msk       (0x2UL)  /*!< TMOL (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR2_TMOS_Pos       (0UL)    /*!< TMOS (Bit 0)                                          */
 #define R_IIC0_ICMR2_TMOS_Msk       (0x1UL)  /*!< TMOS (Bitfield-Mask: 0x01)                            */
/* =========================================================  ICMR3  ========================================================= */
 #define R_IIC0_ICMR3_SMBS_Pos       (7UL)    /*!< SMBS (Bit 7)                                          */
 #define R_IIC0_ICMR3_SMBS_Msk       (0x80UL) /*!< SMBS (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR3_WAIT_Pos       (6UL)    /*!< WAIT (Bit 6)                                          */
 #define R_IIC0_ICMR3_WAIT_Msk       (0x40UL) /*!< WAIT (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICMR3_RDRFS_Pos      (5UL)    /*!< RDRFS (Bit 5)                                         */
 #define R_IIC0_ICMR3_RDRFS_Msk      (0x20UL) /*!< RDRFS (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICMR3_ACKWP_Pos      (4UL)    /*!< ACKWP (Bit 4)                                         */
 #define R_IIC0_ICMR3_ACKWP_Msk      (0x10UL) /*!< ACKWP (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICMR3_ACKBT_Pos      (3UL)    /*!< ACKBT (Bit 3)                                         */
 #define R_IIC0_ICMR3_ACKBT_Msk      (0x8UL)  /*!< ACKBT (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICMR3_ACKBR_Pos      (2UL)    /*!< ACKBR (Bit 2)                                         */
 #define R_IIC0_ICMR3_ACKBR_Msk      (0x4UL)  /*!< ACKBR (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICMR3_NF_Pos         (0UL)    /*!< NF (Bit 0)                                            */
 #define R_IIC0_ICMR3_NF_Msk         (0x3UL)  /*!< NF (Bitfield-Mask: 0x03)                              */
/* =========================================================  ICFER  ========================================================= */
 #define R_IIC0_ICFER_FMPE_Pos       (7UL)    /*!< FMPE (Bit 7)                                          */
 #define R_IIC0_ICFER_FMPE_Msk       (0x80UL) /*!< FMPE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICFER_SCLE_Pos       (6UL)    /*!< SCLE (Bit 6)                                          */
 #define R_IIC0_ICFER_SCLE_Msk       (0x40UL) /*!< SCLE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICFER_NFE_Pos        (5UL)    /*!< NFE (Bit 5)                                           */
 #define R_IIC0_ICFER_NFE_Msk        (0x20UL) /*!< NFE (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICFER_NACKE_Pos      (4UL)    /*!< NACKE (Bit 4)                                         */
 #define R_IIC0_ICFER_NACKE_Msk      (0x10UL) /*!< NACKE (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICFER_SALE_Pos       (3UL)    /*!< SALE (Bit 3)                                          */
 #define R_IIC0_ICFER_SALE_Msk       (0x8UL)  /*!< SALE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICFER_NALE_Pos       (2UL)    /*!< NALE (Bit 2)                                          */
 #define R_IIC0_ICFER_NALE_Msk       (0x4UL)  /*!< NALE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICFER_MALE_Pos       (1UL)    /*!< MALE (Bit 1)                                          */
 #define R_IIC0_ICFER_MALE_Msk       (0x2UL)  /*!< MALE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICFER_TMOE_Pos       (0UL)    /*!< TMOE (Bit 0)                                          */
 #define R_IIC0_ICFER_TMOE_Msk       (0x1UL)  /*!< TMOE (Bitfield-Mask: 0x01)                            */
/* =========================================================  ICSER  ========================================================= */
 #define R_IIC0_ICSER_HOAE_Pos       (7UL)    /*!< HOAE (Bit 7)                                          */
 #define R_IIC0_ICSER_HOAE_Msk       (0x80UL) /*!< HOAE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSER_DIDE_Pos       (5UL)    /*!< DIDE (Bit 5)                                          */
 #define R_IIC0_ICSER_DIDE_Msk       (0x20UL) /*!< DIDE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSER_GCAE_Pos       (3UL)    /*!< GCAE (Bit 3)                                          */
 #define R_IIC0_ICSER_GCAE_Msk       (0x8UL)  /*!< GCAE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSER_SAR2E_Pos      (2UL)    /*!< SAR2E (Bit 2)                                         */
 #define R_IIC0_ICSER_SAR2E_Msk      (0x4UL)  /*!< SAR2E (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICSER_SAR1E_Pos      (1UL)    /*!< SAR1E (Bit 1)                                         */
 #define R_IIC0_ICSER_SAR1E_Msk      (0x2UL)  /*!< SAR1E (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICSER_SAR0E_Pos      (0UL)    /*!< SAR0E (Bit 0)                                         */
 #define R_IIC0_ICSER_SAR0E_Msk      (0x1UL)  /*!< SAR0E (Bitfield-Mask: 0x01)                           */
/* =========================================================  ICIER  ========================================================= */
 #define R_IIC0_ICIER_TIE_Pos        (7UL)    /*!< TIE (Bit 7)                                           */
 #define R_IIC0_ICIER_TIE_Msk        (0x80UL) /*!< TIE (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICIER_TEIE_Pos       (6UL)    /*!< TEIE (Bit 6)                                          */
 #define R_IIC0_ICIER_TEIE_Msk       (0x40UL) /*!< TEIE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICIER_RIE_Pos        (5UL)    /*!< RIE (Bit 5)                                           */
 #define R_IIC0_ICIER_RIE_Msk        (0x20UL) /*!< RIE (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICIER_NAKIE_Pos      (4UL)    /*!< NAKIE (Bit 4)                                         */
 #define R_IIC0_ICIER_NAKIE_Msk      (0x10UL) /*!< NAKIE (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICIER_SPIE_Pos       (3UL)    /*!< SPIE (Bit 3)                                          */
 #define R_IIC0_ICIER_SPIE_Msk       (0x8UL)  /*!< SPIE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICIER_STIE_Pos       (2UL)    /*!< STIE (Bit 2)                                          */
 #define R_IIC0_ICIER_STIE_Msk       (0x4UL)  /*!< STIE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICIER_ALIE_Pos       (1UL)    /*!< ALIE (Bit 1)                                          */
 #define R_IIC0_ICIER_ALIE_Msk       (0x2UL)  /*!< ALIE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICIER_TMOIE_Pos      (0UL)    /*!< TMOIE (Bit 0)                                         */
 #define R_IIC0_ICIER_TMOIE_Msk      (0x1UL)  /*!< TMOIE (Bitfield-Mask: 0x01)                           */
/* =========================================================  ICSR1  ========================================================= */
 #define R_IIC0_ICSR1_HOA_Pos        (7UL)    /*!< HOA (Bit 7)                                           */
 #define R_IIC0_ICSR1_HOA_Msk        (0x80UL) /*!< HOA (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICSR1_DID_Pos        (5UL)    /*!< DID (Bit 5)                                           */
 #define R_IIC0_ICSR1_DID_Msk        (0x20UL) /*!< DID (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICSR1_GCA_Pos        (3UL)    /*!< GCA (Bit 3)                                           */
 #define R_IIC0_ICSR1_GCA_Msk        (0x8UL)  /*!< GCA (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICSR1_AAS2_Pos       (2UL)    /*!< AAS2 (Bit 2)                                          */
 #define R_IIC0_ICSR1_AAS2_Msk       (0x4UL)  /*!< AAS2 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR1_AAS1_Pos       (1UL)    /*!< AAS1 (Bit 1)                                          */
 #define R_IIC0_ICSR1_AAS1_Msk       (0x2UL)  /*!< AAS1 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR1_AAS0_Pos       (0UL)    /*!< AAS0 (Bit 0)                                          */
 #define R_IIC0_ICSR1_AAS0_Msk       (0x1UL)  /*!< AAS0 (Bitfield-Mask: 0x01)                            */
/* =========================================================  ICSR2  ========================================================= */
 #define R_IIC0_ICSR2_TDRE_Pos       (7UL)    /*!< TDRE (Bit 7)                                          */
 #define R_IIC0_ICSR2_TDRE_Msk       (0x80UL) /*!< TDRE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR2_TEND_Pos       (6UL)    /*!< TEND (Bit 6)                                          */
 #define R_IIC0_ICSR2_TEND_Msk       (0x40UL) /*!< TEND (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR2_RDRF_Pos       (5UL)    /*!< RDRF (Bit 5)                                          */
 #define R_IIC0_ICSR2_RDRF_Msk       (0x20UL) /*!< RDRF (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR2_NACKF_Pos      (4UL)    /*!< NACKF (Bit 4)                                         */
 #define R_IIC0_ICSR2_NACKF_Msk      (0x10UL) /*!< NACKF (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICSR2_STOP_Pos       (3UL)    /*!< STOP (Bit 3)                                          */
 #define R_IIC0_ICSR2_STOP_Msk       (0x8UL)  /*!< STOP (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICSR2_START_Pos      (2UL)    /*!< START (Bit 2)                                         */
 #define R_IIC0_ICSR2_START_Msk      (0x4UL)  /*!< START (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICSR2_AL_Pos         (1UL)    /*!< AL (Bit 1)                                            */
 #define R_IIC0_ICSR2_AL_Msk         (0x2UL)  /*!< AL (Bitfield-Mask: 0x01)                              */
 #define R_IIC0_ICSR2_TMOF_Pos       (0UL)    /*!< TMOF (Bit 0)                                          */
 #define R_IIC0_ICSR2_TMOF_Msk       (0x1UL)  /*!< TMOF (Bitfield-Mask: 0x01)                            */
/* =========================================================  ICBRL  ========================================================= */
 #define R_IIC0_ICBRL_BRL_Pos        (0UL)    /*!< BRL (Bit 0)                                           */
 #define R_IIC0_ICBRL_BRL_Msk        (0x1fUL) /*!< BRL (Bitfield-Mask: 0x1f)                             */
/* =========================================================  ICBRH  ========================================================= */
 #define R_IIC0_ICBRH_BRH_Pos        (0UL)    /*!< BRH (Bit 0)                                           */
 #define R_IIC0_ICBRH_BRH_Msk        (0x1fUL) /*!< BRH (Bitfield-Mask: 0x1f)                             */
/* =========================================================  ICDRT  ========================================================= */
 #define R_IIC0_ICDRT_ICDRT_Pos      (0UL)    /*!< ICDRT (Bit 0)                                         */
 #define R_IIC0_ICDRT_ICDRT_Msk      (0xffUL) /*!< ICDRT (Bitfield-Mask: 0xff)                           */
/* =========================================================  ICDRR  ========================================================= */
 #define R_IIC0_ICDRR_ICDRR_Pos      (0UL)    /*!< ICDRR (Bit 0)                                         */
 #define R_IIC0_ICDRR_ICDRR_Msk      (0xffUL) /*!< ICDRR (Bitfield-Mask: 0xff)                           */
/* =========================================================  ICWUR  ========================================================= */
 #define R_IIC0_ICWUR_WUE_Pos        (7UL)    /*!< WUE (Bit 7)                                           */
 #define R_IIC0_ICWUR_WUE_Msk        (0x80UL) /*!< WUE (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICWUR_WUIE_Pos       (6UL)    /*!< WUIE (Bit 6)                                          */
 #define R_IIC0_ICWUR_WUIE_Msk       (0x40UL) /*!< WUIE (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_ICWUR_WUF_Pos        (5UL)    /*!< WUF (Bit 5)                                           */
 #define R_IIC0_ICWUR_WUF_Msk        (0x20UL) /*!< WUF (Bitfield-Mask: 0x01)                             */
 #define R_IIC0_ICWUR_WUACK_Pos      (4UL)    /*!< WUACK (Bit 4)                                         */
 #define R_IIC0_ICWUR_WUACK_Msk      (0x10UL) /*!< WUACK (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICWUR_WUAFA_Pos      (0UL)    /*!< WUAFA (Bit 0)                                         */
 #define R_IIC0_ICWUR_WUAFA_Msk      (0x1UL)  /*!< WUAFA (Bitfield-Mask: 0x01)                           */
/* ========================================================  ICWUR2  ========================================================= */
 #define R_IIC0_ICWUR2_WUSYF_Pos     (2UL)    /*!< WUSYF (Bit 2)                                         */
 #define R_IIC0_ICWUR2_WUSYF_Msk     (0x4UL)  /*!< WUSYF (Bitfield-Mask: 0x01)                           */
 #define R_IIC0_ICWUR2_WUASYF_Pos    (1UL)    /*!< WUASYF (Bit 1)                                        */
 #define R_IIC0_ICWUR2_WUASYF_Msk    (0x2UL)  /*!< WUASYF (Bitfield-Mask: 0x01)                          */
 #define R_IIC0_ICWUR2_WUSEN_Pos     (0UL)    /*!< WUSEN (Bit 0)                                         */
 #define R_IIC0_ICWUR2_WUSEN_Msk     (0x1UL)  /*!< WUSEN (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  IWDTRR  ========================================================= */
 #define R_IWDT_IWDTRR_IWDTRR_Pos       (0UL)      /*!< IWDTRR (Bit 0)                                        */
 #define R_IWDT_IWDTRR_IWDTRR_Msk       (0xffUL)   /*!< IWDTRR (Bitfield-Mask: 0xff)                          */
/* ========================================================  IWDTCR  ========================================================= */
 #define R_IWDT_IWDTCR_RPSS_Pos         (12UL)     /*!< RPSS (Bit 12)                                         */
 #define R_IWDT_IWDTCR_RPSS_Msk         (0x3000UL) /*!< RPSS (Bitfield-Mask: 0x03)                            */
 #define R_IWDT_IWDTCR_RPES_Pos         (8UL)      /*!< RPES (Bit 8)                                          */
 #define R_IWDT_IWDTCR_RPES_Msk         (0x300UL)  /*!< RPES (Bitfield-Mask: 0x03)                            */
 #define R_IWDT_IWDTCR_CKS_Pos          (4UL)      /*!< CKS (Bit 4)                                           */
 #define R_IWDT_IWDTCR_CKS_Msk          (0xf0UL)   /*!< CKS (Bitfield-Mask: 0x0f)                             */
 #define R_IWDT_IWDTCR_TOPS_Pos         (0UL)      /*!< TOPS (Bit 0)                                          */
 #define R_IWDT_IWDTCR_TOPS_Msk         (0x3UL)    /*!< TOPS (Bitfield-Mask: 0x03)                            */
/* ========================================================  IWDTSR  ========================================================= */
 #define R_IWDT_IWDTSR_REFEF_Pos        (15UL)     /*!< REFEF (Bit 15)                                        */
 #define R_IWDT_IWDTSR_REFEF_Msk        (0x8000UL) /*!< REFEF (Bitfield-Mask: 0x01)                           */
 #define R_IWDT_IWDTSR_UNDFF_Pos        (14UL)     /*!< UNDFF (Bit 14)                                        */
 #define R_IWDT_IWDTSR_UNDFF_Msk        (0x4000UL) /*!< UNDFF (Bitfield-Mask: 0x01)                           */
 #define R_IWDT_IWDTSR_CNTVAL_Pos       (0UL)      /*!< CNTVAL (Bit 0)                                        */
 #define R_IWDT_IWDTSR_CNTVAL_Msk       (0x3fffUL) /*!< CNTVAL (Bitfield-Mask: 0x3fff)                        */
/* ========================================================  IWDTRCR  ======================================================== */
 #define R_IWDT_IWDTRCR_RSTIRQS_Pos     (7UL)      /*!< RSTIRQS (Bit 7)                                       */
 #define R_IWDT_IWDTRCR_RSTIRQS_Msk     (0x80UL)   /*!< RSTIRQS (Bitfield-Mask: 0x01)                         */
/* =======================================================  IWDTCSTPR  ======================================================= */
 #define R_IWDT_IWDTCSTPR_SLCSTP_Pos    (7UL)      /*!< SLCSTP (Bit 7)                                        */
 #define R_IWDT_IWDTCSTPR_SLCSTP_Msk    (0x80UL)   /*!< SLCSTP (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                          R_KINT                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  KRCTL  ========================================================= */
 #define R_KINT_KRCTL_KRMD_Pos    (7UL)    /*!< KRMD (Bit 7)                                          */
 #define R_KINT_KRCTL_KRMD_Msk    (0x80UL) /*!< KRMD (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRCTL_KREG_Pos    (0UL)    /*!< KREG (Bit 0)                                          */
 #define R_KINT_KRCTL_KREG_Msk    (0x1UL)  /*!< KREG (Bitfield-Mask: 0x01)                            */
/* ==========================================================  KRF  ========================================================== */
 #define R_KINT_KRF_KRF7_Pos      (7UL)    /*!< KRF7 (Bit 7)                                          */
 #define R_KINT_KRF_KRF7_Msk      (0x80UL) /*!< KRF7 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF6_Pos      (6UL)    /*!< KRF6 (Bit 6)                                          */
 #define R_KINT_KRF_KRF6_Msk      (0x40UL) /*!< KRF6 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF5_Pos      (5UL)    /*!< KRF5 (Bit 5)                                          */
 #define R_KINT_KRF_KRF5_Msk      (0x20UL) /*!< KRF5 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF4_Pos      (4UL)    /*!< KRF4 (Bit 4)                                          */
 #define R_KINT_KRF_KRF4_Msk      (0x10UL) /*!< KRF4 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF3_Pos      (3UL)    /*!< KRF3 (Bit 3)                                          */
 #define R_KINT_KRF_KRF3_Msk      (0x8UL)  /*!< KRF3 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF2_Pos      (2UL)    /*!< KRF2 (Bit 2)                                          */
 #define R_KINT_KRF_KRF2_Msk      (0x4UL)  /*!< KRF2 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF1_Pos      (1UL)    /*!< KRF1 (Bit 1)                                          */
 #define R_KINT_KRF_KRF1_Msk      (0x2UL)  /*!< KRF1 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRF_KRF0_Pos      (0UL)    /*!< KRF0 (Bit 0)                                          */
 #define R_KINT_KRF_KRF0_Msk      (0x1UL)  /*!< KRF0 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  KRM  ========================================================== */
 #define R_KINT_KRM_KRM7_Pos      (7UL)    /*!< KRM7 (Bit 7)                                          */
 #define R_KINT_KRM_KRM7_Msk      (0x80UL) /*!< KRM7 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM6_Pos      (6UL)    /*!< KRM6 (Bit 6)                                          */
 #define R_KINT_KRM_KRM6_Msk      (0x40UL) /*!< KRM6 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM5_Pos      (5UL)    /*!< KRM5 (Bit 5)                                          */
 #define R_KINT_KRM_KRM5_Msk      (0x20UL) /*!< KRM5 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM4_Pos      (4UL)    /*!< KRM4 (Bit 4)                                          */
 #define R_KINT_KRM_KRM4_Msk      (0x10UL) /*!< KRM4 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM3_Pos      (3UL)    /*!< KRM3 (Bit 3)                                          */
 #define R_KINT_KRM_KRM3_Msk      (0x8UL)  /*!< KRM3 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM2_Pos      (2UL)    /*!< KRM2 (Bit 2)                                          */
 #define R_KINT_KRM_KRM2_Msk      (0x4UL)  /*!< KRM2 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM1_Pos      (1UL)    /*!< KRM1 (Bit 1)                                          */
 #define R_KINT_KRM_KRM1_Msk      (0x2UL)  /*!< KRM1 (Bitfield-Mask: 0x01)                            */
 #define R_KINT_KRM_KRM0_Pos      (0UL)    /*!< KRM0 (Bit 0)                                          */
 #define R_KINT_KRM_KRM0_Msk      (0x1UL)  /*!< KRM0 (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                          R_I3C0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  PRTS  ========================================================== */
 #define R_I3C0_PRTS_PRTMD_Pos          (0UL)          /*!< PRTMD (Bit 0)                                         */
 #define R_I3C0_PRTS_PRTMD_Msk          (0x1UL)        /*!< PRTMD (Bitfield-Mask: 0x01)                           */
/* =========================================================  CECTL  ========================================================= */
 #define R_I3C0_CECTL_CLKE_Pos          (0UL)          /*!< CLKE (Bit 0)                                          */
 #define R_I3C0_CECTL_CLKE_Msk          (0x1UL)        /*!< CLKE (Bitfield-Mask: 0x01)                            */
/* =========================================================  BCTL  ========================================================== */
 #define R_I3C0_BCTL_INCBA_Pos          (0UL)          /*!< INCBA (Bit 0)                                         */
 #define R_I3C0_BCTL_INCBA_Msk          (0x1UL)        /*!< INCBA (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_BCTL_BMDS_Pos           (7UL)          /*!< BMDS (Bit 7)                                          */
 #define R_I3C0_BCTL_BMDS_Msk           (0x80UL)       /*!< BMDS (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BCTL_HJACKCTL_Pos       (8UL)          /*!< HJACKCTL (Bit 8)                                      */
 #define R_I3C0_BCTL_HJACKCTL_Msk       (0x100UL)      /*!< HJACKCTL (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BCTL_ABT_Pos            (29UL)         /*!< ABT (Bit 29)                                          */
 #define R_I3C0_BCTL_ABT_Msk            (0x20000000UL) /*!< ABT (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_BCTL_RSM_Pos            (30UL)         /*!< RSM (Bit 30)                                          */
 #define R_I3C0_BCTL_RSM_Msk            (0x40000000UL) /*!< RSM (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_BCTL_BUSE_Pos           (31UL)         /*!< BUSE (Bit 31)                                         */
 #define R_I3C0_BCTL_BUSE_Msk           (0x80000000UL) /*!< BUSE (Bitfield-Mask: 0x01)                            */
/* ========================================================  MSDVAD  ========================================================= */
 #define R_I3C0_MSDVAD_MDYAD_Pos        (16UL)         /*!< MDYAD (Bit 16)                                        */
 #define R_I3C0_MSDVAD_MDYAD_Msk        (0x7f0000UL)   /*!< MDYAD (Bitfield-Mask: 0x7f)                           */
 #define R_I3C0_MSDVAD_MDYADV_Pos       (31UL)         /*!< MDYADV (Bit 31)                                       */
 #define R_I3C0_MSDVAD_MDYADV_Msk       (0x80000000UL) /*!< MDYADV (Bitfield-Mask: 0x01)                          */
/* ========================================================  RSTCTL  ========================================================= */
 #define R_I3C0_RSTCTL_RI3CRST_Pos      (0UL)          /*!< RI3CRST (Bit 0)                                       */
 #define R_I3C0_RSTCTL_RI3CRST_Msk      (0x1UL)        /*!< RI3CRST (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_RSTCTL_CMDQRST_Pos      (1UL)          /*!< CMDQRST (Bit 1)                                       */
 #define R_I3C0_RSTCTL_CMDQRST_Msk      (0x2UL)        /*!< CMDQRST (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_RSTCTL_RSPQRST_Pos      (2UL)          /*!< RSPQRST (Bit 2)                                       */
 #define R_I3C0_RSTCTL_RSPQRST_Msk      (0x4UL)        /*!< RSPQRST (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_RSTCTL_TDBRST_Pos       (3UL)          /*!< TDBRST (Bit 3)                                        */
 #define R_I3C0_RSTCTL_TDBRST_Msk       (0x8UL)        /*!< TDBRST (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_RSTCTL_RDBRST_Pos       (4UL)          /*!< RDBRST (Bit 4)                                        */
 #define R_I3C0_RSTCTL_RDBRST_Msk       (0x10UL)       /*!< RDBRST (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_RSTCTL_IBIQRST_Pos      (5UL)          /*!< IBIQRST (Bit 5)                                       */
 #define R_I3C0_RSTCTL_IBIQRST_Msk      (0x20UL)       /*!< IBIQRST (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_RSTCTL_RSQRST_Pos       (6UL)          /*!< RSQRST (Bit 6)                                        */
 #define R_I3C0_RSTCTL_RSQRST_Msk       (0x40UL)       /*!< RSQRST (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_RSTCTL_INTLRST_Pos      (16UL)         /*!< INTLRST (Bit 16)                                      */
 #define R_I3C0_RSTCTL_INTLRST_Msk      (0x10000UL)    /*!< INTLRST (Bitfield-Mask: 0x01)                         */
/* =========================================================  PRSST  ========================================================= */
 #define R_I3C0_PRSST_CRMS_Pos          (2UL)          /*!< CRMS (Bit 2)                                          */
 #define R_I3C0_PRSST_CRMS_Msk          (0x4UL)        /*!< CRMS (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_PRSST_TRMD_Pos          (4UL)          /*!< TRMD (Bit 4)                                          */
 #define R_I3C0_PRSST_TRMD_Msk          (0x10UL)       /*!< TRMD (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_PRSST_PRSSTWP_Pos       (7UL)          /*!< PRSSTWP (Bit 7)                                       */
 #define R_I3C0_PRSST_PRSSTWP_Msk       (0x80UL)       /*!< PRSSTWP (Bitfield-Mask: 0x01)                         */
/* =========================================================  INST  ========================================================== */
 #define R_I3C0_INST_INEF_Pos           (10UL)         /*!< INEF (Bit 10)                                         */
 #define R_I3C0_INST_INEF_Msk           (0x400UL)      /*!< INEF (Bitfield-Mask: 0x01)                            */
/* =========================================================  INSTE  ========================================================= */
 #define R_I3C0_INSTE_INEE_Pos          (10UL)         /*!< INEE (Bit 10)                                         */
 #define R_I3C0_INSTE_INEE_Msk          (0x400UL)      /*!< INEE (Bitfield-Mask: 0x01)                            */
/* =========================================================  INIE  ========================================================== */
 #define R_I3C0_INIE_INEIE_Pos          (10UL)         /*!< INEIE (Bit 10)                                        */
 #define R_I3C0_INIE_INEIE_Msk          (0x400UL)      /*!< INEIE (Bitfield-Mask: 0x01)                           */
/* ========================================================  INSTFC  ========================================================= */
 #define R_I3C0_INSTFC_INEFC_Pos        (10UL)         /*!< INEFC (Bit 10)                                        */
 #define R_I3C0_INSTFC_INEFC_Msk        (0x400UL)      /*!< INEFC (Bitfield-Mask: 0x01)                           */
/* =========================================================  DVCT  ========================================================== */
 #define R_I3C0_DVCT_IDX_Pos            (19UL)         /*!< IDX (Bit 19)                                          */
 #define R_I3C0_DVCT_IDX_Msk            (0xf80000UL)   /*!< IDX (Bitfield-Mask: 0x1f)                             */
/* ========================================================  IBINCTL  ======================================================== */
 #define R_I3C0_IBINCTL_NRHJCTL_Pos     (0UL)          /*!< NRHJCTL (Bit 0)                                       */
 #define R_I3C0_IBINCTL_NRHJCTL_Msk     (0x1UL)        /*!< NRHJCTL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_IBINCTL_NRMRCTL_Pos     (1UL)          /*!< NRMRCTL (Bit 1)                                       */
 #define R_I3C0_IBINCTL_NRMRCTL_Msk     (0x2UL)        /*!< NRMRCTL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_IBINCTL_NRSIRCTL_Pos    (3UL)          /*!< NRSIRCTL (Bit 3)                                      */
 #define R_I3C0_IBINCTL_NRSIRCTL_Msk    (0x8UL)        /*!< NRSIRCTL (Bitfield-Mask: 0x01)                        */
/* =========================================================  BFCTL  ========================================================= */
 #define R_I3C0_BFCTL_MALE_Pos          (0UL)          /*!< MALE (Bit 0)                                          */
 #define R_I3C0_BFCTL_MALE_Msk          (0x1UL)        /*!< MALE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BFCTL_NALE_Pos          (1UL)          /*!< NALE (Bit 1)                                          */
 #define R_I3C0_BFCTL_NALE_Msk          (0x2UL)        /*!< NALE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BFCTL_SALE_Pos          (2UL)          /*!< SALE (Bit 2)                                          */
 #define R_I3C0_BFCTL_SALE_Msk          (0x4UL)        /*!< SALE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BFCTL_SCSYNE_Pos        (8UL)          /*!< SCSYNE (Bit 8)                                        */
 #define R_I3C0_BFCTL_SCSYNE_Msk        (0x100UL)      /*!< SCSYNE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_BFCTL_SMBS_Pos          (12UL)         /*!< SMBS (Bit 12)                                         */
 #define R_I3C0_BFCTL_SMBS_Msk          (0x1000UL)     /*!< SMBS (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BFCTL_FMPE_Pos          (14UL)         /*!< FMPE (Bit 14)                                         */
 #define R_I3C0_BFCTL_FMPE_Msk          (0x4000UL)     /*!< FMPE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BFCTL_HSME_Pos          (15UL)         /*!< HSME (Bit 15)                                         */
 #define R_I3C0_BFCTL_HSME_Msk          (0x8000UL)     /*!< HSME (Bitfield-Mask: 0x01)                            */
/* =========================================================  SVCTL  ========================================================= */
 #define R_I3C0_SVCTL_GCAE_Pos          (0UL)          /*!< GCAE (Bit 0)                                          */
 #define R_I3C0_SVCTL_GCAE_Msk          (0x1UL)        /*!< GCAE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_SVCTL_HSMCE_Pos         (5UL)          /*!< HSMCE (Bit 5)                                         */
 #define R_I3C0_SVCTL_HSMCE_Msk         (0x20UL)       /*!< HSMCE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVCTL_DVIDE_Pos         (6UL)          /*!< DVIDE (Bit 6)                                         */
 #define R_I3C0_SVCTL_DVIDE_Msk         (0x40UL)       /*!< DVIDE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVCTL_HOAE_Pos          (15UL)         /*!< HOAE (Bit 15)                                         */
 #define R_I3C0_SVCTL_HOAE_Msk          (0x8000UL)     /*!< HOAE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_SVCTL_SVAEn_Pos         (16UL)         /*!< SVAEn (Bit 16)                                        */
 #define R_I3C0_SVCTL_SVAEn_Msk         (0x10000UL)    /*!< SVAEn (Bitfield-Mask: 0x01)                           */
/* =======================================================  REFCKCTL  ======================================================== */
 #define R_I3C0_REFCKCTL_IREFCKS_Pos    (0UL)          /*!< IREFCKS (Bit 0)                                       */
 #define R_I3C0_REFCKCTL_IREFCKS_Msk    (0x7UL)        /*!< IREFCKS (Bitfield-Mask: 0x07)                         */
/* =========================================================  STDBR  ========================================================= */
 #define R_I3C0_STDBR_SBRLO_Pos         (0UL)          /*!< SBRLO (Bit 0)                                         */
 #define R_I3C0_STDBR_SBRLO_Msk         (0xffUL)       /*!< SBRLO (Bitfield-Mask: 0xff)                           */
 #define R_I3C0_STDBR_SBRHO_Pos         (8UL)          /*!< SBRHO (Bit 8)                                         */
 #define R_I3C0_STDBR_SBRHO_Msk         (0xff00UL)     /*!< SBRHO (Bitfield-Mask: 0xff)                           */
 #define R_I3C0_STDBR_SBRLP_Pos         (16UL)         /*!< SBRLP (Bit 16)                                        */
 #define R_I3C0_STDBR_SBRLP_Msk         (0x3f0000UL)   /*!< SBRLP (Bitfield-Mask: 0x3f)                           */
 #define R_I3C0_STDBR_SBRHP_Pos         (24UL)         /*!< SBRHP (Bit 24)                                        */
 #define R_I3C0_STDBR_SBRHP_Msk         (0x3f000000UL) /*!< SBRHP (Bitfield-Mask: 0x3f)                           */
 #define R_I3C0_STDBR_DSBRPO_Pos        (31UL)         /*!< DSBRPO (Bit 31)                                       */
 #define R_I3C0_STDBR_DSBRPO_Msk        (0x80000000UL) /*!< DSBRPO (Bitfield-Mask: 0x01)                          */
/* =========================================================  EXTBR  ========================================================= */
 #define R_I3C0_EXTBR_EBRLO_Pos         (0UL)          /*!< EBRLO (Bit 0)                                         */
 #define R_I3C0_EXTBR_EBRLO_Msk         (0xffUL)       /*!< EBRLO (Bitfield-Mask: 0xff)                           */
 #define R_I3C0_EXTBR_EBRHO_Pos         (8UL)          /*!< EBRHO (Bit 8)                                         */
 #define R_I3C0_EXTBR_EBRHO_Msk         (0xff00UL)     /*!< EBRHO (Bitfield-Mask: 0xff)                           */
 #define R_I3C0_EXTBR_EBRLP_Pos         (16UL)         /*!< EBRLP (Bit 16)                                        */
 #define R_I3C0_EXTBR_EBRLP_Msk         (0x3f0000UL)   /*!< EBRLP (Bitfield-Mask: 0x3f)                           */
 #define R_I3C0_EXTBR_EBRHP_Pos         (24UL)         /*!< EBRHP (Bit 24)                                        */
 #define R_I3C0_EXTBR_EBRHP_Msk         (0x3f000000UL) /*!< EBRHP (Bitfield-Mask: 0x3f)                           */
/* ========================================================  BFRECDT  ======================================================== */
 #define R_I3C0_BFRECDT_FRECYC_Pos      (0UL)          /*!< FRECYC (Bit 0)                                        */
 #define R_I3C0_BFRECDT_FRECYC_Msk      (0x1ffUL)      /*!< FRECYC (Bitfield-Mask: 0x1ff)                         */
/* ========================================================  BAVLCDT  ======================================================== */
 #define R_I3C0_BAVLCDT_AVLCYC_Pos      (0UL)          /*!< AVLCYC (Bit 0)                                        */
 #define R_I3C0_BAVLCDT_AVLCYC_Msk      (0x1ffUL)      /*!< AVLCYC (Bitfield-Mask: 0x1ff)                         */
/* ========================================================  BIDLCDT  ======================================================== */
 #define R_I3C0_BIDLCDT_IDLCYC_Pos      (0UL)          /*!< IDLCYC (Bit 0)                                        */
 #define R_I3C0_BIDLCDT_IDLCYC_Msk      (0x3ffffUL)    /*!< IDLCYC (Bitfield-Mask: 0x3ffff)                       */
/* ========================================================  OUTCTL  ========================================================= */
 #define R_I3C0_OUTCTL_SDOC_Pos         (0UL)          /*!< SDOC (Bit 0)                                          */
 #define R_I3C0_OUTCTL_SDOC_Msk         (0x1UL)        /*!< SDOC (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_OUTCTL_SCOC_Pos         (1UL)          /*!< SCOC (Bit 1)                                          */
 #define R_I3C0_OUTCTL_SCOC_Msk         (0x2UL)        /*!< SCOC (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_OUTCTL_SOCWP_Pos        (2UL)          /*!< SOCWP (Bit 2)                                         */
 #define R_I3C0_OUTCTL_SOCWP_Msk        (0x4UL)        /*!< SOCWP (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_OUTCTL_EXCYC_Pos        (4UL)          /*!< EXCYC (Bit 4)                                         */
 #define R_I3C0_OUTCTL_EXCYC_Msk        (0x10UL)       /*!< EXCYC (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_OUTCTL_SDOD_Pos         (8UL)          /*!< SDOD (Bit 8)                                          */
 #define R_I3C0_OUTCTL_SDOD_Msk         (0x700UL)      /*!< SDOD (Bitfield-Mask: 0x07)                            */
 #define R_I3C0_OUTCTL_SDODCS_Pos       (15UL)         /*!< SDODCS (Bit 15)                                       */
 #define R_I3C0_OUTCTL_SDODCS_Msk       (0x8000UL)     /*!< SDODCS (Bitfield-Mask: 0x01)                          */
/* =========================================================  INCTL  ========================================================= */
 #define R_I3C0_INCTL_DNFS_Pos          (0UL)          /*!< DNFS (Bit 0)                                          */
 #define R_I3C0_INCTL_DNFS_Msk          (0xfUL)        /*!< DNFS (Bitfield-Mask: 0x0f)                            */
 #define R_I3C0_INCTL_DNFE_Pos          (4UL)          /*!< DNFE (Bit 4)                                          */
 #define R_I3C0_INCTL_DNFE_Msk          (0x10UL)       /*!< DNFE (Bitfield-Mask: 0x01)                            */
/* ========================================================  TMOCTL  ========================================================= */
 #define R_I3C0_TMOCTL_TODTS_Pos        (0UL)          /*!< TODTS (Bit 0)                                         */
 #define R_I3C0_TMOCTL_TODTS_Msk        (0x3UL)        /*!< TODTS (Bitfield-Mask: 0x03)                           */
 #define R_I3C0_TMOCTL_TOLCTL_Pos       (4UL)          /*!< TOLCTL (Bit 4)                                        */
 #define R_I3C0_TMOCTL_TOLCTL_Msk       (0x10UL)       /*!< TOLCTL (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_TMOCTL_TOHCTL_Pos       (5UL)          /*!< TOHCTL (Bit 5)                                        */
 #define R_I3C0_TMOCTL_TOHCTL_Msk       (0x20UL)       /*!< TOHCTL (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_TMOCTL_TOMDS_Pos        (6UL)          /*!< TOMDS (Bit 6)                                         */
 #define R_I3C0_TMOCTL_TOMDS_Msk        (0xc0UL)       /*!< TOMDS (Bitfield-Mask: 0x03)                           */
/* =========================================================  WUCTL  ========================================================= */
 #define R_I3C0_WUCTL_WUACKS_Pos        (0UL)          /*!< WUACKS (Bit 0)                                        */
 #define R_I3C0_WUCTL_WUACKS_Msk        (0x1UL)        /*!< WUACKS (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_WUCTL_WUANFS_Pos        (4UL)          /*!< WUANFS (Bit 4)                                        */
 #define R_I3C0_WUCTL_WUANFS_Msk        (0x10UL)       /*!< WUANFS (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_WUCTL_WUFSYNE_Pos       (6UL)          /*!< WUFSYNE (Bit 6)                                       */
 #define R_I3C0_WUCTL_WUFSYNE_Msk       (0x40UL)       /*!< WUFSYNE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_WUCTL_WUFE_Pos          (7UL)          /*!< WUFE (Bit 7)                                          */
 #define R_I3C0_WUCTL_WUFE_Msk          (0x80UL)       /*!< WUFE (Bitfield-Mask: 0x01)                            */
/* ========================================================  ACKCTL  ========================================================= */
 #define R_I3C0_ACKCTL_ACKR_Pos         (0UL)          /*!< ACKR (Bit 0)                                          */
 #define R_I3C0_ACKCTL_ACKR_Msk         (0x1UL)        /*!< ACKR (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_ACKCTL_ACKT_Pos         (1UL)          /*!< ACKT (Bit 1)                                          */
 #define R_I3C0_ACKCTL_ACKT_Msk         (0x2UL)        /*!< ACKT (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_ACKCTL_ACKTWP_Pos       (2UL)          /*!< ACKTWP (Bit 2)                                        */
 #define R_I3C0_ACKCTL_ACKTWP_Msk       (0x4UL)        /*!< ACKTWP (Bitfield-Mask: 0x01)                          */
/* =======================================================  SCSTRCTL  ======================================================== */
 #define R_I3C0_SCSTRCTL_ACKTWE_Pos     (0UL)          /*!< ACKTWE (Bit 0)                                        */
 #define R_I3C0_SCSTRCTL_ACKTWE_Msk     (0x1UL)        /*!< ACKTWE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_SCSTRCTL_RWE_Pos        (1UL)          /*!< RWE (Bit 1)                                           */
 #define R_I3C0_SCSTRCTL_RWE_Msk        (0x2UL)        /*!< RWE (Bitfield-Mask: 0x01)                             */
/* =======================================================  SCSTLCTL  ======================================================== */
 #define R_I3C0_SCSTLCTL_STLCYC_Pos     (0UL)          /*!< STLCYC (Bit 0)                                        */
 #define R_I3C0_SCSTLCTL_STLCYC_Msk     (0xffffUL)     /*!< STLCYC (Bitfield-Mask: 0xffff)                        */
 #define R_I3C0_SCSTLCTL_AAPE_Pos       (28UL)         /*!< AAPE (Bit 28)                                         */
 #define R_I3C0_SCSTLCTL_AAPE_Msk       (0x10000000UL) /*!< AAPE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_SCSTLCTL_TRAPE_Pos      (29UL)         /*!< TRAPE (Bit 29)                                        */
 #define R_I3C0_SCSTLCTL_TRAPE_Msk      (0x20000000UL) /*!< TRAPE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SCSTLCTL_PARPE_Pos      (30UL)         /*!< PARPE (Bit 30)                                        */
 #define R_I3C0_SCSTLCTL_PARPE_Msk      (0x40000000UL) /*!< PARPE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SCSTLCTL_ACKPE_Pos      (31UL)         /*!< ACKPE (Bit 31)                                        */
 #define R_I3C0_SCSTLCTL_ACKPE_Msk      (0x80000000UL) /*!< ACKPE (Bitfield-Mask: 0x01)                           */
/* ========================================================  SVTDLG0  ======================================================== */
 #define R_I3C0_SVTDLG0_STDLG_Pos       (16UL)         /*!< STDLG (Bit 16)                                        */
 #define R_I3C0_SVTDLG0_STDLG_Msk       (0xffff0000UL) /*!< STDLG (Bitfield-Mask: 0xffff)                         */
/* ========================================================  CNDCTL  ========================================================= */
 #define R_I3C0_CNDCTL_STCND_Pos        (0UL)          /*!< STCND (Bit 0)                                         */
 #define R_I3C0_CNDCTL_STCND_Msk        (0x1UL)        /*!< STCND (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_CNDCTL_SRCND_Pos        (1UL)          /*!< SRCND (Bit 1)                                         */
 #define R_I3C0_CNDCTL_SRCND_Msk        (0x2UL)        /*!< SRCND (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_CNDCTL_SPCND_Pos        (2UL)          /*!< SPCND (Bit 2)                                         */
 #define R_I3C0_CNDCTL_SPCND_Msk        (0x4UL)        /*!< SPCND (Bitfield-Mask: 0x01)                           */
/* ========================================================  NCMDQP  ========================================================= */
/* ========================================================  NRSPQP  ========================================================= */
/* ========================================================  NTDTBP0  ======================================================== */
/* ========================================================  NIBIQP  ========================================================= */
/* =========================================================  NRSQP  ========================================================= */
/* ========================================================  NQTHCTL  ======================================================== */
 #define R_I3C0_NQTHCTL_CMDQTH_Pos      (0UL)          /*!< CMDQTH (Bit 0)                                        */
 #define R_I3C0_NQTHCTL_CMDQTH_Msk      (0xffUL)       /*!< CMDQTH (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_NQTHCTL_RSPQTH_Pos      (8UL)          /*!< RSPQTH (Bit 8)                                        */
 #define R_I3C0_NQTHCTL_RSPQTH_Msk      (0xff00UL)     /*!< RSPQTH (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_NQTHCTL_IBIDSSZ_Pos     (16UL)         /*!< IBIDSSZ (Bit 16)                                      */
 #define R_I3C0_NQTHCTL_IBIDSSZ_Msk     (0xff0000UL)   /*!< IBIDSSZ (Bitfield-Mask: 0xff)                         */
 #define R_I3C0_NQTHCTL_IBIQTH_Pos      (24UL)         /*!< IBIQTH (Bit 24)                                       */
 #define R_I3C0_NQTHCTL_IBIQTH_Msk      (0xff000000UL) /*!< IBIQTH (Bitfield-Mask: 0xff)                          */
/* =======================================================  NTBTHCTL0  ======================================================= */
 #define R_I3C0_NTBTHCTL0_TXDBTH_Pos    (0UL)          /*!< TXDBTH (Bit 0)                                        */
 #define R_I3C0_NTBTHCTL0_TXDBTH_Msk    (0x7UL)        /*!< TXDBTH (Bitfield-Mask: 0x07)                          */
 #define R_I3C0_NTBTHCTL0_RXDBTH_Pos    (8UL)          /*!< RXDBTH (Bit 8)                                        */
 #define R_I3C0_NTBTHCTL0_RXDBTH_Msk    (0x700UL)      /*!< RXDBTH (Bitfield-Mask: 0x07)                          */
 #define R_I3C0_NTBTHCTL0_TXSTTH_Pos    (16UL)         /*!< TXSTTH (Bit 16)                                       */
 #define R_I3C0_NTBTHCTL0_TXSTTH_Msk    (0x70000UL)    /*!< TXSTTH (Bitfield-Mask: 0x07)                          */
 #define R_I3C0_NTBTHCTL0_RXSTTH_Pos    (24UL)         /*!< RXSTTH (Bit 24)                                       */
 #define R_I3C0_NTBTHCTL0_RXSTTH_Msk    (0x7000000UL)  /*!< RXSTTH (Bitfield-Mask: 0x07)                          */
/* =======================================================  NRQTHCTL  ======================================================== */
 #define R_I3C0_NRQTHCTL_RSQTH_Pos      (0UL)          /*!< RSQTH (Bit 0)                                         */
 #define R_I3C0_NRQTHCTL_RSQTH_Msk      (0xffUL)       /*!< RSQTH (Bitfield-Mask: 0xff)                           */
/* ==========================================================  BST  ========================================================== */
 #define R_I3C0_BST_STCNDDF_Pos         (0UL)          /*!< STCNDDF (Bit 0)                                       */
 #define R_I3C0_BST_STCNDDF_Msk         (0x1UL)        /*!< STCNDDF (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BST_SPCNDDF_Pos         (1UL)          /*!< SPCNDDF (Bit 1)                                       */
 #define R_I3C0_BST_SPCNDDF_Msk         (0x2UL)        /*!< SPCNDDF (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BST_HDREXDF_Pos         (2UL)          /*!< HDREXDF (Bit 2)                                       */
 #define R_I3C0_BST_HDREXDF_Msk         (0x4UL)        /*!< HDREXDF (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BST_NACKDF_Pos          (4UL)          /*!< NACKDF (Bit 4)                                        */
 #define R_I3C0_BST_NACKDF_Msk          (0x10UL)       /*!< NACKDF (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_BST_TENDF_Pos           (8UL)          /*!< TENDF (Bit 8)                                         */
 #define R_I3C0_BST_TENDF_Msk           (0x100UL)      /*!< TENDF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_BST_ALF_Pos             (16UL)         /*!< ALF (Bit 16)                                          */
 #define R_I3C0_BST_ALF_Msk             (0x10000UL)    /*!< ALF (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_BST_TODF_Pos            (20UL)         /*!< TODF (Bit 20)                                         */
 #define R_I3C0_BST_TODF_Msk            (0x100000UL)   /*!< TODF (Bitfield-Mask: 0x01)                            */
/* =========================================================  BSTE  ========================================================== */
 #define R_I3C0_BSTE_STCNDDE_Pos        (0UL)          /*!< STCNDDE (Bit 0)                                       */
 #define R_I3C0_BSTE_STCNDDE_Msk        (0x1UL)        /*!< STCNDDE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BSTE_SPCNDDE_Pos        (1UL)          /*!< SPCNDDE (Bit 1)                                       */
 #define R_I3C0_BSTE_SPCNDDE_Msk        (0x2UL)        /*!< SPCNDDE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BSTE_HDREXDE_Pos        (2UL)          /*!< HDREXDE (Bit 2)                                       */
 #define R_I3C0_BSTE_HDREXDE_Msk        (0x4UL)        /*!< HDREXDE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BSTE_NACKDE_Pos         (4UL)          /*!< NACKDE (Bit 4)                                        */
 #define R_I3C0_BSTE_NACKDE_Msk         (0x10UL)       /*!< NACKDE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_BSTE_TENDE_Pos          (8UL)          /*!< TENDE (Bit 8)                                         */
 #define R_I3C0_BSTE_TENDE_Msk          (0x100UL)      /*!< TENDE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_BSTE_ALE_Pos            (16UL)         /*!< ALE (Bit 16)                                          */
 #define R_I3C0_BSTE_ALE_Msk            (0x10000UL)    /*!< ALE (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_BSTE_TODE_Pos           (20UL)         /*!< TODE (Bit 20)                                         */
 #define R_I3C0_BSTE_TODE_Msk           (0x100000UL)   /*!< TODE (Bitfield-Mask: 0x01)                            */
/* ==========================================================  BIE  ========================================================== */
 #define R_I3C0_BIE_STCNDDIE_Pos        (0UL)          /*!< STCNDDIE (Bit 0)                                      */
 #define R_I3C0_BIE_STCNDDIE_Msk        (0x1UL)        /*!< STCNDDIE (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BIE_SPCNDDIE_Pos        (1UL)          /*!< SPCNDDIE (Bit 1)                                      */
 #define R_I3C0_BIE_SPCNDDIE_Msk        (0x2UL)        /*!< SPCNDDIE (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BIE_HDREXDIE_Pos        (2UL)          /*!< HDREXDIE (Bit 2)                                      */
 #define R_I3C0_BIE_HDREXDIE_Msk        (0x4UL)        /*!< HDREXDIE (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BIE_NACKDIE_Pos         (4UL)          /*!< NACKDIE (Bit 4)                                       */
 #define R_I3C0_BIE_NACKDIE_Msk         (0x10UL)       /*!< NACKDIE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BIE_TENDIE_Pos          (8UL)          /*!< TENDIE (Bit 8)                                        */
 #define R_I3C0_BIE_TENDIE_Msk          (0x100UL)      /*!< TENDIE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_BIE_ALIE_Pos            (16UL)         /*!< ALIE (Bit 16)                                         */
 #define R_I3C0_BIE_ALIE_Msk            (0x10000UL)    /*!< ALIE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BIE_TODIE_Pos           (20UL)         /*!< TODIE (Bit 20)                                        */
 #define R_I3C0_BIE_TODIE_Msk           (0x100000UL)   /*!< TODIE (Bitfield-Mask: 0x01)                           */
/* =========================================================  BSTFC  ========================================================= */
 #define R_I3C0_BSTFC_STCNDDFC_Pos      (0UL)          /*!< STCNDDFC (Bit 0)                                      */
 #define R_I3C0_BSTFC_STCNDDFC_Msk      (0x1UL)        /*!< STCNDDFC (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BSTFC_SPCNDDFC_Pos      (1UL)          /*!< SPCNDDFC (Bit 1)                                      */
 #define R_I3C0_BSTFC_SPCNDDFC_Msk      (0x2UL)        /*!< SPCNDDFC (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BSTFC_HDREXDFC_Pos      (2UL)          /*!< HDREXDFC (Bit 2)                                      */
 #define R_I3C0_BSTFC_HDREXDFC_Msk      (0x4UL)        /*!< HDREXDFC (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_BSTFC_NACKDFC_Pos       (4UL)          /*!< NACKDFC (Bit 4)                                       */
 #define R_I3C0_BSTFC_NACKDFC_Msk       (0x10UL)       /*!< NACKDFC (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_BSTFC_TENDFC_Pos        (8UL)          /*!< TENDFC (Bit 8)                                        */
 #define R_I3C0_BSTFC_TENDFC_Msk        (0x100UL)      /*!< TENDFC (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_BSTFC_ALFC_Pos          (16UL)         /*!< ALFC (Bit 16)                                         */
 #define R_I3C0_BSTFC_ALFC_Msk          (0x10000UL)    /*!< ALFC (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_BSTFC_TODFC_Pos         (20UL)         /*!< TODFC (Bit 20)                                        */
 #define R_I3C0_BSTFC_TODFC_Msk         (0x100000UL)   /*!< TODFC (Bitfield-Mask: 0x01)                           */
/* =========================================================  NTST  ========================================================== */
 #define R_I3C0_NTST_TDBEF0_Pos         (0UL)          /*!< TDBEF0 (Bit 0)                                        */
 #define R_I3C0_NTST_TDBEF0_Msk         (0x1UL)        /*!< TDBEF0 (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTST_RDBFF0_Pos         (1UL)          /*!< RDBFF0 (Bit 1)                                        */
 #define R_I3C0_NTST_RDBFF0_Msk         (0x2UL)        /*!< RDBFF0 (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTST_IBIQEFF_Pos        (2UL)          /*!< IBIQEFF (Bit 2)                                       */
 #define R_I3C0_NTST_IBIQEFF_Msk        (0x4UL)        /*!< IBIQEFF (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTST_CMDQEF_Pos         (3UL)          /*!< CMDQEF (Bit 3)                                        */
 #define R_I3C0_NTST_CMDQEF_Msk         (0x8UL)        /*!< CMDQEF (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTST_RSPQFF_Pos         (4UL)          /*!< RSPQFF (Bit 4)                                        */
 #define R_I3C0_NTST_RSPQFF_Msk         (0x10UL)       /*!< RSPQFF (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTST_TABTF_Pos          (5UL)          /*!< TABTF (Bit 5)                                         */
 #define R_I3C0_NTST_TABTF_Msk          (0x20UL)       /*!< TABTF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_NTST_TEF_Pos            (9UL)          /*!< TEF (Bit 9)                                           */
 #define R_I3C0_NTST_TEF_Msk            (0x200UL)      /*!< TEF (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_NTST_RSQFF_Pos          (20UL)         /*!< RSQFF (Bit 20)                                        */
 #define R_I3C0_NTST_RSQFF_Msk          (0x100000UL)   /*!< RSQFF (Bitfield-Mask: 0x01)                           */
/* =========================================================  NTSTE  ========================================================= */
 #define R_I3C0_NTSTE_TDBEE0_Pos        (0UL)          /*!< TDBEE0 (Bit 0)                                        */
 #define R_I3C0_NTSTE_TDBEE0_Msk        (0x1UL)        /*!< TDBEE0 (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTSTE_RDBFE0_Pos        (1UL)          /*!< RDBFE0 (Bit 1)                                        */
 #define R_I3C0_NTSTE_RDBFE0_Msk        (0x2UL)        /*!< RDBFE0 (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTSTE_IBIQEFE_Pos       (2UL)          /*!< IBIQEFE (Bit 2)                                       */
 #define R_I3C0_NTSTE_IBIQEFE_Msk       (0x4UL)        /*!< IBIQEFE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTSTE_CMDQEE_Pos        (3UL)          /*!< CMDQEE (Bit 3)                                        */
 #define R_I3C0_NTSTE_CMDQEE_Msk        (0x8UL)        /*!< CMDQEE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTSTE_RSPQFE_Pos        (4UL)          /*!< RSPQFE (Bit 4)                                        */
 #define R_I3C0_NTSTE_RSPQFE_Msk        (0x10UL)       /*!< RSPQFE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTSTE_TABTE_Pos         (5UL)          /*!< TABTE (Bit 5)                                         */
 #define R_I3C0_NTSTE_TABTE_Msk         (0x20UL)       /*!< TABTE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_NTSTE_TEE_Pos           (9UL)          /*!< TEE (Bit 9)                                           */
 #define R_I3C0_NTSTE_TEE_Msk           (0x200UL)      /*!< TEE (Bitfield-Mask: 0x01)                             */
 #define R_I3C0_NTSTE_RSQFE_Pos         (20UL)         /*!< RSQFE (Bit 20)                                        */
 #define R_I3C0_NTSTE_RSQFE_Msk         (0x100000UL)   /*!< RSQFE (Bitfield-Mask: 0x01)                           */
/* =========================================================  NTIE  ========================================================== */
 #define R_I3C0_NTIE_TDBEIE0_Pos        (0UL)          /*!< TDBEIE0 (Bit 0)                                       */
 #define R_I3C0_NTIE_TDBEIE0_Msk        (0x1UL)        /*!< TDBEIE0 (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTIE_RDBFIE0_Pos        (1UL)          /*!< RDBFIE0 (Bit 1)                                       */
 #define R_I3C0_NTIE_RDBFIE0_Msk        (0x2UL)        /*!< RDBFIE0 (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTIE_IBIQEFIE_Pos       (2UL)          /*!< IBIQEFIE (Bit 2)                                      */
 #define R_I3C0_NTIE_IBIQEFIE_Msk       (0x4UL)        /*!< IBIQEFIE (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_NTIE_CMDQEIE_Pos        (3UL)          /*!< CMDQEIE (Bit 3)                                       */
 #define R_I3C0_NTIE_CMDQEIE_Msk        (0x8UL)        /*!< CMDQEIE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTIE_RSPQFIE_Pos        (4UL)          /*!< RSPQFIE (Bit 4)                                       */
 #define R_I3C0_NTIE_RSPQFIE_Msk        (0x10UL)       /*!< RSPQFIE (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTIE_TABTIE_Pos         (5UL)          /*!< TABTIE (Bit 5)                                        */
 #define R_I3C0_NTIE_TABTIE_Msk         (0x20UL)       /*!< TABTIE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTIE_TEIE_Pos           (9UL)          /*!< TEIE (Bit 9)                                          */
 #define R_I3C0_NTIE_TEIE_Msk           (0x200UL)      /*!< TEIE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_NTIE_RSQFIE_Pos         (20UL)         /*!< RSQFIE (Bit 20)                                       */
 #define R_I3C0_NTIE_RSQFIE_Msk         (0x100000UL)   /*!< RSQFIE (Bitfield-Mask: 0x01)                          */
/* ========================================================  NTSTFC  ========================================================= */
 #define R_I3C0_NTSTFC_TDBEFC0_Pos      (0UL)          /*!< TDBEFC0 (Bit 0)                                       */
 #define R_I3C0_NTSTFC_TDBEFC0_Msk      (0x1UL)        /*!< TDBEFC0 (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTSTFC_RDBFFC0_Pos      (1UL)          /*!< RDBFFC0 (Bit 1)                                       */
 #define R_I3C0_NTSTFC_RDBFFC0_Msk      (0x2UL)        /*!< RDBFFC0 (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTSTFC_IBIQEFFC_Pos     (2UL)          /*!< IBIQEFFC (Bit 2)                                      */
 #define R_I3C0_NTSTFC_IBIQEFFC_Msk     (0x4UL)        /*!< IBIQEFFC (Bitfield-Mask: 0x01)                        */
 #define R_I3C0_NTSTFC_CMDQEFC_Pos      (3UL)          /*!< CMDQEFC (Bit 3)                                       */
 #define R_I3C0_NTSTFC_CMDQEFC_Msk      (0x8UL)        /*!< CMDQEFC (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTSTFC_RSPQFFC_Pos      (4UL)          /*!< RSPQFFC (Bit 4)                                       */
 #define R_I3C0_NTSTFC_RSPQFFC_Msk      (0x10UL)       /*!< RSPQFFC (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_NTSTFC_TABTFC_Pos       (5UL)          /*!< TABTFC (Bit 5)                                        */
 #define R_I3C0_NTSTFC_TABTFC_Msk       (0x20UL)       /*!< TABTFC (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_NTSTFC_TEFC_Pos         (9UL)          /*!< TEFC (Bit 9)                                          */
 #define R_I3C0_NTSTFC_TEFC_Msk         (0x200UL)      /*!< TEFC (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_NTSTFC_RSQFFC_Pos       (20UL)         /*!< RSQFFC (Bit 20)                                       */
 #define R_I3C0_NTSTFC_RSQFFC_Msk       (0x100000UL)   /*!< RSQFFC (Bitfield-Mask: 0x01)                          */
/* =========================================================  BCST  ========================================================== */
 #define R_I3C0_BCST_BFREF_Pos          (0UL)          /*!< BFREF (Bit 0)                                         */
 #define R_I3C0_BCST_BFREF_Msk          (0x1UL)        /*!< BFREF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_BCST_BAVLF_Pos          (1UL)          /*!< BAVLF (Bit 1)                                         */
 #define R_I3C0_BCST_BAVLF_Msk          (0x2UL)        /*!< BAVLF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_BCST_BIDLF_Pos          (2UL)          /*!< BIDLF (Bit 2)                                         */
 #define R_I3C0_BCST_BIDLF_Msk          (0x4UL)        /*!< BIDLF (Bitfield-Mask: 0x01)                           */
/* =========================================================  SVST  ========================================================== */
 #define R_I3C0_SVST_GCAF_Pos           (0UL)          /*!< GCAF (Bit 0)                                          */
 #define R_I3C0_SVST_GCAF_Msk           (0x1UL)        /*!< GCAF (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_SVST_HSMCF_Pos          (5UL)          /*!< HSMCF (Bit 5)                                         */
 #define R_I3C0_SVST_HSMCF_Msk          (0x20UL)       /*!< HSMCF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVST_DVIDF_Pos          (6UL)          /*!< DVIDF (Bit 6)                                         */
 #define R_I3C0_SVST_DVIDF_Msk          (0x40UL)       /*!< DVIDF (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVST_HOAF_Pos           (15UL)         /*!< HOAF (Bit 15)                                         */
 #define R_I3C0_SVST_HOAF_Msk           (0x8000UL)     /*!< HOAF (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_SVST_SVAFn_Pos          (16UL)         /*!< SVAFn (Bit 16)                                        */
 #define R_I3C0_SVST_SVAFn_Msk          (0x10000UL)    /*!< SVAFn (Bitfield-Mask: 0x01)                           */
/* =========================================================  WUST  ========================================================== */
 #define R_I3C0_WUST_WUASYNF_Pos        (0UL)          /*!< WUASYNF (Bit 0)                                       */
 #define R_I3C0_WUST_WUASYNF_Msk        (0x1UL)        /*!< WUASYNF (Bitfield-Mask: 0x01)                         */
/* ========================================================  DATBAS0  ======================================================== */
 #define R_I3C0_DATBAS0_DVSTAD_Pos      (0UL)          /*!< DVSTAD (Bit 0)                                        */
 #define R_I3C0_DATBAS0_DVSTAD_Msk      (0x7fUL)       /*!< DVSTAD (Bitfield-Mask: 0x7f)                          */
 #define R_I3C0_DATBAS0_DVIBIPL_Pos     (12UL)         /*!< DVIBIPL (Bit 12)                                      */
 #define R_I3C0_DATBAS0_DVIBIPL_Msk     (0x1000UL)     /*!< DVIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS0_DVSIRRJ_Pos     (13UL)         /*!< DVSIRRJ (Bit 13)                                      */
 #define R_I3C0_DATBAS0_DVSIRRJ_Msk     (0x2000UL)     /*!< DVSIRRJ (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS0_DVMRRJ_Pos      (14UL)         /*!< DVMRRJ (Bit 14)                                       */
 #define R_I3C0_DATBAS0_DVMRRJ_Msk      (0x4000UL)     /*!< DVMRRJ (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_DATBAS0_DVIBITS_Pos     (15UL)         /*!< DVIBITS (Bit 15)                                      */
 #define R_I3C0_DATBAS0_DVIBITS_Msk     (0x8000UL)     /*!< DVIBITS (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS0_DVDYAD_Pos      (16UL)         /*!< DVDYAD (Bit 16)                                       */
 #define R_I3C0_DATBAS0_DVDYAD_Msk      (0xff0000UL)   /*!< DVDYAD (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_DATBAS0_DVNACK_Pos      (29UL)         /*!< DVNACK (Bit 29)                                       */
 #define R_I3C0_DATBAS0_DVNACK_Msk      (0x60000000UL) /*!< DVNACK (Bitfield-Mask: 0x03)                          */
 #define R_I3C0_DATBAS0_DVTYP_Pos       (31UL)         /*!< DVTYP (Bit 31)                                        */
 #define R_I3C0_DATBAS0_DVTYP_Msk       (0x80000000UL) /*!< DVTYP (Bitfield-Mask: 0x01)                           */
/* ========================================================  DATBAS1  ======================================================== */
 #define R_I3C0_DATBAS1_DVSTAD_Pos      (0UL)          /*!< DVSTAD (Bit 0)                                        */
 #define R_I3C0_DATBAS1_DVSTAD_Msk      (0x7fUL)       /*!< DVSTAD (Bitfield-Mask: 0x7f)                          */
 #define R_I3C0_DATBAS1_DVIBIPL_Pos     (12UL)         /*!< DVIBIPL (Bit 12)                                      */
 #define R_I3C0_DATBAS1_DVIBIPL_Msk     (0x1000UL)     /*!< DVIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS1_DVSIRRJ_Pos     (13UL)         /*!< DVSIRRJ (Bit 13)                                      */
 #define R_I3C0_DATBAS1_DVSIRRJ_Msk     (0x2000UL)     /*!< DVSIRRJ (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS1_DVMRRJ_Pos      (14UL)         /*!< DVMRRJ (Bit 14)                                       */
 #define R_I3C0_DATBAS1_DVMRRJ_Msk      (0x4000UL)     /*!< DVMRRJ (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_DATBAS1_DVIBITS_Pos     (15UL)         /*!< DVIBITS (Bit 15)                                      */
 #define R_I3C0_DATBAS1_DVIBITS_Msk     (0x8000UL)     /*!< DVIBITS (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS1_DVDYAD_Pos      (16UL)         /*!< DVDYAD (Bit 16)                                       */
 #define R_I3C0_DATBAS1_DVDYAD_Msk      (0xff0000UL)   /*!< DVDYAD (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_DATBAS1_DVNACK_Pos      (29UL)         /*!< DVNACK (Bit 29)                                       */
 #define R_I3C0_DATBAS1_DVNACK_Msk      (0x60000000UL) /*!< DVNACK (Bitfield-Mask: 0x03)                          */
 #define R_I3C0_DATBAS1_DVTYP_Pos       (31UL)         /*!< DVTYP (Bit 31)                                        */
 #define R_I3C0_DATBAS1_DVTYP_Msk       (0x80000000UL) /*!< DVTYP (Bitfield-Mask: 0x01)                           */
/* ========================================================  DATBAS2  ======================================================== */
 #define R_I3C0_DATBAS2_DVSTAD_Pos      (0UL)          /*!< DVSTAD (Bit 0)                                        */
 #define R_I3C0_DATBAS2_DVSTAD_Msk      (0x7fUL)       /*!< DVSTAD (Bitfield-Mask: 0x7f)                          */
 #define R_I3C0_DATBAS2_DVIBIPL_Pos     (12UL)         /*!< DVIBIPL (Bit 12)                                      */
 #define R_I3C0_DATBAS2_DVIBIPL_Msk     (0x1000UL)     /*!< DVIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS2_DVSIRRJ_Pos     (13UL)         /*!< DVSIRRJ (Bit 13)                                      */
 #define R_I3C0_DATBAS2_DVSIRRJ_Msk     (0x2000UL)     /*!< DVSIRRJ (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS2_DVMRRJ_Pos      (14UL)         /*!< DVMRRJ (Bit 14)                                       */
 #define R_I3C0_DATBAS2_DVMRRJ_Msk      (0x4000UL)     /*!< DVMRRJ (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_DATBAS2_DVIBITS_Pos     (15UL)         /*!< DVIBITS (Bit 15)                                      */
 #define R_I3C0_DATBAS2_DVIBITS_Msk     (0x8000UL)     /*!< DVIBITS (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS2_DVDYAD_Pos      (16UL)         /*!< DVDYAD (Bit 16)                                       */
 #define R_I3C0_DATBAS2_DVDYAD_Msk      (0xff0000UL)   /*!< DVDYAD (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_DATBAS2_DVNACK_Pos      (29UL)         /*!< DVNACK (Bit 29)                                       */
 #define R_I3C0_DATBAS2_DVNACK_Msk      (0x60000000UL) /*!< DVNACK (Bitfield-Mask: 0x03)                          */
 #define R_I3C0_DATBAS2_DVTYP_Pos       (31UL)         /*!< DVTYP (Bit 31)                                        */
 #define R_I3C0_DATBAS2_DVTYP_Msk       (0x80000000UL) /*!< DVTYP (Bitfield-Mask: 0x01)                           */
/* ========================================================  DATBAS3  ======================================================== */
 #define R_I3C0_DATBAS3_DVSTAD_Pos      (0UL)          /*!< DVSTAD (Bit 0)                                        */
 #define R_I3C0_DATBAS3_DVSTAD_Msk      (0x7fUL)       /*!< DVSTAD (Bitfield-Mask: 0x7f)                          */
 #define R_I3C0_DATBAS3_DVIBIPL_Pos     (12UL)         /*!< DVIBIPL (Bit 12)                                      */
 #define R_I3C0_DATBAS3_DVIBIPL_Msk     (0x1000UL)     /*!< DVIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS3_DVSIRRJ_Pos     (13UL)         /*!< DVSIRRJ (Bit 13)                                      */
 #define R_I3C0_DATBAS3_DVSIRRJ_Msk     (0x2000UL)     /*!< DVSIRRJ (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS3_DVMRRJ_Pos      (14UL)         /*!< DVMRRJ (Bit 14)                                       */
 #define R_I3C0_DATBAS3_DVMRRJ_Msk      (0x4000UL)     /*!< DVMRRJ (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_DATBAS3_DVIBITS_Pos     (15UL)         /*!< DVIBITS (Bit 15)                                      */
 #define R_I3C0_DATBAS3_DVIBITS_Msk     (0x8000UL)     /*!< DVIBITS (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_DATBAS3_DVDYAD_Pos      (16UL)         /*!< DVDYAD (Bit 16)                                       */
 #define R_I3C0_DATBAS3_DVDYAD_Msk      (0xff0000UL)   /*!< DVDYAD (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_DATBAS3_DVNACK_Pos      (29UL)         /*!< DVNACK (Bit 29)                                       */
 #define R_I3C0_DATBAS3_DVNACK_Msk      (0x60000000UL) /*!< DVNACK (Bitfield-Mask: 0x03)                          */
 #define R_I3C0_DATBAS3_DVTYP_Pos       (31UL)         /*!< DVTYP (Bit 31)                                        */
 #define R_I3C0_DATBAS3_DVTYP_Msk       (0x80000000UL) /*!< DVTYP (Bitfield-Mask: 0x01)                           */
/* =======================================================  EXDATBAS  ======================================================== */
 #define R_I3C0_EXDATBAS_EDSTAD_Pos     (0UL)          /*!< EDSTAD (Bit 0)                                        */
 #define R_I3C0_EXDATBAS_EDSTAD_Msk     (0x7fUL)       /*!< EDSTAD (Bitfield-Mask: 0x7f)                          */
 #define R_I3C0_EXDATBAS_EDDYAD_Pos     (16UL)         /*!< EDDYAD (Bit 16)                                       */
 #define R_I3C0_EXDATBAS_EDDYAD_Msk     (0xff0000UL)   /*!< EDDYAD (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_EXDATBAS_EDNACK_Pos     (29UL)         /*!< EDNACK (Bit 29)                                       */
 #define R_I3C0_EXDATBAS_EDNACK_Msk     (0x60000000UL) /*!< EDNACK (Bitfield-Mask: 0x03)                          */
 #define R_I3C0_EXDATBAS_EDTYP_Pos      (31UL)         /*!< EDTYP (Bit 31)                                        */
 #define R_I3C0_EXDATBAS_EDTYP_Msk      (0x80000000UL) /*!< EDTYP (Bitfield-Mask: 0x01)                           */
/* =======================================================  SDATBAS0  ======================================================== */
 #define R_I3C0_SDATBAS0_SDSTAD_Pos     (0UL)          /*!< SDSTAD (Bit 0)                                        */
 #define R_I3C0_SDATBAS0_SDSTAD_Msk     (0x3ffUL)      /*!< SDSTAD (Bitfield-Mask: 0x3ff)                         */
 #define R_I3C0_SDATBAS0_SDADLS_Pos     (10UL)         /*!< SDADLS (Bit 10)                                       */
 #define R_I3C0_SDATBAS0_SDADLS_Msk     (0x400UL)      /*!< SDADLS (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_SDATBAS0_SDIBIPL_Pos    (12UL)         /*!< SDIBIPL (Bit 12)                                      */
 #define R_I3C0_SDATBAS0_SDIBIPL_Msk    (0x1000UL)     /*!< SDIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_SDATBAS0_SDDYAD_Pos     (16UL)         /*!< SDDYAD (Bit 16)                                       */
 #define R_I3C0_SDATBAS0_SDDYAD_Msk     (0x7f0000UL)   /*!< SDDYAD (Bitfield-Mask: 0x7f)                          */
/* =======================================================  SDATBAS1  ======================================================== */
 #define R_I3C0_SDATBAS1_SDSTAD_Pos     (0UL)          /*!< SDSTAD (Bit 0)                                        */
 #define R_I3C0_SDATBAS1_SDSTAD_Msk     (0x3ffUL)      /*!< SDSTAD (Bitfield-Mask: 0x3ff)                         */
 #define R_I3C0_SDATBAS1_SDADLS_Pos     (10UL)         /*!< SDADLS (Bit 10)                                       */
 #define R_I3C0_SDATBAS1_SDADLS_Msk     (0x400UL)      /*!< SDADLS (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_SDATBAS1_SDIBIPL_Pos    (12UL)         /*!< SDIBIPL (Bit 12)                                      */
 #define R_I3C0_SDATBAS1_SDIBIPL_Msk    (0x1000UL)     /*!< SDIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_SDATBAS1_SDDYAD_Pos     (16UL)         /*!< SDDYAD (Bit 16)                                       */
 #define R_I3C0_SDATBAS1_SDDYAD_Msk     (0x7f0000UL)   /*!< SDDYAD (Bitfield-Mask: 0x7f)                          */
/* =======================================================  SDATBAS2  ======================================================== */
 #define R_I3C0_SDATBAS2_SDSTAD_Pos     (0UL)          /*!< SDSTAD (Bit 0)                                        */
 #define R_I3C0_SDATBAS2_SDSTAD_Msk     (0x3ffUL)      /*!< SDSTAD (Bitfield-Mask: 0x3ff)                         */
 #define R_I3C0_SDATBAS2_SDADLS_Pos     (10UL)         /*!< SDADLS (Bit 10)                                       */
 #define R_I3C0_SDATBAS2_SDADLS_Msk     (0x400UL)      /*!< SDADLS (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_SDATBAS2_SDIBIPL_Pos    (12UL)         /*!< SDIBIPL (Bit 12)                                      */
 #define R_I3C0_SDATBAS2_SDIBIPL_Msk    (0x1000UL)     /*!< SDIBIPL (Bitfield-Mask: 0x01)                         */
 #define R_I3C0_SDATBAS2_SDDYAD_Pos     (16UL)         /*!< SDDYAD (Bit 16)                                       */
 #define R_I3C0_SDATBAS2_SDDYAD_Msk     (0x7f0000UL)   /*!< SDDYAD (Bitfield-Mask: 0x7f)                          */
/* ========================================================  MSDCT0  ========================================================= */
 #define R_I3C0_MSDCT0_RBCR0_Pos        (8UL)          /*!< RBCR0 (Bit 8)                                         */
 #define R_I3C0_MSDCT0_RBCR0_Msk        (0x100UL)      /*!< RBCR0 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT0_RBCR1_Pos        (9UL)          /*!< RBCR1 (Bit 9)                                         */
 #define R_I3C0_MSDCT0_RBCR1_Msk        (0x200UL)      /*!< RBCR1 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT0_RBCR2_Pos        (10UL)         /*!< RBCR2 (Bit 10)                                        */
 #define R_I3C0_MSDCT0_RBCR2_Msk        (0x400UL)      /*!< RBCR2 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT0_RBCR3_Pos        (11UL)         /*!< RBCR3 (Bit 11)                                        */
 #define R_I3C0_MSDCT0_RBCR3_Msk        (0x800UL)      /*!< RBCR3 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT0_RBCR76_Pos       (14UL)         /*!< RBCR76 (Bit 14)                                       */
 #define R_I3C0_MSDCT0_RBCR76_Msk       (0xc000UL)     /*!< RBCR76 (Bitfield-Mask: 0x03)                          */
/* ========================================================  MSDCT1  ========================================================= */
 #define R_I3C0_MSDCT1_RBCR0_Pos        (8UL)          /*!< RBCR0 (Bit 8)                                         */
 #define R_I3C0_MSDCT1_RBCR0_Msk        (0x100UL)      /*!< RBCR0 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT1_RBCR1_Pos        (9UL)          /*!< RBCR1 (Bit 9)                                         */
 #define R_I3C0_MSDCT1_RBCR1_Msk        (0x200UL)      /*!< RBCR1 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT1_RBCR2_Pos        (10UL)         /*!< RBCR2 (Bit 10)                                        */
 #define R_I3C0_MSDCT1_RBCR2_Msk        (0x400UL)      /*!< RBCR2 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT1_RBCR3_Pos        (11UL)         /*!< RBCR3 (Bit 11)                                        */
 #define R_I3C0_MSDCT1_RBCR3_Msk        (0x800UL)      /*!< RBCR3 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT1_RBCR76_Pos       (14UL)         /*!< RBCR76 (Bit 14)                                       */
 #define R_I3C0_MSDCT1_RBCR76_Msk       (0xc000UL)     /*!< RBCR76 (Bitfield-Mask: 0x03)                          */
/* ========================================================  MSDCT2  ========================================================= */
 #define R_I3C0_MSDCT2_RBCR0_Pos        (8UL)          /*!< RBCR0 (Bit 8)                                         */
 #define R_I3C0_MSDCT2_RBCR0_Msk        (0x100UL)      /*!< RBCR0 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT2_RBCR1_Pos        (9UL)          /*!< RBCR1 (Bit 9)                                         */
 #define R_I3C0_MSDCT2_RBCR1_Msk        (0x200UL)      /*!< RBCR1 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT2_RBCR2_Pos        (10UL)         /*!< RBCR2 (Bit 10)                                        */
 #define R_I3C0_MSDCT2_RBCR2_Msk        (0x400UL)      /*!< RBCR2 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT2_RBCR3_Pos        (11UL)         /*!< RBCR3 (Bit 11)                                        */
 #define R_I3C0_MSDCT2_RBCR3_Msk        (0x800UL)      /*!< RBCR3 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT2_RBCR76_Pos       (14UL)         /*!< RBCR76 (Bit 14)                                       */
 #define R_I3C0_MSDCT2_RBCR76_Msk       (0xc000UL)     /*!< RBCR76 (Bitfield-Mask: 0x03)                          */
/* ========================================================  MSDCT3  ========================================================= */
 #define R_I3C0_MSDCT3_RBCR0_Pos        (8UL)          /*!< RBCR0 (Bit 8)                                         */
 #define R_I3C0_MSDCT3_RBCR0_Msk        (0x100UL)      /*!< RBCR0 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT3_RBCR1_Pos        (9UL)          /*!< RBCR1 (Bit 9)                                         */
 #define R_I3C0_MSDCT3_RBCR1_Msk        (0x200UL)      /*!< RBCR1 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT3_RBCR2_Pos        (10UL)         /*!< RBCR2 (Bit 10)                                        */
 #define R_I3C0_MSDCT3_RBCR2_Msk        (0x400UL)      /*!< RBCR2 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT3_RBCR3_Pos        (11UL)         /*!< RBCR3 (Bit 11)                                        */
 #define R_I3C0_MSDCT3_RBCR3_Msk        (0x800UL)      /*!< RBCR3 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_MSDCT3_RBCR76_Pos       (14UL)         /*!< RBCR76 (Bit 14)                                       */
 #define R_I3C0_MSDCT3_RBCR76_Msk       (0xc000UL)     /*!< RBCR76 (Bitfield-Mask: 0x03)                          */
/* =========================================================  SVDCT  ========================================================= */
 #define R_I3C0_SVDCT_TDCR_Pos          (0UL)          /*!< TDCR (Bit 0)                                          */
 #define R_I3C0_SVDCT_TDCR_Msk          (0xffUL)       /*!< TDCR (Bitfield-Mask: 0xff)                            */
 #define R_I3C0_SVDCT_TBCR0_Pos         (8UL)          /*!< TBCR0 (Bit 8)                                         */
 #define R_I3C0_SVDCT_TBCR0_Msk         (0x100UL)      /*!< TBCR0 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVDCT_TBCR1_Pos         (9UL)          /*!< TBCR1 (Bit 9)                                         */
 #define R_I3C0_SVDCT_TBCR1_Msk         (0x200UL)      /*!< TBCR1 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVDCT_TBCR2_Pos         (10UL)         /*!< TBCR2 (Bit 10)                                        */
 #define R_I3C0_SVDCT_TBCR2_Msk         (0x400UL)      /*!< TBCR2 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVDCT_TBCR3_Pos         (11UL)         /*!< TBCR3 (Bit 11)                                        */
 #define R_I3C0_SVDCT_TBCR3_Msk         (0x800UL)      /*!< TBCR3 (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVDCT_TBCR76_Pos        (14UL)         /*!< TBCR76 (Bit 14)                                       */
 #define R_I3C0_SVDCT_TBCR76_Msk        (0xc000UL)     /*!< TBCR76 (Bitfield-Mask: 0x03)                          */
/* =======================================================  SDCTPIDL  ======================================================== */
/* =======================================================  SDCTPIDH  ======================================================== */
/* ========================================================  SVDVAD0  ======================================================== */
 #define R_I3C0_SVDVAD0_SVAD_Pos        (16UL)         /*!< SVAD (Bit 16)                                         */
 #define R_I3C0_SVDVAD0_SVAD_Msk        (0x3ff0000UL)  /*!< SVAD (Bitfield-Mask: 0x3ff)                           */
 #define R_I3C0_SVDVAD0_SADLG_Pos       (27UL)         /*!< SADLG (Bit 27)                                        */
 #define R_I3C0_SVDVAD0_SADLG_Msk       (0x8000000UL)  /*!< SADLG (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_SVDVAD0_SSTADV_Pos      (30UL)         /*!< SSTADV (Bit 30)                                       */
 #define R_I3C0_SVDVAD0_SSTADV_Msk      (0x40000000UL) /*!< SSTADV (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_SVDVAD0_SDYADV_Pos      (31UL)         /*!< SDYADV (Bit 31)                                       */
 #define R_I3C0_SVDVAD0_SDYADV_Msk      (0x80000000UL) /*!< SDYADV (Bitfield-Mask: 0x01)                          */
/* ========================================================  CSECMD  ========================================================= */
 #define R_I3C0_CSECMD_SVIRQE_Pos       (0UL)          /*!< SVIRQE (Bit 0)                                        */
 #define R_I3C0_CSECMD_SVIRQE_Msk       (0x1UL)        /*!< SVIRQE (Bitfield-Mask: 0x01)                          */
 #define R_I3C0_CSECMD_MSRQE_Pos        (1UL)          /*!< MSRQE (Bit 1)                                         */
 #define R_I3C0_CSECMD_MSRQE_Msk        (0x2UL)        /*!< MSRQE (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_CSECMD_HJEVE_Pos        (3UL)          /*!< HJEVE (Bit 3)                                         */
 #define R_I3C0_CSECMD_HJEVE_Msk        (0x8UL)        /*!< HJEVE (Bitfield-Mask: 0x01)                           */
/* ========================================================  CEACTST  ======================================================== */
 #define R_I3C0_CEACTST_ACTST_Pos       (0UL)          /*!< ACTST (Bit 0)                                         */
 #define R_I3C0_CEACTST_ACTST_Msk       (0xfUL)        /*!< ACTST (Bitfield-Mask: 0x0f)                           */
/* =========================================================  CMWLG  ========================================================= */
 #define R_I3C0_CMWLG_MWLG_Pos          (0UL)          /*!< MWLG (Bit 0)                                          */
 #define R_I3C0_CMWLG_MWLG_Msk          (0xffffUL)     /*!< MWLG (Bitfield-Mask: 0xffff)                          */
/* =========================================================  CMRLG  ========================================================= */
 #define R_I3C0_CMRLG_MRLG_Pos          (0UL)          /*!< MRLG (Bit 0)                                          */
 #define R_I3C0_CMRLG_MRLG_Msk          (0xffffUL)     /*!< MRLG (Bitfield-Mask: 0xffff)                          */
 #define R_I3C0_CMRLG_IBIPSZ_Pos        (16UL)         /*!< IBIPSZ (Bit 16)                                       */
 #define R_I3C0_CMRLG_IBIPSZ_Msk        (0xff0000UL)   /*!< IBIPSZ (Bitfield-Mask: 0xff)                          */
/* ========================================================  CETSTMD  ======================================================== */
 #define R_I3C0_CETSTMD_TSTMD_Pos       (0UL)          /*!< TSTMD (Bit 0)                                         */
 #define R_I3C0_CETSTMD_TSTMD_Msk       (0xffUL)       /*!< TSTMD (Bitfield-Mask: 0xff)                           */
/* ========================================================  CGDVST  ========================================================= */
 #define R_I3C0_CGDVST_PNDINT_Pos       (0UL)          /*!< PNDINT (Bit 0)                                        */
 #define R_I3C0_CGDVST_PNDINT_Msk       (0xfUL)        /*!< PNDINT (Bitfield-Mask: 0x0f)                          */
 #define R_I3C0_CGDVST_PRTE_Pos         (5UL)          /*!< PRTE (Bit 5)                                          */
 #define R_I3C0_CGDVST_PRTE_Msk         (0x20UL)       /*!< PRTE (Bitfield-Mask: 0x01)                            */
 #define R_I3C0_CGDVST_ACTMD_Pos        (6UL)          /*!< ACTMD (Bit 6)                                         */
 #define R_I3C0_CGDVST_ACTMD_Msk        (0xc0UL)       /*!< ACTMD (Bitfield-Mask: 0x03)                           */
 #define R_I3C0_CGDVST_VDRSV_Pos        (8UL)          /*!< VDRSV (Bit 8)                                         */
 #define R_I3C0_CGDVST_VDRSV_Msk        (0xff00UL)     /*!< VDRSV (Bitfield-Mask: 0xff)                           */
/* ========================================================  CMDSPW  ========================================================= */
 #define R_I3C0_CMDSPW_MSWDR_Pos        (0UL)          /*!< MSWDR (Bit 0)                                         */
 #define R_I3C0_CMDSPW_MSWDR_Msk        (0x7UL)        /*!< MSWDR (Bitfield-Mask: 0x07)                           */
/* ========================================================  CMDSPR  ========================================================= */
 #define R_I3C0_CMDSPR_MSRDR_Pos        (0UL)          /*!< MSRDR (Bit 0)                                         */
 #define R_I3C0_CMDSPR_MSRDR_Msk        (0x7UL)        /*!< MSRDR (Bitfield-Mask: 0x07)                           */
 #define R_I3C0_CMDSPR_CDTTIM_Pos       (3UL)          /*!< CDTTIM (Bit 3)                                        */
 #define R_I3C0_CMDSPR_CDTTIM_Msk       (0x38UL)       /*!< CDTTIM (Bitfield-Mask: 0x07)                          */
/* ========================================================  CMDSPT  ========================================================= */
 #define R_I3C0_CMDSPT_MRTTIM_Pos       (0UL)          /*!< MRTTIM (Bit 0)                                        */
 #define R_I3C0_CMDSPT_MRTTIM_Msk       (0xffffffUL)   /*!< MRTTIM (Bitfield-Mask: 0xffffff)                      */
 #define R_I3C0_CMDSPT_MRTE_Pos         (31UL)         /*!< MRTE (Bit 31)                                         */
 #define R_I3C0_CMDSPT_MRTE_Msk         (0x80000000UL) /*!< MRTE (Bitfield-Mask: 0x01)                            */
/* =========================================================  CETSM  ========================================================= */
 #define R_I3C0_CETSM_FREQ_Pos          (8UL)          /*!< FREQ (Bit 8)                                          */
 #define R_I3C0_CETSM_FREQ_Msk          (0xff00UL)     /*!< FREQ (Bitfield-Mask: 0xff)                            */
 #define R_I3C0_CETSM_INAC_Pos          (16UL)         /*!< INAC (Bit 16)                                         */
 #define R_I3C0_CETSM_INAC_Msk          (0xff0000UL)   /*!< INAC (Bitfield-Mask: 0xff)                            */
/* ========================================================  BITCNT  ========================================================= */
 #define R_I3C0_BITCNT_BCNT_Pos         (0UL)          /*!< BCNT (Bit 0)                                          */
 #define R_I3C0_BITCNT_BCNT_Msk         (0x1fUL)       /*!< BCNT (Bitfield-Mask: 0x1f)                            */
 #define R_I3C0_BITCNT_BCNTWP_Pos       (7UL)          /*!< BCNTWP (Bit 7)                                        */
 #define R_I3C0_BITCNT_BCNTWP_Msk       (0x80UL)       /*!< BCNTWP (Bitfield-Mask: 0x01)                          */
/* ========================================================  NQSTLV  ========================================================= */
 #define R_I3C0_NQSTLV_CMDQFLV_Pos      (0UL)          /*!< CMDQFLV (Bit 0)                                       */
 #define R_I3C0_NQSTLV_CMDQFLV_Msk      (0xffUL)       /*!< CMDQFLV (Bitfield-Mask: 0xff)                         */
 #define R_I3C0_NQSTLV_RSPQLV_Pos       (8UL)          /*!< RSPQLV (Bit 8)                                        */
 #define R_I3C0_NQSTLV_RSPQLV_Msk       (0xff00UL)     /*!< RSPQLV (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_NQSTLV_IBIQLV_Pos       (16UL)         /*!< IBIQLV (Bit 16)                                       */
 #define R_I3C0_NQSTLV_IBIQLV_Msk       (0xff0000UL)   /*!< IBIQLV (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_NQSTLV_IBISCNT_Pos      (24UL)         /*!< IBISCNT (Bit 24)                                      */
 #define R_I3C0_NQSTLV_IBISCNT_Msk      (0x1f000000UL) /*!< IBISCNT (Bitfield-Mask: 0x1f)                         */
/* =======================================================  NDBSTLV0  ======================================================== */
 #define R_I3C0_NDBSTLV0_TDBFLV_Pos     (0UL)          /*!< TDBFLV (Bit 0)                                        */
 #define R_I3C0_NDBSTLV0_TDBFLV_Msk     (0xffUL)       /*!< TDBFLV (Bitfield-Mask: 0xff)                          */
 #define R_I3C0_NDBSTLV0_RDBLV_Pos      (8UL)          /*!< RDBLV (Bit 8)                                         */
 #define R_I3C0_NDBSTLV0_RDBLV_Msk      (0xff00UL)     /*!< RDBLV (Bitfield-Mask: 0xff)                           */
/* =======================================================  NRSQSTLV  ======================================================== */
 #define R_I3C0_NRSQSTLV_RSQLV_Pos      (0UL)          /*!< RSQLV (Bit 0)                                         */
 #define R_I3C0_NRSQSTLV_RSQLV_Msk      (0xffUL)       /*!< RSQLV (Bitfield-Mask: 0xff)                           */
/* ========================================================  PRSTDBG  ======================================================== */
 #define R_I3C0_PRSTDBG_SCILV_Pos       (0UL)          /*!< SCILV (Bit 0)                                         */
 #define R_I3C0_PRSTDBG_SCILV_Msk       (0x1UL)        /*!< SCILV (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_PRSTDBG_SDILV_Pos       (1UL)          /*!< SDILV (Bit 1)                                         */
 #define R_I3C0_PRSTDBG_SDILV_Msk       (0x2UL)        /*!< SDILV (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_PRSTDBG_SCOLV_Pos       (2UL)          /*!< SCOLV (Bit 2)                                         */
 #define R_I3C0_PRSTDBG_SCOLV_Msk       (0x4UL)        /*!< SCOLV (Bitfield-Mask: 0x01)                           */
 #define R_I3C0_PRSTDBG_SDOLV_Pos       (3UL)          /*!< SDOLV (Bit 3)                                         */
 #define R_I3C0_PRSTDBG_SDOLV_Msk       (0x8UL)        /*!< SDOLV (Bitfield-Mask: 0x01)                           */
/* =======================================================  MSERRCNT  ======================================================== */
 #define R_I3C0_MSERRCNT_M2ECNT_Pos     (0UL)          /*!< M2ECNT (Bit 0)                                        */
 #define R_I3C0_MSERRCNT_M2ECNT_Msk     (0xffUL)       /*!< M2ECNT (Bitfield-Mask: 0xff)                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  SMPUCTL  ======================================================== */
 #define R_MPU_SMPU_SMPUCTL_KEY_Pos        (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_SMPU_SMPUCTL_KEY_Msk        (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SMPU_SMPUCTL_PROTECT_Pos    (1UL)      /*!< PROTECT (Bit 1)                                       */
 #define R_MPU_SMPU_SMPUCTL_PROTECT_Msk    (0x2UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */
 #define R_MPU_SMPU_SMPUCTL_OAD_Pos        (0UL)      /*!< OAD (Bit 0)                                           */
 #define R_MPU_SMPU_SMPUCTL_OAD_Msk        (0x1UL)    /*!< OAD (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  MSTPCRA  ======================================================== */
 #define R_MSTP_MSTPCRA_MSTPA_Pos    (0UL)   /*!< MSTPA (Bit 0)                                         */
 #define R_MSTP_MSTPCRA_MSTPA_Msk    (0x1UL) /*!< MSTPA (Bitfield-Mask: 0x01)                           */
/* ========================================================  MSTPCRB  ======================================================== */
 #define R_MSTP_MSTPCRB_MSTPB_Pos    (0UL)   /*!< MSTPB (Bit 0)                                         */
 #define R_MSTP_MSTPCRB_MSTPB_Msk    (0x1UL) /*!< MSTPB (Bitfield-Mask: 0x01)                           */
/* ========================================================  MSTPCRC  ======================================================== */
 #define R_MSTP_MSTPCRC_MSTPC_Pos    (0UL)   /*!< MSTPC (Bit 0)                                         */
 #define R_MSTP_MSTPCRC_MSTPC_Msk    (0x1UL) /*!< MSTPC (Bitfield-Mask: 0x01)                           */
/* ========================================================  MSTPCRD  ======================================================== */
 #define R_MSTP_MSTPCRD_MSTPD_Pos    (0UL)   /*!< MSTPD (Bit 0)                                         */
 #define R_MSTP_MSTPCRD_MSTPD_Msk    (0x1UL) /*!< MSTPD (Bitfield-Mask: 0x01)                           */
/* ========================================================  MSTPCRE  ======================================================== */
 #define R_MSTP_MSTPCRE_MSTPE_Pos    (0UL)   /*!< MSTPE (Bit 0)                                         */
 #define R_MSTP_MSTPCRE_MSTPE_Msk    (0x1UL) /*!< MSTPE (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  PCNTR1  ========================================================= */
 #define R_PORT0_PCNTR1_PODR_Pos    (16UL)         /*!< PODR (Bit 16)                                         */
 #define R_PORT0_PCNTR1_PODR_Msk    (0xffff0000UL) /*!< PODR (Bitfield-Mask: 0xffff)                          */
 #define R_PORT0_PCNTR1_PDR_Pos     (0UL)          /*!< PDR (Bit 0)                                           */
 #define R_PORT0_PCNTR1_PDR_Msk     (0xffffUL)     /*!< PDR (Bitfield-Mask: 0xffff)                           */
/* =========================================================  PODR  ========================================================== */
 #define R_PORT0_PODR_PODR_Pos      (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PORT0_PODR_PODR_Msk      (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
/* ==========================================================  PDR  ========================================================== */
 #define R_PORT0_PDR_PDR_Pos        (0UL)          /*!< PDR (Bit 0)                                           */
 #define R_PORT0_PDR_PDR_Msk        (0x1UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
/* ========================================================  PCNTR2  ========================================================= */
 #define R_PORT0_PCNTR2_EIDR_Pos    (16UL)         /*!< EIDR (Bit 16)                                         */
 #define R_PORT0_PCNTR2_EIDR_Msk    (0xffff0000UL) /*!< EIDR (Bitfield-Mask: 0xffff)                          */
 #define R_PORT0_PCNTR2_PIDR_Pos    (0UL)          /*!< PIDR (Bit 0)                                          */
 #define R_PORT0_PCNTR2_PIDR_Msk    (0xffffUL)     /*!< PIDR (Bitfield-Mask: 0xffff)                          */
/* =========================================================  EIDR  ========================================================== */
 #define R_PORT0_EIDR_EIDR_Pos      (0UL)          /*!< EIDR (Bit 0)                                          */
 #define R_PORT0_EIDR_EIDR_Msk      (0x1UL)        /*!< EIDR (Bitfield-Mask: 0x01)                            */
/* =========================================================  PIDR  ========================================================== */
 #define R_PORT0_PIDR_PIDR_Pos      (0UL)          /*!< PIDR (Bit 0)                                          */
 #define R_PORT0_PIDR_PIDR_Msk      (0x1UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
/* ========================================================  PCNTR3  ========================================================= */
 #define R_PORT0_PCNTR3_PORR_Pos    (16UL)         /*!< PORR (Bit 16)                                         */
 #define R_PORT0_PCNTR3_PORR_Msk    (0xffff0000UL) /*!< PORR (Bitfield-Mask: 0xffff)                          */
 #define R_PORT0_PCNTR3_POSR_Pos    (0UL)          /*!< POSR (Bit 0)                                          */
 #define R_PORT0_PCNTR3_POSR_Msk    (0xffffUL)     /*!< POSR (Bitfield-Mask: 0xffff)                          */
/* =========================================================  PORR  ========================================================== */
 #define R_PORT0_PORR_PORR_Pos      (0UL)          /*!< PORR (Bit 0)                                          */
 #define R_PORT0_PORR_PORR_Msk      (0x1UL)        /*!< PORR (Bitfield-Mask: 0x01)                            */
/* =========================================================  POSR  ========================================================== */
 #define R_PORT0_POSR_POSR_Pos      (0UL)          /*!< POSR (Bit 0)                                          */
 #define R_PORT0_POSR_POSR_Msk      (0x1UL)        /*!< POSR (Bitfield-Mask: 0x01)                            */
/* ========================================================  PCNTR4  ========================================================= */
 #define R_PORT0_PCNTR4_EORR_Pos    (16UL)         /*!< EORR (Bit 16)                                         */
 #define R_PORT0_PCNTR4_EORR_Msk    (0xffff0000UL) /*!< EORR (Bitfield-Mask: 0xffff)                          */
 #define R_PORT0_PCNTR4_EOSR_Pos    (0UL)          /*!< EOSR (Bit 0)                                          */
 #define R_PORT0_PCNTR4_EOSR_Msk    (0xffffUL)     /*!< EOSR (Bitfield-Mask: 0xffff)                          */
/* =========================================================  EORR  ========================================================== */
 #define R_PORT0_EORR_EORR_Pos      (0UL)          /*!< EORR (Bit 0)                                          */
 #define R_PORT0_EORR_EORR_Msk      (0x1UL)        /*!< EORR (Bitfield-Mask: 0x01)                            */
/* =========================================================  EOSR  ========================================================== */
 #define R_PORT0_EOSR_EOSR_Pos      (0UL)          /*!< EOSR (Bit 0)                                          */
 #define R_PORT0_EOSR_EOSR_Msk      (0x1UL)        /*!< EOSR (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  PFENET  ========================================================= */
 #define R_PMISC_PFENET_PHYMODE1_Pos    (5UL)    /*!< PHYMODE1 (Bit 5)                                      */
 #define R_PMISC_PFENET_PHYMODE1_Msk    (0x20UL) /*!< PHYMODE1 (Bitfield-Mask: 0x01)                        */
 #define R_PMISC_PFENET_PHYMODE0_Pos    (4UL)    /*!< PHYMODE0 (Bit 4)                                      */
 #define R_PMISC_PFENET_PHYMODE0_Msk    (0x10UL) /*!< PHYMODE0 (Bitfield-Mask: 0x01)                        */
/* =========================================================  PWPR  ========================================================== */
 #define R_PMISC_PWPR_PFSWE_Pos         (6UL)    /*!< PFSWE (Bit 6)                                         */
 #define R_PMISC_PWPR_PFSWE_Msk         (0x40UL) /*!< PFSWE (Bitfield-Mask: 0x01)                           */
 #define R_PMISC_PWPR_B0WI_Pos          (7UL)    /*!< B0WI (Bit 7)                                          */
 #define R_PMISC_PWPR_B0WI_Msk          (0x80UL) /*!< B0WI (Bitfield-Mask: 0x01)                            */
/* =========================================================  PWPRS  ========================================================= */
 #define R_PMISC_PWPRS_PFSWE_Pos        (6UL)    /*!< PFSWE (Bit 6)                                         */
 #define R_PMISC_PWPRS_PFSWE_Msk        (0x40UL) /*!< PFSWE (Bitfield-Mask: 0x01)                           */
 #define R_PMISC_PWPRS_B0WI_Pos         (7UL)    /*!< B0WI (Bit 7)                                          */
 #define R_PMISC_PWPRS_B0WI_Msk         (0x80UL) /*!< B0WI (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                          R_SCI0                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  SMR  ========================================================== */
 #define R_SCI0_SMR_CM_Pos              (7UL)      /*!< CM (Bit 7)                                            */
 #define R_SCI0_SMR_CM_Msk              (0x80UL)   /*!< CM (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_CHR_Pos             (6UL)      /*!< CHR (Bit 6)                                           */
 #define R_SCI0_SMR_CHR_Msk             (0x40UL)   /*!< CHR (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SMR_PE_Pos              (5UL)      /*!< PE (Bit 5)                                            */
 #define R_SCI0_SMR_PE_Msk              (0x20UL)   /*!< PE (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_PM_Pos              (4UL)      /*!< PM (Bit 4)                                            */
 #define R_SCI0_SMR_PM_Msk              (0x10UL)   /*!< PM (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_STOP_Pos            (3UL)      /*!< STOP (Bit 3)                                          */
 #define R_SCI0_SMR_STOP_Msk            (0x8UL)    /*!< STOP (Bitfield-Mask: 0x01)                            */
 #define R_SCI0_SMR_MP_Pos              (2UL)      /*!< MP (Bit 2)                                            */
 #define R_SCI0_SMR_MP_Msk              (0x4UL)    /*!< MP (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_CKS_Pos             (0UL)      /*!< CKS (Bit 0)                                           */
 #define R_SCI0_SMR_CKS_Msk             (0x3UL)    /*!< CKS (Bitfield-Mask: 0x03)                             */
/* =======================================================  SMR_SMCI  ======================================================== */
 #define R_SCI0_SMR_SMCI_GM_Pos         (7UL)      /*!< GM (Bit 7)                                            */
 #define R_SCI0_SMR_SMCI_GM_Msk         (0x80UL)   /*!< GM (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_SMCI_BLK_Pos        (6UL)      /*!< BLK (Bit 6)                                           */
 #define R_SCI0_SMR_SMCI_BLK_Msk        (0x40UL)   /*!< BLK (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SMR_SMCI_PE_Pos         (5UL)      /*!< PE (Bit 5)                                            */
 #define R_SCI0_SMR_SMCI_PE_Msk         (0x20UL)   /*!< PE (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_SMCI_PM_Pos         (4UL)      /*!< PM (Bit 4)                                            */
 #define R_SCI0_SMR_SMCI_PM_Msk         (0x10UL)   /*!< PM (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SMR_SMCI_BCP_Pos        (2UL)      /*!< BCP (Bit 2)                                           */
 #define R_SCI0_SMR_SMCI_BCP_Msk        (0xcUL)    /*!< BCP (Bitfield-Mask: 0x03)                             */
 #define R_SCI0_SMR_SMCI_CKS_Pos        (0UL)      /*!< CKS (Bit 0)                                           */
 #define R_SCI0_SMR_SMCI_CKS_Msk        (0x3UL)    /*!< CKS (Bitfield-Mask: 0x03)                             */
/* ==========================================================  BRR  ========================================================== */
 #define R_SCI0_BRR_BRR_Pos             (0UL)      /*!< BRR (Bit 0)                                           */
 #define R_SCI0_BRR_BRR_Msk             (0xffUL)   /*!< BRR (Bitfield-Mask: 0xff)                             */
/* ==========================================================  SCR  ========================================================== */
 #define R_SCI0_SCR_TIE_Pos             (7UL)      /*!< TIE (Bit 7)                                           */
 #define R_SCI0_SCR_TIE_Msk             (0x80UL)   /*!< TIE (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SCR_RIE_Pos             (6UL)      /*!< RIE (Bit 6)                                           */
 #define R_SCI0_SCR_RIE_Msk             (0x40UL)   /*!< RIE (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SCR_TE_Pos              (5UL)      /*!< TE (Bit 5)                                            */
 #define R_SCI0_SCR_TE_Msk              (0x20UL)   /*!< TE (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SCR_RE_Pos              (4UL)      /*!< RE (Bit 4)                                            */
 #define R_SCI0_SCR_RE_Msk              (0x10UL)   /*!< RE (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SCR_MPIE_Pos            (3UL)      /*!< MPIE (Bit 3)                                          */
 #define R_SCI0_SCR_MPIE_Msk            (0x8UL)    /*!< MPIE (Bitfield-Mask: 0x01)                            */
 #define R_SCI0_SCR_TEIE_Pos            (2UL)      /*!< TEIE (Bit 2)                                          */
 #define R_SCI0_SCR_TEIE_Msk            (0x4UL)    /*!< TEIE (Bitfield-Mask: 0x01)                            */
 #define R_SCI0_SCR_CKE_Pos             (0UL)      /*!< CKE (Bit 0)                                           */
 #define R_SCI0_SCR_CKE_Msk             (0x3UL)    /*!< CKE (Bitfield-Mask: 0x03)                             */
/* =======================================================  SCR_SMCI  ======================================================== */
 #define R_SCI0_SCR_SMCI_TIE_Pos        (7UL)      /*!< TIE (Bit 7)                                           */
 #define R_SCI0_SCR_SMCI_TIE_Msk        (0x80UL)   /*!< TIE (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SCR_SMCI_RIE_Pos        (6UL)      /*!< RIE (Bit 6)                                           */
 #define R_SCI0_SCR_SMCI_RIE_Msk        (0x40UL)   /*!< RIE (Bitfield-Mask: 0x01)                             */
 #define R_SCI0_SCR_SMCI_TE_Pos         (5UL)      /*!< TE (Bit 5)                                            */
 #define R_SCI0_SCR_SMCI_TE_Msk         (0x20UL)   /*!< TE (Bitfield-Mask: 0x01)                              */
 #define R_SCI0_SCR_SMCI_RE_Pos         (4UL)      /*!< R