// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.color.space.srgb-linear
// Description:test getImageData color conversion with a srgb-linear uint8 canvas
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("test getImageData color conversion with a srgb-linear uint8 canvas");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d', {colorSpace: "srgb-linear"});

  const color_style = 'color(srgb-linear 0.0392 0.3922 0.7843)';
  // [0.0392, 0.3922, 0.7843, 1.0] * 255 = [10, 100, 200, 255]
  const epsilon = 2;
  ctx.fillStyle = color_style;
  ctx.fillRect(0, 0, 10, 10);

  // Read without specifying a color space. The result should be the specified
  // color.
  let pixel_expected = [10, 100, 200, 255];
  let image_data = ctx.getImageData(5, 5, 1, 1);
  _assertSame(image_data.colorSpace, "srgb-linear", "image_data.colorSpace", "\"srgb-linear\"");
  assert_approx_equals(image_data.data[0], pixel_expected[0], 2);
  assert_approx_equals(image_data.data[1], pixel_expected[1], 2);
  assert_approx_equals(image_data.data[2], pixel_expected[2], 2);
  assert_approx_equals(image_data.data[3], pixel_expected[3], 2);

  // Read back to srgb. This will convert from linear to sRGB transfer
  // function.
  pixel_expected = [58, 168, 229, 255];
  image_data = ctx.getImageData(5, 5, 1, 1, {colorSpace:"srgb"});
  _assertSame(image_data.colorSpace, "srgb", "image_data.colorSpace", "\"srgb\"");
  assert_approx_equals(image_data.data[0], pixel_expected[0], 2);
  assert_approx_equals(image_data.data[1], pixel_expected[1], 2);
  assert_approx_equals(image_data.data[2], pixel_expected[2], 2);
  assert_approx_equals(image_data.data[3], pixel_expected[3], 2);
  t.done();
});
done();
