// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.actualBoundingBox.whitespace
// Description:Testing actualBoundingBox with leading/trailing whitespace
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

promise_test(async t => {
  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d');

  var f = new FontFace("CanvasTest", "url('/fonts/CanvasTest.ttf')");
  f.load();
  self.fonts.add(f);
  await self.fonts.ready;
  ctx.font = '50px CanvasTest';
  ctx.direction = 'ltr';
  ctx.align = 'left'
  ctx.baseline = 'alphabetic'
  // Different platforms may render text slightly different.
  // Values that are nominally expected to be zero might actually vary by a
  // pixel or so if the UA accounts for antialiasing at glyph edges, so we
  // allow a slight deviation.
  var whitespaces = [0x9, 0xa, 0xc, 0xd, 0x20, 0x3000];
  for (var codepoint of whitespaces) {
    let whitespace = String.fromCharCode(codepoint);

    _assert(Math.abs(ctx.measureText('A' + whitespace).actualBoundingBoxLeft) <= 1, "Math.abs(ctx.measureText('A' + whitespace).actualBoundingBoxLeft) <= 1");
    _assert(ctx.measureText('A' + whitespace).actualBoundingBoxRight >= 50, "ctx.measureText('A' + whitespace).actualBoundingBoxRight >= 50");

    _assert(Math.abs(ctx.measureText(whitespace + 'A').actualBoundingBoxLeft) >= 49, "Math.abs(ctx.measureText(whitespace + 'A').actualBoundingBoxLeft) >= 49");
    _assert(ctx.measureText(whitespace + 'A').actualBoundingBoxRight <= 101, "ctx.measureText(whitespace + 'A').actualBoundingBoxRight <= 101");
  }
}, "Testing actualBoundingBox with leading/trailing whitespace");
done();
