// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.color.type.u8p3.to.u8srgb.to.u8p3
// Description:test srgb unorm8 canvas storing 8-bit display-p3 data accurately
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("test srgb unorm8 canvas storing 8-bit display-p3 data accurately");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d', {colorType: "unorm8", colorSpace: "srgb"});

  // Consider the color in Display P3:
  //   (5,250,128)/255
  // In sRGB this is:
  //   (-0.4990661502955996, 0.9982902153915844, 0.43901323244980783)
  // Quantized to 8-bit, this is:
  //   (0, 255, 112)/255
  // Converted back to Display P3 this is:
  //   (116.892405498713, 251.242468747889, 129.109129531237)/255
  // Quantized to 8-bit, this is:
  //   (116, 251, 129)
  var input = new ImageData(new Uint8ClampedArray([5, 250, 128, 255]),
                            1, 1, {colorSpace: "display-p3"});
  ctx.putImageData(input, 0, 0);
  var readback = ctx.getImageData(0, 0, 1, 1, {colorSpace:"display-p3"});
  const kEpsilon = 2;
  assert_approx_equals(readback.data[0], 116, kEpsilon);
  assert_approx_equals(readback.data[1], 251, kEpsilon);
  assert_approx_equals(readback.data[2], 129, kEpsilon);
  t.done();
});
done();
