/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncCompareHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 8888333889563000881L;
    @NotNull
    private final AsyncCompareResultListener resultListener;
    @NotNull
    private final AsyncRequestID asyncRequestID;
    @NotNull
    private final AtomicBoolean responseReturned;
    @Nullable
    private final IntermediateResponseListener intermediateResponseListener;
    @NotNull
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncCompareHelper(@NotNull LDAPConnection connection, int messageID, @NotNull AsyncCompareResultListener resultListener, @Nullable IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.asyncRequestID = new AsyncRequestID(messageID, connection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    @Override
    @NotNull
    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    @Override
    @NotNull
    public LDAPConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getCreateTimeNanos() {
        return this.createTime;
    }

    @Override
    @NotNull
    public OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(@Nullable LDAPResponse response) throws LDAPException {
        ConnectionClosedResponse ccr;
        String msg;
        if (!this.responseReturned.compareAndSet(false, true)) {
            return;
        }
        long responseTime = System.nanoTime() - this.createTime;
        CompareResult result = response instanceof ConnectionClosedResponse ? ((msg = (ccr = (ConnectionClosedResponse)response).getMessage()) == null ? new CompareResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new CompareResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(msg), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS)) : (CompareResult)response;
        this.connection.getConnectionStatistics().incrementNumCompareResponses(responseTime);
        this.resultListener.compareResultReceived(this.asyncRequestID, result);
        this.asyncRequestID.setResult(result);
    }

    @Override
    @InternalUseOnly
    public void intermediateResponseReturned(@NotNull IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

