// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server_template

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateServerTemplateCreatedCode is the HTTP code returned for type CreateServerTemplateCreated
const CreateServerTemplateCreatedCode int = 201

/*
CreateServerTemplateCreated Server template created

swagger:response createServerTemplateCreated
*/
type CreateServerTemplateCreated struct {

	/*
	  In: Body
	*/
	Payload *models.ServerTemplate `json:"body,omitempty"`
}

// NewCreateServerTemplateCreated creates CreateServerTemplateCreated with default headers values
func NewCreateServerTemplateCreated() *CreateServerTemplateCreated {

	return &CreateServerTemplateCreated{}
}

// WithPayload adds the payload to the create server template created response
func (o *CreateServerTemplateCreated) WithPayload(payload *models.ServerTemplate) *CreateServerTemplateCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server template created response
func (o *CreateServerTemplateCreated) SetPayload(payload *models.ServerTemplate) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerTemplateCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerTemplateAcceptedCode is the HTTP code returned for type CreateServerTemplateAccepted
const CreateServerTemplateAcceptedCode int = 202

/*
CreateServerTemplateAccepted Configuration change accepted and reload requested

swagger:response createServerTemplateAccepted
*/
type CreateServerTemplateAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ServerTemplate `json:"body,omitempty"`
}

// NewCreateServerTemplateAccepted creates CreateServerTemplateAccepted with default headers values
func NewCreateServerTemplateAccepted() *CreateServerTemplateAccepted {

	return &CreateServerTemplateAccepted{}
}

// WithReloadID adds the reloadId to the create server template accepted response
func (o *CreateServerTemplateAccepted) WithReloadID(reloadID string) *CreateServerTemplateAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create server template accepted response
func (o *CreateServerTemplateAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create server template accepted response
func (o *CreateServerTemplateAccepted) WithPayload(payload *models.ServerTemplate) *CreateServerTemplateAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server template accepted response
func (o *CreateServerTemplateAccepted) SetPayload(payload *models.ServerTemplate) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerTemplateAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerTemplateBadRequestCode is the HTTP code returned for type CreateServerTemplateBadRequest
const CreateServerTemplateBadRequestCode int = 400

/*
CreateServerTemplateBadRequest Bad request

swagger:response createServerTemplateBadRequest
*/
type CreateServerTemplateBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerTemplateBadRequest creates CreateServerTemplateBadRequest with default headers values
func NewCreateServerTemplateBadRequest() *CreateServerTemplateBadRequest {

	return &CreateServerTemplateBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create server template bad request response
func (o *CreateServerTemplateBadRequest) WithConfigurationVersion(configurationVersion string) *CreateServerTemplateBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server template bad request response
func (o *CreateServerTemplateBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server template bad request response
func (o *CreateServerTemplateBadRequest) WithPayload(payload *models.Error) *CreateServerTemplateBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server template bad request response
func (o *CreateServerTemplateBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerTemplateBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerTemplateConflictCode is the HTTP code returned for type CreateServerTemplateConflict
const CreateServerTemplateConflictCode int = 409

/*
CreateServerTemplateConflict The specified resource already exists

swagger:response createServerTemplateConflict
*/
type CreateServerTemplateConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerTemplateConflict creates CreateServerTemplateConflict with default headers values
func NewCreateServerTemplateConflict() *CreateServerTemplateConflict {

	return &CreateServerTemplateConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create server template conflict response
func (o *CreateServerTemplateConflict) WithConfigurationVersion(configurationVersion string) *CreateServerTemplateConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server template conflict response
func (o *CreateServerTemplateConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server template conflict response
func (o *CreateServerTemplateConflict) WithPayload(payload *models.Error) *CreateServerTemplateConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server template conflict response
func (o *CreateServerTemplateConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerTemplateConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateServerTemplateDefault General Error

swagger:response createServerTemplateDefault
*/
type CreateServerTemplateDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerTemplateDefault creates CreateServerTemplateDefault with default headers values
func NewCreateServerTemplateDefault(code int) *CreateServerTemplateDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateServerTemplateDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create server template default response
func (o *CreateServerTemplateDefault) WithStatusCode(code int) *CreateServerTemplateDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create server template default response
func (o *CreateServerTemplateDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create server template default response
func (o *CreateServerTemplateDefault) WithConfigurationVersion(configurationVersion string) *CreateServerTemplateDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server template default response
func (o *CreateServerTemplateDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server template default response
func (o *CreateServerTemplateDefault) WithPayload(payload *models.Error) *CreateServerTemplateDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server template default response
func (o *CreateServerTemplateDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerTemplateDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
