/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.HashMap;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.WildcardConstantFilter;
import proguard.resources.file.ResourceFile;
import proguard.util.ArrayUtil;

public class ConstantPoolEditor {
    private static final boolean DEBUG = false;
    private static final int SIZE_INCREMENT = 16;
    private final ProgramClass targetClass;
    private final ConstantVisitor constantReferenceInitializer;
    private HashMap<Constant, Integer> cachedIndices;
    private int cachedCount;

    public ConstantPoolEditor(ProgramClass targetClass) {
        this(targetClass, null, null);
    }

    public ConstantPoolEditor(ProgramClass targetClass, ClassPool programClassPool, ClassPool libraryClassPool) {
        this(targetClass, programClassPool, libraryClassPool, targetClass.u2constantPoolCount <= 1);
    }

    ConstantPoolEditor(ProgramClass targetClass, ClassPool programClassPool, ClassPool libraryClassPool, boolean cacheIndices) {
        this.targetClass = targetClass;
        ConstantVisitor constantVisitor = this.constantReferenceInitializer = programClassPool == null ? null : new WildcardConstantFilter(new ClassReferenceInitializer(programClassPool, libraryClassPool));
        if (cacheIndices) {
            this.cachedIndices = new HashMap();
            this.cachedCount = targetClass.u2constantPoolCount;
            for (int index = 1; index < this.cachedCount; ++index) {
                Constant constant = targetClass.constantPool[index];
                if (constant == null) continue;
                this.cachedIndices.put(constant, index);
            }
        }
    }

    public ProgramClass getTargetClass() {
        return this.targetClass;
    }

    public int addIntegerConstant(int value) {
        return this.findOrAddConstant(new IntegerConstant(value));
    }

    public int addLongConstant(long value) {
        return this.findOrAddConstant(new LongConstant(value));
    }

    public int addFloatConstant(float value) {
        return this.findOrAddConstant(new FloatConstant(value));
    }

    public int addDoubleConstant(double value) {
        return this.findOrAddConstant(new DoubleConstant(value));
    }

    public int addPrimitiveArrayConstant(Object values2) {
        return this.findOrAddConstant(new PrimitiveArrayConstant(values2));
    }

    public int addStringConstant(String string, Clazz referencedClass, Member referencedMember) {
        return this.addStringConstant(string, referencedClass, referencedMember, 0, null);
    }

    public int addStringConstant(String string) {
        return this.addStringConstant(string, null, null);
    }

    public int addStringConstant(String string, ResourceFile referencedResourceFile) {
        return this.addStringConstant(string, null, null, 0, referencedResourceFile);
    }

    public int addStringConstant(String string, Clazz referencedClass, Member referencedMember, int resourceFileId, ResourceFile resourceFile) {
        return this.addStringConstant(this.addUtf8Constant(string), referencedClass, referencedMember, resourceFileId, resourceFile);
    }

    public int addStringConstant(int utf8index, Clazz referencedClass, Member referencedMember, int resourceFileId, ResourceFile resourceFile) {
        return this.findOrAddConstant(new StringConstant(utf8index, referencedClass, referencedMember, resourceFileId, resourceFile));
    }

    public int addInvokeDynamicConstant(int bootstrapMethodIndex, String name, String descriptor, Clazz[] referencedClasses) {
        return this.addInvokeDynamicConstant(bootstrapMethodIndex, this.addNameAndTypeConstant(name, descriptor), referencedClasses);
    }

    public int addDynamicConstant(int bootstrapMethodIndex, int nameAndTypeIndex, Clazz[] referencedClasses) {
        return this.findOrAddConstant(new DynamicConstant(bootstrapMethodIndex, nameAndTypeIndex, referencedClasses));
    }

    public int addInvokeDynamicConstant(int bootstrapMethodIndex, int nameAndTypeIndex, Clazz[] referencedClasses) {
        return this.findOrAddConstant(new InvokeDynamicConstant(bootstrapMethodIndex, nameAndTypeIndex, referencedClasses));
    }

    public int addMethodHandleConstant(int referenceKind, int referenceIndex) {
        return this.findOrAddConstant(new MethodHandleConstant(referenceKind, referenceIndex));
    }

    public int addModuleConstant(String name) {
        return this.addModuleConstant(this.addUtf8Constant(name));
    }

    public int addModuleConstant(int nameIndex) {
        return this.findOrAddConstant(new ModuleConstant(nameIndex));
    }

    public int addPackageConstant(String name) {
        return this.addPackageConstant(this.addUtf8Constant(name));
    }

    public int addPackageConstant(int nameIndex) {
        return this.findOrAddConstant(new PackageConstant(nameIndex));
    }

    public int addFieldrefConstant(Clazz referencedClass, Field referencedField) {
        return this.addFieldrefConstant(referencedClass.getName(), referencedField.getName(referencedClass), referencedField.getDescriptor(referencedClass), referencedClass, referencedField);
    }

    public int addFieldrefConstant(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.addFieldrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedField);
    }

    public int addFieldrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Field referencedField) {
        return this.addFieldrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedField);
    }

    public int addFieldrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.addFieldrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedField);
    }

    public int addFieldrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Field referencedField) {
        return this.findOrAddConstant(new FieldrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedField));
    }

    public int addInterfaceMethodrefConstant(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.addInterfaceMethodrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMethod);
    }

    public int addInterfaceMethodrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Method referencedMethod) {
        return this.addInterfaceMethodrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedMethod);
    }

    public int addInterfaceMethodrefConstant(Clazz referencedClass, Method referencedMethod) {
        return this.addInterfaceMethodrefConstant(referencedClass.getName(), referencedMethod.getName(referencedClass), referencedMethod.getDescriptor(referencedClass), referencedClass, referencedMethod);
    }

    public int addInterfaceMethodrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.addInterfaceMethodrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMethod);
    }

    public int addInterfaceMethodrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Method referencedMethod) {
        return this.findOrAddConstant(new InterfaceMethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMethod));
    }

    public int addMethodrefConstant(Clazz referencedClass, Method referencedMethod) {
        return this.addMethodrefConstant(referencedClass.getName(), referencedMethod.getName(referencedClass), referencedMethod.getDescriptor(referencedClass), referencedClass, referencedMethod);
    }

    public int addMethodrefConstant(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.addMethodrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMethod);
    }

    public int addMethodrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Method referencedMethod) {
        return this.addMethodrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedMethod);
    }

    public int addMethodrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.addMethodrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMethod);
    }

    public int addMethodrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Method referencedMethod) {
        return this.findOrAddConstant(new MethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMethod));
    }

    public int addClassConstant(Clazz referencedClass) {
        return this.addClassConstant(referencedClass.getName(), referencedClass);
    }

    public int addClassConstant(String name, Clazz referencedClass) {
        return this.addClassConstant(this.addUtf8Constant(name), referencedClass);
    }

    public int addClassConstant(int nameIndex, Clazz referencedClass) {
        return this.findOrAddConstant(new ClassConstant(nameIndex, referencedClass));
    }

    public int addMethodTypeConstant(String descriptor, Clazz[] referencedClasses) {
        return this.addMethodTypeConstant(this.addUtf8Constant(descriptor), referencedClasses);
    }

    public int addMethodTypeConstant(int descriptorIndex, Clazz[] referencedClasses) {
        return this.findOrAddConstant(new MethodTypeConstant(descriptorIndex, referencedClasses));
    }

    public int addNameAndTypeConstant(String name, String descriptor) {
        return this.addNameAndTypeConstant(this.addUtf8Constant(name), this.addUtf8Constant(descriptor));
    }

    public int addNameAndTypeConstant(int nameIndex, int descriptorIndex) {
        return this.findOrAddConstant(new NameAndTypeConstant(nameIndex, descriptorIndex));
    }

    public int addUtf8Constant(String string) {
        return this.findOrAddConstant(new Utf8Constant(string));
    }

    public int findOrAddConstant(Constant constant) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        if (this.cachedCount > 0 && this.cachedCount != constantPoolCount) {
            this.cachedIndices = null;
        }
        if (this.cachedIndices != null) {
            Integer index = this.cachedIndices.get(constant);
            if (index != null) {
                return index;
            }
            this.cachedIndices.put(constant, constantPoolCount);
        } else {
            for (int index = 1; index < constantPoolCount; ++index) {
                if (!constant.equals(constantPool[index])) continue;
                return index;
            }
        }
        return this.addConstant(constant);
    }

    public int addConstant(Constant constant) {
        int constantSize;
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        int n = constantSize = constant.isCategory2() ? 2 : 1;
        if (constantPool.length < constantPoolCount + constantSize) {
            this.targetClass.constantPool = constantPool = ArrayUtil.extendArray(constantPool, constantPoolCount + 16);
        }
        constantPool[constantPoolCount] = constant;
        this.targetClass.u2constantPoolCount = this.cachedCount = constantPoolCount + constantSize;
        if (this.constantReferenceInitializer != null) {
            constant.accept(this.targetClass, this.constantReferenceInitializer);
        }
        return constantPoolCount;
    }
}

