import{useEffect,useState}from"react";import{useSorting}from"./state/sortSlice";import{usePaging}from"./state/pageSlice";import{useSelect}from"./state/selectSlice";import{useColumns}from"../hooks/useColumns";import{useFillers}from"../hooks/useFillers";import{useRowFactoryBuilder}from"../hooks/useRowFactoryBuilder";export function useTableClientSide(inputData,config,onSelect,onSortingChange,onPagingChange,defaultPaging){var _config_meta;const[data,setData]=useState(inputData);const{sorting,sortBy,sortFunction}=useSorting(config);const{paging,gotoPageIndex,setPageSize,sliceParams}=usePaging(data,defaultPaging);const selectionState=useSelect();useEffect(()=>{onPagingChange&&onPagingChange({index:paging.index,size:paging.size})},[paging]);useEffect(()=>{onSortingChange&&onSortingChange({column:sorting.column,direction:sorting.direction})},[sorting]);useEffect(()=>{if(!onSelect)return;const selectedData=selectionState.selected.map(id=>data.find(d=>config.rowIdentifierAccessor(d)===id)).filter(x=>x!==undefined);onSelect(selectedData)},[selectionState.selected]);useEffect(()=>{if(JSON.stringify(data)===JSON.stringify(inputData))return;setData(inputData)},[inputData]);useEffect(()=>{selectionState.clearSelected()},[paging.totalDisplayableResults,paging.totalResults]);const rowsRaw=[...data].sort(sortFunction).slice(...sliceParams);const rowIds=rowsRaw.map(row=>row.id);const rowFactory=useRowFactoryBuilder(config,selectionState,rowIds);const rows=rowsRaw.map(rowFactory);const columns=useColumns(config,{sorting,sortBy,selected:selectionState.selected,selectAll:selectionState.selectAll,rowIds:rowIds});const fillers=useFillers(config,rows,paging.size);return{head:{columns},body:{rows,fillers,meta:{noDataTextContent:(_config_meta=config.meta)===null||_config_meta===void 0?void 0:_config_meta.noDataTextContent}},paging:{index:paging.index,size:paging.size,totalDisplayableResults:paging.totalDisplayableResults,actions:{gotoPageIndex,setPageSize}},selection:selectionState}}
//# sourceMappingURL=useTableClientSide.js.map