/**
 * Memoize the result of ac so if it is called with the same args, it returns immediately.
 * Also, to prevent useless React rerenders
 */
declare const cache: Map<any, any>;
/**
 * `ac` returns an instance of AtomicGroups. The instance holds the knowledge of Atomic Group so we can chain `ac`.
 * e.g. <div className={ax([ax(['_aaaa_b']), '_aaaa_c'])} />
 */
declare class AtomicGroups {
    values: Map<string, string>;
    constructor(values: Map<string, string>);
    toString(): string;
}
/**
 * Joins classes together and ensures atomic declarations of a single group exist.
 * Atomic declarations take the form of `_{group}{value}` (always prefixed with an underscore),
 * where both `group` and `value` are hashes **four characters long**.
 * Class names can be of any length,
 * this function can take both atomic declarations and class names.
 *
 * Input:
 *
 * ```
 * ax(['_aaaabbbb', '_aaaacccc'])
 * ```
 *
 * Output:
 *
 * ```
 * '_aaaacccc'
 * ```
 *
 * @param classes
 */
export declare function ac(classNames: (AtomicGroups | string | null | undefined | false)[]): AtomicGroups | undefined;
export declare function memoizedAc(classNames: (AtomicGroups | string | undefined | false)[]): AtomicGroups | undefined;
declare const _default: typeof memoizedAc;
export default _default;
/**
 * Provide an opportunity to clear the cache to prevent memory leak.
 */
export declare function clearCache(): void;
/**
 * Expose cache
 */
export declare function getCache(): typeof cache;
