/* pressable.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./pressable.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react2 = require("@compiled/react");
var _analyticsNext = require("@atlaskit/analytics-next");
var _deviceCheck = require("@atlaskit/ds-lib/device-check");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _interactionContext = _interopRequireDefault(require("@atlaskit/interaction-context"));
var _focusable = _interopRequireDefault(require("./focusable"));
var _excluded = ["children", "isDisabled", "type", "onClick", "interactionName", "componentName", "analyticsContext", "style", "testId", "xcss", "tabIndex"],
  _excluded2 = ["className"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var styles = {
  root: "_19itglyw _vchhusvi _r06hglyw _80omtlke",
  disabled: "_80om13gf"
};

/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
var Pressable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    isDisabled = _ref.isDisabled,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$onClick = _ref.onClick,
    providedOnClick = _ref$onClick === void 0 ? _noop.default : _ref$onClick,
    interactionName = _ref.interactionName,
    componentName = _ref.componentName,
    analyticsContext = _ref.analyticsContext,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    tabIndex = _ref.tabIndex,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var interactionContext = (0, _react.useContext)(_interactionContext.default);
  var handleClick = (0, _react.useCallback)(function (e, analyticsEvent) {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  var onClick = (0, _analyticsNext.usePlatformLeafEventHandler)({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Pressable',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'button'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  return /*#__PURE__*/React.createElement(_focusable.default
  // @ts-expect-error we don't allow `button` on Focusable for makers as they should use Pressable instead
  , (0, _extends2.default)({
    as: "button"
    // Safari does not apply focus to buttons on click like other browsers, which means click events will not be fired.
    // Adding a tabIndex of 0 to the button will allow it to be focused on click.
    // This is a known issue in Safari that is meant to be "intended", see https://bugs.webkit.org/show_bug.cgi?id=22261
    ,
    tabIndex: tabIndex !== null && tabIndex !== void 0 ? tabIndex : (0, _deviceCheck.isSafari)() && !isDisabled ? 0 : undefined
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- TODO: Properly type this and allow pass-through if we can determine the type
    ,
    style: style
  }, safeHtmlAttributes, {
    type: type,
    onClick: onClick,
    disabled: isDisabled,
    xcss: (0, _react2.cx)(styles.root, isDisabled && styles.disabled, xcss),
    testId: testId,
    ref: ref
  }), children);
});
var _default = exports.default = Pressable;