import { subtract } from './position';
export default (({
  scrollHeight,
  scrollWidth,
  height,
  width
}) => {
  const maxScroll = subtract(
  // full size
  {
    x: scrollWidth,
    y: scrollHeight
  },
  // viewport size
  {
    x: width,
    y: height
  });
  const adjustedMaxScroll = {
    x: Math.max(0, maxScroll.x),
    y: Math.max(0, maxScroll.y)
  };
  return adjustedMaxScroll;
});