/* GKrellM
|  Copyright (C) 1999-2021 Bill Wilson
|
|  Author:  Bill Wilson
|  Latest versions might be found at:  https://gkrellm.srcbox.net
|
|
|  GKrellM is free software: you can redistribute it and/or modify it
|  under the terms of the GNU General Public License as published by
|  the Free Software Foundation, either version 3 of the License, or
|  (at your option) any later version.
|
|  GKrellM is distributed in the hope that it will be useful, but WITHOUT
|  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
|  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
|  License for more details.
|
|  You should have received a copy of the GNU General Public License
|  along with this program. If not, see http://www.gnu.org/licenses/
|
|
|  Additional permission under GNU GPL version 3 section 7
|
|  If you modify this program, or any covered work, by linking or
|  combining it with the OpenSSL project's OpenSSL library (or a
|  modified version of that library), containing parts covered by
|  the terms of the OpenSSL or SSLeay licenses, you are granted
|  additional permission to convey the resulting work.
|  Corresponding Source for a non-source form of such a combination
|  shall include the source code for the parts of OpenSSL used as well
|  as that of the covered work.
*/

#ifndef GKRELLM_PUBLIC_PROTO_H
#define GKRELLM_PUBLIC_PROTO_H

#include "gkrellm-visibility.h"

G_BEGIN_DECLS

/* Public GKrellM function prototypes available for all monitors and plugins */

  /* Data structure allocation
  */
GKRELLM_API GkrellmChart *gkrellm_chart_new0(void);
GKRELLM_API GkrellmChartconfig *gkrellm_chartconfig_new0(void);
GKRELLM_API GkrellmPanel *gkrellm_panel_new0(void);
GKRELLM_API GkrellmKrell *gkrellm_krell_new0(void);
GKRELLM_API GkrellmDecal *gkrellm_decal_new0(void);
GKRELLM_API GkrellmLabel *gkrellm_label_new0(void);
GKRELLM_API GkrellmStyle *gkrellm_style_new0(void);
GKRELLM_API GkrellmStyle *gkrellm_copy_style(GkrellmStyle *);
GKRELLM_API void gkrellm_copy_style_values(GkrellmStyle *, GkrellmStyle *);
GKRELLM_API GkrellmTextstyle *gkrellm_textstyle_new0(void);
GKRELLM_API GkrellmTextstyle *gkrellm_copy_textstyle(GkrellmTextstyle *);


  /* Chart functions
  */
GKRELLM_API void gkrellm_chart_create(GtkWidget *, GkrellmMonitor *, GkrellmChart *, GkrellmChartconfig **);
GKRELLM_API void gkrellm_chart_destroy(GkrellmChart *);
GKRELLM_API void gkrellm_chart_hide(GkrellmChart *, gboolean);
GKRELLM_API void gkrellm_chart_show(GkrellmChart *, gboolean);
GKRELLM_API gboolean gkrellm_chart_enable_visibility(GkrellmChart *cp, gboolean, gboolean *);
GKRELLM_API gboolean gkrellm_is_chart_visible(GkrellmChart *);
GKRELLM_API void gkrellm_set_draw_chart_function(GkrellmChart *, void (*func)(), gpointer);
GKRELLM_API void gkrellm_draw_chart_to_screen(GkrellmChart *);
GKRELLM_API gint gkrellm_draw_chart_label(GkrellmChart *, GkrellmTextstyle *, gint, gint,gchar *);
GKRELLM_API void gkrellm_draw_chart_text(GkrellmChart *, gint, gchar *);
GKRELLM_API void gkrellm_chart_reuse_text_format(GkrellmChart *cp);
GKRELLM_API void gkrellm_reset_chart(GkrellmChart *);
GKRELLM_API void gkrellm_reset_and_draw_chart(GkrellmChart *);
GKRELLM_API void gkrellm_refresh_chart(GkrellmChart *);
GKRELLM_API void gkrellm_rescale_chart(GkrellmChart *);
GKRELLM_API void gkrellm_clear_chart(GkrellmChart *);
GKRELLM_API void gkrellm_clear_chart_pixmap(GkrellmChart *);
GKRELLM_API void gkrellm_clean_bg_src_pixmap(GkrellmChart *);
GKRELLM_API void gkrellm_draw_chart_grid_line(GkrellmChart *, GdkPixmap *, gint);
GKRELLM_API void gkrellm_chart_bg_piximage_override(GkrellmChart *, GkrellmPiximage *, GkrellmPiximage *);
GKRELLM_API gint gkrellm_chart_width(void);
GKRELLM_API void gkrellm_set_chart_height_default(GkrellmChart *, gint);
GKRELLM_API void gkrellm_set_chart_height(GkrellmChart *, gint);
GKRELLM_API gint gkrellm_get_chart_scalemax(GkrellmChart *);
GKRELLM_API void gkrellm_render_data_pixmap(GkrellmPiximage *, GdkPixmap **, GdkColor *, gint);
GKRELLM_API void gkrellm_render_data_grid_pixmap(GkrellmPiximage *, GdkPixmap **, GdkColor *);


  /* ChartData functions
  */
GKRELLM_API GkrellmChartdata *gkrellm_add_chartdata(GkrellmChart *, GdkPixmap **, GdkPixmap *, gchar *);
GKRELLM_API GkrellmChartdata *gkrellm_add_default_chartdata(GkrellmChart *, gchar *);
GKRELLM_API void gkrellm_alloc_chartdata(GkrellmChart *);
GKRELLM_API void gkrellm_store_chartdata(GkrellmChart *, gulong, ...);
GKRELLM_API void gkrellm_store_chartdatav(GkrellmChart *cp, gulong total, va_list args);
GKRELLM_API void gkrellm_draw_chartdata(GkrellmChart *);
GKRELLM_API void gkrellm_monotonic_chartdata(GkrellmChartdata *, gboolean);
GKRELLM_API gboolean gkrellm_get_chartdata_hide(GkrellmChartdata *);
GKRELLM_API gint gkrellm_get_current_chartdata(GkrellmChartdata *);
GKRELLM_API gint gkrellm_get_chartdata_data(GkrellmChartdata *, gint);
GKRELLM_API void gkrellm_set_chartdata_draw_style(GkrellmChartdata *, gint);
GKRELLM_API void gkrellm_set_chartdata_draw_style_default(GkrellmChartdata *, gint);
GKRELLM_API void gkrellm_set_chartdata_flags(GkrellmChartdata *, gint);
GKRELLM_API void gkrellm_scale_chartdata(GkrellmChartdata *, gint, gint);
GKRELLM_API void gkrellm_offset_chartdata(GkrellmChartdata *, gint);


  /* ChartConfig functions
  */
GKRELLM_API void gkrellm_chartconfig_window_create(GkrellmChart *);
GKRELLM_API void gkrellm_chartconfig_window_destroy(GkrellmChart *);
GKRELLM_API void gkrellm_chartconfig_grid_resolution_adjustment(
						GkrellmChartconfig *, gboolean, gfloat, gfloat, gfloat,
						gfloat, gfloat, gint, gint);
GKRELLM_API void gkrellm_set_chartconfig_grid_resolution(GkrellmChartconfig *,
						gint);
GKRELLM_API gint gkrellm_get_chartconfig_grid_resolution(GkrellmChartconfig *);
GKRELLM_API void gkrellm_chartconfig_grid_resolution_connect(GkrellmChartconfig* cf,
						void (*fn)(GkrellmChartconfig*, gpointer), gpointer);
GKRELLM_API void gkrellm_set_chartconfig_flags(GkrellmChartconfig *, gint);

GKRELLM_API void gkrellm_chartconfig_grid_resolution_label(
						GkrellmChartconfig *, gchar *);
GKRELLM_API void gkrellm_set_chartconfig_auto_grid_resolution(
						GkrellmChartconfig *, gboolean);
GKRELLM_API void gkrellm_set_chartconfig_auto_resolution_stick(
						GkrellmChartconfig *, gboolean);
GKRELLM_API void gkrellm_set_chartconfig_sequence_125(GkrellmChartconfig *,
						gboolean);
GKRELLM_API void gkrellm_set_chartconfig_fixed_grids(GkrellmChartconfig *, gint);
GKRELLM_API gint gkrellm_get_chartconfig_fixed_grids(GkrellmChartconfig *);
GKRELLM_API void gkrellm_chartconfig_fixed_grids_connect(GkrellmChartconfig *,
						void (*fn)(GkrellmChartconfig*, gpointer), gpointer);
GKRELLM_API gint gkrellm_get_chartconfig_height(GkrellmChartconfig *);
GKRELLM_API void gkrellm_chartconfig_height_connect(GkrellmChartconfig* cf,
						void (*fn)(GkrellmChartconfig*, gpointer), gpointer);
GKRELLM_API void gkrellm_chartconfig_callback_block(GkrellmChartconfig *, gboolean);
GKRELLM_API void gkrellm_save_chartconfig(FILE *, GkrellmChartconfig *,
						gchar *, gchar *);
GKRELLM_API void gkrellm_load_chartconfig(GkrellmChartconfig **, gchar *, gint);
GKRELLM_API void gkrellm_chartconfig_destroy(GkrellmChartconfig **);


  /* Panel functions
  */
GKRELLM_API void gkrellm_panel_configure(GkrellmPanel *, gchar *, GkrellmStyle *);
GKRELLM_API void gkrellm_panel_configure_add_height(GkrellmPanel *, gint);
GKRELLM_API void gkrellm_panel_configure_set_height(GkrellmPanel *p, gint h);
GKRELLM_API gint gkrellm_panel_configure_get_height(GkrellmPanel *p);
GKRELLM_API void gkrellm_panel_create(GtkWidget *, GkrellmMonitor *,GkrellmPanel *);
GKRELLM_API void gkrellm_panel_destroy(GkrellmPanel *);
GKRELLM_API void gkrellm_panel_hide(GkrellmPanel *);
GKRELLM_API void gkrellm_panel_show(GkrellmPanel *);
GKRELLM_API gboolean gkrellm_panel_enable_visibility(GkrellmPanel *p, gboolean,
						gboolean *);
GKRELLM_API gboolean gkrellm_is_panel_visible(GkrellmPanel *);
GKRELLM_API void gkrellm_panel_keep_lists(GkrellmPanel *, gboolean);
GKRELLM_API void gkrellm_draw_panel_label(GkrellmPanel *);
GKRELLM_API void gkrellm_panel_label_on_top_of_decals(GkrellmPanel *, gboolean);
GKRELLM_API void gkrellm_draw_panel_layers(GkrellmPanel *);
GKRELLM_API void gkrellm_draw_panel_layers_force(GkrellmPanel *);
GKRELLM_API void gkrellm_panel_bg_piximage_override(GkrellmPanel *,
						GkrellmPiximage *);
GKRELLM_API void gkrellm_panel_label_get_position(GkrellmStyle *style,
						gint *x_position, gint *y_off);


  /* Krell functions
  */
GKRELLM_API GkrellmKrell* gkrellm_create_krell(GkrellmPanel *, GkrellmPiximage *,
						GkrellmStyle *);
GKRELLM_API void gkrellm_set_krell_full_scale(GkrellmKrell *, gint, gint);
GKRELLM_API void gkrellm_set_style_krell_values(GkrellmStyle *, gint, gint, gint,
						gint, gint, gint, gint);
GKRELLM_API void gkrellm_set_style_krell_values_default(GkrellmStyle *s, gint yoff,
						gint depth, gint x_hot, gint expand, gint ema,
						gint left_margin, gint right_margin);
GKRELLM_API void gkrellm_set_style_slider_values_default(GkrellmStyle *s, gint yoff,
						gint left_margin, gint right_margin);
GKRELLM_API void gkrellm_set_krell_margins(GkrellmPanel *, GkrellmKrell *k,
						gint, gint);
GKRELLM_API void gkrellm_set_krell_expand(GkrellmStyle *, gchar *);
GKRELLM_API void gkrellm_update_krell(GkrellmPanel *, GkrellmKrell *, gulong);
GKRELLM_API void gkrellm_monotonic_krell_values(GkrellmKrell *k, gboolean);
GKRELLM_API void gkrellm_destroy_krell_list(GkrellmPanel *);
GKRELLM_API void gkrellm_destroy_krell(GkrellmKrell *);
GKRELLM_API void gkrellm_move_krell_yoff(GkrellmPanel *, GkrellmKrell *, gint);
GKRELLM_API void gkrellm_remove_krell(GkrellmPanel *, GkrellmKrell *);
GKRELLM_API void gkrellm_insert_krell(GkrellmPanel *, GkrellmKrell *, gboolean);
GKRELLM_API void gkrellm_insert_krell_nth(GkrellmPanel *, GkrellmKrell *, gint);


  /* Decal and Decalbutton functions
  */
GKRELLM_API GkrellmDecal* gkrellm_create_decal_text(GkrellmPanel *p, gchar *string,
						GkrellmTextstyle *ts, GkrellmStyle *style,
						gint x, gint y, gint w);
GKRELLM_API GkrellmDecal* gkrellm_create_decal_text_markup(GkrellmPanel *p, gchar *string,
						GkrellmTextstyle *ts, GkrellmStyle *style,
						gint x, gint y, gint w);
GKRELLM_API GkrellmDecal* gkrellm_create_decal_text_with_height(GkrellmPanel *p,
						GkrellmTextstyle *ts, GkrellmStyle *style,
						gint x, gint y, gint w, gint h, gint y_pad);
GKRELLM_API GkrellmDecal* gkrellm_create_decal_pixmap(GkrellmPanel *, GdkPixmap *,
						GdkBitmap *, gint, GkrellmStyle *, gint, gint);
GKRELLM_API GkrellmDecal* gkrellm_make_scaled_decal_pixmap(GkrellmPanel *p,
						GkrellmPiximage *im, GkrellmStyle *style, gint depth,
						gint x, gint y, gint w, gint h);
GKRELLM_API void gkrellm_decal_get_size(GkrellmDecal *d, gint *w, gint *h);
GKRELLM_API void gkrellm_draw_decal_pixmap(GkrellmPanel *, GkrellmDecal *, gint);
GKRELLM_API void gkrellm_draw_decal_text(GkrellmPanel *, GkrellmDecal *, gchar *,
						gint);
GKRELLM_API void gkrellm_draw_decal_markup(GkrellmPanel *, GkrellmDecal *, gchar *);
GKRELLM_API void gkrellm_decal_text_get_offset(GkrellmDecal *d, gint *x, gint *y);
GKRELLM_API void gkrellm_decal_text_set_offset(GkrellmDecal *d, gint x, gint y);
GKRELLM_API void gkrellm_decal_text_clear(GkrellmDecal *d);
GKRELLM_API void gkrellm_decal_text_insert(GkrellmDecal *d, gchar *s,
						GkrellmTextstyle *ts, gint x_off, gint y_off);
GKRELLM_API void gkrellm_decal_text_markup_insert(GkrellmDecal *d, gchar *s,
						GkrellmTextstyle *ts, gint x_off, gint y_off);
GKRELLM_API void gkrellm_decal_text_nth_inserted_set_offset(GkrellmDecal *d,
						gint n, gint x_off, gint y_off);
GKRELLM_API void gkrellm_decal_text_nth_inserted_get_offset(GkrellmDecal *d,
						gint n, gint *x_off, gint *y_off);
GKRELLM_API void gkrellm_decal_scroll_text_align_center(GkrellmDecal *d,
						gboolean center);
GKRELLM_API void gkrellm_decal_scroll_text_horizontal_loop(GkrellmDecal *d,
						gboolean loop);
GKRELLM_API void gkrellm_decal_scroll_text_vertical_loop(GkrellmDecal *d,
						gboolean loop);

GKRELLM_API void gkrellm_decal_scroll_text_get_size(GkrellmDecal *d,
						gint *w, gint *h);
GKRELLM_API void gkrellm_decal_scroll_text_set_markup(GkrellmPanel *p,
						GkrellmDecal *d, gchar *text);
GKRELLM_API void gkrellm_decal_scroll_text_set_text(GkrellmPanel *p,
						GkrellmDecal *d, gchar *text);

GKRELLM_API void gkrellm_draw_decal_on_chart(GkrellmChart *, GkrellmDecal *,
						gint, gint);
GKRELLM_API void gkrellm_move_decal(GkrellmPanel *, GkrellmDecal *, gint, gint);
GKRELLM_API void gkrellm_decal_on_top_layer(GkrellmDecal *, gboolean);
GKRELLM_API void gkrellm_destroy_decal(GkrellmDecal *);
GKRELLM_API void gkrellm_make_decal_visible(GkrellmPanel *, GkrellmDecal *);
GKRELLM_API void gkrellm_make_decal_invisible(GkrellmPanel *, GkrellmDecal *);
GKRELLM_API gint gkrellm_is_decal_visible(GkrellmDecal *);
GKRELLM_API void gkrellm_remove_decal(GkrellmPanel *, GkrellmDecal *);
GKRELLM_API void gkrellm_insert_decal(GkrellmPanel *, GkrellmDecal *, gboolean);
GKRELLM_API void gkrellm_insert_decal_nth(GkrellmPanel *, GkrellmDecal *, gint);
GKRELLM_API void gkrellm_destroy_decal_list(GkrellmPanel *);
GKRELLM_API void gkrellm_set_decal_button_index(GkrellmDecalbutton *, gint);
GKRELLM_API GkrellmDecalbutton* gkrellm_make_decal_button(GkrellmPanel *, GkrellmDecal *,
						void (*func)(), void *, gint, gint);
GKRELLM_API GkrellmDecalbutton* gkrellm_make_overlay_button(GkrellmPanel *,
						void (*func)(), void *, gint, gint, gint, gint,
						GkrellmPiximage *, GkrellmPiximage *);
GKRELLM_API GkrellmDecalbutton* gkrellm_put_decal_in_panel_button(GkrellmPanel *,
						GkrellmDecal *, void (*func)(), void *,
						GkrellmMargin *);
GKRELLM_API GkrellmDecalbutton* gkrellm_put_decal_in_meter_button(GkrellmPanel *,
						GkrellmDecal *, void (*func)(), void *,
						GkrellmMargin *);
GKRELLM_API GkrellmDecalbutton* gkrellm_put_label_in_panel_button(GkrellmPanel *,
						void (*func)(), void *, gint pad);
GKRELLM_API GkrellmDecalbutton* gkrellm_put_label_in_meter_button(GkrellmPanel *,
						void (*func)(), void *, gint pad);
GKRELLM_API GkrellmDecalbutton* gkrellm_make_scaled_button(GkrellmPanel *p,
						GkrellmPiximage *im, void (*func)(), void *data,
						gboolean auto_hide, gboolean set_default_border,
						gint depth, gint cur_index, gint pressed_index,
						gint x, gint y, gint w, gint h);

GKRELLM_API GkrellmDecalbutton *gkrellm_decal_is_button(GkrellmDecal *);
GKRELLM_API void gkrellm_set_in_button_callback(GkrellmDecalbutton *,
						gint (*func)(), gpointer data);
GKRELLM_API gboolean gkrellm_in_button(GkrellmDecalbutton *button, GdkEventButton *, gpointer data);
GKRELLM_API gboolean gkrellm_in_decal(GkrellmDecal *, GdkEventButton *);
GKRELLM_API void gkrellm_decal_button_connect(GkrellmDecalbutton *, void (*func)(),
						void *);
GKRELLM_API void gkrellm_decal_button_right_connect(GkrellmDecalbutton *,
						void (*func)(), void *);
GKRELLM_API void gkrellm_set_button_sensitive(GkrellmDecalbutton *, gboolean);
GKRELLM_API void gkrellm_hide_button(GkrellmDecalbutton *);
GKRELLM_API void gkrellm_show_button(GkrellmDecalbutton *);
GKRELLM_API void gkrellm_destroy_button(GkrellmDecalbutton *);


  /* Pixops
  */
GKRELLM_API gboolean gkrellm_load_piximage(gchar *, gchar **,
						GkrellmPiximage **, gchar *);
GKRELLM_API gboolean gkrellm_load_piximage_from_inline(gchar *, const guint8 *,
						GkrellmPiximage **, gchar *, gboolean);
GKRELLM_API GkrellmPiximage* gkrellm_piximage_new_from_inline(const guint8 *data,
						gboolean);
GKRELLM_API GkrellmPiximage* gkrellm_piximage_new_from_file(gchar *fname);
GKRELLM_API GkrellmPiximage* gkrellm_piximage_new_from_xpm_data(gchar **data);
GKRELLM_API void gkrellm_set_piximage_border(GkrellmPiximage *piximage,
						GkrellmBorder *border);
GKRELLM_API gboolean gkrellm_scale_pixbuf_to_pixmap(GdkPixbuf *src_pixbuf,
						GdkPixmap **pixmap, GdkBitmap **mask,
						gint w_dst, gint h_dst);
GKRELLM_API GdkPixbuf* gkrellm_scale_piximage_to_pixbuf(GkrellmPiximage *piximage,
						gint w_dst, gint h_dst);
GKRELLM_API gboolean gkrellm_scale_piximage_to_pixmap(GkrellmPiximage *, GdkPixmap **,
						GdkBitmap **, gint, gint);
GKRELLM_API void gkrellm_paste_piximage(GkrellmPiximage *src_piximage,
						GdkDrawable *drawable,
						gint x_dst, gint y_dst, gint w_dst, gint h_dst);
GKRELLM_API void gkrellm_paste_pixbuf(GdkPixbuf *src_pixbuf, GdkDrawable *drawable,
						gint x_dst, gint y_dst, gint w_dst, gint h_dst);
GKRELLM_API gboolean gkrellm_scale_theme_background(GkrellmPiximage *piximage,
						GdkPixmap **pixmap, GdkBitmap **mask,
						gint w_dst, gint h_dst);
GKRELLM_API void gkrellm_destroy_piximage(GkrellmPiximage *piximage);
GKRELLM_API GkrellmPiximage* gkrellm_clone_piximage(GkrellmPiximage *src_piximage);
GKRELLM_API gboolean gkrellm_clone_pixmap(GdkPixmap **, GdkPixmap **);
GKRELLM_API gboolean gkrellm_clone_bitmap(GdkBitmap **, GdkBitmap **);
GKRELLM_API void gkrellm_free_pixmap(GdkPixmap **);
GKRELLM_API void gkrellm_free_bitmap(GdkBitmap **);


  /* Misc support functions
  */
GKRELLM_API GtkWidget* gkrellm_get_top_window(void);
GKRELLM_API gboolean gkrellm_set_gkrellmrc_piximage_border(gchar *, GkrellmPiximage *,
						GkrellmStyle *);
GKRELLM_API gboolean gkrellm_get_gkrellmrc_integer(gchar *, gint *);
GKRELLM_API gchar* gkrellm_get_gkrellmrc_string(gchar *);
GKRELLM_API gboolean gkrellm_get_gkrellmrc_piximage_border(gchar *image_name,
						GkrellmPiximage *image, GkrellmBorder *border);
GKRELLM_API void gkrellm_freeze_side_frame_packing(void);
GKRELLM_API void gkrellm_thaw_side_frame_packing(void);
GKRELLM_API void gkrellm_pack_side_frames(void);
GKRELLM_API void gkrellm_draw_string(GdkDrawable *, GkrellmTextstyle *, gint, gint,
						gchar *);
GKRELLM_API void gkrellm_draw_text(GdkDrawable *, GkrellmTextstyle *, gint, gint,
						gchar *, gint);
GKRELLM_API void gkrellm_apply_launcher(GtkWidget **, GtkWidget **, GkrellmPanel *,
						GkrellmLauncher *, void (*func)());
GKRELLM_API void gkrellm_setup_launcher(GkrellmPanel *, GkrellmLauncher *, gint,
						gint);
GKRELLM_API void gkrellm_setup_decal_launcher(GkrellmPanel *, GkrellmLauncher *,
						GkrellmDecal *);
GKRELLM_API void gkrellm_remove_launcher(GkrellmLauncher *launch);
GKRELLM_API void gkrellm_configure_tooltip(GkrellmPanel *, GkrellmLauncher *);
GKRELLM_API void gkrellm_launch_button_cb(GkrellmDecalbutton *);
GKRELLM_API void gkrellm_disable_plugin_connect(GkrellmMonitor *, void (*func)());
GKRELLM_API pid_t gkrellm_get_pid(void);
GKRELLM_API void gkrellm_monitor_height_adjust(gint);
GKRELLM_API gboolean gkrellm_using_default_theme(void);
GKRELLM_API gfloat gkrellm_get_theme_scale(void);
GKRELLM_API void gkrellm_open_config_window(GkrellmMonitor *);
GKRELLM_API gboolean gkrellm_config_window_shown(void);
GKRELLM_API void gkrellm_config_modified(void);
GKRELLM_API void gkrellm_config_instant_apply(GkrellmMonitor *mon);
GKRELLM_API GkrellmMargin* gkrellm_get_style_margins(GkrellmStyle *);
GKRELLM_API void gkrellm_set_style_margins(GkrellmStyle *, GkrellmMargin *);
GKRELLM_API void gkrellm_get_top_bottom_margins(GkrellmStyle *, gint *, gint *);
GKRELLM_API gboolean gkrellm_style_is_themed(GkrellmStyle *, gint);
GKRELLM_API void gkrellm_message_dialog(gchar *title, gchar *message);
GKRELLM_API void gkrellm_config_message_dialog(gchar *title, gchar *message);
GKRELLM_API void gkrellm_spacers_set_types(GkrellmMonitor *mon, gint top, gint bot);
GKRELLM_API void gkrellm_message_window(gchar *title, gchar *message,
						GtkWidget *widget) GKRELLM_DEPRECATED_FOR(gkrellm_message_dialog);
GKRELLM_API void gkrellm_config_message_window(gchar *title, gchar *message,
						GtkWidget *widget) GKRELLM_DEPRECATED_FOR(gkrellm_config_message_dialog);
GKRELLM_API gchar* gkrellm_get_hostname(void);


  /* Alerts
  */
GKRELLM_API GkrellmAlert *gkrellm_alert_create(GkrellmPanel *, gchar *, gchar *,
						gboolean, gboolean, gboolean,
						gfloat, gfloat, gfloat, gfloat, gint);
GKRELLM_API void gkrellm_alert_dup(GkrellmAlert **a_dst, GkrellmAlert *a_src);
GKRELLM_API void gkrellm_alert_destroy(GkrellmAlert **);
GKRELLM_API void gkrellm_check_alert(GkrellmAlert *, gfloat);
GKRELLM_API void gkrellm_reset_alert(GkrellmAlert *alert);
GKRELLM_API void gkrellm_reset_alert_soft(GkrellmAlert *alert);
GKRELLM_API void gkrellm_reset_panel_alerts(GkrellmPanel *);
GKRELLM_API void gkrellm_freeze_alert(GkrellmAlert *);
GKRELLM_API void gkrellm_thaw_alert(GkrellmAlert *);
GKRELLM_API gboolean gkrellm_alert_is_activated(GkrellmAlert *alert);
GKRELLM_API void gkrellm_alert_get_alert_state(GkrellmAlert *alert,
						gboolean *alarm_state, gboolean *warn_state);
GKRELLM_API void gkrellm_alert_trigger_connect(GkrellmAlert *, void (*func)(),
						gpointer);
GKRELLM_API void gkrellm_alert_stop_connect(GkrellmAlert *, void (*func)(),
						gpointer);
GKRELLM_API void gkrellm_alert_config_connect(GkrellmAlert *, void (*func)(),
						gpointer);
GKRELLM_API void gkrellm_alert_config_create_connect(GkrellmAlert *alert,
						void (*func)(), gpointer);
GKRELLM_API void gkrellm_alert_command_process_connect(GkrellmAlert *alert,
						void (*func)(), gpointer data);
GKRELLM_API void gkrellm_render_default_alert_decal(GkrellmAlert *);
GKRELLM_API gboolean gkrellm_alert_decal_visible(GkrellmAlert *alert);
GKRELLM_API void gkrellm_alert_config_window(GkrellmAlert **);
GKRELLM_API void gkrellm_alert_window_destroy(GkrellmAlert **);
GKRELLM_API void gkrellm_save_alertconfig(FILE *, GkrellmAlert *, gchar *, gchar *);
GKRELLM_API void gkrellm_load_alertconfig(GkrellmAlert **, gchar *);
GKRELLM_API void gkrellm_alert_set_triggers(GkrellmAlert *alert,
						gfloat high_alarm, gfloat high_warn,
						gfloat low_warn, gfloat low_alarm);
GKRELLM_API void gkrellm_alert_set_delay(GkrellmAlert *alert, gint delay);
GKRELLM_API void gkrellm_alert_delay_config(GkrellmAlert *alert, gint step,
						gint high, gint low);
GKRELLM_API void gkrellm_alert_commands_config(GkrellmAlert *alert,
						gboolean alarm, gboolean warn);
  /* Alert plugin API
  */
GKRELLM_API GkrellmAlertPlugin* gkrellm_alert_plugin_add(GkrellmMonitor *mon,
						gchar *name);
GKRELLM_API void gkrellm_alert_plugin_alert_connect(GkrellmAlertPlugin *gap,
            			void (*alarm_func)(), void (*warn_func)(),
						void (*update_func)(), void (*check_func)(GkrellmAlert* alert, gpointer data, gfloat value),
						void (*destroy_func)());
GKRELLM_API void gkrellm_alert_plugin_config_connect(GkrellmAlertPlugin *gap,
						gchar *tab_name,
						void (*config_create_func)(),
						void (*config_apply_func)(),
						void (*config_save_func)(),
						void (*config_load_func)());
GKRELLM_API gchar* gkrellm_alert_plugin_config_get_id_string(GkrellmAlert *alert);
GKRELLM_API void gkrellm_alert_plugin_alert_attach(GkrellmAlertPlugin *gap,
            			GkrellmAlert *alert, gpointer data);
GKRELLM_API void gkrellm_alert_plugin_alert_detach(GkrellmAlertPlugin *gap,
						GkrellmAlert *alert);
GKRELLM_API gpointer gkrellm_alert_plugin_get_data(GkrellmAlertPlugin *gap,
						GkrellmAlert *alert);
GKRELLM_API void gkrellm_alert_plugin_command_process(GkrellmAlert *alert,
						gchar *src, gchar *dst, gint dst_size);


  /* GKrellM Styles and Textstyles
  */
GKRELLM_API gint gkrellm_add_chart_style(GkrellmMonitor *, gchar *);
GKRELLM_API gint gkrellm_add_meter_style(GkrellmMonitor *, gchar *);
GKRELLM_API gint gkrellm_lookup_chart_style_id(gchar *);
GKRELLM_API gint gkrellm_lookup_meter_style_id(gchar *);
GKRELLM_API GkrellmStyle *gkrellm_meter_style(gint);
GKRELLM_API GkrellmStyle *gkrellm_panel_style(gint);
GKRELLM_API GkrellmStyle *gkrellm_chart_style(gint);
GKRELLM_API GkrellmStyle *gkrellm_meter_style_by_name(gchar *);
GKRELLM_API GkrellmStyle *gkrellm_panel_style_by_name(gchar *);
GKRELLM_API GkrellmStyle *gkrellm_chart_style_by_name(gchar *);
GKRELLM_API GkrellmStyle *gkrellm_krell_slider_style(void);
GKRELLM_API GkrellmStyle *gkrellm_krell_mini_style(void);
GKRELLM_API GkrellmTextstyle *gkrellm_chart_textstyle(gint);
GKRELLM_API GkrellmTextstyle *gkrellm_panel_textstyle(gint);
GKRELLM_API GkrellmTextstyle *gkrellm_meter_textstyle(gint);
GKRELLM_API GkrellmTextstyle *gkrellm_chart_alt_textstyle(gint);
GKRELLM_API GkrellmTextstyle *gkrellm_panel_alt_textstyle(gint);
GKRELLM_API GkrellmTextstyle *gkrellm_meter_alt_textstyle(gint);


  /* Accessing GKrellM GkrellmPiximages and pixmaps
  */
GKRELLM_API GkrellmPiximage* gkrellm_bg_chart_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_bg_grid_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_bg_panel_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_bg_meter_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_krell_panel_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_krell_meter_piximage(gint);
GKRELLM_API GkrellmPiximage* gkrellm_krell_slider_piximage(void);
GKRELLM_API GkrellmPiximage* gkrellm_krell_mini_piximage(void);
GKRELLM_API void gkrellm_get_decal_alarm_piximage(GkrellmPiximage **, gint *);
GKRELLM_API void gkrellm_get_decal_warn_piximage(GkrellmPiximage **, gint *);
GKRELLM_API GdkPixmap** gkrellm_data_in_pixmap(void);
GKRELLM_API GdkPixmap* gkrellm_data_in_grid_pixmap(void);
GKRELLM_API GdkPixmap** gkrellm_data_out_pixmap(void);
GKRELLM_API GdkPixmap* gkrellm_data_out_grid_pixmap(void);
GKRELLM_API GdkPixmap* gkrellm_decal_misc_pixmap(void);
GKRELLM_API GdkBitmap* gkrellm_decal_misc_mask(void);


  /* Accessing other data from the GK struct
  */
GKRELLM_API GdkGC* gkrellm_draw_GC(gint);
GKRELLM_API GdkGC* gkrellm_bit_GC(gint);
GKRELLM_API PangoFontDescription *gkrellm_default_font(gint);
GKRELLM_API GdkColor* gkrellm_white_color(void);
GKRELLM_API GdkColor* gkrellm_black_color(void);
GKRELLM_API GdkColor* gkrellm_in_color(void);
GKRELLM_API GdkColor* gkrellm_out_color(void);
GKRELLM_API gboolean gkrellm_demo_mode(void);
GKRELLM_API gint gkrellm_update_HZ(void);
GKRELLM_API gchar* gkrellm_get_theme_path(void);
GKRELLM_API gint gkrellm_get_timer_ticks(void);
GKRELLM_API GkrellmTicks *gkrellm_ticks(void);
GKRELLM_API void gkrellm_allow_scaling(gboolean *, gint *);
GKRELLM_API gint gkrellm_plugin_debug(void);


  /* Exporting plugin labels to display on monitor panels or charts
  */
GKRELLM_API gint gkrellm_plugin_export_label(GkrellmMonitor *mon_plugin,
					gchar *mon_name,
            		gchar key, gchar *(*func)(gchar key, gchar *which));
GKRELLM_API void gkrellm_plugin_cancel_label(GkrellmMonitor *mon_plugin, gint id);
GKRELLM_API gchar* gkrellm_plugin_get_exported_label(GkrellmMonitor *mon,
					gchar key, gchar *which);

  /* Wrappers around gtk widget functions to provide a convenience higher level
  |  interface for creating the config pages.
  */
GKRELLM_API GtkWidget* gkrellm_gtk_notebook_page(GtkWidget *, gchar *);
GKRELLM_API GtkWidget* gkrellm_gtk_framed_notebook_page(GtkWidget *, char *);
GKRELLM_API GtkWidget* gkrellm_gtk_launcher_table_new(GtkWidget *, gint);
GKRELLM_API void gkrellm_gtk_config_launcher(GtkWidget *, gint, GtkWidget **,
						GtkWidget **, gchar *, GkrellmLauncher *);
GKRELLM_API gchar* gkrellm_gtk_entry_get_text(GtkWidget **);
GKRELLM_API void gkrellm_gtk_spin_button(GtkWidget *, GtkWidget **, gfloat, gfloat,
						gfloat, gfloat, gfloat, gint, gint, void (*func)(),
						gpointer, gboolean, gchar *);
GKRELLM_API void gkrellm_gtk_check_button(GtkWidget *, GtkWidget **, gboolean,
						gboolean, gint, gchar *);
GKRELLM_API void gkrellm_gtk_check_button_connected(GtkWidget *, GtkWidget **,
						gboolean, gboolean, gboolean, gint, void (*func)(),
						gpointer, gchar *);
GKRELLM_API void gkrellm_gtk_button_connected(GtkWidget *, GtkWidget **, gboolean,
						gboolean, gint, void (*func)(), gpointer, gchar *);
GKRELLM_API void gkrellm_gtk_alert_button(GtkWidget *box, GtkWidget **button,
						gboolean expand, gboolean fill, gint pad,
						gboolean pack_start, void (*cb_func)(), gpointer data);
GKRELLM_API GtkWidget* gkrellm_gtk_scrolled_vbox(GtkWidget *, GtkWidget **,
						GtkPolicyType, GtkPolicyType);
GKRELLM_API GtkWidget* gkrellm_gtk_framed_vbox(GtkWidget *, gchar *, gint, gboolean,
						gint, gint);
GKRELLM_API GtkWidget* gkrellm_gtk_framed_vbox_end(GtkWidget *, gchar *, gint, gboolean,
						gint, gint);
GKRELLM_API GtkWidget* gkrellm_gtk_category_vbox(GtkWidget *box, gchar *category_header,
        				gint header_pad, gint box_pad, gboolean pack_start);

GKRELLM_API GtkWidget* gkrellm_gtk_scrolled_text_view(GtkWidget *, GtkWidget **,
						GtkPolicyType, GtkPolicyType);
GKRELLM_API void gkrellm_gtk_text_view_append_strings(GtkWidget *, gchar **, gint);
GKRELLM_API void gkrellm_gtk_text_view_append(GtkWidget *, gchar *);

GKRELLM_API GtkTreeSelection *gkrellm_gtk_scrolled_selection(GtkTreeView *treeview,
			GtkWidget *box, GtkSelectionMode s_mode,
			GtkPolicyType h_policy, GtkPolicyType v_policy,
			void (*func_cb)(), gpointer data);


  /* Some utility functions
  */
GKRELLM_API gchar* gkrellm_homedir(void);
GKRELLM_API gboolean gkrellm_dup_string(gchar **, gchar *);
GKRELLM_API gboolean gkrellm_locale_dup_string(gchar **dst, gchar *src, gchar **locale);
GKRELLM_API gchar* gkrellm_dup_token(gchar **string, gchar *delimiters);
GKRELLM_API gchar* gkrellm_make_config_file_name(gchar *, gchar *);
GKRELLM_API gchar* gkrellm_make_data_file_name(gchar *, gchar *);
GKRELLM_API struct tm* gkrellm_get_current_time(void);
GKRELLM_API gint gkrellm_125_sequence(gint, gboolean, gint, gint,
						gboolean, gboolean);
GKRELLM_API void gkrellm_save_all(void);



  /* ------- Some builtin monitor public functions -------- */

  /* Functions exported by cpu.c
  */
GKRELLM_API gint gkrellm_smp_cpus(void);
GKRELLM_API gboolean gkrellm_cpu_stats(gint n, gulong *, gulong *, gulong *, gulong *);


  /* Functions exported by disk.c
  */
GKRELLM_API gboolean gkrellm_disk_temperature_display(gpointer sr, gchar *disk_name,
						gfloat t, gchar units);
GKRELLM_API void gkrellm_disk_temperature_remove(gchar *disk_name);


  /* Functions exported by net.c
  */
GKRELLM_API gint gkrellm_net_routes(void);
GKRELLM_API gboolean gkrellm_net_stats(gint n, gchar *, gulong *, gulong *);
GKRELLM_API void gkrellm_net_led_positions(gint *x_rx_led, gint *y_rx_led,
					gint *x_tx_led, gint *y_tx_led);


  /* Functions exported by the Mail monitor - see bottom of mail.c
  */
GKRELLM_API gboolean gkrellm_get_mail_mute_mode(void);
GKRELLM_API gpointer gkrellm_add_external_mbox(gint (*func)(), gboolean, gpointer);
GKRELLM_API void gkrellm_destroy_external_mbox(gpointer);
GKRELLM_API void gkrellm_set_external_mbox_counts(gpointer, gint, gint);
GKRELLM_API void gkrellm_set_external_mbox_tooltip(gpointer, gchar *);



/* -------- Client mode functions ----------- */

typedef void (*GkrellmClientDataFunc)(gchar *line);

GKRELLM_API gboolean gkrellm_client_mode(void);
GKRELLM_API void gkrellm_client_plugin_get_setup(gchar *key_name,
					GkrellmClientDataFunc setup_func_cb);
GKRELLM_API void gkrellm_client_plugin_serve_data_connect(GkrellmMonitor *mon,
					gchar *key_name,
					GkrellmClientDataFunc func_cb);
GKRELLM_API gboolean gkrellm_client_send_to_server(gchar *key_name, gchar *line);
GKRELLM_API gboolean gkrellm_client_check_server_version(gint major,
					gint minor, gint rev);

/* ------- Some aids for using PangoFontDescription -------*/
GKRELLM_API void gkrellm_text_extents(PangoFontDescription *font_desc,
					gchar *text, gint len, gint *width, gint *height,
					gint *baseline, gint *y_ink);
GKRELLM_API void gkrellm_text_markup_extents(PangoFontDescription *font_desc,
					gchar *text, gint len, gint *width, gint *height,
					gint *baseline, gint *y_ink);

GKRELLM_API gint gkrellm_gdk_string_width(PangoFontDescription *, gchar *);
GKRELLM_API gint gkrellm_gdk_string_markup_width(PangoFontDescription *, gchar *);
GKRELLM_API gint gkrellm_gdk_text_width(PangoFontDescription *font_desc,
					const gchar *string, gint len);
GKRELLM_API gint gkrellm_gdk_text_markup_width(PangoFontDescription *font_desc,
					const gchar *string, gint len);
GKRELLM_API void gkrellm_gdk_draw_string(GdkDrawable *drawable,
					PangoFontDescription *font,
					GdkGC *gc, gint x, gint y, gchar *string);
GKRELLM_API void gkrellm_gdk_draw_string_markup(GdkDrawable *drawable,
					PangoFontDescription *font,
					GdkGC *gc, gint x, gint y, gchar *string);
GKRELLM_API void gkrellm_gdk_draw_text(GdkDrawable *drawable,
					PangoFontDescription *font,
					GdkGC *gc, gint x, gint y, gchar *string, gint len);
GKRELLM_API void gkrellm_gdk_draw_text_markup(GdkDrawable *drawable,
					PangoFontDescription *font,
					GdkGC *gc, gint x, gint y, gchar *string, gint len);

G_END_DECLS

#endif