# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing.aio import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingProfilesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_validate_delete_eligibility(self, resource_group):
        response = await self.client.billing_profiles.validate_delete_eligibility(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.billing_profiles.begin_delete(
                billing_account_name="str",
                billing_profile_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.billing_profiles.get(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.billing_profiles.begin_create_or_update(
                billing_account_name="str",
                billing_profile_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "billTo": {
                            "addressLine1": "str",
                            "country": "str",
                            "addressLine2": "str",
                            "addressLine3": "str",
                            "city": "str",
                            "companyName": "str",
                            "district": "str",
                            "email": "str",
                            "firstName": "str",
                            "isValidAddress": bool,
                            "lastName": "str",
                            "middleName": "str",
                            "phoneNumber": "str",
                            "postalCode": "str",
                            "region": "str",
                        },
                        "billingRelationshipType": "str",
                        "currency": "str",
                        "currentPaymentTerm": {
                            "endDate": "2020-02-20 00:00:00",
                            "isDefault": bool,
                            "startDate": "2020-02-20 00:00:00",
                            "term": "str",
                        },
                        "displayName": "str",
                        "enabledAzurePlans": [{"productId": "str", "skuDescription": "str", "skuId": "str"}],
                        "hasReadAccess": bool,
                        "indirectRelationshipInfo": {
                            "billingAccountName": "str",
                            "billingProfileName": "str",
                            "displayName": "str",
                        },
                        "invoiceDay": 0,
                        "invoiceEmailOptIn": bool,
                        "invoiceRecipients": ["str"],
                        "otherPaymentTerms": [
                            {
                                "endDate": "2020-02-20 00:00:00",
                                "isDefault": bool,
                                "startDate": "2020-02-20 00:00:00",
                                "term": "str",
                            }
                        ],
                        "poNumber": "str",
                        "provisioningState": "str",
                        "shipTo": {
                            "addressLine1": "str",
                            "country": "str",
                            "addressLine2": "str",
                            "addressLine3": "str",
                            "city": "str",
                            "companyName": "str",
                            "district": "str",
                            "email": "str",
                            "firstName": "str",
                            "isValidAddress": bool,
                            "lastName": "str",
                            "middleName": "str",
                            "phoneNumber": "str",
                            "postalCode": "str",
                            "region": "str",
                        },
                        "soldTo": {
                            "addressLine1": "str",
                            "country": "str",
                            "addressLine2": "str",
                            "addressLine3": "str",
                            "city": "str",
                            "companyName": "str",
                            "district": "str",
                            "email": "str",
                            "firstName": "str",
                            "isValidAddress": bool,
                            "lastName": "str",
                            "middleName": "str",
                            "phoneNumber": "str",
                            "postalCode": "str",
                            "region": "str",
                        },
                        "spendingLimit": "str",
                        "spendingLimitDetails": [
                            {
                                "amount": 0.0,
                                "currency": "str",
                                "endDate": "2020-02-20 00:00:00",
                                "startDate": "2020-02-20 00:00:00",
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "status": "str",
                        "statusReasonCode": "str",
                        "systemId": "str",
                        "tags": {"str": "str"},
                        "targetClouds": ["str"],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_account(self, resource_group):
        response = self.client.billing_profiles.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
