--TEST--
Octal integer strings (32bit)
--SKIPIF--
<?php
if (PHP_INT_SIZE != 4) die("skip this test is for 32bit platform only");
?>
--FILE--
<?php
/* Using octal prefix notation lowercase */
/* Maximum value representable as integer */
$octal = 0o17777777777;
var_dump($octal);
var_dump(PHP_INT_MAX);

/* Floating number */
$octal = 0o45734321536435450000000000;
var_dump($octal);

/* Integer */
$octal = 0o16;
var_dump($octal);

/* underscore separator */
$octal = 0o1_6;
var_dump($octal);

/* Ignore leading 0 and _ */
$octal = 0o0_016;
var_dump($octal);
$octal = 0o0_16;
var_dump($octal);

/* Overflow to infinity */
$octal = 0o77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777;
var_dump($octal);

/* Using octal prefix notation uppercase */
/* Maximum value representable as integer */
$octal = 0O17777777777;
var_dump($octal);
var_dump(PHP_INT_MAX);

/* Floating number */
$octal = 0O45734321536435450000000000;
var_dump($octal);

/* Integer */
$octal = 0O16;
var_dump($octal);

/* underscore separator */
$octal = 0O1_6;
var_dump($octal);

/* Ignore leading 0 and _ */
$octal = 0O0_016;
var_dump($octal);
$octal = 0O0_16;
var_dump($octal);

/* Overflow to infinity */
$octal = 0O77777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777;
var_dump($octal);

/* Using no dedicated prefix */
/* Maximum value representable as integer */
$octal = 017777777777;
var_dump($octal);
var_dump(PHP_INT_MAX);

/* Floating number */
$octal = 045734321536435450000000000;
var_dump($octal);

/* Integer */
$octal = 016;
var_dump($octal);

/* underscore separator */
$octal = 01_6;
var_dump($octal);

/* Ignore leading 0 and _ */
$octal = 00_016;
var_dump($octal);
$octal = 0_16;
var_dump($octal);

/* Overflow to infinity */
$octal = 077777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777;
var_dump($octal);

?>
--EXPECT--
int(2147483647)
int(2147483647)
float(1.7912166229916324E+23)
int(14)
int(14)
int(14)
int(14)
float(INF)
int(2147483647)
int(2147483647)
float(1.7912166229916324E+23)
int(14)
int(14)
int(14)
int(14)
float(INF)
int(2147483647)
int(2147483647)
float(1.7912166229916324E+23)
int(14)
int(14)
int(14)
int(14)
float(INF)
