; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter "(bl|ptrue)" --version 5
; RUN: llc -mtriple=aarch64-gnu-linux -mattr=+neon,+sve -vector-library=sleefgnuabi < %s | FileCheck %s -check-prefix=SLEEF
; RUN: llc -mtriple=aarch64-gnu-linux -mattr=+neon,+sve -vector-library=ArmPL < %s | FileCheck %s -check-prefix=ARMPL

define void @test_sincos_v4f32(<4 x float> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincos_v4f32:
; SLEEF:    bl _ZGVnN4vl4l4_sincosf
;
; ARMPL-LABEL: test_sincos_v4f32:
; ARMPL:    bl armpl_vsincosq_f32
  %result = call { <4 x float>, <4 x float> } @llvm.sincos.v4f32(<4 x float> %x)
  %result.0 = extractvalue { <4 x float>, <4 x float> } %result, 0
  %result.1 = extractvalue { <4 x float>, <4 x float> } %result, 1
  store <4 x float> %result.0, ptr %out_sin, align 4
  store <4 x float> %result.1, ptr %out_cos, align 4
  ret void
}

define void @test_sincos_v2f64(<2 x double> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincos_v2f64:
; SLEEF:    bl _ZGVnN2vl8l8_sincos
;
; ARMPL-LABEL: test_sincos_v2f64:
; ARMPL:    bl armpl_vsincosq_f64
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %x)
  %result.0 = extractvalue { <2 x double>, <2 x double> } %result, 0
  %result.1 = extractvalue { <2 x double>, <2 x double> } %result, 1
  store <2 x double> %result.0, ptr %out_sin, align 8
  store <2 x double> %result.1, ptr %out_cos, align 8
  ret void
}

define void @test_sincos_nxv4f32(<vscale x 4 x float> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincos_nxv4f32:
; SLEEF:    bl _ZGVsNxvl4l4_sincosf
;
; ARMPL-LABEL: test_sincos_nxv4f32:
; ARMPL:    ptrue p0.s
; ARMPL:    bl armpl_svsincos_f32_x
  %result = call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.sincos.nxv4f32(<vscale x 4 x float> %x)
  %result.0 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %result, 0
  %result.1 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %result, 1
  store <vscale x 4 x float> %result.0, ptr %out_sin, align 4
  store <vscale x 4 x float> %result.1, ptr %out_cos, align 4
  ret void
}

define void @test_sincos_nxv2f64(<vscale x 2 x double> %x, ptr noalias %out_sin, ptr noalias %out_cos) {
; SLEEF-LABEL: test_sincos_nxv2f64:
; SLEEF:    bl _ZGVsNxvl8l8_sincos
;
; ARMPL-LABEL: test_sincos_nxv2f64:
; ARMPL:    ptrue p0.d
; ARMPL:    bl armpl_svsincos_f64_x
  %result = call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.sincos.nxv2f64(<vscale x 2 x double> %x)
  %result.0 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %result, 0
  %result.1 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %result, 1
  store <vscale x 2 x double> %result.0, ptr %out_sin, align 8
  store <vscale x 2 x double> %result.1, ptr %out_cos, align 8
  ret void
}
