; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -amdgpu-codegenprepare-disable-idiv-expansion=1 -mtriple=amdgcn-amd-amdpal -denormal-fp-math-f32=preserve-sign -mattr=+mad-mac-f32-insts < %s | FileCheck -check-prefixes=CHECK,GISEL %s
; RUN: llc -global-isel -amdgpu-codegenprepare-disable-idiv-expansion=0 -mtriple=amdgcn-amd-amdpal -denormal-fp-math-f32=preserve-sign -mattr=+mad-mac-f32-insts < %s | FileCheck -check-prefixes=CHECK,CGP %s

; The same 32-bit expansion is implemented in the legalizer and in AMDGPUCodeGenPrepare.

define i64 @v_udiv_i64(i64 %num, i64 %den) {
; CHECK-LABEL: v_udiv_i64:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mov_b32_e32 v4, v0
; CHECK-NEXT:    v_mov_b32_e32 v5, v1
; CHECK-NEXT:    v_or_b32_e32 v1, v5, v3
; CHECK-NEXT:    v_mov_b32_e32 v0, 0
; CHECK-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; CHECK-NEXT:    v_cvt_f32_u32_e32 v6, v2
; CHECK-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CHECK-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CHECK-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CHECK-NEXT:    s_cbranch_execnz .LBB0_3
; CHECK-NEXT:  ; %bb.1: ; %Flow
; CHECK-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CHECK-NEXT:    s_cbranch_execnz .LBB0_4
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    s_or_b64 exec, exec, s[6:7]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
; CHECK-NEXT:  .LBB0_3:
; CHECK-NEXT:    v_cvt_f32_u32_e32 v0, v3
; CHECK-NEXT:    v_sub_i32_e32 v1, vcc, 0, v2
; CHECK-NEXT:    v_subb_u32_e32 v7, vcc, 0, v3, vcc
; CHECK-NEXT:    v_mac_f32_e32 v6, 0x4f800000, v0
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v0, v6
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; CHECK-NEXT:    v_mul_f32_e32 v6, 0x2f800000, v0
; CHECK-NEXT:    v_trunc_f32_e32 v6, v6
; CHECK-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v6
; CHECK-NEXT:    v_cvt_u32_f32_e32 v6, v6
; CHECK-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v1, v6
; CHECK-NEXT:    v_mul_lo_u32 v9, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v10, v7, v0
; CHECK-NEXT:    v_mul_hi_u32 v11, v1, v0
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v10, v8
; CHECK-NEXT:    v_mul_lo_u32 v10, v6, v9
; CHECK-NEXT:    v_mul_hi_u32 v12, v0, v9
; CHECK-NEXT:    v_mul_hi_u32 v9, v6, v9
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v11
; CHECK-NEXT:    v_mul_lo_u32 v11, v0, v8
; CHECK-NEXT:    v_mul_lo_u32 v13, v6, v8
; CHECK-NEXT:    v_mul_hi_u32 v14, v0, v8
; CHECK-NEXT:    v_mul_hi_u32 v8, v6, v8
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v13, v9
; CHECK-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v14
; CHECK-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CHECK-NEXT:    v_add_i32_e32 v11, vcc, v13, v12
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v9
; CHECK-NEXT:    v_addc_u32_e32 v6, vcc, v6, v8, vcc
; CHECK-NEXT:    v_mul_lo_u32 v8, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v7, v7, v0
; CHECK-NEXT:    v_mul_hi_u32 v9, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v1, v1, v6
; CHECK-NEXT:    v_mul_lo_u32 v10, v6, v8
; CHECK-NEXT:    v_mul_hi_u32 v11, v0, v8
; CHECK-NEXT:    v_mul_hi_u32 v8, v6, v8
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v7, v1
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; CHECK-NEXT:    v_mul_lo_u32 v7, v0, v1
; CHECK-NEXT:    v_mul_lo_u32 v9, v6, v1
; CHECK-NEXT:    v_mul_hi_u32 v12, v0, v1
; CHECK-NEXT:    v_mul_hi_u32 v1, v6, v1
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v7, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v12
; CHECK-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v8
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v7
; CHECK-NEXT:    v_addc_u32_e32 v1, vcc, v6, v1, vcc
; CHECK-NEXT:    v_mul_lo_u32 v6, v5, v0
; CHECK-NEXT:    v_mul_hi_u32 v7, v4, v0
; CHECK-NEXT:    v_mul_hi_u32 v0, v5, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v4, v1
; CHECK-NEXT:    v_mul_lo_u32 v9, v5, v1
; CHECK-NEXT:    v_mul_hi_u32 v10, v4, v1
; CHECK-NEXT:    v_mul_hi_u32 v1, v5, v1
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v9, v0
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v9, v7
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; CHECK-NEXT:    v_mul_lo_u32 v7, v2, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v3, v0
; CHECK-NEXT:    v_mul_hi_u32 v9, v2, v0
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v6
; CHECK-NEXT:    v_mul_lo_u32 v6, v2, v1
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, 1, v0
; CHECK-NEXT:    v_addc_u32_e32 v11, vcc, 0, v1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, 1, v10
; CHECK-NEXT:    v_addc_u32_e32 v12, vcc, 0, v11, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v9
; CHECK-NEXT:    v_sub_i32_e32 v4, vcc, v4, v7
; CHECK-NEXT:    v_subb_u32_e64 v7, s[4:5], v5, v6, vcc
; CHECK-NEXT:    v_sub_i32_e64 v5, s[4:5], v5, v6
; CHECK-NEXT:    v_cmp_ge_u32_e64 s[4:5], v4, v2
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[4:5]
; CHECK-NEXT:    v_cmp_ge_u32_e64 s[4:5], v7, v3
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; CHECK-NEXT:    v_subb_u32_e32 v5, vcc, v5, v3, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; CHECK-NEXT:    v_cndmask_b32_e32 v6, v9, v6, vcc
; CHECK-NEXT:    v_sub_i32_e32 v4, vcc, v4, v2
; CHECK-NEXT:    v_subbrev_u32_e32 v5, vcc, 0, v5, vcc
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v2
; CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v3
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v3
; CHECK-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v2, v10, v8, vcc
; CHECK-NEXT:    v_cndmask_b32_e32 v3, v11, v12, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CHECK-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; CHECK-NEXT:    ; implicit-def: $vgpr6
; CHECK-NEXT:    ; implicit-def: $vgpr2
; CHECK-NEXT:    ; implicit-def: $vgpr4
; CHECK-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CHECK-NEXT:    s_cbranch_execz .LBB0_2
; CHECK-NEXT:  .LBB0_4:
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v0, v6
; CHECK-NEXT:    v_sub_i32_e32 v3, vcc, 0, v2
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CHECK-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CHECK-NEXT:    v_mul_lo_u32 v3, v3, v0
; CHECK-NEXT:    v_mul_hi_u32 v3, v0, v3
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; CHECK-NEXT:    v_mul_hi_u32 v0, v4, v0
; CHECK-NEXT:    v_mul_lo_u32 v3, v0, v2
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, 1, v0
; CHECK-NEXT:    v_sub_i32_e32 v3, vcc, v4, v3
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; CHECK-NEXT:    v_sub_i32_e64 v4, s[4:5], v3, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CHECK-NEXT:    s_or_b64 exec, exec, s[6:7]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %num, %den
  ret i64 %result
}

; FIXME: This is a workaround for not handling uniform VGPR case.
declare i32 @llvm.amdgcn.readfirstlane(i32)

define amdgpu_ps i64 @s_udiv_i64(i64 inreg %num, i64 inreg %den) {
; CHECK-LABEL: s_udiv_i64:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_or_b64 s[4:5], s[0:1], s[2:3]
; CHECK-NEXT:    s_mov_b32 s6, 0
; CHECK-NEXT:    s_mov_b32 s7, -1
; CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; CHECK-NEXT:    v_cmp_ne_u64_e64 vcc, s[4:5], 0
; CHECK-NEXT:    s_mov_b32 s6, 1
; CHECK-NEXT:    v_cvt_f32_u32_e32 v2, s2
; CHECK-NEXT:    s_cbranch_vccz .LBB1_2
; CHECK-NEXT:  ; %bb.1:
; CHECK-NEXT:    v_mov_b32_e32 v0, s3
; CHECK-NEXT:    v_cvt_f32_u32_e32 v1, s3
; CHECK-NEXT:    s_sub_u32 s4, 0, s2
; CHECK-NEXT:    v_mov_b32_e32 v3, s1
; CHECK-NEXT:    s_mov_b32 s6, 0
; CHECK-NEXT:    v_madmk_f32 v1, v1, 0x4f800000, v2
; CHECK-NEXT:    s_subb_u32 s5, 0, s3
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; CHECK-NEXT:    v_mul_f32_e32 v1, 0x5f7ffffc, v1
; CHECK-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v1
; CHECK-NEXT:    v_trunc_f32_e32 v4, v4
; CHECK-NEXT:    v_mac_f32_e32 v1, 0xcf800000, v4
; CHECK-NEXT:    v_cvt_u32_f32_e32 v4, v4
; CHECK-NEXT:    v_cvt_u32_f32_e32 v1, v1
; CHECK-NEXT:    v_mul_lo_u32 v5, s4, v4
; CHECK-NEXT:    v_mul_lo_u32 v6, s4, v1
; CHECK-NEXT:    v_mul_lo_u32 v7, s5, v1
; CHECK-NEXT:    v_mul_hi_u32 v8, s4, v1
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; CHECK-NEXT:    v_mul_lo_u32 v7, v4, v6
; CHECK-NEXT:    v_mul_hi_u32 v9, v1, v6
; CHECK-NEXT:    v_mul_hi_u32 v6, v4, v6
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; CHECK-NEXT:    v_mul_lo_u32 v8, v1, v5
; CHECK-NEXT:    v_mul_lo_u32 v10, v4, v5
; CHECK-NEXT:    v_mul_hi_u32 v11, v1, v5
; CHECK-NEXT:    v_mul_hi_u32 v5, v4, v5
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v10, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v7, v9
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v10, v9
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v6
; CHECK-NEXT:    v_addc_u32_e32 v4, vcc, v4, v5, vcc
; CHECK-NEXT:    v_mul_lo_u32 v5, s4, v1
; CHECK-NEXT:    v_mul_lo_u32 v6, s5, v1
; CHECK-NEXT:    v_mul_hi_u32 v7, s4, v1
; CHECK-NEXT:    v_mul_lo_u32 v8, s4, v4
; CHECK-NEXT:    v_mul_lo_u32 v9, v4, v5
; CHECK-NEXT:    v_mul_hi_u32 v10, v1, v5
; CHECK-NEXT:    v_mul_hi_u32 v5, v4, v5
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; CHECK-NEXT:    v_mul_lo_u32 v7, v1, v6
; CHECK-NEXT:    v_mul_lo_u32 v8, v4, v6
; CHECK-NEXT:    v_mul_hi_u32 v11, v1, v6
; CHECK-NEXT:    v_mul_hi_u32 v6, v4, v6
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v9, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v8, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v7, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v9, v7
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; CHECK-NEXT:    v_addc_u32_e32 v4, vcc, v4, v6, vcc
; CHECK-NEXT:    v_mul_lo_u32 v5, s1, v1
; CHECK-NEXT:    v_mul_hi_u32 v6, s0, v1
; CHECK-NEXT:    v_mul_hi_u32 v1, s1, v1
; CHECK-NEXT:    v_mul_lo_u32 v7, s0, v4
; CHECK-NEXT:    v_mul_lo_u32 v8, s1, v4
; CHECK-NEXT:    v_mul_hi_u32 v9, s0, v4
; CHECK-NEXT:    v_mul_hi_u32 v4, s1, v4
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v8, v1
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; CHECK-NEXT:    v_mul_lo_u32 v6, s2, v1
; CHECK-NEXT:    v_mul_lo_u32 v7, s3, v1
; CHECK-NEXT:    v_mul_hi_u32 v8, s2, v1
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, 1, v1
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, 1, v9
; CHECK-NEXT:    v_mul_lo_u32 v4, s2, v4
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v7, v4
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; CHECK-NEXT:    v_sub_i32_e32 v6, vcc, s0, v6
; CHECK-NEXT:    v_subb_u32_e64 v3, s[4:5], v3, v4, vcc
; CHECK-NEXT:    v_sub_i32_e64 v4, s[4:5], s1, v4
; CHECK-NEXT:    v_cmp_le_u32_e64 s[4:5], s2, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[4:5]
; CHECK-NEXT:    v_cmp_le_u32_e64 s[4:5], s3, v3
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, -1, s[4:5]
; CHECK-NEXT:    v_subb_u32_e32 v0, vcc, v4, v0, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s3, v3
; CHECK-NEXT:    v_cndmask_b32_e32 v3, v8, v7, vcc
; CHECK-NEXT:    v_subrev_i32_e32 v4, vcc, s2, v6
; CHECK-NEXT:    v_subbrev_u32_e32 v0, vcc, 0, v0, vcc
; CHECK-NEXT:    v_cmp_le_u32_e32 vcc, s2, v4
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; CHECK-NEXT:    v_cmp_le_u32_e32 vcc, s3, v0
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s3, v0
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v6, v4, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v9, v5, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CHECK-NEXT:    s_branch .LBB1_3
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CHECK-NEXT:  .LBB1_3: ; %Flow
; CHECK-NEXT:    s_xor_b32 s1, s6, 1
; CHECK-NEXT:    s_cmp_lg_u32 s1, 0
; CHECK-NEXT:    s_cbranch_scc1 .LBB1_5
; CHECK-NEXT:  ; %bb.4:
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v0, v2
; CHECK-NEXT:    s_sub_i32 s1, 0, s2
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CHECK-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CHECK-NEXT:    v_mul_lo_u32 v1, s1, v0
; CHECK-NEXT:    v_mul_hi_u32 v1, v0, v1
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; CHECK-NEXT:    v_mul_hi_u32 v0, s0, v0
; CHECK-NEXT:    v_mul_lo_u32 v1, v0, s2
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, 1, v0
; CHECK-NEXT:    v_sub_i32_e32 v1, vcc, s0, v1
; CHECK-NEXT:    v_cmp_le_u32_e32 vcc, s2, v1
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CHECK-NEXT:    v_subrev_i32_e64 v2, s[0:1], s2, v1
; CHECK-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, 1, v0
; CHECK-NEXT:    v_cmp_le_u32_e32 vcc, s2, v1
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CHECK-NEXT:  .LBB1_5:
; CHECK-NEXT:    v_readfirstlane_b32 s0, v0
; CHECK-NEXT:    s_mov_b32 s1, s0
; CHECK-NEXT:    ; return to shader part epilog
  %result = udiv i64 %num, %den
  %cast = bitcast i64 %result to <2 x i32>
  %elt.0 = extractelement <2 x i32> %cast, i32 0
  %elt.1 = extractelement <2 x i32> %cast, i32 1
  %res.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %elt.0)
  %res.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %elt.1)
  %ins.0 = insertelement <2 x i32> poison, i32 %res.0, i32 0
  %ins.1 = insertelement <2 x i32> %ins.0, i32 %res.0, i32 1
  %cast.back = bitcast <2 x i32> %ins.1 to i64
  ret i64 %cast.back
}

define <2 x i64> @v_udiv_v2i64(<2 x i64> %num, <2 x i64> %den) {
; GISEL-LABEL: v_udiv_v2i64:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_cvt_f32_u32_e32 v8, v4
; GISEL-NEXT:    v_cvt_f32_u32_e32 v9, v5
; GISEL-NEXT:    v_mac_f32_e32 v8, 0x4f800000, v9
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; GISEL-NEXT:    v_mul_f32_e32 v8, 0x5f7ffffc, v8
; GISEL-NEXT:    v_mul_f32_e32 v9, 0x2f800000, v8
; GISEL-NEXT:    v_trunc_f32_e32 v9, v9
; GISEL-NEXT:    v_mac_f32_e32 v8, 0xcf800000, v9
; GISEL-NEXT:    v_cvt_u32_f32_e32 v8, v8
; GISEL-NEXT:    v_cvt_u32_f32_e32 v9, v9
; GISEL-NEXT:    v_sub_i32_e32 v10, vcc, 0, v4
; GISEL-NEXT:    v_subb_u32_e32 v11, vcc, 0, v5, vcc
; GISEL-NEXT:    v_mul_lo_u32 v12, v10, v8
; GISEL-NEXT:    v_mul_lo_u32 v13, v11, v8
; GISEL-NEXT:    v_mul_lo_u32 v14, v10, v9
; GISEL-NEXT:    v_mul_hi_u32 v15, v10, v8
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; GISEL-NEXT:    v_mul_lo_u32 v14, v9, v12
; GISEL-NEXT:    v_mul_lo_u32 v15, v8, v13
; GISEL-NEXT:    v_mul_hi_u32 v16, v8, v12
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v15
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; GISEL-NEXT:    v_mul_lo_u32 v15, v9, v13
; GISEL-NEXT:    v_mul_hi_u32 v12, v9, v12
; GISEL-NEXT:    v_mul_hi_u32 v16, v8, v13
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v15, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v16
; GISEL-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; GISEL-NEXT:    v_mul_hi_u32 v13, v9, v13
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v12
; GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v13, vcc
; GISEL-NEXT:    v_mul_lo_u32 v12, v10, v8
; GISEL-NEXT:    v_mul_lo_u32 v11, v11, v8
; GISEL-NEXT:    v_mul_lo_u32 v13, v10, v9
; GISEL-NEXT:    v_mul_hi_u32 v10, v10, v8
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v9, v12
; GISEL-NEXT:    v_mul_lo_u32 v13, v8, v10
; GISEL-NEXT:    v_mul_hi_u32 v14, v8, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v13, v11
; GISEL-NEXT:    v_mul_lo_u32 v13, v9, v10
; GISEL-NEXT:    v_mul_hi_u32 v12, v9, v12
; GISEL-NEXT:    v_mul_hi_u32 v14, v8, v10
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_hi_u32 v10, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v11
; GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v10, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v1, v8
; GISEL-NEXT:    v_mul_lo_u32 v11, v0, v9
; GISEL-NEXT:    v_mul_hi_u32 v12, v0, v8
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v1, v9
; GISEL-NEXT:    v_mul_hi_u32 v8, v1, v8
; GISEL-NEXT:    v_mul_hi_u32 v12, v0, v9
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v11, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_hi_u32 v9, v1, v9
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_mul_lo_u32 v10, v4, v8
; GISEL-NEXT:    v_mul_lo_u32 v11, v5, v8
; GISEL-NEXT:    v_mul_lo_u32 v12, v4, v9
; GISEL-NEXT:    v_mul_hi_u32 v13, v4, v8
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v10
; GISEL-NEXT:    v_subb_u32_e64 v10, s[4:5], v1, v11, vcc
; GISEL-NEXT:    v_sub_i32_e64 v1, s[4:5], v1, v11
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v10, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v0, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v10, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v10, v11, v12, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v0, s[4:5], v0, v4
; GISEL-NEXT:    v_subb_u32_e32 v1, vcc, v1, v5, vcc
; GISEL-NEXT:    v_subbrev_u32_e64 v1, vcc, 0, v1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, 1, v8
; GISEL-NEXT:    v_addc_u32_e32 v12, vcc, 0, v9, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, -1, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v5
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v13, v0, vcc
; GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v11
; GISEL-NEXT:    v_addc_u32_e32 v4, vcc, 0, v12, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v11, v1, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v12, v4, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v8, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GISEL-NEXT:    v_cvt_f32_u32_e32 v4, v6
; GISEL-NEXT:    v_cvt_f32_u32_e32 v5, v7
; GISEL-NEXT:    v_mac_f32_e32 v4, 0x4f800000, v5
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v4, v4
; GISEL-NEXT:    v_mul_f32_e32 v4, 0x5f7ffffc, v4
; GISEL-NEXT:    v_mul_f32_e32 v5, 0x2f800000, v4
; GISEL-NEXT:    v_trunc_f32_e32 v5, v5
; GISEL-NEXT:    v_mac_f32_e32 v4, 0xcf800000, v5
; GISEL-NEXT:    v_cvt_u32_f32_e32 v4, v4
; GISEL-NEXT:    v_cvt_u32_f32_e32 v5, v5
; GISEL-NEXT:    v_sub_i32_e32 v8, vcc, 0, v6
; GISEL-NEXT:    v_subb_u32_e32 v9, vcc, 0, v7, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v8, v4
; GISEL-NEXT:    v_mul_lo_u32 v11, v9, v4
; GISEL-NEXT:    v_mul_lo_u32 v12, v8, v5
; GISEL-NEXT:    v_mul_hi_u32 v13, v8, v4
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_mul_lo_u32 v12, v5, v10
; GISEL-NEXT:    v_mul_lo_u32 v13, v4, v11
; GISEL-NEXT:    v_mul_hi_u32 v14, v4, v10
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_lo_u32 v13, v5, v11
; GISEL-NEXT:    v_mul_hi_u32 v10, v5, v10
; GISEL-NEXT:    v_mul_hi_u32 v14, v4, v11
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v13, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_hi_u32 v11, v5, v11
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v10
; GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v11, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v8, v4
; GISEL-NEXT:    v_mul_lo_u32 v9, v9, v4
; GISEL-NEXT:    v_mul_lo_u32 v11, v8, v5
; GISEL-NEXT:    v_mul_hi_u32 v8, v8, v4
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v5, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v4, v8
; GISEL-NEXT:    v_mul_hi_u32 v12, v4, v10
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v11, v9
; GISEL-NEXT:    v_mul_lo_u32 v11, v5, v8
; GISEL-NEXT:    v_mul_hi_u32 v10, v5, v10
; GISEL-NEXT:    v_mul_hi_u32 v12, v4, v8
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_hi_u32 v8, v5, v8
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v9
; GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v8, vcc
; GISEL-NEXT:    v_mul_lo_u32 v8, v3, v4
; GISEL-NEXT:    v_mul_lo_u32 v9, v2, v5
; GISEL-NEXT:    v_mul_hi_u32 v10, v2, v4
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v3, v5
; GISEL-NEXT:    v_mul_hi_u32 v4, v3, v4
; GISEL-NEXT:    v_mul_hi_u32 v10, v2, v5
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v9, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_hi_u32 v5, v3, v5
; GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GISEL-NEXT:    v_mul_lo_u32 v8, v6, v4
; GISEL-NEXT:    v_mul_lo_u32 v9, v7, v4
; GISEL-NEXT:    v_mul_lo_u32 v10, v6, v5
; GISEL-NEXT:    v_mul_hi_u32 v11, v6, v4
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_sub_i32_e32 v2, vcc, v2, v8
; GISEL-NEXT:    v_subb_u32_e64 v8, s[4:5], v3, v9, vcc
; GISEL-NEXT:    v_sub_i32_e64 v3, s[4:5], v3, v9
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v8, v7
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v2, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v8, v7
; GISEL-NEXT:    v_cndmask_b32_e64 v8, v9, v10, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v2, s[4:5], v2, v6
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v3, v7, vcc
; GISEL-NEXT:    v_subbrev_u32_e64 v3, vcc, 0, v3, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v4
; GISEL-NEXT:    v_addc_u32_e32 v10, vcc, 0, v5, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v7
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, -1, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v9
; GISEL-NEXT:    v_addc_u32_e32 v6, vcc, 0, v10, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v9, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v10, v6, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; CGP-LABEL: v_udiv_v2i64:
; CGP:       ; %bb.0:
; CGP-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CGP-NEXT:    v_mov_b32_e32 v10, v0
; CGP-NEXT:    v_mov_b32_e32 v11, v1
; CGP-NEXT:    v_mov_b32_e32 v8, v2
; CGP-NEXT:    v_mov_b32_e32 v9, v3
; CGP-NEXT:    v_or_b32_e32 v1, v11, v5
; CGP-NEXT:    v_mov_b32_e32 v0, 0
; CGP-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; CGP-NEXT:    v_cvt_f32_u32_e32 v2, v4
; CGP-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CGP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CGP-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CGP-NEXT:    s_cbranch_execz .LBB2_2
; CGP-NEXT:  ; %bb.1:
; CGP-NEXT:    v_cvt_f32_u32_e32 v0, v5
; CGP-NEXT:    v_sub_i32_e32 v1, vcc, 0, v4
; CGP-NEXT:    v_subb_u32_e32 v3, vcc, 0, v5, vcc
; CGP-NEXT:    v_mac_f32_e32 v2, 0x4f800000, v0
; CGP-NEXT:    v_rcp_iflag_f32_e32 v0, v2
; CGP-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; CGP-NEXT:    v_mul_f32_e32 v2, 0x2f800000, v0
; CGP-NEXT:    v_trunc_f32_e32 v2, v2
; CGP-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v2
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CGP-NEXT:    v_mul_lo_u32 v12, v1, v2
; CGP-NEXT:    v_mul_lo_u32 v13, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v14, v3, v0
; CGP-NEXT:    v_mul_hi_u32 v15, v1, v0
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v14, v12
; CGP-NEXT:    v_mul_lo_u32 v14, v2, v13
; CGP-NEXT:    v_mul_hi_u32 v16, v0, v13
; CGP-NEXT:    v_mul_hi_u32 v13, v2, v13
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v15
; CGP-NEXT:    v_mul_lo_u32 v15, v0, v12
; CGP-NEXT:    v_mul_lo_u32 v17, v2, v12
; CGP-NEXT:    v_mul_hi_u32 v18, v0, v12
; CGP-NEXT:    v_mul_hi_u32 v12, v2, v12
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v14, v15
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v17, v13
; CGP-NEXT:    v_cndmask_b32_e64 v17, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v18
; CGP-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; CGP-NEXT:    v_add_i32_e32 v15, vcc, v17, v16
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v13
; CGP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v12, vcc
; CGP-NEXT:    v_mul_lo_u32 v12, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v3, v3, v0
; CGP-NEXT:    v_mul_hi_u32 v13, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v1, v1, v2
; CGP-NEXT:    v_mul_lo_u32 v14, v2, v12
; CGP-NEXT:    v_mul_hi_u32 v15, v0, v12
; CGP-NEXT:    v_mul_hi_u32 v12, v2, v12
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v13
; CGP-NEXT:    v_mul_lo_u32 v3, v0, v1
; CGP-NEXT:    v_mul_lo_u32 v13, v2, v1
; CGP-NEXT:    v_mul_hi_u32 v16, v0, v1
; CGP-NEXT:    v_mul_hi_u32 v1, v2, v1
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v14, v3
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v15
; CGP-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v16
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v14, v3
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v12, v3
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v12
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; CGP-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; CGP-NEXT:    v_mul_lo_u32 v2, v11, v0
; CGP-NEXT:    v_mul_hi_u32 v3, v10, v0
; CGP-NEXT:    v_mul_hi_u32 v0, v11, v0
; CGP-NEXT:    v_mul_lo_u32 v12, v10, v1
; CGP-NEXT:    v_mul_lo_u32 v13, v11, v1
; CGP-NEXT:    v_mul_hi_u32 v14, v10, v1
; CGP-NEXT:    v_mul_hi_u32 v1, v11, v1
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v12
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v13, v0
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; CGP-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v14
; CGP-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v12, v2
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v13, v3
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CGP-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v3, v4, v0
; CGP-NEXT:    v_mul_lo_u32 v12, v5, v0
; CGP-NEXT:    v_mul_hi_u32 v13, v4, v0
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; CGP-NEXT:    v_mul_lo_u32 v2, v4, v1
; CGP-NEXT:    v_add_i32_e32 v14, vcc, 1, v0
; CGP-NEXT:    v_addc_u32_e32 v15, vcc, 0, v1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v12, v2
; CGP-NEXT:    v_add_i32_e32 v12, vcc, 1, v14
; CGP-NEXT:    v_addc_u32_e32 v16, vcc, 0, v15, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v13
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, v10, v3
; CGP-NEXT:    v_subb_u32_e64 v10, s[4:5], v11, v2, vcc
; CGP-NEXT:    v_sub_i32_e64 v2, s[4:5], v11, v2
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v3, v4
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[4:5]
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v10, v5
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, -1, s[4:5]
; CGP-NEXT:    v_subb_u32_e32 v2, vcc, v2, v5, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v5
; CGP-NEXT:    v_cndmask_b32_e32 v10, v13, v11, vcc
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, v3, v4
; CGP-NEXT:    v_subbrev_u32_e32 v2, vcc, 0, v2, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v4
; CGP-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v5
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v5
; CGP-NEXT:    v_cndmask_b32_e32 v2, v4, v3, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; CGP-NEXT:    v_cndmask_b32_e32 v2, v14, v12, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v3, v15, v16, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; CGP-NEXT:    ; implicit-def: $vgpr2
; CGP-NEXT:    ; implicit-def: $vgpr4
; CGP-NEXT:    ; implicit-def: $vgpr10
; CGP-NEXT:  .LBB2_2: ; %Flow1
; CGP-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    s_cbranch_execz .LBB2_4
; CGP-NEXT:  ; %bb.3:
; CGP-NEXT:    v_rcp_iflag_f32_e32 v0, v2
; CGP-NEXT:    v_sub_i32_e32 v2, vcc, 0, v4
; CGP-NEXT:    v_mov_b32_e32 v1, 0
; CGP-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CGP-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CGP-NEXT:    v_mul_lo_u32 v2, v2, v0
; CGP-NEXT:    v_mul_hi_u32 v2, v0, v2
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CGP-NEXT:    v_mul_hi_u32 v0, v10, v0
; CGP-NEXT:    v_mul_lo_u32 v2, v0, v4
; CGP-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; CGP-NEXT:    v_sub_i32_e32 v2, vcc, v10, v2
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v4
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; CGP-NEXT:    v_sub_i32_e64 v3, s[4:5], v2, v4
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CGP-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v4
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; CGP-NEXT:  .LBB2_4:
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    v_or_b32_e32 v3, v9, v7
; CGP-NEXT:    v_mov_b32_e32 v2, 0
; CGP-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; CGP-NEXT:    v_cvt_f32_u32_e32 v4, v6
; CGP-NEXT:    ; implicit-def: $vgpr2_vgpr3
; CGP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CGP-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CGP-NEXT:    s_cbranch_execnz .LBB2_7
; CGP-NEXT:  ; %bb.5: ; %Flow
; CGP-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    s_cbranch_execnz .LBB2_8
; CGP-NEXT:  .LBB2_6:
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    s_setpc_b64 s[30:31]
; CGP-NEXT:  .LBB2_7:
; CGP-NEXT:    v_cvt_f32_u32_e32 v2, v7
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, 0, v6
; CGP-NEXT:    v_subb_u32_e32 v5, vcc, 0, v7, vcc
; CGP-NEXT:    v_mac_f32_e32 v4, 0x4f800000, v2
; CGP-NEXT:    v_rcp_iflag_f32_e32 v2, v4
; CGP-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; CGP-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v2
; CGP-NEXT:    v_trunc_f32_e32 v4, v4
; CGP-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v4, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_mul_lo_u32 v10, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v11, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v12, v5, v2
; CGP-NEXT:    v_mul_hi_u32 v13, v3, v2
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v12, v10
; CGP-NEXT:    v_mul_lo_u32 v12, v4, v11
; CGP-NEXT:    v_mul_hi_u32 v14, v2, v11
; CGP-NEXT:    v_mul_hi_u32 v11, v4, v11
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v10, v13
; CGP-NEXT:    v_mul_lo_u32 v13, v2, v10
; CGP-NEXT:    v_mul_lo_u32 v15, v4, v10
; CGP-NEXT:    v_mul_hi_u32 v16, v2, v10
; CGP-NEXT:    v_mul_hi_u32 v10, v4, v10
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v13
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v15, v11
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v16
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v15, v14
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v11
; CGP-NEXT:    v_addc_u32_e32 v4, vcc, v4, v10, vcc
; CGP-NEXT:    v_mul_lo_u32 v10, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v5, v5, v2
; CGP-NEXT:    v_mul_hi_u32 v11, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v3, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v12, v4, v10
; CGP-NEXT:    v_mul_hi_u32 v13, v2, v10
; CGP-NEXT:    v_mul_hi_u32 v10, v4, v10
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v5, v3
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; CGP-NEXT:    v_mul_lo_u32 v5, v2, v3
; CGP-NEXT:    v_mul_lo_u32 v11, v4, v3
; CGP-NEXT:    v_mul_hi_u32 v14, v2, v3
; CGP-NEXT:    v_mul_hi_u32 v3, v4, v3
; CGP-NEXT:    v_add_i32_e32 v5, vcc, v12, v5
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; CGP-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v10, v14
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v5, vcc, v12, v5
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; CGP-NEXT:    v_add_i32_e32 v5, vcc, v10, v5
; CGP-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v10
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; CGP-NEXT:    v_addc_u32_e32 v3, vcc, v4, v3, vcc
; CGP-NEXT:    v_mul_lo_u32 v4, v9, v2
; CGP-NEXT:    v_mul_hi_u32 v5, v8, v2
; CGP-NEXT:    v_mul_hi_u32 v2, v9, v2
; CGP-NEXT:    v_mul_lo_u32 v10, v8, v3
; CGP-NEXT:    v_mul_lo_u32 v11, v9, v3
; CGP-NEXT:    v_mul_hi_u32 v12, v8, v3
; CGP-NEXT:    v_mul_hi_u32 v3, v9, v3
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v10
; CGP-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v11, v2
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v12
; CGP-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v10, v4
; CGP-NEXT:    v_add_i32_e32 v5, vcc, v11, v5
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; CGP-NEXT:    v_mul_lo_u32 v5, v6, v2
; CGP-NEXT:    v_mul_lo_u32 v10, v7, v2
; CGP-NEXT:    v_mul_hi_u32 v11, v6, v2
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v4, v6, v3
; CGP-NEXT:    v_add_i32_e32 v12, vcc, 1, v2
; CGP-NEXT:    v_addc_u32_e32 v13, vcc, 0, v3, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v10, v4
; CGP-NEXT:    v_add_i32_e32 v10, vcc, 1, v12
; CGP-NEXT:    v_addc_u32_e32 v14, vcc, 0, v13, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v11
; CGP-NEXT:    v_sub_i32_e32 v5, vcc, v8, v5
; CGP-NEXT:    v_subb_u32_e64 v8, s[4:5], v9, v4, vcc
; CGP-NEXT:    v_sub_i32_e64 v4, s[4:5], v9, v4
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v5, v6
; CGP-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v8, v7
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[4:5]
; CGP-NEXT:    v_subb_u32_e32 v4, vcc, v4, v7, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; CGP-NEXT:    v_cndmask_b32_e32 v8, v11, v9, vcc
; CGP-NEXT:    v_sub_i32_e32 v5, vcc, v5, v6
; CGP-NEXT:    v_subbrev_u32_e32 v4, vcc, 0, v4, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v6
; CGP-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v7
; CGP-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; CGP-NEXT:    v_cndmask_b32_e32 v4, v6, v5, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; CGP-NEXT:    v_cndmask_b32_e32 v4, v12, v10, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v5, v13, v14, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; CGP-NEXT:    ; implicit-def: $vgpr4
; CGP-NEXT:    ; implicit-def: $vgpr6
; CGP-NEXT:    ; implicit-def: $vgpr8
; CGP-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    s_cbranch_execz .LBB2_6
; CGP-NEXT:  .LBB2_8:
; CGP-NEXT:    v_rcp_iflag_f32_e32 v2, v4
; CGP-NEXT:    v_sub_i32_e32 v4, vcc, 0, v6
; CGP-NEXT:    v_mov_b32_e32 v3, 0
; CGP-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_mul_lo_u32 v4, v4, v2
; CGP-NEXT:    v_mul_hi_u32 v4, v2, v4
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CGP-NEXT:    v_mul_hi_u32 v2, v8, v2
; CGP-NEXT:    v_mul_lo_u32 v4, v2, v6
; CGP-NEXT:    v_add_i32_e32 v5, vcc, 1, v2
; CGP-NEXT:    v_sub_i32_e32 v4, vcc, v8, v4
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v6
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; CGP-NEXT:    v_sub_i32_e64 v5, s[4:5], v4, v6
; CGP-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; CGP-NEXT:    v_add_i32_e32 v5, vcc, 1, v2
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v6
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv <2 x i64> %num, %den
  ret <2 x i64> %result
}

define i64 @v_udiv_i64_pow2k_denom(i64 %num) {
; CHECK-LABEL: v_udiv_i64_pow2k_denom:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_lshr_b64 v[0:1], v[0:1], 12
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %num, 4096
  ret i64 %result
}

define <2 x i64> @v_udiv_v2i64_pow2k_denom(<2 x i64> %num) {
; CHECK-LABEL: v_udiv_v2i64_pow2k_denom:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_lshr_b64 v[0:1], v[0:1], 12
; CHECK-NEXT:    v_lshr_b64 v[2:3], v[2:3], 12
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv <2 x i64> %num, <i64 4096, i64 4096>
  ret <2 x i64> %result
}

define i64 @v_udiv_i64_oddk_denom(i64 %num) {
; CHECK-LABEL: v_udiv_i64_oddk_denom:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mov_b32_e32 v2, 0x1fb03c31
; CHECK-NEXT:    v_mov_b32_e32 v3, 0xd9528440
; CHECK-NEXT:    v_mul_lo_u32 v4, v1, v2
; CHECK-NEXT:    v_mul_lo_u32 v5, v0, v3
; CHECK-NEXT:    v_mul_hi_u32 v6, v0, v2
; CHECK-NEXT:    v_mul_lo_u32 v7, v1, v3
; CHECK-NEXT:    v_mul_hi_u32 v2, v1, v2
; CHECK-NEXT:    v_mul_hi_u32 v0, v0, v3
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v7, v2
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v7, v2
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CHECK-NEXT:    v_mul_hi_u32 v1, v1, v3
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; CHECK-NEXT:    v_lshr_b64 v[0:1], v[0:1], 20
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv i64 %num, 1235195
  ret i64 %result
}

define <2 x i64> @v_udiv_v2i64_oddk_denom(<2 x i64> %num) {
; CHECK-LABEL: v_udiv_v2i64_oddk_denom:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mov_b32_e32 v4, 0x1fb03c31
; CHECK-NEXT:    v_mov_b32_e32 v5, 0xd9528440
; CHECK-NEXT:    v_mul_lo_u32 v6, v1, v4
; CHECK-NEXT:    v_mul_lo_u32 v7, v0, v5
; CHECK-NEXT:    v_mul_hi_u32 v8, v0, v4
; CHECK-NEXT:    v_mul_lo_u32 v9, v1, v5
; CHECK-NEXT:    v_mul_hi_u32 v10, v1, v4
; CHECK-NEXT:    v_mul_hi_u32 v0, v0, v5
; CHECK-NEXT:    v_mul_hi_u32 v1, v1, v5
; CHECK-NEXT:    v_mul_lo_u32 v11, v3, v4
; CHECK-NEXT:    v_mul_lo_u32 v12, v2, v5
; CHECK-NEXT:    v_mul_hi_u32 v13, v2, v4
; CHECK-NEXT:    v_mul_lo_u32 v14, v3, v5
; CHECK-NEXT:    v_mul_hi_u32 v4, v3, v4
; CHECK-NEXT:    v_mul_hi_u32 v2, v2, v5
; CHECK-NEXT:    v_mul_hi_u32 v3, v3, v5
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v6, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v9, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v11, v12
; CHECK-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v14, v4
; CHECK-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v7, v0
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v10, v13
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; CHECK-NEXT:    v_add_i32_e32 v6, vcc, v9, v7
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v11, v8
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v12, v4
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v2, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, v4, v7
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; CHECK-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; CHECK-NEXT:    v_lshr_b64 v[0:1], v[0:1], 20
; CHECK-NEXT:    v_lshr_b64 v[2:3], v[2:3], 20
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %result = udiv <2 x i64> %num, <i64 1235195, i64 1235195>
  ret <2 x i64> %result
}

define i64 @v_udiv_i64_pow2_shl_denom(i64 %x, i64 %y) {
; CHECK-LABEL: v_udiv_i64_pow2_shl_denom:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_mov_b32_e32 v3, v0
; CHECK-NEXT:    v_mov_b32_e32 v4, v1
; CHECK-NEXT:    v_mov_b32_e32 v0, 0x1000
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    v_mov_b32_e32 v7, 0
; CHECK-NEXT:    v_lshl_b64 v[5:6], v[0:1], v2
; CHECK-NEXT:    v_or_b32_e32 v8, v4, v6
; CHECK-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[7:8]
; CHECK-NEXT:    v_cvt_f32_u32_e32 v2, v5
; CHECK-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CHECK-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CHECK-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CHECK-NEXT:    s_cbranch_execnz .LBB7_3
; CHECK-NEXT:  ; %bb.1: ; %Flow
; CHECK-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CHECK-NEXT:    s_cbranch_execnz .LBB7_4
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    s_or_b64 exec, exec, s[6:7]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
; CHECK-NEXT:  .LBB7_3:
; CHECK-NEXT:    v_cvt_f32_u32_e32 v0, v6
; CHECK-NEXT:    v_sub_i32_e32 v1, vcc, 0, v5
; CHECK-NEXT:    v_subb_u32_e32 v7, vcc, 0, v6, vcc
; CHECK-NEXT:    v_mac_f32_e32 v2, 0x4f800000, v0
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v0, v2
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; CHECK-NEXT:    v_mul_f32_e32 v2, 0x2f800000, v0
; CHECK-NEXT:    v_trunc_f32_e32 v2, v2
; CHECK-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v2
; CHECK-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CHECK-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v1, v2
; CHECK-NEXT:    v_mul_lo_u32 v9, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v10, v7, v0
; CHECK-NEXT:    v_mul_hi_u32 v11, v1, v0
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v10, v8
; CHECK-NEXT:    v_mul_lo_u32 v10, v2, v9
; CHECK-NEXT:    v_mul_hi_u32 v12, v0, v9
; CHECK-NEXT:    v_mul_hi_u32 v9, v2, v9
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v11
; CHECK-NEXT:    v_mul_lo_u32 v11, v0, v8
; CHECK-NEXT:    v_mul_lo_u32 v13, v2, v8
; CHECK-NEXT:    v_mul_hi_u32 v14, v0, v8
; CHECK-NEXT:    v_mul_hi_u32 v8, v2, v8
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v13, v9
; CHECK-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v14
; CHECK-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CHECK-NEXT:    v_add_i32_e32 v11, vcc, v13, v12
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v9
; CHECK-NEXT:    v_addc_u32_e32 v2, vcc, v2, v8, vcc
; CHECK-NEXT:    v_mul_lo_u32 v8, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v7, v7, v0
; CHECK-NEXT:    v_mul_hi_u32 v9, v1, v0
; CHECK-NEXT:    v_mul_lo_u32 v1, v1, v2
; CHECK-NEXT:    v_mul_lo_u32 v10, v2, v8
; CHECK-NEXT:    v_mul_hi_u32 v11, v0, v8
; CHECK-NEXT:    v_mul_hi_u32 v8, v2, v8
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v7, v1
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; CHECK-NEXT:    v_mul_lo_u32 v7, v0, v1
; CHECK-NEXT:    v_mul_lo_u32 v9, v2, v1
; CHECK-NEXT:    v_mul_hi_u32 v12, v0, v1
; CHECK-NEXT:    v_mul_hi_u32 v1, v2, v1
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v7, v11
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v8, v12
; CHECK-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v10, v7
; CHECK-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v8
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v7
; CHECK-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; CHECK-NEXT:    v_mul_lo_u32 v2, v4, v0
; CHECK-NEXT:    v_mul_hi_u32 v7, v3, v0
; CHECK-NEXT:    v_mul_hi_u32 v0, v4, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v3, v1
; CHECK-NEXT:    v_mul_lo_u32 v9, v4, v1
; CHECK-NEXT:    v_mul_hi_u32 v10, v3, v1
; CHECK-NEXT:    v_mul_hi_u32 v1, v4, v1
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v2, v8
; CHECK-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v9, v0
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v2, v7
; CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v10
; CHECK-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v8, v2
; CHECK-NEXT:    v_add_i32_e32 v7, vcc, v9, v7
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v7, v2
; CHECK-NEXT:    v_mul_lo_u32 v7, v5, v0
; CHECK-NEXT:    v_mul_lo_u32 v8, v6, v0
; CHECK-NEXT:    v_mul_hi_u32 v9, v5, v0
; CHECK-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; CHECK-NEXT:    v_mul_lo_u32 v2, v5, v1
; CHECK-NEXT:    v_add_i32_e32 v10, vcc, 1, v0
; CHECK-NEXT:    v_addc_u32_e32 v11, vcc, 0, v1, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v8, v2
; CHECK-NEXT:    v_add_i32_e32 v8, vcc, 1, v10
; CHECK-NEXT:    v_addc_u32_e32 v12, vcc, 0, v11, vcc
; CHECK-NEXT:    v_add_i32_e32 v2, vcc, v2, v9
; CHECK-NEXT:    v_sub_i32_e32 v3, vcc, v3, v7
; CHECK-NEXT:    v_subb_u32_e64 v7, s[4:5], v4, v2, vcc
; CHECK-NEXT:    v_sub_i32_e64 v2, s[4:5], v4, v2
; CHECK-NEXT:    v_cmp_ge_u32_e64 s[4:5], v3, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v4, 0, -1, s[4:5]
; CHECK-NEXT:    v_cmp_ge_u32_e64 s[4:5], v7, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; CHECK-NEXT:    v_subb_u32_e32 v2, vcc, v2, v6, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; CHECK-NEXT:    v_cndmask_b32_e32 v4, v9, v4, vcc
; CHECK-NEXT:    v_sub_i32_e32 v3, vcc, v3, v5
; CHECK-NEXT:    v_subbrev_u32_e32 v2, vcc, 0, v2, vcc
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v5
; CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v6
; CHECK-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v6
; CHECK-NEXT:    v_cndmask_b32_e32 v2, v5, v3, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v2, v10, v8, vcc
; CHECK-NEXT:    v_cndmask_b32_e32 v3, v11, v12, vcc
; CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CHECK-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; CHECK-NEXT:    ; implicit-def: $vgpr2
; CHECK-NEXT:    ; implicit-def: $vgpr5_vgpr6
; CHECK-NEXT:    ; implicit-def: $vgpr3
; CHECK-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CHECK-NEXT:    s_cbranch_execz .LBB7_2
; CHECK-NEXT:  .LBB7_4:
; CHECK-NEXT:    v_rcp_iflag_f32_e32 v0, v2
; CHECK-NEXT:    v_sub_i32_e32 v2, vcc, 0, v5
; CHECK-NEXT:    v_mov_b32_e32 v1, 0
; CHECK-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CHECK-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CHECK-NEXT:    v_mul_lo_u32 v2, v2, v0
; CHECK-NEXT:    v_mul_hi_u32 v2, v0, v2
; CHECK-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CHECK-NEXT:    v_mul_hi_u32 v0, v3, v0
; CHECK-NEXT:    v_mul_lo_u32 v2, v0, v5
; CHECK-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; CHECK-NEXT:    v_sub_i32_e32 v2, vcc, v3, v2
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v5
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CHECK-NEXT:    v_sub_i32_e64 v3, s[4:5], v2, v5
; CHECK-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CHECK-NEXT:    v_add_i32_e32 v3, vcc, 1, v0
; CHECK-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v5
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; CHECK-NEXT:    s_or_b64 exec, exec, s[6:7]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %shl.y = shl i64 4096, %y
  %r = udiv i64 %x, %shl.y
  ret i64 %r
}

define <2 x i64> @v_udiv_v2i64_pow2_shl_denom(<2 x i64> %x, <2 x i64> %y) {
; GISEL-LABEL: v_udiv_v2i64_pow2_shl_denom:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v9, 0x1000
; GISEL-NEXT:    v_mov_b32_e32 v10, 0
; GISEL-NEXT:    v_lshl_b64 v[7:8], v[9:10], v4
; GISEL-NEXT:    v_lshl_b64 v[4:5], v[9:10], v6
; GISEL-NEXT:    v_cvt_f32_u32_e32 v6, v7
; GISEL-NEXT:    v_cvt_f32_u32_e32 v9, v8
; GISEL-NEXT:    v_mac_f32_e32 v6, 0x4f800000, v9
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v6, v6
; GISEL-NEXT:    v_mul_f32_e32 v6, 0x5f7ffffc, v6
; GISEL-NEXT:    v_mul_f32_e32 v9, 0x2f800000, v6
; GISEL-NEXT:    v_trunc_f32_e32 v9, v9
; GISEL-NEXT:    v_mac_f32_e32 v6, 0xcf800000, v9
; GISEL-NEXT:    v_cvt_u32_f32_e32 v6, v6
; GISEL-NEXT:    v_cvt_u32_f32_e32 v9, v9
; GISEL-NEXT:    v_sub_i32_e32 v10, vcc, 0, v7
; GISEL-NEXT:    v_subb_u32_e32 v11, vcc, 0, v8, vcc
; GISEL-NEXT:    v_mul_lo_u32 v12, v10, v6
; GISEL-NEXT:    v_mul_lo_u32 v13, v11, v6
; GISEL-NEXT:    v_mul_lo_u32 v14, v10, v9
; GISEL-NEXT:    v_mul_hi_u32 v15, v10, v6
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; GISEL-NEXT:    v_mul_lo_u32 v14, v9, v12
; GISEL-NEXT:    v_mul_lo_u32 v15, v6, v13
; GISEL-NEXT:    v_mul_hi_u32 v16, v6, v12
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v15
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; GISEL-NEXT:    v_mul_lo_u32 v15, v9, v13
; GISEL-NEXT:    v_mul_hi_u32 v12, v9, v12
; GISEL-NEXT:    v_mul_hi_u32 v16, v6, v13
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v15, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v16
; GISEL-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; GISEL-NEXT:    v_mul_hi_u32 v13, v9, v13
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v12
; GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v13, vcc
; GISEL-NEXT:    v_mul_lo_u32 v12, v10, v6
; GISEL-NEXT:    v_mul_lo_u32 v11, v11, v6
; GISEL-NEXT:    v_mul_lo_u32 v13, v10, v9
; GISEL-NEXT:    v_mul_hi_u32 v10, v10, v6
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v9, v12
; GISEL-NEXT:    v_mul_lo_u32 v13, v6, v10
; GISEL-NEXT:    v_mul_hi_u32 v14, v6, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v13, v11
; GISEL-NEXT:    v_mul_lo_u32 v13, v9, v10
; GISEL-NEXT:    v_mul_hi_u32 v12, v9, v12
; GISEL-NEXT:    v_mul_hi_u32 v14, v6, v10
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_hi_u32 v10, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v11
; GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v10, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v1, v6
; GISEL-NEXT:    v_mul_lo_u32 v11, v0, v9
; GISEL-NEXT:    v_mul_hi_u32 v12, v0, v6
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v1, v9
; GISEL-NEXT:    v_mul_hi_u32 v6, v1, v6
; GISEL-NEXT:    v_mul_hi_u32 v12, v0, v9
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v11, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_hi_u32 v9, v1, v9
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_mul_lo_u32 v10, v7, v6
; GISEL-NEXT:    v_mul_lo_u32 v11, v8, v6
; GISEL-NEXT:    v_mul_lo_u32 v12, v7, v9
; GISEL-NEXT:    v_mul_hi_u32 v13, v7, v6
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v10
; GISEL-NEXT:    v_subb_u32_e64 v10, s[4:5], v1, v11, vcc
; GISEL-NEXT:    v_sub_i32_e64 v1, s[4:5], v1, v11
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v10, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v0, v7
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v10, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v10, v11, v12, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v0, s[4:5], v0, v7
; GISEL-NEXT:    v_subb_u32_e32 v1, vcc, v1, v8, vcc
; GISEL-NEXT:    v_subbrev_u32_e64 v1, vcc, 0, v1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, 1, v6
; GISEL-NEXT:    v_addc_u32_e32 v12, vcc, 0, v9, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, -1, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v7
; GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v8
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v13, v0, vcc
; GISEL-NEXT:    v_add_i32_e32 v1, vcc, 1, v11
; GISEL-NEXT:    v_addc_u32_e32 v7, vcc, 0, v12, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v11, v1, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v12, v7, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v9, v1, vcc
; GISEL-NEXT:    v_cvt_f32_u32_e32 v6, v4
; GISEL-NEXT:    v_cvt_f32_u32_e32 v7, v5
; GISEL-NEXT:    v_mac_f32_e32 v6, 0x4f800000, v7
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v6, v6
; GISEL-NEXT:    v_mul_f32_e32 v6, 0x5f7ffffc, v6
; GISEL-NEXT:    v_mul_f32_e32 v7, 0x2f800000, v6
; GISEL-NEXT:    v_trunc_f32_e32 v7, v7
; GISEL-NEXT:    v_mac_f32_e32 v6, 0xcf800000, v7
; GISEL-NEXT:    v_cvt_u32_f32_e32 v6, v6
; GISEL-NEXT:    v_cvt_u32_f32_e32 v7, v7
; GISEL-NEXT:    v_sub_i32_e32 v8, vcc, 0, v4
; GISEL-NEXT:    v_subb_u32_e32 v9, vcc, 0, v5, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v8, v6
; GISEL-NEXT:    v_mul_lo_u32 v11, v9, v6
; GISEL-NEXT:    v_mul_lo_u32 v12, v8, v7
; GISEL-NEXT:    v_mul_hi_u32 v13, v8, v6
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; GISEL-NEXT:    v_mul_lo_u32 v12, v7, v10
; GISEL-NEXT:    v_mul_lo_u32 v13, v6, v11
; GISEL-NEXT:    v_mul_hi_u32 v14, v6, v10
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_lo_u32 v13, v7, v11
; GISEL-NEXT:    v_mul_hi_u32 v10, v7, v10
; GISEL-NEXT:    v_mul_hi_u32 v14, v6, v11
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v13, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; GISEL-NEXT:    v_mul_hi_u32 v11, v7, v11
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v10
; GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v11, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, v8, v6
; GISEL-NEXT:    v_mul_lo_u32 v9, v9, v6
; GISEL-NEXT:    v_mul_lo_u32 v11, v8, v7
; GISEL-NEXT:    v_mul_hi_u32 v8, v8, v6
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v7, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v6, v8
; GISEL-NEXT:    v_mul_hi_u32 v12, v6, v10
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v11, v9
; GISEL-NEXT:    v_mul_lo_u32 v11, v7, v8
; GISEL-NEXT:    v_mul_hi_u32 v10, v7, v10
; GISEL-NEXT:    v_mul_hi_u32 v12, v6, v8
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_hi_u32 v8, v7, v8
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v9
; GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v8, vcc
; GISEL-NEXT:    v_mul_lo_u32 v8, v3, v6
; GISEL-NEXT:    v_mul_lo_u32 v9, v2, v7
; GISEL-NEXT:    v_mul_hi_u32 v10, v2, v6
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v3, v7
; GISEL-NEXT:    v_mul_hi_u32 v6, v3, v6
; GISEL-NEXT:    v_mul_hi_u32 v10, v2, v7
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v9, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_hi_u32 v7, v3, v7
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; GISEL-NEXT:    v_mul_lo_u32 v8, v4, v6
; GISEL-NEXT:    v_mul_lo_u32 v9, v5, v6
; GISEL-NEXT:    v_mul_lo_u32 v10, v4, v7
; GISEL-NEXT:    v_mul_hi_u32 v11, v4, v6
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; GISEL-NEXT:    v_sub_i32_e32 v2, vcc, v2, v8
; GISEL-NEXT:    v_subb_u32_e64 v8, s[4:5], v3, v9, vcc
; GISEL-NEXT:    v_sub_i32_e64 v3, s[4:5], v3, v9
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v8, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v2, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, -1, s[4:5]
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v8, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v8, v9, v10, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v2, s[4:5], v2, v4
; GISEL-NEXT:    v_subb_u32_e32 v3, vcc, v3, v5, vcc
; GISEL-NEXT:    v_subbrev_u32_e64 v3, vcc, 0, v3, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, 1, v6
; GISEL-NEXT:    v_addc_u32_e32 v10, vcc, 0, v7, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v5
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, -1, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v9
; GISEL-NEXT:    v_addc_u32_e32 v4, vcc, 0, v10, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v9, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v10, v4, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; CGP-LABEL: v_udiv_v2i64_pow2_shl_denom:
; CGP:       ; %bb.0:
; CGP-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CGP-NEXT:    v_mov_b32_e32 v8, v0
; CGP-NEXT:    v_mov_b32_e32 v9, v1
; CGP-NEXT:    v_mov_b32_e32 v5, v2
; CGP-NEXT:    v_mov_b32_e32 v7, v3
; CGP-NEXT:    v_mov_b32_e32 v10, 0x1000
; CGP-NEXT:    v_mov_b32_e32 v11, 0
; CGP-NEXT:    v_mov_b32_e32 v0, 0
; CGP-NEXT:    v_lshl_b64 v[2:3], v[10:11], v4
; CGP-NEXT:    v_or_b32_e32 v1, v9, v3
; CGP-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; CGP-NEXT:    v_cvt_f32_u32_e32 v4, v2
; CGP-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CGP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CGP-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CGP-NEXT:    s_cbranch_execz .LBB8_2
; CGP-NEXT:  ; %bb.1:
; CGP-NEXT:    v_cvt_f32_u32_e32 v0, v3
; CGP-NEXT:    v_sub_i32_e32 v1, vcc, 0, v2
; CGP-NEXT:    v_subb_u32_e32 v12, vcc, 0, v3, vcc
; CGP-NEXT:    v_mac_f32_e32 v4, 0x4f800000, v0
; CGP-NEXT:    v_rcp_iflag_f32_e32 v0, v4
; CGP-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; CGP-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v0
; CGP-NEXT:    v_trunc_f32_e32 v4, v4
; CGP-NEXT:    v_mac_f32_e32 v0, 0xcf800000, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v4, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CGP-NEXT:    v_mul_lo_u32 v13, v1, v4
; CGP-NEXT:    v_mul_lo_u32 v14, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v15, v12, v0
; CGP-NEXT:    v_mul_hi_u32 v16, v1, v0
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v15, v13
; CGP-NEXT:    v_mul_lo_u32 v15, v4, v14
; CGP-NEXT:    v_mul_hi_u32 v17, v0, v14
; CGP-NEXT:    v_mul_hi_u32 v14, v4, v14
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v16
; CGP-NEXT:    v_mul_lo_u32 v16, v0, v13
; CGP-NEXT:    v_mul_lo_u32 v18, v4, v13
; CGP-NEXT:    v_mul_hi_u32 v19, v0, v13
; CGP-NEXT:    v_mul_hi_u32 v13, v4, v13
; CGP-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; CGP-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v18, v14
; CGP-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v15, vcc, v15, v17
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v14, v19
; CGP-NEXT:    v_cndmask_b32_e64 v17, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; CGP-NEXT:    v_add_i32_e32 v16, vcc, v18, v17
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v14, v15
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v14
; CGP-NEXT:    v_addc_u32_e32 v4, vcc, v4, v13, vcc
; CGP-NEXT:    v_mul_lo_u32 v13, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v12, v12, v0
; CGP-NEXT:    v_mul_hi_u32 v14, v1, v0
; CGP-NEXT:    v_mul_lo_u32 v1, v1, v4
; CGP-NEXT:    v_mul_lo_u32 v15, v4, v13
; CGP-NEXT:    v_mul_hi_u32 v16, v0, v13
; CGP-NEXT:    v_mul_hi_u32 v13, v4, v13
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v12, v1
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v14
; CGP-NEXT:    v_mul_lo_u32 v12, v0, v1
; CGP-NEXT:    v_mul_lo_u32 v14, v4, v1
; CGP-NEXT:    v_mul_hi_u32 v17, v0, v1
; CGP-NEXT:    v_mul_hi_u32 v1, v4, v1
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v15, v12
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v16
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v13, v17
; CGP-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v15, v12
; CGP-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v13
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v12
; CGP-NEXT:    v_addc_u32_e32 v1, vcc, v4, v1, vcc
; CGP-NEXT:    v_mul_lo_u32 v4, v9, v0
; CGP-NEXT:    v_mul_hi_u32 v12, v8, v0
; CGP-NEXT:    v_mul_hi_u32 v0, v9, v0
; CGP-NEXT:    v_mul_lo_u32 v13, v8, v1
; CGP-NEXT:    v_mul_lo_u32 v14, v9, v1
; CGP-NEXT:    v_mul_hi_u32 v15, v8, v1
; CGP-NEXT:    v_mul_hi_u32 v1, v9, v1
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v13
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v14, v0
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v15
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v13, v4
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v14, v12
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v12, v4
; CGP-NEXT:    v_mul_lo_u32 v12, v2, v0
; CGP-NEXT:    v_mul_lo_u32 v13, v3, v0
; CGP-NEXT:    v_mul_hi_u32 v14, v2, v0
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; CGP-NEXT:    v_mul_lo_u32 v4, v2, v1
; CGP-NEXT:    v_add_i32_e32 v15, vcc, 1, v0
; CGP-NEXT:    v_addc_u32_e32 v16, vcc, 0, v1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v13, v4
; CGP-NEXT:    v_add_i32_e32 v13, vcc, 1, v15
; CGP-NEXT:    v_addc_u32_e32 v17, vcc, 0, v16, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v14
; CGP-NEXT:    v_sub_i32_e32 v8, vcc, v8, v12
; CGP-NEXT:    v_subb_u32_e64 v12, s[4:5], v9, v4, vcc
; CGP-NEXT:    v_sub_i32_e64 v4, s[4:5], v9, v4
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v8, v2
; CGP-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[4:5]
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v12, v3
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, -1, s[4:5]
; CGP-NEXT:    v_subb_u32_e32 v4, vcc, v4, v3, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v12, v3
; CGP-NEXT:    v_cndmask_b32_e32 v9, v14, v9, vcc
; CGP-NEXT:    v_sub_i32_e32 v8, vcc, v8, v2
; CGP-NEXT:    v_subbrev_u32_e32 v4, vcc, 0, v4, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v2
; CGP-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v3
; CGP-NEXT:    v_cndmask_b32_e64 v8, 0, -1, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; CGP-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; CGP-NEXT:    v_cndmask_b32_e32 v2, v15, v13, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v3, v16, v17, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v9
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; CGP-NEXT:    ; implicit-def: $vgpr4
; CGP-NEXT:    ; implicit-def: $vgpr2_vgpr3
; CGP-NEXT:    ; implicit-def: $vgpr8
; CGP-NEXT:  .LBB8_2: ; %Flow1
; CGP-NEXT:    s_or_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    v_lshl_b64 v[9:10], v[10:11], v6
; CGP-NEXT:    s_xor_b64 exec, exec, s[6:7]
; CGP-NEXT:    s_cbranch_execz .LBB8_4
; CGP-NEXT:  ; %bb.3:
; CGP-NEXT:    v_rcp_iflag_f32_e32 v0, v4
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, 0, v2
; CGP-NEXT:    v_mov_b32_e32 v1, 0
; CGP-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CGP-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CGP-NEXT:    v_mul_lo_u32 v3, v3, v0
; CGP-NEXT:    v_mul_hi_u32 v3, v0, v3
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; CGP-NEXT:    v_mul_hi_u32 v0, v8, v0
; CGP-NEXT:    v_mul_lo_u32 v3, v0, v2
; CGP-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, v8, v3
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v2
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CGP-NEXT:    v_sub_i32_e64 v4, s[4:5], v3, v2
; CGP-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, 1, v0
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v2
; CGP-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CGP-NEXT:  .LBB8_4:
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    v_or_b32_e32 v3, v7, v10
; CGP-NEXT:    v_mov_b32_e32 v2, 0
; CGP-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; CGP-NEXT:    v_cvt_f32_u32_e32 v4, v9
; CGP-NEXT:    ; implicit-def: $vgpr2_vgpr3
; CGP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; CGP-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; CGP-NEXT:    s_cbranch_execnz .LBB8_7
; CGP-NEXT:  ; %bb.5: ; %Flow
; CGP-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    s_cbranch_execnz .LBB8_8
; CGP-NEXT:  .LBB8_6:
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    s_setpc_b64 s[30:31]
; CGP-NEXT:  .LBB8_7:
; CGP-NEXT:    v_cvt_f32_u32_e32 v2, v10
; CGP-NEXT:    v_sub_i32_e32 v3, vcc, 0, v9
; CGP-NEXT:    v_subb_u32_e32 v6, vcc, 0, v10, vcc
; CGP-NEXT:    v_mac_f32_e32 v4, 0x4f800000, v2
; CGP-NEXT:    v_rcp_iflag_f32_e32 v2, v4
; CGP-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; CGP-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v2
; CGP-NEXT:    v_trunc_f32_e32 v4, v4
; CGP-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v4, v4
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_mul_lo_u32 v8, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v11, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v12, v6, v2
; CGP-NEXT:    v_mul_hi_u32 v13, v3, v2
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v12, v8
; CGP-NEXT:    v_mul_lo_u32 v12, v4, v11
; CGP-NEXT:    v_mul_hi_u32 v14, v2, v11
; CGP-NEXT:    v_mul_hi_u32 v11, v4, v11
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v8, v13
; CGP-NEXT:    v_mul_lo_u32 v13, v2, v8
; CGP-NEXT:    v_mul_lo_u32 v15, v4, v8
; CGP-NEXT:    v_mul_hi_u32 v16, v2, v8
; CGP-NEXT:    v_mul_hi_u32 v8, v4, v8
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v13
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v15, v11
; CGP-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v12, v14
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v16
; CGP-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_add_i32_e32 v13, vcc, v15, v14
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v8, v12
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v11
; CGP-NEXT:    v_addc_u32_e32 v4, vcc, v4, v8, vcc
; CGP-NEXT:    v_mul_lo_u32 v8, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v6, v6, v2
; CGP-NEXT:    v_mul_hi_u32 v11, v3, v2
; CGP-NEXT:    v_mul_lo_u32 v3, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v12, v4, v8
; CGP-NEXT:    v_mul_hi_u32 v13, v2, v8
; CGP-NEXT:    v_mul_hi_u32 v8, v4, v8
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; CGP-NEXT:    v_mul_lo_u32 v6, v2, v3
; CGP-NEXT:    v_mul_lo_u32 v11, v4, v3
; CGP-NEXT:    v_mul_hi_u32 v14, v2, v3
; CGP-NEXT:    v_mul_hi_u32 v3, v4, v3
; CGP-NEXT:    v_add_i32_e32 v6, vcc, v12, v6
; CGP-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v11, v8
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v6, vcc, v6, v13
; CGP-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v8, v14
; CGP-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v6, vcc, v12, v6
; CGP-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; CGP-NEXT:    v_add_i32_e32 v6, vcc, v8, v6
; CGP-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v8, vcc, v11, v8
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v8
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; CGP-NEXT:    v_addc_u32_e32 v3, vcc, v4, v3, vcc
; CGP-NEXT:    v_mul_lo_u32 v4, v7, v2
; CGP-NEXT:    v_mul_hi_u32 v6, v5, v2
; CGP-NEXT:    v_mul_hi_u32 v2, v7, v2
; CGP-NEXT:    v_mul_lo_u32 v8, v5, v3
; CGP-NEXT:    v_mul_lo_u32 v11, v7, v3
; CGP-NEXT:    v_mul_hi_u32 v12, v5, v3
; CGP-NEXT:    v_mul_hi_u32 v3, v7, v3
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; CGP-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v11, v2
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v12
; CGP-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v8, v4
; CGP-NEXT:    v_add_i32_e32 v6, vcc, v11, v6
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CGP-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v6, v4
; CGP-NEXT:    v_mul_lo_u32 v6, v9, v2
; CGP-NEXT:    v_mul_lo_u32 v8, v10, v2
; CGP-NEXT:    v_mul_hi_u32 v11, v9, v2
; CGP-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; CGP-NEXT:    v_mul_lo_u32 v4, v9, v3
; CGP-NEXT:    v_add_i32_e32 v12, vcc, 1, v2
; CGP-NEXT:    v_addc_u32_e32 v13, vcc, 0, v3, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v8, v4
; CGP-NEXT:    v_add_i32_e32 v8, vcc, 1, v12
; CGP-NEXT:    v_addc_u32_e32 v14, vcc, 0, v13, vcc
; CGP-NEXT:    v_add_i32_e32 v4, vcc, v4, v11
; CGP-NEXT:    v_sub_i32_e32 v5, vcc, v5, v6
; CGP-NEXT:    v_subb_u32_e64 v6, s[4:5], v7, v4, vcc
; CGP-NEXT:    v_sub_i32_e64 v4, s[4:5], v7, v4
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v5, v9
; CGP-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[4:5]
; CGP-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v10
; CGP-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[4:5]
; CGP-NEXT:    v_subb_u32_e32 v4, vcc, v4, v10, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v10
; CGP-NEXT:    v_cndmask_b32_e32 v6, v11, v7, vcc
; CGP-NEXT:    v_sub_i32_e32 v5, vcc, v5, v9
; CGP-NEXT:    v_subbrev_u32_e32 v4, vcc, 0, v4, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v9
; CGP-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v10
; CGP-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; CGP-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v10
; CGP-NEXT:    v_cndmask_b32_e32 v4, v7, v5, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; CGP-NEXT:    v_cndmask_b32_e32 v4, v12, v8, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v5, v13, v14, vcc
; CGP-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CGP-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; CGP-NEXT:    ; implicit-def: $vgpr4
; CGP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; CGP-NEXT:    ; implicit-def: $vgpr5
; CGP-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; CGP-NEXT:    s_cbranch_execz .LBB8_6
; CGP-NEXT:  .LBB8_8:
; CGP-NEXT:    v_rcp_iflag_f32_e32 v2, v4
; CGP-NEXT:    v_sub_i32_e32 v4, vcc, 0, v9
; CGP-NEXT:    v_mov_b32_e32 v3, 0
; CGP-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_mul_lo_u32 v4, v4, v2
; CGP-NEXT:    v_mul_hi_u32 v4, v2, v4
; CGP-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CGP-NEXT:    v_mul_hi_u32 v2, v5, v2
; CGP-NEXT:    v_mul_lo_u32 v4, v2, v9
; CGP-NEXT:    v_add_i32_e32 v6, vcc, 1, v2
; CGP-NEXT:    v_sub_i32_e32 v4, vcc, v5, v4
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v9
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; CGP-NEXT:    v_sub_i32_e64 v5, s[4:5], v4, v9
; CGP-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; CGP-NEXT:    v_add_i32_e32 v5, vcc, 1, v2
; CGP-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v9
; CGP-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; CGP-NEXT:    s_or_b64 exec, exec, s[6:7]
; CGP-NEXT:    s_setpc_b64 s[30:31]
  %shl.y = shl <2 x i64> <i64 4096, i64 4096>, %y
  %r = udiv <2 x i64> %x, %shl.y
  ret <2 x i64> %r
}

define i64 @v_udiv_i64_24bit(i64 %num, i64 %den) {
; GISEL-LABEL: v_udiv_i64_24bit:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v2
; GISEL-NEXT:    v_cvt_f32_u32_e32 v2, v1
; GISEL-NEXT:    v_sub_i32_e32 v3, vcc, 0, v1
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; GISEL-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; GISEL-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GISEL-NEXT:    v_mul_lo_u32 v3, v3, v2
; GISEL-NEXT:    v_mul_hi_u32 v3, v2, v3
; GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GISEL-NEXT:    v_mul_hi_u32 v2, v0, v2
; GISEL-NEXT:    v_mul_lo_u32 v3, v2, v1
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v3
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; GISEL-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GISEL-NEXT:    v_sub_i32_e64 v3, s[4:5], v0, v1
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GISEL-NEXT:    v_add_i32_e32 v3, vcc, 1, v2
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; CGP-LABEL: v_udiv_i64_24bit:
; CGP:       ; %bb.0:
; CGP-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CGP-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; CGP-NEXT:    v_and_b32_e32 v1, 0xffffff, v2
; CGP-NEXT:    v_cvt_f32_u32_e32 v0, v0
; CGP-NEXT:    v_cvt_f32_u32_e32 v1, v1
; CGP-NEXT:    v_rcp_f32_e32 v2, v1
; CGP-NEXT:    v_mul_f32_e32 v2, v0, v2
; CGP-NEXT:    v_trunc_f32_e32 v2, v2
; CGP-NEXT:    v_mad_f32 v0, -v2, v1, v0
; CGP-NEXT:    v_cvt_u32_f32_e32 v2, v2
; CGP-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v0|, v1
; CGP-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v2, v0
; CGP-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; CGP-NEXT:    v_mov_b32_e32 v1, 0
; CGP-NEXT:    s_setpc_b64 s[30:31]
  %num.mask = and i64 %num, 16777215
  %den.mask = and i64 %den, 16777215
  %result = udiv i64 %num.mask, %den.mask
  ret i64 %result
}

define <2 x i64> @v_udiv_v2i64_24bit(<2 x i64> %num, <2 x i64> %den) {
; GISEL-LABEL: v_udiv_v2i64_24bit:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_and_b32_e32 v3, 0xffffff, v4
; GISEL-NEXT:    v_and_b32_e32 v1, 0xffffff, v6
; GISEL-NEXT:    v_cvt_f32_ubyte0_e32 v6, 0
; GISEL-NEXT:    v_cvt_f32_u32_e32 v7, v3
; GISEL-NEXT:    v_sub_i32_e32 v4, vcc, 0, v3
; GISEL-NEXT:    v_subb_u32_e64 v5, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_cvt_f32_u32_e32 v8, v1
; GISEL-NEXT:    v_sub_i32_e32 v9, vcc, 0, v1
; GISEL-NEXT:    v_subb_u32_e64 v10, s[4:5], 0, 0, vcc
; GISEL-NEXT:    v_mac_f32_e32 v7, 0x4f800000, v6
; GISEL-NEXT:    v_mac_f32_e32 v8, 0x4f800000, v6
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v6, v7
; GISEL-NEXT:    v_rcp_iflag_f32_e32 v7, v8
; GISEL-NEXT:    v_mul_f32_e32 v6, 0x5f7ffffc, v6
; GISEL-NEXT:    v_mul_f32_e32 v7, 0x5f7ffffc, v7
; GISEL-NEXT:    v_mul_f32_e32 v8, 0x2f800000, v6
; GISEL-NEXT:    v_mul_f32_e32 v11, 0x2f800000, v7
; GISEL-NEXT:    v_trunc_f32_e32 v8, v8
; GISEL-NEXT:    v_trunc_f32_e32 v11, v11
; GISEL-NEXT:    v_mac_f32_e32 v6, 0xcf800000, v8
; GISEL-NEXT:    v_cvt_u32_f32_e32 v8, v8
; GISEL-NEXT:    v_mac_f32_e32 v7, 0xcf800000, v11
; GISEL-NEXT:    v_cvt_u32_f32_e32 v11, v11
; GISEL-NEXT:    v_cvt_u32_f32_e32 v12, v6
; GISEL-NEXT:    v_mul_lo_u32 v6, v4, v8
; GISEL-NEXT:    v_cvt_u32_f32_e32 v7, v7
; GISEL-NEXT:    v_mul_lo_u32 v13, v9, v11
; GISEL-NEXT:    v_mul_lo_u32 v14, v4, v12
; GISEL-NEXT:    v_mul_lo_u32 v15, v5, v12
; GISEL-NEXT:    v_mul_hi_u32 v16, v4, v12
; GISEL-NEXT:    v_mul_lo_u32 v17, v9, v7
; GISEL-NEXT:    v_mul_lo_u32 v18, v10, v7
; GISEL-NEXT:    v_mul_hi_u32 v19, v9, v7
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v15, v6
; GISEL-NEXT:    v_mul_lo_u32 v15, v8, v14
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v18, v13
; GISEL-NEXT:    v_mul_hi_u32 v18, v12, v14
; GISEL-NEXT:    v_mul_hi_u32 v14, v8, v14
; GISEL-NEXT:    v_add_i32_e32 v16, vcc, v6, v16
; GISEL-NEXT:    v_mul_lo_u32 v6, v12, v16
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v15, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v18
; GISEL-NEXT:    v_mul_lo_u32 v6, v11, v17
; GISEL-NEXT:    v_mul_hi_u32 v18, v7, v17
; GISEL-NEXT:    v_mul_hi_u32 v17, v11, v17
; GISEL-NEXT:    v_add_i32_e64 v13, s[4:5], v13, v19
; GISEL-NEXT:    v_mul_lo_u32 v19, v7, v13
; GISEL-NEXT:    v_add_i32_e64 v6, s[4:5], v6, v19
; GISEL-NEXT:    v_cndmask_b32_e64 v19, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e64 v6, s[4:5], v6, v18
; GISEL-NEXT:    v_mul_lo_u32 v6, v8, v16
; GISEL-NEXT:    v_mul_lo_u32 v18, v11, v13
; GISEL-NEXT:    v_add_i32_e64 v17, s[6:7], v18, v17
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v15, v18
; GISEL-NEXT:    v_mul_hi_u32 v18, v12, v16
; GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v18, vcc, v6, v18
; GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e32 v19, vcc, v19, v6
; GISEL-NEXT:    v_mul_hi_u32 v6, v7, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v20, 0, 1, s[6:7]
; GISEL-NEXT:    v_add_i32_e32 v17, vcc, v17, v6
; GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v20, vcc, v20, v6
; GISEL-NEXT:    v_and_b32_e32 v6, 0xffffff, v0
; GISEL-NEXT:    v_and_b32_e32 v0, 0xffffff, v2
; GISEL-NEXT:    v_mul_hi_u32 v2, v8, v16
; GISEL-NEXT:    v_mul_hi_u32 v13, v11, v13
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v18, v15
; GISEL-NEXT:    v_cndmask_b32_e64 v16, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v17, vcc, v17, v19
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; GISEL-NEXT:    v_add_i32_e32 v16, vcc, v20, v18
; GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v14
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v16
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v15
; GISEL-NEXT:    v_addc_u32_e32 v2, vcc, v8, v2, vcc
; GISEL-NEXT:    v_mul_lo_u32 v8, v4, v12
; GISEL-NEXT:    v_mul_lo_u32 v5, v5, v12
; GISEL-NEXT:    v_mul_hi_u32 v14, v4, v12
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v17
; GISEL-NEXT:    v_addc_u32_e32 v11, vcc, v11, v13, vcc
; GISEL-NEXT:    v_mul_lo_u32 v13, v9, v7
; GISEL-NEXT:    v_mul_lo_u32 v10, v10, v7
; GISEL-NEXT:    v_mul_hi_u32 v15, v9, v7
; GISEL-NEXT:    v_mul_lo_u32 v4, v4, v2
; GISEL-NEXT:    v_mul_lo_u32 v16, v2, v8
; GISEL-NEXT:    v_mul_hi_u32 v17, v12, v8
; GISEL-NEXT:    v_mul_hi_u32 v8, v2, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v9, v11
; GISEL-NEXT:    v_mul_lo_u32 v18, v11, v13
; GISEL-NEXT:    v_mul_hi_u32 v19, v7, v13
; GISEL-NEXT:    v_mul_hi_u32 v13, v11, v13
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GISEL-NEXT:    v_add_i32_e32 v5, vcc, v10, v9
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v14
; GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v15
; GISEL-NEXT:    v_mul_lo_u32 v9, v12, v4
; GISEL-NEXT:    v_mul_lo_u32 v10, v2, v4
; GISEL-NEXT:    v_mul_hi_u32 v14, v12, v4
; GISEL-NEXT:    v_mul_hi_u32 v4, v2, v4
; GISEL-NEXT:    v_mul_lo_u32 v15, v7, v5
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v18, v15
; GISEL-NEXT:    v_cndmask_b32_e64 v18, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v15, v19
; GISEL-NEXT:    v_mul_lo_u32 v15, v11, v5
; GISEL-NEXT:    v_mul_hi_u32 v19, v7, v5
; GISEL-NEXT:    v_mul_hi_u32 v5, v11, v5
; GISEL-NEXT:    v_add_i32_e64 v9, s[4:5], v16, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v16, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e64 v8, s[4:5], v10, v8
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e64 v13, s[4:5], v15, v13
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e64 v9, s[4:5], v9, v17
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, s[4:5]
; GISEL-NEXT:    v_add_i32_e64 v8, s[4:5], v8, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e64 v17, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v19
; GISEL-NEXT:    v_cndmask_b32_e64 v19, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v16, v9
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v14
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, v18, v17
; GISEL-NEXT:    v_add_i32_e32 v15, vcc, v15, v19
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v14, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v15, v14
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v9
; GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v10
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v12, v8
; GISEL-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GISEL-NEXT:    v_mul_lo_u32 v4, 0, v8
; GISEL-NEXT:    v_mul_hi_u32 v9, v6, v8
; GISEL-NEXT:    v_mul_hi_u32 v8, 0, v8
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v13
; GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v11, v5, vcc
; GISEL-NEXT:    v_mul_lo_u32 v10, 0, v7
; GISEL-NEXT:    v_mul_hi_u32 v11, v0, v7
; GISEL-NEXT:    v_mul_hi_u32 v7, 0, v7
; GISEL-NEXT:    v_mul_lo_u32 v12, v6, v2
; GISEL-NEXT:    v_mul_lo_u32 v13, 0, v2
; GISEL-NEXT:    v_mul_hi_u32 v14, v6, v2
; GISEL-NEXT:    v_mul_hi_u32 v2, 0, v2
; GISEL-NEXT:    v_mul_lo_u32 v15, v0, v5
; GISEL-NEXT:    v_mul_lo_u32 v16, 0, v5
; GISEL-NEXT:    v_mul_hi_u32 v17, v0, v5
; GISEL-NEXT:    v_mul_hi_u32 v5, 0, v5
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v13, v8
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v15
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v16, v7
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v9
; GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v14
; GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v17
; GISEL-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v4, vcc, v8, v4
; GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v10
; GISEL-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GISEL-NEXT:    v_mul_lo_u32 v9, v3, v4
; GISEL-NEXT:    v_mul_lo_u32 v12, 0, v4
; GISEL-NEXT:    v_mul_hi_u32 v13, v3, v4
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GISEL-NEXT:    v_mul_lo_u32 v11, v1, v7
; GISEL-NEXT:    v_mul_lo_u32 v14, 0, v7
; GISEL-NEXT:    v_mul_hi_u32 v15, v1, v7
; GISEL-NEXT:    v_add_i32_e32 v8, vcc, v2, v8
; GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v10
; GISEL-NEXT:    v_mul_lo_u32 v2, v3, v8
; GISEL-NEXT:    v_add_i32_e32 v10, vcc, 1, v4
; GISEL-NEXT:    v_addc_u32_e32 v16, vcc, 0, v8, vcc
; GISEL-NEXT:    v_mul_lo_u32 v17, v1, v5
; GISEL-NEXT:    v_add_i32_e32 v18, vcc, 1, v7
; GISEL-NEXT:    v_addc_u32_e32 v19, vcc, 0, v5, vcc
; GISEL-NEXT:    v_add_i32_e32 v2, vcc, v12, v2
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v14, v17
; GISEL-NEXT:    v_add_i32_e32 v14, vcc, 1, v10
; GISEL-NEXT:    v_addc_u32_e32 v17, vcc, 0, v16, vcc
; GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v13
; GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v15
; GISEL-NEXT:    v_sub_i32_e32 v6, vcc, v6, v9
; GISEL-NEXT:    v_subb_u32_e64 v9, s[4:5], 0, v2, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v3
; GISEL-NEXT:    v_cndmask_b32_e64 v13, 0, -1, s[4:5]
; GISEL-NEXT:    v_sub_i32_e64 v0, s[4:5], v0, v11
; GISEL-NEXT:    v_subb_u32_e64 v11, s[6:7], 0, v12, s[4:5]
; GISEL-NEXT:    v_cmp_ge_u32_e64 s[6:7], v0, v1
; GISEL-NEXT:    v_cndmask_b32_e64 v15, 0, -1, s[6:7]
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v9
; GISEL-NEXT:    v_cmp_eq_u32_e64 s[8:9], 0, v11
; GISEL-NEXT:    v_add_i32_e64 v9, s[10:11], 1, v18
; GISEL-NEXT:    v_addc_u32_e64 v11, s[10:11], 0, v19, s[10:11]
; GISEL-NEXT:    v_sub_i32_e64 v2, s[10:11], 0, v2
; GISEL-NEXT:    v_sub_i32_e64 v12, s[10:11], 0, v12
; GISEL-NEXT:    v_cndmask_b32_e64 v13, -1, v13, s[6:7]
; GISEL-NEXT:    v_subbrev_u32_e32 v2, vcc, 0, v2, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v15, -1, v15, s[8:9]
; GISEL-NEXT:    v_subbrev_u32_e64 v12, vcc, 0, v12, s[4:5]
; GISEL-NEXT:    v_sub_i32_e32 v6, vcc, v6, v3
; GISEL-NEXT:    v_subbrev_u32_e32 v2, vcc, 0, v2, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v6, v3
; GISEL-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GISEL-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GISEL-NEXT:    v_subbrev_u32_e32 v6, vcc, 0, v12, vcc
; GISEL-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GISEL-NEXT:    v_cndmask_b32_e32 v1, -1, v3, vcc
; GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GISEL-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v10, v14, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GISEL-NEXT:    v_cndmask_b32_e64 v2, v18, v9, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e32 v3, v16, v17, vcc
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v4, v19, v11, s[4:5]
; GISEL-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v15
; GISEL-NEXT:    v_cndmask_b32_e64 v2, v7, v2, s[4:5]
; GISEL-NEXT:    v_cndmask_b32_e32 v1, v8, v3, vcc
; GISEL-NEXT:    v_cndmask_b32_e64 v3, v5, v4, s[4:5]
; GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; CGP-LABEL: v_udiv_v2i64_24bit:
; CGP:       ; %bb.0:
; CGP-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CGP-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; CGP-NEXT:    v_and_b32_e32 v1, 0xffffff, v4
; CGP-NEXT:    v_and_b32_e32 v2, 0xffffff, v2
; CGP-NEXT:    v_and_b32_e32 v3, 0xffffff, v6
; CGP-NEXT:    v_cvt_f32_u32_e32 v0, v0
; CGP-NEXT:    v_cvt_f32_u32_e32 v1, v1
; CGP-NEXT:    v_cvt_f32_u32_e32 v2, v2
; CGP-NEXT:    v_cvt_f32_u32_e32 v3, v3
; CGP-NEXT:    v_rcp_f32_e32 v4, v1
; CGP-NEXT:    v_rcp_f32_e32 v5, v3
; CGP-NEXT:    v_mul_f32_e32 v4, v0, v4
; CGP-NEXT:    v_mul_f32_e32 v5, v2, v5
; CGP-NEXT:    v_trunc_f32_e32 v4, v4
; CGP-NEXT:    v_trunc_f32_e32 v5, v5
; CGP-NEXT:    v_mad_f32 v0, -v4, v1, v0
; CGP-NEXT:    v_cvt_u32_f32_e32 v4, v4
; CGP-NEXT:    v_mad_f32 v2, -v5, v3, v2
; CGP-NEXT:    v_cvt_u32_f32_e32 v5, v5
; CGP-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v0|, v1
; CGP-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; CGP-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v2|, v3
; CGP-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; CGP-NEXT:    v_add_i32_e32 v0, vcc, v4, v0
; CGP-NEXT:    v_add_i32_e32 v1, vcc, v5, v1
; CGP-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; CGP-NEXT:    v_and_b32_e32 v2, 0xffffff, v1
; CGP-NEXT:    v_mov_b32_e32 v1, 0
; CGP-NEXT:    v_mov_b32_e32 v3, 0
; CGP-NEXT:    s_setpc_b64 s[30:31]
  %num.mask = and <2 x i64> %num, <i64 16777215, i64 16777215>
  %den.mask = and <2 x i64> %den, <i64 16777215, i64 16777215>
  %result = udiv <2 x i64> %num.mask, %den.mask
  ret <2 x i64> %result
}
