; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -o - %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=CHECK,NOBMI
; RUN: llc -o - %s -mtriple=x86_64-- -mattr=+bmi | FileCheck %s --check-prefixes=CHECK,BMI
;
; test that masked-merge code is generated as "xor;and;xor" sequence or
; "andn ; and; or" if and-not is available.

define i32 @masked_merge0_demorgan(i32 %a0, i32 %a1, i32 %a2) {
; NOBMI-LABEL: masked_merge0_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %esi, %eax
; NOBMI-NEXT:    xorl %edx, %eax
; NOBMI-NEXT:    andl %edi, %eax
; NOBMI-NEXT:    xorl %edx, %eax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: masked_merge0_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    orl %edi, %edx
; BMI-NEXT:    andnl %edi, %esi, %eax
; BMI-NEXT:    andnl %edx, %eax, %eax
; BMI-NEXT:    retq
  %not = xor i32 %a0, -1
  %or0 = or i32 %not, %a1
  %or1 = or i32 %a0, %a2
  %and = and i32 %or0, %or1
  ret i32 %and
}

define i16 @masked_merge1_demorgan(i16 %a0, i16 %a1, i16 %a2) {
; NOBMI-LABEL: masked_merge1_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %esi, %eax
; NOBMI-NEXT:    xorl %edx, %eax
; NOBMI-NEXT:    andl %edi, %eax
; NOBMI-NEXT:    xorl %edx, %eax
; NOBMI-NEXT:    # kill: def $ax killed $ax killed $eax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: masked_merge1_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    andnl %edx, %edi, %eax
; BMI-NEXT:    andl %edi, %esi
; BMI-NEXT:    orl %esi, %eax
; BMI-NEXT:    # kill: def $ax killed $ax killed $eax
; BMI-NEXT:    retq
  %not = xor i16 %a0, -1
  %or0 = or i16 %not, %a1
  %or1 = or i16 %a0, %a2
  %and = and i16 %or0, %or1
  ret i16 %and
}

define i8 @masked_merge2_demorgan(i8 %a0, i8 %a1, i8 %a2) {
; CHECK-LABEL: masked_merge2_demorgan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq
  %not = xor i8 %a0, -1
  %or0 = or i8 %not, %a1
  %or1 = or i8 %a0, %a1
  %and = and i8 %or0, %or1
  ret i8 %and
}

define i64 @masked_merge3_demorgan(i64 %a0, i64 %a1, i64 %a2) {
; NOBMI-LABEL: masked_merge3_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movq %rsi, %rax
; NOBMI-NEXT:    notq %rdx
; NOBMI-NEXT:    xorq %rdx, %rax
; NOBMI-NEXT:    notq %rax
; NOBMI-NEXT:    andq %rdi, %rax
; NOBMI-NEXT:    xorq %rdx, %rax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: masked_merge3_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    andnq %rdx, %rdi, %rax
; BMI-NEXT:    andq %rdi, %rsi
; BMI-NEXT:    notq %rsi
; BMI-NEXT:    andnq %rsi, %rax, %rax
; BMI-NEXT:    retq
  %not_a0  = xor i64 %a0, -1
  %not_a1  = xor i64 %a1, -1
  %not_a2  = xor i64 %a2, -1
  %or0     = or i64 %not_a0, %not_a1
  %or1     = or i64 %a0, %not_a2
  %and     = and i64 %or0, %or1
  ret i64 %and
}

define i32 @not_a_masked_merge0_demorgan(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-LABEL: not_a_masked_merge0_demorgan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orl %edi, %edx
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    negl %eax
; CHECK-NEXT:    orl %esi, %eax
; CHECK-NEXT:    andl %edx, %eax
; CHECK-NEXT:    retq
  %not_a_not = sub i32 0, %a0
  %or0 = or i32 %not_a_not, %a1
  %or1 = or i32 %a0, %a2
  %and = and i32 %or0, %or1
  ret i32 %and
}

; not a masked merge: `not` operand does not match another `and`-operand.
define i32 @not_a_masked_merge1_demorgan(i32 %a0, i32 %a1, i32 %a2, i32 %a3) {
; NOBMI-LABEL: not_a_masked_merge1_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %ecx, %eax
; NOBMI-NEXT:    orl %edx, %edi
; NOBMI-NEXT:    notl %eax
; NOBMI-NEXT:    orl %esi, %eax
; NOBMI-NEXT:    andl %edi, %eax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: not_a_masked_merge1_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    orl %edx, %edi
; BMI-NEXT:    andnl %ecx, %esi, %eax
; BMI-NEXT:    andnl %edi, %eax, %eax
; BMI-NEXT:    retq
  %or1 = or i32 %a0, %a2
  %not = xor i32 %a3, -1
  %or0 = or i32 %not, %a1
  %and = and i32 %or0, %or1
  ret i32 %and
}

; not a masked merge: one of the operands of `and` is not an `or`.
define i32 @not_a_masked_merge2_demorgan(i32 %a0, i32 %a1, i32 %a2) {
; NOBMI-LABEL: not_a_masked_merge2_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %edi, %eax
; NOBMI-NEXT:    andl %edi, %edx
; NOBMI-NEXT:    notl %eax
; NOBMI-NEXT:    orl %esi, %eax
; NOBMI-NEXT:    andl %edx, %eax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: not_a_masked_merge2_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    andl %edi, %edx
; BMI-NEXT:    andnl %edi, %esi, %eax
; BMI-NEXT:    andnl %edx, %eax, %eax
; BMI-NEXT:    retq
  %not_an_or1 = and i32 %a0, %a2
  %not = xor i32 %a0, -1
  %or0 = or i32 %not, %a1
  %and = and i32 %or0, %not_an_or1
  ret i32 %and
}

define i32 @not_a_masked_merge3_demorgan(i32 %a0, i32 %a1, i32 %a2) {
; NOBMI-LABEL: not_a_masked_merge3_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %esi, %eax
; NOBMI-NEXT:    orl %edi, %edx
; NOBMI-NEXT:    xorl %edi, %eax
; NOBMI-NEXT:    notl %eax
; NOBMI-NEXT:    andl %edx, %eax
; NOBMI-NEXT:    retq
;
; BMI-LABEL: not_a_masked_merge3_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    orl %edi, %edx
; BMI-NEXT:    xorl %edi, %esi
; BMI-NEXT:    andnl %edx, %esi, %eax
; BMI-NEXT:    retq
  %or1 = or i32 %a0, %a2
  %not = xor i32 %a0, -1
  %not_an_or0 = xor i32 %not, %a1
  %and = and i32 %not_an_or0, %or1
  ret i32 %and
}

; not a masked merge: `not` operand must not be on same `or`.
define i32 @not_a_masked_merge4_demorgan(i32 %a0, i32 %a1, i32 %a2) {
; CHECK-LABEL: not_a_masked_merge4_demorgan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    orl %edx, %eax
; CHECK-NEXT:    retq
  %or1 = or i32 %a0, %a2
  %not = xor i32 %a1, -1
  %or0 = or i32 %not, %a1
  %and = and i32 %or0, %or1
  ret i32 %and
}

; should not transform when operands have multiple users.
define i32 @masked_merge_no_transform0_demorgan(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; NOBMI-LABEL: masked_merge_no_transform0_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    orl %edi, %edx
; NOBMI-NEXT:    movl %edi, %eax
; NOBMI-NEXT:    notl %eax
; NOBMI-NEXT:    orl %esi, %eax
; NOBMI-NEXT:    andl %edx, %eax
; NOBMI-NEXT:    movl %edx, (%rcx)
; NOBMI-NEXT:    retq
;
; BMI-LABEL: masked_merge_no_transform0_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    orl %edi, %edx
; BMI-NEXT:    andnl %edi, %esi, %eax
; BMI-NEXT:    andnl %edx, %eax, %eax
; BMI-NEXT:    movl %edx, (%rcx)
; BMI-NEXT:    retq
  %not = xor i32 %a0, -1
  %or0 = or i32 %not, %a1
  %or1 = or i32 %a0, %a2
  %and = and i32 %or0, %or1
  store i32 %or1, ptr %p1
  ret i32 %and
}

; should not transform when operands have multiple users.
define i32 @masked_merge_no_transform1_demorgan(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; NOBMI-LABEL: masked_merge_no_transform1_demorgan:
; NOBMI:       # %bb.0:
; NOBMI-NEXT:    movl %edx, %eax
; NOBMI-NEXT:    orl %edi, %eax
; NOBMI-NEXT:    notl %edi
; NOBMI-NEXT:    orl %edi, %esi
; NOBMI-NEXT:    andl %esi, %eax
; NOBMI-NEXT:    movl %edi, (%rcx)
; NOBMI-NEXT:    retq
;
; BMI-LABEL: masked_merge_no_transform1_demorgan:
; BMI:       # %bb.0:
; BMI-NEXT:    orl %edi, %edx
; BMI-NEXT:    andnl %edi, %esi, %eax
; BMI-NEXT:    notl %edi
; BMI-NEXT:    andnl %edx, %eax, %eax
; BMI-NEXT:    movl %edi, (%rcx)
; BMI-NEXT:    retq
  %not = xor i32 %a0, -1
  %or0 = or i32 %not, %a1
  %or1 = or i32 %a0, %a2
  %and = and i32 %or0, %or1
  store i32 %not, ptr %p1
  ret i32 %and
}

; should not transform when operands have multiple users.
define i32 @masked_merge_no_transform2_demorgan(i32 %a0, i32 %a1, i32 %a2, ptr %p1) {
; CHECK-LABEL: masked_merge_no_transform2_demorgan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edx, %eax
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    notl %edi
; CHECK-NEXT:    orl %esi, %edi
; CHECK-NEXT:    andl %edi, %eax
; CHECK-NEXT:    movl %edi, (%rcx)
; CHECK-NEXT:    retq
  %not = xor i32 %a0, -1
  %or0 = or i32 %not, %a1
  %or1 = or i32 %a0, %a2
  %and = and i32 %or0, %or1
  store i32 %or0, ptr %p1
  ret i32 %and
}
